% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{ggml_gallocr_alloc_graph}
\alias{ggml_gallocr_alloc_graph}
\title{Allocate Memory for Graph}
\usage{
ggml_gallocr_alloc_graph(galloc, graph)
}
\arguments{
\item{galloc}{Graph allocator object}

\item{graph}{Graph object}
}
\value{
TRUE on success, FALSE on failure
}
\description{
Allocates memory for all tensors in the computation graph.
This must be called before computing the graph.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
galloc <- ggml_gallocr_new()

# Create graph
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 10)
b <- ggml_relu(ctx, a)
graph <- ggml_build_forward_expand(ctx, b)

# Allocate and compute
ggml_gallocr_alloc_graph(galloc, graph)
ggml_graph_compute(ctx, graph)

ggml_gallocr_free(galloc)
ggml_free(ctx)
}
}
