% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggml.R, R/graph.R
\name{ggml_build_forward_expand}
\alias{ggml_build_forward_expand}
\title{Build forward expand}
\usage{
ggml_build_forward_expand(ctx, tensor)

ggml_build_forward_expand(ctx, tensor)
}
\arguments{
\item{ctx}{GGML context}

\item{tensor}{Output tensor of the computation}
}
\value{
Graph pointer

Graph object (external pointer)
}
\description{
Builds a computation graph from the output tensor, expanding backwards
to include all dependencies.

Creates a computation graph by expanding backwards from the output tensor
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
b <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(1, 2, 3, 4, 5))
ggml_set_f32(b, c(5, 4, 3, 2, 1))
result <- ggml_add(ctx, a, b)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
ggml_free(ctx)
}
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 10)
b <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 10)
ggml_set_f32(a, 1:10)
ggml_set_f32(b, 11:20)
c <- ggml_add(ctx, a, b)
graph <- ggml_build_forward_expand(ctx, c)
ggml_graph_compute(ctx, graph)
result <- ggml_get_f32(c)
ggml_free(ctx)
}
}
