% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensors.R
\name{ggml_new_tensor_3d}
\alias{ggml_new_tensor_3d}
\title{Create 3D Tensor}
\usage{
ggml_new_tensor_3d(ctx, type = GGML_TYPE_F32, ne0, ne1, ne2)
}
\arguments{
\item{ctx}{GGML context}

\item{type}{Data type (default GGML_TYPE_F32)}

\item{ne0}{Size of dimension 0}

\item{ne1}{Size of dimension 1}

\item{ne2}{Size of dimension 2}
}
\value{
Tensor pointer
}
\description{
Create 3D Tensor
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
t <- ggml_new_tensor_3d(ctx, GGML_TYPE_F32, 10, 20, 30)
ggml_nelements(t)
ggml_free(ctx)
}
}
