% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_diag_mask_inf}
\alias{ggml_diag_mask_inf}
\title{Diagonal Mask with -Inf (Graph)}
\usage{
ggml_diag_mask_inf(ctx, a, n_past)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor (typically attention scores)}

\item{n_past}{Number of past tokens (shifts the diagonal). Use 0 for
standard causal masking where position i can only attend to positions <= i.}
}
\value{
Tensor with same shape as input, elements above diagonal set to -Inf
}
\description{
Creates a graph node that sets elements above the diagonal to -Inf.
This is used for causal (autoregressive) attention masking.
}
\details{
In causal attention, we want each position to only attend to itself and
previous positions. Setting future positions to -Inf ensures that after
softmax, they contribute 0 attention weight.

The n_past parameter allows for KV-cache scenarios where the diagonal
needs to be shifted to account for previously processed tokens.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
# Create attention scores matrix
scores <- ggml_new_tensor_2d(ctx, GGML_TYPE_F32, 4, 4)
ggml_set_f32(scores, rep(1, 16))
# Apply causal mask
masked <- ggml_diag_mask_inf(ctx, scores, 0)
graph <- ggml_build_forward_expand(ctx, masked)
ggml_graph_compute(ctx, graph)
ggml_free(ctx)
}
}
