% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPieDonut.R
\name{ggPieDonut}
\alias{ggPieDonut}
\title{Draw a Pie and Donut plot}
\usage{
ggPieDonut(
  data,
  mapping,
  addPieLabel = TRUE,
  addDonutLabel = TRUE,
  showRatioDonut = TRUE,
  showRatioPie = TRUE,
  showRatioPieAbove10 = TRUE,
  title = "",
  labelposition = 1,
  polar = TRUE,
  use.label = TRUE,
  use.labels = TRUE,
  interactive = FALSE
)
}
\arguments{
\item{data}{A data.frame}

\item{mapping}{Set of aesthetic mappings created by aes or aes_.}

\item{addPieLabel}{A logical value. If TRUE, labels are added to the Pies}

\item{addDonutLabel}{A logical value. If TRUE, labels are added to the Donuts}

\item{showRatioDonut}{A logical value. If TRUE, Ratios are added to the DonutLabels}

\item{showRatioPie}{A logical value. If TRUE, Ratios are added to the PieLabels}

\item{showRatioPieAbove10}{A logical value. If TRUE, labels are added to the Pies with ratio above 10.}

\item{title}{Plot title}

\item{labelposition}{A number indicating the label position}

\item{polar}{A logical value. If TRUE, coord_polar() function will be added}

\item{use.label}{Logical. Whether or not use column label in case of labelled data}

\item{use.labels}{Logical. Whether or not use value labels in case of labelled data}

\item{interactive}{A logical value. If TRUE, an interactive plot will be returned}
}
\value{
An interactive Pie and Donut plot
}
\description{
Draw a Pie and Donut plot
}
\examples{
require(ggplot2)
require(ggiraph)
require(plyr)
require(moonBook)
ggPieDonut(acs,aes(pies=Dx,donuts=smoking))
ggPieDonut(acs,aes(pies=smoking))
ggPieDonut(browsers,aes(pies=browser,donuts=version,count=share))
ggPieDonut(browsers,aes(x=c(browser,version),y=share),interactive=TRUE)
}
