% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-bivariate.R
\docType{data}
\name{ScaleBivariate}
\alias{ScaleBivariate}
\alias{scale_fill_bivariate}
\alias{scale_color_bivariate}
\alias{scale_colour_bivariate}
\title{Bivariate color scales}
\format{
An object of class \code{ScaleBivariate} (inherits from \code{ScaleDiscrete}, \code{Scale}, \code{ggproto}, \code{gg}) of length 5.
}
\usage{
ScaleBivariate

scale_fill_bivariate(
  name1 = NULL,
  name2 = NULL,
  colors = c("gold", "red4"),
  n_breaks = 4,
  breaks = c("quantile", "equal"),
  flip = c("none", "vertical", "horizontal", "both"),
  guide_size = 1.5,
  na.value = NA,
  na.translate = TRUE,
  aesthetics = "fill",
  ...
)

scale_color_bivariate(
  name1 = NULL,
  name2 = NULL,
  colors = c("gold", "red4"),
  n_breaks = 4,
  breaks = c("quantile", "equal"),
  flip = c("none", "vertical", "horizontal", "both"),
  guide_size = 1.5,
  na.value = NA,
  na.translate = TRUE,
  aesthetics = "colour",
  ...
)

scale_colour_bivariate(
  name1 = NULL,
  name2 = NULL,
  colors = c("gold", "red4"),
  n_breaks = 4,
  breaks = c("quantile", "equal"),
  flip = c("none", "vertical", "horizontal", "both"),
  guide_size = 1.5,
  na.value = NA,
  na.translate = TRUE,
  aesthetics = "colour",
  ...
)
}
\arguments{
\item{name1, name2}{Optional names for \code{v1} and \code{v2}. Used as axis titles in
the legend. If \code{NULL}, the default, the names are taken from the mapping.}

\item{colors}{A character vector of length two specifying the colors for the
bivariate palette.}

\item{n_breaks}{An integer guiding the number of bins for each variable.}

\item{breaks}{Method used to bin the variables: \code{"quantile"} (the default)
or \code{"equal"}.}

\item{flip}{Method used to flip the legend: \code{"none"} (the default),
\code{"vertical"}, \code{"horizontal"}, or \code{"both"}.}

\item{guide_size}{A numeric value controlling the size of the legend graphic,
in centimeters.}

\item{na.value}{If \code{na.translate = TRUE}, what aesthetic value should the
missing values be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}

\item{na.translate}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}

\item{aesthetics}{The names of the aesthetics that this scale works with.}

\item{...}{Other arguments passed to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}
}
\value{
A \code{ScaleBivariate} ggproto object.
}
\description{
\verb{scale_*_bivariate} creates a bivariate palette by mixing two colour ramps,
then implements the mapping by binning the variables \code{v1}, \code{v2} and assigning
each bin combination to a colour.
}
\examples{
# Create a bivariate fill scale
sc <- scale_fill_bivariate()
class(sc)
sc$palette(9)

# Basic bivariate map
p <- ggplot(nc) + geom_sf(aes(fill = duo(value, sd)))

# Customize axis labels
p + scale_fill_bivariate(name1 = 'var1', name2 = 'var2')

}
\seealso{
\link[ggplot2:Scale]{ggplot2::Scale} for the base \code{ggproto} class that all scale objects
inherit from.
}
\keyword{datasets}
