% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_rectrug.R
\name{geom_rectmargin}
\alias{geom_rectmargin}
\alias{geom_tilemargin}
\title{Rectangular rugs in the margins}
\usage{
geom_rectmargin(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  outside = FALSE,
  sides = "bl",
  length = unit(0.03, "npc"),
  linejoin = "mitre",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_tilemargin(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  outside = FALSE,
  sides = "bl",
  length = unit(0.03, "npc"),
  linejoin = "mitre",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{outside}{\code{logical} of length 1 that controls whether to move the
rectangles outside of the plot area. For the best results, it is probably
best to set \code{coord_cartesian(clip = "off")} and avoid overlap with the
default axes by changing the sides argument to \code{"tr"}.}

\item{sides}{A \code{string} of length 1 that controls which sides of the
plot the rug-rectangles appear on. A string containing any letters in
\code{"trbl"} will set it to top, right, bottom and left respectively.}

\item{length}{A \code{\link[grid:unit]{grid::unit()}} object that sets the width and
height of the rectangles in the x- and y-directions respectively. Note that
scale expansion can affect the look of this.}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A \emph{Layer} ggproto object.
}
\description{
Like rug plots display data points of a 2D plot as lines in the
margins, this function plots rectangles in the margins. Rectangular rugs
are convenient for displaying one-dimensional, ranged annotations for
two-dimensional plots.
}
\details{
By default, scales are expanded 5\\% on either side of the plot,
whereas the rug rectangles will occupy 3\\% of the total plot size by
default. The \code{geom_rectmargin()} and \code{geom_tilemargin()} versions do the
same thing, but are parametrised differently; see
\code{\link[ggplot2:geom_tile]{geom_rect()}}.

These functions do not have hard-coded required aesthetics, since the x and
y directions can be omitted by not choosing a side in the corresponding
direction, i.e. y-direction variables are omitted when plotting the rug only
on the top and/or bottom. This can result in errors when the aesthetics are
not specified appropriately, so some caution is advised.
}
\section{Aesthetics}{

\code{geom_rectmargin()} requires either one of the following
sets of aesthetics, but also can use both:

\itemize{
\item \strong{xmin}
\item \strong{xmax}
}

and/or:

\itemize{
\item \strong{ymin}
\item \strong{ymax}
}

\code{geom_tilemargin()} requires either one of the following
sets of aesthetics, but can also use both:

\itemize{
\item \strong{x}
\item \strong{width}
}

and/or:

\itemize{
\item \strong{y}
\item \strong{height}
}

Furthermore, \code{geom_rectmargin()} and \code{geom_tilemargin()} also
understand these shared aesthetics:

\itemize{
\item alpha
\item colour
\item fill
\item group
\item linetype
\item size
}
}

\examples{
# geom_rectmargin() is parameterised by the four corners
df <- data.frame(
  xmin = c(1, 5),
  xmax = c(2, 7),
  ymin = c(1, 2),
  ymax = c(2, 4),
  fill = c("A", "B")
)


ggplot(df, aes(xmin = xmin, xmax = xmax,
               ymin = ymin, ymax = ymax,
               fill = fill)) +
  geom_rect() +
  geom_rectmargin()

# geom_tilemargin() is parameterised by center and size
df <- data.frame(
  x = c(1, 4),
  y = c(1, 2),
  width = c(2, 1),
  height = c(1, 2),
  fill = c("A", "B")
)

ggplot(df, aes(x, y,
               width = width, height = height,
               fill = fill)) +
  geom_tile() +
  geom_tilemargin()
}
\seealso{
\code{\link[ggplot2:geom_rug]{ggplot2::geom_rug()}}, \code{\link[ggplot2:geom_tile]{geom_rect()}},
\code{\link[ggplot2:geom_tile]{ggplot2::geom_tile()}}
}
