% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale.r
\name{scale_radius_continuous}
\alias{scale_radius_continuous}
\alias{scale_radius_binned}
\alias{scale_radius_discrete}
\title{Vector field radius scales}
\usage{
scale_radius_continuous(..., range = c(1e-08, 1))

scale_radius_binned(..., range = c(1e-08, 1))

scale_radius_discrete(..., range = c(1e-08, 1))
}
\arguments{
\item{...}{Arguments passed on to underpinning \verb{ggplot2::scale_*} functions.}

\item{range}{Relative output range of radii. Must lie between 0 and 1.}
}
\value{
An object of class \link[ggplot2:ggplot2-ggproto]{Scale}.
}
\description{
Scales to set up the visualisation of the \code{radius} aesthetic. These
scales are also automatically used in plot guides.
Note that \code{scale_radius_identity()} does \emph{not} exist as it would be impossible to
relate such a scale to the \code{max_radius} parameter. For more details see
\code{vignette("radius_aes")}.
}
\examples{
if (requireNamespace("ggplot2")) {
  library(ggplot2)
  data(seawatervelocity)
  
  g_num <-
    ggplot() +
    geom_fields(data = seawatervelocity,
                aes(radius = as.numeric(v), angle = as.numeric(angle)))
  g_discr <-
    ggplot() +
    geom_fields(data = seawatervelocity,
                aes(radius = cut(as.numeric(v), 4), angle = as.numeric(angle)))
                
  g_num + scale_radius_continuous()
  g_num + scale_radius_binned()
  g_discr + scale_radius_discrete()
}
}
\author{
Pepijn de Vries
}
