% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{print_prior}
\alias{print_prior}
\title{Print a Joint Prior Distribution}
\usage{
print_prior(p_prior_r)
}
\arguments{
\item{p_prior_r}{A list specifying the prior distributions, typically
generated by \code{\link{BuildPrior}}.}
}
\value{
A character vector summarising the prior specification.
}
\description{
Displays the structure of a prior distribution specification passed to
C++ functions. This function is primarily intended for debugging and
inspection of the internal representation.
}
\details{
This function is mainly used for debugging purposes. It provides a
readable summary of the prior distribution list as received by C++ code.
The input \code{p_prior_r} should be the output of \code{\link{BuildPrior}}.
}
\examples{
p0 <- c(A = 0.15, B = 0.45, mean_v = 2.25, sd_v = 0.15, t0 = 0.2)
p1 <- rep(0.1, 5)
p_prior <- BuildPrior(
    p0 = p0,
    p1 = p1,
    lower = rep(NA, 5),
    upper = rep(NA, 5),
    dist = rep("tnorm", 5),
    log_p = rep(TRUE, 5)
)
print_prior(p_prior)

}
