% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_waterfall.R
\name{ggplot_waterfall}
\alias{ggplot_waterfall}
\title{Plots a water fall plot}
\usage{
ggplot_waterfall(dtData, cXColumnName, cYColumnName, nArrowSize = 0.25,
  vcGroupingColumnNames = NULL)
}
\arguments{
\item{dtData}{Data set which may include other columns apart from the
columns mapped to x and y .}

\item{cXColumnName}{Column name of the x mapping.}

\item{cYColumnName}{Column name of the y mapping.}

\item{nArrowSize}{the size of the arrow head on the plot in cm}

\item{vcGroupingColumnNames}{The set of columns which together define the group
for the chart to operate between. If you plan to facet your plot,
you should specify the same column names to this argument.}
}
\value{
Returns a gpplot friendly object which means the user can use
ggplot scales to modify the look, add more geoms, etc.
}
\description{
A waterfall plot highlights the change in the time series rather than the
value of the time series itself.
}
\section{Cosmetic Tips}{
 The minimalist look can be achieved by appending the
following chunk of code to the output object:
\code{
+
xlab(NULL) +
ylab(NULL) +
scale_fill_continuous(low = 'green', high = 'red') +
theme(
   axis.text = element_blank(),
   axis.ticks = element_blank(),
   legend.position = 'none',
   strip.background = element_blank(),
   # strip.text = element_blank(), # useful if only one year of data
   plot.background = element_blank(),
   panel.background = element_blank(),
   panel.border = element_blank(),
   panel.grid = element_blank(),
   panel.border = element_blank()
)
}
}

\section{Also See}{
 \code{\link{stat_waterfall}}, a
flexible but less polished alternative.
}

\examples{
{
library(ggplot2)
set.seed(1)
dfData = data.frame(x = 1:100, y = cumsum(rnorm(100)))
ggplot_waterfall(
   dtData = dfData,
   'x',
   'y'
)}
}
