% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{scale}
\alias{scale}
\alias{scale.default}
\alias{scale.symbolic_tbl}
\alias{scale.symbolic_interval}
\title{scale for symbolic data table}
\usage{
scale(x, ...)

\method{scale}{default}(x, center = TRUE, scale = TRUE, ...)

\method{scale}{symbolic_tbl}(x, ...)

\method{scale}{symbolic_interval}(x, ...)
}
\arguments{
\item{x}{A ggInterval object. It can also be either RSDA object or
classical data frame, which will be automatically convert to ggInterval
data.}

\item{...}{Used by other R function.}

\item{center}{same as base::scale, either a logical value or numeric-alike vector of length equal to the number of columns of x, where nmeric-alike means that as.numeric(.) will be applied successfully if is.numeric(.) is not true.}

\item{scale}{same as base::scale, either a logical value or a numeric-alike vector of length equal to the number of columns of x.}
}
\value{
Return a scale ggInterval object.
}
\description{
scale for symbolic data table
}
\examples{

#For all interval-valued
scale(facedata)

#For both interval-valued and modal multi-valued
scale(mtcars.i)

}
\keyword{Symbolic}
\keyword{scale}
