% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxcox_transform.R
\name{boxcox_transform}
\alias{boxcox_transform}
\title{Box-Cox Transformations}
\usage{
boxcox_transform(
  model,
  lambda = seq(-2, 2, 1/10),
  showlambda = TRUE,
  lambdaSF = 3,
  showplot = TRUE
)
}
\arguments{
\item{model}{Model used for Box-Cox transformation}

\item{lambda}{sequence of lambda values to consider for plot. Default is seq(-2,2,1/10)}

\item{showlambda}{Default is TRUE, show lambda values in plot}

\item{lambdaSF}{Digits to round lambda values shown in plot}

\item{showplot}{Default is TRUE, if false plot will not be shown and a tibble is returned with a 95\% confidence interval for lambda and lambda value which maximizes log-likelihood}
}
\value{
Box-Cox transformation plot with 95\% confidence interval of lambda values to consider
}
\description{
Box-Cox Transformations
}
\examples{
model <- lm(s2 ~ (A+B+C+D),data = adapted_epitaxial)
boxcox_transform(model,lambda = seq(-5,5,0.2))
boxcox_transform(model,lambda = seq(-5,5,0.2),showplot=FALSE)
}
