% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gerbil.R
\name{plot.gerbil}
\alias{plot.gerbil}
\title{Plotting for gerbil objects}
\usage{
\method{plot}{gerbil}(
  x,
  y = NULL,
  type = "Univariate",
  imp = 1,
  col = NULL,
  lty = NULL,
  lwd = NULL,
  pch = NULL,
  log = NULL,
  legend = NULL,
  legend.loc = "topright",
  mfrow = c(3, 2),
  trace.type = "Mean",
  file = NULL,
  sep = FALSE,
  height = NULL,
  width = NULL,
  partial = "imputed",
  ...
)
}
\arguments{
\item{x}{A \code{gerbil} object containing the imputed data.}

\item{y}{A vector listing the column names of the imputed data for which plots should be created. See details. By default, \code{y} contains all columns of the data that required imputation.}

\item{type}{A scalar used to specify the type of plots that will be created.  Options include univariate (marginal) plots (\code{type = 1}), bivariate plots (\code{type = 2}), and trace plots (\code{type = 3}). See details. Defaults to \code{type = 1}.}

\item{imp}{A scalar or vector indicating which of the multiply imputed datasets should be used for plotting.  Defaults to \code{imp = 1}. Setting \code{imp = TRUE} will include all imputed datasets.}

\item{col}{The color used for plotting -- should be a vector of length equal to \code{imp + 1}. The first element references plotting of observed data, and remaining elements reference plotting of imputed data.}

\item{lty}{The line type used for plotting imputed values with trace lines or density plots -- should be a vector of length equal to \code{imp + 1}. The first element references plotting of observed data, and remaining elements reference plotting of imputed data.}

\item{lwd}{The line width used for density and trace line plotting -- should be a vector of length equal to \code{imp + 1}. The first element references plotting of observed data, and remaining elements reference plotting of imputed data.}

\item{pch}{A length-2 vector that indicates the plotting symbol to be used for imputed and observed values in scatter and lattice plots.}

\item{log}{A character vector that includes names of variables of which a log transformation is to be taken prior to plotting.}

\item{legend}{A character or expression vector to appear in the legend. If \code{FALSE} or \code{'n'}, no legend is created. Defaults to \code{c("Observed", "Imputed", ...)}.}

\item{legend.loc}{The location of the legend in the plots.}

\item{mfrow}{The layout of plots across a single page when there are to be multiple plots per page (as is the case when \code{file} is non-\code{NULL} and \code{sep = FALSE}).}

\item{trace.type}{The type of trace plot to be created (only valid when \code{type = 3}).  See details.  Defaults to \code{trace.type = 1}.}

\item{file}{A character string giving the name of file that will be created in the home directory containing plots. The name should have a \code{.pdf} or \code{.png} extension. If \code{NULL} (the default), no file is created.}

\item{sep}{If \code{sep = TRUE}, separate plots will be generated for each outcome.  Applicable only if plots are saved to file (\code{plot.file} is \code{non-NULL}). To change display of plots produced as output, use \code{\link[graphics]{par}}.}

\item{height}{The height of the graphics region (in inches) when a pdf is created.}

\item{width}{The width of the graphics region (in inches) when a pdf is created.}

\item{partial}{Indicates how partially imputed pairs are handled in bivariate plotting. If \code{'imputed'}, cases with at least one missing variable in a pair are considered imputed. Otherwise (\code{partial = 'observed'}), only cases with both variables in the pair missing are considered imputed.}

\item{...}{Arguments to be passed to methods, such as \code{plot}.}
}
\value{
No returned value, but instead plots are generated in the workspace or written to a specified directory.
}
\description{
Using a \code{gerbil} object as an input, this function gives
diagnostic plots for selected variables
}
\details{
Three types of plots may be produced:
1) Univariate (produced by setting \code{type = 1}): Compares the marginal distribution of observed and imputed values of a given variable.  Density plots are produced for continuous variables, and bar plots are given for binary, categorical, and ordinal variables.  For semi-continuous variables, two plots are constructed: a) a bar plot for the binary portion of the variable and 2) a density plot for the continuous portion.
2) Bivariate (produced by setting \code{type = 2}): Compares the bivariate distributions of observed and imputed values of two variables.  Scatter plots are produced if both variables are continuous or semi-continuous, box plots are produced if one variable is continuous or semi-continuous and the other is not, and a lattice plot is produced if neither variable is continuous or semi-continuous. For bivariate plots, imputed observations are those that have one or more of the values of the pair missing within the original dataset.
3) Trace lines (produced by setting \code{type = 3}): Plots a pre-specified parameter across iterations of MCMC in order to examine convergence for a given variable.  Parameters that may be plotted include means (\code{trace.type = 1}) and variances (\code{trace.type = 2}).

Multiple plots may be created, as determined by the variable names listed in the parameter \code{y}. For univariate and trace plots, one plot is created for
each variable listed in \code{y}. For bivariate plotting, one plot is created for each combination of two elements within the vector \code{y} (as such, \code{y} must have a length of at least two in this case).
For trace plotting, elements of \code{y} should correspond to column names in the dataset that has been expanded to include binary indicators for categorical and semi-continuous variables.
If multiple plots are to be created, it is recommended to specify a file for output using the parameter \code{file}, in which case separate
files will be created for each plot (if \code{sep = TRUE}) or all plots will be written to the same file (if \code{sep = FALSE}).

The only required input is a parameter \code{x} which is a \code{gerbil} object.
}
\examples{
\donttest{
#Load the India Human Development Survey-II dataset
data(ihd_mcar) 

# Create a gerbil object

imps.gerbil <- gerbil(ihd_mcar, m = 1, ords = "education_level", semi = "farm_labour_days", 
       bincat = "job_field")

# Univariate plotting of all variables to a file
plot(imps.gerbil, type = 1, file = file.path(tempdir(), "gerbil_univariate.pdf"))

# Bivariate plotting of all variables to a file
plot(imps.gerbil, type = 2, file = file.path(tempdir(), "gerbil_bivariate.pdf"))

# Trace plotting of all variables to a file
plot(imps.gerbil, type = 3, file = file.path(tempdir(), "gerbil_ts.pdf"))

# Univariate plotting of one variable (not to a file)
plot(imps.gerbil, type = 1, y = "job_field")

# Bivariate plotting of one pair of variables (not to a file)
plot(imps.gerbil, type = 2, y = c("job_field", "income"))

# Bivariate plotting of one pair of variables (not to a file) with income logged
plot(imps.gerbil, type = 2, y = c("job_field", "income"), log = "income")
}

}
