% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw_gwalpha.R
\name{bw_gwalpha}
\alias{bw_gwalpha}
\title{Bandwidth Selection for Geographically Weighted Cronbach's Alpha}
\usage{
bw_gwalpha(crit, minmax, adaptive = TRUE, tol = 3, max_iter = 100, ...)
}
\arguments{
\item{crit}{predetermined criterion for reliability level}

\item{minmax}{a numeric vector of length 2 with the lower and upper bounds
of the bandwidth search interval}

\item{adaptive}{logical; if \code{TRUE} (default), the bandwidth \code{bw}
corresponds to the number of nearest neighbours; if \code{FALSE},
\code{bw} is a fixed distance}

\item{tol}{convergence tolerance}

\item{max_iter}{maximum number of iterations}

\item{...}{additional arguments passed on to \code{\link[=gwalpha]{gwalpha()}}.}
}
\value{
a adaptive or fixed distance bandwidth
}
\description{
A function for automatic bandwidth selection to calibrate GWalpha.
}
\seealso{
\code{\link[=gwalpha]{gwalpha()}}
}
