% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/azimuthaleq.R
\name{azeq_fwd}
\alias{azeq_fwd}
\alias{azeq_rev}
\title{Azimuthal Equidistant projection}
\usage{
azeq_fwd(x, lon0, lat0)

azeq_rev(x, y, lon0, lat0)
}
\arguments{
\item{x}{For forward conversion: a two-column matrix or data frame of
coordinates (longitude, latitude) in decimal degrees.
For reverse conversion: numeric vector of x coordinates in meters.}

\item{lon0}{Longitude of projection center in decimal degrees. Can be a
vector to specify different centers for each point.}

\item{lat0}{Latitude of projection center in decimal degrees. Can be a
vector to specify different centers for each point.}

\item{y}{Numeric vector of y coordinates in meters (for reverse conversion).}
}
\value{
Data frame with columns:
\itemize{
\item For forward conversion:
\itemize{
\item \code{x}: Easting in meters from center
\item \code{y}: Northing in meters from center
\item \code{azi}: Azimuth from center to point (degrees)
\item \code{scale}: Scale factor at the point
\item \code{lon}, \code{lat}: Input coordinates (echoed)
\item \code{lon0}, \code{lat0}: Center coordinates (echoed)
}
\item For reverse conversion:
\itemize{
\item \code{lon}: Longitude in decimal degrees
\item \code{lat}: Latitude in decimal degrees
\item \code{azi}: Azimuth from center to point (degrees)
\item \code{scale}: Scale factor at the point
\item \code{x}, \code{y}: Input coordinates (echoed)
\item \code{lon0}, \code{lat0}: Center coordinates (echoed)
}
}
}
\description{
Convert geographic coordinates to/from Azimuthal Equidistant projection
centered on a specified point. This projection preserves distances from
the center point.
}
\details{
The Azimuthal Equidistant projection shows all points at their true distance
and direction from the center point. It is commonly used for:
\itemize{
\item Radio/telecommunications range maps
\item Seismic wave propagation studies
\item Air route distance calculations
\item UN emblem (centered on North Pole)
}

The projection is neither conformal nor equal-area, but distances from the
center are preserved exactly.

All parameters (\code{x}, \code{lon0}, \code{lat0}) are vectorized and recycled to a
common length, allowing different projection centers for each point.
}
\examples{
# Project cities relative to Sydney
cities <- cbind(
  lon = c(-74, 139.7, 0),
  lat = c(40.7, 35.7, 51.5)
)
azeq_fwd(cities, lon0 = 151.2, lat0 = -33.9)

# Distance from Sydney = sqrt(x^2 + y^2)
result <- azeq_fwd(cities, lon0 = 151.2, lat0 = -33.9)
sqrt(result$x^2 + result$y^2) / 1000  # km

# Different center for each point (e.g., distance from home city)
homes <- cbind(lon = c(151.2, 139.7, -0.1), lat = c(-33.9, 35.7, 51.5))
destinations <- cbind(lon = c(-74, -74, -74), lat = c(40.7, 40.7, 40.7))
azeq_fwd(destinations, lon0 = homes[,1], lat0 = homes[,2])
}
