% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bearingarea.R
\name{sbi}
\alias{sbi}
\title{Surface Bearing Index}
\usage{
sbi(x)
}
\arguments{
\item{x}{A raster or matrix.}
}
\value{
A numeric value representing the surface bearing index.
}
\description{
Determines the surface bearing index (Sbi), calculated as the ratio
of root mean square roughness (Sq) to height at 5\%
of bearing area (z05).
}
\examples{
# import raster image
data(normforest)
normforest <- terra::unwrap(normforest)

# determine the surface bearing index
Sbi <- sbi(normforest)
}
