% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocs_vector.R
\name{geocs_vector}
\alias{geocs_vector}
\title{geocomplexity for spatial vector data based on geographical similarity}
\usage{
geocs_vector(
  sfj,
  wt = NULL,
  method = "spvar",
  similarity = 1,
  normalize = TRUE,
  returnsf = TRUE
)
}
\arguments{
\item{sfj}{An \code{sf} object or spatial vector object that can be converted to \code{sf} by \code{sf::st_as_sf()}.}

\item{wt}{(optional) Spatial weight matrix. Must be a \code{matrix} class. If \code{wt} is not
provided, \code{geocomplexity} will use a first-order inverse distance weight matrix via
\code{sdsfun::inverse_distance_swm()} function.}

\item{method}{(optional) When \code{method} is \code{spvar}, variation of the similarity vector is
represented using spatial variance, otherwise shannon information entropy is used. Default
is \code{spvar}.}

\item{similarity}{(optional) When \code{similarity} is \code{1}, the similarity is calculated using
geographical configuration similarity, otherwise the cosine similarity is calculated.
Default is \code{1}.}

\item{normalize}{(optional) Whether to further normalizes the calculated geocomplexity.
Default is \code{TRUE}.}

\item{returnsf}{(optional) When \code{returnsf} is \code{TRUE}, return an sf object, otherwise a tibble.
Default is \code{TRUE}.}
}
\value{
A \code{tibble} (\code{returnsf} is \code{FALSE}) or an \code{sf} object (\code{returnsf} is \code{TRUE})
}
\description{
This function calculates geocomplexity for in spatial vector data based on geographical similarity.
}
\examples{
econineq = sf::read_sf(system.file('extdata/econineq.gpkg',package = 'geocomplexity'))
gc = geocs_vector(dplyr::select(econineq,-Gini))
gc

library(ggplot2)
library(viridis)
ggplot(gc) +
   geom_sf(aes(fill = GC)) +
   scale_fill_viridis(option = "mako", direction = -1) +
   theme_bw()

}
