% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/georefar.R
\name{get_ubicacion}
\alias{get_ubicacion}
\title{Obtener Ubicacion}
\usage{
get_ubicacion(lat, lon, aplanar = TRUE, campos = NULL)
}
\arguments{
\item{lat}{numeric Latitud del punto, en forma de número real con grados decimales.}

\item{lon}{numeric Longitud del punto, en forma de número real con grados decimales.}

\item{aplanar}{boolean Cuando está presente, muestra el resultado JSON con una estructura plana.}

\item{campos}{text Campos a incluir en la respuesta separados por comas, sin espacios. Algunos campos siempre serán incluidos, incluso si no se agregaron en la lista. Para incluir campos de sub-entidades, separar los nombres con un punto, por ejemplo: provincia.id.}
}
\value{
Un Data Frame con las unidades territoriales que contienen el punto.
}
\description{
Permite realizar una georreferenciación inversa para un punto, informando cuales unidades territoriales lo contienen.
Realiza la consulta GET al endpoint /ubicacion de georef-ar-api.
Si existe GEOREFAR_TOKEN en el Renviron lo usará para hacer la consulta.
}
\examples{
\dontrun{
get_ubicacion()
}
}
\references{
\href{https://datosgobar.github.io/georef-ar-api/open-api/#/Recursos/get_ubicacion}{georef-ar-api/ubicacion}
}
