% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_files_plink.R
\name{delete_files_plink}
\alias{delete_files_plink}
\title{Delete all Plink binary files}
\usage{
delete_files_plink(file)
}
\arguments{
\item{file}{The shared file path (excluding extensions: \code{bed}, \code{bim}, \code{fam}).}
}
\value{
Nothing
}
\description{
This function deletes each of the Plink binary files (\code{bed}, \code{bim}, \code{fam} extensions) given the shared base file path, warning if any of the files did not exist or if any were not successfully deleted.
}
\examples{
# if you want to delete "data.bed", "data.bim" and "data.fam", run like this:
# delete_files_plink("data")

# The following example is more awkward
# because (only for these examples) the package must create *temporary* files to actually delete

# create dummy BED/BIM/FAM files
file <- tempfile('delete-me-test') # no extension
# add each extension and create empty files
file.create( paste0(file, '.bed') )
file.create( paste0(file, '.bim') )
file.create( paste0(file, '.fam') )

# delete the BED/BIM/FAM files we just created
delete_files_plink(file)

}
