library(testthat)

test_that("rss.AUC.test works as expected",{
  set.seed(123)
  rss.data1<-rss.simulation(H=3,nsamp=c(6,6,6),dist="normal", rho=0.8,delta=0)
  rss.data2<-rss.simulation(H=3,nsamp=c(8,8,8),dist="normal", rho=0.8,delta=0.2)
  result=rss.AUC.test(data1=rss.data1, data2=rss.data2, alpha=0.05, delta0=0.5)
  
  expect_equal(result$RSS_AUC, 0.4930556, tolerance = 1e-3)
  expect_equal(result$p.value, 0.9227096, tolerance = 1e-3)
  expect_equal(result$CI, c(0.3571189, 0.6331168), tolerance = 1e-3)
  expect_equal(result$`-2*log.LR`, 0.009413097, tolerance = 1e-3)
})

test_that("rss.AUC.test handles wrong input with error",{
  rss.data1<-rss.simulation(H=3,nsamp=c(6,6,6),dist="normal", rho=0.8,delta=0)
  rss.data2<-rss.simulation(H=3,nsamp=c(7,8,9),dist="normal", rho=0.8,delta=0.2)
  
  expect_error(rss.AUC.test(data1=rss.data1, data2=rss.data2, alpha=5, delta0=0.5),
               "alpha is out of bound.")
  expect_error(rss.AUC.test(data1=rss.data1[,1], data2=rss.data2, alpha=0.05, delta0=0.5),
               "The input data must contain 'rank' and 'y' variables.")
  expect_error(rss.AUC.test(data1=rss.data1[,2], data2=rss.data2, alpha=0.05, delta0=0.5),
               "The input data must contain 'rank' and 'y' variables.")
  expect_error(rss.AUC.test(data1=rss.data1, data2=rss.data2[,1], alpha=0.05, delta0=0.5),
               "The input data must contain 'rank' and 'y' variables.")
  expect_error(rss.AUC.test(data1=rss.data1, data2=rss.data2[,2], alpha=0.05, delta0=0.5),
               "The input data must contain 'rank' and 'y' variables.")
})
