% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rss.ELR.test.R
\name{rss.ELR.test}
\alias{rss.ELR.test}
\title{RSS empirical likelihood ratio (ELR) test for one-sample population mean}
\usage{
rss.ELR.test(data, alpha = 0.05, mu0)
}
\arguments{
\item{data}{A numeric data frame of ranked set samples with columns \code{rank} for ranks and \code{y} for data values.}

\item{alpha}{A numeric value specifying the confidence level for the interval.}

\item{mu0}{A numeric value indicating the hypothesized value of the mean.}
}
\value{
\item{RSS_mean}{The RSS mean estimate.}
\item{CI}{The confidence interval for the population mean.}
\item{-2*Log.LR}{The empirical log likelihood ratio test statistic.}
\item{p.value}{The p-value for the test.}
}
\description{
The rss.ELR.test function conducts a one-sample empirical likelihood ratio test on ranked set sample data to assess the population mean.
}
\details{
This function performs a one-sample empirical likelihood ratio (ELR) test on ranked set sample data using the method introduced by Ahn et al. (2024). Given a data frame of RSS data \code{data} with \code{rank} and \code{y} columns, the function calculates the empirical likelihood ratio test statistic, confidence interval, and p-value based on the hypothesized mean value \code{mu0}.
}
\examples{
## Unbalanced RSS with a set size 3 and different sample sizes of 6, 10, and 8 for each stratum,
## using imperfect ranking from a normal distribution with a mean of 0.
rss.data<-rss.simulation(H=3,nsamp=c(6,10,8),dist="normal", rho=0.8,delta=0)

## RSS empirical likelihood ratio test
\donttest{
rss.ELR.test(data=rss.data, alpha=0.05, mu0=0)
}

}
\references{
S. Ahn, X. Wang, C. Moon, and J. Lim. (2024) New scheme of empirical likelihood method for ranked set sampling: Applications to two one sample problems. International Statistical Review.
}
\seealso{
\code{\link{rss.simulation}}: used for simulating Ranked Set Samples (RSS), which can serve as input.

\code{\link{rss.sampling}}: used for sampling Ranked Set Samples (RSS) from a population data set, providing input data.
}
