% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank2return.R
\name{rank2return}
\alias{rank2return}
\title{Compute the portfolio return knowing the rank of a stock in the input `mtx'.}
\usage{
rank2return(mtx, myrank, maxChosen = 0, pctChoose = 20, verbo = FALSE)
}
\arguments{
\item{mtx}{{a matrix with n rows (number of returns) p columns (number of stocks)}}

\item{myrank}{{vector of p integers listing the rank of each stock, 1=best}}

\item{maxChosen}{{number of stocks in the portfolio (with nonzero weights)
default=0. When maxChosen=0, we let pctChoose determine the maxChosen}}

\item{pctChoose}{{percent of p stocks chosen inside the portfolio, default=20}}

\item{verbo}{{logical if TRUE, print, default=TRUE}}
}
\value{
average return from the linearly declining
 portfolio implied by the myrank vector.
}
\description{
This function computes the return earned knowing the rank of a stock in
the input mtx of stock returns. For example, mtx has p=28 Dow Jones stocks
over n=169 monthly returns. Portfolio weights are assumed to be linearly
declining. If maxChosen=4, the weights are 4/10, 3/10, 2/10 and 1/10, which add
up to unity. These portfolio weights are assigned in reverse order
in the sense that first chosen stock (choice rank =1) gets portfolio weight=4/10.
The function computes return from the stocks using the `myrank' argument.
}
\seealso{
\code{\link{outOFsamp}}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
