% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exactSdMtx.R
\name{exactSdMtx}
\alias{exactSdMtx}
\title{Exact stochastic dominance computation from areas above ECDF pillars.}
\usage{
exactSdMtx(mtx, howManySd = 0.1)
}
\arguments{
\item{mtx}{{(n X p) matrix of data. For example, returns on p stocks
over n months}}

\item{howManySd}{{used to define (x.ref)= lowest return number.
If the grand minimum of all returns in `mtx' is denoted GrMin, then
howManySd equals the number of max(sd) (maximum standard deviation for data
columns) below the GrMin used to define (x.ref). Thus,
(x.ref)=GrMin-howManySd*max(sd). default howManySd=0.1 }}
}
\value{
five matrices. SD1 to SD4 contain four orders of stochastic 
dominance areas using the ECDF pillars and 
a common (x.ref). The fifth "out" matrix is another output with 4 rows for
SD1 to SD4, and p columns (p=No. of columns in data matrix mtx) having a 
summary of ranks using all four, SD1 to SD4.
}
\description{
ECDF=empirical cumulative distribution functions. These are sufficient
statistics representing probability density functions
defined by observable finite data (e.g., stock returns). The exact computation
of stochastic dominance orders SD1 to SD4 needs areas between two ECDFs,
since such areas represent integrals. Higher-order SDs with continuous 
variables involve repeated integrals. Our quantification needs
areas of ECDFs defined from areas of lower-order ECDFs. We argue that these
computations are convenient if there is an ECDF of an imaginary
reference minimum (x.ref) return, whose ECDF is a rectangle 
common for all stock comparisons. A common (x.ref) avoids having to compute
all possible pairs of p stocks. Choosing a common reference as SP500 index
stock cannot avoid a slower trapezoidal approximation for integrals,
since its returns vary over time. We want exact areas of rectangles and fast.
}
\details{
The \code{exactSdMtx} function inputs `mtx' (n X p) matrix data 
(e.g., n monthly returns on p stocks).
Its output has four matrices SD1 to SD4, each with dimension (n X p). They measure
exact dominance areas between empirical CDF for each column to the ECDF of
(x.ref), an artificial stock with minimal return in all time periods. A fifth
output matrix called `out' produced by \code{exactSdMtx}
has 4 rows and p columns containing column sums of SD1 to SD4. 
We intend that this
`out' matrix produced by \code{exactSdMtx} is then input to another
function \code{summaryRank()} in the package designed for practitioners.
For example, it indicates the best and the worst columns 
representing (the best stock to buy and best stock to sell)
from the input data `mtx' for investment based on a sophisticated computation
of their ranks.
}
\examples{
x1=c(2,5,6,9,13,18,21)
x2=c(3,6,9,12,14,19,27) 
st1=exactSdMtx(cbind(x1,x2))


}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
