% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigfp.R
\name{bigfp}
\alias{bigfp}
\title{Compute the numerical integration by the trapezoidal rule.}
\usage{
bigfp(d, p)
}
\arguments{
\item{d}{{A vector of consecutive interval lengths, upon combining both data vectors}}

\item{p}{{Vector of probabilities of the type 1/2T, 2/2T, 3/2T, etc. to 1.}}
}
\value{
Returns a result after pre-multiplication by \eqn{I_F,  I_f}
matrices, without actually creating the large sparse matrices. This is an internal function.
}
\description{
See page 220 of Vinod (2008) ``Hands-on Intermediate Econometrics Using R,'' 
for the trapezoidal integration formula
needed for stochastic dominance.  The book explains pre-multiplication by two
large sparse matrices denoted by \eqn{I_F,  I_f}.  Here we accomplish the 
same computation without actually creating the large sparse matrices. For example, the
\eqn{I_f} is replaced by \code{cumsum} in this code (unlike the R code in
my textbook).
}
\note{
This is an internal function, called by the function \code{stochdom2}, for
 comparison of two portfolios in terms of stochastic dominance (SD) of orders
 1 to 4.
Typical usage is:
\code{sd1b=bigfp(d=dj, p=rhs)
sd2b=bigfp(d=dj, p=sd1b)
sd3b=bigfp(d=dj, p=sd2b)
sd4b=bigfp(d=dj, p=sd3b)}.
This produces numerical evaluation vectors for the four orders, SD1  to SD4.
}
\references{
Vinod, H. D.', 'Hands-On Intermediate Econometrics
Using R'  (2008) World Scientific Publishers: Hackensack, NJ.
\url{https://www.worldscientific.com/worldscibooks/10.1142/12831}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\concept{fourth order stochastic dominance}
