% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/par3d.save.R
\name{par3d.save}
\alias{par3d.save}
\alias{par3d.restore}
\title{Save and Restore the par3d Parameters for an rgl Scene}
\usage{
par3d.save(
  params = c("userMatrix", "scale", "zoom", "FOV"),
  filename,
  dev = rgl.cur()
)

par3d.restore(parms, filename)
}
\arguments{
\item{params}{A list of \code{par3d} parameters to save}

\item{filename}{Name of a \code{.rds} file to save to or restore from}

\item{dev}{The rgl device.  Currently unused}

\item{parms}{A list of \code{par3d} parameters to restore}
}
\value{
\code{par3d.save} returns a list with the current values of the
\code{par3d} parameters named in \code{params}.
}
\description{
Use this function to make a manually manipulated rgl view reproducible, within sessions or
across sessions. Within an R session, simply use \code{par3d.save} to record
the \code{par3d} parameters for the view(s) to named objects. Across
sessions, use the \code{filename} argument to save these to .rds files
}
\examples{

\dontrun{
	library(rgl)
	open3d()
	# ...
	parms <- par3d.save()
	# ....
	par3d.restore(parms)
	
}


}
\seealso{
\code{\link[rgl]{par3d}}
}
\author{
Michael Friendly
}
\keyword{dplot}
\keyword{dynamic}
