% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose_funs.R
\name{diagnose_roots}
\alias{diagnose_roots}
\title{Diagnose roots of estimating equations}
\usage{
diagnose_roots(GFUN, theta)
}
\arguments{
\item{GFUN}{a function of theta}

\item{theta}{parameter estimates to use in evaluating the estimating equations.}
}
\value{
a numeric vector
}
\description{
Computes the value of \deqn{G_m = sum_i psi(O_i, \hat{\theta})}{G_m = sum_i psi(O_i, theta)}, i.e., the estimating
equations at \code{theta}. Used to verify that \eqn{G_m = 0}{G_m = 0} (or close to 0).
}
\examples{
myee <- function(data){
   function(theta){
    c(data$Y1 - theta[1],
     (data$Y1 - theta[1])^2 - theta[2])
   }
 }

mest <- m_estimate(
   estFUN = myee,
   data   = geexex,
   root_control = setup_root_control(start = c(1, 1)))

f <- grab_GFUN(mest@basis)
# Should be close to zero
diagnose_roots(GFUN = f, theta = roots(mest))
}
