% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq_data.R
\docType{data}
\name{pw.freq}
\alias{pw.freq}
\title{Long-Term Frequency of Power Output}
\format{A data frame with 10 rows and 3 columns: \describe{
  \item{\code{PW_bin}}{the right end point of the intervals defining power
  bins} \item{\code{freq}}{the proportion of observing each power bin from
  historical data} \item{\code{freq_h}}{the accumulated hours of observing
  each power bin from historical data} }}
\usage{
pw.freq
}
\description{
A dataset containing power bins, the proportion of observing each power bin,
and the accumulated hours of observing each power bin.
}
\note{
\itemize{ \item This dataset is provided to show how a user is expected
  to structure the long-term frequency data, which will be used in
  \code{\link{analyze.gain}} or in \code{\link{quantify.gain}}. \item In the
  gain analysis performed by \code{\link{analyze.gain}}, power bins will be
  defined with 100kW increments. To be consistent, \code{PW_bin} must be
  defined with 100kW increments. For example, if rated power is 1,000kW
  (1MW), power bins shalle be generated by using the intervals of [0kW,
  100kW], [100kW, 200kW], \eqn{ \ldots}, [900kW, 1000kW]. \item The gain
  analysis will only need the information specified in \code{freq_h}, so as
  long as the elements in this column correponds to each power bin (with
  100kW increments) and the number of elements matches the number of power
  bins, there should not be any problem. }
}
\keyword{datasets}
