% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spot-pkgs.R
\name{spot_pkgs_used}
\alias{spot_pkgs_used}
\title{Spot Packages Used}
\usage{
spot_pkgs_used(file_path, as_yaml_tags = FALSE)
}
\arguments{
\item{file_path}{String of path to file of interest.}

\item{as_yaml_tags}{Logical, default is \code{FALSE}. If set to \code{TRUE} flattens
and puts into a format convenient for pasting in "tags" section of a
blogdown post Rmd document.}
}
\value{
Character vector of all packages with functions used in the file.
}
\description{
Primarily used for cases where you load metapackages like \code{tidyverse} or
\code{tidymodels} but only want to return those packages that have functions from
the package that are actually called. E.g. say you have a
\code{library(tidyverse)} call but only end-up using functions that are in \code{dplyr}
-- in that case \code{spot_pkgs()} would return \code{"tidyverse"} whereas
\code{spot_pkgs_used()} would return \code{"dplyr"}.
}
\details{
Also does not return uninstalled packages or those loaded when R starts up.

Is essentially just calling \code{spot_funs() |> with(unique(pkgs))} in the
background. Does not have as many options as \code{spot_pkgs()} though.
}
