% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spot-funs.R
\name{spot_funs}
\alias{spot_funs}
\title{Spot Functions}
\usage{
spot_funs(file_path, ...)
}
\arguments{
\item{file_path}{character vector of path to file.}

\item{...}{This allows you to pass additional arguments through to
\code{spot_funs_custom()}.}
}
\value{
Given default arguments and no missing packages, a dataframe with the
following columns is returned:

\code{funs}: specifying functions in file.
\code{pkgs}: the package a function came from. If \code{funs} is a custom function or
if it came from a package not installed on your machine, \code{pkgs} will return
"(unknown)".

Note that any unused loaded packages / \code{pkgs} are dropped from output.
Any functions without an available package are returned with the value
"(unknown)".

See README for further documentation.
}
\description{
Given \code{file_path} extract all functions and their associated packages from
specified file.
}
\details{
\code{spot_funs()} uses \code{spot_funs_custom()} to run -- it is a less verbose
version and does not require passing in the packages separately. See README
and \code{?spot_funs_custom} for details on how the function works and arguments
that can be passed through (via \code{...}).

If code syntax is malformed and cannot be properly parsed, function will error.
}
\examples{
library(funspotr)

file_lines <- "
library(dplyr)
require(tidyr)
library(madeUpPkg)

as_tibble(mpg) \%>\%
  group_by(class) \%>\%
  nest() \%>\%
  mutate(stats = purrr::map(data,
                            ~lm(cty ~ hwy, data = .x)))

made_up_fun()
"

file_output <- tempfile(fileext = ".R")
writeLines(file_lines, file_output)

spot_funs(file_output)
}
\seealso{
\code{\link[=spot_funs_custom]{spot_funs_custom()}}, \code{\link[=spot_funs_files]{spot_funs_files()}}
}
