% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-files-gh-repo.R
\name{list_files_github_repo}
\alias{list_files_github_repo}
\title{List Files in Github Repo}
\usage{
list_files_github_repo(
  repo,
  branch = NULL,
  pattern = stringr::regex("(r|rmd|rmarkdown|qmd)$", ignore_case = TRUE),
  rmv_index = TRUE
)
}
\arguments{
\item{repo}{Github repository, e.g. "brshallo/feat-eng-lags-presentation"}

\item{branch}{Branch of github repository, default is "main".}

\item{pattern}{Regex pattern to keep only matching files. Default is
\code{stringr::regex("(r|rmd|rmarkdown|qmd)$", ignore_case = TRUE)} which will
keep only R, Rmarkdown and Quarto documents. To keep all files use \code{"."}.}

\item{rmv_index}{Logical, most repos containing blogdown sites will have an
index.R file at the root. Change to \code{FALSE} if you don't want this file
removed.}
}
\value{
Dataframe with columns of \code{relative_paths} and \code{absolute_paths} for
file path locations. \code{absolute_paths} will be urls to raw files.
}
\description{
Return a dataframe containing the paths of files in a github repostiory.
Generally used prior to \verb{spot_\{funs/pkgs\}_files()}.
}
\examples{
\donttest{
library(dplyr)
library(funspotr)

# pulling and analyzing my R file github gists
gh_urls <- list_files_github_repo("brshallo/feat-eng-lags-presentation", branch = "main")

# Will just parse the first 2 files/gists
contents <- spot_funs_files(slice(gh_urls, 1:2))

contents \%>\%
  unnest_results()
}
}
\seealso{
\code{\link[=list_files_wd]{list_files_wd()}}, \code{\link[=list_files_github_gists]{list_files_github_gists()}}
}
