% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MarginalCorFuneigen.r
\name{marginal.cor.funeigen}
\alias{marginal.cor.funeigen}
\title{Calculate marginal correlations with response, 
from a funeigen object}
\usage{
marginal.cor.funeigen(object, id, response, alpha = 0.05)
}
\arguments{
\item{object}{An object of type \code{funeigen}.}

\item{id}{The vector of subject id's. These tell which responses in \code{response} 
correspond to which curves in \code{object}.}

\item{response}{The vector of responses}

\item{alpha}{The alpha level for confidence intervals (one minus the two-sided coverage)}
}
\value{
Returns a \code{data.frame} with four columns. 
 The first, \code{time}, is the time index of the rows.  
 That is, it is a grid of points t along the time axis and
 these points correspond to the rows.  The next three are the 
 lower bound, best estimate, and upper bound, of the 
 correlation between the smoothed value of the covariate x(t)
 and the response y at each of the time points t. 
 We refer to the correlation function estimated here as marginal because
it ignores any other functional covariates (rather than 
trying to adjust or control for them).
}
\description{
A function for internal use.  Its main job is to be called by \code{MarginalCor},
and do the technical work for calculating estimated marginal correlations. It 
uses R. A. Fisher's classic r-to-z transform to create confidence
intervals for the correlations.  This process is explained
in easy-to-follow detail by David Shen and Zaizai Lu in a technical report.
}
\note{
The confidence intervals are simply based on Fisher's
 r-to-z transform and do not 
 take into account the uncertainty in estimating the 
 smoothed value of x(t).
}
\references{
Shen, D., and Lu, Z. (2006). Computation of correlation coefficient
and its confidence interval in SAS (r). SUGI 31 (March 26-29, 2006), paper 170-31. Available online at 
\url{https://support.sas.com/resources/papers/proceedings/proceedings/sugi31/170-31.pdf}.
}
