% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FittedFunReg.r
\name{fitted.funreg}
\alias{fitted.funreg}
\title{fitted method for funreg object}
\usage{
\method{fitted}{funreg}(object, type = "response", which.coef = 1, ...)
}
\arguments{
\item{object}{A \code{funreg} object}

\item{type}{Either \code{response} or \code{correlation}.
If \code{response}, fitted values for the scalar response
variable are returned.  If \code{correlation}, estimated 
individual-level correlation coefficients of the smoothed value of the functional covariate
at various time points with the scalar response variable are returned.}

\item{which.coef}{Only required if \code{type} is \code{correlation} 
and there is more than one functional covariate.  This specifies
which functional covariate is of interest.}

\item{...}{Other optional arguments which may be passed from other methods but ignored by this one.}
}
\value{
Returns the fitted values for the responses if \code{type} is \code{response}, 
or the fitted values for the correlations of the 
\code{which.coef}th functional covariate with the
response, if \code{type} is \code{correlation}.
}
\description{
Returns fitted values for a \code{funreg} object.
}
