% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.R
\name{power_exp}
\alias{power_exp}
\title{Simulation-based experiment for power analysis}
\usage{
power_exp(
  n_simu = 100,
  alpha = 0.05,
  n_perm = 100,
  stat = c("mo", "med"),
  n_point = 100,
  n_obs1 = 50,
  n_obs2 = 50,
  c_val = 1,
  delta_shape = "constant",
  distrib = "normal",
  max_iter = 10000,
  verbose = FALSE
)
}
\arguments{
\item{n_simu}{integer value, number of simulations to compute the
statistical power.}

\item{alpha}{numerical value, between 0 and 1, type I risk level to reject
the null hypothesis in the simulation. Default value is \verb{5\%}.}

\item{n_perm}{integer, number of permutation to compute the p-values.}

\item{stat}{character string or vector of character string, name of the
statistics for which the p-values will be computed, among \code{"mo"}, \code{"med"},
\code{"wmw"}, \code{"hkr"}, \code{"cff"}.}

\item{n_point}{integer value, number of points in the trajectory.}

\item{n_obs1}{integer value, number of trajectories in the first sample.}

\item{n_obs2}{integer value, number of trajectories in the second sample.}

\item{c_val}{numeric value, level of divergence between the two samples.}

\item{delta_shape}{character string, shape of the divergence between the
two samples, among \code{"constant"}, \code{"linear"}, \code{"quadratic"}.}

\item{distrib}{character string, type of probability distribution used to
simulate the data among \code{"normal"}, \code{"cauchy"}, \code{"dexp"}, \code{"student"}.}

\item{max_iter}{integer, maximum number of iteration for the iterative
simulation process.}

\item{verbose}{boolean, if TRUE, enable verbosity.}
}
\value{
a list with the following elements:
\itemize{
\item \code{power_res}: a list of named numeric value corresponding to the
power values for each statistic listed in \code{stat} input.
\item \code{pval_res}: a list of named numeric values corresponding to the p-values
for each simulation and each statistic listed in the \code{stat} input.
\item \code{simu_config}: information about input parameters used for simulation,
including \code{n_simu}, \code{ c_val}, \code{ distrib}, \code{ delta_shape}, \code{ n_point},
\code{ n_obs1}, \code{ n_obs2}.
}
}
\description{
Computation of the statistical power (i.e. risk to reject
the null hypothesis when it is false) associated to any statistics
described in the package based on simulation permutation-based p-values
computations. See Smida et al (2022) for more details.
}
\details{
The \code{c_val} input argument should be strictly positive so that the null
hypothesis is not verified when simulating the data (i.e. so that the two
sample are not generated from the same probability distribution).
}
\examples{
# simulate a few small data for the example
res <- power_exp(
    n_simu = 20, alpha = 0.05, n_perm = 100, 
    stat = c("mo", "med", "wmw", "hkr", "cff"), 
    n_point = 25, n_obs1 = 4, n_obs2 = 5, c_val = 10, delta_shape = "constant", 
    distrib = "normal", max_iter = 10000, verbose = FALSE
)
res$power_res
}
\references{
Zaineb Smida, Lionel Cucala, Ali Gannoun & Ghislain Durif (2022)
A median test for functional data, Journal of Nonparametric Statistics,
34:2, 520-553,
\doi{10.1080/10485252.2022.2064997},
\href{https://hal.science/hal-03658578}{hal-03658578}
}
\seealso{
\code{\link[=stat_mo]{stat_mo()}}, \code{\link[=stat_med]{stat_med()}},
\code{\link[=stat_wmw]{stat_wmw()}}, \code{\link[=stat_hkr]{stat_hkr()}},
\code{\link[=stat_cff]{stat_cff()}}, \code{\link[=comp_stat]{comp_stat()}}
}
\author{
Zaineb Smida, Ghislain DURIF, Lionel Cucala
}
