% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_fgpKern_Class.R
\docType{class}
\name{fgpKern-class}
\alias{fgpKern-class}
\title{S4 class for structures linked to the kernel of a \code{fgpm} model}
\description{
This is the formal representation for data structures linked to the kernel of a Gaussian
  process model within the \link[=funGp-package]{funGp package}.
}
\section{Slots}{

\describe{
\item{\code{kerType}}{Object of class \code{"character"}. Kernel type. To be set from \{"gauss", "matern5_2",
"matern3_2"\}.}

\item{\code{f_disType}}{Object of class \code{"character"}. Distance type. To be set from \{"L2_bygroup",
"L2_index"\}.}

\item{\code{varHyp}}{Object of class \code{"numeric"}. Estimated variance parameter.}

\item{\code{s_lsHyps}}{Object of class \code{"numeric"}. Estimated length-scale parameters for scalar inputs.}

\item{\code{f_lsHyps}}{Object of class \code{"numeric"}. Estimated length-scale parameters for functional
inputs.}

\item{\code{f_lsOwners}}{Object of class \code{"character"}. Index of functional input variable linked to each
element in \emph{f_lsHyps}}
}}

\author{
José Betancourt, François Bachoc, Thierry Klein and Jérémy Rohmer
}
