% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_ikasudb.R
\name{read_ikasudb}
\alias{read_ikasudb}
\title{Read a shuraku Excel file}
\usage{
read_ikasudb(boundary, path, na = c("-", "…"), zero = TRUE)
}
\arguments{
\item{boundary}{Agricultural community boundary data as returned by \code{\link[=get_boundary]{get_boundary()}}.}

\item{path}{Path to an \code{.xlsx} file.}

\item{na}{Character vector of strings to interpret as missing values. Defaults to
\code{c("-", "\\u2026")}.}

\item{zero}{Logical. If \code{TRUE}, treat masked values (\code{"x"} and \code{"X"}) as zero.}
}
\value{
An \code{\link[sf:sf]{sf::sf()}} object.
}
\description{
\code{read_ikasudb()} reads a shuraku Excel file provided by MAFF.
}
