% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/functional-spectral-density.R
\name{Simulate_new_MA}
\alias{Simulate_new_MA}
\title{Simulate a new Moving Average (MA) vector time series and return the time series}
\usage{
Simulate_new_MA(a, T.len, noise.type, DEBUG = FALSE)
}
\arguments{
\item{a}{Array, returned by \code{Generate_filterMA}, containing the filter of the MA process}

\item{T.len}{Numeric, the length of the time series to generate}

\item{noise.type}{the type of noise that is driving the MA process. See Details section.}

\item{DEBUG}{Logical, for outputting information on the progress of the function}
}
\value{
A \code{T.len x dim(a)[1]} matrix, where each column corresponds to a
coordinate of the vector time series
}
\description{
Simulate a new Moving Average (MA) vector time series and return the time series
}
\section{Details}{


The function simulates a moving average process of dimension
\code{dim(a)[1]}, defined by \deqn{X[t,] =  a[,,1]  * epsilon[,t-1] + a[,,2]
* epsilon[,t-2] + ... + a[,,dim(a)[3]] * epsilon[t-dim(a)[3]]  }

\code{noise.type} specifies the nature and internal correlation of the noise
that is driving the MA process. It can take the values
\describe{
\item{\code{white-noise}}{ the noise is Gaussian with covariance matrix identity}
\item{\code{white-noise}}{the noise is Gaussian with diagonal covariance
matrix, whose j-th diagonal entry is \eqn{((j - 0.5 )*pi)^(-1)}}
\item{\code{studentk}}{the coordinates  of the noise are independent and
have a student t distribution with 'k' degrees of freedom, standardized to
have variance 1}
}
}
\examples{
ma.scale1=c(-1.4,2.3,-2)
a1=Generate_filterMA(6, 6, MA.len=3, ma.scale=ma.scale1)
X=Simulate_new_MA(a1, T.len=512, noise.type='wiener')
plot.ts(X)
}

