% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinal-friendly.R
\name{ordinal_friendly}
\alias{ordinal_friendly}
\alias{ordinal_friendly_safe}
\title{Translate integer-ish numbers to an ordinal character vector}
\usage{
ordinal_friendly(
  numbers,
  zero = "zeroth",
  na = "missingth",
  nan = "not a numberth",
  inf = "infinitieth",
  negative = "negative ",
  and = FALSE,
  hyphenate = TRUE
)

ordinal_friendly_safe(
  numbers,
  zero = "zeroth",
  na = "missingth",
  nan = "not a numberth",
  inf = "infinitieth",
  negative = "negative ",
  and = FALSE,
  hyphenate = TRUE
)
}
\arguments{
\item{numbers}{\verb{[integer / numeric]}

An integer or integer-ish numeric vector to translate.}

\item{zero}{\verb{[character(1)]}

What to call values of \code{0} in \code{numbers} (e.g. \code{zero = "zero"}).}

\item{na}{\verb{[character(1)]}

What to call values of \code{NA} in \code{numbers} (e.g. \code{na = "missing"}).}

\item{nan}{\verb{[character(1)]}

What to call values of \code{NaN} in \code{numbers} (e.g. \code{nan = "undefined"}).}

\item{inf}{\verb{[character(1)]}

What to call values of \code{Inf} in \code{numbers} (e.g. \code{inf = "infinity"}).}

\item{negative}{\verb{[character(1)]}

A prefix added to the translation of negative elements of \code{numbers}.
\code{negative} is the string \code{"negative "} by default.}

\item{and}{\verb{[TRUE / FALSE]}

Whether to insert an \code{" and "} before the tens place of translated \code{numbers}.
\code{and} is \code{FALSE} by default.}

\item{hyphenate}{\verb{[TRUE / FALSE]}

Whether to hyphenate numbers 21 through 99 (e.g. \code{"twenty-one"} vs. \code{"twenty one"}).
\code{hyphenate} is \code{TRUE} by default.}
}
\value{
A non-NA character vector of the same length as \code{numbers}.
}
\description{
Convert an integer vector, or numeric vector which is coercible to an integer
without loss of precision, to an ordinal numeral (e.g. first, second, third).

\code{ordinal_friendly_safe()} checks that all arguments are of the correct type
and raises an informative error otherwise. \code{ordinal_friendly()} does not
perform input validation to maximize its speed.
}
\examples{
ordinal_friendly(c(0, 1, 2, 3, NA, NaN, Inf, -Inf))
ordinal_friendly(10^10)

# Specify the translations of "special" numbers
ordinal_friendly(0, zero = "noneth")

# Modify the output formatting
ordinal_friendly(1234)
ordinal_friendly(1234, and = TRUE)
ordinal_friendly(1234, hyphenate = FALSE)

# Input validation
try(ordinal_friendly_safe(0.5))
}
