% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numeric-friendly.R
\name{numeric_friendly}
\alias{numeric_friendly}
\alias{numeric_friendly_safe}
\title{Translate a numeric vector to a cardinal character vector}
\usage{
numeric_friendly(
  numbers,
  zero = "zero",
  na = "missing",
  nan = "not a number",
  inf = "infinity",
  negative = "negative ",
  decimal = " and ",
  and = FALSE,
  hyphenate = TRUE,
  and_fractional = and,
  hyphenate_fractional = hyphenate,
  english_fractions = NULL
)

numeric_friendly_safe(
  numbers,
  zero = "zero",
  na = "missing",
  nan = "not a number",
  inf = "infinity",
  negative = "negative ",
  decimal = " and ",
  and = FALSE,
  hyphenate = TRUE,
  and_fractional = and,
  hyphenate_fractional = hyphenate,
  english_fractions = NULL
)
}
\arguments{
\item{numbers}{\verb{[numeric]}

A numeric vector to translate.}

\item{zero}{\verb{[character(1)]}

What to call values of \code{0} in \code{numbers} (e.g. \code{zero = "zero"}).}

\item{na}{\verb{[character(1)]}

What to call values of \code{NA} in \code{numbers} (e.g. \code{na = "missing"}).}

\item{nan}{\verb{[character(1)]}

What to call values of \code{NaN} in \code{numbers} (e.g. \code{nan = "undefined"}).}

\item{inf}{\verb{[character(1)]}

What to call values of \code{Inf} in \code{numbers} (e.g. \code{inf = "infinity"}).}

\item{negative}{\verb{[character(1)]}

A prefix added to the translation of negative elements of \code{numbers}.
\code{negative} is the string \code{"negative "} by default.}

\item{decimal}{\verb{[character(1)]}

A word inserted between the whole and fractional part of translated
\code{numbers}. \code{decimal} is the string \code{" and "} by default.}

\item{and}{\verb{[TRUE / FALSE]}

Whether to insert an \code{" and "} before the tens place of translated \code{numbers}.
\code{and} is \code{FALSE} by default.}

\item{hyphenate}{\verb{[TRUE / FALSE]}

Whether to hyphenate numbers 21 through 99 (e.g. \code{"twenty-one"} vs. \code{"twenty one"}).
\code{hyphenate} is \code{TRUE} by default.}

\item{and_fractional}{\verb{[TRUE / FALSE]}

Whether to insert an \code{" and "} before the smallest fractional tens place
of translated \code{numbers} (e.g. \code{"one hundred one thousandths"} vs.
\code{"one hundred and one thousandths"}).

\code{and_fractional} is equal to \code{and} by default.}

\item{hyphenate_fractional}{\verb{[TRUE / FALSE]}

Whether to hyphenate numbers 21 through 99 in the fractional part of translated
\code{numbers} (e.g. \code{"twenty-one hundredths"} or \code{"twenty one hundredths"}). This
also determines the hyphenation of the fractional units (e.g. \code{"one ten-millionth"}
vs. \code{"one ten millionth"}).

\code{hyphenate_fractional} is equal to \code{hyphenate} by default.}

\item{english_fractions}{\verb{[character]}

A named character vector used as a dictionary for the translation of the
fractional part of \code{numbers}. The names (i.e. keys) are the decimal digits
of a fractional number and the values are the corresponding translations.

For example \code{english_fractions = c("5" = "a half")} matches the number
\code{0.5} (translated as \code{"a half"}) and \code{2.5} (translated as \code{"two and a half"}).

By default \code{english_fractions} is a named character vector with translations
for fractions \code{x / y} for \verb{x = 1, 2, ..., 8} and \verb{y = 1, 2, ..., 9}. For
example, \code{2 / 3} is translated as \code{"two thirds"} and \code{1 / 2} is translated
as \code{"one half"}.

Provide an empty character to \code{english_fractions} to opt out of any such
translations. In this case \code{1 / 2} is translated as \code{"five tenths"} instead
of \code{"one half"}.}
}
\value{
A non-NA character vector of the same length as \code{numbers}.
}
\description{
Convert a numeric vector to a cardinal numeral (e.g. one tenth, one, two).

\code{numeric_friendly_safe()} checks that all arguments are of the correct type
and raises an informative error otherwise. \code{numeric_friendly()} does not
perform input validation to maximize its speed.
}
\examples{
numeric_friendly(c(1/3, 0, 0.999, NA, NaN, Inf, -Inf))

# Specify the translations of "special" numbers
numeric_friendly(c(1, 0, Inf), zero = "none", inf = "all")

# Modify the output formatting
frac <- 8765.4321
numeric_friendly(frac)
numeric_friendly(frac, decimal = " dot ")
numeric_friendly(frac, hyphenate = TRUE, hyphenate_fractional = FALSE)
numeric_friendly(frac, and = TRUE, and_fractional = TRUE, decimal = " . ")

# The `friendlynumber.numeric.digits` option specifies the number of
# numeric digits mentioned by `numeric_friendly()`
opts <- options()
options(friendlynumber.numeric.digits = 5)
numeric_friendly(0.0987654321)

options(friendlynumber.numeric.digits = 10)
numeric_friendly(0.0987654321)
options(opts)

# Set `english_fractions` to specify the translation of certain
# fractions. The names (keys) of `english_fractions` should match
# the decimal part of a fraction (e.g. `"5"` matches `0.5`).
numeric_friendly(
  c(1/2, 6/5, 12),
  english_fractions = c(`5` = "1/2", `2` = "1/5")
)

# Input validation
try(numeric_friendly_safe("A"))
}
