% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqdom.product.R
\name{freqdom.product}
\alias{freqdom.product}
\title{Compute a matrix product of two frequency-domain operators}
\usage{
freqdom.product(F, G)
}
\arguments{
\item{F}{frequency-domain filter of type \code{\link{freqdom}}, i.e. a set of linear operators \eqn{F_\theta \in \mathbf{R}^{p \times q}} defined
on a discreet grid defined \eqn{S \subset [-\pi,\pi]}.}

\item{G}{frequency-domain filter of type \code{\link{freqdom}}, i.e. a set of linear operators \eqn{G_\theta \in \mathbf{R}^{q \times r}} defined
on a discreet grid defined \eqn{S \subset [-\pi,\pi]}.}
}
\value{
Function returns a frequency domain object (\code{\link{freqdom}}) of dimensions \eqn{L \times p \times r}, where \eqn{L} is the
size of the evaluation grid. The elements correspond to \eqn{F_\theta * G_\theta} defined above.
}
\description{
For given frequency-domain operators \code{F} and \code{G} (\code{\link{freqdom}}) the function \code{freqdom.kronecker} computes their matrix product frequency-wise.
}
\details{
Let \eqn{F = \{ F_\theta : \theta \in S \}}, \eqn{G = \{ G_\theta : \theta \in S \}},
where \eqn{S} is a finite grid of frequencies in \eqn{[-\pi,\pi]}, \eqn{F_\theta \in \mathbf{C}^{p \times q}}
and \eqn{G_\theta \in \mathbf{C}^{q \times r}}.

We define \deqn{H_\theta = F_\theta G_\theta} as a matrix product of \eqn{F_\theta} and \eqn{G_\theta}, i.e. \eqn{H_\theta \in \mathbf{R}^{p\times r}}.
Function \code{freqdom.product} returns \eqn{H = \{ H_\theta : \theta \in S \}}.
}
\section{Functions}{
\itemize{
\item \code{freqdom.product()}: Frequency-wise matrix product of two frequency-domain operators

}}
\examples{
n = 100
X = rar(n)
Y = rar(n)
SX = spectral.density(X)
SY = spectral.density(Y)
R = freqdom.product(SY,SX)
}
\keyword{internal}
