!!! Donnees pour Joint 

!AD:sortie fortran
    module sortie
    integer,save::cptaux,cptcens,nb0recu
    double precision::moyrecu
    end module sortie
!AD:

    module donnees

    implicit none
    double precision,dimension(6)::cof
    double precision::stp,half,one,fpf
    double precision,dimension(20),save::x,w   !The abscissas-weights : w = w(x)*exp(x) => gauss-laguerre
    double precision,dimension(32),save::x1,w1 !The abscissas-weights : w1 = w(x1)*exp(x1) => gauss-laguerre
    double precision,dimension(50),save::x50GL,w50GL
    double precision,dimension(20),save::x2,w2 !The abscissas-weights : w2 = w(x2)*exp(x2*x2) => gauss-hermite
    double precision,dimension(32),save::x3,w3 !The abscissas-weights : w3 = w(x3)*exp(x3*x3) => gauss-hermite
    double precision,dimension(9),save::x9,w9  !The abscissas-weights : w9 = w(x9)*exp(x9*x9) => gauss-hermite
    double precision,dimension(7),save::x7,w7  !The abscissas-weights : w12 = w(x12)*exp(x12*x12) => gauss-hermite
    double precision,dimension(50),save::x50GH,w50GH
    double precision,dimension(5),save::x5,w5
    double precision,dimension(12),save::x12,w12
    double precision,dimension(15),save::x15,w15
    double precision,dimension(100),save::x100,w100
    double precision,dimension(1000)::MC1,MC2,MC3,MC4,MC5,MC6,MC7,MC8,MC9,MC10,MC11,MC12,MC13,&
                                      MC14,MC15,MC16,MC17,MC18,MC19,MC20,MC21,MC22,MC23,MC24,MC25
    !double precision,dimension(5000)::QMC5000_1,QMC5000_2
    double precision,dimension(1000)::QMC1000_1,QMC1000_2 
    double precision,dimension(500)::QMC500_1,QMC500_2 
    double precision,dimension(100)::QMC100_1,QMC100_2 

    ! gauss-hermite quadrature à 50 noeuds
    DATA x50GH/ -9.182406958,-8.522771031,-7.975622368,-7.486409430, &
        -7.034323510,-6.608647974,-6.202952519,-5.812994675, &
        -5.435786087,-5.069117585,-4.711293666,-4.360973160, &
        -4.017068173,-3.678677063,-3.345038314,-3.015497770, &
        -2.689484702,-2.366493904,-2.046071969,-1.727806548, &
        -1.411317755,-1.096251129,-0.782271730,-0.469059057, &
        -0.156302547,0.156302547,0.469059057,0.782271730, &
        1.096251129,1.411317755,1.727806548,2.046071969, &
        2.366493904,2.689484702,3.015497770,3.345038314, &
        3.678677063,4.017068173,4.360973160,4.711293666, &
        5.069117585,5.435786087,5.812994675,6.202952519, &
        6.608647974,7.034323510,7.486409430,7.975622368, &
        8.522771031,9.182406958/
    DATA w50GH/ 0.761348691,0.588605297,0.513304798,0.468326212, &
        0.437553282,0.414838821,0.397244944,0.383161392, &
        0.371619771,0.361997265,0.353872470,0.346948770, &
        0.341010727,0.335897877,0.331488254,0.327687661, &
        0.324422449,0.321634538,0.319277916,0.317316124, &
        0.315720440,0.314468551,0.313543590,0.312933448, &
        0.312630298,0.312630298,0.312933448,0.313543590, &
        0.314468551,0.315720440,0.317316124,0.319277916, &
        0.321634538,0.324422449,0.327687661,0.331488254, &
        0.335897877,0.341010727,0.346948770,0.353872470, &
        0.361997265,0.371619771,0.383161392,0.397244944, &
        0.414838821,0.437553282,0.468326212,0.513304798, &
        0.588605297,0.761348691/

    ! Quadrature GL 50 noeuds
    DATA x50GL/ 0.028630518,0.150882936,0.370948782,0.689090700, &
        1.105625024,1.620961751,2.235610376,2.950183367, &
        3.765399774,4.682089388,5.701197575,6.823790910, &
        8.051063669,9.384345308,10.825109032,12.374981609, &
        14.035754600,15.809397198,17.698070933,19.704146535, &
        21.830223307,24.079151444,26.454057841,28.958376012, &
        31.595880957,34.370729963,37.287510611,40.351297574, &
        43.567720270,46.943043992,50.484267963,54.199244880, &
        58.096828017,62.187054176,66.481373878,70.992944827, &
        75.737011548,80.731404802,85.997211136,91.559690413, &
        97.449565615,103.704891237,110.373858808,117.519198203, &
        125.225470133,133.612027923,142.858325489,153.260371973, &
        165.385643317,180.698343709/
    DATA w50GL/ 0.073478627,0.171113306,0.269058399,0.367277884, &
        0.465859023,0.564899293,0.664499976,0.764765779, &
        0.865805255,0.967731440,1.070662589,1.174723003, &
        1.280043950,1.386764699,1.495033689,1.605009845, &
        1.716864091,1.830781080,1.946961191,2.065622859, &
        2.187005287,2.311371640,2.439012827,2.570252004, &
        2.705449971,2.845011697,2.989394256,3.139116562, &
        3.294771422,3.457040581,3.626713713,3.804712645, &
        3.992122630,4.190233269,4.400592837,4.625081607, &
        4.866012648,5.126273277,5.409528338,5.720520374, &
        6.065527140,6.453085474,6.895188963,7.409380781, &
        8.022669231,8.779528260,9.760303127,11.131390723, &
        13.324267692,18.114146002/
            

    DATA w/0.181080062419,0.422556767879,0.666909546702,0.91535237279, &
    1.1695397071,1.43135498624,1.7029811359,1.98701589585, &
    2.28663576323,2.60583465152,2.94978381794,3.32539569477, &
    3.74225636246,4.21424053477,4.76252016007,5.42172779036, &
    6.25401146407,7.38731523837,9.15132879607,12.8933886244/

    DATA x/0.070539889692,0.372126818002,0.916582102483,1.70730653103, &
    2.74919925531,4.04892531384,5.61517497087,7.45901745389, &
    9.59439286749,12.0388025566,14.8142934155,17.9488955686, &
    21.4787881904,25.4517028094,29.9325546634,35.0134341868, &
    40.8330570974,47.6199940299,55.8107957541,66.5244165252/

    data cof,stp/76.18009173d0,-86.50532033d0,24.01409822d0, &
    -1.231739516d0,.120858003d-2,-.536382d-5,2.50662827465d0/
    data half,one,fpf/0.5d0,1.0d0,5.5d0/

    DATA w1/0.114187105768,0.266065216898,0.418793137325,0.572532846497, &
    0.727648788453,0.884536718946,1.04361887597,1.20534920595, &
    1.37022171969,1.53877595906,1.71164594592,1.8895649683, &
    2.07318851235,2.26590144444,2.46997418988,2.64296709494, &
    2.76464437462,3.22890542981,2.92019361963,4.3928479809, &
    4.27908673189,5.20480398519,5.11436212961,4.15561492173, &
    6.19851060567,5.34795780128,6.28339212457,6.89198340969, &
    7.92091094244,9.20440555803,11.1637432904,15.3902417688/

    DATA x1/0.0444893658333,0.23452610952,0.576884629302,1.07244875382, &
    1.72240877644,2.52833670643,3.49221327285,4.61645677223, &
    5.90395848335,7.3581268086,8.98294126732,10.783012089, &
    12.763745476,14.9309117981,17.2932661372,19.8536236493, &
    22.6357789624,25.6201482024,28.8739336869,32.3333294017, &
    36.1132042245,40.1337377056,44.5224085362,49.2086605665, &
    54.3501813324,59.8791192845,65.9833617041,72.6842683222, &
    80.1883747906,88.735192639,98.8295523184,111.751398227/

! gauss-hermite quadrature a 20 noeuds
    DATA w2/0.898591961453,0.704332961176,0.62227869619,0.575262442852, &
    0.544851742366,0.524080350949,0.509679027117,0.499920871336, &
    0.493843385272,0.490921500667,0.490921500667,0.493843385272, &
    0.499920871336,0.509679027117,0.524080350949,0.544851742366, &
    0.575262442852,0.62227869619,0.704332961176,0.898591961453/

    DATA x2/-5.38748089001,-4.60368244955,-3.94476404012,-3.34785456738, &
    -2.78880605843,-2.25497400209,-1.73853771212,-1.2340762154, &
    -0.737473728545,-0.245340708301,0.245340708301,0.737473728545, &
    1.2340762154,1.73853771212,2.25497400209,2.78880605843, &
    3.34785456738,3.94476404012,4.60368244955,5.38748089001/

! gauss-hermite quadrature a 32 noeuds
    DATA w3/0.824566523071,0.640950485906,0.561749015435,0.515037283347,0.48357144163, &
    0.460786455454,0.443553185862,0.430163710393,0.419597752949,0.411206128685, &
    0.404557061809,0.399354844618,0.395393939396,0.392531864366,0.390672744629, &
    0.389757342027,0.389757342027,0.390672744629,0.392531864366,0.395393939396, &
    0.399354844618,0.404557061809,0.411206128685,0.419597752949,0.430163710393, &
    0.443553185862,0.460786455454,0.48357144163,0.515037283347,0.561749015435, &
    0.640950485906,0.824566523071/

    DATA x3/-7.12581390983,-6.40949814928,-5.81222594946,-5.27555098664,-4.77716450334, &
    -4.30554795347,-3.85375548542,-3.41716749282,-2.99249082501,-2.57724953773, &
    -2.16949918361,-1.76765410946,-1.37037641095,-0.97650046359,-0.584978765436, &
    -0.194840741569,0.194840741569,0.584978765436,0.97650046359,1.37037641095, &
    1.76765410946,2.16949918361,2.57724953773,2.99249082501,3.41716749282, &
    3.85375548542,4.30554795347,4.77716450334,5.27555098664,5.81222594946, &
    6.40949814928,7.12581390983/


                ! gauss-hermite quadrature a 5 noeuds

        DATA w5/1.181488625535987604501,0.986580996751428170494,0.945308720482941881226,&
        0.986580996751428170494,1.181488625535987604501/

        DATA x5/-2.020182870456085632929,-0.9585724646138185071128,0,&
        0.9585724646138185071128,2.020182870456085632929/

                ! gauss-hermite quadrature a 7 noeuds

    DATA w7/1.10133072961032234908,0.89718460022518404681,0.82868730328363926234,&
        0.810264617556807326765,0.8286873032836392623397,0.89718460022518404681,&
        1.101330729610322349075/

        DATA x7/-2.651961356835233492447,-1.673551628767471445032,-0.816287882858964663039,&
        0,0.8162878828589646630387,1.673551628767471445032,2.651961356835233492447/


        ! gauss-hermite quadrature a 9 noeuds
   DATA w9/1.04700358097668224537,0.8417527014786699581343,0.7646081250945503029035,&
        0.7303024527450921536951,0.720235215606050957124,0.7303024527450921536951,&
        0.764608125094550302903,0.841752701478669958134,1.04700358097668224537/

        DATA x9/-3.19099320178152760723,-2.266580584531843111802,-1.468553289216667931667,&
        -0.723551018752837573323,0,0.7235510187528375733226,1.468553289216667931667,&
        2.266580584531843111802,3.19099320178152760723/


        ! gauss-hermite quadrature a 12 noeuds
        DATA w12/0.98969904709229809937,0.78664393946332246449,0.705220366112219755756,&
        0.662662773266871319239,0.6396212320202566006693,0.629307874369492821036,&
        0.6293078743694928210357,0.639621232020256600669,0.662662773266871319239,&
        0.70522036611221975576,0.786643939463322464492,0.98969904709229809937/

        DATA x12/-3.889724897869781919272,-3.020637025120889771711,-2.279507080501059900188,&
        -1.59768263515260479671,-0.947788391240163743705,-0.3142403762543591112766,&
        0.3142403762543591112766,0.947788391240163743705,1.59768263515260479671,&
        2.279507080501059900188,3.020637025120889771711,3.889724897869781919272/


        ! gauss-hermite quadrature a 15 noeuds

        DATA w15/0.9483689708276051861,0.74860736601690624983,0.6661660051090438365387,&
        0.620662603527037136634,0.593027449764209532813,0.5761933502834996497355,&
        0.567021153446603929198,0.564100308726417532853,0.567021153446603929198,&
        0.576193350283499649735,0.593027449764209532813,0.62066260352703713663,&
        0.66616600510904383654,0.748607366016906249827,0.9483689708276051861/

        DATA x15/-4.49999070730939155366,-3.669950373404452534729,-2.967166927905603248489,&
        -2.325732486173857745454,-1.719992575186488932416,-1.136115585210920666319,&
        -0.565069583255575748526,0,0.565069583255575748526,1.136115585210920666319,&
        1.719992575186488932416,2.325732486173857745454,2.967166927905603248489,&
        3.669950373404452534729,4.49999070730939155366/

        ! Monte-carlo pre-generated centered and scaled gaussian numbers
        DATA MC1/-0.61304335481364680,2.7930139037579855,0.64134358862723806,-1.7892626611584030,&
        0.45493501440497636,0.93533592942073274,1.2322811614384335,0.27985245067772629,&
        -0.54419276817713191,1.8079182005895578,1.4166699902230899,-5.9116367196702397E-003,&
        -0.58271688539934241,-1.6913583584245697,0.27980264824397433,-1.4916197813681946,&
        0.85368102970927529,-1.7563882664730437,0.25274515740631975,-1.0298217970329309,&
        -1.6620593004650464,-0.90156240691755773,-0.60860201208745979,-0.95915369652207949,&
        0.51686613919396385,0.24521259035014345,-1.2275928495362556,-1.0461909626669921,&
        -0.24929245341289222,0.48313598658752360,-0.53046263829693252,1.7859785560415893,&
        0.28108085817933243,-0.47179483156683405,-1.0945544025642875,0.40826271687845456,&
        0.92453529849286031,3.3488858086523438E-002,-0.59959142539450982,0.10707096080046555,&
        9.1977425084218314E-002,0.68936821787380320,-0.84210682721246433,1.8002709358869000,&
        -1.5160422913867420E-003,0.32438200300125669,-1.0917467786437223,1.0960731629423419,&
        0.73428550348131372,0.17173402330373908,-0.13557802231243041,-0.23047452331912610,&
        1.8261308343585543,0.89084301663561394,-0.30545716204361573,8.5185532566874250E-002,&
        1.1059215165947138,-0.26866817031488549,1.7421393021625229,-0.71839036919775523,&
        -0.38229966003530402,1.0101026520541858,0.31287995610105640,1.3492965048450736,&
        -1.0113972753507734,-0.81888628713792566,1.0243403087978575,6.2541820524138272E-002,&
        -2.9590494971867953E-002,-1.2773571595385651,-0.44577891556411364,-1.3338470465440222,&
        -0.55530483003759601,-0.19289812847521515,4.6488259289054520E-002,-0.60893605265507855,&
        0.92852560223530678,0.38138908813870581,-7.4338535819542362E-002,-0.36054817843079490,&
        1.3342529113250032,-1.5160727940782561,-2.3888685005864181,0.40651575861881428,&
        -2.8165241119010781E-002,-7.5545163536787752E-002,1.0653360950433539,0.87445190747134705,&
        0.14618199091697978,1.2232589310331314,1.7263509116134541,-0.21711651895466166,&
        -1.0220557046336409,1.0004646208984314,1.1867539748822851,0.48716301265287426,&
        0.66350250390668575,-0.44826359897351548,-0.74995824476424311,0.26096040067386572,&
        -1.4027989097196918,-2.1799704072602060,1.2633842172380598,-1.6642250447445353,&
        -0.28246802784825120,-0.79019302283499104,-0.64511116594742079,1.4922293296828144,&
        -2.4439387943858830,1.4743634242945616,0.91627957108831870,-1.3084597634832220,&
        -0.41361530885069209,-8.9005137996109332E-002,2.0989362225580575,0.44723842539638098,&
        1.3986692402076237,0.11983790370585017,-1.4047622016225059,-0.69486480089971203,&
        0.35971144905699554,-0.67568873455368217,1.3778179803529329,-0.31116412889383033,&
        -0.31931776554946623,0.62628879708656593,-1.0749746708667300,-0.55350363697663130,&
        -0.70622687956211372,1.5610888286605520,0.75320739680646998,1.4327799230964995,&
        1.0408947054138020,-1.4794651433531414,-3.6297210543281326E-002,-0.47260224608482049,&
        0.37758761964880072,-0.33981068262929776,0.79104418709634150,-0.32299712366316524,&
        0.60049215033280923,-1.1674817770100534,-9.1357667635280984E-003,-0.96801677091454796,&
        2.2804643153624164,0.18316657232525588,0.89346698626130983,-0.98872698163117512,&
        1.1047206389283910,1.9008121754676648,-1.8876468230762479E-002,0.33248785948463838,&
        0.97992812878707836,-0.73218392991793813,0.50117710826454220,-0.50126994936042091,&
        -1.3473118037808818,0.95455560009431140,0.81198015450098038,-1.3151985689144579,&
        -0.40551052567057894,-1.4304818157041155,-1.1993090480370063,1.0598230592948692E-002,&
        0.48899434653823243,-1.0834517292226371,0.82068908302978649,-0.32695755592511139,&
        0.96952600477630535,0.98383149230905853,0.81662642016671161,1.6074966118358742,&
        -1.0652849292636299,-0.54608226862758624,-0.92438845998333197,0.54147839038910905,&
        -0.49152844758442477,-2.8792328592643521,-1.0391238811863961,1.2219372705983234,&
        -0.95224951120321066,0.84972776007020823,0.53227063802289964,9.2687531638720455E-003,&
        1.2196849012704800,0.50809550548086257,0.62506806319358821,-1.2592915272351850,&
        0.41269723909112394,0.22086855195693023,-0.98774177396726037,-0.97063796352833276,&
        -0.67375443086440645,-0.80450082039076576,0.69529565366913526,-0.89373278525945776,&
        -1.5373962483927812,0.30934120340295918,-7.2536424027520155E-002,-0.93586484626992439,&
        -0.47224732608094488,0.57435170216323916,-0.38503022777781259,-1.5390317945021372,&
        -0.48646668754389011,2.1709986532475565,-0.51194546259390461,-2.8848309626313329,&
        -0.44283432263444372,0.64021358038270315,0.12893127200071813,0.96038218330644065,&
        -0.33672331622252644,-9.8043688412825847E-002,0.76821052396591660,-0.94327366695665948,&
        -0.40216459472614946,1.6585462861732863,-0.28812553102400829,1.2688051455775524,&
        -0.83279731970230220,7.7724457885361212E-002,0.53990507684154398,0.30018619471781743,&
        -0.97925104413142572,-0.36327591642216150,-1.9934601002340511,1.1359683119546968,&
        1.1083849291459174,0.29584559330091964,0.30541817110606412,-0.51929098097527171,&
        3.1983600384078888E-002,0.20097758449999217,7.0791127309995745E-003,1.4523481755114338,&
        -0.60833687364724598,-0.57617685922605244,-1.5680884408278966,-0.68331892168772501,&
        -1.2064337312620657,-1.1054137507665682,-0.33379816088987463,0.37255455342307692,&
        -0.30685576054298952,-0.56457550759026309,0.21543143818767313,0.66208129954840456,&
        1.2625374482105134,-8.0227983765237140E-002,-0.57822036464268656,1.5619484036123681,&
        1.0751319085335196,-1.4908912549917921,7.6760039939451324E-002,0.64903759909042857,&
        -1.4758381769630446,0.28880895245547250,-2.1263859583264817,0.11010018511290272,&
        -0.47712289343290781,9.8760434429626023E-002,1.0065439732938386,-0.65400871918875836,&
        -0.97731712003820936,-0.56626412085516153,-1.4192752249967184,1.5770038675382174,&
        -0.99321712883637303,0.20849637091899631,0.99756117903354613,0.62145257753106775,&
        -8.1533779912759868E-002,0.75346120058532862,0.85228583543264036,1.5077641918055720,&
        2.2440729461320195,-1.3674834430974296,0.35396792659099446,1.2551259744719372,&
        -0.89111230039387102,0.41085381352886391,0.88634889103099301,3.4318863516403383E-002,&
        -1.4806838709004586,-0.21002521819019210,2.1897181348069217,-2.0294618721141306,&
        1.0662450940370478,1.2757457719588341,-1.2453140141501822,0.38883081731652042,&
        -0.54644182711736322,-2.2373029124720825,-2.1523320180142811,-2.3840004442383846,&
        0.28318378977512504,-1.8910904313632777,0.35497341667959503,-0.29360247284708452,&
        0.26061176176517431,1.6630448104870297,5.6751178367926945E-002,-1.1773396655040342,&
        -3.3563533573742883,1.4367769297810069,-0.96064199918439563,-0.79325775444118385,&
        0.68024257982438097,1.0233986385139526,-1.9554964005541604,-0.51327130632280105,&
        1.0040180605570805,0.36856923344017245,-0.17664084355835108,0.30049339642714523,&
        -5.8383518374336384E-002,-0.60181118323683336,-1.1775529999025927,1.5507132775274495,&
        -1.4434200334800840,0.65319907570567837,0.28712216067524476,-1.3509434569383481,&
        0.72980009105457144,-0.90369637453317331,2.7433201459475987,1.0029257858059297,&
        -0.23944118973318912,-0.17037613339585961,0.90530621039692427,1.2889357987854393E-002,&
        0.64665779831722481,0.29202546043798217,1.3901751952265016,0.27555981499037774,&
        -0.54755490506866422,-1.1530481919414513,1.5941506989235825,0.14694854534861693,&
        0.50203205488005120,-5.0570076897767643E-002,0.72150397366120989,-0.31959468731741669,&
        3.7522125674750877E-002,-1.3861833410970543,-1.1041021389834009,-0.91458807303095302,&
        0.56947782962805149,1.1954139195437337,-0.74564965726098820,-1.9693882821622120,&
        4.4057639675240214E-002,0.20628777491551864,1.1518053114735394,1.5986092775360805,&
        -1.1972719309400390,0.41033096570202066,0.14934478547109037,1.2750566269639727,&
        0.81571442675352457,-0.24332666169249220,0.31760604678894538,-0.20138813808562206,&
        -0.86827566251761290,-0.27116476794808442,-1.1449980752092333E-002,0.95325193149926124,&
        -0.68322556146307833,-0.85537925370619394,-1.3661028647387998,0.71728596223054197,&
        0.85494402302455241,-0.41282550473597796,-1.2497509424144340,-0.35860376530009952,&
        0.31883431447332272,-1.5667896353983659,1.6639436857748680,-8.8610974997051783E-002,&
        0.78637201378230104,0.99506494282381575,-0.48026316059247653,-0.11380817499535142,&
        -0.41685169474016392,0.53110696933311241,-0.71546603703593448,-0.14040037054479601,&
        0.37157498423771174,-0.54382911723190641,-1.2979520712773454,0.46341380664983339,&
        -0.84236597891910558,0.43744548903353936,0.93165500379861643,-1.8065866399379029,&
        1.0495420574124492,-1.1658480373097857,0.48897201263060719,-0.32508219205073469,&
        5.4010671912237060E-002,-0.57099171928243397,-0.39832286754298346,-1.0924493647365126,&
        0.13956736768113492,0.74604682483632678,-0.74574603828376529,0.26224086037072569,&
        1.3389010908915169,0.51833704566194605,-0.52594738437861188,-0.46710815407165018,&
        -0.44780095294278194,0.48289318918024732,0.39634628705071157,0.92622106336506038,&
        0.64553398429466169,0.26329644983687239,0.55317167823451807,0.65607416665200569,&
        -2.2208735730848734,1.9259295921539972,0.20743251700845794,0.19096325494286398,&
        1.4272486954776664,1.4704202205540253,8.2923850025381787E-002,-0.57190109215361618,&
        -2.5782314087394864,-0.66041588984827782,0.50546045952348151,9.1963960612545151E-002,&
        1.9103604977765030,0.57281481836268999,1.6294578959400596,-0.85072306928445796,&
        -0.26794913406219323,1.3729085356065887,-1.8562446917989726,0.59675297078035905,&
        1.2225065050083781,0.68142673680925236,-0.78662371385527052,-0.26600619758405714,&
        -0.13071173585823967,-2.0499483282250639E-004,0.55643273864991549,-1.0293456994564218,&
        1.3180107584161251,0.61978392494083934,0.51679805058450756,-0.49714873414504340,&
        0.33277133747771553,0.30987502073305512,0.50826691779576449,0.21891186383167593,&
        0.14656670307777495,0.32640730582390892,1.4559406341954133,0.82479554688705936,&
        0.38778015496064838,-0.96298931698888901,-1.9713206433170793,1.4782157771186804,&
        0.25569187419174677,-0.78882086874214619,-0.39475682102270093,-1.1366639666706240,&
        -0.20310670948946830,3.6722190702349403E-002,-0.81674079427480917,0.58700151602126982,&
        -1.3958812739612905,0.46917079450445626,0.12806879999509654,-2.0385785566770727,&
        -0.57180029758371953,-5.7096518272241721E-002,-0.94221781826107609,0.98735880290144318,&
        1.0509587861153344,-0.20182302023051171,0.64231324464404305,0.41490886364909246,&
        1.7384710920768409,-1.7329457517975253,0.41043029945423254,2.4578106163468685E-002,&
        -0.87997897594584340,-1.8325805037171148,0.94618312256431714,0.45269152350360686,&
        -0.47022417436143144,1.1268443758419469,-0.72653779152484621,0.76638291306285433,&
        0.84669362925749803,-5.9426084633259331E-002,0.52127169399953099,-0.25025813156743293,&
        1.2158130829172478,-0.60669269463954478,0.64761903800245058,0.78567679274450519,&
        0.81143022524849118,-0.16348128531794062,2.4950961675697649,-0.88689851770961936,&
        -1.5257921448173639,-0.44347555087785556,-1.1636023443296506,-2.0566258018994570,&
        -0.37247010194478014,0.65437054001133288,0.86444948755776296,0.18771642577129044,&
        -0.23425171758653546,-0.52959583750322747,-1.2844202578485633,0.86393661540449584,&
        1.9414042846802342,-0.62646822440232053,-0.57285290746609074,1.2812605609697330,&
        1.5329412369843751,0.16107172943137080,-7.8030764489157287E-002,-0.52480137173871078,&
        -0.43522922347144116,-0.52565318984487430,1.4189478012023107,0.65433354088448414,&
        -0.53791786690193455,0.61961198284556884,-0.50973001072128277,-1.7630450419201862,&
        -0.73950228664042605,0.37839373068766657,-0.41995046702756067,0.21771200434010335,&
        -0.86233716082088541,-0.44852066896385767,1.5617469066324323,-0.39781050145421565,&
        0.63536224884952641,-0.69184385183022878,-0.53626044725583044,-0.71468224028999228,&
        -0.32770603065495041,-0.38336046878833441,1.5270693101728097,0.38412637043099140,&
        0.16446786393138293,-0.34967674749557864,1.3373558038867110,0.96506570543082071,&
        0.86302428283975130,0.52038837288043904,1.3699957832330203,0.54682707986134538,&
        -1.3588664178613137,-0.85730174871853093,0.79995787684257336,1.1245101334289129,&
        0.21621665598364029,1.2531466437386918,-0.58083330224890040,-0.88482094759406726,&
        0.27874564034087640,0.37524610570526373,6.6145788765792947E-003,-0.71337124369615978,&
        0.64065545659289835,-0.32104776424088538,1.2129536177784117,-1.2913999504047626,&
        0.12814605491289571,-2.1688220112852634,0.70078363317401871,0.53868119480437360,&
        -1.0140758972266339,-1.5449821729576878,0.36524499926507681,-0.57880536398977933,&
        0.26400246201906097,-9.6984837855713033E-002,1.5701755402993789,-0.17000880963250159,&
        -1.6198801754256837,-1.1857260223808337,0.72995268932913204,-0.24518835961331656,&
        -2.7940762013017637E-002,0.46273681501347447,1.3881046220645741,-0.66158621537667262,&
        0.57653312046879224,-1.8678913440009224,-1.4838692674701777,-0.34597795519380503,&
        -0.79915479477140228,0.22175828691113394,-1.3944148244480328,-0.35803889888896900,&
        -1.3761051319583855,-1.9784833262466750,-0.34114995573045276,0.42901794138677779,&
        0.46580418252427230,1.1629716112797113,-0.12416764697744272,7.7302512807929227E-002,&
        -0.87424342830658419,-1.2658442311942177,-0.56061306593207139,2.2353029402250089,&
        -2.1797984376665052,-0.95773859558315300,1.4364966846624321,2.2870307545710708E-003,&
        -1.0074636067045806,-0.44225343274743134,0.16025128271062355,-1.5302200747801862,&
        0.68998173767747706,-0.42208370378675103,-0.15983654777241540,-0.80224661051583912,&
        -1.5387427698463705,0.64319348693470579,-0.34810676656630141,1.2676157471596639,&
        -0.34378426180623944,-0.79607515359807446,0.85719722386507713,-0.54020071171139072,&
        -0.69048350989650420,-0.93546752794354604,-1.1181487549745808,-1.0194185395957795,&
        -1.0922343789997770,-1.3690558186831092,2.4418761732042804,1.7960030882270284,&
        0.50814686713480794,-0.88998634478792082,1.8187566974197977,-0.11503163730251675,&
        -0.49210062722480352,-0.38354405505598499,-0.48906736494766267,-0.84518197737809564,&
        1.7766171193166229,-0.63189009282246911,-1.7755179510152905,1.4495434381108132,&
        3.2295387102892183E-002,-0.55196773259452858,-1.8505505280304329,-0.50479191000363599,&
        -0.31599041993970206,-0.78962789555037949,-1.6153266842697547,1.1845402591901819,&
        -0.80268555532321106,1.0288506451389339,7.1519335303309256E-002,1.1829980952417123,&
        -0.44284858570592028,-2.8253099617353001,-0.67305159248024349,-0.96908959709976616,&
        -0.67174058398978298,-0.10124031699728031,0.26668092535753574,1.6959490216468247E-002,&
        -0.38304041212295792,0.16286023951324852,0.95399989764500770,0.14349279006043414,&
        -0.25295305109286359,-1.5369121601178070E-002,0.87610780560423140,1.1914034479159210,&
        0.14947555014178848,-0.90884970665173748,-0.10263665787357770,-1.4368606923230391,&
        -0.37197014190240230,0.11464110717145523,0.43047867421028768,0.22895760072543306,&
        -0.10516164291373128,-0.51021631428220782,-0.58995070425171736,-0.35608257767657053,&
        -0.44963624618120085,3.6894496319566587E-002,-0.23098286935501042,0.67196501627298966,&
        -0.23179240503337653,0.49888211170281760,-0.80522348155783485,-0.27092122894171344,&
        0.38701685726820190,7.2831952662988850E-002,1.3735655733763008,8.5832921514948930E-005,&
        0.41976346450833768,9.3585097118517632E-002,-1.1028324080962992,-0.28334809380997172,&
        -0.84335295778341923,1.1509795826659541,-0.95460559049639226,-0.91875704472932529,&
        0.42866018280742108,1.7210488887717217,0.76439265262215916,-1.2089412361830261,&
        -0.23756073268183989,-0.77473185934310684,0.58055724229076444,-0.97432812665462143,&
        0.61054034913628341,-0.88982349097508651,-1.0406827784203947,-7.4132636918481307E-002,&
        0.17780064132695933,-0.16333749220493138,0.75074511327090421,0.67671497710575612,&
        1.6072327568591633,0.54176353428376511,-0.97168983581861412,0.46989052647125618,&
        0.15630453887805706,-2.7855097039320410E-002,-0.72009306721965272,-1.1941078513082939,&
        -2.0937857980261683,1.0897308554248739,-0.49172678096882322,-0.19955712089813443,&
        1.0564063434469264,0.64223533517412912,-0.12637064787786262,-0.48297820345782133,&
        0.31174571349311797,-0.29926918103080175,0.16901808837361906,-0.93710392620167215,&
        0.32933442649278977,0.51992128643042468,-0.43271466564214767,-1.5064689175467965,&
        1.6564615669442422,-1.1086899702323934,0.44048507384056124,0.77863046008504477,&
        -1.1620568363132799,0.85358833022011715,1.6807536833410766,-1.3953590909948461,&
        -2.0952478514876645E-002,-1.1850176953599003,0.26103013135695374,-1.0353046361890679,&
        0.54692278713195819,-1.4450915676539340,-0.48000377075591988,0.46002831203740768,&
        1.0964012352603560,0.80062317951751127,0.24867144470065966,-0.88419998277053224,&
        -0.38470681564960141,-0.76156669208154815,-0.40445188406129629,-0.45660969998761969,&
        -0.38143728991507947,-0.50683597779661305,0.51814757658592825,1.2303072317520174,&
        -0.74965429271232420,-1.3599944251383786,0.37222153510785133,1.7104087446916141,&
        0.41972005868258849,0.53519839258738500,0.40442419890544679,-1.2816609660773672,&
        1.1457633092154689,-1.7804781960188873,-1.6620116596458239,-0.26811193355330298,&
        -0.43632251072271183,-0.97966981853384394,-1.0120264646896986,0.12494199958617956,&
        -1.1804877023398981,-0.79693222608727476,-2.6495363586554709E-003,0.14399376463387670,&
        0.20995290645327702,0.97311217436764652,0.14066255629468741,-1.4073095092924330,&
        -0.52808090032418442,-0.49065146746317945,-1.7235151121244214,-0.75145207791063862,&
        -0.91692522267408505,-1.6548348511846638,0.90369839829767284,-0.43308902858705711,&
        0.52904134857243246,0.57423395374088815,-1.2103546343414062,-0.73748953107500381,&
        1.0370544746499910,0.17793448767838141,-0.56517260089935539,-0.46194286175895821,&
        -0.88120439265203243,-0.89655874711216754,-0.51777209437027860,-0.25938903130815866,&
        -1.6611431381357789,0.95754767390421158,0.49053189336713138,-0.42007532951826798,&
        0.90089412599595431,0.83181907081292539,0.28139755889399376,2.4894427319566321,&
        1.0407244530009716,0.77708725637822873,-0.33430975316244305,-0.52968228305579212,&
        0.69293429436918863,-0.56396274170919447,-0.37233680469899072,0.89146979060631115,&
        -5.2533783397600411E-002,-0.17352624835140287,-1.0256872560665726,1.5184079670498607,&
        3.3478421396137562E-002,1.5585874358140552,-0.92396840627216759,0.60287036812575800,&
        -0.87193440002677947,-0.35917570329967563,-2.0086180931098396,0.55519326007496694,&
        0.67809394977479320,-0.18476822217046129,0.46101925867740978,0.66150296075101234,&
        0.54719166373582062,-0.31951069679709215,-1.1116151367629332,-0.28422055672734614,&
        -1.2888933683995194,-0.31094108287514244,-0.49298684136998117,-1.7735579256750609,&
        0.36654106130753644,2.0197025284598178,1.8139785681805622,-0.57525835637112421,&
        0.77736273009525769,-0.54482305127797437,0.65713846877514082,0.46684531234078785,&
        1.6181939721335270,0.29782747215365818,0.45302574457953509,-1.1129386797918537,&
        2.6089723258193267,-0.92833580942155314,0.67746577024152443,0.48073718445163371,&
        -0.22778247907582069,-0.61440701404000786,0.58865969504967230,-0.11766228784323728,&
        -0.50336763381476668,-2.3509913458343457,-1.1886348555446422,-0.72336536844721877,&
        6.5667891034274950E-002,-0.98442264358750386,0.10803556218439651,-6.0939228790185977E-002,&
        -0.85371273864251540,0.35039034513677936,-1.4143005059571907,-0.46381579821169039,&
        -1.2613339227313209,-1.2689745165519708,-0.75233314222324232,0.77067540597874429,&
        3.5857641173325870E-002,0.97199859487005658,-0.80181339007170693,-0.76040746849606144,&
        -1.3814738292929583,0.19293066011827967,-1.8288913871098385,-2.7114762107770334,&
        0.70192369826547163,0.74638569403816779,1.2099149797677311,0.10189655011097735,&
        1.1726433263312042,1.8636912667660961,0.80215622943433740,-0.39222987914211938,&
        2.1167600878042601,0.24982305015648057,0.54718247268950537,-1.2528097758246455,&
        -2.7875899750702575,0.12541782922067185,-0.58410229313930229,-0.63136567984349812,&
        1.7194157824427965,-0.40349975115481795,0.81608425726776412,-0.73536168971492732,&
        1.0489911555904667,-0.53784967697851649,0.67127253696454037,-0.54488973683701081,&
        1.2641901325523190,1.5003689787776640,-1.2259761371367788,-1.6622268952951065,&
        0.38112699703486153,-0.26964830977272852,-0.97930307959584617,-1.0129905880653380,&
        -1.2764221203782053,-0.80445998166564436,-0.23690657004023680,-0.51055067866535253,&
        -0.75648973131798924,-0.32089987832501871,0.42822753496754984,0.56113215929138460,&
        -0.76915003115457414,-0.55595659164084887,-0.13316984282884933,1.3335545327247795,&
        -0.83396732940412077,-2.0885933834233241,1.6134225351165112,1.1941836406632702,&
        -1.5564258899334988,-2.3712570751396762,0.99267121880635689,-1.4719686293108365,&
        1.2101983131958602,0.73927387574572478,1.8641861285455326,0.52371695055836964,&
        -0.87392956874532390,0.79561980281415967,1.0458924555369877,0.65098357090584447,&
        0.25187479958998116,-0.31967187060740354,-3.1669132630634450E-002,-0.65453430484540265,&
        -0.18257887442820192,0.76114137187965303,-1.0711833474731847,-0.44655800694576725,&
        -0.20099947910291133,-0.70772333555626710,0.83781833241529935,1.1944460469801037,&
        -1.6494810719193851,0.75353551075194325,-0.59201490782315946,0.36675076181414035,&
        0.63075044721089568,-0.20614302976217630,1.4370137590854222,-0.11447339376235613,&
        0.60152581489298707,-1.5140048514379068,7.9817712659790430E-002,1.0684856890209462,&
        0.26009798355068531,-1.9818456257329222,0.10381287434292505,-0.14813569074494592/

        DATA MC2/0.54151689084839305,1.2833793829417315,-0.39612109306074733,0.39018275764479504,&
        -2.3093233589290354,0.57130951736321733,1.9733374587556163,-1.3077454204758379,&
        9.8315542557498581E-002,1.3567609910410225,-0.10285774471695441,1.0068015653132494,&
        0.49066309735579516,0.73097510213764916,-0.52648471847282519,-0.10941760679022547,&
        0.64864186810638669,0.68289606043168471,1.3426551540973717,-0.86704656777245703,&
        -1.1238735396819601,0.67342501774452845,1.7284240288751869,0.30011087390410313,&
        0.41364367472548430,0.78268424705917772,1.1317218037618793,0.73159055026499820,&
        -0.61393540799204149,0.42310047113835925,0.77320566652574840,1.1954897691149988,&
        -1.5853175041032237,-0.28790009629210112,-0.11358369197334481,0.61968061799012486,&
        0.71907776531611367,-0.41645118265109338,0.13473061497418362,0.15066223713630689,&
        -0.56389822968576941,5.8946826325049197E-002,0.56653103645764025,4.0525409714504544E-002,&
        1.8531736720142211,-0.60913279304377832,0.80547467435066145,-0.23202895261648207,&
        1.5274226356045766,0.11119988165982717,-1.8551311293409609,1.9446106896905730,&
        -0.43005174656628686,0.22877317203085396,-0.16059346090405313,-1.6994252327010666,&
        -0.28687588848178941,1.0390552585526303,-0.46065813472497158,-0.84296336901711355,&
        2.5145897688305163E-002,-0.20960549236438658,3.3463055498415806E-003,-1.1127185995874558,&
        -2.7844092646567016E-002,1.4297461161980589,0.34404417535930665,1.3095601544960511,&
        3.8283813738677452E-002,-1.0000153876433988,-1.0144986097216866,-1.3247321979970870,&
        2.0075357666788527,1.0710539733610569,0.21280653052707912,1.0455152307389171,&
        0.12914228483745335,-2.0192543403806238,0.24822201032844138,1.0242798802481776,&
        7.4365813141575643E-002,-0.95881185551198689,0.96643484225931720,-0.24073749879886414,&
        0.44013746705242440,-1.4889265052830769,-1.5112501595525640,-5.6913772753896660E-003,&
        0.38311223828661861,-0.94040047748457800,1.0218438007074921,-0.59893872245939161,&
        0.37850144055968166,1.7570141492918077,-0.46441621938442645,0.61682173098341597,&
        0.56258756436111268,-0.45340011160425525,-1.2070416098376873,-1.9220076010959575,&
        1.1614670083051528,0.99905921333444259,-0.14539336195296634,1.0548752281210920,&
        0.20937692135047176,0.67011158496850143,-1.4190786345970763,-1.0194025609314783,&
        -0.48760133579062442,0.35146599977898024,-0.23397553845241775,-0.30909350853143208,&
        0.65295151897059089,-1.3615354786209342,-1.3597817902194202,-0.30518773723239873,&
        -6.1237074726701222E-002,-0.10600087642282113,3.3792370866224797,0.20995199368923037,&
        0.50259433711755153,-1.7307320814410905,1.2326606419905703,-0.78647808213197756,&
        2.0515674669266466,1.3074155991124669E-002,0.53885252528146299,-0.26057772422570735,&
        0.33853297547487976,0.34634197503387593,-0.36318095698107788,0.33437317651007731,&
        -1.2172641596945533,-0.99871089857582074,0.96569143634214261,-1.0377960742796761,&
        0.72653152602717852,-0.61117485314229714,1.0589574035347020,0.39450514192379244,&
        0.60578818591573491,0.14500277740097667,-1.1421124149695323,9.6220663380539306E-002,&
        -2.2929649878964620,-0.10700766714232614,-0.63961252908670019,-1.3664633344780159,&
        0.36784576585238088,2.0769951763699868,0.43913020958837579,0.14765661580141914,&
        -1.7881398001388389,-1.6664959642128673E-002,-0.85771734892225804,2.2968276010336068E-002,&
        -1.1574062669944458,1.0753974213353541,-1.9961257813890876,-2.0095237224479430,&
        -0.93240608149477311,-0.25329133814597971,0.29277960253748142,-0.16515988778723054,&
        -1.4132789362042457,0.13539239637517758,0.33521921089476353,-0.24356543797397109,&
        -1.3475784251860869,0.29914679902791708,-1.1006594713121820,-0.84185117515451324,&
        0.21853386369344227,9.7549087083224628E-003,1.1920902142658760,0.65378817633529107,&
        -0.84624705247502874,2.1597134669965361,-0.13034901407750493,0.67880161285063023,&
        0.21744663019793981,-0.79612419355904385,-0.28099125926992841,1.0812404386862340,&
        0.30193834164697092,-0.85155148393309665,1.5245515455811067,-1.7400279048955221,&
        0.53066286713233712,0.31348682164721742,0.11625567565339583,-0.30950702417759818,&
        1.2564897003030155,-0.16962308827335956,-1.4693736105687729,0.52261623109706112,&
        0.60484979008859319,0.49805557248746263,0.84318272073532496,-1.8479260264002380,&
        -6.6386073409118781E-003,0.44574541233368514,0.13657609746507052,0.47536141002657722,&
        1.8926010090994565,5.1118582383405234E-002,-1.0061940191677248,-5.4432395471525265E-002,&
        -0.65952307317068648,0.33722763705148090,1.8727231804981876,0.38741930690807924,&
        0.46361342135988565,-1.4781147219820512,-0.34654406801923088,-1.7871697094014107,&
        -0.70640728278424947,-0.14045041641875297,-0.74177319372829631,-1.4552640531881631,&
        -1.6847612136486276,-5.5505791840919687E-002,-1.3995767247057902,-0.55217685577055031,&
        -0.54279132751165393,-0.32407809090751905,-0.50226953007575881,0.76784694171284629,&
        -0.40401315493397255,0.28484799254881077,2.4325068340603253,-0.42344764729072182,&
        0.53888709038899263,-0.24179733003186446,-1.1701110360586835,-0.41902694695159859,&
        -1.2083885727132440,-0.26330582192881985,0.64110989016276565,0.38838912771506728,&
        0.55763460875895976,1.0857549245307077,0.23357862011769354,1.0151550080589234E-002,&
        -1.0331980119465500,-0.15833014627596395,-0.18368912746855942,-0.12470029989925099,&
        1.2271688899399114,-0.48898818003008132,0.39142672679678558,0.43223774542115606,&
        3.6041381962837134E-002,0.32945930062617518,0.89017505889459214,-0.55556935735796775,&
        6.3723296594677709E-002,1.5073285968537340,-0.74107710004661242,-0.64930296412014377,&
        0.19525834056838223,0.36650981822380768,1.1769076773486173,-0.97459222473998697,&
        1.2444821740263705,-0.65122419368852635,-1.8182419992339263,-2.1291031580007993,&
        0.62117280302218425,0.48809372247130811,-0.13044256007048977,0.26155817837538686,&
        -1.1667428862260689,-0.11138597131866632,-0.99014296354540876,-8.6239336133015747E-003,&
        0.18929387567005693,-0.86734344371050842,2.5642370173123350,-9.2908200931265103E-002,&
        -0.63354742522552865,0.96407903986810994,-0.65247310908868472,-1.0728593754105751,&
        0.69303180070381976,-0.45472073875155916,-1.1145354420251843,-1.2605898329741543,&
        1.2455037378282618,1.8422979018133567,1.6680068150885596,-1.0372215568357941,&
        -4.8602919895527626E-002,-0.25323730919599929,-0.67155662460815380,1.6167984801441189,&
        1.0228549500498394,-0.40304138384566351,1.2391109417809523,-0.61880340740983808,&
        1.2135933010755275,-7.1494359196454804E-002,-1.1296308629538130,1.5170425084816952,&
        0.59056309062616008,-0.49943993355367117,0.17502234821850185,0.81997755019811502,&
        0.68690763532976529,0.21165114314528016,-0.66282946703544443,1.4864718880312193,&
        0.26030648615054525,0.62590300886593153,1.4041669670140948,1.6008647438991013,&
        0.18543945297149850,-0.94982257433804074,-0.47692508451581517,-1.3290564764604493,&
        0.14471094608736634,-0.89421364048575236,0.35767743219657855,0.42088592492808147,&
        8.0937821853258582E-002,0.44390152100029767,-1.5725292188967712,0.77945660356166668,&
        -1.2344360284623110,-0.48245101523228406,1.4369066120993730E-002,-0.51940232871399483,&
        -1.2939457342264615,-0.11371942520720722,-1.0513975046989474,-1.3334696354483928,&
        8.8981515294392799E-002,-2.1845348564081575,-0.45878509178215832,-0.22641341121813469,&
        -0.12038664588607610,-1.1012276383098067,-0.72789369388917202,-4.1402416178856066E-002,&
        -0.16189664812786017,-1.6398856907881092,1.9237637349190548,1.6317399004260291,&
        -5.6610941455968913E-002,2.1796877987372905,0.33603201727650334,-1.0410735981757979,&
        -1.2957669985304137,-0.63524345878838429,0.30713473776727157,-1.4327139934880293,&
        -0.87202805293125196,-1.3822192442461001,-0.32497305716429453,0.47456340229695004,&
        -0.40134875144930648,-1.0141978541772567,0.51147271058807831,0.11685195106883747,&
        1.0829132211071013,-0.18106489169717566,-0.89159407889372033,-1.6246557492352167,&
        2.0244768484427418,-0.98175968281372872,0.40096028671761358,-0.76531845503368112,&
        5.9899915243173056E-002,0.94306562875514066,0.26765352779056539,1.0543756646677005,&
        -0.40527689691843100,0.79942144043258268,0.12848038571702952,-0.82880379897648027,&
        0.89260802559886154,0.54404756865324866,0.28766267139764140,-1.7634218847077332,&
        -0.26263243336943110,-0.75682887682962119,-0.15692250529454752,-0.80554872740307992,&
        -1.4496870025331410,0.58671609792169810,-0.65581736988860895,1.3873456305818312,&
        -3.0367740860659120,0.67032480860206700,0.38381030637621333,0.42277700283678232,&
        0.81298772484469184,0.23723614858581715,-0.33820563973179468,1.5079600259057990,&
        0.11830973753636266,-1.2403639051130704,0.77122209849281009,0.95326879799922271,&
        1.7502309752469916,-0.99168886136993706,-0.69913639907901259,0.53505278595620231,&
        -0.33693989156695348,0.33157286516523965,-0.64056206648007141,0.65074707048864133,&
        0.17177310969505263,-0.86171997504113462,1.3170903417547006,0.14218750382262027,&
        0.85090447571110783,-0.69598314607811140,0.26162183295733549,-0.84647137374007952,&
        -1.0686333815204840,1.0476150137381717,-0.54958314583019541,1.1721193356387551,&
        -1.2539893043744925,1.1625323956231746,6.5560691363694745E-002,0.47886665503125353,&
        0.56925237935881468,-0.67510352335339963,-0.33434788568003454,1.0321978843329287,&
        0.90196735265289274,-0.84352777854768179,1.3303775803666311,0.14765702811509385,&
        -0.43662552538228944,-1.6663063541339320,0.33240630201885635,1.0083000408387837,&
        1.3659283744060340,0.55707267285336115,0.89235515554733258,0.57319410301628371,&
        -1.3540394838947112,-0.21518711360238280,0.27856250518103165,-0.74524732946874683,&
        0.68911253013160334,-0.76920005971150784,0.20755524806654507,-1.7610163725353181,&
        0.99776048928725758,-0.10758977101695197,0.22229125342085948,0.51225010579288366,&
        0.50138288524632912,-0.85867809374980764,-4.9098481990139699E-003,-2.2313596930005071,&
        0.47451485763981993,-1.0082521253120542,1.0449991602232604,0.39467611616492859,&
        -0.38523661639792683,1.1924109137909289,5.3813678915487842E-002,0.38020379147510935,&
        -0.11785428029423099,0.39573040418856537,1.1711756650146303,0.82494313344358816,&
        -6.9182935408480001E-002,1.8643502779419487,-0.97002006183020262,-8.2230332335791634E-002,&
        -0.43008775339537064,-0.70029265215521519,-0.57899804326639936,0.35585793913662139,&
        1.3355951417002818,-1.6869373341785157,-4.8747326348257743E-002,0.11516138321098093,&
        -1.5656894525306508,0.24299382875071115,0.34363878235402873,-0.17727176444823262,&
        0.12812098778392328,1.1004826987146903,0.37012850551300824,-8.2068272931037731E-002,&
        1.5081663392176416,0.87647437062826772,-0.22170393884855102,0.43767902288109889,&
        -1.2557383785441101,-0.88525627833789866,-1.4636998434540291,0.11055307507636038,&
        -0.93737855334893827,4.8285401321515278E-002,1.0174100708138529,-1.8350548002578320,&
        0.24919751008776900,-0.92843409938361432,-0.16927753862732337,-0.26303779845648162,&
        1.6819165452464448,-0.58073621532469533,-0.51766050724476220,-1.2982419817600259,&
        -0.70656584122712096,0.39906284565900924,-0.27004719914980596,-0.59693585782353387,&
        -0.33785016818706565,-0.99452935212122306,-0.25190698834329428,-1.2623800459546102,&
        1.9638881513538602,0.21835538447993136,-0.65091409163491498,1.2275019696054150,&
        1.0379717160841320,-0.74454542558563064,-0.99472120930342911,-0.80776043577984269,&
        1.1045498567921725,-1.4529635567354522,-0.25245272878701430,0.46895169744576332,&
        -0.76873952923164968,1.3957589132064641,-0.71043304046088418,-0.30884179176172810,&
        1.6491454897222644,0.30620087886360398,-1.9790424786771010,-0.39473130891215569,&
        1.3499513038266429,-0.75853899439444639,-1.3032542414091473,-1.1767996992264627,&
        -1.7394927444648627,-5.5488126215767833E-003,-1.2632341361793122,0.14276551723947786,&
        0.69843131289890137,-1.4571982351730024,0.60005183226934533,1.5203653096528691,&
        -0.49111179252659259,1.3747407228623261,-0.15580409259147115,0.27752213260908332,&
        0.47500205668171114,0.79342616698601287,-0.22892197213576237,0.84391563749056764,&
        -0.96617813277911979,-1.2791465392595625,-0.88376333974337329,1.2608317871865848,&
        0.12128836038012675,1.4244420382962666,-1.4794411203655768,-1.6921292547672884,&
        2.9829833640026955E-002,1.0082468824416797,1.3311581120592564,-1.1390622097879444,&
        0.19158656532891774,0.69411667077624695,1.5266133664980930,1.3652601129167601,&
        -8.3829220072888469E-002,-1.2659431979158144,0.71708420490387881,8.1118114579457071E-002,&
        -1.0406221335887649,0.86747193336583239,-0.91432297655531636,1.2221292986966199,&
        -0.49365924387841442,0.38774223938639812,-1.5057471894532022,1.2211016167374837,&
        -0.78159906133186519,-0.75085929195957046,-7.8358691896327257E-002,1.9337192154329406,&
        -0.10422471076046602,-0.52112264674409470,-0.29747769677933344,0.97210124822366839,&
        0.49536308844790566,2.3403073462306483,-1.8491568922541253,-2.1885522546922007,&
        -0.45227876595263772,1.1411898147135675,1.1748055664203596,-1.4711292712894377,&
        -0.79814280487776013,-0.26840730697951487,-1.5083052040453910,0.68915742047446715,&
        -0.42463559332984552,1.5151952309293657,-0.39172351965824592,0.72666088213006574,&
        -1.8588033627742264,-0.90233959089077254,0.64494525951127601,-0.19939895585906658,&
        0.81827643455912680,-0.50081257942965407,0.68018885160254439,-0.27631273602337131,&
        -0.40064636199863846,0.28227902105280950,-1.0881643791197857,-0.18622320436343742,&
        -0.15089813745255345,0.36677933625221504,-0.14590001107298531,0.82717051670217556,&
        0.50243531098156535,-0.15347021116095261,-0.68065127127927227,0.96363638541606955,&
        0.17407537556321032,-1.2391015751595493,-1.1853729641582855,0.34733271973663693,&
        0.18009868093771644,-0.53018340934053154,1.8256932434871900,0.25553394655055911,&
        -1.4153176525943252,-1.3086213792930828,0.55214133911097785,-1.4294207042865326,&
        1.1816927441285765,1.8417198972533424,-0.82661803258237188,1.0355733489168979,&
        -0.43605261453984651,1.1633670122924022,0.85782340534149293,2.2920999840161094,&
        -0.12406027441939259,-0.17263311680391452,-0.76388427010343984,1.4962720310094411,&
        0.98924509891687729,-0.82324453444603130,-1.4431267867775928,-0.34834202518996871,&
        1.0401233160520802,-0.10127249781397418,-2.0074986758306239,-7.4210459474008561E-002,&
        -0.21658077930145475,1.6018866077070426,-1.1391095539535068,1.6158404873731989,&
        0.54991086940773692,-4.2024363943178142E-002,1.0226405469089210,2.2916860470506117E-002,&
        0.81289546713285277,2.2448673869950544,-0.99404419115638143,0.56792951180831430,&
        1.0381280592627253,1.2765969816594191,0.62826642880100259,-1.1680144922075315,&
        1.7461307080333857,-0.29747131657978432,0.55179427257454927,-0.42785662167940675,&
        0.26713654609656157,0.99350693318677008,1.1955477134807877,-1.0147218337446338,&
        1.2230155733744859,1.8052150236836904,2.9395014459526849,-1.3157159615570500,&
        -0.27293818404069348,0.37273805975209340,1.5936970827997756,-0.45157916735266806,&
        1.0234237043568688,-0.69945963976603742,-0.71226439040400491,0.59284980428298406,&
        -2.0040518595201919,0.75164484556606881,-0.70499235661963977,0.56409970854745028,&
        -0.37404647631298082,-0.55206181724425152,-6.3749322986263570E-003,-0.54570791750753622,&
        -1.2323370305068013,-0.70491477221879384,0.39887273589619587,-1.5249552203913728,&
        -4.8862613054792503E-002,0.84760749567580607,-1.5680253497157508,-0.10705175810557188,&
        -1.1318615422137410,-6.3307283123963165E-002,0.59019958399786621,-0.93747006445235403,&
        -0.44550100310423241,0.38370536333241384,-0.89350430805436820,-1.1354373740794801,&
        1.6949453549095101,-2.9569545562502325E-002,1.0642926864166207,0.21618910738643105,&
        -0.55704267879274894,-0.68354604954747666,-1.2875877117912498,-0.62245949497841047,&
        -0.84248353792762032,-0.76305033203628392,-0.91293627921208198,0.43649878924902275,&
        -5.2675142214887165E-002,0.80317694679417018,1.0515787987095575,0.96427140624606134,&
        2.4658252043853853E-002,0.82667285635685228,0.55678394926686325,0.32851925836521823,&
        -0.16773861485642028,0.63433964740427451,-1.1911009461538828,0.95057664660907293,&
        -7.4457265840342318E-002,-0.45177981360824659,0.65627033364662335,-0.87133561014379124,&
        -0.45292504381522536,-1.3853354477930173,0.93596751520688481,-1.3194940772356973,&
        0.79031402780410309,-0.48886220558416488,1.4783848997665410,0.64053695699731727,&
        1.5799451782805494,-6.6469114412591845E-002,1.9379675701668673,-0.83639285094713178,&
        1.0340328018034033,-0.73194858691859266,3.2904424680944219E-002,-0.40764895343123719,&
        0.25986951866460656,-0.36538501637159776,-0.18814559185237190,-1.3381679099904487,&
        -0.68444506572808972,-1.3359852455883257,-1.0000419849068711,1.2272090668031501,&
        -4.8425722965207744E-002,-1.5472271875907222,0.73633697423612110,-0.40153646517564334,&
        0.89129062032025230,0.41048816967878266,-0.20742044770268100,-0.97862553870615954,&
        1.6757073093677868,-1.4472997277319228,9.5538747825484327E-002,-0.33313907716539604,&
        -0.56982077944446863,-0.29201406119141721,0.95309289391997887,-1.2427377833961535,&
        0.48477352975219240,-0.16186647469552770,-2.0349813266021779,1.6432518735942965,&
        3.2459145623419949E-002,0.18727521323337756,1.2234602178454981,0.72466480244325293,&
        -0.16110642717521648,1.2915158735617711,0.70034145890091104,1.4478708870860697,&
        1.0975663453707794,0.78200417346664863,1.2784527067448330,-0.96858146576764015,&
        0.95676273176679816,1.1446120976307586,-2.3747652081680788,-1.0468826293039679,&
        -0.22699372594894718,0.33716768050089430,-1.1255312404627340,-0.43548859688517194,&
        -0.38954965885598669,-2.2628766741436568,0.23193709734056916,1.6801365049648047,&
        -0.39665073484524044,0.31179414203957562,-0.74829273685473552,-0.45771582980631298,&
        -0.72556300719291622,0.23496431548406246,1.5928067349554531,0.11280234271913479,&
        -1.7657838336677956,1.4516589925931693,1.0261837797057431,-7.1073641311387770E-002,&
        -8.4087119741166658E-002,0.19853924376577128,0.53952139795509813,-0.37408275477716307,&
        6.5382323486182933E-002,1.7448106515001860,0.47777949740348546,1.0338581836432916,&
        5.3397126006184369E-003,-1.1841410291966401E-002,1.6676909947800316,-1.2889585841463505,&
        -0.12337909049002778,-0.78068935806537243,-1.1399594427721176,-0.18041141499684413,&
        1.3882856058974589,-0.53612498913941353,1.2749681845005063,-9.9016696028064788E-002,&
        0.30963695258551704,-0.76737807200886754,1.2039792839406003,-0.75568370559414755,&
        -2.1159571033527866,-0.24897039110806821,6.6451106781418648E-002,2.1477368258080967,&
        -0.30306405036659279,0.12093643037894193,-2.8623671000139708,-0.80598743796917116,&
        0.38096035047630133,1.0138086837651097,-1.2089927911861396,0.86549405558627501,&
        2.1357733137709349,1.5073815577970022,-1.2327932615038699,0.62805511957234750,&
        -1.9142856195160673E-003,9.1160151428302083E-002,-1.4616608244483869,-3.4154943486732994E-002,&
        -1.0710129478627646,1.2488275510432423,0.37930961008701108,-9.8574745692924598E-002,&
        1.3692628420755091,-0.99317251212106317,1.5308213354162983,-1.2787631441459923,&
        -0.53654448192144399,-1.0086355011653783,1.5886589735136816,1.0496370818878311,&
        -1.2289262953152649,-2.2172865832234225,0.71511396004988115,-0.13526171104409457,&
        -5.5969650249529580E-002,0.91914805597653448,-0.13887026394224225,1.0716830401461348,&
        -1.3176851762064414,0.18599937273566503,-0.32345170794905753,-0.10214419698833654,&
        -5.2014431035806809E-002,1.5034249350025122,0.40489547202485521,-0.13097201493178640,&
        -0.23549567698381152,-0.88568548293755101,-0.16617577545377968,-0.84953895934807455,&
        0.47216182503470949,-0.81610673907256559,-2.4812174008026866,-0.32700214348155032,&
        -0.66631735526426261,1.2690609609807921,-0.68231162700704562,-4.3868335116116665E-004,&
        0.39596044747251047,1.0901709528102337,0.33024092346924105,-0.22643413998123069,&
        0.84236097177846969,2.1958345559544670,0.95318321350002655,1.3021836355302860,&
        -0.17133296407945142,-1.3256476422889949,1.1256321876230113,-1.4046813854198050,&
        -0.65108371635608098,-0.93934321841663559,0.76088515155084324,0.71154306244980092,&
        -1.7050543733918153,1.3241509660417514,-0.18848197115334756,-1.9720115511167486,&
        -1.1457300219368936,0.84354752305253167,1.1423868097595598,0.25355146357319713,&
        1.2404960888344654,0.30541930416602214,-2.0844603344906367E-002,-0.19093467956959848,&
        1.9680588241242578,-1.1521186090174951,0.25216093964804209,2.1858228635327608,&
        0.97747676443107101,0.76064053724572811,-0.77439961971170401,-0.77510682312376411,&
        0.63914721099094596,0.76752965326972111,0.44373899012361895,-1.3308978288919779,&
        -0.24413409580573561,2.0567021628024968,1.4979021956679710E-002,0.81318168753204256,&
        -1.8188812998765294,-0.69872696454545868,-0.82292213162110783,0.54410684861635061,&
        0.93874033585236372,-0.60364819606109921,0.38709352666471725,-0.16494472364152035,&
        -1.0168169425645119,0.27351784918905253,0.17245244268530280,-1.3684654063302157,&
        -1.0559758044765142,-0.49504382815715886,0.77904142810925847,-1.2651399661764076,&
        -1.6843865538728955,0.78232988785511404,-0.96726947452387679,0.29159609685006410,&
        1.7862338902709809,1.2849367304529073,-1.9138449172580707,-0.19089377252953155,&
        0.48943664243359242,0.38928437326132043,-0.48284494183136634,-1.9211649398299531,&
        -0.27774259265662549,-2.1597153829701394,3.9321024851511816E-004,2.9193379324657664,&
        -1.4628724896711987,1.1167615741361285,-0.28956450205832873,-0.69766103375001709,&
        -1.4576458152348091,-0.58651465980111284,-0.27517413248210909,0.69819676084696736/

        DATA MC3/0.20062725899181022,0.13618595895559427,-2.8486250260438526,0.20652190889345079,&
        -0.54096129690799355,-4.2442278271690045E-002,1.2206860500957872,-0.57245733335598337,&
        -0.64802418662764072,-1.4793728652516847,1.8959721254219485E-002,1.9797521132850479E-002,&
        1.0603476961223341,-1.4222338202298839,1.2119554320264774,0.50330413593308543,&
        0.28119111230069022,0.96057659440325072,-0.70325748781915220,1.6238045779852728,&
        0.21760486393243250,-0.45748713639586946,-1.0038299618167219,1.2223161823805453,&
        -0.11439345470065344,2.4138207644859793,-0.11880099178275516,-1.6702433105435488,&
        -1.3297137695736934,0.10809193574249454,-0.91493869376748660,0.95105235211850858,&
        -2.4070947291568414,1.4234999227104232,-0.12871842817836834,-0.14042652965242952,&
        0.88395447790746851,0.30246351006554145,-0.75300213078633238,-0.51543851981273525,&
        0.56149044284135752,-0.25466394668997477,0.60405184731069206,0.40642634637497144,&
        0.32956323509865693,1.3705788442979825,0.94844592472141254,0.58112106906305372,&
        -0.74636318472157970,-1.0085999247193811,-0.33743275472601708,0.32412470371716889,&
        -0.20628140418928309,2.2623191235050402,0.12543994326418764,-0.76203461848965715,&
        1.3701110664607377,0.83837388483286990,-0.58116490504436258,0.33569435603882580,&
        1.9853274576305686,-0.75127812971063845,2.0311168677211695,-0.32780632758109979,&
        -0.67600805247687512,1.2712373898152274,-1.1357938351192183,0.22674608852814113,&
        -0.35203854991439493,0.72523779375969899,-1.1646799009293125,-0.80546843389257372,&
        -1.3091637415701411,0.44674705217621880,-9.3271062474074282E-002,0.65801353773291749,&
        1.1462366844578786,0.22865830623754063,-0.57547994503570177,1.1894000980507029,&
        -1.0626905020286119,-1.6936969410230280,0.78774665158228674,-1.2231287224078777,&
        0.64558331915784395,0.54432934618654605,-1.4033535793084877,-1.1142006694518685,&
        -1.0782833663267659,-0.56111477089664030,2.2191378297148484E-002,-0.38948008255347777,&
        -1.0695616249680342,0.33813517539342502,0.89426046169733986,-0.41417279814464258,&
        0.15782685174133301,-1.5119372863601312,-0.70372577022962501,1.7538747997481017,&
        1.4502721318380505,9.4673264898254644E-002,-2.1407644712584224,1.6240591561782121,&
        0.86664712954508305,4.7068794504369738E-002,1.0336382862690006,-0.32047203877750829,&
        -1.6837330339223600,0.97184613586787039,0.49473932711822100,-0.59657332656309947,&
        -2.0205798619806519,-0.15727296790618439,-0.11984237142204403,-0.80117650760153314,&
        5.6049278306983322E-003,-0.86147268308974811,-0.54649637065148382,1.3596187871414513,&
        -0.10716007125217458,1.0825398675634437,-0.73840751378116209,0.26445225665517746,&
        -1.3866304117859647,-0.18039979549178939,0.32977508952490930,0.90899856189572326,&
        1.9390147224672572E-002,0.23558199800467589,1.0803541765208917,7.1306942810302407E-002,&
        1.2962556336608764,1.2748265232457545,0.80904050818399287,-2.2544845093203967,&
        -0.29254568479832033,-6.9632518556608083E-002,-0.31940264436603272,0.82473050300677175,&
        -0.36199065029805910,-1.2326956508718883,2.0877608074620477,-0.98127313343932332,&
        -1.3643589231893689,0.39899983232231540,0.90811219834009660,1.4405174666449292,&
        -0.90455016715650849,0.60473047495270005,-2.5929548224429916E-002,-0.36383026642850380,&
        0.95560744521696928,0.69379139543448554,1.5773478998886412,-1.9096898496214481,&
        -1.2081797015731621,-6.5170091828648913E-002,0.77795916095037820,-2.6961849896389709,&
        0.24901584652034423,-0.56834724755706312,0.51645007417670985,-1.8880494673264065,&
        -0.90364213554286033,0.79194370268110170,0.90454756695723160,-1.4681004104594602,&
        5.3453798459437311E-002,-4.7197948036451699E-002,0.75614858448638755,0.81760106449163106,&
        0.93195520269071264,-0.56998672196078581,-0.61814236037979087,-1.3013942090296986,&
        -9.4658774380668720E-002,1.2617656506805739,0.58945662658835851,0.10667435889757652,&
        0.38934512888808243,-0.22531469793757747,-1.2671236235494003,1.2912436183458746,&
        -0.43903345038539399,-6.3322056745213615E-002,-0.58111825562933961,0.93704459384486782,&
        -0.84351012106315015,-1.3084399741355250,-0.70026920453752572,0.66599208197019011,&
        1.0727577777314692,-1.1745668694203215,-0.82943315782111848,0.30992992789584384,&
        -0.88830579928303421,-8.5935972998546023E-002,-0.70423551334322276,-1.4394703599333398,&
        -2.6374822127253461,0.51718437103343173,0.76119348286227906,1.7022374523549646,&
        0.61640644372351461,7.9608299202809332E-002,2.0872526218749758,-0.48316755126277577,&
        -0.83800025037524684,-1.3492711850020558,-1.7674654477929181,0.42376139473056806,&
        1.2054262963544504,2.5340828377950357,-0.33951205795004408,0.16654579376027620,&
        1.0518414734452959,0.45515297159665657,-0.18051600148593197,-2.2157915491243737E-002,&
        -0.19861433026421291,0.61560040067006372,1.4394965131350412,-1.9355001496324014,&
        1.0772365150165570,1.0752049629750886,-0.85191406524747759,-4.4168907887340368E-002,&
        0.67552815186378501,-0.99681717358481525,-0.39136460781346577,-1.3908185912567368,&
        -2.4585909045688532,1.4581589210861419,0.78618432624707124,1.4320718428083898,&
        -1.0528667023556182,-2.5926354540963491E-002,1.2256669981648014,-0.87829452693180443,&
        -2.3510551095519006,0.15638363450831855,0.44376193662115948,-0.74468613554738039,&
        0.83306390678860531,0.14373102459923628,-1.5293977751568342,0.13924693264934940,&
        -0.33253206921711520,2.4873922344414892,-0.52435636082660575,1.0583031492883757,&
        0.57505916462436479,-1.3055013626663867,-1.9866678424669619,-0.57758130256489326,&
        -0.65667217640412179,-0.60820437151409590,8.1699166642943272E-003,0.74081639042033742,&
        1.5725699188689055,-1.3058377830070200E-002,0.77875321225507455,0.97747610572520083,&
        -0.81682603056890091,-1.1463731150104333,-0.52527616655567289,0.17327088618997313,&
        0.55798694533605453,-2.3035088325831934,0.15018633468877154,0.40142428426227517,&
        -0.91036863704428506,-1.2664948676892840,0.10367746291654605,-0.68044642719445358,&
        -0.70928169169468824,1.3367512871300422,0.47994647151041603,0.74545130578963503,&
        0.89412969988765156,0.13319127340879799,0.46209714840127064,0.59156070760973589,&
        -0.44878846212746520,-2.3120490988242453,0.70453057252537132,-9.0276046923842709E-002,&
        -1.8391943886244972,-0.41728702070892232,1.6805296829639476,0.64772560920608191,&
        -0.58402882190847838,-2.3167039174733164,-1.0238938902967207,-1.3023290960231269,&
        -0.39315708834409135,-0.64537544615583142,0.75917474357974035,-0.45008466083702769,&
        -2.1773472329008614,-0.28965641126790742,0.16065172728041413,-0.32634976244519875,&
        0.14911578106996545,-0.62010216000057583,-1.4144170822940891,1.3021552831545666,&
        -0.24596634281212959,2.8793921119729315,1.6711685531617042,0.37895527201916995,&
        0.33649687921576671,-0.10170254653666999,-1.5635471480500001,0.39232462609607649,&
        -0.30020565604271798,-0.39014273079209194,-0.83119452097163304,1.1613220752929008,&
        1.2119683784340785,-0.96494734572711593,0.59756502327299099,-0.83773359137726000,&
        2.1459720209298894,0.32922084074806518,-0.52820184624405897,-0.34743219896255573,&
        -0.99453668554875341,-2.1355234678536270,0.67061348950571698,-7.7249905799478755E-002,&
        0.96074501890215291,-2.2139387210221804,-0.94549971499651653,0.92827641992187115,&
        1.6274860068790709,0.19704712863360971,-0.97707310694051974,0.10724541097595056,&
        1.1387578377646863,-1.8529265844518041,-1.5688587295411962,0.36968909965040209,&
        0.76617300571497637,-0.28128688586832923,-1.8695031918857850,1.9069631015586521,&
        -0.69016547184689958,0.67502232335483880,0.43798188747355443,-0.70120182882761350,&
        1.6378554640591676,-1.9252540398766422,-1.7532452356186812,2.5731246296436288,&
        -1.1546864482304258,-0.75457594648429005,-0.30515975468704520,0.88528716269342755,&
        1.7463950706256266,1.2331356657818082,-0.30730241385498647,-0.17457839710382739,&
        1.2603663945686892,7.2901929930752826E-002,-0.74063286037680631,1.2817268716334829,&
        0.86408315731503516,0.61487996874807338,1.8488004034077428,-0.79559482749635702,&
        0.60312152962669019,0.83078110371340630,-0.40320871567999267,0.59150859094890385,&
        0.84547749594825727,0.64713196228647685,-0.46548797710796064,1.7281603875062213,&
        -1.4534959513019847,0.58211927114264028,0.11408300810824851,-1.3976139721226362,&
        -1.0974294610102615,1.6281216620321250,0.11100331123045910,-1.2517014417511356,&
        0.60151097484474980,-0.41371884724674424,1.4596896068572238,-0.32737768413643847,&
        0.44997450253566179,1.1425758494440319,1.2465771674684325,0.63846018244065350,&
        -0.51822045719455845,-0.18255301694824971,1.7566303478652835E-002,-0.40452260588371480,&
        -0.61501764183948227,-0.19182008281728255,0.61739123946185392,-0.45896994842399907,&
        -1.2015286013050888,0.38699261916260486,-0.93271529585634660,-1.2085857127597013,&
        0.54843559323258184,1.0786672269347095,-1.3829003945056264,2.1399825489254671,&
        -1.1721098954883515,2.0671708259897645,-0.68907136422549220,0.93153248818024648,&
        -1.0497903115086133,-0.17094817389695396,0.62445504969705579,-0.37754171278310067,&
        0.83213848954073577,0.25728311124023273,0.28942551522338539,-1.1335411518715339,&
        0.57709746158085884,-0.24792910365442422,1.2651667982679653,6.8129280157170582E-002,&
        -1.5364537597404107,-2.1703894877431438,0.71006168672862324,1.1724559695383159,&
        -1.6536876905865288,0.72738481159204660,-0.93955072610366952,-7.9363459275187957E-004,&
        0.25972036503048307,1.3758731270223787,-0.39629751452943046,0.11122784967087454,&
        0.26704870588731594,-1.4076657617152997,-6.3670134592981875E-002,-5.5099378856751563E-002,&
        0.10553269605199400,-0.54525321150476647,1.8908458169222362,0.82226435071115245,&
        0.16700798987806695,-1.8596678759003891,-1.3047846668187599,0.77825165179296740,&
        0.15264421423207508,-0.27139783367420972,0.55132976690824498,2.0444002320592660,&
        -0.89638160510766973,0.28223758583695380,-0.76355223336882982,-0.53671201417073577,&
        1.0102439076948604,0.42337416332718480,0.59615610999754254,0.69301914667812814,&
        1.3304622233219736,0.50603322920695948,-1.0850868867401620,-1.7541307633523046E-002,&
        -0.63831966150192898,-0.95014325132007971,0.17472315318398721,-0.18730413664493253,&
        -0.57063131590474636,-1.1567791338041313,0.47645163812797225,-0.72358387501884724,&
        1.3016652565695859,-2.1077249740842556,0.14073812203000552,1.0867481953914921,&
        -0.26251163560148072,1.0516974998551802,0.54260525423884076,-2.3799145530133931E-002,&
        -2.2602296541511095,0.57652978137077027,-0.21074312474400680,0.53561271718211023,&
        -0.66624641142896313,-0.15768520723704479,0.18883398337271193,-0.49824824575700438,&
        1.1895057235390845,0.80977345760058139,-0.66714089366539742,0.16398671659360317,&
        1.3904367896429910,1.6189392385401165,1.0086865087697849,-1.0400640549850231,&
        0.35100523594074096,-0.15382965326735992,6.6414325092825313E-002,2.0702709068606464,&
        -0.26887093851388560,-0.83260065372315128,-1.1952433545776888,0.76260915224366099,&
        -1.0204268216055161,2.4756322989872057,1.1384216447717862E-002,0.93407296214619262,&
        -0.39862579721696878,-1.7403620277572280,0.59381325908727245,3.0123171791985679,&
        2.0605355497618878,-1.1228846774697763,9.6373449547354079E-002,1.3386138971067454,&
        1.2142669329612616,1.4891561166458394,-0.65789465116447854,-3.9810108929463579E-002,&
        1.4329224375629910,1.0463242789868443,0.56674967861206960,-0.34507351557460597,&
        0.62344751318843850,0.24641516917744583,2.0790455348699464,0.14215271788730011,&
        1.6622050022140833,1.5927151810246425,-1.5115091838949120,-0.88887662641619658,&
        -0.27453716673888545,0.50838695460805361,5.5935496715412335E-002,-0.13423925018139657,&
        -1.3160468491364641,0.93041957554067112,-1.6378226415659580,-0.20329339587239434,&
        -0.18844604749431365,-0.26717246130026523,1.9927436836896952,0.25859412101962559,&
        -0.57465182430869177,1.1140905599013335,1.6531256366791207,-0.33437256334386251,&
        1.6335294582813997,-1.9181697722210591,0.48921674446998109,-0.59302019158956010,&
        -8.5989594058252170E-002,-1.8511825794449306,0.34553389436440002,0.86560273851680569,&
        -0.78872552496287840,-1.0232242954696840,-1.2301233542806984,-0.73332894023246853,&
        -0.13925217193260153,-4.2117453559485818E-002,-1.2451710097209838,1.3172345889042760E-002,&
        0.90305682229489304,1.8982275233466486,2.1373066087237329,0.29674544670395170,&
        0.24804342896476655,-1.1555569276955282,-0.44483528862342586,-0.62904027062369017,&
        1.2421026904169103,-0.39875083631548747,-1.3049940959796331,0.92268291782958656,&
        -0.42670087753456087,0.54281840354028954,-1.6163189554180994E-002,0.19583854790330454,&
        0.47501023333247483,-0.14102497752508059,1.1984601644172399,0.58357026587791383,&
        -0.21617267359450004,0.86207854032241904,1.4138903779960612,0.24582511758671871,&
        -1.1195666356382772,-1.5254684052110039,0.22901300269169686,-0.54595823711135849,&
        0.73976377137419302,0.31004846535877612,-1.0513051283684820,-0.97967621314902364,&
        -2.0876636051824637,-1.4751967593811057,1.1852586228619957,1.7383773646996574,&
        -1.0849028162288532,-1.0638454422269068,-0.10069199969993045,-0.29242522392538739,&
        0.24881705181053326,-1.4873637380941493,0.42529900952755306,1.0407877229673592,&
        -1.7315509806976541,0.67260648198210027,-0.76028244709942916,0.79147904806709324,&
        0.12875122330988617,0.45330164899094560,-0.93598367924185910,-1.5318053784321428,&
        -1.0017389518556390,-0.73385077341125948,-1.1021179637863261,-0.96868959624260631,&
        1.5659829299130594,-0.11463374024013114,1.1329939294590015,-1.9274585845109644,&
        -4.1731855010174604E-003,-1.8044632591821386,-0.98173111689767922,-0.49022547583478138,&
        -0.17429177569429335,1.2325707714623801,-0.46762772837285138,0.38264209668719984,&
        -0.37788208718792260,-0.22062343886563862,-0.64563509288105370,0.32246441247008584,&
        -1.0258748870042338,1.7791314177994435,0.37419209043690765,-0.32258241158514389,&
        1.2027008523321336,-0.81183796441168599,0.56979231180455703,-0.32651640646681324,&
        -1.4369095113911337,-0.51524043981230538,0.98597133548034777,1.7644824135184851,&
        1.7355178110679230,-0.73902576608599690,-1.2912580251227797,0.52744708093321668,&
        0.21944555346105210,-0.13969445247051052,1.4120560503844952,-0.64697724562385595,&
        1.0032433199534601,0.72351478116766754,0.54164766045756041,-0.88690439493063111,&
        -0.87118028474424014,-1.5334897588272047,1.3533053339511132,0.87615453734822601,&
        -0.86288146786782483,-6.2598557604427243E-002,0.23625970685574199,0.21707544721982441,&
        -7.7105214596004695E-002,0.50734847381138770,-0.73476974459067079,-1.0006231599793409,&
        -1.5666307601029572,-5.7238695159756957E-002,2.7714962240858889,-0.59381169886685981,&
        8.2376727366581345E-002,-1.0129565773126619,1.0336969963249494,0.81807978483369792,&
        -0.94168194238538594,-0.16201774861257537,-2.5855737415942657,-1.0494454354815645,&
        1.1412925415244517,0.86420335993687381,-1.3233679576625628,-0.96446889115010226,&
        1.2420963324096470,-0.35104866898162529,0.52539973877824331,-0.45106719237560977,&
        0.28759273244347189,0.61547025664654642,-0.47866034986432932,1.3054179037936959,&
        0.69879876805393248,1.3398104019815369,-0.67324131501518791,-0.37377835425556571,&
        0.47476961588552735,-0.15156528293022414,1.8956785910630378,-2.7891723986819793E-003,&
        -1.1897447567290940,-0.73414326432409860,0.73377357416432154,-2.5508767397991976,&
        -1.3988290940742294,-0.72591429725216439,-0.78314002048965548,-0.41498711541780248,&
        1.4727308509359269,5.7001224284594920E-002,0.35412180007788963,0.45956128125615009,&
        0.24041459078694913,-0.75266835996897130,-0.13560786058003232,-0.12240312463438240,&
        0.46829084481333039,1.0553790361377509,0.73456682220735425,1.5517851167842391,&
        1.4048638216412688,-0.27046491026327574,-5.6313947187736739E-002,-0.73518391288799034,&
        -2.3759769913154414,1.4889100153135901,0.65941659172395306,1.1821408886736275,&
        2.1367665395779061,-1.3888839016840827E-002,-0.33961844704327615,0.30009624578893851,&
        0.29944551741917619,0.95232823672173272,0.75384424909278869,-0.42382512751599949,&
        -2.4995060633857014,-1.0450451141959061,-7.3704044271657637E-002,-0.46053323815322050,&
        -0.12077497565250558,-0.66030620429953379,0.50077882607664248,-0.50088469710237193,&
        2.0978463464841264,-1.2960596901869572,-1.1149316820402013,-0.12541044399768839,&
        1.1449534641863113,0.45875316908095248,-1.3925109353065139,1.3481819659532639,&
        -0.57517036385413378,1.0750472892764760,-0.21969185347559708,0.96199731110048570,&
        -0.71813637310216349,1.7418943646122513,0.92058431580549727,5.7815279186037190E-002,&
        -0.36877810096467661,0.33600217834703555,2.3157334268617377E-002,0.49903266472310920,&
        0.77726100533091758,0.54012474759436147,0.12082849232595863,-1.4474564418333673,&
        0.31742960808126391,-1.3430196147875362,-0.48349019016079386,1.6308329838347710,&
        0.38746800418186728,0.61554641434444268,1.2293474331784386,-0.46027270412069193,&
        -0.29199130552359243,-0.41191524053434203,-2.6691732161790402,-0.91944555200301503,&
        -0.20803549641368602,-1.0856761873283223,-0.75078490501589434,-0.92340784669100684,&
        0.55108628903465606,5.6789356944539253E-003,-1.5372802524339781,0.80401152848020851,&
        -1.6194814181395574,-0.15411028423613096,-0.54808874544396646,-1.2164983038083699,&
        0.15186178699735242,0.52718826370283811,-1.1537970076643580,-0.54265359777933309,&
        0.77488343842710716,-0.77281136412765217,-0.97371182081519358,-1.3324003811268856,&
        0.62619461769260576,0.12643671299826437,1.7897019266868224,1.2432569735925567,&
        -1.2013728993138248,0.17892494728986580,1.0446084316745128,-1.4898538292140280,&
        -1.2302753735998075,0.91934346690672331,-1.1656052227006901,-0.25982059581967304,&
        0.65542018709600092,0.67834155905661897,-0.55739068435621386,1.0794150525870241,&
        1.8632065187435587,-0.73637348845110373,-4.8665076587220420E-002,0.24334278407597570,&
        -1.0152907140263088,-1.0520828245114240,-2.5789850035018453E-002,0.93413856882126678,&
        0.38517559880498592,-0.11135974987005573,0.12420818841485474,-6.2165617382289047E-002,&
        -1.7682665569247362,1.2678127516372910,-2.0105100572055465,-0.89447817228851911,&
        0.42829781355306473,0.17374687871543693,-1.3024138123705920,0.71865797437046131,&
        -0.87964008935658267,0.48343385542755180,1.4388788717448222,1.7146096319143314,&
        0.19252755558740844,1.3095689885933364,-1.6503676813462875,-1.2681125183402684,&
        -1.4323291348669085,-1.3835431346318767,1.0104697564520231,1.0682553053689159,&
        -0.45336354733244821,-0.80378634620186507,0.22736472136561711,0.56504076047073160,&
        -0.22227495882959258,0.64206166284404131,0.99203931531276779,-0.35922031123285669,&
        0.65492669934143333,-0.46898730521019588,0.97513869034155698,-0.56053676583414447,&
        -1.5905048200770866,0.80566058743763824,0.21679704809587291,0.14985989373365594,&
        0.92815282860761117,1.5423288418777150,0.53460707568972976,1.0878649312965332,&
        -0.75088154045002609,1.7814291167145977,1.2023399153208703,0.75546757314235202,&
        0.54039266376412931,-6.0643414221250844E-002,-1.5291595426429561,0.98949513958574176,&
        0.36505286437705536,1.9433163050481759,8.1490439775092169E-002,-0.91499736641537366,&
        0.84637735403771497,0.29745677323251374,6.7039507181314781E-002,0.38002598049100689,&
        -1.5028489492355785,-7.3880854468410709E-002,0.22511778180515155,0.30175142929118742,&
        -0.43186414301776804,5.2463420940586258E-002,2.2805223048507859,0.47439182015827108,&
        -7.4181963866904135E-002,-0.43377319244031670,-1.0191978924348235,1.0819659145408778,&
        5.6434048479190842E-003,1.2937338271179124,-0.27306303344644628,-1.3621726424471590,&
        6.5985784500573477E-002,0.90421626313355097,1.7465226261071327,0.52518415899695259,&
        -0.93220913373282122,-0.81016413873272275,-0.35528526562853857,-1.0302590970848005,&
        -0.44507923449800996,-5.6352381987284816E-002,0.15260114652635115,0.31985770346185044,&
        -0.93039191479902417,2.5080498784559920E-002,-0.81363449079460681,1.2634996375704644,&
        -1.2107048226116734,0.83511020520087487,-1.6997795940297609,-1.9286510091926234,&
        0.48314201553911496,-0.17966297004967755,7.4542962935187094E-003,0.39283445681820406,&
        2.4063813184937364,1.8112287895856687,-0.50678176549616283,-1.8250751740834827,&
        -0.31392288168943577,0.68573282596494212,1.5445035454677305,-0.17165188111622243,&
        0.63361490655898267,-1.8187958918081448,-1.2964583833536827,0.69099620499391023,&
        0.10162831154407546,0.33611312839400237,0.25300276312692471,-0.25338355297956228,&
        -0.92133187780884895,-1.6929255096281552,-1.2768180648376695,0.27378559397813740,&
        -1.0226342410892417,-1.6758709031955408,2.1562137191441675,-0.14295848006944431,&
        -1.0703960514326600,-1.8589590331792902,0.64851506027347849,-0.89004210346731982,&
        -1.7539523775404768,1.0791811812690300,0.20384510477804410,0.64469982647265289,&
        -0.13565523438450691,0.56168975233391827,-1.7464745890296265,1.0077688200125670,&
        -0.74088041947882710,1.1698954295623911,0.95493601572456244,0.85319824683868739,&
        1.4950387786572550,1.1129781999507784,0.52023002805469654,-0.18302151742717970,&
        -0.49377084243245378,0.76772958507388811,-1.2675618676387901,0.35574161266794335,&
        2.3676391793338309,-0.49613294131196972,2.8629834934056544E-002,-0.63767654538375995,&
        0.35887899319047228,-0.62458787739971999,-0.34231058269050862,0.32435698186327339,&
        -1.5003835739687958,-0.26830417607721457,-3.9839044327707920E-002,0.64687125802827106,&
        0.11902098915820636,1.2426465886133813,3.4822793335425817E-002,-1.1594780152158881,&
        1.0596453646122241,2.4618932430034217,-1.3923349190280854,-0.25687195903258120/

        DATA MC4/-0.24247880852008935,-2.7283433024578989,0.60840813673178706,-0.40109894831642323,&
        -3.0526545067257800,-0.96698080083429616,-0.56773650425057298,-1.2565991691789888,&
        -0.72533501406949619,-1.9371233260736909,9.3362183169245966E-002,0.65731359981918414,&
        1.0114623412581267,-2.3044874192479772,0.85407433788536036,-0.73336816629693524,&
        -0.63693874702958653,0.79906931922937929,0.18370524311727959,0.55661977972346788,&
        -1.6806022947765280,1.8502414115734878,0.57581983231660494,-1.8310001676678720,&
        0.45526705189057576,9.0075792131025956E-002,-2.0389423856111684,-1.2515813468711523,&
        -0.19271513737938070,9.2603302219509173E-002,0.10987595787467833,-0.91062441441313091,&
        -1.5056480866579225,1.6627047307745302,1.4890065278150197,-1.2153663283814888,&
        -0.92522459688612568,0.20051465952894101,1.1338332205970494,-0.49872713808001085,&
        0.16089879582426947,5.5378710249764547E-002,-0.95458632279025790,-0.17104613774896729,&
        0.11588388461269448,0.56935876571226851,2.2518862515995317,-0.42334748434969099,&
        0.39301268624213032,1.2491225163443673,0.20360250349570996,0.13122537501984999,&
        -1.7358066538405024,-1.6543085338029919,1.2680752464109772,-7.8331503512823419E-002,&
        0.93580655080590169,-0.73897217387814840,2.1534144137824454,-0.43754968302939445,&
        -0.54669317553088415,-1.3176833559377585,0.83755040860606134,0.36884014982228536,&
        1.3242999640387763,-1.4932603741423152,-0.50563408007043231,-0.24164431426646962,&
        1.8350743717606830,0.32755129934767963,-1.1275810424306496,0.84480439583749134,&
        -1.3768471230161099,-0.55773886607123457,-0.49039277796083819,2.5514247219995498,&
        -0.18969515417591212,0.43522286375577635,0.30732765711414095,0.26156935182403873,&
        -0.33222149256721367,0.17178329669286818,-1.1290972948212128,0.34681410346080210,&
        1.0766512219604798,-0.80864603677871749,-0.39829182396219837,-0.41991841264720392,&
        0.17159596910839717,0.89505231215839687,-0.62457669873383093,-1.4374852663744224,&
        -1.0114447079437945,1.4865298322008307,1.1391162692487646,-0.23334702260403370,&
        -0.35477649343133905,-4.9054405691397400E-002,-0.28830735384335643,0.10225076512469065,&
        -9.9580227462746904E-002,0.26171884546210300,1.3000617144973783,0.39513108261657015,&
        1.1406224679881234,0.19610971461210469,0.72368902405056057,0.28683640453027098,&
        0.27818069700058090,-1.4788550989424596,-0.51388898765487989,-0.13861852133582592,&
        -0.41280325764280973,1.0588410004701245,1.2117274527045252,-0.94371658078586895,&
        0.53312372504875727,-0.85129285688965950,-2.4500990008217243E-002,1.0253788363027683,&
        -0.33059251629597686,-0.93041558769894650,0.83053764438536493,-1.7242943303298286,&
        -0.91834390689694889,0.58257975220887426,0.48719689821721213,1.9511909074836442,&
        0.92751585538099723,0.10298273842331207,1.0217181594036950,0.15511803944449740,&
        -1.0108604856364378,1.8014853750244015,0.34653753970647766,-0.80333158918044578,&
        -0.12062692032418915,-1.1551671254504259,0.50346961358276232,-4.1286126661011597E-003,&
        0.10659055081143713,0.82491245965310878,1.5863843560493556,-1.1463817846287125,&
        -0.12708496389972482,0.17583317749641506,1.2195928843188495,-0.82532076165074375,&
        0.63283287056189585,-0.48680906381655520,-0.17702671857933999,0.96403542898142514,&
        0.24036596136948310,0.69278767966206933,-0.70773858389814337,0.82092405797147006,&
        0.96629626036133820,0.20620296225382864,0.41712607395501339,0.82814097447962898,&
        0.53082703347091387,-1.3073498099030865,-0.51733892806522042,-0.53018592950494048,&
        0.61024303063585295,0.39901415868059315,-8.0293042012925947E-002,-0.55999683757164020,&
        -1.0838132309698634,0.83812055362376947,-0.32596949141975751,0.68332355247581711,&
        0.82084573820210349,1.2127566143795865,2.1474242382325834,2.2307570473919784,&
        -0.51889064729304801,-0.85232267459945754,0.93076078408278073,-1.2948547425570927,&
        1.0376217736792825,-1.3858070865395375,3.2003527370088722,-0.48213670731210778,&
        1.5721022071710049,0.79972118780349299,-2.4144167431640677,-0.58410700223035383,&
        -0.99654564276495761,0.32491449996046828,0.70933521252015130,0.20825563662333682,&
        -1.6140493849856790,1.4139177621396550,0.65402615878800552,1.4058712265088866,&
        -1.1781440443693862,2.5258764022916269,-1.3247575843202137,-4.2997138333242563E-002,&
        0.43777227739978525,9.1402088997040609E-002,8.5108819811790554E-002,-0.91983004844071670,&
        -0.91440527587420040,-0.21169737315533926,-4.6369413952836940E-002,-1.2197452797126433,&
        -0.13578852634652511,0.26987582008207545,0.33587719300872748,1.5208361501878815,&
        -0.37534818547934351,-0.34986696384743787,0.89062691019323936,1.8855593152775374,&
        0.60915209475963794,0.40176647774309332,0.87958541310271121,0.81529182515587340,&
        -0.48367053241483560,-1.5139668443654970,-0.27727016642799068,-1.2093553380896596,&
        0.41664057446800828,-3.4757497782463742E-003,0.73057041816083734,-1.1504890844471380,&
        0.30274610853997447,1.9301319481718195,0.42790170536632305,0.98530284395198142,&
        -0.49482377411995171,-0.92637983862369144,0.27344117205039015,-1.2163126418165366,&
        0.19949597888853951,0.62571700911947803,-0.65995195181892019,0.85013260448288963,&
        0.60752981484574953,-0.22196088487717119,1.4970448840629182,-0.12153383372483373,&
        1.7179590619914396,0.61404709494325016,0.38466997842297018,-1.0537067125232724,&
        -0.57727537419348063,-1.8992261630487193,1.3143983544980606,-1.0611756514354183,&
        -0.73223910103014211,0.40891463557887187,1.1637724745487843,-1.5776679581541937,&
        -0.58879582679609554,1.3372634307416411,6.6212398587699541E-004,2.3220253834917925,&
        0.18052123790387462,-1.4441867386462661,-0.21212448786176408,-0.50171093877419404,&
        0.21034367231165296,0.71139691540881134,-0.29376229748499727,-0.72109848329612891,&
        0.28789490797231865,0.17510137197662023,-0.12517498317408077,0.21435389137322647,&
        0.26691322065003387,-1.0462708439646755,-0.96357953649414008,0.55195735740664620,&
        -1.8917018072174578,-0.46915276672461070,0.91460462235718576,-0.96666001781652389,&
        0.63518198888148170,0.31190406300689022,-0.53283036264727757,-0.12554960656397676,&
        0.82784860328180154,5.9944350143528863E-003,-0.59641148742297734,1.1746158067577070,&
        -1.2775762218706208,0.46129949744470800,-1.2789179750813930E-002,-0.57075781937114722,&
        0.43719401877965980,-2.0682120806841975,-0.81320072365731488,-0.50455251438290716,&
        0.88732405875025611,0.33058912037858240,-0.49493462670667654,-0.95741312134249856,&
        -1.1440848569806350,-0.26912260338984001,0.42026766602940308,2.4519208301870907E-002,&
        0.18852034168052129,-0.21638843903616659,1.5610575541253242,4.2275205744895350E-002,&
        -1.3826392007359820,-2.4094250914036848,-0.60484188102021896,2.4033604310266474,&
        -0.71169725950701224,-0.83054724301487781,-0.41615129687360558,-1.2834984460619927,&
        1.4509542389517058,-1.2275179047526974,0.58987272563801374,-0.50356965906769968,&
        -0.52377028377687707,0.91872907621714506,0.16761503851622223,-0.29853575997087017,&
        0.63875386129121425,1.3896747374530714,0.23363236448651389,-0.57273443502782773,&
        -0.27237937500189113,0.51766906595938211,0.55233536300626496,0.40981511229602324,&
        0.43518480177352348,-0.72887568563438021,1.0327400138540561,-1.6928087800846463,&
        -0.39220949698248780,-0.57656019258287461,0.66125891675879689,-0.98961549220603162,&
        0.96643366847504486,-0.87896202970054094,0.12800924371159550,-0.22473629529923389,&
        1.9355037640202797,0.98155143362719388,-0.71758717051676602,-0.34562862380861842,&
        3.4762226498124847E-002,1.3202065443521476,-2.6376758896258017,-2.1587616145095120E-002,&
        0.98677698709366601,-1.0299410489620657,1.1828765650423498,-0.65312048813660917,&
        -0.38294274673465312,1.0732922235578697,1.7807088351955798,-0.46479276948494497,&
        7.9844144314975662E-002,-1.5218557932417056,-1.6297053561603599E-002,-0.27261717770653271,&
        -0.14728403514079152,-0.44463146529404624,0.69335642374786766,-0.13349137589229143,&
        0.88092191408307774,-1.3487649307348615,-1.0460688200925965,-1.3223004278363102,&
        -0.31162159269672673,0.87227349994134651,-0.77320200154135033,-0.53902589723307137,&
        1.5754806429018759,1.1991718495282049,1.2041381097496346,-1.5178387951849914,&
        1.1919157547309864E-002,0.61555259899895454,2.0381564867449233,-0.76569217572411707,&
        -3.4258777652326780E-002,1.2889295572660886,-0.42958956214627625,1.0136447279168608,&
        0.30362797414022258,1.4951265713267574,-0.68094624263750270,-0.63906959675175434,&
        0.42562761728733467,0.44759580652078884,-1.3205263320944147,-0.49649260804267870,&
        -1.1826726723461098,-2.4356398666442414,0.54973866351526823,0.92262529793998527,&
        1.0061385216001832,2.0288676888170349,-1.4419819890360983,1.4749005395374910,&
        -0.91556641804936401,-0.35246571066890442,-2.0290518758095160,1.2563068024953377,&
        -0.11117180369413589,0.50005243152831624,0.92342496943168195,-0.59024563018203269,&
        0.90255319792782440,1.2124562362694220,0.36397095244636984,2.2939539473983774E-002,&
        -0.49413478814101042,-0.65660754607196670,-9.5011493460067001E-002,0.45170776755458480,&
        0.96337241988597899,-0.94172496315277099,-0.70303473930575078,1.5016518742015450,&
        -1.1442442758614548,0.86382543691654035,-0.59871073294699018,0.10950981105373828,&
        -1.9192326140654594,-1.0470279371971276,0.20505568105174388,1.0347166753173931,&
        -0.37581284850992580,0.23611548027927548,-1.0421316172768063,1.2130528410176922,&
        0.46242206119975898,-0.81743146012631474,-0.77587245877634414,2.1629759807413147,&
        2.2829320866582523,0.19475000043355584,2.9724259855448999E-002,-1.2306437513850994,&
        -0.74274472934725089,0.63233958892669018,0.17146842141010954,1.1906348799314963,&
        0.72179943322050955,-1.2463885447452274,1.1742248173705234,0.85115615007286771,&
        -2.1154235757722309E-002,0.47912417792671824,-0.10240488920033262,1.1913694228531881,&
        1.8664316367255620,1.5270401807389189,1.1788774180989725,0.65971651407790921,&
        -5.9601860464966690E-002,1.5292207591736506,1.4360284055143377,-1.9604445381107527,&
        1.6393833343606627,0.24035429983694867,0.89727796995617881,-6.9530027530522079E-002,&
        -0.96050265959082504,-0.69942151779047668,-0.32390612366650523,1.0596727412828404,&
        -0.83576858612357663,-7.3926932745783602E-002,-8.4238738647080216E-002,0.76722520895812363,&
        -0.65952166710001614,1.5076949036104270,0.48405875361479644,0.54800179164574470,&
        7.2950093302424412E-002,-0.24697060273073398,-0.38127210384876054,3.5654979208632781E-002,&
        0.40326936803754992,-1.5216715126632818,-0.39470143545915015,1.4457923140129489,&
        0.78543320651350190,0.22760214720813884,0.22309854472390420,-0.34508952231402290,&
        9.1984068944375746E-002,0.54093971631793136,-0.86816090585197425,0.53407368629424912,&
        -3.6914459295858439E-002,2.2084611519602086,-2.1886961718072975,7.5567344882974716E-002,&
        0.23153070897031042,-0.83667026987841497,-0.72578350714536632,1.5944834999140584E-002,&
        -1.1522703386110422,-0.58663512792259520,0.54356967068140094,0.20012356025948499,&
        -0.38901064847223366,2.8568633203690515E-002,-9.6593408913816636E-003,-1.6806482631454782,&
        -0.67569594956240719,1.0039819701125625,0.98981564449466475,-1.6943705599957417,&
        1.0705063570489708,1.6322484421801875,0.64616994888764057,0.20956318789796657,&
        3.6559117997299308E-002,-0.44555687020508755,0.39392162252649721,-1.9405436995073688E-002,&
        -0.25971915689578917,-4.6279469440670302E-002,0.35038911042209642,1.5454596282862529,&
        -0.66554499695599401,-0.40851378147156714,-0.27303858677198495,0.73835220237494048,&
        0.74003867885018770,-5.3367564775873531E-002,0.58359528150823647,-0.72369978494374554,&
        0.99462834600167005,1.4754333680053220,0.54094832100952839,-1.0721694194360132,&
        -0.15560694252970486,-1.0701478764996168,0.99553488249226740,0.28082156691621163,&
        -0.57569987909937093,-0.10511071554605540,1.0615394439478527,6.2015502031626535E-002,&
        -0.15024332063634857,0.69982454941668004,-0.81098706132100107,-1.6584794230474142,&
        -1.3177810804542696,-1.4022959887469634E-002,-0.35419119544605676,0.89424744177946025,&
        3.6606735341704250E-002,-0.93968286899397324,-0.60653459749959426,0.85007282320329891,&
        1.2854042563869617,0.73568696293951641,-8.6957303277052436E-002,0.94572977873590269,&
        -1.0842206699119025E-002,-1.8008402407379354,-0.78486262880149826,-0.20522311206131527,&
        0.78084422886708649,-1.8292753703674578,-0.93525337783096019,-0.18117578124233258,&
        1.3962428897288357,-0.38453628245969396,1.6150395894808467,0.47188028058999004,&
        1.0710175110565565,-0.83606095925372170,-0.40305931418335167,-1.3280973567809504,&
        -0.58696932330760931,0.27215101087186233,0.90071392473123069,-2.9832475031947706E-003,&
        -0.98372238957444824,0.45452838684813840,1.1338653244850205,-0.46125583235488216,&
        2.0839472383277471,0.95429425437862525,-0.23033981138858034,-0.86968254374876497,&
        0.55777413106906049,-0.39668723142759271,1.2306039991853555,-1.0008594414248975,&
        0.40998383812072464,0.30885943565281326,0.46374468799208113,0.48309997282698763,&
        1.5015963273331894,0.21538337494501569,-0.15285710058684576,0.14419356707771058,&
        1.3606028571155262,-0.97684445488123950,-0.32061995497744539,7.6588886440738732E-002,&
        1.1425699608034767,-0.50934919718092586,1.1503163141225203,-1.2268618748914553,&
        6.1502745194954370E-002,-0.45188871597473779,0.12399778304736600,-1.0066339342149284,&
        0.86605838365360721,0.98059204221959140,5.4852584147703373E-002,2.2196626652990252,&
        1.0504891693327030,0.12260169741062842,-0.24563558712910069,0.80560146247116837,&
        0.60564288187142445,0.64012030577337786,-1.5574376699939951,-1.3955479402916675,&
        0.44725379933167214,0.78517603772470657,0.34455843548948423,0.23280862028561100,&
        -0.87614529282021658,0.43428766436778277,1.8143119967514148E-002,0.38367542907657265,&
        -1.4082762496904766,0.67997690859916704,-0.54284757763929248,-0.36757538048571442,&
        0.29261761255037899,1.7742390003357267,0.46333254191463430,0.37725874610106469,&
        -0.80450120501049327,0.47868841919496213,-0.68093240205475924,-0.34308504903518905,&
        -0.31903091075479867,-0.59425547300180037,-1.3753036760105730,-0.81579738292405313,&
        7.5186271284925957E-002,0.38690430160243700,-1.2264135787224073,0.48341117598461458,&
        0.11744864592403104,2.5133019524851448,-1.4921469185808325E-002,-0.56812140526316723,&
        -2.9997719588050615,0.42404951137032021,-0.61785406156642442,-1.1731973311752313,&
        0.19219032362243296,-0.87722420687838831,-0.70565732770872036,0.73120106429912357,&
        -0.24771801442802008,-0.27528166822168160,0.22903934655174168,-5.3954734974990252E-002,&
        -3.5319942103416289E-002,-0.81459881202792028,0.93117454218409956,1.1820132474288154,&
        -0.67996406231062512,-0.67574784258799370,-0.98322638404064722,-1.1981196670925629,&
        0.16895518653812677,-0.29998464726404800,-0.19505255417941209,1.8891152223120697,&
        -1.0226012685735621E-002,-5.7671800499141820E-002,0.62563267371793496,-3.1485877468845479E-002,&
        -0.22396629876575413,-1.2909456247407716,0.16326897253745437,0.27547797759997317,&
        -0.50909314718295873,1.7623046868982457,-0.25263614741165757,-0.52868949270539345,&
        1.0938479197200550,-0.36978618928527451,0.15212692370289380,-0.73195396977060634,&
        -1.1047684229585664,2.2743622006946604,-0.74561022158540968,-0.77932692697958239,&
        -0.41825893185160468,1.6926264649072300,1.8661432955217829,-1.1079551009021553,&
        0.28604636313440041,1.3979790645690058,-1.0349248932491468,-0.92893971787159124,&
        0.73379646637502194,1.1884465556671342,0.29265584689614937,0.40209684611531810,&
        0.38362137584167028,1.0746702472643732,1.8130917177345280,-0.97881374853208081,&
        -1.0086377165285101,0.44175858545399732,-1.1786847149134307,8.8626013161114098E-002,&
        -0.88088998591641343,-2.9866812634093738,0.29210043989759815,1.4907330679680264,&
        -0.64113354017132118,1.0554786608475764,1.1672267852135199,-0.68023465647500903,&
        3.6813292047697496E-002,-3.4390525602052073E-002,0.40697916432888304,-1.0587530584931226,&
        0.32994284601812540,1.2936926095911001,-0.78882844522282125,1.9092780044853335,&
        1.6629656151624010,-0.39920974757504701,-3.0604804864758886,2.0021924913704150,&
        0.68201619479702802,-0.69348952782459772,-0.53664891708869467,0.68272071802978695,&
        0.39315574698261108,-0.65329485085001626,0.15068412459184855,1.1496083145138465,&
        0.53109100657342923,0.86288449801939615,-1.9834300830472762,0.14015579001964962,&
        1.6970885631828199,-0.55931642588366215,-0.80850000451837545,0.54785751450966758,&
        -0.77210456108732761,0.10388494194861361,0.79671441383667285,1.0569061852079198E-002,&
        -2.4483430835561579E-002,1.2967136483085346,0.72771385530889243,-0.61990169257824512,&
        -1.7490269938602776,-1.8225178810690406,-0.62818379596638141,-0.89954495997990258,&
        -0.68580315520811452,-0.15988430043957336,-0.67835812112950455,0.14148975427280461,&
        -6.1269199375308669E-002,-1.3789582111183756,-0.84775840971613137,-0.65197397390489376,&
        -2.0969214170014605,-0.52605504213135168,0.69129755913139457,1.8534832604337834,&
        1.6985479477143615,0.70180390225207900,-0.87138601470904609,4.2130450262124704E-002,&
        1.6627050173523517,-0.74886441323551312,-0.29099105107225226,-1.0414146226173031,&
        2.1179444799956517,1.5616112158517038E-002,-1.3807534156517094,-1.5983162684468244,&
        0.48999106184042152,1.6873426222974870,1.0072216575453223,-0.76966114358913629,&
        -0.49936760156456067,-2.5709509266784578,0.13362159521213615,0.19117045845100161,&
        8.9560599645392772E-002,-0.23908918537189153,0.22709714358312696,-0.79826355535482807,&
        -0.36280136342953406,0.21178165056181020,0.59924070117274464,-0.76612038713858421,&
        6.5591549171269983E-002,-2.3556392482280835,-0.36519110609698985,-0.17089448674096033,&
        -0.24318570904332890,-1.0085089452034395,1.9073277778700610,-1.7524447728120784,&
        -9.0041182636059841E-002,-0.10328947945615334,0.64644074983886646,-1.1001601869781106,&
        -0.44764034546275744,0.24933851723551262,1.0735420350741540,-0.58139535515252549,&
        -0.99250458552091858,1.1116656357583770,-0.14040809084893505,3.0168935071579601E-002,&
        0.87707342985249337,2.4625041841522117,2.0001930739253715,0.21785475267104679,&
        -0.58338286076733525,1.7536670143744153,-1.0801660914361337,-1.1705937530176937,&
        -0.16709646096057587,-0.89678367247108837,-1.6507722412061847,5.6109403004219877E-003,&
        1.2365963659159247,0.23754589856941852,-1.1879204302709656,-0.93967478651344227,&
        0.27455869370518765,0.74216151299546640,-2.8149444619654562,0.26704023903317342,&
        0.95385580578361995,-0.95988948351240200,0.35036499386127085,1.1734916472529577,&
        9.3915449112912233E-002,-0.84500826228966108,-0.10359381003773722,0.48084523072016089,&
        0.73076063774284339,-0.89945179949093479,1.3143026381176275,1.6097602804348574,&
        -0.90923154141981977,-0.31918765992109910,-1.3630286105778688,-0.15346383977368266,&
        -8.3656148538344480E-002,-0.42885246993742604,-1.2735242256710588,0.12779877692327257,&
        -0.69797234037080180,0.13606193792704521,0.22918976035940802,1.0880398506761630,&
        1.1613912253058207,0.48173550781734359,0.23079812563118726,-1.7795046797527765,&
        -0.86714333608495675,0.93755631734538414,-0.56679891887328526,-1.1467673682551545,&
        0.75635460290653078,-1.0137524449777715,2.7953574942332167,-0.92517964643546746,&
        -0.86397670068110066,-0.93591858367398673,-0.23283954831126474,-0.96992670713714679,&
        -0.22836584288047196,-0.86847658876715650,2.4390180103553410E-002,1.0869984462322757,&
        -0.45391252685773148,1.6448078626443079,0.30040163920609692,-0.30210421016140498,&
        -0.50469634245557959,2.4406405063625534,0.19908824133070821,1.4836319025083873,&
        -1.9606440654206674,-1.0810231739457588,-1.0944918953324885,-1.8292049373860091,&
        0.29282640769729074,1.6693421575611478,-2.2693162890924281,-0.21496079765956558,&
        0.88730808709227560,-1.2721854705858904,2.2645618594412218,0.83964745456410739,&
        -0.26755959555079095,-0.68274200021531217,-1.3472081829804632E-002,-9.4929083907902501E-002,&
        -0.44429563919408255,-0.94974348365438843,0.58912849128839739,-0.22043859626085879,&
        0.97556150622604842,0.87961994833863744,0.69947280754076713,1.2520577287329120,&
        0.89459808229801208,1.8915668672998724,0.27901404465795404,0.69734222714182659,&
        0.61671797608547907,1.2034879912641090,1.1417779360139004,-0.92587044877004210,&
        0.14405174034007620,-1.1113095274932083,1.1610176021969167,-1.0242421091532992,&
        1.9700142130034146,-0.38186994223601778,-0.64738375094077383,0.18521946237062495,&
        -0.70930994398806091,-1.6807955469447742,1.6030787810457352,0.12163947558159677,&
        0.64427684062338642,-6.9526348631608767E-002,2.3972490826258741,0.29073765990922013,&
        0.36727314399523414,1.3056303787969841,-0.28780756365868410,0.16862252111476358,&
        0.96009058895821631,-0.88759720294312061,-0.35450360895196420,-0.51031261344720547,&
        1.2143644722496221,0.80364353473886641,0.53877286809315783,-0.88472667464849797,&
        0.37374216491326445,-8.4890407606597523E-002,-0.35026136791136969,0.26911774977199482,&
        0.93941915821889865,1.3694604394634140,1.4525792294310305,0.53834936239244813,&
        -0.92959424138456803,-0.32743192406582117,-0.41787821319796303,0.38217995636723562,&
        7.6471010156161524E-003,7.9493055447304839E-002,-1.1576362913559013,0.15931786963721536,&
        -0.72430121468839226,-1.3995125082531621,0.81836973253943490,1.2150183994931942,&
        0.93986418047516251,-0.31246020351272352,1.2627246702729347,4.0425585009263076E-002,&
        1.4346190148573379,-1.8232783200826446,-0.27734907314016777,1.2711918000779001,&
        -1.0017304390939126,-1.8008104443122550,-0.89058039555715407,0.53045619336208327,&
        0.55756753102419410,-0.71136505409982942,-1.3555884665477538,-0.12892272857296516/

        DATA MC5/0.56692896720467401,-0.25446108697700004,-0.39348390091568769,0.89145958899222255,&
        -0.11104354213087615,-4.6763354751803120E-002,0.70876124162957332,8.3124815185903908E-002,&
        -0.66172991531209324,0.18061100805195657,1.5705701683222253,1.6040924305672806,&
        -0.37139830480522218,-1.9521548181079249,-1.5290168743037147,0.90237766424978250,&
        0.39157157563784067,-0.23676255504880039,0.86537300011778140,0.45836492885575292,&
        1.9158552978016716,-0.15108533573433397,-0.24661405095860606,-1.0021780546030954,&
        0.78033512113169023,-1.1757134276358969,-0.89844550811897816,-0.83897384286993337,&
        -1.9162133069960074,0.51067204619431183,-0.52582322585425889,0.86462140768854800,&
        2.0669380061071290,-0.20597584064501875,0.92573620519453492,-0.19602786194645105,&
        -1.7683657053098523,-0.35172785155335551,-0.49320620042357471,-1.2410791724114802,&
        -0.64313028702884412,3.2832969146476716E-002,0.25575208443815450,-2.2519401515038355,&
        -0.30860919337654769,-1.3985022050342237,-0.90172209412187976,-0.94530282868463755,&
        -0.40688445153728603,1.0658647010295712,-1.1033027397805804,-0.47411219919233677,&
        -0.30246536669490631,0.30014162804842098,0.41978575341229396,-0.39675919932125109,&
        0.39248344416875730,-0.96569560582577907,1.3396888253780639,0.82402161147627495,&
        -0.65475192971453189,-1.4006392946056823,0.76057979842672063,-1.0819265319407783,&
        -4.5058138294348946E-002,1.7806770756708761,1.4822754276118659,-2.3609878961520963,&
        0.13967477096744424,-1.1023525742276146,-1.4927720258278327,-0.30999439102271942,&
        1.2447462802449374,1.9157744359643358,0.31033747818943475,1.3865965030467662,&
        1.8395686404919218,-0.15715230259683791,1.7595072352506038,2.1934388642010232,&
        0.14905194668155486,-1.1938496512391672,1.0819427219242570,0.13168044844381238,&
        -0.11344208676029313,-0.30334485531393313,0.18351851527113192,-1.5627217812610046,&
        -1.5781573508731661,-0.60013258994111729,1.1547299370294504,-0.11689238841554508,&
        1.1185706553924823,1.1180380338914986,0.64105680770017670,-0.11013288923981231,&
        -4.4515467977050666E-002,-1.6813134576687225,-0.42444823096587608,1.1830938063808105,&
        0.74105666272970627,-1.4200719556898858,-6.8823356128282970E-002,-6.2781311441583582E-002,&
        -1.5529708503141180,-0.51160943417203097,-0.79298223371534282,0.91455426693685993,&
        -0.49677089944627045,-1.5041040409555864,0.13757012874315000,0.21877448398280369,&
        1.6954251818267509,0.96528884416085181,-0.69767566679965254,-1.7382151166680411,&
        -0.51265975363018401,1.6264086142791898,-0.99082018128553850,1.5650092205787407,&
        -0.84956118667102154,0.99999196138808055,-0.79633337004790283,0.71657255028493938,&
        -2.4728250126452137E-002,0.64825199942790657,0.14909385319341367,0.53997737791007139,&
        0.35734360456770775,-1.7918050698061425,0.75404654576753904,-1.8345137768589272,&
        0.48478687983590563,-0.33916046800195487,9.9939879443285737E-002,0.66357921900190608,&
        1.6530251148695057,0.82631607678236185,-0.53992486227983005,1.2831996351103452,&
        8.0231151934143582E-002,-0.35966964071873836,-0.63330676723027501,0.80682861670457706,&
        -5.7255235635973775E-002,-1.1501290549599854,1.6920521661296613,1.1716351346223828,&
        0.53858224697819268,-0.41632891506549380,-0.67355993340851239,1.7739241884495260,&
        0.83433610629811417,0.48424267662749265,0.44404057158864907,1.8292827594904406,&
        -1.3658787531046621,-1.2942848666099747,0.90799220662694724,0.63989069258909048,&
        -0.71826538891563718,-0.83962851157059382,0.25611380295116776,-0.61035342167845297,&
        0.24490713027967745,5.4807390978709659E-002,-0.70777519025412272,-1.1440255800947570,&
        0.85210226563841607,-0.15406592277330089,-0.77501867171608063,1.3995302104372429,&
        0.22625912831032208,0.72092166293162940,0.28343103904553929,-0.57065819187950129,&
        2.2470752527184623,-0.88698995826735083,0.54497894400448688,0.70454471471039382,&
        -0.55184942110537238,1.6430853411910418,-0.85927048609433010,-0.67737498888490755,&
        0.37398888362163807,0.79343559153388732,-2.8492629770683765E-002,1.7376420121664020,&
        -0.77277116405751256,0.72658574764212069,0.16282850499156845,-5.5992903779818769E-002,&
        1.7788319695524553,-1.1481003575715998,-1.5969026972754066,-1.1114863301852083,&
        0.29791560961202423,0.72620062015904552,-0.87640474143736813,-3.1358098311734660E-002,&
        0.42267362766171468,0.72787584030060370,1.1378969283936586,-0.95978358173888001,&
        -1.9275812374105565,-0.62476151686277892,-0.52749470535844156,-2.9564775853591510,&
        -1.1007214439668307,2.2902552588800136,0.42586156824161581,-1.0692276417209317,&
        1.2117779908094870,-0.57551380858496859,1.1152796500926880,0.68185037772987322,&
        2.6578923805766461E-002,-1.1016340864691498,-0.67448790637014666,-0.26155980810386303,&
        1.5245356106588190,0.85257648550138287,1.7070784998335649,-0.66750264635999024,&
        0.32463279734491618,0.77843917917535832,-1.3186816865573006,1.0688736907548573,&
        -0.80704889293996651,-1.9002509990791618,-1.0885967189038674,1.0170332773087123,&
        0.22336143344027584,0.24135254906267492,-0.83960709283955948,0.74729304931877960,&
        0.59986107416355838,0.33516663161440263,0.13013138793662246,-0.13148410551187964,&
        -8.1098360917536017E-003,1.5215316735203099,-0.19410731779024368,0.18148900214860100,&
        0.48707254919975856,-0.39947761839468332,0.20945978939572249,-1.4016395733486646,&
        -7.4174225677757763E-002,0.81555527549937623,-2.6536086678840385,0.79600033741226028,&
        0.18317903979333569,-2.3358588048374207,0.52850220896136213,1.0008596773468035,&
        0.83781205978862427,-0.30328577909254351,-1.0686406702428501,-0.74374869053077852,&
        -1.9320755013992121,-8.7815921322401791E-002,-0.40808840406013824,0.59768855804053156,&
        -0.57370113270969292,0.53787193178279680,0.28463743278119746,0.18350588747471649,&
        -1.2810921991049375,0.24242180492044127,-0.39364677778395585,0.36999555613120189,&
        -1.1152302243404337,0.91769570359239749,-1.1872995180705854,1.1462528657869973,&
        -0.65526766618513355,-0.38352863883049809,0.13244461025328197,0.82686069855363875,&
        0.32281863362527374,-0.57374811844660190,-0.28053865863219829,-0.72117833933143705,&
        0.71051020176625712,0.30311722030359428,-1.6858917850722499,-0.26457437826783353,&
        -0.83727498806977041,-0.62709610329947241,-2.0082367912273162,-1.0221764872603569,&
        0.89744233642135762,0.88512741765711755,-0.89229178542911014,0.69674631392010500,&
        8.6109127611010954E-003,0.26472607942030485,1.1948879720601955,0.42985006529404440,&
        0.93214923159499796,0.20792632147315454,0.19731268973616842,2.2175410649369665E-002,&
        -0.62313343550459543,-1.1882341690240303,-1.3765266962236131,-0.95166422276867635,&
        -0.83129741978200655,1.1883682710799350,0.31064412572567984,0.38449346862644196,&
        -0.83016965467980663,2.2085053384803999,-0.43286271640450341,-1.0950300106436643,&
        0.76990026280817325,0.53849653490377436,7.7407755827756441E-002,-0.10583528225923503,&
        -1.4766818874299492,0.88836311189248418,-1.1313186034210083,0.86603922804810196,&
        3.0895827303414030,0.27384957380080127,-0.79069807453019336,-1.8497598202911063E-002,&
        0.48266794023341253,-6.6706808578480090E-002,1.2455035613790335,-0.96301342690282066,&
        0.88096077587427124,1.4585656309110679,-1.8143238026980437,0.25558470687802126,&
        0.54336185032793216,-1.2354156191333723,-0.70987838256549662,-1.8116906796353822,&
        -2.0251003644811223,0.11251713677963592,0.77240125286757677,0.57204261039836490,&
        2.9232560810212913,-0.41742562623229923,0.92962553036540463,2.1810363477914692,&
        -0.37810937822219143,-2.1390750451085290,6.2741598520692332E-002,-0.32004862636315989,&
        -0.26310107947155981,0.83510060454348367,-0.92769675278776820,0.49764908403675706,&
        0.42594262342034095,-2.5692621349530165,-0.21152844183101061,-0.44180598170638441,&
        -0.24439205983016740,8.2744295591778774E-003,-4.1508504695078795E-002,0.50340368563428339,&
        -6.9149404230249886E-002,-2.0833028151242252,0.16001288214833617,-0.25308141577262483,&
        3.3153185758366580E-002,-0.49160506115151675,-1.4669964225396874,1.0355913782696211,&
        0.38982185765611960,0.30855197704402915,-0.72360103674348364,2.3126066562174667,&
        0.95300818843290502,-0.76217613491119462,0.81170776807591627,0.94466372858892178,&
        -0.65160595656745013,-0.14020727154567911,-0.23789526080420190,-1.2617338640397553,&
        0.27217779270937964,0.79924044156200935,-1.6173397151743707,0.70606624660106687,&
        0.31216233447484548,-0.37001666749659379,-0.46149901543950356,3.9407168900801891E-002,&
        -1.2413435627802201,-0.86452124159434762,-1.8180774469502472,-0.79653207532450776,&
        0.58399911183872133,-0.79581929857413825,-1.1798942224173816,-1.9209881513211231,&
        -2.0646491282148007,-0.34380363242362022,-0.34789277860197793,0.36169162528751864,&
        -1.6597472141243599,-0.93080233504496057,0.33837114533212270,0.27308599686561685,&
        0.79301408883340307,-0.50777097445328945,-0.15962280848131369,0.77787310806311927,&
        -1.0222344993341508,-0.98165936935746745,0.78753523496751510,-1.6441432218402423,&
        -0.61895683140661395,-0.35260525305698970,0.26012852487017485,7.4421270786509924E-002,&
        0.92687018677481392,-0.58224121399467321,-0.45874838803660972,-5.1803095661134647E-002,&
        0.43417775132397446,-0.81085172277439121,0.28127906899702548,0.12813014614337248,&
        -1.4002635056306281,0.10286410626720821,-0.60431550816334600,-0.46313633100750623,&
        -0.35364664439133464,0.28155201399766605,-0.26324783512031036,-1.6038908706663114E-002,&
        9.5365442788195975E-002,1.3900775132343899,1.3466351700304355,1.5249016571494864,&
        0.18140339232917899,0.29393676649998274,0.79335263613422091,-0.44987458573643524,&
        0.69951090329457033,1.1032661891569762,-0.63000489968822881,-1.4373164357497130,&
        -0.37026116392753167,1.1129599474976519,0.16354304273896514,2.3664154346537467,&
        -1.2400862324884561,-1.4351210120739031,-2.0934864769051127,0.83795977169441715,&
        1.6392718638434218,-1.1516837446856341,1.2224687772078213,-6.2869541084605893E-002,&
        -2.3116306592442712,0.36648728604273900,0.79555642634728285,-1.4377524794267358,&
        6.7878225018226976E-002,0.62457647882187239,-1.1405363187549067,1.2279364290595289,&
        -0.34832908437081217,-1.1746212461560672,-2.3569534881474894,-0.84464636306429219,&
        -1.2921831247013735,-1.0180473379064998,-0.51178503307950851,0.26266157055162492,&
        0.60389216143374025,3.0325735045150028,0.19128235735678870,6.9259124010239925E-002,&
        -0.76101811516316487,1.2652369110714989,-2.0075944102466248,-0.73336653057773404,&
        0.18064477835439721,-1.6321997629310008,-0.72988637744094431,0.11407744183185280,&
        1.7217989066892931,-0.81334482589479462,1.0522838762193953,0.15813684189377297,&
        -7.9068119766516134E-002,-0.15283235519955249,1.1905531304282224,1.5716966398880312,&
        -0.27853927489242652,-1.3214209388506224,-0.32404649541638991,0.75186284738758269,&
        0.43159806386513033,-0.27996011049170128,0.60892582170605325,-0.91089577736819494,&
        0.55488456160035726,-1.3523466273384857,0.39846925094777902,-1.7886974823624067,&
        1.6818364100870011,-0.54073689368142963,-0.67243586007099387,0.33450162610211759,&
        -0.20728120458225249,-1.1054044765472741,-0.49768987609950821,-0.35402676310240722,&
        -1.6585081721204631,-0.50546904953324046,-7.3202051472442645E-002,2.4099130082044482,&
        0.10798053191988786,0.36187228826970486,-0.26400765200978088,0.48520948839605166,&
        -0.24166108086318963,0.78911544086593099,0.29017504494658880,-1.4504568355577396,&
        -1.3671567273594756,3.0070266115524600,-0.16529727395930274,-0.86604963649218802,&
        -2.1891657743505282,2.2393877930274040,9.8887503142530669E-002,-4.5793331055082730E-002,&
        -1.0516094014502624,1.2758904734297016,0.14011408466230740,-0.64551488618804920,&
        -2.4254264440625804E-002,-0.16182173713871056,0.19759230351232915,-0.50566033415614742,&
        -1.6797640147902790,0.32979564792401767,0.66308907099377357,-1.6254043274588650,&
        0.50121007752571656,-0.83968567604976185,1.6531729408321267,-0.47437311054115738,&
        -8.6082374179187418E-002,-0.92141208174804778,-4.6557912453346333E-002,-0.31402481188843540,&
        -0.90834206862157774,-1.0248490888640081,1.3653794344213581,-0.41112476724520758,&
        0.48998826745537866,-1.1622172320337563,0.86820123360237922,-5.8754094881713910E-002,&
        0.38905930081739643,-0.30992567019321898,0.59824425857695152,-0.78030411041773207,&
        -1.2654595805558277,-0.78061532156954949,1.2907693750209657,-0.28944643408379767,&
        0.88413973452085470,-0.95298506292724783,1.6652586488710750,-0.92560586301759951,&
        0.19465417364267526,0.37856252954097747,-1.1957580846108216,-1.4705180464787038,&
        1.2934433923063862,0.13736137909855961,1.2955937519004990,-0.58661048899234103,&
        0.50633067018804079,-0.64647387726000050,1.4759396933945632,2.6909414021983911,&
        1.0483527823878314,-1.0069071383558212,1.6272066983718658,1.0453542244413754,&
        0.71023917201756503,-1.5357265304836478,0.93638978850038135,1.3807455380602052,&
        1.1157959367634109,6.7886837671237099E-002,0.28696963683830723,1.8749774471253153,&
        0.44467784241771224,-0.81014838913870868,1.8050271206797499,0.59360621125086421,&
        0.97574790012244850,-1.1183241613371067,1.1225388644293319,0.47030063582639081,&
        1.7212012976058175,0.70161071270210262,-1.6858385074955988,0.91164705225736764,&
        0.76297892201422568,1.6358025594474641,0.54153352773679109,-0.19816646524332990,&
        -0.63852645521120355,0.51204650542336105,2.0713069985419739,0.57629010695965943,&
        0.72347783235588559,-0.67459806408769862,0.21315784897133161,-0.44756817969519430,&
        -0.96135489659161555,0.16054042670491089,0.90282470249248503,-0.24749037026668419,&
        -0.29016589948129484,-0.14895681589415655,0.48826994534065310,2.5030762035758709,&
        -0.99900163144703691,1.5084960204483657,0.11666338831295897,1.6183773497018896,&
        0.42104128317292655,-0.37979178471053066,-0.73793933033648107,-0.88045581124449146,&
        1.8842458080733380,0.70881784282979232,-0.60179858702942934,0.63347357550726713,&
        -1.0238280447755297,2.7990726176092937,0.99187820707677155,0.98094276697595617,&
        0.31449517793194215,-0.90671494174624956,-0.45701803541456271,7.0615831317711944E-002,&
        -0.87925301105346154,-1.2664467568159006,-7.7708046798603589E-002,0.68854704832544478,&
        -0.43036416972234592,0.24783923730088317,0.32535383681770175,0.31027255765922029,&
        0.32207825409191082,-1.8966836549726502,-0.46356609734034909,-2.0432751158068654,&
        -0.47757025358491023,-0.99526741408596509,0.64486769329565052,1.7367848237450780,&
        -0.24770268330247944,-0.14841764732993709,7.7049222155458702E-002,2.3875646960677552,&
        -1.6566344602846548,-0.68397746759531419,0.24667910308650962,-0.68965773288456889,&
        -0.74036633389475903,0.11228448162445008,-0.60870360527088097,-0.45742600947996354,&
        0.86105693859730481,0.43536869903650444,1.1501485885207188,2.6519141719961274E-002,&
        -0.68465230753095696,1.7214320384253545,-1.4377501333259062,-1.9048567447833689,&
        -1.3191074678958792,-6.1689088105347123E-002,2.2686406120292197,-1.0840126446617142,&
        -0.58566332267138710,1.0336478267222977,-0.42135171043322850,1.3091404079195030,&
        -0.19619317155950794,0.33568847066059304,0.75015011844304968,-0.63545641855403290,&
        -1.2591742990680439,-0.17690439121792670,0.30721206783922583,0.27607068860482092,&
        0.64997793897165490,-0.47857688031785295,-0.95013163364958941,-1.1264343983436338,&
        -0.29312733272721836,0.10943390845140416,1.2424402525600438,0.32244667929599025,&
        -0.39837733892571814,0.50942701846728911,1.6388687829395638,0.46844653580753010,&
        -1.5375958051576695,0.27762535807559596,-0.49549824561598388,0.30771176488289409,&
        -0.72702965083126958,1.5269876711331469,-0.38556077962079938,-0.67132980706232204,&
        1.2239781125021065,-0.38189338937132955,6.4747312734582646E-002,-0.45989911198396949,&
        -0.75262086345931267,0.43790358577834282,0.19902985684468200,0.87336510369018172,&
        0.95914642711386189,-1.4688083309767068,0.57099557142503310,-0.76121468360739553,&
        -0.33675806822267029,-0.12331044143242934,-0.35790800213979340,1.1174109103515921,&
        -1.7593792815598985,-2.6713099233682902,1.3519692288778091,0.74372121488139076,&
        0.10337888317220857,1.1721861174178207,1.4233328446102234,2.4918705094046376,&
        -0.76510430635479654,2.2544516524559077E-002,0.81337831147891104,0.28943557851784468,&
        -0.22233290498261574,1.0793898327091109,-0.55050677043606300,-0.97973915234009967,&
        -0.11265161671499550,1.2124468215515101,-0.20227710375417166,1.0229565146317250,&
        0.98199301252947113,-0.77020954141218234,0.48621571376407086,0.23358170957392652,&
        0.70651228571770230,0.58633747426095018,-1.0516434745340315,0.44311509349130540,&
        -1.7597805264737714,0.21524279977406879,-1.3833314182861800,-6.6828577494356417E-002,&
        0.35634632578656078,-0.96057061646399944,-1.1088232086674725,1.1584485693914157,&
        1.5804969318969171,-0.95070805152334592,0.29312404283702342,-0.73007358087917396,&
        1.2676913788026598,0.41324021821455065,-0.75824752089115122,6.6893235849345284E-002,&
        -0.60381733040158325,-0.43134422494320540,7.5744433097337596E-002,1.5748866550052083,&
        -0.46935754315895978,0.21063391077952487,1.5743681308943835,-0.93038513210700835,&
        0.79756368147667067,1.2282788121976969,-0.16828909304936315,-2.0555969369569538,&
        -0.39398685759184549,-0.52976485537674600,1.0026955377719611,0.87879786993816611,&
        0.94547348143080245,0.61710528601416903,-1.2069227775409674,1.0743672717878923,&
        0.33322509681898138,0.65246684125802357,1.1337649208684393,-2.1666553778286888,&
        -1.2780858187629391,0.63224422237376254,1.0273382926192338,2.6324616644946652,&
        -0.29787189981639195,-1.0289391967066193,1.2095853793565866E-002,1.4012880098417215,&
        2.8555557839141321,1.0787259378082508,0.92990066817471495,0.64499615586278147,&
        0.43484837913491980,-0.59176141247928982,6.3872568286318085E-002,0.39874803202122705,&
        0.51825634367843032,-2.7409218339098543E-002,-7.5315854730054352E-002,-1.5844545757328679,&
        9.6362098663559034E-002,-1.6939157219153613,-0.57259222222765571,-0.38922210081038450,&
        -0.98077243072851639,-1.6060875307226445,0.66638839120149573,-0.71689919197883401,&
        -0.36213887753279461,1.0068020415155310,-0.47814743098339962,-0.97358431988570437,&
        0.14334716001648545,-1.7991538029878711,-0.56299976912904737,-0.30665862014217454,&
        0.15197106976356997,3.0495848020889129,0.14276308855199477,2.1453229882305762,&
        -0.78407784762157506,0.61772407174587940,0.38083084248195020,8.9105419626891322E-002,&
        -2.0046216881468104,7.2692579008491742E-002,-1.3799145910808597,1.0616108241888693,&
        -2.2470820891796173,-1.2288701625953000,0.86840890378325242,-0.84755624451739231,&
        -8.5603134561887770E-002,-0.15258182019926814,1.8073385556722459,-0.61489801037410752,&
        0.78651404508584044,0.37787069794027400,1.5592276025410399,1.2155035106329499,&
        0.48037432834452565,2.8264938839594307,0.17487348660448765,-0.73195432624370538,&
        0.21396602744013862,-0.88819850727077299,-2.2279895520130894E-002,-2.2311079730572141,&
        0.89575412504421414,-0.76686311308742106,0.50139531899597756,-1.0770391318105164,&
        0.31103580736840725,1.4098375651358741,-1.3053251846997745E-002,0.26280783572935440,&
        -0.61691517409219410,-7.8828734231641995E-002,0.62372088712286389,0.31532657751123255,&
        0.41681742489126172,-0.33174464686436889,0.34172786759555485,1.9433996567215046,&
        -0.53524264879284267,2.0009109123851329E-002,-0.75110770151299078,1.2767108136679144,&
        0.20900802093750881,0.19208609546611521,0.19522428109175763,1.0615269292062710,&
        -0.73453315810435549,-0.37898709343935200,1.1359454080985563,0.89871711885513250,&
        -1.7216439027174242,-1.0241216097179011,-0.84524241302064018,0.20450617663441911,&
        9.2796130861027906E-002,1.9862276839140742,-0.13448275179637809,0.54888493455118648,&
        -1.2102741265483110,3.0611038106599903E-002,0.67761199419909035,1.5701319499090047,&
        0.59684185975914328,-0.23980812598658319,0.28147970884312196,-0.34818057019247750,&
        -0.31402555614065158,-0.43979578662693841,-2.0832246279338367E-003,-1.2669371799893741,&
        -1.0605405403250860,-0.62356539800772526,8.0013240845156708E-002,-0.69839897168575105,&
        -8.8047692098771238E-002,-0.29707645179115189,-0.16595623868874301,-1.1770420759331919,&
        0.96856384408826524,-1.3154909447474146,-1.3334285277663642,-0.77008616357928572,&
        1.0692549664353983,0.59065689803598476,1.2233526719732892,0.88896146434757939,&
        0.77814247311808404,-0.12922369648707696,-0.49032400422537248,-6.6909347658461113E-002,&
        -0.62050661037860799,0.73195122768807130,-0.53802748154270519,0.10811955279911295,&
        -0.64979623980301071,-2.8912087784172282,-0.24093401451322602,-0.71684019630689533,&
        0.76781639149663250,-0.58434751505638438,-0.60079330008333554,-0.32779489524762945,&
        -0.57530517447239260,0.64255131756499007,-1.0845466743903296E-002,-3.3286842792841567E-002,&
        -0.33282650273886361,-1.7771758008399758,-1.7619361088584002,0.39100910357612262,&
        -0.59911584310005872,0.44030857789753841,-0.89821278539512561,0.11511315669379762,&
        -2.1719768428140616,0.59153622713616527,0.10878000523223652,1.5964413196689615,&
        -0.40819074722671939,-9.6176393143909793E-003,-1.8488360254900460,0.43976214889044352,&
        0.63411701952335431,-0.15031620946443242,0.49887523060899447,-0.13382557801022449,&
        -0.62480022930030488,1.0340201478332818,-2.3983473063801100,-1.0105939561490895,&
        -0.70506464555736659,0.21410279698909440,-1.0758958781164083,0.69281243282919303,&
        -0.93169025128456906,0.91179229744491852,0.50548742532792601,6.1104345794515742E-002,&
        0.49311690547404546,1.0049149375115458,-0.87709857994401319,1.1632190374508218,&
        -0.50654527907171698,0.33225793106683121,0.65863305254047622,1.5085234632765432/

        DATA MC6/-0.89843679605612237,-2.0576086938310190,-2.4707335147218208,9.1697924962391028E-002,&
        0.89222154993686553,1.6376816393265967,1.6385449394260163,-1.0374805287585922,&
        5.4564317210392718E-002,-0.74678049542701297,-0.22843815217152041,0.23663967870888530,&
        -2.9771932948251258,0.39878787213571582,-0.32004161921988861,-0.50569861636083768,&
        -8.8438373136707910E-002,0.78694627587012289,-0.15839176061799423,0.43105499668558628,&
        0.15825731430500353,-0.81619058215960771,0.16938671395459534,-0.79479890347604043,&
        -0.56801345593859787,1.0373880976211671,-0.13465018915665478,0.74805443989554510,&
        0.38337755393138995,-0.87143765986391319,1.0773904177588485,0.79345352835656946,&
        0.23951375843329284,1.8990249001255914,-0.23060428528995508,-0.81072962964125228,&
        -0.67709468512419113,0.67754152379499666,-4.5931989237953351E-002,-0.36530180520852740,&
        1.0295501276861756,-0.69451454706524118,-2.7337329591854442,-0.99975517176008233,&
        1.1193200696791861,-0.12501410915138692,0.77984311744212576,2.7430077402005093,&
        -1.3406418545459591,-1.3803996310300481,-0.19707731667154910,1.1407163826829019,&
        0.78048576574940320,-0.32756634748633257,-0.61539254287061185,-0.43640724176659229,&
        0.46942996004864346,0.64342276747013105,-0.20862243152952906,-5.1788150712596279E-002,&
        -2.2862691495144148E-003,0.82191032660617280,0.34100481120149595,1.7453527388427170,&
        1.3291095934493360,0.18330953133765907,-4.7781085035910414E-002,-0.44160476527070969,&
        -0.24104058209018567,-1.2009967583523355,-0.84705577955298161,0.17181610424565075,&
        1.5031581697858263,-0.88469372961501225,-0.19387929406675497,7.0120470484529587E-002,&
        0.15640608290009983,-0.34391416515108780,0.50475138893160387,-1.6286239993242959,&
        0.42936771923061262,0.21918476727262490,-1.0355158941845284,-0.71734022542552678,&
        -2.2548915123862865,-1.7751452576724813,2.5620502022954518E-003,-0.14163129101872310,&
        5.9286049182501972E-002,1.4847798775697385,0.15939524916972098,0.28759549029753001,&
        0.18679102940574685,0.11265874758480657,-0.93653384856795319,-0.89289681270296217,&
        0.56893557731742583,-0.16562404080345330,-0.80288361127106300,1.2784638016524290,&
        -0.20029136277261500,-0.60714840573077067,1.1903933368951833,-0.18156976442986772,&
        -1.2955023190226340,-0.78697003296631107,-1.0299339204904649,-0.26428927398506719,&
        -0.26171843741256412,1.7689484708486052,0.82116090986766732,0.44890198916787699,&
        0.66551137895537182,-1.3328391924056173,0.55369258168045332,0.59276223473329115,&
        -1.0292156890023194,-0.67959044023791892,0.64014279808392072,-0.50562210315158584,&
        0.82361225436717023,1.0715319298299359,-1.7068607758336640E-002,-0.40326581567277214,&
        0.56259347141169636,0.14529038895957450,0.84309798400391212,1.0781609265331584,&
        0.52121970998622591,-0.44797767211817918,1.1657635814524678,-1.4674742053022529,&
        -0.47575976652368551,-1.3266329342421614,0.45017679407351990,-8.8937836199616163E-002,&
        -0.38283605071862659,-0.31456016955494803,-0.34051638941592666,-0.74995828883539739,&
        2.2525379071987466,0.50660956808350044,2.4959398769119141,-1.1154763495272275,&
        4.6193997854289272E-002,-1.5676779320189087,1.4603650768973291,-0.63732818236259470,&
        7.2859402135338508E-002,0.96746837248377804,-1.0155299815545717,-0.93828380651955301,&
        -0.89268083868380388,-0.25256841118817674,1.5897731533270520,-0.73001886862925580,&
        -1.1473847920295384,-1.1729221607593547,0.89260662090051135,1.9179498684533760,&
        0.83206799153730815,-1.3615621886780844,-0.61018155845845912,0.48232864602525366,&
        1.3570536198014560,0.34415055526670674,1.9883867068106900,-2.0557435716619561,&
        -1.1617108713725302,0.82509708797293735,0.11779242511398040,0.46618853066106308,&
        -0.14679752175470784,0.31614655476692305,-1.7208280020663760,-1.7866036110252315,&
        -0.81371813177022667,-0.24659351669134788,-0.60982751071581331,0.39512227171821529,&
        -0.83112349516680029,-0.21128943627576000,-0.75871335231688530,-1.3532605552055128,&
        -0.59883508139526120,-1.0385829187129216,0.75777978769508780,2.7915852153010201,&
        0.56549773687987392,-0.18702915470115133,0.37437560460194380,1.1698648665226379,&
        -1.5642627093426882,-1.5898914217195519,-0.55922101474766994,-2.3565387537837408,&
        -1.5825246843923793,-8.1940935613663585E-002,0.42722018359189928,0.27788825258767841,&
        1.8143481730769191,0.81749329974791296,-0.16751984817125917,-1.3864462130367232,&
        0.42200219203357714,-0.22352393771178031,0.22916112453354145,-2.6105797205550250,&
        1.2335105132985338,1.0418590550414464,0.31598221732424225,-1.8790968189970685,&
        -0.18769967389855508,-0.12828211314599092,2.7981266586246157E-004,0.78645745969173109,&
        -0.73833135538515338,0.56803857883535624,0.81071561392744407,0.69189241249096400,&
        -0.39443675111736182,-1.4868056753040166,0.10939042932888035,1.5078861438642217,&
        2.5003661558644099,-0.32171280996337126,2.0954144272779973,-0.46157568868660398,&
        1.1948314963892850,-0.84860417656832565,0.89840326474563448,-0.35180421724053418,&
        0.91233562721145478,-0.54966934699652570,1.2074940965067760,1.2877360284648216,&
        0.39040747569054401,-0.31314272516682473,1.1185959583474894,0.81286514182566805,&
        -0.24415657987582029,0.18733571999544354,-0.48634918905741764,1.1408745797950486,&
        -1.0594810506250552,0.92653305302670419,0.24989083954908164,2.3346529935822216,&
        -0.33092826766871880,-0.23599710775922930,0.11800696065338706,0.33954463723832445,&
        0.37468587867012010,-2.3521069049394803,-1.4992259425278271,0.77167155047162228,&
        1.0121144903535439,2.5996213972416655E-002,-0.12847104858973457,1.3691269793535950,&
        -0.12530063810042943,-0.79338731435089838,-1.6893391137942817,0.42427796536703194,&
        -0.67050417629013503,1.0421059326671440,-0.93347389591889440,0.51471113541547808,&
        0.61090860663489921,1.2897599876512935,1.5316966273265931,-1.8788859085084542,&
        -0.87903830216396084,0.81580104342697868,-1.5974771405014063,0.46223429675047029,&
        0.73643220508236196,1.1876748402364261,0.42331226637710651,-0.22557125563338859,&
        -1.0622923942613003,-1.4358559987282007,-0.82781872386134969,-6.7728167686781054E-002,&
        1.2586803053652724,0.84065909394669136,0.12843702891518305,-1.5240843260137944,&
        0.56728721058291476,1.1279577755473371,-0.16475455916792922,-0.13925475111932611,&
        -0.43027760051676617,-6.4788947837439811E-002,-0.64361964134039384,1.1329853071545268,&
        -0.53083605763137309,0.65110403173730380,1.0359911130490540,0.71894707628490973,&
        1.6766860992137667,0.84151387399265942,0.30324501960232569,0.61251188738738038,&
        -0.67812961502756242,-0.46072731576682097,1.2819275051474563,0.94551113001198273,&
        -0.49861859127298019,-2.0139491640308358,0.78363012446112823,-0.54088558083384541,&
        7.6322747105333349E-002,-0.50361303088862608,-0.63044383145987060,1.7116325957196403,&
        0.64104289421197824,6.5157164384451544E-002,0.16910721397445641,-0.11074704337585954,&
        -0.29050920775248079,-2.2892660743045194,0.59908512761522703,0.43003405107205728,&
        0.96306811211186594,-0.64496314839248803,-0.17607088652463668,-1.1912646755721177,&
        0.35716790291298522,1.1672041698802507,0.15559034484877593,0.83042030420619639,&
        -1.4978156045871562,-0.15253124413944663,-0.31452901407298939,-1.5016797655697054,&
        -0.38366645260434790,-0.35627877251802220,-0.72993385089406071,0.52340760528225583,&
        0.85175501249794572,-1.4632397243130852,-0.89966567243812723,-0.51282055865456233,&
        0.53358488869911669,4.6146597898149198E-002,-0.43172068658402807,-0.59167721405384843,&
        0.13757690012567228,0.57028474504533899,-0.88365100562888510,0.42922377692607100,&
        1.8740815791077889,0.34074265624739414,0.60638776041255960,-0.30716662841064057,&
        -0.26544513359110461,0.32915381276419003,-0.20987773800387616,-0.96783193510700893,&
        -0.48180065489581780,0.46434749710140943,0.93050048991450274,-0.92212074648469611,&
        0.66656288325229440,1.1926588068709993,-1.0746956591408390,-0.19376131500995525,&
        0.43226177676705968,-1.1434933622757952,-0.25390872671291087,-0.81452131898533786,&
        0.29926259206821648,-0.80369560379607818,-0.77415877207823658,0.10046819332192673,&
        1.1011722403086124,-1.0994509081219399,1.9434869680658586,1.0101020146511648,&
        0.37768543543444177,-0.11141849593669155,1.7641448383924430,0.59622193163994786,&
        -1.2370137765659919,2.3134985031003632,-3.3439872923294589E-002,0.40174045274734776,&
        0.24637724883393844,-0.23794774686133244,0.75235590422896614,0.59079095632083167,&
        -0.92600263103649982,0.70546007121495169,-1.3549699152769199,-1.5214751053379167,&
        1.0328151900444575,1.0878083516489458,-0.28118713635771425,0.23474087122594028,&
        -1.0662972249718872,0.28213038245447863,-1.7403184302361818,-1.4487387175177580,&
        0.60652023278865819,0.66165115325388379,0.84773210875543270,1.8400539550780772,&
        -1.4943140480151020,0.71636890513542317,0.27711187833612833,0.26673544726022497,&
        0.94719314002140720,0.13280071206847069,0.47640137669667748,2.9929875409566320E-002,&
        0.13190425237007000,-0.94256857365678037,-0.18206105230083311,0.34246077634962491,&
        0.53825647249856368,-0.34637760600186834,-1.1172477095924953,-2.4302180739988861,&
        0.20370251331556352,-1.7419185053555739,0.54784682797308104,-0.58796226023545417,&
        1.5309273613051102,-1.1128905856959252,1.0900929973980826,-0.49681782312762302,&
        0.50009454752681359,0.16527045161158144,-0.49366426255237011,-1.0387785019172302,&
        -0.75715617257224099,-0.47840198206730644,-1.1875012929697897,-1.8795854182785847,&
        0.12974129689429714,-1.3418285922381969,-0.66315658650318798,-1.2879798691919806,&
        0.39204147014826546,2.6041008735432570E-002,0.31687966339066626,-0.79446029597146317,&
        -0.45320276097276829,0.54295416514541661,-0.90512322947596513,1.3199362166087385,&
        1.1997283153661638,1.1007604145448695,-1.4729044371871414,-1.7840340992211814,&
        0.80596805543757855,-2.1915185839369737,-0.60553752753548895,-6.1765400937714078E-002,&
        0.25746780538737740,-0.21722693383512298,-6.2289905426075546E-003,0.11996972278069712,&
        -0.57498513631254833,1.5858009650641778,-0.37905852639162640,-0.28442358181283200,&
        1.6049852753311156,1.2923843943934556,0.98318200972268666,1.0715252652203837,&
        -0.15224387516443738,1.5320217944450227,0.97059352905268337,0.91772561319434298,&
        0.73216265755690835,-6.1526691765953427E-002,1.1103094493134442,-0.36111526442891384,&
        1.9445056622914327,-0.47750417862822769,-1.0072257594499987,-2.9164133579798324,&
        -0.75553086624727528,0.44017841644652816,1.4824042719432764,-0.42096966685052895,&
        6.3603520908314601E-002,1.5802086676670997,0.50319184722384558,7.8677395173547604E-002,&
        -0.11869198664558309,-0.65021306497458087,-2.0538942280271870,0.18185033802429487,&
        -0.47398295893090808,0.82962037029256752,2.0034743518507003,-0.22689393103883962,&
        -0.38885163029173653,5.6633236810770704E-002,-1.2365286619045475,-4.7949068527494779E-005,&
        -0.21910318644396273,-0.40819495639540732,-1.0093992931215698,-1.3382513717921816,&
        -0.29372388608237077,1.8491357843547631,0.43071910309934075,-1.1751293471193871,&
        -1.8611300002664142,1.5342375404629103,0.17379125089954822,-1.1280478668006793,&
        -0.59561701059313044,0.21955990872671463,0.84089242780248374,0.23152106227923339,&
        -0.10770285743234601,0.42455476100591882,1.2041818053598765,-0.17785902834218309,&
        -0.63052677614977037,-0.90049309112642495,0.10352576260936323,-0.43270466408710634,&
        1.5680072683030499,-0.21664350506502733,-1.0314864483043593,1.8255128336318356,&
        2.1812965868750185,0.85195261375268760,-0.54270806485192324,-1.2906002248420809,&
        -0.28890804616179866,2.0565891097136078,-0.80252954257480513,0.49957444808634144,&
        0.22042802960065944,0.21045200046678417,-0.55964199549068028,-0.27969570083439765,&
        -0.31920499635942345,-0.19406430891199328,0.30283921968814392,-0.25217495174849647,&
        -1.3322838704499154,-0.38317354561310280,0.53244041926029639,-0.92014310402368771,&
        0.49033838172017391,0.68042914234586593,-0.68956937285584030,-1.0869316012835903,&
        0.55977527330950738,-0.19771379592366881,-0.17323120300195297,-0.81733862172666971,&
        1.2541611547195481,-0.31997276099947636,-2.7637761683774933,0.52471966736896647,&
        -0.82826373798479835,-1.4195092863937906,-1.0211028977455634,0.98634197878112362,&
        0.83140246327744804,-6.8331966774960798E-002,1.0426452717112433,-0.32703320015911946,&
        -1.3822153229300322,-0.39870618867397289,-0.37070270409179856,1.8517984833366277,&
        1.5647134489001964,0.39422100383659425,-1.3905424999693727,1.0377617462255946,&
        -0.19654939422049264,-0.10582677090503495,0.52728380883629333,0.17458067918497183,&
        -0.23346169196985755,-2.3327948213656682,0.32511704767406469,-0.26398932266895264,&
        2.0824922794122314,-1.6215257157426888,-0.42210784745321572,0.25434635168100656,&
        -1.3180536849171067,-1.7368542325916483,0.58714531761158795,-0.43808993806987290,&
        -1.0419765002064543,-0.49852412840756793,7.4596066977505440E-002,0.45230928425331762,&
        -0.40676525206790382,1.0324194473597128,1.6981273892877116,0.40242053519517867,&
        0.23116457050056083,-1.9375709565805745,0.70229333716630671,-4.3085816611236234E-002,&
        0.26536610568052010,1.2801007506765143,0.86116680859959638,-0.22540981317006212,&
        0.21007051280357122,0.35010567116075697,0.61784513110315853,0.34723401713622520,&
        -0.45524690296460163,-1.3303511443024265,-6.5038428954523345E-002,0.14415607235160596,&
        -1.1779092796401096,0.99006925711099647,1.0676337040465478,-0.73540167186047622,&
        -0.23684754811143399,0.48068128670529287,-1.4353647765890132,0.33653681964114290,&
        9.7421318024391135E-002,-0.74780917662963564,0.22778858255444628,0.44640041410589676,&
        -5.1339963360843989E-002,1.1852512724863764,0.99731243509754841,0.26985485509216528,&
        -0.13672489537789076,-0.65241311133520763,-0.91908329050118998,-1.0800461670818129,&
        -3.6723656357757074E-002,1.9474197941756717,1.5905730860938287,0.46948382619155565,&
        -0.52660552571009756,-1.4144618030921852,-0.70919330778559542,-0.36863153740983440,&
        -0.40552479130034447,-1.0893295492922046,-0.86492290239886260,1.2672044936356948,&
        -0.13441170979954228,-0.31213479801585442,-1.3517354107124198,-0.43105000388612130,&
        0.85595276137242760,3.8279507325350660E-002,1.1875852842325278,0.45965600878278023,&
        0.90748260229445521,-0.54380948765644355,1.1486407539896291,0.67124346957657177,&
        -8.3783693565522080E-002,-1.5556215794986519,-0.40533004583786725,-2.8157127582708670,&
        -0.72199982294349396,-1.5458849034513871,-1.6540588754507701,2.1995275039154394,&
        1.0105088951817673,0.82476285110742897,-0.34030718153827927,1.2000383342305374,&
        -0.40514499800390819,-1.1343012118437685,-0.29502020266035922,-1.6871826696498001E-002,&
        -0.57942058605904334,0.25799165015890890,0.60914320338174621,1.8353925988979838,&
        -1.0876424764071657,0.66594191326065000,1.1262045762415116,-0.47375662108605193,&
        0.68776676429732531,0.98701664141202161,-0.21545238776870287,0.27156850650295555,&
        -0.11495516783698488,1.2463883235004320,-1.2584776580652952,-0.38249956791475626,&
        -1.2469201661088360,0.14581179634553748,0.44933385388690034,-6.8784553655262051E-002,&
        0.41954740945599861,0.20969881832948040,-0.29081274852310446,-1.4876380672124780,&
        0.92126404057718103,-3.4057115749186476E-002,-1.3812120436004556,0.41613817779397533,&
        -0.86111876610366944,1.8268257434319322,-0.89440092061917797,-0.65199025744352135,&
        0.79879288319766084,-1.4758175650654339,-0.70916505575125144,1.2643734542006981,&
        0.14264175537910548,0.68965991720884223,-0.49467431509069920,-0.26684022107831840,&
        -0.52703223505183172,0.32391541780560357,1.4515325889378698,-1.6580441841546711,&
        1.7397835035022653,-0.80916399894019875,0.36888107237976225,0.16826880245771242,&
        -0.27612706578306584,0.82368593575045945,0.25846412058131618,0.38740335027022504,&
        1.0353647850342460,1.6217173266151541,0.64515813298064384,0.63022808502354111,&
        1.5008741412159994,2.2104828003098635,-9.3565241583530953E-002,-0.14457981954526572,&
        1.3006927351140249,-0.15280682662109388,2.9628359039560438E-002,1.8888396275566766,&
        1.0274640178597705,-0.13186020886518199,-0.66846779102399856,-0.79177903456816334,&
        1.3282631483792304,-0.84557973219633320,-0.71405814669423862,1.6994638219609031,&
        -0.40535841180658427,-1.5272910682184027,-0.66411870018652985,-0.37214470669595617,&
        6.5682481317364858E-002,1.1479966687555809,-1.1455864120603978,-1.0173593618901910,&
        -1.5590723428605493,1.4520440315634078,0.41986065847707982,-0.72702795597590464,&
        0.64430895922399323,1.4569386239371691,0.19189217240877132,1.4136703178983867,&
        1.4015888374430794,-2.0527205240874653,0.40642246489989703,-0.80886813303626437,&
        -3.0153835149700647,3.3753380874943055E-002,4.9837351652766718E-002,2.0333847606611917,&
        -1.3571672195537861,-0.33117588252400154,0.83728108108630972,-1.4628734507686207,&
        -1.3577977037087490,-0.15143345646369291,-0.39052123478371981,-0.55002574954028605,&
        0.19609802132264126,-0.57101432008071040,-1.0521728160227835,-1.6412598935567400,&
        1.0382400294597265,1.0861375590434093,0.67843753659560213,0.17059807321259896,&
        1.0998684869185731,-2.3096664075933526E-002,3.0725113950739411,-0.63886034364759536,&
        -0.24910281112980520,5.4377079035123456E-003,-0.92623369397260924,-1.8505318672620814,&
        0.62343489505097838,1.3415903529213244,1.6861542757638228,1.7960375417923904,&
        1.2833937133856952,0.22448992220291644,-1.7764368431207314,-0.55143194079295565,&
        -1.0998670769069130,-0.31114035550547020,-0.94802054912689049,-6.2980954382893514E-002,&
        0.35369877089085427,1.0910829005934106,1.7852360682869597,0.28323746672611450,&
        -0.18035783220067605,-1.3363997193034141,-0.38028615066233240,0.25791289899731334,&
        1.4609536044742868,-0.24415371867015911,-1.7642197310244605,0.86049375902804115,&
        -1.0593318578282573,0.73975702756562733,2.1285618057679510,0.91884996661081519,&
        -0.56861730588013359,0.35592896704899096,-0.32909363788949442,-0.27990719555868782,&
        1.0492054304091689,0.38429819636482104,-0.36460963505687355,-0.33705853021019500,&
        0.99390663158764325,0.29837694689991112,-9.9715732841496971E-002,0.82029638747180367,&
        0.94715090052835904,-1.4835055176840442,-0.83486202743184112,0.82672740453365656,&
        0.30167748142312517,-0.62550141629222689,-0.25594734663464702,1.1247819992365020,&
        1.7050321528076466,-0.26442849691509918,-0.20488915898969579,0.96893805195778249,&
        0.70611693960795097,-2.1857310990669885,-0.27451800185794245,-1.4042498286332801,&
        -0.69864024334093289,-0.42824101082355776,1.2255932786354906,-1.8823069297212638,&
        -0.55464220995463065,0.82245973487433122,-1.0616761430292394,0.35834632072603823,&
        2.0224889814854889,-1.2309220944181976,-1.3450984131917110,0.23362983596462567,&
        0.14486030500469657,-0.23947781431510337,0.73589729857933772,1.5184132941818060,&
        0.23800027138202992,1.2290218783943447,1.3375961660452584,-0.48316911376659183,&
        0.66678132940349744,-1.1933817083275318,1.0860351138228759,-0.82553692698937431,&
        0.34631820118377649,-1.7791286786638720,-0.62257408612226828,-0.57653472229581748,&
        0.65024372906539907,-0.65176036691174988,-0.71283519878670210,-0.12248022407695267,&
        -2.2182944609876958,-1.1134176748144184,0.21160394067588789,1.4809138570142922E-002,&
        -0.46665695404399132,0.19745216341886565,-0.49950211112183390,-0.45313691638365811,&
        0.49389399939405321,-0.11991557358425736,1.9824464552427958,-1.0697664374295777,&
        -0.33797631803738087,1.1217504035649191,0.79818797859468926,-0.23478632263916546,&
        1.0090786794660789,1.1474488682445709,-0.10911465905955224,0.84104131687404948,&
        -0.70576051430528264,0.41791214133035393,1.1997658518514425,1.4988687920266404,&
        -0.37346871843060170,-1.3299318748996829,-0.38153177287159507,0.27041744641156162,&
        1.5951452632864278,-1.0791092314179735,0.36681309892612063,-0.29541574694466971,&
        0.10133363214894858,2.1999590951902297,1.6451182512878828,1.0495913201614917E-002,&
        0.15159612083196508,-0.39761497693710662,1.5163483721958326,-0.63857538311967121,&
        -0.54090406484731135,1.4522568176765802,-0.78728462146740663,-0.43109452132502213,&
        1.0583256418818439,0.28645543297824910,-0.69487176422543695,-1.4764509470376934,&
        -2.3226623229465511,1.1982313662935591,0.69737572010711901,0.14021562424132328,&
        0.11111387294608960,0.25160073274289119,1.4972081139089086,1.6659044533718983,&
        -1.9031805626239304,1.5455048617513218,-0.51541110917038635,0.31034351180332381,&
        -0.16380902082512430,0.63104032127168519,-1.2994417191720453,-0.16722116379951171,&
        -0.26991390966977102,-1.1938802336320673,-0.31817831167314625,-1.3518188545447694,&
        0.53394422466430014,0.56634927325858875,-6.2463372778671186E-002,-0.67880423114805410,&
        1.7614462710462795,-0.36201098816018162,1.3542430903441758,2.1787121096441742,&
        -0.20592349845467711,0.46355345094016986,-0.45583476222554414,2.1484964474385286,&
        -0.44067968762161214,-0.30795159027598557,0.65781019904014504,-1.6862758157949524,&
        1.6445070538273574,-1.2853872922620833,-2.7696832487651450,-0.14490093156830275,&
        1.8895078701623160,-0.37179567909567512,0.82244167894053932,0.67381417798294851,&
        0.17657752741706143,-1.7714941993633830,0.85979805369740814,-1.1955771630161993,&
        0.17653794713282794,-0.91746285661856430,2.5244946830621666,-1.5633875887985418,&
        6.7354847265875982E-003,-0.43927224355933681,0.15599298509651024,5.4607141493018457E-002,&
        -0.58462787129026139,9.9226198051583225E-002,0.44780637686805502,-1.1493243934203887,&
        0.21406092396491572,1.7411087023365983,-0.18588101041567687,1.1559606363828199/

        DATA MC7/-0.48540714245229039,0.13634575058559037,-1.7670970001870356,-0.73779097762618484,&
        -0.20917171257837783,-1.7321905780965245,-1.0900241186319828,8.2614540493846048E-002,&
        1.1627676087485930,-1.5542805243235043,0.65459931335137034,0.71849275195769102,&
        1.6641542444324933,0.83745388161600232,1.7252198984274296,-1.5834706797116558,&
        -0.51156960848518918,-0.86740785297733536,2.0690395734379319,-0.26397377164277769,&
        -0.33990376760606716,0.69141629697411411,0.39845742973506354,-1.2650755530218836,&
        0.79305383180870570,-2.2608821576347049,-0.11570462767575009,5.8246718144582800E-002,&
        -0.57696313224416051,-0.13874300290956057,-0.46638853398250024,0.28658015461549424,&
        0.83879712784384541,-0.55925928592618679,0.93817612955799512,0.50913385097698216,&
        0.47445903815998403,0.25109298920535988,-1.1729959811946584,-1.6569415079016339,&
        -0.88668308790735151,0.23918756199404617,-1.1467513573364323,1.3958427120852155,&
        0.24102731254361379,-0.32644169175774007,0.48997046099308961,-0.46103714631180698,&
        0.97587553176953667,-0.10198314131261028,-0.46340489960772957,1.3741605293933294,&
        0.63278403575155739,-0.74796067071196215,-1.0245450611244311,-0.67954471709886277,&
        -0.52334056000251339,-0.33031392415605432,0.19934528280525929,1.4328768623562396,&
        7.0169584494566853E-002,0.14681036206942397,0.40412156516468445,0.28198830268837627,&
        -1.0363109227745101E-002,-0.11755444625569605,-0.93001637009703064,-0.17771583833066681,&
        1.0331463738604949,0.22608065980196268,-0.88924460017136542,-0.81733123902250027,&
        -0.46160450839632117,-5.8193885955223998E-002,0.82782250975832061,1.1492850504088461,&
        -0.77260203204419908,-1.1477743144760064,0.27224978624486418,8.6446576427197941E-003,&
        -0.76326659264582519,-0.83213874685954825,-1.7202077339562163,0.69707202979444227,&
        -0.21007194823269285,1.7265051669531648,-0.67111734403073720,-1.7396380987197750,&
        0.55390644391009114,0.13447546013098280,0.44997329947945497,7.5033162545240187E-002,&
        -0.47269046392526554,-0.12281388747712695,0.19825547100658725,0.89853711606672204,&
        1.1121014594881584,1.7877996993140723,0.35936023254013300,-0.30058880312495734,&
        -1.1397741422295571,-0.37220395064105533,-0.12787771413123389,1.8044547251498926,&
        0.39890282879098471,-0.59838719482616565,-1.1550056496472043,-0.76826016110857587,&
        1.9220508340693014,-1.8815960972814354,0.68128070042859767,0.26873028444512564,&
        -1.1349601367766180,-1.5424637130164185,0.88935193857475126,-1.6618576938608642,&
        1.4224255005517847,-0.18262692580199874,-6.0509867491647808E-002,1.2241311367821071,&
        0.15507113260960981,-0.84855958474868753,1.7515742766967144,1.0699704171016271,&
        8.3477679537371033E-004,0.87185320926754262,-3.0409550698849513E-002,-0.48605455668768854,&
        -0.42343834048952400,0.64737087487892098,-2.1152183923024124,0.88125952428470011,&
        0.90917399263452414,-0.12551313858082502,-0.26437048388248863,0.10144800286654959,&
        6.9324855124474075E-002,-0.53283086806683588,-1.5646918727841976,-0.20702151547600262,&
        -0.98843315413654564,0.88446752247244886,-1.0581853649793875,-1.2598974496694766,&
        -0.44061384351631633,-0.72759678481965084,-1.3061978364187374,0.90377408972762141,&
        -1.1893641744917285,-0.23091935050142670,0.42688085114444974,-0.75887389675813599,&
        -0.42179888534637566,-0.74451858320836362,1.2572536877283644,-3.8798965830677344E-002,&
        1.6624512598793322,6.0476622165165687E-002,-0.93992439373181869,-0.82416301774957446,&
        -1.1920588572874893,0.15561493639732954,-1.9648627085653925,1.1818883108625948,&
        -1.6321245306435130,-0.63162606745948779,-1.4634847652628780,-1.3939046484531290,&
        -0.62750374229705574,0.27023577270869481,1.3460418727201280,1.5033231016648758,&
        1.1705599575538774,0.23388330637881319,-0.61459596702910790,-1.8302605697189116,&
        0.15259201292625546,-0.21916736573346365,-0.30733153413215047,0.70962478099871884,&
        1.7415618059380220,0.23810279164330156,-0.38740231567177114,2.3224667169606295E-002,&
        1.6066923487936313,-1.3671273861747368,-0.79126176008790072,1.0070520534059519,&
        1.9632542386670297,0.95085963386416217,-0.90305720943493095,0.67819760310734634,&
        -0.75716157107981308,-1.0559267641835193,-0.91560821275815896,-0.88691720698879561,&
        -7.1066863805478997E-002,2.4223368999992880,-2.2510524284250672E-002,-0.62095546341390639,&
        1.8205521873882096,-0.13955602945759080,-0.19852602472599176,-1.1325812967552622,&
        -0.24410436352311818,2.2527808994996353E-002,0.42514250627517902,0.78376762596142135,&
        0.26394555153162413,-1.3339059429767808,0.81441044175874389,1.0198834612516423,&
        -9.3374188570170255E-002,0.66309942813668632,0.28424191548895000,-2.0461332031193748E-002,&
        0.63011426499308498,-0.32480667885752373,-0.96427244710583337,1.5821026950117245,&
        -0.71992732581789998,-0.53601831613755979,-7.4738475085335571E-002,-0.82113617454627574,&
        1.0365091516993008,0.74472916613422280,0.81851151537002731,-3.0626487347903395,&
        1.4126171006353025,-1.0549995818732578,-0.24532277568478264,-0.70853352483441578,&
        0.45265922495188565,-0.31804244281896243,0.70418296072874698,5.2813831324184803E-002,&
        -0.71834092119363258,-1.1371353778703841,0.21199299504015301,-0.89988538075073821,&
        -0.97726409626589661,1.5130253225543668,0.57515802562865159,-4.2092799182581589E-002,&
        1.2158291719318306,0.32140419193391445,-0.21109850349752859,-0.45250039054099506,&
        1.1188746910688927,-1.9391238055900277,-1.0603928473219615,1.9648341236740638,&
        -0.88595047786292336,0.19903246980156167,-0.43753019406938681,0.88384256401965500,&
        -1.3451359102993588,0.62770371751021004,0.71264931624169003,0.42201612906927238,&
        0.92026977972257640,0.74843733877795027,0.84472576710644875,0.53708254088067575,&
        0.66610240930475317,-2.2240702021516472,-0.53481566647464795,-1.2685395911550916,&
        -0.32199203145894889,-0.23755391940202944,0.47654076355260633,-0.11288295186493325,&
        0.71336697219139744,-0.27781919880285205,0.30004471680477163,0.61297352433646746,&
        -1.3156229327669033,-0.30058079321906855,-0.82054909081798455,1.0831085204049737,&
        -1.0653579880939386,-0.79609836686031066,-1.3397472797792094,-8.8221661918406018E-003,&
        -0.29143724691320000,-0.51511333379937030,0.30176918300458677,0.54863692169282319,&
        0.67815940857688028,-0.18035800208856406,-1.0922305990644645,-0.50618165623472966,&
        2.3746197872483217,0.14609055570433066,-0.35548415737612804,9.0582273256084436E-002,&
        -8.5239738457021250E-002,-0.98618463676005863,-2.5223632957951363,-1.2802058380742238,&
        -4.2907809307806903E-002,0.20225986175434299,-0.31159883624462070,0.63025240154060469,&
        -1.0620471560862941,0.45475567633560560,-0.78507297924185770,1.3449826621314320,&
        0.42706279793694046,-0.26035351723858186,-0.64415220203191903,0.29581403546705970,&
        -0.16433293297271068,-9.9072827882294212E-002,-3.8710270868327019E-002,-0.86814974997562955,&
        -0.54331436919743026,1.5269930343149394,-0.77813581641399499,0.77836138684652212,&
        1.4103266244761468,-0.98397416897032297,-0.11468345047107498,-0.32050441786695505,&
        1.6051781528184734,-1.6026412461051220,-1.3377485892267422,0.30748659796955635,&
        0.68096771712396864,0.35905465440996620,1.8931837352332950,-8.6070712749637956E-003,&
        -0.17494621615684369,-0.42081628038612778,-0.18969539141620897,-0.11376825034634083,&
        -1.3024296556354114,0.33374511269510554,-1.7731777987850743,-2.1636912727110480,&
        -0.81484667638865049,-1.0648192370605116,-0.52837396049343599,0.30638908268060044,&
        1.0647962281601758E-002,-0.69427039390448486,-1.2723666931276922,0.41284561460101166,&
        2.0550540506047312,0.43998702291833974,1.1283167323572851,-1.0331895025334259,&
        -0.27450711396583721,-0.51639746091539263,-0.57171480342183867,-0.73242779895005272,&
        -0.11228428853895339,-0.43281297421273096,-0.80507738960698783,-0.91799990350541194,&
        0.12440306957164211,-0.18630931778226104,-4.4344847823552004E-002,0.52501221199274239,&
        -0.37139488606991672,0.32651095820151971,-0.66625193359885004,-0.86517927071876921,&
        -0.28007236757538745,-0.99737488701500743,0.37945227640419488,0.13157148463705262,&
        -1.1652490681745695,0.93649751810964843,-1.0401933136523458E-002,-4.6103421020399708E-002,&
        0.18080511995642157,0.52513241228472030,-0.68316178050782184,0.84501947345539086,&
        1.3509928342284208,-1.6496511241609191,0.81083930039083474,-1.3680966853682806,&
        -1.7649076400466992,-1.2881822602933533,0.34548156573027644,-2.1732433043729587,&
        -0.65947332996797259,2.9843348476343756,-0.17492841179325427,0.72202337976304343,&
        -0.18615603311640674,-0.99202074204136337,-0.15443404808567771,-0.26467748725487122,&
        -0.92923717311659582,-1.1089711175439247,-0.45729273213171839,-1.3772835548659779,&
        -0.92277947683869221,-0.57056730304768122,7.9220764199612770E-002,-5.5710515572290654E-002,&
        0.31011724407022562,0.39682610792447987,-1.5736785363850219,0.56006735965300236,&
        -0.23688643806588180,-0.64622059791443986,0.50602688351217173,1.2779490657565316,&
        -0.90102959190801890,0.81166621963296615,-0.94715223252847380,0.27522945951109190,&
        -1.1360042988166259,1.5583474265502759,2.5026427731902573E-003,-0.42618573823047984,&
        -1.0582211298153033,-0.95317395282076933,-0.74037247414457230,-0.28919215494341011,&
        -1.7509407892598368,0.71423589917641850,-1.4083842244736380,-0.28653177321585710,&
        -0.33194851361158761,0.74667146732787948,-0.62502195673528049,0.91099510911185111,&
        -0.32279171634159765,-0.90081482029536752,0.64447761185167129,-1.2480526356559378,&
        0.23873934060151883,0.77554667834817514,-1.7459606616397607,0.60393348158784388,&
        1.6456424191679235,-0.65738277708837178,8.6830844027426649E-002,0.29918181336359934,&
        1.8511061695890276,0.87869420417607413,0.82795381513539235,-2.8864479645325448E-002,&
        1.3220930408151430,0.20655347884629166,0.32363020810085791,0.65033866575226795,&
        0.16157807269407470,1.5142965897782337,0.61926279935788531,-1.6014103416893247E-002,&
        -0.58350890595619975,-0.40572114387817509,8.5658660065531189E-002,0.15624162612673509,&
        1.8674666779152131,-0.32811274013132258,-0.25115109170671579,0.79129478274871412,&
        0.18136647931406313,-7.0787275899608593E-002,0.46904735450548907,-0.29400311315386379,&
        0.23783402803376122,-0.53176610122708257,2.5576087876567737,-0.34518262881801126,&
        -1.8665369500317259,-1.7996949129884630,-0.34147494507789256,-0.30276529032753707,&
        -0.20877718972952325,0.91594854759867950,1.0059720811050772,-1.1469685173338942,&
        -1.0380711549785342,0.87438825873713422,0.56926911875817499,-0.11278896928333614,&
        -0.29442326804126984,-0.11405615878958343,0.59906932964846504,0.76190469940199168,&
        0.40430101315843459,1.0178864785108763,-1.2096581228645678,-1.7002341701850963,&
        1.4543589045036036,1.1572437252123273,-0.41195696865042325,-1.1699949485737802,&
        1.4040886964456307,1.2701321282727704,0.21515543202508722,-1.5613644007696363,&
        -0.59046539348536320,-0.43275538739165914,-0.11227162302163383,0.31485887941150792,&
        0.29268025585151303,2.4123291411250825,0.21069627899144699,0.32543487119741410,&
        0.21313768816020107,-1.0396586840349422,2.1432761563867317,0.44718038248019348,&
        -0.53132480710315322,-1.6648122065057358,0.26917570479058928,-0.41381666024090469,&
        -1.3473109040029427,-0.91798695144913700,-2.0827748426904908,0.56139398446059541,&
        0.57915618350157638,1.5733761650376383,-0.31780399454204927,-0.65728314575421132,&
        0.46483457308062065,-1.6084616155896270,0.15355338703236937,-0.66327172264503376,&
        1.6655105445871929,-1.8050829940243462,0.55716860926384726,0.45660945192706326,&
        0.64294525212973930,5.3158224566037970E-002,-1.1181407632102944,0.62675269090122077,&
        -0.56502181615526004,1.8530929267692782,1.1892470120576417,-1.4348586385002955,&
        2.2167243704801953E-002,-0.69391766217371098,-0.94210739660139020,-0.90458284149672685,&
        -0.60024220003397888,1.5109549378678064,-0.22800292301296593,-0.69960949625290580,&
        3.8733500365803065E-002,-2.2548127707692127,-0.37471166434602143,0.53675937043431721,&
        -2.7368784740379017,1.4752939245340968,0.74487220961545619,5.7581237858324488E-002,&
        1.0016964069654191,1.6793286490323160,-0.18190468883696392,1.3362137152111107,&
        0.47519667496753965,-0.76001745092692241,0.39867177603608894,0.70023124057090957,&
        -0.33315268689131261,0.89172896564790749,0.51969454115670699,-0.87722659448464890,&
        -1.0251238636341702,-1.1694186293277160,-1.3303130319454111,-1.8137659734788414,&
        0.15457850898940761,0.66072466995494894,0.97182933063014509,0.74825566057997672,&
        0.22741617675760209,1.2066028180328037,0.22980485231489417,-0.85544569926047309,&
        1.8061732803228157,0.38906488465526234,-1.7182610657378463,0.49507186029108358,&
        -3.4281637015641103E-002,0.15304505153161954,-0.11170011082212118,-1.2964760266653013,&
        0.51657450889462775,-5.8621619770195241E-002,1.3433283251056456,-0.49813590193111174,&
        -1.3396875693481223,1.4934065276251731,0.45429768909752505,-2.3283033190231524,&
        -0.39090500032804582,-1.1353674645251581,-0.35565504964099015,1.3336862907815230,&
        0.37544747802589828,-0.37487326514738023,-0.72420734324453295,0.53658690098128292,&
        0.49065706346498755,-0.25769796977559950,2.4536624001348328,-1.0563972590347943,&
        0.15132437538798035,-0.42596770446120946,-0.15147016762800036,-0.15119148218811740,&
        1.8483577399613356,-0.47779329756162775,-0.88633290234587259,-0.60779224973971080,&
        -0.65733833226202198,0.11573090687568904,-7.9071328815039532E-002,-0.32906136536201991,&
        -0.60451277970976602,1.2838727742652218,0.94282004504100825,-1.7773014446617397,&
        -0.50654440233278319,0.31884348679319946,-0.57226399743136502,-2.2700986425170169,&
        -0.38003433872489023,1.2594109741219379,-0.30965750842265505,-4.5947116113430317E-002,&
        0.29572939446488478,0.21680522509154773,-0.28730098875365806,-0.56357818932701964,&
        -2.4032232196250831,-0.20101031103036576,-1.1120177591296094,-2.3870035508879872,&
        -0.31704208236389769,1.0042655981204043,1.7049375236118123,0.25209574840080956,&
        1.4513029324327007,0.37793117798336168,0.83296805324905965,-1.1211550973725206,&
        -0.92390716518777227,7.2407637354037588E-002,0.66690411801863714,1.2202927410148152,&
        1.7058505597474543,2.4800749917590297,-1.1565801786538916,-9.2956052228675534E-002,&
        -1.4712074148893368E-003,0.55001474230491421,-0.44481493146145651,1.0007886652204248,&
        -0.79719192428446928,1.2357258923316277,0.30911357506592824,-0.53698356575919626,&
        -0.43098936392140524,-8.5198626417378104E-002,-8.6194262465793564E-002,0.16534963269430872,&
        -0.26031587258112299,-1.4467658345273910,0.35172288557429171,0.72217802417026267,&
        -0.54478386631684828,-0.19850190961213207,0.33650917727489577,-0.83595251029082263,&
        1.0878635044287654,0.44287104059260834,-1.5366159911645785,1.1966809410149475,&
        -0.11226095672912159,-0.90920456904025904,0.58280385009034041,-0.80681452035364443,&
        -1.3826716400153847E-002,2.4715455739391334,-0.92711439008862473,-0.77610201929018530,&
        -1.9702171331485319,1.3833911149771718,-0.42911104219907503,0.21500550359474896,&
        -0.54731001661675527,0.99041820039284867,0.46602627851297507,-0.45232474411947871,&
        1.8169628190031037,0.57350179798689871,-0.52795145546302957,1.1611890231422752,&
        -0.89439239357434053,0.59059587682033043,1.8979382023849234,-7.7036345417564401E-003,&
        1.0376087580875257,-1.2518109616159501,-0.55131958533532233,1.5302446129686647,&
        -0.87046580063101031,-0.32914890634187410,-0.37896580453919276,0.51118509475438711,&
        -0.28034936884668443,0.25208818634821589,1.4247377245477011,1.6798612887707705,&
        1.8134510987327903,2.2613087880057421,-1.7161398830772225,0.32164862148434809,&
        -1.1368240053756460,-1.6934474444810910,0.22485316268924643,0.98775151548302376,&
        6.3531680239707164E-002,-0.38342327336849802,-0.56185674326762991,0.90433904338638937,&
        -0.68826770851874708,-1.1102437442383888,1.0091411305790359,-1.7528758655993588,&
        2.0675586403934942,-1.4364911154329272,-0.94928509741881617,1.3419330191160044,&
        0.59688658173121356,0.26562618191692250,-0.19167618765119185,0.68146936619727938,&
        0.42204230114082369,0.40553044865591520,0.34074456134115888,-0.79890449992519041,&
        0.43579757499287086,0.35771605272464840,0.99333716654596116,-1.0329092542731382,&
        -1.8570754733150894,-1.1854754187982532,-0.50149222049901543,1.3560223290912758,&
        -1.2587239628814169,0.29805671086029806,0.65807087334106340,-0.59363123284788133,&
        0.24342548206952661,-0.72114532952609756,0.22210186033242860,-0.71696933433582666,&
        0.87246201203580709,-0.16986211940808454,-1.4438874298733471,1.0976776026923307,&
        -0.51292015574302552,1.3015221481671850,2.7110185160781550,-0.12327477526336510,&
        -0.52982541525022997,1.0808482294328303,1.4138922687914848,1.1282036565587119,&
        -0.81830772680915087,-0.97513037247347378,1.1376963022879536,0.69497153620113949,&
        1.0855999376934333,1.0931031060863472,1.5101292381535900,-2.1533544297026945,&
        1.0158572624494693,0.25745214393014904,-1.2190647186624632,0.91474297867378918,&
        -0.57137697049560598,0.17692262994069025,0.57084332650608238,-0.37438934573941623,&
        -0.91767953870531238,1.6688546750073747,1.2208272891045928,-0.23228369386113809,&
        0.20196191776244679,-0.30906477697519508,-1.1349262854583164,0.39472100647468911,&
        2.4332556809342133E-002,-0.95061946371802353,0.92011733331289869,-1.2384314153557852,&
        1.8006775575957961,-1.8712607927091724,2.1192567157578810,-0.38190375270309340,&
        -0.89471913680933857,0.51430177758721074,-1.8375926063507839,0.13768984891070257,&
        -0.70236578490675994,0.16904045390648639,-0.59428026205798701,0.46387358984078053,&
        -0.20786914407480966,0.21760418657830888,2.0573570732219064,0.29654563906580350,&
        -1.2160357270561550,1.1930046153579512,0.52590647072920438,0.15539907019825416,&
        0.71247486412648675,-0.26257232450732315,0.16419561583406411,0.32440428276046734,&
        -0.67658739458549466,0.17291917542716750,-1.9444144736762456,1.2237342624503473,&
        0.61684870295213723,0.72641319189219422,1.0411161197419643,-0.88155193328142312,&
        -1.9489383703068053,9.4860607812571413E-002,1.2576187678141644,-0.70831702079311876,&
        1.2356364928258490,0.55132238812546708,-1.8397761622954889,0.51684908074369207,&
        -0.79074496065906719,0.10178304135830522,0.28018502420872404,-0.34299884328276825,&
        0.29331578872143294,-0.68028674804450917,-0.44769587990219073,1.1263988274335739,&
        -0.58382509826133477,1.5507944378197445,-1.3377096341548880,0.39779837976784438,&
        0.40446799524155747,1.9277959401367312E-002,-0.92485945994092611,0.80305115806959748,&
        -0.89472821025935512,1.8315421141662493,0.19517060370022102,0.94227569344708362,&
        2.0694308878374985E-002,-0.41316369152978710,0.12947609344350505,-1.2966296002200597,&
        -0.14227323216826135,-0.17867178560287322,1.6340317731626706,2.7123533754239752E-002,&
        -1.1561498580861254,1.6431891716073956,0.54433553476661334,0.96388103461879737,&
        -2.1107779260825623,1.8289735359908628,0.25772678267464816,-0.52093234511193953,&
        0.14546238979564699,-0.19180678717276825,-0.82822155892333960,-0.64211322203765808,&
        -7.2587694978399980E-002,-0.41590812040458863,-6.5314638854856957E-002,-0.98942151640455767,&
        0.30489631385578619,1.9084658740068807,-1.3704222357846636E-002,1.2696454138041571,&
        -7.0582487283342488E-002,0.78978580077805438,-0.27431493846533461,-0.19011246558497552,&
        -1.1987764354161199,-9.0891033896797813E-002,-1.4278235783769297,0.94654420516536286,&
        1.0425057771304467,-0.88241890387080624,-1.6557103237239403,2.2552355894177194,&
        0.83355152323447312,-0.77523663749865812,0.27929174618319480,0.74652918709380522,&
        0.85959892014213646,-2.0877825428271768,0.89541631947470390,0.46004391406053685,&
        -0.86827781804222104,-0.50428247105079627,-0.91848249343735100,-0.82088604629953521,&
        -0.55145920889855093,0.73381932514158632,0.39805140231409902,-0.53451461208505813,&
        -0.85131303176751716,1.0029654515625237,-0.53248169561485181,-8.8467831216528486E-002,&
        0.57447240217832551,-0.38453211484855193,-0.39247355679325674,-1.3456906060910685,&
        1.6215708941824081,0.62223054327288529,0.90072014859921201,-1.1301000359560494,&
        -0.34645238034081594,0.17496441107058613,-0.65508286305699037,0.76226403446632907,&
        0.54795235338470616,0.14269719495386191,1.5948903552025822,0.76876983797598220,&
        -1.8462882478100724,0.46175234491385869,-1.5190042730084257,-0.40992092130126623,&
        -0.62325818810386957,-0.74776111601799444,-1.0168047549721480,-0.37388430994640087,&
        -0.29332845762241533,0.39647216512660277,1.5354541909362538,-3.2202551223595406,&
        1.0314943565938772,-0.31030706729663599,-0.63903235008180170,-1.5724481314794476,&
        -0.83351985629200653,-1.3315166757942813,1.3751894078506932,1.1618004154089439,&
        -0.66806994815025489,-0.69236169926689972,0.31058560277926162,1.3776650809355611,&
        0.63177218753205999,0.52741436066470726,-1.5894154221217378,-0.22453112220322533,&
        -2.3901968056242948,1.0409107845761718,1.3054492020271564,-2.4068349498795292,&
        -0.22773354095967788,1.0370865454608449,1.0772508306890880,-0.76692414885049631,&
        -0.46704275696740094,-0.53584509995133811,1.0599206590090358,0.65578971907754779,&
        -0.96964017163420024,3.1874457892550629E-003,0.31121712034443921,1.3479630402857647,&
        0.50697038953360696,-0.30863998673147480,1.0526157041523219,-0.74883118763619405,&
        -0.54852764292557488,0.16851951531496770,0.36812348635740283,0.58205726278386549,&
        -0.22762241770264538,0.35261507501386435,1.8949128959242647,0.80499831184563930,&
        -0.34283372732567924,1.7697456582592543,-0.95439877139771279,1.0847828350432553,&
        -9.7363696453813375E-002,0.41322587978023911,-0.98152035676390792,0.76636463824213186/

        DATA MC8/-4.0853255080669545E-002,-1.6016077563020206,1.3538878958103684,2.1774041872563132,&
        -2.0966748082504849,0.66694686260959246,0.31254404363276012,0.61162032830226232,&
        0.51803825601406162,0.35122429089637008,-0.65618637005077818,0.60296494681093105,&
        -0.36926297647605688,0.14524629583699677,0.35978771133288245,1.9819948317497926,&
        0.86445582454188497,-0.61405326017685069,-0.56238142070662334,2.4695110016366364,&
        0.50508257898518083,-0.49530132936240762,0.18376934467489106,-0.30725412660691614,&
        -0.22143885918760825,-0.67825848502161001,-0.81114942048503191,-0.86942014260016243,&
        -1.3725457148099309,0.39178506795141110,1.6068116416176865,1.3632202598148477,&
        0.53630595801754699,0.74844559850407621,0.16202391699651247,-0.26939380289964310,&
        -0.62511881544776515,1.4359628848543431,-1.4843731595269245,1.1359443303705146,&
        0.37718500932492105,0.30053478532786332,0.36861841067389128,-1.4888663032779188,&
        -6.8841625127850246E-003,-0.74417463173706944,0.17513490975675089,6.1097918175943830E-002,&
        1.1496541413878461,-0.33436101514038008,-0.74463433625550357,1.5668523377581225,&
        -1.4303367212390443,-1.1915789499845582,0.77918151376730704,-1.6441293096437331,&
        0.37235973904016478,1.2191874716673272,-0.62685101218003292,0.28590338061165516,&
        -4.5408565314395501E-002,4.5942423415338586E-002,-1.1875105244947766,-1.8882550454035070,&
        -1.7676212344502062,-1.0462135135605883,0.56172242719227516,-9.1096008194338177E-002,&
        -7.5414700663655465E-002,0.41235567392507033,-0.33016233362867581,0.19677140335184093,&
        -0.73404052835907152,-0.48346366767073168,-0.22612235305026873,-1.2429424604552666,&
        -0.17799916627983153,-0.37717012308692682,0.78566468919681387,1.0090284555289286,&
        2.9938537938743859,-1.0187554508137553,0.79779187862947665,-0.26184577492241712,&
        -0.82282521837951628,0.19872963966503315,-2.5824939334742765,1.9306187972342601,&
        -0.10024695356405806,2.0862437014588329,-0.46301275516377016,2.0812187051894688,&
        -1.1635080998217309,0.13353959849938615,1.1099672030501933,-4.5495925835222530E-002,&
        0.89706054029229365,0.29960156528485177,1.9509939795803231,-1.3004770562443335,&
        0.24106034563480522,-0.51006316806451291,0.23413795032890972,-0.52730261044525573,&
        -0.73278998579220911,-0.25846858948997131,-0.28490071266020023,0.10084761094286404,&
        1.3662634645725729,1.2292269408332523,-0.89468632078065913,-0.93846448420433970,&
        1.2242950037475495,0.57358061370440705,0.29190729717334701,0.14864006716295822,&
        0.73757829788240936,0.98489235081075932,-1.4078263259053760,-0.52630956627612402,&
        1.0043208489421178,-2.1945459147461115,1.5018947801710512,0.99323675399184097,&
        -0.37249766411684643,-0.31787595992055528,1.2691505300693484,2.1115445532190846,&
        -7.7189703439857968E-002,-0.90829954381356726,0.21278195336539435,0.65052697974370155,&
        -1.6550693260320397,-7.6329478539717499E-002,-1.0368794892651978,-0.67648360346541014,&
        -0.38312304621112564,0.42849007271972689,1.4284775821916800,0.65068428395261013,&
        1.5532036130184577,-0.10595497088300089,-1.9301700929517591,-3.2094090687986729E-002,&
        -0.14780157687708242,-0.41337032333944851,-0.66903883992185997,-1.7224664760194401E-002,&
        -0.15205983092096559,0.48707038885709919,1.2338793347993313,-1.6215390009983996,&
        0.25282723774291571,-0.55592506565692068,-0.48895289042378831,0.68045612091871055,&
        0.78112583115729439,-0.17040563367880690,1.4264262530056648,-1.1137530636198376,&
        0.36348006091167240,1.3295405343896176,6.5648942331854129E-002,8.2032947533449863E-002,&
        -1.8591067135349875,-0.41196216149451143,-0.58775080237069621,0.97307192185854796,&
        0.99531730813893393,-0.17949465967899325,-0.16403842949993402,0.77900522716450515,&
        -1.2840475652541512,-0.45084515985287493,1.0288838527208286,2.0160540359535681,&
        -0.89900096173144450,0.68328421951219243,1.3801676054213396,-0.42653305288608157,&
        0.34190777753117646,-5.5802834189864044E-002,-0.26281047750754205,-0.24566848196212340,&
        -0.49758988649317987,-0.60445990592461252,0.49507234533595101,-0.10954394354843069,&
        -0.31549228630323695,1.2315464317567755,-0.32469558851803954,-1.8664908800338194,&
        -0.16585221695966659,1.0168699305360922,-0.66280761890048312,0.57006836859109900,&
        -1.4506153202923064,1.3455563674396818,-1.0653684500942162,-0.92584856979813457,&
        0.30173900273452015,0.13858162678425787,0.65809587822040372,2.7797867299862165,&
        -0.97620981694834230,-0.48608883873018305,0.31200948257612704,0.88639951811679896,&
        -0.27972143675050731,0.57186792605912673,-0.49063354406982534,0.12936360531900942,&
        2.8945522104096435,0.17887006992453022,0.86607993644405978,0.35945512947790720,&
        0.23651335311966049,1.1024488103780219,0.65699723057150117,0.15916502590776982,&
        -1.6818711706182983,0.77097604641575979,1.4087548700807211,-0.33097561249160312,&
        -1.9850847304685206,1.3142709013090794,8.7350061512019971E-003,-1.0863921573241078,&
        0.33891573964805793,0.29966643673578641,1.3954512038358848,0.49361629314393751,&
        0.67693270521910121,1.3393484894207941,1.1556305444384889,0.28369427554563587,&
        -0.27482640045125017,-1.1994115978821507,0.77998470677198140,0.53509070650816026,&
        0.84614739209386280,-0.54719989436077521,-0.89926161251065329,-2.7065347676455143,&
        0.34642037951456039,0.47847102291229632,0.82568446482454105,-1.4483568504550821,&
        -0.19038748617070397,0.86307334215785947,0.79121387540285149,-0.91038624985923966,&
        1.5478181350137177,1.0133986389237586,0.74610373470408653,0.28059400510781768,&
        0.53701027036400728,0.34326048345672056,1.5520161076626435,0.42821991984040125,&
        0.21217656199407250,1.8088632158590132,0.56798109172436140,-0.38007125428371713,&
        -1.1906112231094110,0.91795888374778800,-0.23366329953571635,0.67422430642114706,&
        -1.1507036226104492,1.7563780204728345,0.39716369598214479,-0.95986868341154175,&
        3.5647561653127436E-003,-0.85919893072224907,0.26747659070366664,0.70160204364857781,&
        1.9296309305590720,-0.49421840190208599,2.1810439558883443,-0.72981583523670390,&
        2.0227635349717814,1.4982101199832600,-0.66213500952498383,-0.47615781429591530,&
        -1.1926449476002683,-0.78733294450419589,-1.7900189362614038,0.12098637767129972,&
        0.45596604439597999,-0.59196480215206959,-1.3721716105720734,1.0302021011869629,&
        0.22388643416777698,0.50909167726498494,-0.52998557199308793,2.8487903243137457E-002,&
        -3.9129878365829476E-003,0.99124881681489696,-0.43260292573360537,0.41697701052362224,&
        -1.4325056124887507,0.96666233791562706,4.8359263464048119E-002,1.3465883387663631,&
        1.2184379357385033,-0.41149136419509424,0.52565165617400889,-0.28004512441122059,&
        -0.31179633816576058,-1.0197106488068086,-1.0791766819170485,-0.18499148254359798,&
        -1.0566224299278781,0.45045956396578796,-0.21242085837258892,-2.2358485001211093,&
        -1.8930590495298563,-0.22826492413773705,0.55994396233186616,0.71698465923273536,&
        -0.16503893947997986,-0.98146611644725890,1.1454884515757915,0.41210430701072681,&
        -0.63463843632308792,1.6059226543172282,-0.33662367023951789,-0.92610760500278755,&
        0.89921951761469299,0.96272907106339833,1.1357316167588405,0.44182220635029140,&
        -0.70296479405227619,0.87759423387406144,0.47699023140330243,-0.49950783894696626,&
        -0.19223849583380614,6.0199325697040352E-003,-0.69778242737983509,4.6855575663917589E-003,&
        1.1636318829489012,0.62734886687983971,-0.59504156246374562,-1.1780028499306072,&
        -1.1503371429664797,1.8702307843686987,0.85955691348376739,-0.97378630895094875,&
        0.51845210948785314,0.27493022658671445,1.1196669692449503,-1.2713376480883449,&
        1.6247265222924387,1.0216782994400928,1.1596979959054887,1.6300479289897103E-002,&
        -0.37859520987593659,0.40681533249182450,-1.9704930752743131,-0.26776189224576702,&
        0.47367342680770436,1.4203708525973520,0.11914548017020873,0.15051403116145909,&
        -1.3443542300547737,1.3003069128294213,-1.3616353641009473,0.79820014294598929,&
        3.8268463250278576E-003,0.17480091987050239,-0.89245480496530805,0.73162596154783410,&
        0.60563015073272186,0.29559834230680332,0.69902368685044503,-0.36199316005915588,&
        -0.29584728498792429,0.13510738854583954,1.9709685127677539,-1.9825955109350808,&
        -2.0383487925719574,-1.2779114737926291,-0.43120835919895728,-1.2220001882358900,&
        -0.15117083892933894,-0.13511747922067111,-0.34260157335353481,-4.7120137151204673E-002,&
        -6.0361552892450373E-003,0.70626778578358129,-0.78665674892279425,0.97975397440177903,&
        0.23508885107319824,6.4242058863835452E-002,0.99353431622657196,-1.2031833861154266,&
        0.94655729611772954,0.19744623526766897,-0.71369752096567529,-0.85208878220010753,&
        1.1848796647310122,-0.97578410794098347,-1.9200762114132000,-1.1612874208352066,&
        0.67175473499537808,0.37946632224056620,4.2269259409554441E-003,-7.1130228992186045E-002,&
        -0.14828870906189504,-0.59868095236307117,-1.3667625030670609,-0.28156900216976100,&
        -0.38453184319576111,-1.8248417129835439,-0.57097040003256927,1.8071999232238827,&
        0.77103055557799283,0.23241288301299290,1.1350804522597990,0.48598376220158740,&
        0.33517896902913463,-4.4198412182304234E-002,1.4687772672116159,-0.89200248207009747,&
        -0.59518038055081068,-0.12496740971797680,-0.75603556087330170,-1.1947115599902891,&
        0.39016112725479940,-0.79760134646306935,0.24905631665196892,0.59853160448386056,&
        0.45059550103316603,6.4329597361121996E-002,1.9317521290637180E-003,-0.48268774420319316,&
        0.25644608685723896,0.67209474061674623,0.50230205857000398,-0.38452327172108575,&
        -0.32720378286126445,-2.9775170955012724,-0.24886276083671105,0.46383720121151417,&
        1.2435477527117884,-0.97137663153512999,-0.49160013756326071,1.7675320158419892,&
        0.21993252120650192,-0.10876104524098434,0.65152022294577872,-1.7991077823729584,&
        0.56808346244453767,-0.55654535391651716,1.1436569431594825,-0.22898099537647951,&
        1.4210472287077407,0.12027433572833811,1.1677512303069260,-0.56498312187171906,&
        0.20398181580253724,1.2500204091959570,-1.1661183698289190,0.14629885158993694,&
        -0.60928329341174370,-0.83593156455082884,-2.1801508650041327E-002,0.83451864335545667,&
        0.50424986653660375,2.1653916540508842,1.0274448728189685,0.81150951034493413,&
        0.47551807616155078,0.99288402828662881,-0.77420180597869437,-1.4258191830438769,&
        2.5044893305701744E-002,0.34788970595863511,0.18026902638149558,-0.12675014959956787,&
        1.6265612587170322E-002,1.2909990467549088,0.90195686607163250,-1.0842619363108739,&
        0.59272691430042035,0.93190174885537180,0.65063691311120142,2.0420339069019064,&
        -1.7890065556997710,-0.39922237845988606,-0.50693511613526543,0.44643056695407018,&
        0.63715113437544013,0.37561303598485740,0.30081458457686688,1.7791094408756409,&
        -0.60682967475863947,-0.73669767651909923,1.8287315291576118,0.22498589633125415,&
        -0.41778483339663075,-0.17876649435082539,0.77454889742278599,-7.0220652715245482E-002,&
        -0.69888707690122520,-1.8822964431549523,-1.4133508154340977,-0.30520931057540068,&
        -0.63214622382859254,6.7525264611949395E-002,1.4481801751242733,0.18759169692619868,&
        0.64837168530562694,-0.61414193406652751,-0.35076011995306450,-1.3578417099932845,&
        0.45547354071510021,-0.23935714547620365,-0.23259171379135735,0.57929227541276906,&
        -0.86427578951815676,-0.28894680617639790,2.3536970279655902,0.35061250367815577,&
        0.15854133125293116,0.33977085463808904,-1.0415213635556331,1.0942936691832716,&
        0.53641284029170100,-9.4469087163475823E-002,0.12851640823696739,-0.16843359866865984,&
        -0.57767551630668446,0.85531504466445685,0.60998900180777771,1.7946155507370392,&
        -0.77347277820260651,0.64068962470316637,-0.14065404996672090,2.9660099209839985,&
        -1.0010731946443505,-0.47728209758059931,-0.97274647996741337,-0.26922226201180427,&
        -0.13248487408877507,-1.6896157220167809,1.0578992200134851,0.59799617445483566,&
        0.60150855562582217,0.91978252864018362,0.87843108609161791,-0.51934436371230397,&
        0.49616064756024891,-0.10426916864716604,-6.2958704133588117E-002,0.46321909069153333,&
        1.6836665689121419,0.12585446995193406,0.32193543853116141,2.7588513705711814E-002,&
        -0.97321364182423009,1.6927264517702247,0.42142362492135821,0.35897012975595499,&
        -0.71561662826362782,1.1815282924072243,0.95348500074348230,-1.3329537969833762,&
        1.0367642884757020,0.53650833166067635,-0.26280137272487319,-1.9650444858017617,&
        -0.20467163139541975,4.8280217697197696E-002,-8.4476391636477147E-002,-2.8670719295314048E-002,&
        0.45433097655683530,1.8504548607191598,-0.49835647431845609,0.83960671865577097,&
        -3.0315301810759312,0.80716765964452464,1.5338516440167664,-0.75444066316020109,&
        -1.0338873779566209,-0.92749501151170710,4.4626585898521393E-002,-0.18029001870331801,&
        1.2042008287050534,-0.86780296306248084,0.13456468442898578,0.76424433571028116,&
        1.9654466169406755,0.98631646798871075,-2.0568647593984718E-002,0.34654063218534192,&
        -1.6260476278354119,-0.83130109136314845,-0.93039153694154153,-0.22346063189158011,&
        -0.99232522627631659,0.81444811166742159,-0.75051774842182339,-0.87518591766439235,&
        0.70860315573443922,0.13799867908713204,1.6081804129006834,1.2074621273753385,&
        -0.76506411983658718,1.2925546674486499,0.91365915332760217,-0.83390401640057077,&
        -1.0795550190419760,-0.57443254401506283,9.2604919545797842E-003,0.19079289816063832,&
        0.15552705911827358,1.7848987354701273,-0.82950674261658786,0.36029346165415349,&
        -1.6958685699325775,0.47829478667328384,0.31617698686251272,0.68592830623029788,&
        -0.25734316667392226,-1.4023017025259814,4.0325116982201118E-003,-0.15305178836588570,&
        -0.43664233179111056,-0.40918551218261151,1.7459327060764853,-0.46634432957996502,&
        -0.17950959777695030,-0.47703642590038414,-6.6731970213120897E-002,1.5647819681265465,&
        -0.37048212303623862,-0.82317503097738520,-3.5670820278311081E-002,1.3516971485765186,&
        -1.6203644313592167,-1.1546962823596718,-0.29542535670552178,1.4498948558177704,&
        0.24075274045628256,-0.85303548813138708,1.3710847333828813,-1.0528795205304462,&
        -0.12052130956467619,0.50306337479238439,-2.5791900199722280,2.2115397431601518,&
        -0.21971916253620108,0.24656883502775279,-0.27167812653017975,-0.27219207476357321,&
        -8.3782199330839621E-002,-1.1615493623781115,-0.52260295751534458,-1.9431401370704735,&
        1.0514206243614908,2.3615170080266981,1.0061161438602557,0.34965864757245335,&
        1.8273316684054324,-1.3954404906876396,0.93775494817397109,-0.82279300803787270,&
        -0.67326086700269205,-0.13413403573004190,0.19609246847859349,-1.9562910910894746,&
        -0.11871383237697720,-1.7900079916612912,0.47924360199781235,1.4557889427555537,&
        0.81761468167306905,0.96639003888498565,0.39889878503916470,-0.59144847253877264,&
        0.24775000905765404,-0.35737476276429619,-0.86838748347985373,-1.2069930773525031,&
        0.72427096478365460,0.17412961891618967,0.34954621982383055,0.24676627676002730,&
        1.0973702266751384,-1.2624211546727209,-0.91030699998987641,0.77271880934801174,&
        -0.68736217690938761,1.5561490863629159,-0.86011819357767239,-0.12553267533742837,&
        -0.25465206463644169,-0.10324611980682295,0.41864839080283356,-0.13997315469828939,&
        -0.62084072526934531,0.30645068434775369,-1.1822591673455340,-1.4514155475086847,&
        0.70901188181898434,-0.98110389077834226,-0.34075505292775704,-0.26181983228472805,&
        0.54632167606782289,0.68296487880829349,0.99589796521221230,-0.90324613567972500,&
        0.86530553322293458,0.89616146302732713,-0.54167282020886642,-1.9947959478915592E-002,&
        -0.10592886076392095,-1.6563988158178109,1.2254257666966075,0.25493839261956514,&
        -0.70258807869115525,-0.34594702721303378,0.39024784029969278,-0.48812581846944275,&
        -1.1041521215472236,0.71750471187230558,0.83789157164460804,-0.38185796569877878,&
        6.8655475265970878E-002,-1.9839715636772155,1.0849305202224935,0.23178839835721723,&
        0.88592618709954374,0.68500597321967172,-1.2088419905019194,0.51711523217112743,&
        3.1321120971424201,-1.8667649614530293,-0.21445320111666516,-1.6009917156696438,&
        -0.97743614154033642,-0.19709893647637741,0.25320764144977587,-0.34106285264031627,&
        -1.5456307458521910,-1.6670929763599787,1.2508090920195734,0.85482948938375547,&
        -0.12058949704702826,-0.57394839657855390,0.54296374595530550,0.49852105187883405,&
        -0.32169735802024563,0.24896839156770351,7.3359955209838790E-002,-0.96229238773080183,&
        -0.89702135677134509,1.5871812687850440,0.71252956537116918,-1.7645974009783087,&
        -1.0387480278298262,0.26620224052407565,0.49895801921687966,0.40064024970404088,&
        0.50788392166747154,-1.2845838529819522,2.1677088946433453E-002,-0.35296528129516636,&
        1.0119733055300211,-0.11543647916570261,-0.13879969308665380,-2.2183010571788460E-002,&
        -0.66609611294349547,0.46861239999905746,0.77561652985521812,-5.1833675718167813E-002,&
        -1.8327391827676125,-0.64099675506209997,-8.6017187352041731E-003,-0.43987542853287354,&
        0.47130984119399855,-0.13652078508584761,-0.36033148123502834,-1.6295614512732302,&
        1.4525022577780615,-7.0586465172936874E-002,0.80573555678476960,-0.24011378607952888,&
        -0.44048549708624751,0.13983218381804058,-1.7715369587153931,1.6771959622468098,&
        0.90083747025842886,-2.9656496627909985,-0.85308096349648899,-0.52257570557408517,&
        -0.54185756654541373,3.1740394052699732E-002,1.0347675736608566,0.59303756709787503,&
        1.6063726400943978,1.0928587436298578,-0.87038717646794350,1.2901463563527440,&
        0.26047759026138700,-0.44305453032418485,-0.90190424632174837,2.3941109015830859,&
        -0.82821092648432260,0.55313954015134903,-1.1665322975713726,-0.47207167914580977,&
        0.75218315815814474,-0.13043173356825552,-0.48020002146545526,1.4359206857870708,&
        1.2781878692220554,0.48878134870803436,0.16116506145099224,0.39701780432430650,&
        -1.6274270297132101,-1.3717747092660042,0.92173454238890440,-0.82358256943784869,&
        -1.2790337782461563,-1.2921488795697900,-0.54698877995295947,-0.72300340174904298,&
        1.5636370098532051,-0.37153352809782764,-1.5429852571582439,0.25654616075213776,&
        3.8586153814427336E-002,0.41092551454474280,0.68450353633211347,-8.5441520051467490E-002,&
        0.20591248362093018,-0.50978615490684576,-1.1837428698512809,1.4706738652842182,&
        -0.27747305963924612,0.66598586926665193,-0.75787839749399410,-1.4295279862475025,&
        -1.4603437992632593,2.6406662418494573E-002,-0.95678013652023552,0.41504224715760574,&
        0.70876120290923483,-1.9482443777571490,7.7759367951673085E-003,0.82549736761557757,&
        -0.70560400381459243,8.7265761828758462E-002,-0.89462309240943172,-1.4196471620867550,&
        -1.4124108968556068,1.4559607795992664,-0.24352138390849759,-0.46157475724339520,&
        2.3609442503029854,0.20775942484627755,1.0700557797851542,0.30515539103247241,&
        -1.7842130433786885,0.28071528753656327,1.3054667231447652,-0.49217874937326994,&
        0.10833966172521879,1.3720769781072975,0.91315150045500026,-0.85193896144204551,&
        -0.67151579851172960,-1.3751272389978395,-1.0976568077406579,-0.11029565063287039,&
        1.6132691050113146,0.49141813403745943,-0.40304944962407047,-1.3431529406219354,&
        -7.0566147815257746E-002,-0.67387716777520157,-0.53205786459655813,-0.92972025536529190,&
        1.5971621236991813,2.5294457319281035E-002,0.55851654484195012,0.51541491265303618,&
        -0.22356562036992123,0.32710078150825356,0.54548740111631477,-0.52030684013545625,&
        0.72484195428732223,-0.60737664574319028,-0.68556463170657478,-0.59285173594557583,&
        -2.0775230939882028,0.94970809987412796,1.4394854715347949,1.2491560215673412,&
        0.67134850926179679,0.89046240867015725,2.1562600873699926,-0.11512861173363062,&
        -0.32092778005044853,1.0275598348920649,-0.28392112136100650,-2.3839006927997661,&
        0.21825976085549037,-0.53862506772015639,1.3698451436190722,1.4973055530669561,&
        0.41932856790647954,1.0131630692554177,1.4196409276570225,-0.38952354252566984,&
        0.49440076747393857,-0.53567345555963863,-8.5657804305661667E-002,-0.52530461952247798,&
        -0.47414787894212446,7.4924112308331778E-002,0.90818756749627938,-0.54941467200830973,&
        -0.57251476020655112,0.36155244519727048,-0.19203693632250179,-0.12402968457149705,&
        -1.7599952985302190,-2.2954235479586114,-1.7516660187439539,0.71041968136084876,&
        1.5391082856226339,0.52000600631664329,3.8568243704488588E-002,4.9882692771394996E-002,&
        -0.81162941649791898,-0.14228487237888371,-0.56970457126689411,0.42299645319182372,&
        -0.39633567717766610,-0.80067712509311495,-0.17264947596862418,2.2691389014694145,&
        0.28313776514102806,3.7772902014726877E-002,0.22924334967860993,-0.46374717601944310,&
        -0.12057792260735288,-1.0841842646684299,-0.62432131650316414,0.29708946040030398,&
        -1.7370873675762959,0.59476990032806909,1.3677800783648943,1.0431828465914816,&
        0.82488307996611832,-1.9284441135450769,-0.53066734017865536,2.3062526106487353,&
        -0.47039754444824650,1.5015233773355043,1.1462796347368622,-0.55794241336157135,&
        1.7609001080928306,0.58134556698897588,6.0087125077509539E-002,-0.82604069568734528,&
        -0.20866871648520208,0.47916416930677574,2.0761611477015980,-9.9703442857312322E-002,&
        -0.29873500834503858,-1.2742799528842341,0.82893835068837807,1.1817442992933322,&
        0.66315975129697535,1.1302633938489386,-1.8025235758717428,1.0619294446619956,&
        -0.65256552571882409,-1.0427451474542639,-0.15314777108664318,0.40363270993878281,&
        4.5600021783272077E-002,1.2550389212588289,9.2107080058586963E-002,-0.16716681827900967,&
        7.2010894931050576E-002,1.8363766004097914,1.5768243879795656,-0.78115647478855199,&
        -0.65137865306524056,-1.0543082650095474,0.36874987720926161,-1.4722587475165279,&
        -0.48701150483435512,0.76174865515271917,1.0278437560191723E-002,-2.3340171375036163/

        DATA MC9/-0.26815223604533489,-0.45646637398687417,-1.2531146780530442,-0.75420266115029178,&
        1.7463367097888673,-1.0698169917127911,1.2166825873053506,0.27986259621814802,&
        -5.9058358229759300E-002,5.7614044691878204E-002,0.54971747725692921,-0.21039600995435936,&
        1.2276374569832620,-0.23275538624580844,-0.29885600219080616,4.3481599130232775E-003,&
        0.40590350465273384,-0.84174897920565750,-0.21398848787301442,-0.79600759226740347,&
        -1.3888140883298490,0.71177561046392634,0.12644614143986355,2.7471198612650436E-002,&
        1.7410412033160800,1.3510452086401927,-0.97050657529738227,-1.3026459751656490,&
        0.54285856036870184,1.4867742772575816,-0.45166333509504708,-0.18143880652177855,&
        0.88190382373645471,1.1710283004828801,-0.99420137452364954,1.0609750846279820,&
        -0.92647731788054910,1.0174127424790305,-0.26006063265590385,0.34676378018298054,&
        -1.8516709920199150,0.44245868476956007,0.27096446306693989,0.29908026320112224,&
        -1.0097974709692052,0.38136524355688212,-1.3088069923440619,-1.5483482327669733,&
        -0.25852111865431521,-0.66843206946887035,-1.6075705732619234,-0.93534582589226434,&
        -0.22020692218135121,2.1750068673595284,1.0566330442269747,-1.4720745912773399,&
        -1.8754657592115895,-1.5908005886682588,0.73881916010686244,-0.57537954880199893,&
        -0.88016695689773816,-1.3825663266529324,-2.2302285110899135E-002,0.90309605051108421,&
        0.62130180350822617,0.58472286961147779,-0.42926600594389874,-1.0217595146488467,&
        0.37687511452571826,0.43750484001721812,-2.4407663401445723E-002,0.24545897705978531,&
        -0.71358024065826831,0.38562777714846630,-0.26861534520839908,3.5761848203402176E-002,&
        1.6975900287106640,-1.4204450147366225,-0.96059262215972641,-1.1389643935794651,&
        6.7602979124703685E-002,0.17892480741014982,0.38040582260303063,0.23416146335802296,&
        -0.97312819460676248,-8.2749377881801964E-002,-1.1567069800530847,-1.3508660379839248,&
        1.1455726566921345,-1.4869442043484831,0.85724625839697310,-1.2256341063623721,&
        1.0264560327816761,1.3072427050823110,-0.76656881492175599,0.31179318090081759,&
        1.3314622329668744,-1.0993843051810028,0.95969959450349507,-0.87422617059276386,&
        -1.0375112669224265,0.15606785850065716,-0.75335258078968348,-1.2418804199089026,&
        2.3453751746266893,-0.94006417916365315,1.6584446524000753,0.57898388628519692,&
        1.0868004822371673,-1.5059089723592385,0.44714945629494668,1.9742788745807978,&
        -1.3320595192266886E-002,-0.99558011011335346,0.43470736778730212,-1.2313436660054475,&
        1.3458945615250175,0.76306338781078142,2.2760606614894838,-0.19930081073467873,&
        2.0185700137080853,-0.21287325550184147,0.17111121767544657,0.34777631765826383,&
        0.91563514993302497,-0.16300233247492674,1.8773095817527903,0.50308620071801624,&
        -0.49023952731426329,0.88122269959645638,-1.3148786522445859,-1.0641871361874076,&
        0.87713546362198758,0.66028083297445517,0.43084441437078330,-1.9299992635473182,&
        -0.78845600960032947,-1.1037210072159129,0.25242409332373772,1.5732151853691434,&
        1.2172390499339869,2.2896721659807419E-002,2.0954234217893135,1.1839508664325000,&
        0.23539830960536703,-2.6771099450720367E-003,0.32700110374033137,0.21294593242267720,&
        0.11390733480281902,1.0000415460615784,0.18856849777423021,-0.50385868338234574,&
        1.7638577879861348,1.2338373105294136,0.80805118510749530,-2.0550504538529504,&
        -0.66713563612510285,-0.68669859984168602,0.29837893790839737,-0.90082255068228378,&
        -0.13220724902907979,0.66342424831578128,0.75348155648680581,-1.7312620551306186,&
        -1.1050433120182921,0.84764750490858376,0.98906565348024655,-0.86278379916880943,&
        0.59673269327773326,-0.93000635127958275,0.91354124392963443,1.4307285388003721,&
        -2.2516796834005131E-002,-1.6282409102494551,-1.0787278838430472,-0.72595271184344035,&
        0.83198823628989116,-0.19577992560960181,0.53803326478082381,-0.52538865638223486,&
        -0.45225723158216569,0.97507336137714173,-0.26400464145164126,0.28053353176927298,&
        -0.28837321768042568,0.17581049158967174,0.19022390217161092,1.5878142018507060,&
        0.18594103021239458,-1.2360077842059209,-1.7133438952804558,0.94111383864814258,&
        -1.0144088982556407,-0.14768770335689610,-1.3150696155856785,-0.19425554110199345,&
        -1.0026479262995101,6.5235772420258090E-002,-1.7998470389282866,-2.9639672233841566E-002,&
        1.0303432071955583,-0.90773185552416047,-1.1438845146971501,-0.62313325170148104,&
        0.96735018515598081,1.3673981194766012,0.43131462769090295,0.76466806218882954,&
        -1.1348326216138520,6.7074634987939738E-002,0.66509226338514749,-2.6032107918933454,&
        0.74801434165055869,0.21082664216780503,-0.16631285723860437,-0.37887111140208352,&
        1.3138898525444658,1.1053608938401633,0.28033784449064530,-0.38365063868447591,&
        -1.0410732065056860,-0.15410803353276581,-0.67136747413181885,-0.79220478477932943,&
        0.48679774213621724,-1.0345462295091594,-0.63395546540124992,1.5381585389409580,&
        3.8864770308879540E-002,-2.1461250952416662,0.78921772379292754,-1.5019581371988910,&
        1.8478840933938270,0.96036723345575603,0.30733787760778225,-2.4362523091898987,&
        1.8271208072196099,0.89282046271609694,0.31931039585591625,-0.31406661995512214,&
        0.41217618891489238,1.5430823744397242,-1.7443447292477716,0.61612310036148543,&
        -0.67378917798585347,-0.10395773776265657,0.25364321305159671,-1.6280528327055714,&
        0.76815935273618008,1.0436097851987909,-0.55482954248485872,1.0468872165808474,&
        -0.19628496892044123,1.5082163313093682,0.41521015996189664,-4.1416982292687907E-002,&
        -0.34166328978773330,0.37165622506270030,0.12183390557339373,-0.91419942886692562,&
        -0.87268793880810291,-0.13429309551348592,0.20653526481470078,1.8973835103575867,&
        -1.1776956691970273,0.83542545366865817,0.99892350064891788,1.2494340944533699,&
        -0.32798600540955203,-0.65936418196893953,1.6157568235658262,-0.21807284479710931,&
        -0.70836808230531612,-0.82541586245236076,1.1603022487660484,1.2101141576674788,&
        0.23270023196243647,-1.4906372316137044,1.8882709108938685E-002,-0.57866546939950358,&
        -0.42731265287218562,-1.4137595857978291,1.1967578309168843,1.2786186386345366,&
        0.62248650771481095,-1.2009055109583224,-7.3265396122654758E-002,-1.3195723673092474,&
        -0.72371280855404296,-0.99445925432720828,0.49388570843670015,-1.1436863250013956,&
        -1.1657661708225502,0.53025949038203857,-0.51181233379833879,0.28438133821110195,&
        1.2652235586106828,3.0473620294242446E-002,-0.69763591414488180,0.45372035266029676,&
        0.61639990429066738,1.5559325704676152,-0.59703486299382846,-1.0159368846106169,&
        -0.81002090894517753,1.0437175034710195,0.31266850466558599,-0.13263008966857195,&
        -0.43784874990176831,-1.1326104401066783,0.61661119520716923,-1.4496515411650859,&
        -0.31104253664175491,-0.11430049082012742,0.52607268002881913,0.64323572243258786,&
        0.63950559150578745,0.11969551881995573,0.31448407489952607,-0.34510157886903708,&
        1.0094988208044913,1.2149871191899364,1.2916667673809263,-1.4502388288501633,&
        -0.54188487807551911,-0.27181895648264348,-0.90204482005411857,-0.72974306136458855,&
        0.61123433014726058,-0.32116844595100091,0.65599146311646328,-0.62400043503819469,&
        -0.51354845765622825,0.51521671473367614,7.1478522436882325E-002,0.76958599776299219,&
        -1.5793517449165713,9.0868513480888341E-002,-1.0375365466584177,-1.6352169906120999,&
        0.59278431414114774,1.4273582838380383,-1.6149701645462040,-0.14224574433914261,&
        -0.40810427891631612,9.1892617800612558E-002,-1.2581242954668896,-0.66808106863720762,&
        0.57556496519307376,1.6032653884821289,-2.2277785697824717,-0.21661974537983625,&
        -0.10243105043855301,-9.5839167595040339E-002,-0.71711593708127686,-0.90718879325993818,&
        -1.5342644955872042,-1.3501640398374377,0.14873664433880654,-0.65292882648172523,&
        0.30953897424877591,-1.0257097079327366,-6.1480969872495204E-002,-2.2272610470347187,&
        1.1957546929811935,1.0826913270473544,-8.3729837269219107E-002,0.27187870200481218,&
        1.7902844352672822,0.26450299706191271,9.7806047769738960E-002,-0.56837269906437782,&
        1.3470985816747922,0.17643358189466996,2.3401887192737756,-5.6187048686160500E-002,&
        0.97902947733220280,-1.6667437226078228,-0.69038047882931619,0.31755370604086425,&
        -0.26984095087461146,0.58717832768943379,-0.89626255593376636,1.7772748379668919,&
        -0.49551048489252353,0.70666125428077609,-1.9360877523131717,0.59108467218643845,&
        0.23300053409785582,0.58453618655703099,-0.63518246267076217,-1.7626945682616049E-002,&
        2.9624315184020613E-002,0.62240459257792191,-3.2581279031953007E-002,-7.2553703578650097E-002,&
        -0.38173462156469418,-1.2561677510486464,-1.2186288805679970,-1.3219246529812776,&
        -2.1445981782192827,-0.54506720047195789,-0.32305321638037815,0.61872011856329057,&
        0.12090309785146271,-0.36821341294963184,0.91751677129464992,-0.21679943331261536,&
        0.49009517637422700,0.10674874397617928,-2.2725752757810413,1.4236239910017641,&
        0.29555781648473228,-1.6022834648287720,1.2529556576937180,0.36482945029493569,&
        1.2458221726532921,0.66626646880719420,0.96110174172941842,0.49101608423018001,&
        -0.60330264607055428,1.6262983476232289,5.9844666964154601E-002,-1.4193309945080606,&
        0.51746351471191709,3.4074749395964554E-002,0.60462271066955309,0.48903504763994438,&
        0.27484031857172303,0.65779625167870126,1.5747238985341474,-1.4936232210586815,&
        -2.8627531825634631,-0.22876659911314209,0.98444514989047627,1.4586830390582608,&
        0.50495954733706394,-0.10243763488929382,0.58376329403834504,1.1908813677812151,&
        1.8316507538186082,-0.34594351302172999,0.18536353797319202,-0.75673759353874592,&
        0.82320023786821195,1.5920102345590652,-0.62965960707713342,0.88228518197136885,&
        -0.19132141440940062,0.32100468929512194,-8.9764041011911475E-002,1.6516614998009209,&
        1.9565795068727559E-002,1.6787497909483491,-0.33361110445312098,-0.49230944345371219,&
        -0.67033912170386400,0.91995730444632939,1.1419512500666467,0.76898967269665552,&
        -0.74141700578254643,0.52874816859300011,1.3470275447103717,-0.59002847235619837,&
        -1.2014564176101847,-0.33493041172823240,8.8571132248124879E-002,-0.91180704548317715,&
        1.5998255979114546,0.82652645651492407,-0.50938674617349711,0.49693855547555182,&
        -9.1174935992939091E-002,-0.61501471448239498,-2.5735575310038643E-003,-1.0881164638883536,&
        0.43920255476018022,0.33842773776217827,0.44355622896255903,-2.1918929372945595,&
        0.98877961921656943,1.3163651822707185,-0.55106083149821627,1.6886895088793197,&
        -0.63599244264500820,-0.35395993764931205,0.60859395691348450,-2.2193748160891178E-003,&
        -0.41995037711157934,-1.3465716573445492E-002,0.42556695984740689,-0.75186778790995712,&
        1.2138924335902279,-2.5798752635839381,2.8227784340209743,-1.1772515592485207,&
        0.28113775246063222,2.3749286811362840,-2.2010064637887119,0.25756178457401269,&
        -0.19482701250150719,0.51118919181598432,-8.2975907205635066E-002,-0.92950309410609322,&
        -0.35803163540185390,2.4844599964649779E-002,1.4586118495823228,-9.8506224878534332E-002,&
        0.89877324644580425,0.16509467373839512,-0.58431334310448513,1.3428473954517059,&
        -0.56504951375184942,0.58829581637940731,-0.57146898268671520,1.1746977087801906,&
        0.24616742469176511,0.16713964793608196,-1.1107778784915705,0.56737111293372722,&
        -1.8958905385075040,-0.53040799918397230,-0.68176179103643331,0.65518696019332479,&
        0.85895659866075214,-8.6693587075376052E-003,-0.23733934105551371,-0.12379747973077183,&
        0.24816496396220325,0.48704220040530438,1.0358215725255862,-1.3647921789944835,&
        2.2476506688123132,-0.20805893206902309,0.63550662447367623,-0.57435496527247343,&
        -0.68534745458505120,0.46832243738886231,1.1696128784106608,-0.20266386015247456,&
        1.0025934026318031,-0.41438983763513948,0.22330780530590247,-0.39840335241379804,&
        -0.99484294228768722,1.4575561760094227,0.99556125903909731,-0.10734967604767050,&
        0.40729822405568378,-0.86076458797681743,0.89452389963357415,8.2459166253953026E-002,&
        0.37040928010278185,-0.50127717490942558,1.2499958673474405,0.11061277745612473,&
        0.57157129578126764,1.7570673734310180,1.2868324698731388,-0.36213721784346653,&
        -1.4452557054635429,-2.2621792690278570,-0.14744757984778215,-0.56511990706820758,&
        0.43981379552111566,-0.27847507209930222,0.18212354268589373,-0.57320721725672252,&
        -0.34882215638902969,0.46789580978520151,-1.0142118829724158,0.68915588070963796,&
        2.2409700830182038,-0.70382776704368588,-1.2984792546617310,0.64197848113020362,&
        0.65073511032428566,-2.4333647453668568,-0.28598850669398701,-0.81691990572404605,&
        0.13461348993018410,-0.43864244723307133,0.31069101688853434,-0.66144502852702181,&
        -0.50537702142015350,0.78624609552700331,-1.2548628724001269,-0.83811455327067286,&
        -1.5384149281593005,-0.83598813030244667,0.75531265098326972,0.19704651231454465,&
        0.74161839290829512,0.53060415848796638,0.11461408752743150,7.3552575341180149E-002,&
        0.79023113837460890,-0.28909336061460283,2.2809024200598884,-1.4780077206152551,&
        -0.68705140215066041,-0.19416912222567878,0.40801695708346691,-0.62342114789158987,&
        2.2569147139125813E-002,0.84403018635339755,-0.31276445098243916,-6.0323916775245061E-002,&
        -1.6410385569232704,-0.92817501940172586,0.38151595446047237,-0.18440661663088570,&
        -1.7110540203352393,-1.0106226586751657,1.7011459431811629,9.8958256612252257E-002,&
        0.65459227027162514,0.45031652697989089,1.8542949084773639,-6.2183801364741796E-002,&
        -1.6471445998696181,-0.11651312914527709,0.78603303431890759,-0.17193812404764186,&
        -0.31553226826267555,0.88206993944223966,7.8103063040636054E-003,1.0428935031939270,&
        1.6018148011388216,1.3464421683292052,-1.0536486918913477,8.1999099953072974E-002,&
        -0.46080993753765637,0.44673958034513461,-0.18654505401530613,-5.3495318015864352E-002,&
        -0.51105922123885095,0.84988270463484394,0.20943407736946526,-0.13297669963286229,&
        -0.73558955375293988,0.45725571080748373,0.78994812271831316,0.67987846699723364,&
        -0.66659553290799400,4.9024721833447749E-002,-0.90226847267143462,0.22635905346495216,&
        -8.2734027622600945E-002,-1.4652871484517276,-0.56358783878744667,1.3571034632938259,&
        1.5726260062616306,1.5460018894879686,0.15510312428378156,0.45520415592695485,&
        0.99044990284687850,0.40986605464627274,0.10088517693376159,0.39659508533879878,&
        0.71281750583366887,4.6867213421140579E-002,0.68679527203825175,-0.33169436153776771,&
        4.1913615350186284E-002,1.5186598000772260,-0.13896383704524315,0.34721967895170169,&
        -9.0492320675596163E-002,0.41513215767279099,0.25260543068610919,-0.43535447582794734,&
        0.80373526119479211,0.71291217821381736,1.4215449062449785,0.11568459160989507,&
        1.1832205524905752,-0.69375634690009447,1.4852990350033903,-0.97392330103208291,&
        -1.3059874854863114,-0.76490769360065825,0.97251951918222967,-0.22098082941229966,&
        -0.41808188807189650,-0.85837916199385056,0.34488316166714589,1.3886060390957418,&
        1.8304518059558648,0.87440468834010587,-0.64223971838899929,3.9407813448620432E-002,&
        0.21800162437276777,-1.3106140900730952E-002,-1.2767233760566872,-0.41170125368294930,&
        1.2472222856285413,1.4656549216753321,-0.33460304522992346,-1.0718732254560839,&
        -6.6051043653501659E-002,-0.43572723683098230,0.46424956912385917,0.74501617811005105,&
        3.3563485245740288,1.4014873510776988,7.7061023317489567E-003,1.5222229427066643,&
        0.44541226086815883,-7.5097244069977004E-002,-0.46883143395235433,-0.52387920475364824,&
        2.7151927251865011,0.71539018543485133,-0.19364017709733738,-0.33836566826599834,&
        -1.1747816879342772,3.1720759707371440E-002,1.2920854177459860,1.6400855506491312,&
        0.92511626759020438,-0.17960967328875202,0.56532936143188828,1.3667273240654825,&
        0.11344977652696872,-1.8540321624067120,-1.0590224459061430,0.46891248175063094,&
        -0.77500961863410867,1.3762604639220630,2.1909287375204141,0.18972667920528713,&
        0.12114997772653285,1.8245848926371811E-002,1.2748381772966588,-0.33983343065051558,&
        -1.6684841310054470,1.4491179653169259,1.0988841156986628,0.13202600563072592,&
        0.26652500056933293,-1.0365596815644806,-0.84902596775570627,-1.4759451217771737,&
        -2.1253462437507118E-002,-1.2936283331582605,0.75095231138342911,-0.61928844932793936,&
        -1.3948715767411974,-2.1276082083464916,-4.6149573639812883E-002,0.58248169594602384,&
        -2.5908561243689983,-1.6345808931195378,-1.1037589023873149,-1.7049806830972492,&
        0.78813552742217141,1.0476281402096026,1.4548655113017339,-0.65475383346019678,&
        0.25801832652665563,-0.39097211377056124,-1.1437108559322180,-0.25994615126947235,&
        -0.46719396474608965,0.70741840294901692,-0.31067575247378759,0.14503600146959425,&
        0.69012409274950137,0.97500634008418885,0.38409096933895137,1.3436238239948000,&
        0.31893794511440821,-0.69814618375315585,-0.95487547629305070,1.1416357425787622,&
        0.79116060657534615,-0.44539889871959343,0.87957838307997493,-0.51781369316274117,&
        0.78197097743692068,-0.81255845353152278,0.15311602413846559,0.49930979784901541,&
        -0.14149243259654723,-0.19246765890890594,0.17723837720139088,1.4331741002743450,&
        1.1485476386478162,-0.25341853914304124,1.1019681084691499,0.65795295869279746,&
        0.28882505224824251,1.4864553568880634,-0.72298143769964596,1.1517522671801681,&
        0.44500262633965898,-1.4618667881761007,2.0461901329768772,-0.23095594768036110,&
        0.32334734406860888,-0.35259005902308688,-1.8258116813602319,0.30860883066274719,&
        1.2134113693226405,2.2911987457206942,-0.42176853815872811,-0.97539712338757900,&
        1.1483210363656506,0.99520102154408407,0.46929652549938711,0.18306251788149230,&
        -1.5402805471190077,-1.3610181463657434,-0.58652424359172406,-1.6367337881379054,&
        -1.8692824010975658E-002,0.84750001092100435,0.45026558048812271,0.71730881127128243,&
        2.0349267451363975,0.51565939005441241,-0.85102342712765000,0.64838135254513485,&
        -0.56073126876856272,-0.13405312724148877,-1.4398058874773056,0.69776774814489884,&
        -0.64626807169654699,-0.50413126685081244,2.0758145962427923,-0.15094347671198596,&
        0.39191647441564537,-1.5120119849961084,0.22376481312480309,0.63256297089134605,&
        -1.1361764985911047,1.3305785102155174,0.37279900770660657,-0.35991054012958762,&
        1.0774033935343159,0.77948789468240376,0.56990253379100175,0.59083973191354311,&
        1.8525806005470105,-0.80728117932061005,0.32480229867859300,0.42501766276552422,&
        0.87618470834789930,-1.6461094900282600,2.2017871293241829,2.6312373388767987,&
        -1.0951331479281632,0.24936006711724976,-0.18520212297302283,-0.28767789230055679,&
        0.13957848558800959,2.2967033887925767,-0.76918218196340005,-0.27923167856991277,&
        -8.6663540249994134E-002,-1.8052182058261304,-1.1793815517380946,-0.11256577459810969,&
        0.46723467546306624,0.34563393404178311,-1.5537665510128686,1.0072712691933960,&
        -0.35956824524954967,-0.15613408927365988,-0.79032599120170977,-1.3141840997575929,&
        1.1806793034333123,-1.1826339129640495,1.0852059448234481,1.9000708681848695,&
        -0.74915562619550691,0.21412973765554630,1.9003058691890116,-2.4564375766898136E-003,&
        0.57599707109556741,0.65134462541677018,4.8070473746480977E-002,-2.8732641747987189E-002,&
        6.6775615783413095E-002,0.62533012073152128,-1.6312655049061546,9.3612059343183771E-002,&
        -0.32447791211468807,0.43214335398499970,-1.5904782555076549,0.83928042885234511,&
        1.3460257526415527,-1.4006979192171383,-0.12506490310796670,9.0107579849724243E-002,&
        0.67968112907647682,0.29668714903662069,0.50614900754669545,-0.80511019618212398,&
        0.25924910630260184,0.85729475227144425,1.6346730314785674,0.96755222377550243,&
        0.86946174220388073,0.87406745100160366,1.3914428271961574,0.15428895953701491,&
        -1.1603044204619581,1.5064321097805358,-2.7976621875302244E-002,1.2197864955862294,&
        0.17618113985139114,0.43457649248277769,0.80216036093827303,-1.7023476881330950,&
        0.91513459905394745,-0.27892881754430249,-0.22811186625803781,-0.97182157303450478,&
        -1.2497722504924806E-002,0.60596512756045529,-0.34686127965260788,-2.4980117018905505E-002,&
        0.56066791710607611,1.7868875858313820,-1.7879366246863244,-0.63225788443313435,&
        -0.64814922924407248,0.33508137140461464,1.1695420455881300,2.2958341225526144,&
        -0.68038079472822444,-0.51959442760904040,-0.31849323388108430,0.35698216106943081,&
        -1.6873322058171558,-0.35071328292106813,-0.54335908824769452,1.0718960250651981,&
        0.32637842761815578,-1.1272058437908048,-0.14851150614275413,-0.99083539389627806,&
        -0.51157370798648827,0.12711533051777651,0.39041793429092969,-4.9597484982017966E-003,&
        -0.37202373193164473,-1.1711332250129303,-0.50603533910523379,-0.35325301605432663,&
        -5.9162352646889536E-002,-0.39880204287000093,0.25008779911746665,0.64905181879456408,&
        -0.39674940258321006,-0.40114300334058772,0.68641468925039950,0.37554311591755968,&
        -0.30218247582243124,1.2775361769730840,0.90477055345737989,2.2257432009289162,&
        1.1174335152967700,-1.3266077745134255,0.69975115482892036,-1.3383165606233625,&
        4.2263678543524360E-003,0.19789159496881498,2.3782440354196783,-0.27359644071067402,&
        0.52708941625699923,0.16368742906413730,1.0143716749516398,-0.28459001258196887,&
        -0.12716602090599127,0.38417990828567816,-1.0138155720163742,-0.12626659778791613,&
        -1.1208583330868309,0.15150351928130004,2.1439141799594994,-0.38910661292052917,&
        1.4707139095863964,0.64402696248577873,-1.7618607608787245,-0.95027542744599713,&
        -0.51112883079948779,-2.4255744180555872,-1.8749563594639529,-1.5592443934848657,&
        -0.88203124303506242,-1.1007193571082043,0.84617355158286023,1.1459805225936015,&
        -1.8584763687421284,-0.48597428964910994,-0.60563504270716095,-1.8301792441563594/

        DATA MC10/-0.93151730843034974,-0.67107021312680171,0.82998305374476899,-0.14540820802987964,&
        1.0182857370668821,-1.4083426017257197,-0.31905945199060981,-1.4595747804276069,&
        -1.8430607003588091,0.44524216446200421,0.61037879086363533,1.3793949841262900,&
        0.55913717665685803,9.2048043083264100E-002,-0.52776724651390516,1.0320738289763891,&
        -0.73089884310109199,0.73990901186922842,-0.60103404057813647,0.12841109156823574,&
        -0.10520827012858887,-1.1738506119914305,-2.4215186767608565,1.1445122149829463,&
        -1.8049099075493618,-0.46091975598531859,0.27911244343274189,-4.4909750550355038E-002,&
        0.34947501805390041,0.66023279359122422,0.44777941838635571,1.1415918055583230,&
        -0.70370616661609997,-3.4798480908190058E-002,0.12099329893995377,-1.0670913258014565,&
        2.8412929419815307,2.4517625521935822E-002,-0.97813700397789427,-0.56193286726218938,&
        0.30611867842023760,2.0770242858000501,0.54012828694917059,0.26780879538415669,&
        0.43513533744534216,-0.64772022171627552,-0.98000655334014852,-0.31036594303634918,&
        0.45653555235215565,0.72422979784009200,-1.3003292842032821,-1.8201857257064236,&
        -0.88960278477776444,-0.88041110118107124,-1.4879640943242045,0.84067721451118327,&
        0.91160135672875298,0.91021742175447062,-2.0586112522236131,1.5851027625570169,&
        0.10674665225637267,-0.25059491292682878,-1.0753404706378604,0.83439978885414023,&
        -0.87863810709010259,-0.31494812793105059,-0.88437320453479806,0.71284978314242509,&
        -0.23282850815217962,-0.68564863839628321,1.2633371959691972,1.8859351125757760,&
        0.75510745933979950,-0.38648052120169674,1.0375077194065341,0.81498284982975067,&
        -1.7206997510721784,1.1263063085050726,0.24590666540601469,1.4033910544686417,&
        -0.97275322594812652,1.5591556917485385,1.9054955882149875,1.1268532834142153,&
        -0.65588908979109983,-2.2996581343189866,2.3503399658367172,-0.38824158086325938,&
        0.88964830178744847,-1.1564709473638113,0.32566410924948874,-0.66732470119611109,&
        -0.59738647524295574,0.20109322721007000,0.92078723454985800,-1.5371761642834769,&
        -1.5067149565025038,0.33857465142742543,-0.56876605444586281,1.3065488833055898,&
        -1.9475415597171302,-0.72263169032007768,-3.5424889215845530E-002,1.0726129721122197,&
        0.16197423966476862,-0.46475785630150140,-0.34058898680131483,2.3846754204709826,&
        -1.1123186422663049,0.22093062588815590,0.31337579202123234,-0.18894296890751580,&
        0.21275674443187750,0.61267477406391002,-0.45598898481878164,0.29305678576230004,&
        0.44516354423413002,0.83173874835879513,-0.55610778611242762,-1.0555370619624478,&
        -7.8968772661588624E-002,0.43910026252511303,0.44594207253364132,-0.91590605232106281,&
        0.15191851123577088,-1.5861975047259571,0.40983629900992924,2.2135984034720830,&
        0.33950327075479664,0.67630144948909010,-9.8956041969550559E-002,0.19377041043656368,&
        -0.84360611349634407,-3.8807179522268205E-002,0.38912304235281742,0.64426744923664714,&
        -1.9224574397399481,0.11783782515172465,-1.0306339266833331,0.61019335042545531,&
        -1.2472062876819161,0.24309554933176974,0.99456193834734208,0.27679494873980937,&
        1.2116946280615213,7.8256892988492185E-002,-1.1128810849486093,-1.0018872444460591,&
        1.3973307669270219,-0.93948592008307741,-0.69311213857288645,-1.4657723733994028,&
        -1.0063387149191714,1.9399618600195065,0.86692139179669869,0.91243618023686524,&
        1.2680367189615216,-1.5277187306816322,0.34458575503343725,1.7071171322775798,&
        0.52159002002661636,-0.24534703179868467,-1.0671380306468996,-0.84650296991948681,&
        0.19873912431773386,-0.75343999957616059,-1.7517999551508279,-1.3903627231818809,&
        0.31565575439713461,0.29162043082492128,-0.47185745745539459,-0.24176616874386789,&
        -0.32951983010171748,-0.24458257326894053,0.19154142115935935,7.4187258136199599E-002,&
        -1.6994273939090592,-1.6959627459291473,0.53345382142718045,-0.21001759133361531,&
        -7.8549696968098798E-002,-0.28288583581904930,0.12791114086411362,0.68985826992316346,&
        -1.8988767757440477,1.4160755043870628,1.0278872636197807,-0.49676870645891352,&
        0.91366471322488774,1.2478592690111705,-1.3998882523611726,0.77611184704668312,&
        -1.3757130944372743E-002,-0.80463154062654707,-1.4003724554283132,-0.80839197805607854,&
        -6.3195337364135265E-004,1.0301694942228110,-0.35722027087816116,0.35389022667921316,&
        -2.1483238106714415,1.7748195449050979,3.5023893655829162E-002,-0.47582744499537122,&
        1.6843995143557400,0.94821574901710481,-0.33052080487332797,-0.23682548553347674,&
        -1.0613341102498970,-0.37658425997188105,1.0582796442995446,1.1497418834271147,&
        0.76577757688223325,-0.61418572645930725,1.4529088346271510,0.38283710133545112,&
        -0.14118967376500474,-0.25410963499505562,0.99382883465303473,-0.17452627241495847,&
        0.41221545231486012,2.0877739124076662,2.0022473316898446,-0.46700825619264957,&
        0.28951371178184293,-1.1003008701033430,0.14086481349785945,-1.2589224828261614,&
        -2.0132414002721082,-1.4168063916190513E-003,-3.4920041742851592E-002,1.0957027909445116,&
        2.3234572894652477,-0.76053016053196709,-0.62165145328729987,1.6057356834375680,&
        -8.6654883500437100E-003,0.17323922659820665,0.64945082843939306,0.80806461784266259,&
        0.76441518692946619,1.0012470834826452,4.9730339154466521E-002,1.0815883402974652E-002,&
        -1.1033343393761150,-0.67600063352906714,1.1036611892567565,0.77357881794127881,&
        0.46668457314896111,0.91364954450490776,-5.5407051088715388E-002,-0.87020130534557893,&
        -0.63210519463487236,-1.5570299344177614,1.9372865724498456,-0.66167457362654714,&
        -0.49076648614887297,1.0117288430435698,-1.3356913660752738,0.16104855752937192,&
        -0.91841011972343500,-1.0953493866993982,0.96177789920328549,-0.62112069206023102,&
        -0.88386377941448724,0.49467821541676832,2.1560600628570321,-6.6037912221649495E-002,&
        -2.1531344912103583,1.6173648848679791,-0.16366117487072965,0.28776581182873867,&
        -0.90888593467722500,-0.63203649789056349,-0.46679994923195184,-0.75210257279302961,&
        -1.1313568201011184,-0.41334937160640012,-0.23161073328881859,1.0386206025935443,&
        1.3508923415021068,1.1196452146470399,0.45250776956083816,-2.0357818940437866,&
        0.54021497410455011,0.40016555583310298,-1.9562755695539760,-0.99099851955805063,&
        -5.6262997249688279E-002,-0.53995575625325454,-0.10066828667793035,0.81361585562309002,&
        -0.68394925687004493,1.0918575175682648,-1.5355891754753357,1.9488719022945615,&
        -1.2914114196273445,-0.89347090754843150,1.5729036282627076,0.52227922855167863,&
        -0.16347230500225809,-0.99714227123752830,-0.61421399805862886,-1.8896594893097529,&
        -1.1425175708499296,-2.3424356954416616,2.2038831259991665E-002,-1.4626642564144299,&
        0.67331281095864437,1.1334737573450697,-1.5406439761779782,0.36621716100462975,&
        -0.27840999190354510,0.15212818622778748,-9.7528356198062216E-002,0.78974476937532856,&
        -0.69624016453175186,-0.24482643524280523,-0.24698233623505544,-0.43060955922111194,&
        -0.33775445644413493,2.0293178615918679,0.51837956402802499,-1.4123051591835709,&
        0.47730154400265212,0.71806274997803998,-0.37813724516293867,2.6558104814046266,&
        1.1671927858017723,0.29192911227740775,7.1548959326080061E-002,-1.2689862510480812,&
        0.56906484905277166,0.32469198796130416,-0.68763823185573170,0.39374774268514368,&
        -2.1988895817196910,0.23922583855947355,1.7500869702046928,0.15765508050023394,&
        1.1809192055715678,-0.90260585763129575,0.96821851556597882,0.55225906471596808,&
        0.16051407652643124,-0.30508887164349019,-2.2514438712461184,0.72521028760791550,&
        -0.28209422474692492,-1.4100890614001413,-1.3826726939566008,-0.53618715308650378,&
        -0.82791798086045365,1.1787062453274952,2.2828551333402902E-002,0.32793142856716062,&
        -0.33400461193390907,-1.9333818360323516,0.31842410987750486,1.5079937043770246,&
        0.75404760788852621,-0.39152320507001109,1.3863908918653856,-0.22909693661956856,&
        -0.44303382184001938,1.6760961626541435,0.81035843088364390,0.23290555100624827,&
        2.1249705997538140,-0.91231018777708939,-0.22932794976929108,1.4908774538137195,&
        -8.3495622657037333E-002,0.83535741613487891,0.86117703546585722,-0.97482870511761466,&
        0.56220182483747450,-9.5652401886732089E-002,-0.56163384462402177,0.90780751857661002,&
        -1.1020086226842649,2.7990835606364447E-002,0.79901948023787051,0.52162237814574108,&
        -0.46909965656451957,1.2022221672256335,0.32371817900195266,0.32480586050627325,&
        0.15072866563800266,-0.31973386406634235,1.4132254798808561,-2.4552407602669000,&
        -1.1383528016030022,0.31393653377097769,1.5935504993239937,-1.1484501856941975,&
        0.26208061663774657,1.4626566522316868,-0.86098527456739204,-3.6880417995205667E-002,&
        -1.5355369983869218,-0.82750116839250942,4.0382809882755027E-002,-0.16867791160088014,&
        6.6984303457728989E-002,-1.0849959577904866,0.29829878928551795,0.70388758038921162,&
        0.36674162249440950,0.36574668901174412,1.0873094288783072,-0.15672983086503819,&
        8.3221935744643635E-002,0.53691058977535555,-1.6795779703571130,1.2829251179847647,&
        0.66075682668083024,1.2744657670249115,-2.0479231975999346,0.24256970480064369,&
        0.38680705890462147,1.3390428687009384,0.44056196064044634,-1.0954881793948774,&
        0.66516315841088769,0.60451545657157846,-0.14285934799266856,0.23365797082099424,&
        1.5785130499433639,0.34781075128606154,-0.47330006617012438,-2.1103728258238785,&
        0.61529326964150766,-0.57891504097943214,0.40820675800498968,-1.5753478688372762,&
        -0.73244295011214910,-2.0260429216692919,0.29416872006878564,1.5048652450547590,&
        0.10361549057524666,-0.95080297825980420,0.52435829795798172,-2.8790527230760719E-002,&
        0.11273423985817288,1.0952927021241285,-1.2893011486283763,-1.5043264620467540,&
        -0.87414136846133728,1.6948304907002445,1.2608899980460329,-0.20309343447340256,&
        0.94169477167395810,1.6463846334750585,-0.27281349001849314,-0.27791264994874876,&
        0.40312301871791434,0.64129063921566620,-1.1961089264444262,1.2094772416741069,&
        -1.3412156744142820,0.75620359737830900,0.86427074189897890,-0.86814534804838051,&
        -0.83985084167801660,-1.5944967650297530,2.0063734300111498,-1.4214519203296605,&
        -6.7813727734484991E-002,-0.69589068885402883,-1.0215362869154114,-0.10019092818775853,&
        0.32475097983596252,2.5910125885012598,-0.50438586738774172,-2.0619288468132830,&
        0.65253288799498355,1.2336806049486511,0.23968508429587956,-1.0156494111810688,&
        -1.4116012484744347,-0.88967076289139513,-1.6339419304645943,0.98944728375260560,&
        -0.38079957095154354,-1.6724107083129216,-0.38119925776367697,0.16139553190195877,&
        0.90571183345560258,1.5047575652875578,-1.7716692005338590,1.8239531179125277,&
        -0.49732552486337550,-1.5101546671573660,0.42181434261780326,0.96885070250543548,&
        0.90720251470010027,-1.9176577607846597,-1.6302917221694522,1.6979281722688904,&
        -1.5092814420687515,1.9228756684151092,0.94326458469784924,-0.50671397656364503,&
        0.42934615477414301,1.0531853502185862,0.20912024853925448,0.44908469063595036,&
        0.62666198117917271,-5.5248704829496731E-002,1.1866903417938091,0.95551255767707211,&
        -0.71204954700143130,-1.2278430602501154,-0.65296451374337616,1.3027241201050612,&
        -1.0528258383215294,-2.1315411070384318,-0.11158297602485155,-1.6290794588512234,&
        -0.26088939021117219,1.3410783995970748,-0.91759498358379898,4.2833214785842934E-002,&
        0.27352474019095452,-0.48654471321699555,-0.78307705984618059,-0.14816273052588150,&
        1.3041131051166854,5.5933278617802111E-002,-0.36586319010326979,-0.78106534339942446,&
        0.48127035792944473,-0.54801422641747344,0.81450447863657993,-0.34279439130435402,&
        -7.7600912972346781E-002,0.54784668607793785,0.84803891324748792,-0.94489120692321504,&
        -0.73009490957466794,-0.68999276192045378,0.31916143519320561,0.62039884391541045,&
        -0.69180332943324174,-0.90955772375052479,2.2563605650153820E-002,-0.75761086575078396,&
        -0.63470940172510582,0.15927949556908802,-0.14487802220155249,1.1441114709360343,&
        -1.3933615038861089,0.68618383360353874,-1.0073844397976737,1.1181595243557800E-002,&
        -0.74353999586274566,-1.6087160151725663,0.59553880708668638,-1.1431564815657602,&
        -1.4057188058956320,7.1025757886797047E-002,0.46489377138357113,-0.55806563439841561,&
        1.4274625032020838,-0.82175613845210860,-2.3177527972988252,-0.58904480502837486,&
        0.33862809687962508,0.99607527801859708,-0.80962815952814615,8.4631040738063879E-002,&
        -1.6861883770212076,4.7359443684637841E-002,-1.0909011638290227,-1.8314522493359069,&
        0.50503415566332410,-1.0984361903856197,0.86089398086336621,-1.5927640206210851,&
        0.16901601294345453,0.58760348264980444,-1.8512948660920241,-0.29134467785664891,&
        1.5773466389893300,-1.4882012606424360,0.35089411766761042,-2.5171900977656589,&
        1.3373294701293250,0.60000691273336382,-1.2426096803771876,3.8738887068526733E-002,&
        -1.0637655854864316,-0.79378917964763396,0.58046332119939392,-0.91256495152305372,&
        -0.38078798591242707,-8.0546323437192521E-002,0.14790575006636369,0.33908487413807981,&
        1.7570749106075745,-1.0307104466342576,0.19918719603189686,-0.74727455913448071,&
        -0.65397156524261701,1.6632871565123275,-1.2683942236556018,0.68362774832423268,&
        8.3719147517051243E-002,-2.0376119735019302,-0.31135641748003212,0.16113279941403713,&
        -2.2150972521066237,-0.55042480326472920,-0.56087085366492728,-8.0633818636259888E-002,&
        0.12558587138237814,0.82770901251481466,1.9315487715982973,0.63118514912403778,&
        -0.95347659064341006,-1.1419721581670712,1.4241681235001848,1.4135442631342490,&
        0.79599258255770167,0.35852855210855378,1.7650602157358275,-0.21079784887125352,&
        0.31050434518339970,0.29537378500987216,0.47777584928853978,-2.1008956949029454,&
        -0.83275257152855287,0.30268955378329720,-0.62811571640491504,-0.39321343425047173,&
        0.17513972454747673,-0.28854785207411843,3.0822584267885957E-002,-1.9022681542908615,&
        -0.90880023129283516,-0.77202969722314974,-4.9735952032349956E-003,-1.4567640664903831,&
        -0.11111957017053828,-0.53657037662902174,-1.0804497907786073,0.58954388683382541,&
        0.64867606418789725,0.91661499823510617,-0.94665033689528200,-0.35987735569290369,&
        -9.7033853998854031E-002,0.21508443484813686,-1.7415022063548298,-0.21823706432714551,&
        -0.74953478075422608,-0.88923158626808152,-0.37339566421977322,-0.19215670151437528,&
        -1.4041424234147466,0.47621296824443810,0.19125047844581158,-0.60270252480755948,&
        0.10133145126317436,0.85705105846609997,-1.4826692481155097,0.45393374440269052,&
        -0.96978899612197189,0.48832597001857647,-0.54516323533228694,-0.16993771978679889,&
        -1.7734040728395013,1.8748028082965322,0.64595778116129243,-0.39226040186444555,&
        -0.55335860011394400,2.9840206446264263E-002,-8.3089255829232475E-002,0.17489216519138784,&
        0.47012437480874808,-1.2170189682079247,3.7046700899767228E-002,-1.6057374206040664,&
        -0.60415065289317815,-0.12807840133118434,-0.17460041464667261,-0.69755680462729930,&
        -0.37938316697311453,0.55689836689613281,-0.38216056009912741,-1.1554161123586035,&
        -1.3525646484711626,-0.30156578491998642,-0.81118932041961811,1.1757569323906283,&
        -0.94583516375625643,-0.97389998198480288,0.57547892106241927,-2.2128624665692680,&
        -0.39849544074545734,-1.2483141758383083,-0.37868008848416457,8.0248352195828442E-004,&
        -0.51468806534624856,-1.2863710521567218,-0.60006308707296752,-0.88800954363439577,&
        0.14905967198826589,0.95798607241944034,1.7836338714474369,1.0830465998649337,&
        1.0350151330204527,-0.19878248208435007,-0.81483620124368583,-0.20917960970938687,&
        0.26002465123776985,-1.6802225561912212,3.6601391073072309E-002,-0.64810273544445440,&
        0.77131225028808914,-1.5114472896229234,0.15974445093011849,-0.64252615551505166,&
        -1.9299525325413662,0.77960610422395926,-1.9898750843342352,0.35553877419338981,&
        -2.6838294900203370,-0.40269061812527496,-0.33590127656559138,-1.0520568171198039,&
        -0.17828041184446608,-0.43463701300296820,0.62472837125790703,0.84100550146519715,&
        -2.0813694292133436,1.2064537576889507,1.0574929723994373,0.26651741266532453,&
        1.7777942647362817,0.27762916915379870,0.20672593165353464,-0.28097266194644899,&
        -1.0123024357753605,1.4982234516653268,1.1281891078072284,1.9243446502756029E-002,&
        -1.0368553731074464,1.3816103630679852,-0.60264807414932087,0.58583816942972389,&
        1.9336984629112615,-0.44642510379018663,-0.27703112783184031,-3.9039614222637006E-002,&
        0.21454736817257997,1.3758772817277163,-0.99958843040487111,0.49960937042741127,&
        -0.62776656308817136,1.9639747664818356E-002,0.37220875702313683,-0.53738838662173494,&
        0.51450616329491072,0.72856934926068651,-0.63689159166401299,0.53177090344773581,&
        -0.15836261516214842,-0.92712878286232658,-0.66192163287944561,0.62113639370564910,&
        -0.92383614498561251,0.51739344054804082,-1.3635812882848752,0.75348544943962426,&
        -0.44071161593321823,-0.57707592163885757,-0.21556642521350308,1.1271418550090684,&
        -0.49667682354673937,-1.0534143864991916,0.11217371989942833,-0.32305742851727742,&
        -0.94762378023356708,1.1812652050069459,0.89922407814382754,2.7282929050649656E-002,&
        0.14932691056584621,0.46354547942024998,-0.83377668141520334,1.2533997912065662,&
        -1.0452363707020427,-0.43031186200652272,0.27239600248419221,0.27349679245236330,&
        -0.70795225145263274,-0.62448275537799225,-0.45410394821788508,-0.80617618514119049,&
        0.52066003155965479,-0.17814610559456417,-8.3949357290269436E-002,-0.62274867352370766,&
        1.2894394163532281,0.33280167249699200,-0.98515476870181018,-0.16508034865605403,&
        1.0548760379814026,-1.4419262790161513,0.31715639572009580,-0.83915717788516175,&
        1.3700259048429477,-0.95829902285928914,1.1377858226350905,-6.6836629262670907E-002,&
        0.82396535928558345,1.4204253340750943,6.4648385403153069E-002,-1.9733345320360862,&
        -1.0564689971905381,2.0496312558058074,1.3702922002451559,0.21409897858332055,&
        -0.53296002414477506,-0.28447451157750375,0.98924001581534249,0.29554748214699061,&
        -1.2773968609719384,1.6368156609062252,-0.22924762181248193,0.24851063162605211,&
        -0.36316132046504029,1.1280492471836074,0.78810268280761486,-0.71755590659781809,&
        -1.7718790437581715,0.24512951206420835,7.7606479158776401E-002,0.23573488296226527,&
        -0.39274315743010180,-1.0865106008696366,-7.0457044236001923E-002,-2.1836077168701578,&
        -0.92161417072337348,0.11962653649202262,1.9490189728098464,-1.3768552580847663E-002,&
        0.29452547167990167,-0.44358629227129082,-0.48476298964059150,0.12837810796048724,&
        -1.0299021094837422,2.0540177727526934,-0.72119906729273209,0.92721373279828034,&
        0.93309878017460701,-0.43357491640010937,-0.80970498427188886,1.0151515862754374,&
        -0.75876343067755991,-1.7202962409619955,-0.31568623085827835,-1.2323718651915967,&
        -0.81568934650567371,-0.12682656523172242,-0.85524877252334308,0.70141449012809731,&
        0.22107179866101992,-0.73741953252423420,-2.0205158584402465,-0.68425248247035342,&
        0.44632762787594349,0.35073163022108733,-0.16350375052606295,-1.0832647739974992,&
        6.3252733564362021E-002,2.4050338875159515E-002,-0.92359706796095642,-0.70172763866244059,&
        -1.1676063670503909,0.73606110098518163,-0.68380461272547566,1.9419927748052015,&
        -4.2773796009414340E-002,-0.55368817198604747,0.79342576250387908,-1.0093008114890978,&
        -1.1430533369152116,1.9642318299901724,-1.0856072349409995,0.22469631718954602,&
        -0.32750515675608222,-0.85284594452205575,-1.4870194327363222,-0.68538105082826994,&
        -8.6636074645529956E-002,7.1385350568261036E-002,-0.19215093006313638,-0.59689261840471708,&
        0.77937232111907051,-0.61351913952481274,0.11715765503439755,-1.5703945612861543,&
        1.0580295258974344,-0.55342867832682718,-1.4512096768732963,0.53868171678329124,&
        -0.16297800763705264,1.7130307806625138,0.78242912454763425,2.0460294660148479,&
        0.99251798450972006,-2.5795502161144666,1.3680205507131979,0.70908415459219487,&
        -0.10787081079608979,-0.92447009087051657,-0.54020579299135085,1.3600123748439215,&
        0.89058057773368160,-1.4632231494430976,2.0353063924406061,0.30845215987151897,&
        0.51327718335070449,-0.88576555059616535,-1.4524166435014254,1.6895985809892771,&
        0.56515100389415363,-0.26094389507529181,0.84977245928893230,1.5954782136947963,&
        1.1062199036811924,0.51186057099852200,0.57515056153080346,1.7080535346590116,&
        0.89453416646310402,0.73126038726972864,-0.73285658911770502,-1.1666377387392008,&
        0.37417076317362130,-0.12358590058604069,-0.13317961433542394,-0.73506225080270615,&
        0.67599406299931097,1.8534729151098508,1.8555716347204980,0.11109268758039312,&
        -1.3440762366320524,-2.3478403817577351E-003,0.26090269543806976,0.66864590649243960,&
        -0.11022288914249771,0.38569879111163524,0.56808046846546967,0.99057747697586296,&
        -0.28732568408706294,0.92596745069410868,-0.75222874275980434,-0.23060918032924324,&
        -1.1378053408702937,0.13245806181717373,1.7680377738997485E-002,0.81189613108087966,&
        0.23782688115928305,-0.23772253825391076,0.70867704877945237,-1.6469166119837956E-002,&
        -4.2636277642155544E-003,0.74746598297435818,-1.2259643282586330,1.7043164025033202,&
        1.3748797190356621,0.60894261564326968,-0.97312752533568669,1.5456318260767259,&
        -0.10847826319267340,-0.20499277428866483,-0.61961645357943262,0.82382456880699795,&
        3.1200468853939817E-003,0.76226703301511656,0.24980316570676731,0.94382257639290490,&
        0.53103081934971952,0.37395777714909795,1.2076478348212345,-0.83441109071182873,&
        -0.39112224258979922,-0.96636775390596641,-1.7404352428295546E-002,1.0150290293694153,&
        -5.8082035772119241E-002,-0.16545393861461277,-1.2078463709328031,-1.5236842660633774,&
        0.37377408475797247,-0.52167977610264260,-1.6310502316674140,-2.4788117802761515E-002/

        DATA MC11/-0.31626970872440985,0.67473175274696662,0.59348556559910814,1.0716377917670286,&
        -0.50319596893468188,-0.28790805753687582,0.17442913983396616,0.42582192673295033,&
        -0.40709674036486826,-8.6362552881900825E-002,-1.6010973243395954,2.0938842221873526,&
        -0.83221937931036860,1.1916197049963566,-0.81778835771935621,1.5023325956567057,&
        1.0017397661824965,0.91925550754886698,0.55171414142911213,-0.89585618066644868,&
        3.8599717329457973E-002,0.33078336015288368,1.7698581623960423,1.2028178869684323,&
        -0.84340908464912334,0.85573419679130736,-0.20307953399121967,-1.0500022191496572,&
        -0.75330422655718143,2.4423118687377971E-002,-0.25431036243382787,0.30332362727810747,&
        -1.0665351019394853,0.55123952760721151,-0.65487870555650840,0.82832043454348059,&
        1.1531262525266961,0.64632617986591356,-0.58111815617428475,0.69414384512926020,&
        -5.6850887831751268E-002,-0.46333981384726641,0.46981251223254689,0.50992741411777309,&
        -0.31817929756285335,0.50328260027517691,1.2446894369792052,0.94411333416745535,&
        0.90164399542688600,-0.54186637515051750,0.55541741137704781,-1.0958403059666477E-003,&
        -2.3377583481697441,-0.62271920049377172,-0.18555928152966789,-0.79627897814723081,&
        -0.42844336264116267,0.66062734628348674,-1.8324829124488327,2.0886532234487807,&
        -1.3763560967432524,2.0513277935381278,-1.2778261857214726,0.19579759989326906,&
        0.29316061929966264,0.24664615786181890,1.4028726285206494,-0.17664028760038006,&
        1.2713687020143012,0.19817990128151647,0.28658118951305811,1.3253505214828061,&
        -0.69693808144994351,-1.8312366901055923,-0.12882368137748529,0.32676060286383646,&
        0.27488425651677589,-0.80720424544861547,0.19398258224972642,-0.85145002461107988,&
        0.48913080038732742,0.52120327563087232,0.64432476574628295,1.2162906245100913,&
        0.22108375814199582,1.3140649662340165,-5.6992779932955540E-002,-1.2546950135304287,&
        0.38687867277004823,0.97719026956938704,0.49325710282475677,-0.83345654309449024,&
        -0.84192603139109856,-1.7465639152927235,1.1288521666409170,-0.66292236229588342,&
        1.4289081715561383,0.25921969752294710,-0.53826645019381980,0.73811978846423398,&
        2.7443129861959608,-1.2357947937393019,0.25995240204619835,-0.82305594713243013,&
        1.3791218346398502,-1.1973776569195573,-0.19627959332852890,-0.76036409006276051,&
        -0.72791989409101021,-9.8016265317203671E-002,-0.41364436563241697,-0.18170052362864048,&
        -0.62216992799418869,-2.2203152765790466,-0.16873504131233494,-8.4956974835713406E-002,&
        5.2748088155428086E-002,-1.0523659148564319,0.71501292259960358,-0.39359703848357769,&
        -0.23832020437421070,-0.15195612396128144,-2.1341980231341671,-1.8480872762334044,&
        1.0110667622101634,-0.50276566257715150,-0.71357454181897073,0.42599783203073199,&
        0.38158165327938620,1.1531102547562022,1.1351276716365655,0.27302424231929046,&
        0.50697797298232405,0.57951779547359106,0.97562402733467013,1.2878191069716638,&
        -0.25410253244724368,-2.4376875287195916,-1.9361144523789480,1.4514620186320613,&
        -0.27103574881142062,0.76850275305574833,0.31128177117768896,-0.63279642257976820,&
        -1.1049407844434183,-0.16909446409211218,-3.1324423047150031E-002,0.87521851717842802,&
        -0.98770467499828285,-0.36725459308725938,0.70451753614771173,1.0103944621502610,&
        -1.0675555551716214,0.33219506890803163,6.5999937015700644E-002,0.15378434047989450,&
        0.73195620242505610,2.3076796676252327,-2.8114542350936755,-0.46578874931919600,&
        0.79822358935821758,-0.40242420234355919,0.32078075077354101,-0.77942199567918324,&
        -0.51031212092454603,0.30860970058985993,-0.18425664536283942,0.20985245182917850,&
        -1.2601142912943344,4.7173756755688023E-002,-0.99557795945241778,0.37018381526161492,&
        -0.50288017032492371,-1.1450304736741881,-0.14582259871792053,0.21526592196100430,&
        0.68168185396253622,-0.41531374294564755,-0.79496127044576281,-0.16169057727613803,&
        -0.25472109159044309,0.45670675902132418,-1.6160371602411123,2.1637261090140979E-002,&
        0.52002005348724922,1.6472831939507628,-1.2592444526899276,-0.14210273791046157,&
        -0.79073083656345922,-0.47547831430492687,-1.0567981960009165,-0.67818335850786793,&
        0.94943639116116341,-0.55658557641653150,0.39001277921523109,1.0463629704348674,&
        -0.67093549687244569,-2.6301288978150485,0.15787707508346047,0.27878690980339621,&
        1.0375602638984669,-0.37015132636748627,-1.9041189926710731,-0.58246044255224272,&
        0.76688295707253640,0.63664463947214434,0.42912392155864598,-1.9549524156073379,&
        0.52764001640476887,0.73721461832543478,8.0824820785780557E-003,-1.8886292459744671,&
        -2.3990217937988256,1.3563655727392656,-1.9328272799942186,-1.1683546282303405,&
        0.34350586701965713,-1.0640097934424388,1.0820868147587344,-0.38517701198315907,&
        0.65419747005791962,1.6956854274588762,-0.31332681486925296,0.44429242005250985,&
        1.1335803898569219,0.70318537082324262,1.0677862092813406,0.85498215195725713,&
        -1.8074169690438022,1.4051228456156259,0.83526589545919250,-0.55482817877253610,&
        2.2418460018763295,0.87536553552862051,-1.9181186586373706,1.8363960075766022,&
        -0.16189852890708487,0.36769678437428616,0.62672446809214166,-1.6031801058365462,&
        0.95571060880286784,-0.56990016478267125,0.62556540537270300,0.12875366461008422,&
        -1.8537016972999063,-0.31384379629777870,-0.17947915581807500,-0.18380779583773518,&
        1.4052838113014552,0.55848775702716524,0.10579140544883756,0.84897856954771778,&
        -1.6006882218351497,1.0168135763467552,0.81267404362419471,-0.14347219377359544,&
        -2.2481275020692979,-0.91353287796785476,0.20958943187202494,0.48207641063450046,&
        -0.43846840385393299,1.7216666951021194E-002,-5.4519875032420513E-002,-0.28101816686592090,&
        -0.67097287428150409,0.34272030534481224,-2.0858356571599682E-002,-1.7613441996802643,&
        -0.97637749181079614,-0.77233908275013841,1.2109554248409440,2.4094445630208141,&
        0.85569530617104339,0.16586191781494874,1.2091069419749556,0.71662506984531182,&
        2.1893056797957682,-1.4026323052539218,1.6175970403738822,1.7593244751828212,&
        1.5230403274800077,-0.90807705664516747,-2.4365376628165412,-0.87366837987429469,&
        0.20304532777649592,0.38380312484570805,-1.3091536886936608,-1.3867718395678996,&
        -0.68643471070364115,-2.1797018422234355,-1.4915310366920096,-0.94439234186178678,&
        4.3503240621715525E-002,0.40300857980333593,6.9980860445317247E-002,1.1833384377386300,&
        -8.2421687932712887E-002,0.30609212621518406,-0.24142795462792033,0.77633845349371655,&
        -0.26522356645580780,-1.8308446050037996,0.37406975711818286,-0.92912828410970094,&
        -0.84716724075623850,-0.73051374718157036,0.39576834252086407,0.71798553064970128,&
        -0.69529215000094180,1.8874229976092058,-1.0317970343262577,0.41854854622366816,&
        0.40330700293457517,0.38933290063226944,-0.91046244455470049,0.46307510812286906,&
        0.69797608369879671,-1.7876513558431435,-8.8412505132979186E-002,-0.22033448816812412,&
        2.5417787127535705E-002,0.55026989693963158,1.6580265622683876,-0.51477704595742757,&
        1.1423436475425910,0.87759122244776722,-0.82278143635357148,0.23053024128521554,&
        0.38234207277833016,-1.9923687446568323,1.0644668650625393,-1.9104062011905314,&
        -0.86453520579058551,-1.0365281541504188,1.2220862829393635,-0.43070474491936733,&
        -0.42879423191813743,1.3518686612522479,-0.20276269377327946,1.8668492804647101,&
        -0.90160718505623172,0.55701491240756729,-2.5737997990508061,0.13090189144728481,&
        1.2180183793539121,1.5447346992056497,-0.22623857125287553,1.1309113230657521,&
        1.1934508372910821,-0.80782336929240695,2.3023976583142616E-002,0.18958283345792865,&
        0.50500921631966300,0.98951206871515629,-0.71437566900735250,0.38638287791712228,&
        -0.16127019167095236,-0.61585253745673751,1.0284752524408405,1.0780833638098712,&
        -1.1437882694216535,-0.47766292185228959,-1.8340823014562722,-0.81734546630157567,&
        -0.89178750816949470,-0.43955022666920374,-0.52931110688671401,0.11115866663351341,&
        2.3390565278411390,-0.68214195053579962,-0.79822070331988304,-0.20110150225041776,&
        1.4841294533918963,-0.67643095418628751,-0.61705858556028037,-0.87583641512400179,&
        1.9086878452209678E-002,0.97444113040263458,0.25111641736561580,0.74928755829549254,&
        1.8101061043829894,-1.5595128919588976,-0.45779746445627489,0.18316268503767430,&
        0.17370054121164885,-0.42066301215928081,1.0379048006114806,-1.1771925531863683,&
        -0.77676259651436863,-1.7578282727556875,1.0183550853179202,-0.81505017205112540,&
        1.4898228635809403,0.77747263568568659,-0.40627161009572371,2.9730436260186514E-002,&
        0.74452447610654482,0.97768402741998717,0.63618236528172178,-1.4865629605413069,&
        0.98397851299693184,0.62261527994573374,0.31276121415079516,0.25217688100094759,&
        -0.83761201374247218,1.2186118846442824,0.94890076695778058,-0.94818297875579438,&
        -0.42193135076545130,-1.4631245079749313,-0.30735969408978198,5.6676890294709556E-002,&
        -1.6501599746096520,0.84872833769353995,-0.54149757287626443,-0.35451978926283700,&
        -7.8602323880335001E-002,1.7116813664481196,5.6057622810438495E-002,-1.5070720992056941,&
        2.0166676085830426,-1.4869104789007181,-0.22420527740902918,-1.9368439226530023,&
        -0.19453594254145520,-0.62411920194944159,-1.1717067351872312,0.21953918905287931,&
        -0.38732386808718733,5.7707786012402222E-002,0.80185879050614839,0.66851307323255671,&
        1.3934267290458140,0.27725542518690194,-0.63852666612285414,0.53701689246342954,&
        1.2220125185394757,0.96399349187588124,-0.58100517830095610,0.34893864380919620,&
        1.3363951278911201,0.48749043840477652,0.26603077194365454,0.59549698468790779,&
        0.46740924201936407,1.1991021670909163,-0.84694940513257444,0.39848876800107125,&
        0.47468696508632163,0.54568653764587138,0.18316061219376500,-0.39900560494714360,&
        -2.2749093456471168,0.37434666256357241,1.2123424191499168,0.72593472497390799,&
        0.20670187409910762,-0.72864985052145181,0.50902860750420609,0.44425301873803330,&
        4.7895566587267152E-002,-2.4201817713806837E-002,0.26499975942060111,-0.84450422973927897,&
        1.1869473996694568,-0.74883166386409250,-0.70752578224049500,0.50701091174248569,&
        -0.91410741790960515,-0.78161837869838380,-1.0988849397337168,1.1245744094793453,&
        0.38561405846386271,-0.22177646450556196,0.69174912870131278,0.72268914025467768,&
        0.41098059840202389,-0.26963637351906744,-0.14284847983073318,0.16363334844707436,&
        -1.1196903573484966,-3.2053214056950982E-002,-0.30698206061673478,-1.7735218541097886,&
        -0.95644804753906709,-2.7534233619020858,-2.2974828045493787,-1.8758965731603960,&
        -0.37875436993284822,0.30239228578855687,-0.17369439499394015,1.3735968895190809,&
        0.36143500459163114,-1.3745053282437061,-0.47722195491975500,-0.24152011671473100,&
        -1.3156943189917782,-9.8372537098671206E-002,0.83991827079495307,0.14258194575238589,&
        -0.37243214198913172,-3.4843832354996871,1.5592385632057357,-0.34632361259430072,&
        -1.5486041300652736E-002,0.80024663461958478,4.7984568828420490E-002,0.48958671630947886,&
        0.54676052629120764,-0.89416004556880369,0.93454153306581311,1.3682178460938763,&
        -0.42351686578356723,0.63717849934594328,0.67629496990138227,2.7950776019581174E-002,&
        1.4327175396055032,-0.52638448845605701,-1.1180064106993126,-1.4390658353129580,&
        -0.21110413895184926,0.71475291704109778,-1.4640479789016259,1.5558798402475726,&
        -0.94146553505237851,-1.2334727871956233,-1.2562980061925659,1.5078232051959140,&
        -1.5851026174305645,2.4178030170133114,-0.22499672344521648,0.68130123103349005,&
        1.4404371886183667,1.6073796167482202,1.4636325619870055E-002,-0.30747642193696834,&
        -1.2275938983946999,-0.35605108488701126,1.3867937101884238,1.3941831668030895,&
        -1.2526023767992887,-0.44886415828776188,-0.39481259018874620,0.87744741189348430,&
        1.0510674057608227,-0.65626270500477324,0.37572544202364638,1.7701704121226833,&
        0.70162244657899575,-0.63064784528703333,-1.3150045530468235,-0.80407918382233878,&
        1.7319188799395679,-0.64329301613076328,-1.7259988971900251,-1.5712094655728908,&
        -9.3585122121017286E-002,0.67534035171821938,1.4192224178474420,0.58009982324091858,&
        0.84973518008545812,-2.8987342908630382,1.6140576923609400,0.36604427662325090,&
        -1.3457592954048512,-1.9401383175704638,-0.39980117921108960,0.99024989288817078,&
        -0.47292946241790035,-0.69509006866406908,-1.5831014217494763,-0.41021026637820618,&
        -0.74708246852826476,-0.10509017373536275,0.13982880281644613,-0.73375545324859348,&
        -1.0708057371025550,-1.6055657253112765,-0.93864771465439323,-0.51153668119364937,&
        0.76000670924319280,0.30614248048686710,-0.57749150733676047,2.3980308722946786,&
        -0.45933911405606731,1.7800331017498459,0.62224604614784329,-0.11268765925106194,&
        0.42659051809507215,-1.1133007075487404,-0.71440798443941189,-1.3002000725228191,&
        -8.5540217064096799E-002,1.9114931382352369,1.0439688787252996,-0.81947956688281565,&
        -0.29932946420917128,0.67866667089956079,-0.58958000031107316,-0.61662541722298181,&
        -1.5449151485024855,0.19945902993609327,-0.90053430089541220,1.6375455887029251,&
        1.9199415585951978,-0.45559574948525450,-1.9032040876203629,0.15615654615119090,&
        -7.7248172802500834E-002,-0.63948585464426411,-0.52570684571745807,0.24486136257239255,&
        -0.19612337926850401,-1.1468299408687173,0.12642762289997592,-8.4694658824133767E-002,&
        0.79122098953104136,-0.21956189493895517,-0.75675014277871488,-0.36575083921772628,&
        -0.63501953104790188,-2.0589694076715874,-0.22637429693294914,-2.1906116247200567,&
        -5.2575323630914904E-002,0.76493527621952562,0.39434766862697984,8.9688801318825020E-002,&
        0.89109788370906851,-0.77906696589635049,0.11508362432477019,-1.0088476671899593,&
        -0.45872962716466631,-0.95596041270713616,-0.67818829785186485,4.8743668903003183E-002,&
        -0.62918659861239457,0.24839322083185941,0.45138557286308684,-0.15952117845352373,&
        1.0658709373791903E-002,1.5584189321284805,-0.57327475758098279,0.55428917420409962,&
        -0.60794683611496614,5.2016177380234639E-002,-0.55205303018761920,-0.90784202230971023,&
        -0.56416387791933253,-1.4068954527936641,-1.2319711296579379,-0.33030073984141062,&
        -0.80269376343096099,0.47875696774955778,-2.1912420777904869,0.26525101034526610,&
        0.91298203246773801,1.5685033784361138,-0.52889955657518806,0.49582880347583480,&
        6.5667200634160578E-003,-0.46907750370207202,-1.5089074933761890,1.0690046873849666,&
        0.10063841408131544,1.4237909149256278,0.60223656168157580,1.9751137751920131,&
        0.78733117449191770,-0.24614682386109610,-2.4905363119360158,-0.70491282161159330,&
        2.9925354760534604,0.86738640884587870,-0.74157883727141460,-0.57305220811161794,&
        -0.21080355819853275,1.0369862189760524,0.85837804287180697,-1.2724394815411397,&
        1.0667670435391829,0.97515795856964538,1.2651304133103649,0.84753964168792439,&
        0.37958411180670726,-1.3691625493583441,-0.28502153951218817,1.4768555663292826,&
        2.1824747660698627,0.95565386919729911,0.36872475302739582,0.11561718145491244,&
        -0.36142543191416887,-1.2763775116511014,5.3149194648836572E-002,1.9485214564215450,&
        0.14351143947455941,-1.2884357702762479,0.33479870886816759,-1.8533524763231575,&
        0.54327060724130116,-0.76644956633315708,1.8805906516059991,-1.1499597203394782,&
        0.83157345972848662,0.66926919904699356,-0.49667972367764218,2.6277084183794495,&
        -0.11725209369353543,-0.48429581027418472,0.92261224251640650,-1.1220071232114011,&
        -7.6178977602456843E-002,0.44248676622413069,-0.62637570159145572,-1.4524647183000374,&
        -0.21613102263446207,1.7805496805776924,0.12780550748298697,-0.60556160955444549,&
        -0.19182463194414048,-2.2570142307839185,0.76145761510879839,1.3283480442464422,&
        1.5951138079515836,-0.82508292005209605,-0.60983834619631516,1.6673140803474511,&
        -0.39380342972014770,1.7595114356470001,-0.54835084571181203,-0.23754860490015078,&
        -0.33146802945581977,-0.18078644686151268,0.41061292599745719,-0.31797660261521404,&
        -0.27650112281857908,0.98708104799694962,-2.2008332958438001E-002,-0.97939771958872457,&
        -1.6571679126762215,0.61012280146505415,0.11761405237946275,0.95060240623813652,&
        -1.2895864778127739,-1.5963789804602990,0.19678898492594052,0.32397834721295221,&
        0.31929670500075058,0.10408424681516158,-0.44509881263920298,-6.1517110138865475E-002,&
        -0.14114652916513487,1.0277967167158715,0.83567245413055569,-8.9080690776702082E-002,&
        0.11166861879532686,1.9232786482531554,-0.98879458569695133,0.22946622098587016,&
        0.94827622162852720,0.43924020630392313,0.77331741506441865,-1.5280421318807693,&
        0.78012787278640228,-0.55712041821138292,-1.7038566838260836,-5.7528605096123737E-002,&
        0.26516178898221937,-1.2451224787256623,-0.37483606339327030,1.7294463222861842,&
        -0.50450405487121242,1.0295507022848418,0.69008407207894096,-0.78771265655357359,&
        -0.84473651611649669,-1.4495825449481718,-3.6036103981082451E-002,-1.5211244445265848,&
        1.4338662533646527,-0.32007422559452053,-4.9507043057281305E-002,-1.8391221961377600,&
        1.7333973681695714,1.1773735338794737,7.7002902742674698E-002,0.26324890691669434,&
        0.92320279525285187,-0.15429089803114579,0.80793961530355574,0.88050160405398670,&
        -0.15666256223856195,6.2344663896840367E-002,1.7508621981690564,0.46314578703634379,&
        -1.5126383992926982,-1.9626206002712741,2.2813559842600881,0.54437585195681470,&
        -1.0405759809490556,7.6451028700519133E-002,-0.40665217547498722,0.89641369610254107,&
        1.6516110084185547,0.31312874860525652,1.2709632969708047,-1.2725731163677998,&
        2.7556740889705522,0.27366592322771160,-0.91434396859752254,-0.33353822224113816,&
        3.6256057044670616E-002,0.29814049624272737,0.97558696767736663,0.34087830582423823,&
        1.5294798736559385,1.4021940352274243,0.30241176102139589,-1.0567599362226858,&
        0.24417131043628484,-0.48171284080533355,0.29178244686414245,-0.89857329771448236,&
        -3.6596539502111461E-002,0.28611068217485425,-0.86543973995643697,-0.70258356901871366,&
        7.4097756981809385E-002,0.28952827330362829,0.61592047773283298,1.3608314524089107,&
        -0.97908200659016764,0.56223280113540175,0.34299327557580805,1.3706861957103254,&
        -0.36641741968275815,2.6718705838422781E-002,-0.75252796637704666,-1.7727694563950014E-002,&
        -2.1223443165449418,0.23945424476322727,-0.41101230448582265,-0.12058800505976681,&
        -0.37062983212196798,0.49209608887837980,-1.8784701981612917,0.67391868316977677,&
        2.2601900409257070E-002,-0.54303690613986155,-0.93024242004677926,0.92662941140918409,&
        0.46736478115532243,0.20016210046457161,-1.6996125349254279,9.6663483036752942E-002,&
        1.3000880179314618E-002,0.59694194665570166,-0.74410106782808250,-1.7911611777328940,&
        -2.3869992957515129,1.1857252532390967,1.8933038240875517,-1.5855743799803945,&
        1.7918559253096071,-0.50773355205898829,1.9405017665146072,-0.24060187904300273,&
        1.8915861270407628,0.49106386747929548,0.42974594200493560,0.28048590335094736,&
        -0.17897760817561784,-0.91649328268881392,0.52447524176178162,-0.25020424312205164,&
        1.9805174095779265,-1.6459122767733818,-1.1066299689419150,0.84808145525218470,&
        0.84056033485499593,-0.79624194250434843,0.60379124417565833,-0.27070309022945949,&
        -1.6444686835403202,0.28346111599430768,0.98469945008360604,-1.3046763910603241,&
        -0.52104371173968911,0.97287210278834424,1.6551196514573912,-1.0459150263164816,&
        4.0132312516697563E-002,2.0304969842058367,-0.35125594044347108,0.11687664409026736,&
        -0.56419078513716447,-1.9598070761435653,-1.2380969040107657,-1.0900375459996772,&
        -1.0172864607008780,-1.8380249608351906,0.16605114501366677,1.0665361903852688,&
        -0.55420790380954466,0.36037261239966739,-1.2880615089511063,-0.45519834085559452,&
        -0.24756576708017786,1.9400773732527907,-0.41886691530133707,-0.56353441333080989,&
        0.17073227007691055,2.2600707567700788,0.29834165531756762,0.74798197914475928,&
        -0.68796680045353897,-1.5681083137550436,1.7003206655885121,7.1832517974018215E-003,&
        0.87912545776861684,-1.1930684704796253,1.3615115137393028,0.31077786354803255,&
        -0.17759794782572061,0.56279213563658648,-2.1334355921290364,0.34383997625374862,&
        0.69766722788390301,-0.48900133783742478,-0.86724827239918378,0.17914763274416931,&
        8.6594369206420014E-003,-1.9708714918886141,0.81963637688442015,-0.43141804035419817,&
        -1.0476964586591169,1.0567433869093137,-0.35438760326827667,-0.68378181935954285,&
        -0.43801863348477171,0.40383623609750913,-0.70559536005356194,1.0468362399791111,&
        -0.79769408157719746,0.71901171704919264,-0.43396579896377674,1.2477073730439514,&
        1.3854525334475722,0.16487729610915833,-0.23688210420937839,0.72519343939479819,&
        0.54827419457216287,0.21590474006695023,-0.50952331990203348,-0.42597850653381258,&
        0.48171142499409159,0.97694999476441902,9.1074254153282894E-002,0.51211282156695914,&
        1.1670668153641137,0.49103040491714856,-0.99501070890856080,1.2540776225248712E-002,&
        -1.2629493879459117,0.41978999055385019,-7.9955920648050266E-002,7.3722565962328025E-003,&
        -1.1661504927134787,0.70718287748203712,1.6945215089301878E-002,0.59608267312617258,&
        -0.34940899970706146,-0.69322358409474039,1.1373307905143215,-2.3496000936103134,&
        1.0331754685813690,1.6906461060318665,0.37376066347532860,0.54934503360506060,&
        0.49778767876210500,-0.70457458090707337,-1.3194327233860008,0.60780274786526789,&
        -1.1999447596379029,0.44046837638597219,1.5356972917504708,-1.5750185275849453,&
        0.17003687000804574,-1.1016640510866662,0.13196257541625320,-0.93399698582594293,&
        0.27941003251842034,-2.0570520124719947,-0.96936419601102453,1.0358779271675362,&
        4.7359930061850122,-6.3588347329607371E-003,-0.69640766087476658,-1.0379059612311003/

        DATA MC12/0.27361076549895796,-1.2448659763318988,-1.8073571210693864,-0.41364878741474520,&
        -0.93877609372580406,-4.7853059578075376E-002,-0.27968593777200174,-0.56880910556029640,&
        1.1498651810466238,-1.3409580154207044,0.77929486218785293,-2.4490383467746701,&
        1.0563333093635374,1.9579286450140014,9.4495139313297449E-002,-0.78605068712723081,&
        0.83520154802107338,1.2620017540910680,1.7294184028446380,-1.0825348385970415,&
        -2.0505168183448199,-4.8219389244819479E-002,1.5366672623671065,0.65190018678173500,&
        -0.19017350441880240,-0.12570558110566360,-0.68293652535163862,-0.17639004734214334,&
        0.70002218224749979,-0.51135982710995709,1.1530587196290476,0.67741794468137329,&
        0.80847291555201484,-1.4154092590723073,1.8956934599730901,1.1547091598009458,&
        8.3893441676186759E-002,-0.35686188666729868,4.1866518867857042E-002,1.0709727093103876,&
        1.2019326972339393,0.15457420672743510,0.88535863342224697,0.10440246248555758,&
        -0.37043718238271539,1.2258937721411571,-0.30412723209461812,0.43573915311561695,&
        -0.22049871051971051,-1.7310878309284536,-0.24576743373182766,0.45082239843921601,&
        1.8800378793633783,-0.92959029303064100,-0.38378767307871098,-1.2065264045903963,&
        -0.89862855589922996,1.7275789900990213E-002,-1.2634186672293153,1.6420853901048720,&
        -0.60995538993956733,0.31301789783254058,0.45158382973198080,0.16006349275718879,&
        -0.76074711119001936,0.97382006887301875,-1.1709187249264241,-1.7182092568817262,&
        0.25660364051923229,-7.0838414664039159E-002,-0.64231104509609771,-2.1650416284770406,&
        0.76451565831696822,0.31220860634139147,5.1996974290931468E-002,1.8835527191456876,&
        -4.4257266023406260E-002,-1.0101268069623817,0.91508158038505738,1.7356256789406312,&
        -1.6555810878415594E-002,1.6230581319634378,-0.92014369859808498,-0.49284283026937281,&
        0.82127945610476216,-0.26132192735996229,1.1350762765036702,6.2159462356400769E-002,&
        -0.42228987170373883,-9.2781560544911656E-002,1.0680789836025821,-0.39235267793880807,&
        0.34350890538430395,-0.59738221593709773,0.57676784315210350,-1.3653336994870418,&
        -2.2029867281805533,0.74928198920614164,0.62862866804802386,-1.8576672287741751,&
        -0.70855773231706065,5.3133195911453913E-002,-1.3864477603574938,-0.52670399407074797,&
        -5.9840739348086293E-002,-0.23284801902599500,0.55942351576861993,-1.0153503813422966,&
        -0.32370931956008675,-1.4127740784141176,0.14322053293313225,-2.0026200674531869,&
        -0.33175004035314354,0.45960465574822967,1.9113908709225642,0.55311145287737251,&
        0.84254877032982722,0.84966785924057486,1.5304729620000486E-002,-3.1581597314748772E-002,&
        0.53107109988695611,-1.6012304254378069,-1.2314416291642252,0.88428994789820881,&
        0.45290861356197915,0.69146901397808114,-0.45928264949756803,-0.26115839297928700,&
        -0.26425917662178411,-0.66046332138790664,-1.6964490507892316,0.34702828744442599,&
        0.71298678717228670,0.73028206610182078,-0.89303810910355275,0.48195449767041687,&
        -1.6193683950167872,-0.15016717189254769,-1.1990259563596322,0.19583258322138378,&
        -0.69335710372670878,2.4154640897685860,1.1987410661830331,-0.60768252248076204,&
        -0.61467207698198578,-0.49903114641570351,-0.89815183213132577,-0.87080397608576199,&
        -0.41162257636998212,-0.88630441176636843,-1.8869365353021172,0.93965913178876903,&
        -1.0027973217349717,1.3912068399565682,-0.16831463954595263,-0.34275329973664931,&
        -0.51507452946301802,0.24124716385797668,-0.23402427081810809,0.33701986990221644,&
        0.38081767011485523,-2.0929124392660361,-0.20833651919622320,0.98734910638180506,&
        -0.58556132116349868,1.6604959951682876,0.93104546478684913,-0.48485081868209223,&
        0.50819337915092333,-0.60267379637011964,-1.0054356986841901,0.47308958536329443,&
        -0.81758906352174143,1.0634622807859810,1.0597468790212636,1.8716413467308113,&
        0.18082607659171623,-3.0488625216830032,-1.4364077896835887,2.4094254520056793,&
        1.5538067099065653,-0.26658691785734251,-1.2821604041216161,-1.1020732473058268,&
        -1.1274727681864092,-0.72899594850925375,-0.37321130809153413,-0.44628366673300318,&
        0.11935130392986193,4.0861450833061926E-002,0.66941809991404599,0.38814018683443441,&
        5.7245806137475777E-002,0.36571449276338480,0.16967333492622846,1.7289462018760933,&
        -1.8517547264117500,-0.87984581983061261,1.6907352811235297,-9.1671866124649920E-002,&
        -0.88863199206198429,-0.46972741819582065,0.54700849519858918,-0.85008479818515614,&
        -2.1038550631931967,2.1911711114552013,-0.66368780900254287,-0.83615577576943412,&
        -0.89614662192087080,-1.1563906972936484,1.5841571490288051,-0.54261792390334840,&
        -0.79777081238609504,1.0057930757117375,1.0516992577016955,1.2241201124922525,&
        -0.36752188883117465,-2.0733235969548494,3.5990556491519193E-002,4.8123690959195525E-002,&
        -1.6206373439409969,-1.4237297527738277,0.54126158094069043,2.0647734978198771,&
        0.83336128031584955,-1.8729467530171782,1.8320361974954154,-1.2058338624574885,&
        -0.40506664760285283,0.45691899717799317,0.10794822991821390,-0.43553072290794564,&
        -2.9072282483529463E-003,-0.53515668673512196,0.69329301927842346,0.28637848217475598,&
        -1.3501144096383833,-0.21775506456201926,0.57915180572905112,0.18811857911402194,&
        0.69332115492871438,0.13770276303058246,-2.4026362204398219E-003,-0.48787828758750584,&
        -1.6285393933534176,1.6232775423592820,-1.0060946111463349,0.14358864384813927,&
        -0.46527239466727344,0.34788076098624476,-1.2907136693292758,0.85124020141653856,&
        -0.22813347007845536,-0.55781928739842324,-2.3924708073739597E-002,-1.9213424625710465,&
        0.81946900732896610,0.45714803737085014,1.4867954918854147,0.97228157589525488,&
        0.12978203825409665,0.83438820688727788,-0.78602498411898736,0.18393962196491442,&
        -0.15961231382742436,0.19264250223315521,-2.0886503731988291,-1.5990402105518857,&
        0.25327526082576618,0.72001769432467100,0.57463734072616446,0.49021879230886906,&
        -7.4054530386624240E-002,-5.2042343597759493E-002,0.30476186322234999,-0.64038416501902451,&
        0.69594437138704424,2.4570266730715615,-1.1758808530219236,7.7763627812019953E-002,&
        0.45465431240750409,-0.62794179405553585,0.92469715911465533,2.3938529121483949,&
        1.8524010878187165,1.9636690964130725,0.40000066942964546,-0.12552367582089538,&
        -0.68693981685490368,1.7096233525037834,0.77480514353022056,-0.11831521422138670,&
        -0.24435428180924848,-1.3889010281118366,9.2931457138671125E-002,0.52365962814173750,&
        3.1416015417275740E-002,0.21674249588845051,2.6843189611042506,-1.1829053128541582,&
        -0.31677608541818231,-0.72785225389535846,2.5161067702430547E-002,0.58331589622319679,&
        -0.45557628255898547,-0.46741612342640099,-0.49120698178876315,-0.90362055529096064,&
        0.34063747450024634,0.42187405017521262,-0.17475411779389777,-0.25072955959193666,&
        7.9496602892069699E-003,-5.6370657791707468E-002,-0.78786407396153391,-1.3368662085399945,&
        -1.8453099563286328,0.80201075657713605,-0.56235139579069415,1.2428336708468759,&
        -0.48537884313600471,-0.82722155380390794,-1.5737344950747905,-0.79086259772765788,&
        3.8249479140908975E-002,-6.9788905590676450E-002,1.2968900720675476,-0.49638711685922399,&
        -9.5149274011461383E-003,-0.33315948771673887,-0.66835723656998036,-0.31579457844133413,&
        1.0205497759775191,-0.43183625224559563,1.6720279761859769,-0.67224352229063356,&
        7.4401757835499627E-002,-0.79909130543006501,-0.72169014011327848,0.50664734164485914,&
        -0.16489408476549905,-1.3855611950781983,0.98575508285536440,1.7672223419330018,&
        0.20046792504451685,-0.89742463526743343,7.0129238708771691E-002,-1.0522266124617925,&
        -0.19415163100295812,-0.99762815533302340,1.0652590392555017,-2.4691107572938606,&
        1.5624261556941208,-1.0274045422117288,1.0026363493215456,-1.3873748756980286,&
        1.6941125541083366,0.88701270713328884,0.52787969945388491,0.18147177366363670,&
        -0.43428293622491415,-0.70289392324855171,-1.8180602759038229,1.2592123439603964,&
        -0.67830127552566000,-3.0188363522032236E-002,-0.47299833326408214,-1.0172072909460077,&
        6.5888081419630914E-002,1.5866257841892586,-0.75902091532767513,1.4080068404751651,&
        0.92637237728210586,1.8600828236040081,1.5851428906056493,-2.0992143214201837,&
        8.5574032025974966E-002,-0.73916236958396331,-1.4329515618625190,0.85974526475799462,&
        0.99512304487966308,0.37643381721401725,0.76929459305407777,1.0957371968616150,&
        -0.82431956192334832,0.46721381519104971,1.9322143510633250,-2.6244288663293558,&
        0.58992479896254812,-0.98675711620146445,-1.1740402223895274,9.4091554398353330E-002,&
        2.8357533244103485E-002,-0.53100553336481293,-1.0536726866709654,0.81481593364474258,&
        0.11961514503954922,-0.83816158537538943,-0.49711302723473721,-0.75157479881376155,&
        -0.81426107959635496,-0.86497452068845382,0.20942515328986069,0.66115476959286390,&
        -1.3855973022332013,0.21426453752696789,0.35320220493613030,0.69025111240157211,&
        -0.59577861786899700,-0.26196275194126301,-0.38549190192294819,-1.2639107073178093,&
        -1.4811377872052121,-0.16683903898124219,-1.2520624639976177,-0.57571511940248943,&
        -0.95740505646126606,-0.72907587078522251,-0.42408931587449705,-0.93086845981042765,&
        0.33251567512060715,-0.28541969902105585,0.89818641300796587,-0.32884809157746947,&
        -0.36277106605317883,0.35394032779391343,0.29052600094726910,-0.20373494523543392,&
        1.4948184280409518,-7.4161047455497522E-002,-2.2527148302758295,0.69772055575453451,&
        1.1236599005489867,0.46275992648592668,-1.3009461314940529,-7.0153556184038693E-002,&
        0.60002978432841059,-0.81473896384717126,2.7270567809911089E-002,1.5357274974480088,&
        1.7527323479523353,-1.0532150494775836,1.0230165231091353,-0.60777725781246450,&
        -0.96685410309300945,0.23078916525728782,0.21059958313399527,0.15721834741890472,&
        0.23023832052891360,-0.37574576294795664,-0.15496236953378720,4.4416188519707925E-002,&
        2.6888450460456719E-002,0.13087281168917736,-0.28362514505988407,-0.88636153407188623,&
        -0.23206858249839168,-1.6490153317898786,-0.61281641757635175,-0.98449642647382096,&
        -0.59174970278824357,-0.36093152307268445,0.32545905195201857,-0.87501765071407633,&
        0.11877647698083693,-1.2557527416685086,0.38120641300589192,-0.58351905785061997,&
        -1.2747669496818397,3.6410646558364949E-002,0.26052397314492443,0.44667962107186238,&
        0.83865131965385376,-0.38378889760933915,-3.6542897111886706E-002,-2.8891712443785168E-002,&
        0.80734116470224104,-0.20750885307368086,-0.18619098641133383,-2.3646112941034083,&
        1.1758261670154868,0.73720113768638773,1.5837875800888872,-0.44858137412494398,&
        0.22667639872258316,-1.1016335803461803,1.4075237623106274,-0.29849246069143420,&
        0.94086730755448444,-1.1803106604009796,0.74499833574543006,1.3447018732498555,&
        1.5808280072975134,1.3693294794720465,-0.38204974605722192,0.53793434023222453,&
        1.1945614248017438,1.6638216226123996,0.48447944556904560,0.11420144844919143,&
        -1.7541430581890074,-0.19054610193513238,-0.70805580609247343,-1.1780673913741442,&
        -0.43063571532591982,-1.8572498840794858,-0.23454338354959203,-1.3451592798957370,&
        0.67100070506508935,-1.4880636128083726,-3.1398639696342823E-002,-9.2058026207983853E-002,&
        -0.76612611593799740,-0.15972754216765622,1.0341695782063507,-1.1803712881551807,&
        -0.10096204812082375,0.20232422643846129,0.13554642337263387,0.71832493754786342,&
        -0.23748091510535441,-1.6347497177667696,-6.5376590417107985E-002,-1.5415173178296957,&
        0.93688276749642407,0.33939711858536270,-1.1378188328163199,0.56921400435315539,&
        0.69112003702895164,1.1364880274865234,-2.4402757945508244,2.4110004170955643,&
        -1.4475369826171511,-1.8387066163031098,1.8521738461817707,0.43244726880572548,&
        -0.88103657667162338,-0.78171988871386078,-1.0098263967565273,-0.29614605497667623,&
        -0.24874159815792604,-1.4078490400803103,0.47293547333799146,-9.4739371380738430E-002,&
        1.0546608879252941,-0.99794454099550078,-8.1823093038023098E-002,0.73964099869577193,&
        -0.91618361097177592,0.98123637204456904,-0.38625887581370000,1.1893415173754822,&
        1.4875055528884988,-1.2567641408355470,0.84431103742030345,7.7743762194552424E-002,&
        0.73430775970382112,8.9157381967259544E-002,-0.18538501568985066,-4.4122195145290796E-002,&
        -0.25002357882448395,-0.41708967234885236,0.19852458388837019,1.9649301548687195,&
        1.3758012966255899,1.7833036274067196E-002,-0.14329744941417441,1.3256737538701782,&
        -0.25523905723854157,-1.0400286609728011,-0.97263926821898872,1.2611316833485193,&
        2.2448068691874949,-0.17301309174506144,0.71656536446925123,1.2332112231343950,&
        -1.3876162274732464,1.2622099628257297,-0.10575472628424719,0.76447156763697266,&
        -1.1179053439351208,7.2257041378104542E-002,0.27622260018354011,-1.9109192509456161,&
        -1.1011016106897700,5.7283789002991421E-002,0.27348791968468100,-0.49965075290580485,&
        1.0310840291538974,0.73109143265542920,-0.25207964020669382,-1.2048163652361359,&
        -0.77967246283655911,0.76096196754381840,-1.1912183004481625,0.26141696775629919,&
        1.9490770881884951,-5.4341995990679411E-002,-0.13020915500284197,0.44944211293723002,&
        -0.69443351230530559,2.6469274331567081,-0.12654878742019154,0.62743883799283251,&
        0.46674867732342279,1.2347679060741898,1.6101657646894894,0.83082723911502632,&
        -0.88105349363461183,-0.20383688567527602,0.35868121926023094,-1.8034309730094304,&
        1.8241806170474231,-2.0860492533623569,1.8733715041164190,0.92081141627815499,&
        -1.0177889992028502,-0.51154037811594055,8.9097953033017735E-002,0.17031803498726403,&
        -0.93035633410066776,0.25042571114624307,-0.93176320370966914,0.98887137613714660,&
        1.5485767532045538,-0.68320265783483702,-0.23779286306215724,0.52931612950207263,&
        -0.50183408452090406,-2.5046744905662253E-002,-2.7862268755665354,-0.25853102414262263,&
        -0.80176358867702069,0.39737176390006013,-0.10089242705489634,-0.49858574472601247,&
        -0.98333214493917753,1.3062147111093121,-0.27142085635367702,-0.79257907737135136,&
        -0.74865122339906542,-0.69334003438846115,-1.6426098339730857,0.76083056389806814,&
        -0.39154008374342059,0.36486924769651236,0.16662308895994404,0.16862702338290100,&
        0.16487986777240946,2.3501207291358566,-0.14247446842197495,-2.4979971745577179,&
        -1.8537017203557795,0.37085282254255353,0.60027881123107685,0.52717503564636248,&
        -0.27925520328010817,-0.21537112804139444,-0.69133886920467524,-0.75405752063480969,&
        -0.17082212439108441,-1.3944014981698440,-1.1577483462391778,0.59204682138779352,&
        -1.1200104785711156,-0.79643137557686194,0.37243333526631711,-0.47505373985352056,&
        1.5811388507417869,0.98429620733259604,-1.3921838124143147,-1.2756106184686347,&
        -0.65133110952587325,2.0988735769886504,-0.50058448469521422,-0.92663682722872398,&
        -1.0381220434736698,0.11623120700396890,-0.96442078304219325,0.39538602526200400,&
        0.71704899125302834,-0.17366780838466336,2.2624483666851582E-003,-0.95480146391286436,&
        0.21255267276251111,-0.17282312560050475,-1.3173880650709104,-2.9089999401221385,&
        -0.15292534087257847,0.35156754984368777,0.72646471989150108,0.89685486496731370,&
        0.59519774484265531,0.73309361873448575,3.3832097083908344E-002,-0.13938331008198107,&
        2.1719077560692268,-0.34696526938582656,0.44631415862635027,-0.34746298474526988,&
        0.92767486586434023,-0.16152540475535887,-1.3157059513564324,-4.1134110043330133E-002,&
        -5.6214310719034211E-002,-1.4713629552578449,-1.2431984516364865,0.63494967672380043,&
        0.68050164510967182,-1.0023305844002188,0.59808957996500223,0.36080097272991418,&
        0.98068159262839549,1.8077707701524210,-1.4582349450816035,1.0554843741852842,&
        1.7421763667939034,-0.21388026244783567,0.67006925055671418,-0.75261874268401197,&
        -1.0299938248190348,0.22586919618378415,-0.68207803289462443,-0.60119573314984387,&
        0.88816029322471846,-1.5771078961790477,-0.28367510328465884,1.5220731005456554,&
        0.14803815729091177,0.63052412947309822,1.7941301418666713,0.60191516197969286,&
        -0.85859184086692797,-0.29958483854533802,0.16783440263707114,-0.24065028887465045,&
        -0.75543314919457882,0.16309092447785614,0.55833485301710273,2.1418080905799219,&
        3.4618263081269358,0.54286066031863989,-2.2303370445652329,0.11538996187013370,&
        0.86091816201884952,-4.2432609542204701E-002,1.5058680524981711E-002,-1.6563426986422449,&
        6.1883735815347854E-002,5.3376043932304391E-002,-1.1368415988156073,1.2246479984036229,&
        -0.85798185874200228,1.4522251588223212,-0.94872270221438715,0.97037867568139780,&
        0.97310817153534113,0.95567270214817657,0.96455233323175982,-0.59858431213938768,&
        1.0414434036958673,0.68048493564840162,0.32494485112571742,-1.5514666641227171,&
        0.48191326471258877,-0.38768911487138136,0.31670782240206241,-0.66292802384708327,&
        -0.56492689511119509,1.0180969098329784,-0.78567674451573966,0.67217933887902592,&
        -0.74655092066638384,0.60586698491532842,0.37960805519971846,0.90370176759671950,&
        -0.43780099795739608,1.0739815492932749,0.59411526160596051,0.14471532165312512,&
        -1.6677538705798061,1.3011016923309087,0.41812855125679405,1.3720457870507670,&
        0.84676482870065750,-1.9923170178643317,-0.49144728699823748,-1.6173849278901049,&
        -0.28732050521953378,0.24325822204175485,-0.61686605029672292,6.1955997202059621E-003,&
        -0.47107499048138918,-0.80096759957907471,0.40493631815894005,0.57657416126086503,&
        5.5043290122858517E-002,-0.32077743406488896,0.20994291808900190,6.4517056395793804E-002,&
        -1.6195696571090821,7.8532208397784561E-002,0.56926046990667611,1.4411358353883557,&
        -1.0989729019244128,-0.59672492454232673,2.6261565233249820,0.49392541873940654,&
        0.55957839925315500,1.0408834256048778,5.8193841962472993E-002,1.1073791202258789,&
        0.30672169396847254,0.45733234794821692,0.36187039263975485,-0.81627410016337776,&
        1.0676304338695641,0.56389444127523825,0.37692124471199728,1.2924619903257697,&
        9.1537505681874048E-002,0.96680829339155916,0.92585695580436955,-0.41369536793933831,&
        0.62327583269470899,0.27237501452674351,-1.7793308906713197,1.5453719673531958,&
        1.5382620279732671,-0.12404131874728049,-1.3813493835826440,-1.3064274790228834,&
        -0.62774480891728368,-1.4273963911389593,2.3143760665900772,-0.76159304809281092,&
        8.4715383027349031E-002,1.0118941606088951,0.61877437173676297,1.2754371248723235,&
        0.36389465337574506,1.2032519272083178,0.62323347091693682,1.1947252588684982,&
        0.41129251052771149,-0.90526973101781771,0.64270752413086163,1.8489586628762738,&
        -0.87545158197407658,-0.62745045689321499,-1.2798932814581829,-0.72997515707835525,&
        -0.79952595299557838,-0.18200460743054742,0.83817381845739158,-0.36953390647674927,&
        -1.1973496905835479,-0.16443113229770051,-0.79319680479346266,-3.4051223852832789E-002,&
        -0.92524569881922869,-0.72032158901342935,1.4240177973846220,0.75420679984640804,&
        1.4739710002941946,-0.14880335560506369,0.12675547250980893,-0.68370675540354597,&
        -0.37714375618988444,8.8703133011469718E-002,-0.75826909186189084,1.9569012192097430,&
        -0.87919225891365405,1.6543452217846604,-0.12044097259586610,0.65029628327603040,&
        0.83922126124702046,-2.9024378056225077,0.13888550630635049,1.7694465507932373,&
        -2.4047979178203600,-0.34760496194602242,8.9742324152388628E-003,-0.10686456632126108,&
        0.68159533372734726,0.37630627608164346,1.8707468250091646,-1.6910348612292532,&
        -1.1967000204792255,4.2993633793074297E-003,7.5774447757502597E-002,-0.20032083555028751,&
        0.21876865702944848,-1.1242846415805623,-4.6357783038321949E-002,-0.67712805832624900,&
        8.8588418331312618E-002,-1.7356099960606084,1.0035655839973074,0.90986484070729645,&
        -0.73502534733715652,-0.41255986625463309,0.35283309829095261,1.6706422054834422,&
        -0.34648884203018682,-0.42682092044593634,-1.9933648183213991E-002,-0.30437723280416035,&
        -0.65153224791271980,-0.97894692115845883,-0.23562188790212421,0.62592676223271115,&
        1.5355655371708434,-0.37916511049177648,-0.19743104684065238,-1.5502165349761208,&
        1.5429306026921754,-7.0587103130497819E-002,-1.5416174569798606,6.5402943554982745E-002,&
        1.1227254211900011,2.0700954851893036,8.1577273175237316E-002,-0.83693760258944083,&
        -4.9267149513265510E-002,-0.58087606722519780,-0.65048067919787922,-0.78924150751099409,&
        -1.1710340201800806,-0.42179971247174247,1.5719159617249205,-1.5692300875509044,&
        -0.33988225716888809,0.11464630518207605,-2.4160004913621989,-0.43854680674834962,&
        -1.1990151025355797,1.6652572550169606,-0.10301426897329811,0.73289586742181601,&
        -0.43069345093554889,-1.2052364642385702,-0.41113044607993576,0.16609100947570546,&
        -0.95771065041794445,0.10930938108758091,-1.3006035246599490,1.2095651750783480,&
        1.3989231970491789,-0.21837112400134870,5.5694412841489391E-002,-0.34878585441394555,&
        0.75498599526885335,0.83540628881602252,-3.5508282721067139E-002,-0.66821672766875539,&
        0.24012545055437415,-0.65616170421301323,0.91693691313065728,0.39295463678681708,&
        2.1443296711610773,1.0428441421008379,-1.6806055305226963,-0.82164092288939583,&
        -0.92344251538577005,-1.6386451047111383,0.42028007592770150,0.93453046973738907,&
        0.50514685138899873,-1.5909543833481790,0.17631820986578400,0.15965095807912405,&
        0.69003419691640433,-0.61762093773260984,1.1431504151622063,0.49050630868045503,&
        -0.19030932299060374,5.3171424408420022E-002,0.15939634610310491,-0.73197848224063244,&
        -1.8922936569440183,-0.70315269787538259,-0.30128141527526131,-1.6843573620160341,&
        1.9823339697283815,-0.10995432281995719,-0.16470339569036296,-1.5181882114810901,&
        -0.57798885186124949,-0.30683399467201716,0.92462024720459179,-0.54672005222668008,&
        0.20514975600517840,-0.46342891112584189,-0.23619164863789824,-0.92455111484974462,&
        -2.3694986628096664,-1.1219703289690248,0.87159099116198924,-1.3313314334579842/

        DATA MC13/0.45762605850701293,0.43018668224978324,-0.94421670793484136,0.67538606696819614,&
        1.4661229693329121,0.39702158391448295,1.2693793089394261,0.49238514664550564,&
        0.38217235849807768,0.96789199606668308,-0.16697324555283199,0.25812346222079191,&
        0.77826224994505977,1.1684179638241967,0.38881610395224736,-0.49071707793866809,&
        -1.2474312472110420,1.6886597308076132,-1.6635306325525956,0.93979733147993516,&
        0.31259534795093186,-0.29908853345156378,1.1462198905775962,-0.13143065921229802,&
        -0.94201977431016648,1.1370045531307877,0.62805899338296045,1.1003613391228517,&
        -0.71064295215445683,-7.4400427565122537E-002,-0.75222944914073819,1.4995962760572712,&
        0.77819390161909652,-0.47371062853445811,-0.50732772707395024,1.0158325941143052,&
        0.86101139949837113,-0.43431862617872757,1.2169801560825291,-0.41976485262359570,&
        0.35041485612039275,6.1177462366006748E-002,-0.40530214826668287,-1.8912309834229324,&
        0.36349409389152337,0.50758298526525558,1.4191771426428255,-0.59107306883966537,&
        0.78732033045712269,0.99527385102498400,0.89868188703827323,0.15830850302885466,&
        -0.68626712133308609,1.4978117738031023,0.17613336312721406,0.12730806137929684,&
        -1.0419276990920912,0.95723486997920981,4.6667539715087150E-002,0.36688806039930583,&
        0.10932085021537741,-1.8482251780483896,-9.1315219187245347E-002,1.6162193793599160,&
        -1.2193203596764000,-1.4310015807834056,-0.84180615035184814,-2.0221668371666959,&
        -0.52776523514108786,-5.1980701636541712E-002,1.0784940259989806,-0.66542607236318740,&
        -0.26612790550969978,-3.7940468545735219E-002,-0.38885373994878070,0.86144176811956397,&
        0.36622470616537450,-0.11283264786121944,-0.73716216743995944,-0.63247495936132048,&
        -0.85913569951238167,0.22812101298708168,0.92826557937326226,-1.1376325090610617,&
        1.8054002349189997,-4.7653997243221898E-002,0.59000225570356524,-0.47242497204459721,&
        -0.32247302530376004,1.1017050198867859,0.40366406362636159,-1.8144279082934116,&
        0.33595523944988565,1.0956949852109188,0.29396346069166651,0.25927162203658910,&
        0.71221817516399644,1.0573774607866533,0.34785581516722353,-0.96863632769194929,&
        0.51769417247885396,-1.1156383207347476,1.2237446603395044,1.4877058372840046,&
        -1.5627689324459086,1.1875733294170872,1.0961664559605500,-1.0099335427821003,&
        -2.2740647588337857,-1.3141104100722585,-0.45189161106196674,-1.6381127770763360,&
        0.61540440011616004,-0.66488170929264956,-1.0687745223057281,-0.49092885237151385,&
        0.20955857222991542,-0.53264685530663602,0.93300836970749490,0.22488772698956180,&
        -0.60686462746599201,-0.50417967543579556,1.4216259358800163,1.6487184097637264,&
        1.3694582948147285,-2.0587820171802313,-0.99127865641187685,-0.28852647588847463,&
        -1.0391606619205602,0.40098871925071566,1.2379756766823866,0.28515462552749954,&
        1.0229348785053392,1.0725635592324203,0.22928747728892523,-0.32633816895973483,&
        -1.0201006051288157,-0.96067960997207480,-0.71711985308411752,1.3006319739098002,&
        2.1652039031003945,-0.31187370911020529,0.12861639926791810,-1.0291548320149948,&
        0.22373044217476040,0.86836225933684930,-0.70636878773040179,1.2247541552004872,&
        -1.2587164198112051E-002,-0.40882742970208236,-0.64161818864185682,-1.2712334398483640,&
        -1.9855960823606427,-0.93973507804929057,-0.60985063503893266,-0.44992772491831051,&
        1.4681246304167288,-1.3904228143204700,0.63520941026272171,-0.37837593500256156,&
        0.35253893358510041,1.5362660256612908,1.2327993520659661,-0.30195230321793903,&
        -1.1551207692694325,1.0723947947272898,-0.93826531020668202,1.7550490600224256,&
        -1.4717204568528479,0.65181152751630500,-1.3059206619785724,0.28513039468812840,&
        -0.74656291368188532,0.48504701842908549,0.31476605780179023,-0.43953467207478203,&
        0.70586508397480774,0.86369832981567563,-0.53519633239472375,-0.70569732949663178,&
        0.12921609285172506,-2.0321426595077567,-0.99394417520541889,0.47092830891503468,&
        -0.66471213671333473,-1.9022549364140675,-1.5504256860774997E-002,-1.0533253074906395,&
        0.58186692667789297,-1.0814583664321147,-1.1631025140279065,0.61740634829365348,&
        2.4505347257826813,0.70128503218519112,0.66409708724854211,-0.90292479879344212,&
        1.7188369674819854,-1.0676601193003290,1.6657156220873310,0.91796101313094203,&
        -2.2046355852614583E-002,-0.10522663721697181,-1.2577870879105033,-0.71155075659791411,&
        9.4623948883847786E-002,0.90968055668569936,-0.74018164432375066,-1.1871551334383010,&
        6.6331347838189295E-002,-9.0706909111436876E-002,1.0513045797839065,0.40797485468960731,&
        0.31437808650835014,-0.75980048103681208,-0.52577095087427850,-2.2906195335675599,&
        0.68499426617953840,-1.4854623491018766,0.23127570229027153,-1.3350261372186962,&
        -1.3749666427007472,-2.2064208020805588E-002,0.51637638602152347,0.20696548737147460,&
        1.7399250254084666,-1.0523558335662853,-3.9764869269529143E-002,9.2495226608831443E-002,&
        0.74573060930813928,0.71451348941409853,0.53484332118103584,-2.2408003684911999,&
        -0.29006267389024160,0.99859250282728007,-0.98342940765653697,-0.71132196706394990,&
        1.3043944602531798,-1.0426321649420620,-0.23408560614903789,0.72103430958755332,&
        -0.37577508207937915,0.20744563632990931,-1.1345653212301312,-0.45663795914602218,&
        0.64077263243354998,1.7725485075278815,1.8901705086057270,0.33700995846074910,&
        0.11198482302491485,-0.94470926089739760,2.3216437793037437,1.1169983131328451,&
        0.84029898733490849,-0.63953545224712982,-0.26441991717817798,0.48296118241092756,&
        1.9965197012480351,-0.28536497161283148,-2.3369957094662031,0.31716285261724553,&
        0.81482237194626872,-0.58265090193980029,-1.2685279088258226,-0.23286047083901934,&
        0.95693104373470106,0.73100115568596091,-0.42542445268677093,-0.84584770399264875,&
        -1.7029957184663942,0.52428800670726794,0.39051800805124903,-0.18440823620635888,&
        -1.0083678643485638,0.53170007216345561,0.16880760727559216,-0.43528668125691816,&
        0.59999184641685144,0.65298826606860172,1.4326686518478748,1.8252567702077194,&
        -2.6406963329895061E-002,-1.1697671786021859,0.25138794903047018,-7.5263032486262260E-002,&
        0.31938756234722249,1.7155790421443231,-0.64559799167712550,-1.0847405172186724,&
        1.0054234014100032,-0.22132012035944712,-1.6146457989319905,1.2866161531356199,&
        1.8304734221639134,2.2920799860964616,-0.10385584001096795,6.3705143801066330E-002,&
        1.7164837198047809,-1.4610865549506964,1.1280569619667389E-002,1.1592748408501088,&
        1.4652551117934567,0.92351110071330456,-0.78126766997479657,0.10829660165552132,&
        -1.2960261515560361,-3.1658664912105117E-002,-0.10055898732603409,1.7757752905327291,&
        1.6546597883114693,0.22527742309590501,-1.7877542298018334,1.1190219025135806,&
        -0.66785780171543496,-1.6719623867156170,0.36900567040071308,-1.9925579921696350,&
        -0.30490724913316436,-1.0607335644920319,-0.24556733873654635,0.80855826295082767,&
        0.24075301018092582,0.88760917598945455,-0.70376890007791082,0.85443176936582765,&
        -0.31301057081496941,0.92228355855110822,1.7198565019323275,4.1670676725852465E-002,&
        -0.18783304011689975,-0.32604076046288905,-0.92519216832477913,-0.36468216496452410,&
        -0.45379032687966203,-0.94676464639706392,0.43192938234996664,-2.5294698280163404E-002,&
        0.47554981028467852,-0.73602613905469683,0.67415726449821078,-1.8792786817953946,&
        0.66429275165648571,0.51364256012672183,0.61453165952008160,-0.34773925713235510,&
        -0.10602905967833552,0.79284410606704092,-0.77311072364879130,1.5293821704147510,&
        0.76635882779429754,0.12172717789906312,-0.43105967620148433,-0.48395702960247849,&
        -0.34127783713652143,0.86307197320783124,0.40991432751019857,-1.3497575484035154,&
        -0.43440149952677565,-2.0708924409485170,-0.29058188443347516,-0.16291439513139885,&
        -0.83839339736419194,0.34611298606505353,1.0183087129324788,0.76381389269409372,&
        -1.1398591212013696,-0.69394429703287064,1.2327328068135199,0.70653405081308185,&
        0.76231720979672168,-1.5876052709626225,-0.24339145124606629,-0.47475338553232871,&
        -0.73498491861992732,1.5775264445834836,0.39263921209500385,0.97714369657996214,&
        1.1823900750611416,0.74616511099439731,0.99597689492477470,0.53734896098649343,&
        -2.2227066457810629,0.57856354900918694,-1.4446496856765763,0.27345513553690087,&
        -1.1125869279582168,-1.0160976317679267,-0.61022894474188583,3.3773254922604634E-002,&
        0.91745346537930783,0.33297454752466538,-0.29276637573553721,-1.2252651713686287,&
        -0.34434649536877066,2.1885186072312193,0.82278959834178100,-0.18934504856166454,&
        -0.38314085641353263,1.8945766356368745,0.51109579249183035,-0.45418449041735370,&
        0.88409450546845658,-0.48204380434998012,0.60083229226140566,-1.7000401793522133,&
        -8.4141301047387807E-003,0.17085314838369342,0.52460608393368235,0.29680250213965348,&
        1.0592488650933791,1.7637372216539788,-0.92904139681531805,-1.0336391467022148,&
        1.9515682691674416,1.4377111987097815,0.76639559313269501,-1.7244472171855347,&
        0.59977446794092648,-7.3944438968130410E-002,0.20021239413763578,1.1634224902814438,&
        0.41259092558663130,1.1691426306847579,-0.62934090896081352,3.0696455043970058E-002,&
        -0.49807426285152445,0.40482158995153616,0.52972420711916457,-0.28941395539193537,&
        -6.3941702109956257E-003,0.59139281988265813,-9.1208347208816577E-003,0.37752326342754777,&
        0.60726754904888403,6.5746628702118642E-002,1.5127517345663068,-1.4832024413104503,&
        0.51389232193198742,-0.69515663942486128,2.1205389468246345,-0.71626520698442864,&
        0.59878084272418397,-0.99643949087575057,-2.4693707066954071,0.67191949282374630,&
        0.87035697960992653,-1.2236644041822438,-0.51433517584192445,0.69374522095945990,&
        0.84646045640787060,-0.37392647587819178,0.81162059724947200,0.49054493664738563,&
        -0.39240540316293832,0.23447972591696073,5.6646482598016024E-002,0.84649084527147311,&
        -0.54297413344494139,1.8073063253998383,0.85050105402043230,1.3673520531526258,&
        0.48886279623527229,2.6759532207133336,0.81061994650998792,0.38649188650261590,&
        -0.23373588236790435,-8.9687088478410421E-002,-0.58786302300384230,-0.29336129487198187,&
        -0.59941321199540609,-1.8460691989848967,-1.0796169787996872,-1.1751095137606746,&
        -1.2036031346170857,0.91700198060649696,0.82144805841218371,-0.43266182855172947,&
        0.71474516031828483,-1.1666242220349561,-0.33601058313597476,1.5100717184882166,&
        1.5276374561959665,0.99547068405561789,-1.3370743648463774,-0.55469701470714705,&
        -0.89929375123296706,-0.64362964764979402,-0.16195342011888877,-1.0616804901377068,&
        3.2868015984532470E-002,-0.26976046003191972,-0.76543312719961631,1.4862869134360306,&
        1.1072852361958727,0.15058685753746173,-1.2190538013044174,0.36081238938857157,&
        1.7028512367914594E-002,-1.6445790086745549,-0.35453126116894729,0.41337927297663690,&
        0.57549781838184677,-1.0379580879095014,0.17390330030931941,2.2776830106096710,&
        0.19622234691681961,-1.9674985372082310,-0.49113293481530035,-1.6132995216681547,&
        -0.30453594996623085,-0.84327420254324204,0.10598722533305498,0.12569969576371562,&
        0.97089201429729877,-1.0134421469463786,0.15758081008083705,7.9133428728191152E-002,&
        -0.66341780561386332,0.38330406123077448,2.7037117888773370E-002,-0.79522458597043666,&
        1.2975643643225452,-0.25738364974350336,-1.0505274931948565,1.3638101378019445,&
        1.4148787588264380,-1.7916095627240898,-0.19310543396202781,-0.17413070047584017,&
        -2.2331930695673101,1.0805122078887275,-1.6800430088491738,-1.2649676257802687,&
        -0.97341773874650228,-6.9055414111079258E-003,-0.85795696829270829,-2.5873476404006004,&
        -0.28885932340073367,0.65554858916025072,-0.84181768144508662,2.1164361186293790,&
        0.31370726248495617,0.16187194699264440,-0.86900786962995336,2.6513250133103488,&
        -0.16083544124426377,-2.0308175187137696,-1.4809556783569549,-1.2059678266667131,&
        0.24046044739158537,-1.1105851160792690,-6.1994703343757604E-002,0.32648305092330066,&
        -0.67658880301116253,0.39819688370928513,-0.33142993053496139,1.3766121783752316,&
        -0.14944576332158516,-0.52188268458007869,0.20849183514175157,-0.79944859790656408,&
        0.17878751988754590,0.63617677067431355,0.74690408321780355,0.51823827411271550,&
        -1.2768147171393094,0.93631284667936154,0.23382281181422687,6.0944650360661629E-002,&
        -0.66447232398110478,0.75560460432532683,-0.19150822532210085,1.1309918913450685,&
        -0.37396685153732218,-0.14947395207790837,0.90235597368920450,0.56670207751629187,&
        0.58837241890649072,1.4499840463822273,0.59623364597654627,0.29664295999791646,&
        -0.84918985985212225,0.71633657270732798,-0.46898193282626865,0.17027919820125420,&
        -0.11819692013584714,1.2352388374174126,9.9046840635401479E-002,1.0864255725773129,&
        -1.7136732801454402,-1.8841500117561576,-0.57032496748794148,-1.2617874376109270E-002,&
        1.0644651707052581,-0.35209572494670366,1.0735503148493637,-0.85405419764149970,&
        2.8289775670076596,1.2206692190925144,-0.42849380805336762,-0.94901170945877322,&
        1.3310846481943013E-002,-1.5460511196599711,0.72140273077034600,-0.41047840686828624,&
        -2.6935949661259270E-002,-1.4107056170763728,-0.25433143288012522,0.95509133071506724,&
        -0.39478543027737539,1.0562916028974871,-0.21583199461962327,-0.48181202660993877,&
        0.27900674239340240,-0.17111717448429151,5.9383873605392670E-002,-1.3896428753523411,&
        0.17645636130872799,0.44796590251821705,-4.6455792467530933E-002,-0.56849408902672582,&
        0.32243041403697514,0.91592866920942040,0.44888968162864323,1.5956038919162447,&
        -2.1367919147227559,-0.33573594485131508,-0.33444333388409531,-1.1505074474816488,&
        0.17280011845599236,-1.8534990701826068,0.96551327974266166,0.54795801146348910,&
        0.46765383028483859,0.42021519995713058,0.92146175770689587,-1.4884644873663484,&
        -2.2204555662328995E-002,-1.7739735026864070,-0.12281862565207639,0.23535764182629490,&
        -1.1358566643723391,-0.48706386311704819,2.4896190139292638,0.14178199282126586,&
        1.3102831020244616,1.0085284708151059,0.34299159791014411,-0.67187222197036589,&
        0.70178872973352902,0.21069990775312494,-0.29274218143462072,0.68679825769614777,&
        -0.41789260023632535,0.34117469418829788,-9.8701882703088675E-002,6.1147289668596963E-003,&
        0.45039719542021456,-0.93893777480838592,0.87533989520515754,-1.0357707476806113,&
        -0.10197522136683938,0.23026608152373354,1.0460398886909128,-2.4352001582020550,&
        -0.65843700889870971,1.6519328639795634,2.7352720984744217,0.45851383032188980,&
        -0.19932812123653176,0.72507752095371669,0.42215627685448726,-0.21256055675569507,&
        1.0447041383091482,0.28357301408993185,0.60119410409057950,-0.83230756889680346,&
        1.0302630234202643,-4.3772212741078835E-002,0.16351696481124295,-0.54322833613841970,&
        1.1895783533944708,-0.66244564103997594,0.43816359317191150,-0.64853939601760702,&
        5.2456186327655294E-002,-1.4656884003937560,-0.30604872298935953,-0.91277302858716824,&
        -0.54723692861262141,0.58186754620029701,1.1274869490905719,0.88909059029063597,&
        -0.13694493976222588,-1.6394574010222507,-1.1775827609974254,-1.3303790912311235,&
        0.76180815230754095,8.9679535261423332E-002,-0.62393977836291070,-6.3519939131935127E-002,&
        -0.68048311683517981,-7.9442137818450845E-002,-0.70438598183491119,-0.70615994053234743,&
        6.2713445202731186E-002,0.96180027324648565,0.51210151239508372,0.21184771531673949,&
        0.86207248044006379,1.1397297291832198,0.89603778245600252,-7.8198417375876711E-002,&
        -1.4976751805950943,-0.14211031828818260,1.4362433950029350,2.0189216455182950,&
        -0.51295249293617140,-1.3782214898771346,2.9064565448133943,0.66092364867820375,&
        -1.3900134678474492,0.94034061291240645,1.4377579562557665,-0.50177841602888629,&
        -2.7687194171892631,-0.24132027038209625,-0.17870460186302631,0.12970353975318680,&
        1.0679651121902476,0.37843517295669393,0.44258907997742925,-1.2580811009593456,&
        -3.0739700158031464,0.11514243701398023,-2.4595738000661882,0.24312212032248451,&
        0.28541683968188752,1.4748527619097060,-0.36585325355684079,-0.36248927519234547,&
        -0.20311109817082826,-0.37034496448279614,-0.80539391645969527,1.4391463191354834,&
        0.77688482962662075,-1.0933451687587621,0.66224096871466842,1.3123244842129851,&
        -1.6239459367197675,0.59827182373937393,0.15746218639186893,-0.60455938410711307,&
        0.79115892855641801,-1.0062688254264043,1.2659463653709560,-8.4417454398925673E-003,&
        2.0594695517371342,-1.0190701956166071,7.5761810309492250E-002,-0.29440158205610611,&
        0.15132082338692318,-0.73584749684017048,-1.3682229728246846,-0.66707845839494140,&
        -0.75388309119250885,-0.64993126320886174,0.90905943981604098,0.39280621313645597,&
        -0.34782716161060662,0.82224711959628516,0.51284162059625338,-0.25522299810054910,&
        0.91697444180666277,-0.27175461221088237,0.44459924558997455,-0.37940835613650425,&
        0.20452972733904606,-0.21439016461807037,-0.85326626839326059,-2.1281506695037740,&
        9.2354972736400351E-002,0.21149603509760123,0.14886287304138809,1.3350364439091180,&
        -0.73459394607357253,-0.29037742130613042,-0.61944551922050162,-0.95525963957602156,&
        0.64717694506128887,-1.2165919782802974,0.66633925287142082,9.5901269842177499E-003,&
        -0.31527980079165835,1.4326620806549115,1.6913415685699256,1.4536767050694928,&
        -0.79988457652887768,-0.30027582405483272,-0.44124248819399081,-1.2461278133630507,&
        2.3852932423255377,-1.1676154899722961,0.58195299050547744,1.3936350589726039,&
        6.9586387344696868E-002,0.64538462743130565,0.59300887623165810,0.38625538203443333,&
        -0.61296395806706183,-0.19426371268071904,0.69028512674959652,-0.52460448591297426,&
        -1.0675391729850712,-0.64196404569732302,-0.73285037101668804,-1.0423264685475804,&
        1.3569235847347536,-1.1520670098025279,0.91634681607389590,-0.11115728244844826,&
        -0.21909302592561400,-1.1088109630071412,0.90241415976676509,0.35009586110784924,&
        -2.0074280423770205,-1.3964290293122514,-0.28934269650509720,0.70816803079231327,&
        0.75394717612147122,-6.4208171152544220E-003,-0.41069978071715374,0.78902486149003914,&
        2.7272692787348638,-6.1438416601891012E-002,1.9815890361473159,1.2006860033883686,&
        -0.18844146444152787,-1.1220103532780346,1.8235908272222026,0.41377228408257533,&
        2.3764832795279487,-0.20443147910036924,0.34888114280688731,0.19275577877242839,&
        -0.54083724748866113,-0.16202404272774798,-0.75420612262917774,-8.3145485717337972E-002,&
        0.15054727000568824,-0.17026127359180387,-0.20738284301454032,0.90279704130897520,&
        -1.1798378076558715,-0.39408835776757151,-0.85617561311801693,8.9543858872079843E-002,&
        0.13014735740743139,1.5661885867202485,1.0355729660911597,0.21121484673969904,&
        1.3204865286877732,-0.81271581728682218,0.58539561734239676,1.4189457659021802,&
        -1.0235564674152553,-3.5050344535074739E-002,0.34958357645923982,-2.2267247230230272,&
        0.37797917656151109,-0.18632827392113657,-0.34739038768393116,-5.9645186883090395E-002,&
        -0.38069907660827063,-1.4021224456762442,-1.8011118094848635,1.5692410342479317,&
        8.3399864134715451E-002,-0.36228585500558486,0.71147243764763801,1.6878568718629796,&
        -0.57304637486012722,-1.0330344275094299,0.96909913320459784,-1.9160036301346870,&
        -1.0926542021651895,1.1652881055257256,-1.2169918703296625,-0.32864098711642070,&
        -0.10977405730707138,-1.1907907474954793,-1.4006003945667012,-1.5726909056275313,&
        0.12339070658286870,0.26580411977763818,0.66378796300731047,1.9739588491257163,&
        -0.24972794005755414,0.30162202302163921,-1.6338770467721548,0.10973667562073963,&
        -0.81082553434969551,0.23128746853764767,1.3157174449601299,0.82181445881648973,&
        1.0935543275009998,-0.65763314974565767,0.63555174922412294,-1.3273608462458817,&
        -0.43930583240024701,0.85321670979138697,1.2762331498106312,0.50886282703385355,&
        -0.94547858965445908,0.95542231462932359,-0.13195646959986765,9.5977944560124151E-002,&
        8.8517307867041345E-002,0.88205021121107774,9.4475027249917604E-002,0.16347801352637473,&
        -1.4637786112467541,0.88707124647627178,-0.54186906930816570,-0.20223958058551605,&
        1.1173960670657932,1.1789935586346689,-0.29669087882574596,-0.25823954784394554,&
        -9.3147791512545680E-002,3.2955161890359262E-002,-0.76513600515079894,-0.10086651093891466,&
        6.4502411114938041E-002,0.52431759644051024,-2.0144567669705702,-0.87651333438093959,&
        -1.3313941900694610,-0.82288276962989648,0.17923174364656944,0.89541865150831457,&
        -0.11398864900640261,1.1124498126654374,-5.7193740083464652E-002,1.2615097126846357,&
        -1.3713038393163255,0.26181240474891515,-1.2551053750850898,-2.0552115936319257,&
        -0.57956312425904033,-0.31254630931930405,-0.34988598694728706,0.41980385167085293,&
        1.8354383076991123,-1.6531515353713377,0.74141815302360858,-0.26197588873638900,&
        0.16548951485661975,-0.52289946256922881,0.10672615103390419,-7.2137035559382542E-002,&
        0.65751559549180216,1.0982177716510044,-0.61625516201358255,1.6867859412781563,&
        0.80748280447035359,0.43308719445634730,-0.38224269325861066,-1.5304359927023963,&
        0.82534558885125586,-0.24020266607947485,-1.4564577298188000,8.1693396665409257E-002,&
        -0.81555506244167764,-1.3135644323316271,0.54149611664771602,0.10855987112943459,&
        -0.23754217632616204,1.0255097455860551,-1.2058565543548156,0.50728749801833217,&
        -1.5873582641298756,0.93364630544904237,1.1816830713252113,-1.2045153449074339,&
        0.22148919484643909,-0.89005019501001448,0.85417435602114744,-1.0015079815266750,&
        -0.47737788280428251,1.0821071050097264,1.8424586794391293,-1.2988612222926996,&
        -0.53871650595981746,-0.49473142556723648,-0.17425424184913141,0.21377692099146109,&
        -0.91904481906600832,-0.32112765885535244,1.2674174163742411,-0.67026801162108984/

        DATA MC14/0.21471474045220615,-0.99368229295781663,-1.2350173691386148,1.3944653924834414,&
        -0.17694969094498944,-0.19783392406222058,0.31873332698914919,0.84309539819923529,&
        0.37766048078379166,0.15113067100480518,0.86773138006511930,0.13106988550288431,&
        1.3252850114912056E-002,-0.52104562352036843,0.24988398554332342,0.61174641949332087,&
        1.7489152679520237,-0.44604715091972125,0.66827442967623674,0.72872856934511065,&
        4.9462284294015849E-002,-0.50382468214389975,1.7717061663933171,-1.7438957125874204,&
        -1.2493564693991979,-0.45297711490799536,-0.69787673896452607,-0.86982040071166933,&
        1.8224235111711991,-1.8641020895033986,-0.89800226527350580,-1.9317303951148792,&
        1.2126479275840258,0.14726691238604020,-0.91236825030353874,0.28695297456705432,&
        1.8059033528050807,0.40546956139410928,1.4724492746791928,-0.14499845520945082,&
        0.37026049866754202,-0.67063084893476255,-0.44971804953230843,0.92585157136430341,&
        0.59786513629301374,-0.90892704060864737,-1.0712133659289038,-0.69193673039387871,&
        -1.3242201841420129,-0.42347201227574649,1.0674315803251977,-0.20826188175542593,&
        5.2258567339334976E-002,-0.62096503644448142,-1.9440629567462384,-1.3227780195504599,&
        -0.65568524732711486,-1.2896677694854104,7.7216410142831718E-002,1.5915151267380538,&
        -1.3844841909369552,0.82322030311625294,-0.65131693207473040,-0.42726419544820232,&
        0.64990924150461604,-0.26935596429412995,-0.26203590132352300,0.20315156481401306,&
        -1.2530267929049741,1.2415073904163687,-1.5452978872493901,1.0828212911557999,&
        -0.31049336684869966,-0.45484481351291511,1.2523048257787648,-0.63738855049806786,&
        -0.44261491191050156,0.45090888861246320,2.3881873529713005,1.1548604788521284,&
        0.94571768336811746,-1.2182433508072734E-002,0.60753105469295687,0.62290359733518563,&
        -1.0603595668844923,-0.72914836345292133,0.36299888815165698,-0.79139344612197438,&
        -0.78882470050226905,0.38803574412880737,-1.1046970265098728,0.66565798617742267,&
        0.64354031215441254,-2.0041161409062336,-1.2275444918759053,0.99114337021227761,&
        -1.7642397748656995,-1.6762729725221526,-1.4982133636994075,0.17443836127147905,&
        -1.7542107506562137,0.25043034049753743,0.85081701791293773,-0.30074608625878835,&
        -0.54973795415894822,-1.5899508503860227,0.69834391358370707,0.32661022680011104,&
        -0.48191092558535398,0.33869398429061404,1.0533670593987268,-1.3718069922052851,&
        -0.40051340988002221,0.80000676933206127,-0.59850557663751980,0.30757185425811229,&
        2.1643757804018322,-0.63840881035171337,-4.3833461098699136E-002,0.52673515802610915,&
        0.34365697606751860,-2.0043698166039379,1.0759185739009387,-0.55760399876479061,&
        -0.98936161753349872,-2.0672261436204837,-0.91813761391364823,0.34022960323235557,&
        -0.71369908620889499,-0.41727628710873116,1.1002153875189933,5.7888782395941897E-002,&
        2.9728938240337475,1.1635084898740449,4.8944443324005778E-002,1.1671709676473290,&
        -0.98041877191287408,1.0254324861394317,0.23827930338929379,0.72094354813724282,&
        -0.64271277997401566,-0.76205665606966733,1.2198887188598018,-0.55957371394206112,&
        0.14887218278539419,0.40828613181858026,-0.61438299570232680,1.9334955163939529,&
        -1.1323014923750729,-0.50988082856550143,-0.10784201366801131,1.0163782040907914,&
        -0.23169292169161582,2.6977121051539164,-1.1294141379459257,0.31638099224941124,&
        -0.20694470926817382,0.97200477871316771,-0.23960264435806214,-0.29844517844448126,&
        -0.68659664374319407,-1.0112629963918702,0.60034571135164239,-1.1835070008265511,&
        0.57962447120648752,0.57318162952061358,1.0241631094542294,-2.4873461192881141,&
        1.8174484298618876,-0.93242909122805484,0.83281482363805370,-0.87968882797485437,&
        -0.42788274136911653,0.29565416270153860,0.56686939953512372,0.42642394688648072,&
        0.87581677538609448,1.3163703108700224,1.5180070670962384,0.49813373028446833,&
        -0.44082669003759978,0.47767079591802031,-4.5101644938368837E-002,7.7366044307039167E-002,&
        0.84592290833625883,0.29322953761432319,-0.53252315711654552,-2.5010800783930343,&
        0.42797381796775918,0.29946512079979121,1.6225970333839494,-0.11335583731797605,&
        0.60364577113741091,-0.83642827707588852,0.38328680326438552,0.65620292176949202,&
        1.2949597120931882,1.1166471628404917,-1.9109576609245293,-5.5242602959130777E-002,&
        0.13252813725880155,0.87707410457092250,1.1244534029369051,-0.72458543118677032,&
        -0.57778959503204985,1.1608636586277588,-0.60747720172646680,-1.6404499542575837,&
        -0.78419556823266190,2.3680167050544281,0.92161368745956707,-1.2949896249396169,&
        -0.84553169585841081,1.7777892784726559,0.69854036667786945,-1.0087604204682188,&
        -0.37195268816408206,0.49590529705237502,-0.53441424901797352,0.92171418652063197,&
        -1.5078037599399781,-1.2664912990522170,0.16465873450204060,-1.2992669488657886,&
        -0.16158544742842698,2.0695278097377172,1.2599652087419628,0.25834438538560334,&
        1.3961161808364242,-1.5489040575756328,-0.46011825132349365,-0.62516656864391440,&
        -0.84515260070464271,-0.33373123483437600,0.70938454107621418,0.82127396301729882,&
        -1.5969087751286044,0.98322838443212979,0.90670670686486277,-0.39922392247872152,&
        -0.11200574304739763,2.2490750749093693,-8.9730118092783417E-002,0.53095408563968338,&
        0.35341413677764616,-0.79955815732999369,-0.17374922820307698,0.48601518017370648,&
        0.86259385209509853,0.18895829048508955,1.6090254855977375,0.41370417874463938,&
        -1.8400137242297678,-0.43901620039669170,-1.1803117494948834,-1.4623279897735642,&
        -1.3073113814683879,5.4085010456651110E-004,-0.45445771826261366,1.4401067630585200,&
        1.1611824947868745E-002,1.3150893777977812,-1.1218309803912112,-7.5357036225180446E-002,&
        1.6923262490842170,3.9944962957421275E-002,-0.81222500925406516,-0.56630284573051226,&
        0.26768156300941304,0.27121049634452254,-2.5757977250500721,0.66352781159503960,&
        0.89236207729874595,-1.5755440021349849,-0.47711790585649183,-0.64484013436531429,&
        -7.3670914940053137E-002,0.74514133371617619,0.49136133285907085,-1.7211230875688848,&
        -0.20865166830546342,-2.1030627199816077,0.27311292170835177,-6.7801883456976401E-003,&
        1.0594920263346017,1.0695942976880031,0.34882085150470654,0.56800544232780825,&
        0.79585893026381505,0.81462960160271380,1.1461592875809417,-1.1072219763276927,&
        1.2141346040763707,-1.0350284603230060,-1.4089844046442643,-1.3772862667990089,&
        -0.95844042878357549,0.19567697538810952,0.34158103053440964,-2.2952974966871591E-002,&
        -0.54758614243213655,-0.94521596571535182,0.54424831225814418,-1.2224386651516095,&
        0.99648916333951776,0.85547816194109494,2.2925130749617959,0.32877656772713382,&
        0.22295203547509279,0.32371465838400387,0.17794684541783329,-0.89175075944135440,&
        -1.1223625901939267,0.88663245170077687,0.72438348609429315,0.30344609997498972,&
        0.55027961146796223,-0.33265523279760928,-0.20348834118019193,1.1128712443485582,&
        -0.38736081742228040,-0.74700277146711391,-1.3374544356794866,0.89630425138838155,&
        0.90534873817827510,-1.8868124983211495E-002,0.30902100966422091,1.5951269977364955,&
        0.25966425288235273,-1.6581658539077253,0.19705986182308405,1.0184675470101445,&
        -1.4601316554066193,-2.0297194081842673,1.0088264118429562,1.1388766583013492,&
        1.0917044908040645,0.42130484266244317,-0.31109287672638208,-0.52547522017503312,&
        -0.54456415753972121,0.51845233964662141,0.14455424402410114,-0.53491226555519078,&
        -1.4385343920949631E-002,-0.19951857997966016,-0.27069869088175180,0.39843393717884340,&
        -0.31400055787443720,0.55191398159459049,0.16431609936976077,-0.39242381882253285,&
        0.10216888000806218,-3.2275957984049544E-002,-0.18495634451823068,-0.65207166697758001,&
        0.43286242695633365,-1.6440041342730942,0.53453796705293688,1.7985048258527947,&
        0.23093495257621829,1.8570777464014252,1.5001558308594849,-1.7570388969719923,&
        0.37445522731503561,0.97022889786744204,-1.2544161941485319,-0.50568990237102285,&
        -0.78410874442393563,2.2745225741713222,-1.0459064727410157,2.0293318793461679,&
        0.22346856078781419,-1.0610372820895226,0.31562110071314198,-0.30031470181126463,&
        0.68156020790905858,-6.6763004955807226E-002,1.1413714282444050,1.8773263581003814,&
        0.69374394713028098,1.4089063746476707,-0.70261432138513968,-1.5963018820138068,&
        -0.69308346802775267,0.85583600767582768,0.74705454760945689,2.4347588977434209,&
        0.25254661061558265,-0.47505116066207986,-2.2351824163934889E-002,0.46973905044116465,&
        -0.91700312835863618,0.88229980050853429,-9.0779706939413174E-002,-1.7486069184193873,&
        0.47819175004533898,-0.34805887631465171,-1.3059295007667628,-1.7464252073146553,&
        0.59412333554102059,0.33090328239607675,-0.44814157742238442,8.6270446130480752E-002,&
        -0.70536076760676181,0.53754607958836931,5.9170722470224466E-002,0.58283877101163539,&
        0.67494217947730872,0.53203746677877528,1.1657254616103016E-002,0.30398886611389569,&
        0.10325822335284493,-0.38414701153397435,5.3641778627581356E-002,0.23111604332626004,&
        -2.0309262714714609,1.5729209603159209,0.74385913004856041,0.83937289060012377,&
        -1.7030788099064200,-3.3158667518424431E-002,-0.72862849078883873,0.16884638461448623,&
        1.0080695316014856,-0.33559789571873672,0.67325348568193188,0.11346149720464953,&
        8.1335280695797554E-002,0.63365464621696799,2.0581644691382071,5.7344839495228041E-002,&
        0.85634341027535277,5.8114572202874359E-002,0.56014495629154648,4.6227735614623365E-002,&
        2.0267316356624114,0.66139117873954323,-0.50624381058125090,1.1258996623820390,&
        0.24715062447350189,0.53508838365012568,0.37500509763412321,-0.42171796372962655,&
        -0.68849640714110072,-2.5112335764148668,-0.62160913497243553,-0.21774627142724665,&
        0.67635460023719884,1.1324566121791717,-1.5913709360663058,-0.51592622359568541,&
        1.1083266865910624,-0.45288217934162006,-0.24314741527413275,-0.68858193797357137,&
        -0.92544047147842079,0.63242665223376693,-1.2072760444632615,0.23279430383284114,&
        -0.37993898033143353,0.95386240046536552,0.98282431541101656,0.15026090922270904,&
        -0.83509462325595984,0.96887401459681732,0.78291230902151132,-1.3901394003242680E-002,&
        1.3285879103436302,-1.3264935295801512,0.29472112402489842,1.6651483988567759,&
        -0.17401262150045074,0.54565834304129612,0.12067360004526674,0.45822134535365838,&
        0.54265983430337317,-0.44292957555680329,-0.80578144941380381,-0.54430183778324137,&
        0.61048480093615198,-0.91433481867700306,0.54208945758761728,-0.18965448121931500,&
        -1.4339699796116014,1.8948702126045827,-0.72781086115967475,0.11852335229185532,&
        -0.14646613080435322,-2.2081813910620651,0.35010799197723347,0.85021992576751015,&
        0.43726714624855473,1.0293226355338423,1.8201508365578620,-1.6892696119388950,&
        -0.49518508033800390,1.1882314238330220,0.38787966057990225,0.96855193169889353,&
        0.73406681535205709,0.31082918423901085,1.7278055725054517,-0.35155278135306745,&
        -1.6197072235001484,-2.1920422127734001,1.3830671288073941,-0.79917732243358786,&
        -1.3621214834324022,1.8707271654926190,1.9360472352198310,1.4610067298579044,&
        -0.51735845475364617,0.90331165431244909,-6.0569355136775603E-002,-0.19717266758814225,&
        -0.46957055480692339,0.74062528013468920,0.34442681169853928,2.0149934303748815,&
        -0.51741658635676324,-1.4516654415868442,-1.0493050499375931,1.3923487472994789,&
        -1.6394683723370176,0.97965547315528712,7.5308691401681838E-002,0.48935426664553378,&
        -0.16101821778658418,1.8351974804685320,0.40654732713790576,-1.4078446424068860,&
        0.25050303057825757,1.0211546457880720,3.1294009450182021E-002,-0.31923374614444061,&
        -0.97819706001971929,-0.85203627707884722,0.19599535636468965,1.6853681656370147,&
        1.1820726369241181,0.43993730462696973,1.4385087711786886,-1.3951567777663487,&
        7.4781581222543456E-002,-1.3586762117755606,-0.67623130570555523,-0.77133163125230664,&
        -1.2992363113428398,-3.7153275305710512E-002,-0.53601118352608446,2.3003310807678958,&
        -0.11918608293656724,-0.35696887726972476,3.7894854817088243E-002,0.99813157901913607,&
        -1.6716105225759867,-1.9378866608985825,0.41783184300519638,1.1482674770021084,&
        -1.2185941847323800,1.4701800236370610,0.58372501304955826,-0.11058601078745310,&
        -0.30870254326779106,-0.61215730949838887,1.4844811058941387,0.61201589052741934,&
        0.16746902483574472,1.1208683882504098,-1.4795368955242771,0.21565952062345153,&
        -0.77460259621990168,-2.2290298507128958,-1.1982995273685508,-0.66349146730912101,&
        -0.33226339310699210,0.47234436673479729,5.3016365930596464E-002,0.41954282723416514,&
        1.5405529351012826,-0.20323470360633331,-1.7403874181560219,-0.30538420648734288,&
        -1.8036829925921638,4.2890229859481960E-002,1.9772562040134577E-002,-0.13263807307561332,&
        9.7640277267228098E-002,-0.25925019445746689,1.3257306563623950,9.6173760292740593E-003,&
        -0.85801890411910042,0.20378644576386040,2.4535615822858685,-0.76761196111813357,&
        -0.99008372373439879,-0.83346351466414670,0.13949778540740268,-0.87227092133023088,&
        -1.1126399294772438,0.66106569386407432,1.5735250804244975E-002,0.20100038155183136,&
        0.57843194959105271,-0.12684766751012067,0.24071008804181665,1.4234735655321189,&
        0.20780878250956045,-0.66304064797492679,-0.66706214234938188,7.4906187811279085E-002,&
        0.63816422626114933,-0.24857701728795359,1.4659856954287234,-1.3234909783739255,&
        1.3743184615945538,-0.11880733493766880,0.45592785688903487,-0.66977177935428878,&
        -0.82618244118316519,-1.5298999250734022,0.12190289801111433,0.48822409114044774,&
        0.22201358391737247,0.18618441598096849,-0.18237693288849693,2.6429502605640195E-002,&
        -0.84509835206436346,0.71620307332544220,-1.6132342252731399E-002,0.73788341917346345,&
        0.33050565676017329,-0.52008596126339623,0.84756121682657615,3.5943893782472723E-002,&
        -0.41486118089594659,-0.22077781784343986,0.18412908485123777,1.1406967873480502,&
        -0.33849887817278318,-0.65107105049491076,-0.21935177308938172,1.1982988723641776,&
        0.22601140787801846,-0.10169442271496777,1.7739525619022196,1.1794241452743948,&
        -0.13504078853298215,0.77902749832863438,1.4663684718483712,-0.25621690290231952,&
        7.8933268728971676E-002,-0.41768907687073209,-1.6750834712298248,0.30648852577721009,&
        0.30655537459186150,-0.17956314140788737,-1.0277106935535107,0.63306858664284638,&
        -0.15020909253004402,-1.7775682362824710,-9.5967457589917093E-002,-1.3494459874548757,&
        -0.17168310410066565,-1.1361043367372732,0.76418701610480222,0.49252414040102321,&
        -0.42588234950700066,0.18288790954947309,-0.24071134962644591,-0.82676324864889195,&
        -1.8954193423014611,0.70827230464728530,-0.64642857295474065,-0.94764296780824098,&
        1.3006169185034715,1.1366797423145329,-0.85883530490974447,-0.73652391534484074,&
        -0.56006863758541292,-1.3839148001581123,-0.16278888264824540,0.82288016329335689,&
        1.0995664023257410,0.94190799494602162,1.4232181721034225E-002,-0.58183057893395707,&
        0.40164226781432205,0.56670337125553560,-0.57173322526399895,-0.42666413572467077,&
        0.19891706211783819,1.3877774543618933,1.1711559092996249,0.61347889289220203,&
        0.11594969212538860,0.18097478600079014,1.9461057108329627,-1.6040958700183576,&
        -0.24773990153526559,-0.25379987727376652,0.98816086749642906,-0.51039867022099383,&
        -0.40688631886234111,1.6573928264866393,-1.3962937192649483,-0.12990927049143783,&
        1.1807990100182955,-7.7334742218561722E-002,0.78836334371907457,-0.20554595756703922,&
        -0.93567348453099863,1.1609793694656241,-0.80559181107891809,0.82467425430039798,&
        0.38537759169249003,-7.2388222820899475E-002,-0.60458763167837071,0.65901507476225463,&
        0.97717337748344613,-0.20100834646696036,1.0042025736843321,-1.6842697798231807,&
        3.0171637453335690E-002,1.1596462788645088,-1.0350785809303249,0.33137893467654683,&
        1.8585612802387153,2.1237801894522512,-1.6568702217011688,0.51260613235363017,&
        0.73522491138446144,-0.74039171677484017,-1.6677361309074978,-1.5393026376900241,&
        0.28716649420039686,1.2165388832868893,0.42954639130748584,-0.52487855827199603,&
        -1.3317071077541507,-2.6809269988461476E-002,-0.68444608905506432,0.61529610634598586,&
        0.44127750500934215,0.23106759139816560,0.11200546287395062,-0.31785708083307801,&
        -6.3737778142075235E-002,-0.98051584473486086,1.9255750936534703,5.2574434189795509E-002,&
        -0.90540271621727042,-0.58740414423996701,-0.79698540733080070,1.6603844935562504,&
        -0.29898170970562815,-1.8918274586321155,-0.41170640147612303,1.2742686018004570,&
        -0.85925885404253777,-0.53193814819219531,-0.91723868084428251,-0.16732473184663166,&
        -0.45295584257795124,-0.28024608237346560,0.14973426752471702,-2.1536875765896863,&
        1.3638620523237746,-0.94409159285375999,-0.83916884968662286,0.77674976241794957,&
        -0.12771230889104668,-0.51935309982337885,1.5574058909720068,-2.9914465007917092E-002,&
        0.93551778691219334,-0.22125018357979079,-1.1051111474668436,-1.0302437077414563,&
        0.30588870391855172,-0.67195421721555537,0.42409734694138190,-0.79811115151059886,&
        1.6869589394933870,-0.47320713554693039,0.16488680319898996,1.4431388342529230,&
        -0.45046282869125315,-0.93993877650768154,1.9312188033429494,-1.4606156613263133,&
        -0.71826365567606110,1.1173141545365459,-0.60263861679021125,-1.4889574341860030,&
        1.6083531223236782,0.67360034491506349,0.56412536414065795,-0.32486924895771324,&
        -1.6104938406953677,-0.12359859406400323,0.20226873629100806,0.13242834012590102,&
        0.39297054602570552,-0.59655728087930404,0.16150847704745797,-0.48238921448032279,&
        0.62536570316123141,-1.1690286618052739,0.71611593995406475,0.65826362653812487,&
        0.35412618603653206,-0.66273954328806106,5.2582308441212484E-002,5.2556095054408867E-003,&
        -0.99280623593736372,0.40929181385909297,0.85639756326142635,-0.68668484291338872,&
        -1.3358341182096194,0.58391876911829454,1.3888919909769379,-0.86897564632633795,&
        0.88113164826412926,0.17319038257824049,-9.8174844584670955E-004,0.51980450657083677,&
        8.8694493730549384E-002,1.3414990341503037,-1.1524099789370230,0.69883240711027894,&
        -1.6634636158035048,0.88941510863875339,7.0327067488668196E-002,-0.93085626653259390,&
        0.50784636770509850,1.6579983755578527,0.80592099815495455,0.24292208865400033,&
        1.1050446288147697,-1.4963145632988797,0.52856759256982844,-1.0058239845734136,&
        0.75787256925537638,0.59529036183698902,-0.35690924419300823,0.18435263432655533,&
        -1.4128949123539192,0.44438526754962060,-1.3896465797779187,-0.72114360829990809,&
        -1.2472670963810526,0.19524238505511957,-1.1860967816853452,0.38391533072957268,&
        -1.0314987715563411,-0.23758318364096917,0.28715306842191024,-0.82040816817336604,&
        0.62040355516609347,-1.2873218310324868,0.45016857336573829,5.3614140108202432E-004,&
        -0.32393068518034418,-0.49858734673518185,0.74158394046330578,1.4466872710441221,&
        -0.69691840632600410,0.92117425027855238,1.0947565434812396,-0.75788034549521321,&
        -1.8473976386531901,-1.6294954175994680,0.60460889657400241,-1.5124197248934883,&
        -0.61970525934859289,-0.79491241699075932,-1.1887034807063432,1.6809766312270322,&
        -1.1109085493205111,-0.60445445229970207,-1.0692929360757115,-1.4295292257531491,&
        0.59431974145831223,1.4015299033281545,-0.34923792040452228,-0.34780089213252857,&
        -0.43337961030293726,1.5247167894300662,-0.33276735570531896,-1.2471070773769188,&
        6.9030358671509348E-002,0.83950183661980871,0.32125454602291192,-2.7429271924847200E-002,&
        -0.59042393760527734,2.3476460696300134,-0.99988522198266139,2.4634839970038053E-003,&
        -0.50919844471890463,0.76847383278992953,0.64427785461785192,1.0816792280128118,&
        0.71506315414528165,-0.47742820351194298,0.41818244378623892,1.1922753529431018,&
        -0.21894083516199500,-1.0413380148942906,-0.83696133527712779,1.0948655349905803,&
        -0.17459953053026889,0.65415880610192922,0.36970309244746274,0.52588631929930418,&
        -1.7347173571442465,0.54126917372053340,2.0804756784729803E-002,-0.14507505465481588,&
        0.81287839639047743,-0.29807157316220795,1.4003543567458017,-0.72662782679327431,&
        -0.36263783690736812,-1.5060761916200027,-1.0907251886758427,-1.5201204930832681,&
        1.2021593484277304,9.0465147725258335E-002,-1.8092742133994062,0.30457728402071760,&
        1.2082053130110804,-0.44862506017293508,1.4582285988775814,-0.34947988868567692,&
        0.58011640263703834,-6.6090114600013641E-002,-1.8617543147118689,7.0886343180400976E-003,&
        0.54955586223356978,1.1640575748210515,0.40822131042419108,2.2553134498278435,&
        0.92640993575271047,1.8265646587125457,-0.17739886716807196,-0.50551309469024630,&
        0.15009476599634949,1.8437364131799299,1.5140159452017943,-2.1412367450381979,&
        -1.3739204883299376,-0.69466856616735095,-2.0412583284178316,-0.33256110287184926,&
        -1.2942096927317676E-002,-0.62998320923430384,0.80150480690585657,-0.68637073864236453,&
        -7.2959475611220070E-002,0.49760980955390621,1.6352591237791239,-2.2850179089685363,&
        -1.4746039376389575,-1.9255807054628942,1.3433480712605137,-0.28575147227257142,&
        2.8101700695976246E-002,-0.28181576063369890,-0.95176781171515779,-1.3411658968619544,&
        0.64027063952674079,-1.8109015249977798,-4.8541759902721693E-002,-0.44744119704420948,&
        1.0142432377138992,-1.2244242342515665,-0.19088829140012653,-1.3611970057761498,&
        1.4165499621565927,-7.4402922310390043E-002,-0.31919142441207243,-0.88717301792550973,&
        1.4531504704263420,1.0250470423759250,-0.92355284123307757,-2.6419926702628276,&
        1.0581800785793825,-1.6868602061496771,0.19081264456389041,-1.6105791027732674,&
        -0.23176229785245417,-1.0228052232471432,2.0279658815894095,-0.46188599894084964,&
        -0.57369798719390674,-0.47980724336538444,0.36542763709515985,0.92896033849642978/

        DATA MC15/0.97772086113321777,-0.76036658169275984,-3.1335655902879456E-002,0.27815871302008738,&
        -1.2471982752315789,-0.19804652662798536,8.2115765111460612E-002,1.2412034733780453,&
        0.64607544922537874,-0.80422785247907103,-0.21363548851055073,8.8656256298154143E-002,&
        -0.20302969495467035,-9.1253673141802327E-002,-0.79817127200530991,-0.33186437783733702,&
        0.67282966157833579,-1.3156177808401186,1.7497339259900029,-0.43811348031180963,&
        1.5144266955994223,0.16466006503867781,-1.2459356960706225,-0.76912318338997665,&
        0.88183307580723913,0.11441069887721375,-0.92147413391122401,-1.2127310467231518,&
        -3.1216443817257165E-002,-1.2325494892599218,-0.91469467864713594,0.18989596301277328,&
        -0.21902724415489125,1.9502179209046278,0.69145252714125627,-0.29840330963713946,&
        0.33478781267386026,-1.5469943345540449,7.1636009993532659E-002,-0.30026164048193754,&
        2.1078932445771321,-8.0685335510926395E-002,1.3525372208663500,-0.88520489756410703,&
        -0.20955108942030867,0.53961140159579291,-0.88294528995859622,-0.49659438319960020,&
        -1.3172651432729261,1.1765265097066089,0.71215879946913141,0.54286946196586228,&
        -2.2529597646145612,-0.67295537946850781,0.91925688204536660,0.79482531078827767,&
        -1.2457553456255586,0.50049018954798719,-1.0548310018111267,0.50010600676199068,&
        -1.0053966563129333,1.4016704456926696,-1.1577752936746040,-0.42307202394321108,&
        -0.88921523896786758,-1.1335078344862641,0.97424181323260473,-1.4328094738046966,&
        0.24416044130483594,0.26117114079700277,-2.8466790003271753E-002,0.37603692011915096,&
        2.1037398308538657,-0.66132522526221016,1.7734742174692846,0.83347710923739726,&
        0.37953600735063198,0.26102520064123091,-1.9865390549621855,0.17008782123486377,&
        0.57624260852526055,0.55769173662521043,0.50543114865282990,-0.44209717539186216,&
        0.36739102976930632,-0.98357104560759334,1.1837851229737484,-0.24227876639662205,&
        0.22253286739840997,-0.69071059812492497,-0.55527596472652341,-0.27690479166639131,&
        0.29232273514917151,-0.79246071049568767,-1.8528172384186783,-0.97515678946715711,&
        -0.56794581883752226,1.3852812907588090,-1.3102472897736748,-1.7603172891064245,&
        -0.21862998959712071,-0.20417342531270813,-0.41833839281323709,0.41904789066728931,&
        -0.26090759542605374,-1.6359399357744471,0.26557016510796005,-0.41507782709244828,&
        0.69693860127737217,-0.75071838057253004,-1.5899483832408758,-1.0372921134403028,&
        -1.3419126368139802,0.51555640605859732,-1.2390773310688230,-0.50706148398279871,&
        0.18136392195591497,-2.0260409336491425,-1.0455459718610185,-0.91503768862255708,&
        1.1375608862323459,0.72069860739894942,-0.23517528409011790,0.38060614520518787,&
        -0.13107819823149031,3.1929592227642560,-2.0075365360432404E-002,0.36205292447667187,&
        0.82483324844123906,-0.20213166844456337,-0.98890101441342459,0.39435716727988673,&
        0.19017018928823434,-1.4556121154529615,0.77157134859615617,0.43098615988011302,&
        0.92682639013199797,-7.3451468011171292E-002,-0.21922234159322140,0.20415109073813448,&
        -0.52232760558770397,-0.18033846872436490,0.39533088135847838,-0.39651580287943239,&
        0.34922711915247362,-0.12293047430803070,-1.8934556919089545,0.76773119320877836,&
        2.3082577257960724,0.45980247175379801,1.4093853079542038,-0.30715484302953716,&
        -1.3148459676567179,-0.90805619699768991,-1.4446432894006567,0.34780703919216555,&
        -1.0391895920347014,0.70529250651809439,0.58118406006878875,-0.30358242450148493,&
        -0.95428586372999147,-0.45751959530915970,2.6754940390838713,-0.44871622655750892,&
        -1.0576701285008447,0.39457991902437295,0.13809519902292663,1.3079836281091555,&
        -1.2534753583301106,0.13993112116914191,-0.52892004276458748,-0.36899768662392879,&
        5.8361249381200263E-002,0.93969510373497800,1.9306796321484048,-0.85077102436899521,&
        1.2769119434087863,2.1120816549770076,2.0245359379247492,-0.19894793438659567,&
        1.2663389680163939,-1.3538860934961432,0.71355119974894277,0.66809404139056305,&
        1.1292076390173376,-0.78215862935650626,1.3490311874052312,1.4567524917190324,&
        1.9784399979984182,0.84017877584239697,0.80094387562813063,-0.70475669575288136,&
        0.28561361169675203,1.0171518011109486,7.1697389727616551E-002,-0.32228851584270934,&
        -1.8764546837848990,-2.0076955013693376,-0.66463034645149333,-0.13714358395874635,&
        0.57175942210896136,2.3069611252932836,-0.45875780580499015,-0.47375596093098982,&
        1.9018567030523565,0.90853533250770524,0.21942022346272572,-2.2774077183257819E-002,&
        -0.47416103751066646,0.72025084532586936,-0.14709217373438474,0.54260485229672317,&
        1.0303630890857440,-0.76302071114377679,-0.35190673755204471,-0.55197538841113059,&
        -0.82809126014892298,-0.19586746494175025,4.7345752531433097E-002,1.1066617407441948,&
        -0.70870190373442177,-2.4928591582801944,8.9726319218944153E-002,1.4125267481600396,&
        -0.62521008864316518,0.61464747386829643,7.3428771837232411E-004,0.19812784330501568,&
        0.43268684838332477,-1.7409127482747657,0.97562794669631980,-1.4702835669994005,&
        -2.3739464682988047,0.58569594120681057,-1.0081772410640635,-0.18019806939058461,&
        -1.1870777880055121,0.69214831455629666,1.3081198012050637,-0.11685921962568557,&
        -1.0899476548738924,0.89412584242750093,-0.37137133403941985,1.9927225395484292,&
        0.38103266822649851,-2.1553089234608209,0.31907598587787517,-0.36297073404700908,&
        -1.3394584901103057,-1.0256954429978469,-0.37130086531723638,-0.69573225494766266,&
        1.9248698594558893,0.31493536131659011,0.49217357388578242,1.2304516890937316,&
        6.0559041326510570E-002,-0.26387278379275991,-0.43894362796456909,-9.3193298667725272E-002,&
        -1.4122069198492888,-0.11158837805703230,0.29076067298059050,1.3269976158218859,&
        1.3585000866442163,-1.1410918297499351E-002,0.89053920287471100,-0.11893256053179424,&
        0.44588557310381882,0.14997342163536273,1.5961879525338327,1.0241110453821037E-002,&
        2.3613446688419186,-1.2738201291219067,-0.19160514608046342,-0.45452726498985285,&
        8.7069984292681687E-002,1.0609106056027708,-0.26782415356868328,0.37768481524922365,&
        1.3078888743452408,-0.27187787523986279,0.27927180217432829,-0.35896431315933752,&
        1.5008167451803991,1.5039107786485872E-002,-1.3645665714619641,0.16987073436851752,&
        0.89926936058849272,-1.4215746500735555,-0.32682826414339822,-1.7745390987061451,&
        -1.3411907432047605,-1.2513101675285572,-0.72093141060010779,1.3950561067742402,&
        1.7400119239987837,-0.40844900308972437,-7.6504201270871666E-002,0.11635019411239940,&
        0.79261192683742177,0.23552296358807268,-0.57736488634383387,0.94239875109887650,&
        0.47721496792804324,-1.2485424941605447,0.17179941923585101,-0.21906661815485864,&
        -0.45229264172494249,-0.92199375449201881,2.2120717056627113,0.71101567606368865,&
        -1.6005346164189302,-0.82310018481878178,-0.97947690771656337,1.5022774338018607,&
        0.52105951689260988,-0.13972807088328579,-0.20842232529194263,0.22771034385930203,&
        -0.78991913617857534,0.90518118474213405,-1.6122594259425458,-0.97722526788735997,&
        0.53421803803233958,-0.72490252572197211,-0.26490202111753575,0.82072906126896239,&
        1.0325890886640177,1.7210450219803812,0.20504959342852677,0.64201581580249489,&
        0.44473614522423854,-1.0611356485884522,0.70200314892264370,2.1539031671443718,&
        0.87246863132847152,1.6803483484611641,1.1439251876343570,-0.40901216164950965,&
        0.13524771363301979,0.17496487166270877,-0.79152906380069865,0.75958640441432324,&
        0.50903347989096415,-0.46879760968809403,-0.43343423518756397,-1.7582453861232192,&
        1.3238671195122342,-0.71917831269946031,-0.44269925569565649,-1.4134149565695238,&
        0.84193920841652126,-0.39666339024300978,-1.2744121378965283,2.7049610506133752,&
        -1.0033259281946225,1.1176032453873261,-1.1089672386355620,-0.69482702514161487,&
        -7.2013318631927864E-002,0.47336352174281277,-0.12556013957605713,0.58336815654884056,&
        0.71843678496335606,5.5857369057807679E-002,0.37318765905614609,-3.7920750140421441E-002,&
        -0.40082914446274320,1.5973490286774705,0.10398526003553524,1.3868604327664755,&
        -2.8099717629485892,0.34949242916861550,-0.57963814360666921,-0.71824567776243320,&
        -1.1623069442695990,-1.2686561540463812,0.25045824697839453,0.41240185704668092,&
        1.2597845332632844,-0.58939562385729249,-7.1378562559946471E-002,-0.40964098852178360,&
        1.5398019915335475,1.5372919000563048,0.27389013191267425,-0.69843321194255570,&
        -0.84170262130587936,-1.2977134990543893,-0.85883321300788884,-0.63233879889085565,&
        0.47457793831443640,-1.1871468522752324,-0.12345316865078823,0.46164291337108393,&
        -1.7272188025138986,0.62962633379333310,-1.0915806995880306,-0.27418786676904411,&
        -1.7110871865381159,-0.78641182054029846,0.50320873191582027,0.50994734113856155,&
        -4.3495090613612675E-002,-1.2825435967293022,0.10839206348148256,2.0338875863392580,&
        1.2439403324382464E-003,-1.7757154637329886,1.7450862905819113,0.82797399463887733,&
        -0.72731916907827399,-0.84787582236693093,-0.70975125584542820,-2.0025888633121927,&
        0.34117273224833500,2.3895621622982053,0.56854787377148797,-0.59719542768932943,&
        -0.31184972732766247,9.7622804788177031E-002,0.51852113814026701,-1.6181141435409012,&
        -0.55269544114526525,0.12544891484902215,1.6851464500855253,0.79421215461147443,&
        -0.68272537422197899,-0.37252288596720812,-5.0064646294400899E-003,-1.1331749906433783,&
        2.6576530717019684E-002,-0.38392707389511443,-0.37466271783472566,-0.21998855938591869,&
        -9.8949676506983497E-002,-0.22426537066000382,-0.21915108698782026,2.0367536867106804,&
        1.8579851182012435,-0.81336713928848448,0.66540237141602487,0.44575926338214034,&
        -0.38457569744750975,-1.0450696597671920,2.5875114525919884,0.52865693214774212,&
        0.47829013092604339,7.4029348018955929E-002,-1.1702411570384805E-002,-1.0022021590993977,&
        -3.0442498397572244,0.18496153096063078,0.10137011765637335,1.9681716591008973,&
        -0.47304618800391862,-0.52058110756449416,0.98559506417781506,0.53405197717394293,&
        0.43904879036785399,0.52776748011882724,0.28931455162845970,1.3265279006724036,&
        0.83274211877621085,-0.28994915474927285,-0.36662991723436583,-1.2055152072683004,&
        1.0350791616472879,-0.42680882119780250,-2.7373364180829416,-0.83235236795943779,&
        0.69023374371424029,0.66130453383779719,1.1093894867455831,0.40980640418887682,&
        0.45839443367119986,-9.9569140460497016E-002,0.95156445433065406,0.95367114915367590,&
        -2.1992119834975186,1.5836816493324954,0.23083405466459159,-0.30058421001847135,&
        2.5794646248548041,-0.15798857360656027,0.12294106593064438,0.95221012458740584,&
        0.82509819330216394,-0.83095121999657773,-0.58470615577332452,0.40285815127512098,&
        -0.95588063071363083,-0.84023535221202761,0.35872790717794611,-0.40024834066463522,&
        0.92629721936101761,1.2121792994028502,0.19232520105581744,-1.1028652184764431,&
        -1.4690554915963143,0.93537840495044289,-0.28216880402960381,-0.54031250066617353,&
        2.8295732115470633,0.72823064129640247,-0.46904433447081351,-0.30794152507034100,&
        0.88781192976191448,0.53697565137994263,-0.16078150292560089,1.5037587202926093,&
        1.3076479006010218,-0.11749265490965889,-1.3522302833463771,0.91493299073745082,&
        -0.89519448558705517,1.5075853467167522,-1.8457729911932770,-0.13781802930044582,&
        -0.50210274041422520,1.0050455454934364,1.1064831945232592,-5.8184584651681630E-002,&
        0.44587723094978832,-0.64745011945563746,-2.5901487925634319,-0.75227855355392192,&
        -0.38605105804897216,-0.35600709236438444,-0.66360249509496694,-0.64177286374440923,&
        2.0130391949419280,0.54270468547906403,-0.76127177448479844,1.0668410775615385,&
        0.34512788884836182,6.6756661459686541E-003,0.74109048675888067,0.29207677164428392,&
        -1.0382722818780727,7.3073843207648939E-002,0.10597362507605070,-0.66387496963921211,&
        -0.84902549679508865,-0.96120236355545141,1.7035714995624707,0.12663981589531642,&
        -2.0933393887119887,-0.45378490245926084,0.12696089651984233,1.3936710998305475,&
        -0.59882893641145640,-1.4360051484540424,0.52482188900435944,0.44104187247439480,&
        -0.71847578162210657,-0.53336493308289190,-0.49381563590046490,-0.23042962201550163,&
        1.5486920092134919,-1.4800234883392784,0.80256510576958695,0.44875122777741266,&
        0.57411967188093449,-0.33586356209126822,6.2789258320881773E-003,-0.81650621319719963,&
        0.48059139598344058,-6.9533759554367622E-002,-0.76234119655023458,1.2534487958843361,&
        -1.3347231730599236,9.5496931066826052E-002,-0.88393916494536973,-1.2153912556022635,&
        8.8984713914221761E-002,-8.8311856401465008E-002,-2.6127967553611535E-003,-0.50246560862467726,&
        -0.24260617865639605,-0.61435539290283303,-1.8457201973264643,0.46023028685612433,&
        -5.1392511781760235E-002,0.70598192367853885,-0.51318834275068259,-4.9366553715553894E-002,&
        2.1669909059973276,-0.22855628349106560,0.35766000620819610,-0.22014126635517489,&
        0.96787812924424110,-0.63042392101149580,-2.1135971821473492,0.94138384433399680,&
        0.15517961086636478,0.84195869661160694,-1.8024130760119248,-0.40817904185773823,&
        1.2242151506981234,-0.66725869061345711,0.22387536501443173,1.5966091633050246,&
        0.21689718967491742,0.18909755022028435,0.98610731243587402,-1.1972747318497861,&
        -1.6662264981705206,0.18403089176420886,-0.20741763703909491,-0.33692795296387684,&
        0.49658118434896276,-0.18814563611593152,-0.85426884094035738,0.22467251821384521,&
        -0.56187111776302978,-0.36979874594516138,-1.7734590811640809,-1.1809405005373896,&
        0.15548496393964512,-0.51791053144623322,1.2185227231900115,-2.0214970469986082,&
        -5.2047858197560772E-003,0.56817933630550188,1.1949427806310111,-0.62608631272281390,&
        0.57087192599081027,-0.72565062241714906,0.71478876156453219,-0.83902044440494183,&
        0.34857873047088955,0.14880603922958538,-0.31511944550343340,-1.6888040225005616,&
        -0.38520585063245094,0.68450776834871796,2.9654010996046281,0.76051841136196852,&
        6.2565946739342154E-002,-0.26933701024382156,0.47515060189632974,1.4050104372494179,&
        1.2915234872756660,1.4398643867248901,-0.45729992333357472,-0.75851432161051358,&
        0.25109447884553288,-1.2618966170785133,2.0209674975715934,-1.1451349210229882,&
        2.2120400704720868,0.20473318687920289,-0.93962185451153135,-1.2655192870017729,&
        -2.0603057254018311,-0.31256304902724780,-0.36418234041079184,-9.3406392880497305E-002,&
        1.6393596986454302,1.9433313602976747,0.80511749845132508,-1.1394071706353159,&
        0.31447294164596468,1.4059295170731295E-002,-0.13593483577979171,-0.23313903564674715,&
        -0.24783263390974625,0.51585338208229703,-0.74653247500162923,1.7723658905984494,&
        -7.7152433635364850E-002,-0.39486668351993198,1.0528544700117253,0.28873008977003406,&
        -1.1083006698845015,-5.1702030014764082E-002,-1.5626457098565805,-1.2755408675525890,&
        0.86290829079127773,-0.44131555636064523,1.1720269120868421,0.93049189287965173,&
        0.45761635345858576,-4.8530799535314133E-002,0.86123662938591616,-0.81004223671500064,&
        1.0440515203075647,-0.41088600089058963,0.17273181300972246,1.4895206557784062,&
        -0.28889982241967049,-0.55091271124046504,-0.69803435578399187,1.1428245349964481,&
        -0.24158459631337870,-0.14399287406899514,-1.8420060026191143,-1.9748214631755909,&
        -0.20691602175774035,-1.1114168381147365,0.88701261332873627,0.71544853365317751,&
        1.0163626129453627,1.1339191533934110,-1.0078638308223149,1.1090122003094216,&
        -0.61641250461631514,0.69388206700415944,1.0173275146350664,-0.96403959856389709,&
        9.2572801865085541E-002,-0.54491210897674647,-0.58236339673003068,-1.9904465805007963E-002,&
        1.3789474674529936,0.20739900102263367,-7.1913482992447347E-002,0.31136665296978011,&
        -1.5637489111881160,0.65041051300135810,0.59791964702479250,0.15045554540174361,&
        0.28418261732487854,-0.93077548831858647,-1.4132569931632128,-6.1972354375649255E-002,&
        1.3099880796414540,-2.0112088342693246,-0.43786014475854812,0.86044940068392284,&
        -0.38585712167412611,-1.2068535786156551,0.68431990671740128,1.5067431373645588,&
        0.30478077166212186,-1.3944129028792380,-1.1005550139985427,1.0410059310517905,&
        0.86031615686736929,0.66928672534489153,-0.91912876519629905,-0.58855076541987472,&
        0.61695207696955023,-0.96950932336816553,-1.1793063599948392,0.75807817613627504,&
        1.0816963619586544,-0.97936056190929577,0.54791241848006855,-0.53112505493600770,&
        -0.45543036600256998,1.9959508079428063,-0.95305453168219378,0.57312423729637851,&
        -0.25757599416449617,0.55172825386169266,-2.9978179027595475E-003,1.4678847219911945E-002,&
        1.2953023751388606,0.52877548503134941,1.1892551074222617,-1.1164954131720557,&
        -0.28712550608584170,7.2000005487687993E-002,0.19236751934211749,0.11895306605430521,&
        -1.0582612379090997,-1.6435282581018229,-1.4406787161959029,0.22934931062457389,&
        0.43397252419360427,0.16356355119689764,-0.95999470433259548,-0.11484275207696924,&
        1.5732863515716866,-0.73681716183680812,-1.9523469931779833,0.30648986967382080,&
        0.14612998837241234,-0.78289480415355051,0.71808485746143880,-1.0687050728389229,&
        -0.37603766648623504,-3.9703113781853303E-002,1.5517811288048422,0.17907567603958385,&
        -0.30946307536522200,-1.5919504519916707,0.30806029821182351,0.61794158093525120,&
        -1.1279864972069809,-0.43131029650335267,-1.5222442952442863,-1.6030617033848796E-002,&
        -0.77074053021607813,-1.3898067532309797,0.18092066625514680,0.30030552672429245,&
        0.41814359538285795,0.41649693219937728,-0.21237142199567341,-0.36714682765301998,&
        -0.49305255397675879,-0.19888346250802863,-1.2259938797014522,1.2542787622600124,&
        1.2061125388576774,-0.90417403705918942,0.86837643976729773,1.1533521329737761,&
        -5.4053068884335281E-002,-1.4219207798234281,-0.45745237393137667,0.17981023959805431,&
        -0.58195275525895818,-0.53441419642870680,0.14231170507435970,1.7437310924625309,&
        -0.12748715384038478,-0.23047426508497518,-1.5899449560155328,1.3134746284920773,&
        1.0420836366121273,1.8568127395908072,0.20910778752801706,-0.24450917331423097,&
        -9.5703986511746247E-002,-1.5135968743055579,-0.28354451106194162,2.7767901867488152,&
        -0.40357111223388453,-1.0674271126117596,-1.8141292678102361,0.94976614105051183,&
        3.2508368919693852E-002,0.22587027175022070,-2.3625261156643099E-002,0.67680502096481232,&
        -0.58100650002566967,0.14600830183958285,-0.29096691077720360,1.5927072778457638,&
        -2.8042915090718674,-0.96487441249859462,-1.1535289899949930,0.28878608561329783,&
        -0.26954694792259104,1.5376616300237169,-0.96067781966371335,-5.3018644591815392E-002,&
        -0.27052579731688570,-0.71384167305498136,-0.60469805345897798,-1.0084413448418443,&
        9.6782257198981300E-002,-0.57458782221806071,1.2482481050360208,-0.24414990837891390,&
        -0.23329059023747800,-8.8449074329456590E-002,0.35458263917472610,-1.4587489771845923,&
        0.49148854919838275,-1.5161591429762573,0.74543039215003160,-0.35975227449201502,&
        -0.85948320359017172,0.72736720435008562,-1.5950238349287829,0.20554740506486982,&
        -2.2117730369504431,0.21419988231526027,-0.72792643944559676,1.2925366412501378,&
        0.49009447359241032,-0.74233573006235631,0.55873526543220031,-1.7554082705468272,&
        0.99482210602762666,-0.63611193223896256,0.34464921337400450,1.7604536577758114,&
        -1.1161282372646715,0.34638611460803270,0.96222779634784394,0.64390432174935064,&
        1.0763466755169671,-1.0377011140026762,0.69367624905269265,-0.44845765446662422,&
        -1.5609495793932102E-002,-1.0469362194925276,0.94117727456387612,8.0479701515687826E-002,&
        0.80267777303340737,-0.70486301944328122,-1.2145656170471824,2.3828283565662702,&
        -1.2723610189319092,-0.26476760564097168,-0.16477541006160532,2.2346575649509672,&
        -6.9858393831056215E-002,-0.61233179580677999,-1.2003594237496147,1.4430278833951737,&
        -0.23481748643523256,0.95756587988969355,0.28959314640494577,0.55637280808034006,&
        1.8257399992919618,2.1612556382876780,-0.27305017880529359,-0.66891899412115119,&
        1.9260141044115147,-0.22099897761225901,0.70055374812478743,0.11896550069797635,&
        -8.9375614619098764E-002,-0.68845293936535235,-0.64180446153526904,0.45412606978820624,&
        8.8663366047318740E-002,-1.1440918721915052,1.0620698442774379,-0.19470738561875542,&
        4.2934241496360090E-002,1.1326737437386731,-0.80578784649210833,-0.85669332933423337,&
        -1.2519926209025205,1.1494332679459383,-0.11913301131685833,-0.64837774538833504,&
        -0.34912506310672542,1.7328008103259973,-0.61285907964489716,0.11558627913295047,&
        0.10466307950816742,1.5019945398233210,-0.84847019975857041,1.4636590521229809E-002,&
        5.8514559576236573E-002,-0.88944282696056920,0.16484977519696345,2.5543993616085965,&
        0.50578736177562167,0.36439136240829706,2.4926968392747555,1.7011829797147684,&
        0.69089907913033244,-0.57325566062508126,0.40488578886896481,2.6584168956098112E-002,&
        -0.95228366141968901,0.31445577946860354,-0.36539941853526425,0.29158171643302205,&
        -0.67440229961918308,-1.5115774047377015,1.4126204788835763,-1.5546693009506134,&
        -0.73281482184612046,0.57946346650123393,0.47707093564362346,1.1877934917670141,&
        -8.7456030545419505E-002,0.78569429267763802,0.78326459234990398,-1.5454684799315170,&
        -1.0341781627637845,-1.7564653868747417,-1.6929481176115548,0.46042398764937703,&
        0.64108905178525188,-1.2679801252651335,0.78340590279322164,1.7740937822235590,&
        -1.8714966780850180,-1.0883269232830939,1.0708024492962627,-1.4313395257565562,&
        1.1336359696760752,-0.79702666334452477,-0.27688375324202380,-0.55108759520929151,&
        0.45701574008277795,-1.2271012888634099,-1.2217022336706562,7.2806637651653032E-003,&
        1.5266908954492828,-0.72033442779684265,0.90658369045687526,0.73738613826397770,&
        -1.1999564329803902,1.5898661150462714,-0.21066528448396393,2.6765636873391983E-002/

        DATA MC16/-0.78403458991405384,-0.21677771798886708,-0.55679157999588846,0.56274022534665524,&
        -0.66660214775757476,-0.73776560196211816,-4.1050119200918257E-002,0.37800475337061046,&
        -1.1113528528058412,0.84205487017630154,-0.67320774276172912,-0.38636520747286485,&
        0.25749151082074778,1.0673508904484732,1.4419769528065829,0.36046990139548246,&
        -1.6306404466272399,0.81210686762212025,0.36362371076909034,-0.90204296470939160,&
        -5.2389220202963188E-002,-0.85074426770276612,-0.77029273237084039,2.6923070293607148,&
        1.0601106206415143,-0.96495785406373236,0.83751031660780750,1.3158883031638919,&
        -1.9750530005912321E-002,-2.2337176989400795,-0.43466586371653732,2.1399210600534666E-002,&
        2.3497144192633401,-0.12507601155436848,0.44593521747734760,-8.9827043282855637E-002,&
        1.1650555456567577,1.3975566070484582,-1.8726445716072055,-1.5466010176244529,&
        -1.2354768848415245,1.2262622835557704,-1.6447521253360209,-0.95608648142424391,&
        1.1447474450901949,0.39888954594044435,0.75889056716812697,-1.4128888408110485,&
        -0.80438822907767926,0.59105119485859037,-0.81053301602957550,-1.0065944158110895,&
        -0.31559367378063857,0.40300670547316414,1.4644553591264220,1.4145299966141673,&
        0.29264206446883140,0.19454923608043570,-1.6161812240499402,0.12795983661200949,&
        1.3101679007423073,1.1076135899963482,0.19846703593123460,-0.79202368403611678,&
        0.69447775209211116,-1.0232674136969360,0.33206141335426337,0.99265266496974225,&
        -0.52413146121798371,1.0188066133792641,1.7776272091727316,-1.0551136359437743,&
        -0.50033901658863877,1.0685158742019065,0.15559888964502241,0.19879781764195831,&
        -1.2984988427339867,1.5069941703087586,0.10731783785666318,0.74426198944801980,&
        7.9256486140738935E-002,-0.61587631518708785,1.8324723642839658,-1.4308044348069706,&
        1.8888591726412043,1.0237843563420661,-0.41586778856769341,0.63196637820870083,&
        -0.30593222891716071,-1.0011729242199798,-0.39697138982679492,-0.32132701494492277,&
        0.60226061934888619,-0.35236786757463828,8.8727762557332474E-002,0.31229088857575349,&
        1.4507344623888363,-1.3743007318070137,1.2458038544536219,-1.6838422202831593,&
        -0.42021937610004012,0.26227497821198759,-0.34789202307156647,0.48099486269049035,&
        -2.0138009325456392,-1.6663578118144406,-1.0065993346251187,-0.32571915294827830,&
        -0.64506082807002074,1.1054134088355387,1.1135008388005534,-1.6936037424685704,&
        1.2021450160000888,6.6762386236537366E-002,-0.68610927460047066,0.42689291353014175,&
        1.2801901006636884,-0.73540449952647013,-1.3603586314364675,-0.63579206606797856,&
        -2.8878493785413708,0.89120238351710412,-1.1475226411321744,-0.99837789866336313,&
        -8.8857318059072737E-002,-1.3353498503724051,-0.16845218160338404,0.78583258368600684,&
        0.61986127969276805,0.73259123477912236,0.21638695931942376,0.21357041942055272,&
        -1.5013219411723668,0.60295061657234572,-0.36980424738591061,1.0169148619872839,&
        1.5510913805535910E-002,1.1547422573859933,0.55496163436895485,-0.59096875104770608,&
        1.4546611779808631,0.33347415713713013,0.87245914421783199,1.0672323977906280,&
        0.52192678646533075,0.10275454967666472,-0.61593803353937604,-5.0511770147077140E-002,&
        -1.3561758965708377,-1.9185434126503567,1.2446316076884825,0.26212092748018362,&
        -2.3607068667031452,-0.70890977728513704,1.1967349969568295,0.14276331297075742,&
        -0.74164487102821353,6.8117504704196308E-002,1.0288082235358091,-1.0183630064004505,&
        2.4724906219161396,-0.41971400127777103,0.86352593707237246,3.4731665002512270E-002,&
        1.2885682844064072,-0.16947186819329846,-0.76738545747147069,-1.4249490059113732,&
        -1.0100346475413986,0.26098149847315966,0.37895674115741551,1.4078102324308031,&
        0.86904784929147139,0.72529092330229550,-0.72819890918600194,-0.59962979839289265,&
        -1.0641008268139294,-0.52790542157118392,-0.47489403639762789,1.6134769919566212,&
        0.42060577556722162,1.1503881763168260,-0.93868467241666720,0.25716045898686030,&
        2.2931013597295817,0.26424345527872295,-0.57649828559223892,1.6238920263485102,&
        -0.32679861575538599,0.54924271048841278,-0.34821417104992064,-0.67835671284100352,&
        0.52380462777336201,0.88532051512715204,6.9195840376282833E-002,0.16287391136995005,&
        0.37475983074772340,0.58260081409834263,-1.2229220089276747,-0.93518942542536465,&
        -1.0388821788449436,0.19823024606303821,-0.75466724117579653,0.62103613264696778,&
        -2.5154542481800188,1.5817958537432784,-2.3594795402024565E-002,-0.18044099730796070,&
        0.11784061675897371,3.1847389417156429E-003,0.73678244382032720,-2.0018119482892911,&
        -0.52214098208209203,0.47227827293467550,-1.0852602697147855,-1.0744283320143695,&
        0.14694181094384809,-1.3178573845282253E-002,1.0092864179802246,-0.39123245681178842,&
        -0.73774971962148106,-1.3772601010642767,-0.35749948212982324,0.25660243965938406,&
        0.84243403623828350,2.1298210108411859,-0.21490300102326487,0.74870360935904290,&
        -1.5174154345885962,0.62499545126123723,0.70827003899987284,0.84361327030096767,&
        -0.92863740625931346,-0.10964308919218986,-0.92764928696036097,3.4094720893785312E-002,&
        0.36225371201127865,-0.88184427898395845,-5.4546216056963172E-002,-0.45419778481669459,&
        0.48674628953819343,1.1233504478759604,-1.0375370391438277,0.56440164896693346,&
        -1.5964849525987019,1.6835993611368927,9.5451858814222329E-002,-0.53178006268626898,&
        0.75331059721687399,0.94850840475613274,6.4442395259261209E-002,0.57307210048876844,&
        1.1330555325973692,-0.31395053353544566,-1.0924780100292426,-1.4345570474179743,&
        -4.4550954155404568E-002,0.84266923597504417,0.82824692654679999,0.86678101214326830,&
        0.92671177024365625,0.16320800158862289,-0.99018398107359340,-6.1711896960480059E-002,&
        5.3827520722761431E-002,1.3516964124066337,-0.22671677826961187,-1.3440381212833867,&
        0.91002609669373469,2.0393245840586820,0.29554182921932687,-0.21350993982597377,&
        -0.11563413877316152,0.85084761708305279,1.4778916657968901,1.0692330017518541,&
        0.69243302181858957,0.98032236624203972,-0.52443702931470382,-1.8334253708772599,&
        -9.0860897302202495E-002,-0.50552343394808563,1.7924948058729052E-002,-0.76943234709085506,&
        1.7388902369419235,1.0300353868033343,0.50250524762282900,0.58896537545186622,&
        -0.32114600652361325,0.68939501146090931,0.20123070328469655,-0.20000299837853325,&
        1.5065102229778309,-4.8041152779094057E-002,-0.18802828558055176,0.14752626581352424,&
        0.64934250976675367,2.2632594426891273,0.93007775707628093,-1.2314588953238608,&
        -7.2710001407867750E-002,1.6100339010367335,0.29728282894968044,-7.3180469001527582E-002,&
        -0.26452017371918368,0.41659463514292094,-1.1079683620804335,0.20753951952309072,&
        -1.8571413286970557E-002,-0.87084534692695648,0.23678946056225736,0.26595722698241653,&
        -0.77025953466263775,-0.47209024386941828,1.5663089870164695,-0.80364017097733098,&
        0.80302602150972380,1.2765241992851962E-002,0.33294478407431727,0.99651433449594418,&
        0.43887414709332107,-1.4624961327230115,0.29872653818339334,0.48322712999414058,&
        -1.1416001919980114,0.95893500942670873,-0.74503559966764787,9.4976544830632642E-002,&
        1.9330448405102065,1.0955248545694245,-1.6585049506263918,-1.1980790028989574,&
        -0.33187250506684740,1.7192653731883349,-3.5064321202410943E-005,0.12155990585307436,&
        -0.21931786740410736,0.32480063814199944,0.54223317638473834,2.6392237483241661,&
        -2.2382320276871654,0.57177611247816851,-0.70103775210839847,0.18647580892454282,&
        -0.44269116280937221,1.2256545566883563,1.3686674424366907,-0.80776966936746830,&
        -0.47298268025598400,-1.0260904127905344,0.69112200273745950,0.50746616253528043,&
        -0.69472762746335748,-0.89741446553861370,0.19310745568585819,1.1570520035231047,&
        -0.66763824646062464,-0.34253417786074497,-2.1183555632996693,0.40667478294906384,&
        -0.74512168431111991,-1.2023217897814675,-0.49270361384650130,0.83174833341597920,&
        0.42796080798522518,0.73645970175530939,0.21268527817845667,1.8623324007637641,&
        -0.51307997650343362,-0.13146534243207561,-4.7971835630217771E-002,-0.94907371950091080,&
        0.72340439508082321,0.96396619715641818,0.40534846746454617,-1.2525297784992189,&
        0.23855201602850007,1.3877156949140657,-0.36434632332008748,0.18975954499442868,&
        1.3945140339484434,0.45587834481969408,2.2209012768139256,0.78832499385071753,&
        -0.11276005873003220,0.30638447704322430,-2.0339905897051551,0.11449648813452150,&
        0.17391533519301713,-2.0208557586605038,2.1482314286275175,-7.7150011954642925E-002,&
        -0.87405671915785688,1.3297246475732538,-1.1841965221375534,-0.85777140431024446,&
        -1.1445090493119956,-0.26404732873016379,0.68719348304636407,2.8409050320495920E-002,&
        1.3048604274043014,1.2188394412032617,-0.49071926285045320,-0.18032652572301111,&
        2.0774659928248913,-0.53220435245986963,-0.54095056515817419,-1.0779374787789509,&
        -0.67056856750405969,0.11187609808992528,1.9068181458033207,0.53687284022200410,&
        0.39810739223969305,-0.49056737732171207,-1.6966907070547603,-0.68102271124828306,&
        -2.4210947422684339,1.9449960475106478,-0.17003870351578917,0.51796485553580796,&
        0.87735643618881598,-0.46505820267622394,-0.75486278185208755,-0.87786281492909701,&
        -0.21564733449392021,-0.47155325641931911,2.2907230370293679,-1.0709681843409284,&
        0.40514267235996315,0.37437593602610519,2.1903354509569848,-0.69471370399570875,&
        -1.7160475993947983,-0.64015138397580518,2.3529920444347362E-003,0.44065015216070041,&
        0.41627265725429297,0.41430072897413101,-0.41611923485031155,1.8101014787940439,&
        2.3697331535696729E-002,-0.51121609689198022,-0.28004980156207598,-1.6226670895929514,&
        -9.5336022712812399E-002,-0.26265321140148656,3.8372892246207602E-002,0.67764472685543031,&
        -0.92067833754241979,0.62267040589465161,0.35492133705795620,0.19878424394506278,&
        -1.6299481197247241,0.68841033707707466,0.19802806648390986,0.97978281651530685,&
        -1.5690426505041859,-1.7580982475479824E-002,1.2359142055751520,1.1945168501578258,&
        -0.35579251330595879,-0.96736432871008360,0.56165520482097586,0.25198815517409251,&
        4.2106067889131842E-002,0.36685766999233810,-2.6498864044984702,1.2669544103811892,&
        0.85634971715036201,-1.0879319225182174,-0.61374448614815735,-1.0546271304612722,&
        1.1180825503343608,9.5996910190832202E-002,-1.3138809446441945E-002,1.5494703320706913,&
        -0.28099172557513052,-1.4793315836700833,0.68793943612644481,-1.5170544546836848,&
        1.2176070892301669,1.3529524646466675,-1.6274649123745950,0.66638695208219312,&
        0.25284200984623384,2.6252677989772595,-2.8502110924975588,0.51285692208426781,&
        2.3902573441816810,-0.71628221564062000,0.35381702371938306,-0.30517044096843043,&
        1.0124790781812785,-0.32982158211817281,-0.15720295093859277,0.22115138080268026,&
        1.9716749946900667,2.5803293773024905,-1.0101492426622316,2.0211453046853434,&
        1.4848707875523013,-0.79038255445803718,-0.64844101675623478,1.1804965960974707,&
        3.9759226195460531E-003,-0.58715416412177324,0.65512956673144651,-1.9882769279571095,&
        -0.62720965843223642,1.0627044780604136,0.19959940785791067,1.5030736201468515,&
        1.6807271820206691,0.25427623703082747,-0.75075822773594159,1.8603849976262710,&
        6.8377515617235970E-002,0.65392081479017528,0.48848775601633859,0.92155560816542426,&
        0.74354656709565303,0.33210208701565336,-1.0712827652253378,0.20141550354759238,&
        -0.45156029823903965,-0.42863666536283862,0.44134063778612415,-0.47419003866314346,&
        -0.61385864005829749,2.4320804279062833,-1.1184754314715208,0.70220545647974630,&
        -0.91839430957272128,0.43595769240975729,0.26983014669377381,0.13711648470995438,&
        -0.39087631785638888,6.9943330057422981E-002,0.16795378557513493,1.0241765468789019,&
        -1.7009246648979888,-0.21576704711792088,-0.87018671647510759,0.49324835799708933,&
        0.11396283567397000,-0.12949481022584181,-0.46411404779533111,-1.4783342717140062,&
        -1.1474928144778782,9.1331970759407868E-002,0.45405980277317615,-0.10300929673490955,&
        0.68634524073720826,1.5338977224576036,0.21137988283584230,0.83106097974456095,&
        -2.2769766736897150,1.0410728977334960,0.99035621180197098,-0.22969828610140430,&
        -0.29730160076130435,0.11472742530646814,0.84933415608450891,6.1645167520643120E-002,&
        -2.1072269672567252,-0.12544727470731165,-1.3539648241534423,-0.87923459199278731,&
        -1.6410819295348908,-1.2794450069573389,1.1553913889403746,8.2223284411151773E-002,&
        0.37033044031225315,-1.3464467002805733,0.47224996968382782,1.7900272502771051,&
        -0.63381064173614898,1.2028679422301396,-0.31261258542887210,-0.75208486895237991,&
        0.42722797203711688,-4.2690272089044468E-002,-0.84594549792919582,9.0992703242571152E-002,&
        -0.62132805431084770,-0.66660697012748937,1.4310754709834117,1.1012748036712272,&
        -0.78137383913423275,1.7794037739672004,0.88174853075316817,-9.4596679966574004E-002,&
        -0.26717294625134674,-0.79861853887981404,0.67628263088767471,1.5158367515853906,&
        0.27452454139016330,-1.5549872586148552,-0.56277608889782904,-0.97210145276132154,&
        -0.76582384028810269,0.32587532282066173,-0.57047963486794739,-0.12786634879661776,&
        -0.43825163757258312,0.88133304760881992,-0.65159739443058717,-0.54465758631193850,&
        -1.2828654078586932,1.6329486249027834,-0.80236043165508664,-1.4854596046192698,&
        -0.70555491332228459,1.2378809363168068,-1.7027280974646566,-2.0279863224624273,&
        0.77935123344664581,1.0810952309094619,-1.1743235984482125,-0.14798954298153383,&
        0.96794910420257696,-0.29104339667843654,-0.67665518979287853,0.62804568726058652,&
        1.2409267762371972,-0.36677539557500144,1.0068315330597468,0.93603223611690922,&
        -0.50853462696055540,0.22749470749709530,-1.2588500421964985,-1.8697839079236496,&
        2.9751178410137909E-003,0.85375147818400865,-0.81436539785053097,-0.85650222620570915,&
        1.0771024583361095,0.34405696954803772,0.13286392685753223,0.81580955757073925,&
        1.4491943008073149,0.20847872448414179,1.1146217962748595,0.32549198676386526,&
        -0.38308903230136632,1.4789402609324782,-0.57052797191227822,0.59248184299138629,&
        -0.75613821473123377,0.20476211313713730,-0.18750046076686669,0.11466803182621688,&
        -2.2999151003241640,1.2819079477369344,-0.36706506496373653,-0.18143183408022462,&
        0.43368079826362993,0.67532767043016073,0.39191695369830576,-0.52569827095847199,&
        -3.9411200866439754E-002,1.4288801126038675,-0.75476054509739843,1.5356512187942279,&
        -0.12186630404188400,-2.5499166208372479,0.51961765897947354,0.50391792994826090,&
        0.26378564045503355,0.52132945881822645,1.9336316435377194,-2.3771899420109865,&
        0.23147225950915656,-0.96485772910472922,0.23765109068939275,0.93380896254825330,&
        0.14813169010624572,0.68076608791895965,1.6331981218648220E-002,4.5166164905985504E-002,&
        2.3951467881139620E-003,-0.25265473206962302,-2.3358860737108205,0.20478067250965531,&
        -0.54796619814993364,0.67742352770263858,0.27570341290360101,-1.0981521737797959,&
        0.57458660375395676,-0.93210151300575583,0.55088426699107174,0.93313128394127554,&
        -0.89178924658826775,-0.74422006040173372,0.51458813443737794,1.0579593838519348,&
        0.49864649537565520,1.3613293872391741,-0.23371648360483382,0.38032058779329780,&
        -0.77706928172861123,0.32910217789631219,0.36388059047024263,-1.0266226387826396,&
        1.2144825233589598,8.0022855166614282E-002,0.16404415128843569,0.70844347575740441,&
        -6.1806286906406792E-002,-0.14002666475983036,0.27112263405865122,0.23496372354507894,&
        0.52540274276831322,-0.86265242082372262,0.14706608955106432,0.64569112402973117,&
        -0.17201779477404314,-0.88657079498095048,-1.8650936442063826,-0.28303884362602483,&
        -0.37113542359771978,0.81583503297875237,-0.68271521434794524,-0.57115606096662574,&
        -0.35984082486108149,0.95378122196179671,-0.44967034416218621,1.1469121611332389,&
        0.69889808475607096,-0.74887074954284161,0.77737082267655055,-0.12429856122514435,&
        -0.31424768142375398,1.6411667538496644,0.35382374484388029,0.12524124020416338,&
        0.26933749349081332,0.86753776437983798,-1.0311334395365854,-0.70689495264397717,&
        -0.35513746375606847,-5.2287366748884475E-003,1.9400884998805460E-003,0.13596299938178250,&
        1.5764791835627558,-0.10464057618950735,-1.6695652750602539,-1.2668595491015762,&
        0.57934061585076690,0.27689894654683256,0.30912902088182653,1.0024027439328320,&
        -0.98456291471847690,2.4311486812936138,0.19278592123306956,-0.72242859446630714,&
        0.70615379031658876,2.0104326613643999,-0.64944111731261467,-0.36208207039135171,&
        -0.68480770312092065,-0.10806638939558244,0.11687584497654604,-0.46020744146677817,&
        0.75636576658011401,0.89828082761858996,0.27937211052040073,1.7324521015479355,&
        1.0117794074560924,0.60925680835343843,1.0361715393348108,-1.3087706744781999,&
        -1.3583623210299449,1.9999398295151825,1.7518688707630814,0.22634660573098009,&
        -0.37374465360857212,-1.9742328157961331,1.3623627752050189,1.3791460410976339,&
        1.3793180135626861,0.81406300694965528,1.7101447623677359,-0.83123495195442554,&
        -0.29530357811252728,-1.4893401678248390,0.27194007852465713,-1.6040655194014489E-002,&
        -0.24409596277302886,0.62016608475502155,-0.78704490756134060,-0.65961279466223111,&
        -0.16537184562204862,0.96057727713479601,-1.0914617132740685,1.0144431122449573,&
        -0.51440929642168376,1.1076355292671956,-0.80418627551708366,8.4908756427008302E-003,&
        -0.12265190690519875,-0.71933947012319233,0.93347600363768923,0.23006328126181161,&
        -0.42353005617901440,-0.75796130642759207,2.1986515277290817E-002,-0.65424773182666940,&
        -1.7309578732435972E-002,-1.0771611697173600,-0.92659594455836780,0.42595929973698765,&
        0.62299741930599406,-0.68055406328887647,-0.36650802552042760,-0.62959648527378775,&
        -1.2592624458582393,0.69043325361463403,-0.77921009559871524,0.84505433279855813,&
        1.4619749172796250,-0.24254020585440181,1.0315364472011443,0.72588494118848879,&
        -1.5551963901962660,0.75742755718344645,1.3480768691275584,0.60254269258853765,&
        -1.7972170114688157,0.38037251883801143,1.9525242442330291,0.21547085084122786,&
        0.77617762903663867,-1.4006093751495456,-0.89369406682285812,-6.6094403198742699E-002,&
        1.1572377086005188,1.5926958830911542,1.3319313624857123,0.31152392425753667,&
        1.4338179832497440,0.51856352212750478,2.6674618522482631E-002,1.4298247055764399,&
        -0.32606410657032148,-0.54853328729419459,1.3717395133729167,-2.0811142207843663,&
        6.6686773586261711E-002,-0.93318121474989879,-0.13542149089641642,-1.2649244953027550,&
        1.2758720758659967,0.51465086802927795,-0.97167147620522998,0.40544580390582430,&
        0.28353817429534861,0.42321383996575529,0.97046932056339430,1.5583494535650213,&
        -1.3421658316531786,1.6492495037216564,-0.38504129177686908,1.2534048671320965,&
        -0.63438357812280399,0.92947545917867813,0.27644016360871226,-0.72503814604056360,&
        0.43189691716141704,1.1199500791142392,-1.5403462855507024,-1.8376952911625934,&
        -1.0022980873870169,1.5112361636657086,-0.29857133053174850,-0.39543889063083154,&
        -0.25073022141252493,-1.3719128020362219,1.1478374505629636,0.39493881385275736,&
        0.82672868408841560,1.5644659246961066,-1.1419554637655902,0.96703199114929583,&
        0.48530362363906776,0.53119687311931918,-1.6041751502131838,1.2935305731470026,&
        -1.4662777941012253,0.58474071762339674,-4.0843432892970030E-002,-0.70432096556211510,&
        -1.6848984525523141,0.86970130913860833,0.61844873122844979,0.50660437752165333,&
        -0.20210882778709655,0.94539846582724174,0.25778048529686282,0.29620382899140513,&
        -0.89463588353535106,-0.65496082586717930,-0.37806370980997550,1.9444197419119793,&
        1.5367199613084606,-0.79200448877405283,1.2219798428782709,0.24772245272800295,&
        0.45915626378376739,-0.38329429587196218,-3.8370206156259391E-002,0.25513555798815946,&
        0.61589040500247982,1.1215873712859226,0.52442669437245948,1.1188340509845596,&
        -4.4799567068743155E-002,-0.26529722208046880,-1.2800423854802065,1.2579683802132031,&
        -0.42906463401000822,0.47026130106282688,-0.22202982188830903,0.29661921347293035,&
        1.0181878775294413,-0.34303560219839524,2.0565789413988584,-0.75963722711244830,&
        1.8196397397141455,0.12285813500781799,1.7744797297829338,-1.0024288819794867,&
        -0.73313967959839388,3.7907641451969183E-002,-5.7231782559133013E-002,0.19699263363957462,&
        0.49405866463119064,-1.5558283520935505,-7.0718391675060638E-002,-0.57682358053746119,&
        -0.92316288128583157,0.97765419349389382,0.96746956860671940,-0.41026541096981956,&
        0.10639615338874522,0.57732266990395043,-1.5901396766088096,0.41848804252694249,&
        -1.4509025956336350,-1.0362012545057502,-0.82971837147526017,1.8838617725806803,&
        0.27347705915276549,0.90450274002088193,0.18954962501072012,0.21503947226092382,&
        -0.34821016487583106,-0.18911601990138738,0.33315570665128047,0.72361578041645125,&
        0.85599690705139642,-0.21509929151182508,1.8623504089780551,0.41041681669279728,&
        0.61250899353983757,0.73438456290763876,-0.55792384699875830,0.88268604736465095,&
        1.0186835725678929,-0.44704556968820636,-0.89935831566779545,-0.45831158887653112,&
        1.5304954736110885,0.74365219793121107,-0.28616272088955003,-0.92025052404174645,&
        0.71361268622685825,2.6500527692429796E-003,-0.92556695534002631,-0.32211958750998015,&
        -0.76997864773907465,0.97027205196782962,0.40208127513422115,-0.41362089419515669,&
        -0.75694429512377237,0.17780450946758186,-0.47125139842663455,-0.74264738502661221,&
        0.39546776215085805,0.61896962405620226,-6.6783867751101927E-002,-1.2107991306166550,&
        0.83079101951423551,5.4516453388390979E-002,0.86538420375746150,0.33485240767515995,&
        6.5123474854328664E-002,2.5267374432271428,-1.2221178339945244,-0.43532613618581734/

        DATA MC17/0.98525586307718860,-0.38682963319081959,-1.1206330833202038,1.1027958541569809,&
        0.47338963047579380,0.71015359684513313,0.16353561423641774,-0.66240850961871345,&
        -0.56030230895465694,0.80665567224802703,0.87346030173162159,0.24062541738879276,&
        -2.5115298101083764E-002,0.90276291193154468,-0.69749442320548527,0.46795972418844772,&
        0.71451849048188465,8.7958454348986054E-002,1.1375755188838890,0.55964834725578438,&
        -0.75539545701678534,-0.81233127379089376,2.0583106681303702,-0.68548164099519315,&
        2.4838900573542655,-0.68377762819309118,1.6756609994179426,0.34502911411624532,&
        7.8818513249354252E-002,-2.3908916961924806E-002,1.5887703420302075,1.9457056619488342,&
        -0.20771222338884882,-1.1344634430958016,-0.66240623440973434,0.78224815849994234,&
        -0.24723594822294279,-1.3989921663411256,-6.8310636322041027E-002,1.1073518654848085,&
        -0.82342797609687035,-1.7288245254595349,0.79224819686581971,-1.0115382057036602,&
        -0.25902707625576582,1.1715495426370954,-2.5600810163960106,-1.2736480893729496,&
        0.98231061164769962,-0.20252188126764101,-0.84210037575731223,-0.30195924334823576,&
        0.20458977617511556,0.54486724602475789,-2.7147285158395758E-002,-7.9167881357071201E-003,&
        -0.82451328134014412,-0.85002111656016599,0.70304157496775666,0.83202321010998403,&
        0.48503783526527289,-0.25139338512718662,1.1777372450345194,0.83826868937081767,&
        0.47056614611847947,1.2733172629898764,1.2927213630785170,-1.0310819488831602,&
        1.0177710275999183,1.6742604039709901,-0.90128506456282731,0.99675374558032570,&
        0.12517774989197408,-6.9407670561924886E-002,0.63816874327142337,2.8977412167163887,&
        6.8527362110025594E-002,0.79126711923894888,0.23599914937008068,0.19699521911439885,&
        2.0693797989631326,-1.3007202006679712,2.7002907666135296E-002,1.2210693701204745,&
        -9.7471598214108526E-003,0.80447863334629777,1.2172546277806360,1.0767727661153661,&
        -2.5672589246679611,-1.2553024763074789,2.3385688920639760,0.86957525139144243,&
        -0.60280355327902935,0.24594731963278416,-0.48587733401135647,-0.89124764403337764,&
        1.7715585559802125,0.92174366046641698,-7.6028160842844042E-002,-0.19141315545948093,&
        -0.18647238246883624,0.83004208894332387,-0.15792408041239117,0.56640308994983257,&
        -2.0092875204221965,0.26626075648216663,1.0380609853810867,-0.15922073057881037,&
        -1.1944296936482244,0.73855976012563684,-0.71676598677317893,-0.59369978851891125,&
        0.82760087961110418,0.23053005562254233,1.0138622273133324,0.18964303599435453,&
        0.24743512798597728,1.0503692516939824,-0.46472897862992008,-1.4261011294850616,&
        5.5524044727000725E-002,0.25207260319130281,-0.32308234651806872,1.0088140250460602,&
        0.73824729243251608,-0.52253055848005336,-0.73115816027569713,-1.9781496627641713,&
        1.5189444585966942,1.4871470905077746,3.1831777806765564,-1.2294339728341508,&
        -0.14043617632167327,-0.46900259553801094,9.0191299416974680E-002,-2.0670594359624830,&
        -2.0965301035014439,1.2405248643840336,9.8063462397963722E-002,-1.3914238207176570,&
        0.83182062436945614,-1.7849929340802320,-0.61469972018110552,-0.16239823969374181,&
        0.36481490812863049,0.30253975832479435,7.3650585823043499E-002,0.10032457303779452,&
        0.20927969719317743,0.84275318381721354,-1.2752567235231791,-0.22407592295061840,&
        -0.17268764984999080,-1.4271929791742133,8.5402577867179905E-002,1.6210702368511047,&
        -1.6424022062090902,-0.76336570513626578,-0.93332497181323426,-1.9972642218867021,&
        -0.69373272335584135,-0.55231154027888751,0.57045129197764433,0.29746148714126847,&
        -1.8485125521547641,-1.3879182306129179,-0.57726655733462628,-0.19649607060497340,&
        -0.29435799383417716,-0.50073375215797578,-0.34930574849870166,1.1511712484427434,&
        0.13212366619292024,-0.44801631409552212,-0.52091984426914517,-0.13341555580378059,&
        1.5200553288161469,2.3141777302542552,1.0827607659664857,-3.4956267460124868E-002,&
        0.46393201125125288,0.21033794047615520,-1.3637436453366669,-2.6585281729966130,&
        5.9288716732018451E-002,-1.1365339850094910E-002,-0.10320416479816438,-0.47799832297234168,&
        0.53990807458843115,0.35793201080551645,-0.46788354819780026,1.4277717350177348,&
        -1.3346440541104423,-0.52265591562872693,1.3109984819874720,0.39604001231230018,&
        0.26291915781084624,0.16969651562763588,0.85634979573763814,0.77652415558836629,&
        0.48504707443949907,0.47095180317149549,0.63637928500330720,0.34969719547567035,&
        -0.77485688037314937,1.7819756731903147,8.5629087109250088E-002,1.5617684469526150,&
        -1.9273857490753512,1.2662005502890821,0.57590679216833496,-2.1060698870218189,&
        -1.2310775740228614,0.58442194514481527,3.7523021031861149E-003,-0.62959936010799000,&
        -0.36934423507703851,0.42821496437606765,1.3209727656365942,5.9243834101632920E-002,&
        -0.39051354306412400,-0.29493148561194815,-1.4098561213126855,0.71092512878679903,&
        6.3832226739394413E-002,1.2717031631549163,0.18562481180879151,-0.36625503985126562,&
        0.21568109052892348,6.9291448581473097E-002,0.25760385844011591,1.3210563699465445,&
        -1.6792218412824764,0.93874156136822873,0.35034398323567612,9.3748076977691525E-002,&
        -0.87878631457400325,1.5614345433470949,-1.5861425164780663,1.4676985532111937,&
        -0.78548792237753473,0.21917771954162368,-0.81997830798180338,0.40003894072094859,&
        -0.26201107364967952,0.18489460334264007,1.8244807570109882,0.39785582512302764,&
        0.82951574393075833,0.31640569619339287,1.1491393290353873,-1.1158897176296660,&
        1.4066584686083379,-0.11136169290790109,0.26460534735186125,0.56022244580095759,&
        -1.9377965936679957,-0.22205027445272724,-2.8744449713922246E-002,4.0748830152881561E-002,&
        -1.0264735994455552,0.48688674337899962,-0.52776922405147919,-0.54803591294431131,&
        -9.8554355521726367E-002,0.37857885621171750,1.0530781817442967,-0.79097634107676829,&
        -1.5528607623917585,0.38995519587813121,-0.61491838904047968,1.1018778069926209,&
        -2.2538804190216237,-0.39093514057235007,0.41507263742958456,-1.2598237738326385,&
        1.1377567483026132,1.5158932917793804,-0.43557292089368249,-0.95570821384083982,&
        0.80549081973628023,-0.89303078169456407,0.46305344088300726,-0.51536860970351250,&
        1.3005175749496942,-0.15014073390616453,1.3520922742050336,0.23195343272536176,&
        0.80769040076229115,-1.5213360165642960,1.0232125743703584,0.46534236802138795,&
        -1.1157860674548170,0.43501470662119424,-0.62167736668254969,-0.83383813020608011,&
        -0.75147993520690126,-0.13513194991797675,-0.20056545644633247,1.4500810491615446,&
        0.16907831199267520,1.0416072279646915,-1.0666067074101360,0.19963710838973642,&
        0.50138358480735101,-0.52235922141036750,-0.17943384560319303,0.30823656778722336,&
        -0.25803451032170288,1.9342182784624269,-1.2279271973088058E-003,0.10149336369132826,&
        1.7876864627521740,-1.4797385522226529,-0.25524527243275014,0.55881257317878485,&
        -0.96344166666040887,-1.0824393467116131,0.78834554791399147,0.98157643643813686,&
        0.70021168570653058,-1.0659782970024512,-0.80717811999601285,-1.9195939270474962,&
        0.33931590282549656,1.6761744695964436,1.1556816111435164,0.49624965210487143,&
        0.10996819385715116,1.0960273643104212,0.55130428716060120,-0.14426550633927479,&
        -0.95228517445748651,1.7699685347290479,0.73823755490107612,7.1655772305249887E-002,&
        9.2907742819355793E-002,0.23700360091723285,-1.5752473687745896,0.51778170940502133,&
        -0.96443242732688916,-0.31650646270268545,-1.4764596033478110,0.23845664942833283,&
        -0.63738632003221085,-0.16474179165750288,3.4361607744262765E-002,-1.2425510440585585,&
        6.8852469443803771E-002,0.48234430243892218,-0.71065453260360112,0.14038434505721470,&
        0.44806760599633882,0.37710080954844488,-0.59466200826744087,0.72323642046593595,&
        -0.15782855435747706,0.24411645561025286,-7.9471231778323825E-002,3.2406547973491344,&
        -0.26540132707183922,0.34562387114219623,-0.75745613305047677,-1.4751901333997222,&
        -0.96745940664049668,1.6453139538465986,-8.1994037446007570E-002,0.74811417040080042,&
        0.41879827921687940,-0.34342495188219596,4.9993120722794764E-002,1.0838397488093359,&
        -0.92427409140018646,1.4712495455895387,0.28724335209023211,-1.8094414353565031,&
        1.0429060350962200,1.1473815229914139,-0.28342561807163325,1.2532037459188030,&
        0.24404334682816733,-0.86302080338443488,-0.66404727884063630,1.0688907296756638,&
        -0.18697622797644506,-1.9301474191301637,0.35724262099218768,1.0432091700026929,&
        -1.0199571024803300,0.60711646584466661,0.18897765828238466,0.19334359430802692,&
        0.61373803834113527,-2.9475815353975712E-002,0.86976040944573019,-0.71042755872237040,&
        0.56465088243140737,-1.7997868604946505,-0.38830912778932108,1.2995214139990408,&
        0.15629479623995274,0.53484195307892290,-1.0353156216253812,1.2294759005518456,&
        1.7584345357415210,0.18088059689752581,-0.10462914435461181,2.2266183554742138,&
        1.0078523643198825,1.0569949677901105,-0.63794090358079314,-1.1896393220445629,&
        -0.48714491786515890,-1.6179699950797068,0.69267967500657557,-0.88803983209361548,&
        -0.67606677554105177,0.23215064864408141,-0.16482636844709744,-2.9246554788318221E-002,&
        -1.6533858065085174,0.14697818636604518,-1.1104009212584971,0.56561003349544503,&
        -3.6456458929440121,-0.24156872358006751,-1.2997446996747679,-0.33127760960712388,&
        5.0226925088934816E-002,-0.53027750043751987,0.77008404575933342,-1.4080105171564383,&
        0.28057901716327383,-0.43384432884736052,1.7368113207001568,1.4312971032783262,&
        -1.1062679238220041,-1.5674593836491282,-1.5240712481978522,-3.5512183985732367E-002,&
        -0.75002795172754977,-0.34281969686929992,-0.29387386890708328,-0.83533584644255410,&
        0.71039033852810163,1.2744387952715239,-1.4304399162403829,4.2745401418475243E-002,&
        0.68019983590085731,-1.5043244944793102,-0.96323715354310446,1.4612436764043861,&
        -1.4303066355997160,0.12628242876822049,-0.56576060797031535,-0.24064447516551180,&
        -0.14745431725784414,0.30846562583770021,1.2294730246786232,-5.4799993946547040E-002,&
        -0.43078253683563827,-1.0531388815576068,-0.86792947278808352,-0.50694567764225307,&
        -1.3642224632365276,1.1089874422926722,0.96902222329875332,1.1793979498323519,&
        -0.23696300828325068,0.43061322228106436,-0.39271144770389393,0.81187644690804794,&
        1.7850708293378943,0.90551236827665238,-2.2427196133651668,-0.80289971511750857,&
        0.66743871117416498,-5.0763133620596701E-002,-0.60396465332252525,0.31521494599061878,&
        1.0456471600479673,-5.8250831564680444E-002,0.76910769821873171,1.2078687189680601,&
        -1.9437448721392097,-9.9762298423479223E-002,2.5463221554305573,1.8160720480644021,&
        0.94716895085427344,-1.2247096871808540,0.19315359308287910,0.51092055886146115,&
        -0.48119101590832608,-0.20855895680299369,-1.0210854493957906,0.47333384393919498,&
        -0.45446167071176075,1.1857527448865428,0.45716368487127401,-1.0242809062950196,&
        -0.74691209543935899,-0.73619563384672926,-0.22562110900507351,0.38681073364225105,&
        -0.28167026842535320,1.6089368834336160,-0.64370465072303573,7.1492488873998505E-002,&
        1.5478479042245332,-1.0617152170032540,1.7764129488510718,1.0770162875289928,&
        0.99368339923480842,-0.85757414623160433,-0.24441816150862355,-7.0946912353089496E-003,&
        0.58878037680151030,1.0875416287607638,-1.1916627405747251,1.2366209266458474,&
        -0.57351876746741681,1.5660503407359994,0.28882514961644123,-0.32867510464038502,&
        -1.5074093795383383,0.74425255265639056,0.12939301908244047,1.9333367635386688E-003,&
        -9.1569347165477051E-003,-1.3148553353233918,0.89915338230036890,-0.22885259676032740,&
        1.3370028403394654,0.98292000323271922,0.91526195244685138,0.61487524513054048,&
        -4.8141358741493029E-002,0.91649708220732795,-0.61103169467898788,-0.73840132878604181,&
        -0.82222295849374782,-2.4951348171290215,1.9255211654918416,2.0330364186552772,&
        1.1556402508954253,-0.73973934766923344,-0.43001937969297255,0.33536107506197699,&
        -0.31237549701090322,-1.3260009347910091,0.45389854897585696,0.71113953156767695,&
        1.5326731196297603,0.65469290563350269,0.29674576689912147,-7.3698111518450279E-002,&
        0.56296512444985525,-0.95570892737028124,-0.14504434659751020,-0.59886222024319824,&
        0.75317179186549588,0.10924801096198253,0.91318374191238461,-1.3918125554660172,&
        0.27481502737434543,0.85954934776517178,0.77763798955755170,3.1340500351233951,&
        -3.5583401142312975E-002,-1.2334451183992114,0.53664884284806003,0.45897948411802719,&
        -1.2394210286562708,1.7912209048869134,-0.50833088081587163,0.17101946791394257,&
        0.20507112385974557,-1.4875181670348998E-002,2.4071467089439462,-0.27277426602268273,&
        0.52916182253520239,-0.49922546796064565,-0.65947467584831032,-0.86219137808352209,&
        -2.3972873684861917,0.63067095465118761,-1.6353338092993563,0.18475551611292707,&
        -0.92141552150178430,0.80058078408427646,-0.31023807043147106,0.22221780379853184,&
        1.8259802029635157,-1.4265101569947369,-0.50262379420982384,-1.5902054710404523,&
        -1.0998196075624955,1.5622847869407332,0.11488187458523046,-0.74236074505098648,&
        0.47739760635632172,1.5176519174624254,-0.94156804240902536,-1.1081701911446942,&
        1.1788678473140741,0.52056151713441834,2.6194215704573143,7.0512178260512204E-002,&
        -0.42065984438973936,3.9053723404739372E-002,1.7177784566048209,2.3011874207037040,&
        0.14809570660017957,0.49756803777340108,-1.8358894817095393,-1.7437010618180808,&
        2.0799039560643156,1.3195733683334168,0.62206069780712014,-1.8746059950492364,&
        -0.13568606098652092,-1.3138469126466372,1.0609153623544716,0.79726153880580686,&
        -0.38583670073518261,-0.42554321322393923,0.67103991574997224,-1.0468780484012883,&
        0.17903729607132701,0.16606846759647137,-0.77441944277196806,-0.10545952515365094,&
        -0.28693662412617704,1.0920175643119501,0.18771513902821929,-0.61114886595642082,&
        -0.64444494867588764,-0.77773644666976749,1.1382034139393038,0.63579122384119457,&
        -0.44279614901591874,-0.84582174606962546,-1.4236595481483252,-2.5653073143634719,&
        -0.87778717548922836,0.88842825223267163,0.54058045407752509,-0.46797349312467573,&
        1.5954930868175510E-002,-0.24397425776739079,5.9708508356613905E-002,-0.70498412090428830,&
        -1.1942538260262955E-003,2.2456607945303415,-0.88049802113214037,-0.77993693877297343,&
        0.86412348411337203,0.28192563631853168,-2.2276522419097562,-1.7420745471570509,&
        0.26492466875807952,-0.73525681453356162,-1.0738796266830672,0.56357146214656872,&
        -0.20828168287603296,0.79456950346973287,1.7648539415340856,8.5432421575034251E-002,&
        2.1678871966436749E-002,-0.73198140877717721,-8.4131899669825150E-002,-0.23227288911028238,&
        -0.87471792684158789,-0.56257195101586632,-0.17886232081539055,0.63947278617694447,&
        -0.44900046460215670,0.34707715118072918,-1.1139682193592073,-1.2190847597862484,&
        -5.3734343228830000E-002,-0.94247784542145152,1.4034121039019225,-0.32491762068058871,&
        -0.15086541349631330,0.13248585605238122,-1.0506255586561639,5.1436359345100333E-003,&
        0.55652039560215305,0.62941780948347403,4.3317611770783748E-002,-6.7759712088711968E-002,&
        0.54440040493618325,0.33086768360949842,-0.29851288465162118,-0.14104416184319260,&
        -1.1542496771003268,-0.71812479363473347,1.5717075090059529,1.2981720393811871,&
        1.1637893875950258,-2.0941795280407076,-1.8233778896690489,-1.0487760602751917,&
        -0.47807206061338464,-5.6864968801317835E-003,0.55310518414263399,0.58385606388025568,&
        -8.3756893022719756E-002,-0.28587189065561014,0.34534205282618935,-0.30700024273109500,&
        -0.79376767104713597,0.38196516415099674,0.65518667165775624,0.72343950185079897,&
        6.7573634748319428E-002,-2.2800123661273028,0.16273177310317055,1.5433239495381053,&
        -0.19444494722039499,-1.7475170158726934,-0.37105969027638569,-1.2585911599349420,&
        -0.74434704406746277,0.24407417195678943,0.17361357915672818,-1.2185233403410108E-002,&
        -1.1754276539576773,-0.64956853627074052,0.33345278340018114,1.2276525284558346E-002,&
        1.0769261705220836,0.29093685864959629,-1.0292780266313619,-0.97015234792301663,&
        1.6214438473475010,6.8242769524651817E-002,1.8297283297552696,0.29502646841341673,&
        -0.68584252669033785,0.34228185526573612,-9.1902465736806535E-002,-0.61275035563868252,&
        -1.5036235825308844,-7.7143123512703887E-002,0.94364237805625140,2.3966373011400224,&
        -0.28617475180904778,-0.48154556290854600,0.65787506489646630,0.24986391090289262,&
        -0.65058936626443964,-1.0044783665875476,0.29814528140689878,0.22232082814750934,&
        0.57470357623696489,1.1521302292467961,0.98091198052242745,1.0168474270948966,&
        -0.33941219935671790,0.87508123094814538,0.46376584159245282,1.8689037700011659,&
        0.30987043769966471,0.36613469011743749,-0.65721991476696395,-0.22186302282231285,&
        0.80867972889419104,0.78558150556152240,-0.16681216431560841,-1.7323155287055922,&
        -1.2855743223478682,0.30579401597127692,0.26511941777136067,-0.67833633187911846,&
        -0.15960957161433931,-0.38524477916540445,0.99483722048919798,-1.0775128997852480E-002,&
        -0.92366796765543402,-1.1724822396034031,-0.65673045494412752,-0.22623312678103114,&
        -0.23816949546745433,-1.2602534657156454,0.33688576166028977,0.73773753531146424,&
        -2.1550769423069998,1.4144434788759019,-1.1793405890715911,0.60922364147800423,&
        1.0182751757928366,-0.86567733531553215,-0.89234860990694431,-0.43670137726244773,&
        1.0389892863285353,-0.10618827476917277,-2.0172855491644723,-0.21770446567856847,&
        0.62165994229039445,0.26026734899785398,0.43781599003671712,0.47130143761010940,&
        -0.94189006598784819,8.5196440070583843E-002,-0.36824232483883845,2.4472693615573111,&
        0.80860029977853576,-1.5948079604588654,1.0336375701106426,0.96667712305610554,&
        2.4203497914898895,0.21152685340253197,0.49624373760335300,-0.55689429924275724,&
        0.10205099248102394,1.5715570098707552,-0.42973197661199436,1.0571428836011254,&
        0.21535968003338279,0.31683398598958940,-2.0888677752709035,0.87547099312458077,&
        -0.31220768099729795,-0.17510355913357450,-1.6233580839022761,-0.71279291726437954,&
        -0.50753439024756997,-0.46448018733309371,0.17548933959939372,-0.73473216136787878,&
        -0.17215126413170898,-0.67593139570359506,-0.26754214270983567,3.5682913987661507E-003,&
        -0.89129371474630592,-0.70510013711216724,1.1299765505565287,-0.27154979460647127,&
        -0.37828987163704209,-0.42717428026999960,-0.33213682543214917,0.69640940796654616,&
        -1.1489638981875478,0.66271435165435955,0.34318600336470362,0.61044819259981631,&
        -0.75832924204019092,1.5440850959834060,-0.89262892197172339,-0.25183644482389228,&
        0.87200655095536528,-1.1935124503991099,-0.55743689001536056,-1.6145121383433123,&
        -0.48850863895850499,-0.26101473912868917,1.1592717063872489,0.78642398658705681,&
        -0.48881025539649586,-1.0701461309331470,0.77992715517003774,0.19615620531298600,&
        -0.90037945067095038,-1.0541416517417315,0.93085359550713143,-0.46827113517966962,&
        1.4202960961885931,-1.2037937066003461,7.4753751856086556E-002,8.8557530739333840E-002,&
        0.78022792106954808,-0.87121999082549784,-1.2249948600290443,0.75916321398826392,&
        -2.1400903584865580,0.91977635723411011,0.28166802893036308,0.45888360335289530,&
        -1.0065896270117616,1.0366402862255202,9.9253414236634849E-002,1.6434750483811325,&
        6.6254279514968525E-002,4.7211802248598458E-002,1.7231362904409950,0.55662144596087826,&
        -0.16236602507056985,0.22005215892124136,0.13781005107582076,-3.0724801368026244,&
        0.37414036386739657,-1.7256400491824406,0.44051945555213301,-0.24588037104452085,&
        0.54514447987915471,0.26860811789103767,-0.20243377297558465,0.53109261815206998,&
        0.79358969351979136,-0.20284085614459485,-0.30451205898006928,-1.5096078787673732,&
        0.47585132988865003,-0.78729209245735454,6.5153330457373426E-002,-2.1319272740880209,&
        0.36197884794222229,-3.9830475361003641E-002,0.18158083719031259,0.47671229960624434,&
        0.47624946931587026,-1.4746451029296608,0.54190049154710651,2.1568622495342229,&
        -1.2894147285783299,-0.90068890827250880,-0.21195564931027341,-0.34990962528098180,&
        -0.47812834364615364,1.5101443516147117,-0.49686249784427500,-0.55871653460627368,&
        0.42385198779254979,-0.86414847036308540,-0.91281760604161100,-1.3034978957727765,&
        -0.99200879000552933,-1.2361329760659483,0.38279352288207319,-1.3508420129620835,&
        0.66591053402412825,3.7965789360728495E-002,-0.23792824658845724,-1.5871306727506616,&
        -0.50484512702254813,-0.71727043385538181,-0.79330837023908729,0.33756894780807911,&
        1.0672360179494120,-1.3141703870364314,2.5529043531818898,0.10613763483777072,&
        1.2877717364850141,0.46608517273865618,0.88450775389765468,-0.51562783513393173,&
        -1.8938379016009560E-002,-0.33232612016877366,0.37533699598786163,-1.0189207981155550,&
        -0.96232331842046870,6.6632098568356585E-002,-1.5539179952065514,-9.0791688661806855E-002,&
        -0.88620777397631678,0.79508837297955526,0.86856571297393548,1.1676193366538408,&
        -7.8846163897735827E-002,0.88116087376452024,-0.43934069101322504,0.18136395816749429,&
        0.50652919877124281,-2.4095888955484619,1.1570726002738467,2.3155391440948905,&
        0.32776441814751417,8.5978149246322647E-002,-1.7483801216858157,1.3546835439968101,&
        -0.38313546535487386,-1.1975408944212765E-002,-0.37293982833980127,0.73238065407641073,&
        0.35779459882823345,0.24584526400315049,-0.83766877781204019,-0.34254428562671585,&
        0.20697809865607300,0.81692920026618310,1.2072284599421537,0.68748845811896642,&
        1.8967458888262387,-9.1489165506542500E-002,0.34657399489670077,-0.34153981772246150,&
        0.91386567185377710,1.0343622175048088,1.2238927864129518,-0.18501502885818810,&
        2.0171101682877604,-0.39582405119335085,2.0978934832170961,0.27696660197648837,&
        1.0476077665460772,1.9068296333106121,0.44187578563182811,-0.16008237290866911/

        DATA MC18/-1.1833656700384070,-4.1108571442580462E-002,0.33374578418064726,0.62730476409062486,&
        0.99697670137394978,-1.2954136580633018,0.31025088826242914,3.6049783541893289E-002,&
        0.30866535695459441,-1.5229241818817092,0.77043167800679935,-0.16472661069051855,&
        -1.7984529314687661,-0.54750070743395451,-1.7091057009040951,-1.2181604556652861,&
        -1.8321339480553351,0.93595585720729957,1.6299250249422832,-0.29904683776042434,&
        0.79746192963645768,-2.0749790160635619,-0.60348239643141299,1.5253436971026162,&
        0.90315209587248513,-1.0688132027854940E-002,-0.60877951649752249,-0.11366264253089732,&
        0.14089560211557658,0.77562971637858591,1.4991914112579476,-0.77159516761141933,&
        0.57907532990227728,-1.7654515891232681,-0.16586680005592599,-0.20396189376753013,&
        -0.13139708910164591,-1.5089380460117030,0.31876613562042000,0.34144617484494272,&
        -3.8307548983775142E-002,-0.26521029194469131,-1.0151446086143170,1.0511172861218157,&
        1.1572473704736257,-2.3280175504924498,0.42266763163101473,9.7788000234711528E-002,&
        -0.57968595850862958,-0.53329407879466495,-0.46461569656525942,-1.2799897190063201,&
        -0.71916739463729062,1.1724863448972944,-0.44314823987065921,0.67235212550787937,&
        0.32141210270331566,1.6543237504892738,0.83779364026218406,-0.71290885484844191,&
        -0.35049514029589324,0.53804032664492263,0.82034422788927586,-9.0216638045386280E-002,&
        2.4069868751319770,0.25993341267299525,-0.36511379894853424,0.50329594216179596,&
        1.0064512189049089,0.67206474324633825,-8.3141079657087821E-002,-0.76748686364675078,&
        -1.1425817262946678,-5.1992089377675375E-002,-0.41746687782908382,-0.69225517392368752,&
        -0.47188075432574017,-0.88546733537031963,-1.2053161736787246,-0.75906540275733503,&
        0.27127297410351786,-0.70912627544047957,0.18697867263698792,-0.65079367288149603,&
        -1.7055251132558482,-0.58417477945338703,-0.34609622580466171,1.8734494789941794,&
        -9.6892951194168811E-002,1.3043111253532331,-0.51004837055749630,0.99477217000132345,&
        -2.1039273765731750,-1.1254648953473161,-0.17117932602038657,1.3682820773812610,&
        -0.44688088959508132,-0.91689386891480651,4.0163836329052190E-002,0.68369150612781338,&
        -0.33127241797842688,0.74325843403538672,-0.59383760627256299,-0.28864951818829288,&
        0.24091444229195227,-0.91275895604044188,-0.69738212519215248,0.67231036981498349,&
        0.51220594185110657,-2.0964568395293095,-0.34607811930890975,0.81324682118204794,&
        -0.25815647355159488,-1.5224809843224210,0.76505237435945761,1.1855897268647924,&
        0.78880755696140081,9.8151003568591536E-002,-1.4717191098231954,-0.87732839739096968,&
        2.8108114950109950,-1.2852943167476947,-0.93588364380298183,0.37043100776804883,&
        0.32364178303062097,0.21481267107381138,0.64831570482519407,0.52676436648691194,&
        9.2102393090151821E-002,-0.62055258025563054,0.83082925629661231,1.1130446550449664,&
        -0.42235292107444333,-0.95378383869006622,-1.9164023708156255,0.39499087593488363,&
        0.88464552832214760,-1.3884532153898517,1.8505696150634043,-1.4030647873261946,&
        -0.37851768359777099,1.1653679131290440,-0.33121338054635602,-1.8817962846322451,&
        -0.86619054891472991,9.9522033737324406E-002,1.1011874511227044,0.21963845145930558,&
        -0.95614931967678285,-0.21499999464073666,1.0588989229799348,-0.36237072387069635,&
        -1.6094988122273590,1.1016433540023198,0.85303026131027282,2.6825542260881359,&
        1.4462559050049437,-0.54216701785131127,-0.25316455010895245,-0.25551653436657440,&
        1.3326753545412298,1.3849450132971195,1.7232637461319589,6.1515202616250271E-002,&
        0.84806005585960542,7.3868085459145860E-003,-2.0468978097741748,-1.2532592880396662,&
        1.7924805428015671,0.50012687224033714,-0.64326674886370094,0.14803434590284109,&
        0.56892979282547107,-1.6833843593090054,0.20827191095390810,-0.25830935240648162,&
        0.48203816510043490,-1.3770305094536768,0.71102377206949485,-0.10621866032524213,&
        0.55632630247631232,0.70433065737989498,1.9717086338103147,-0.26778714701874945,&
        0.42703154822447675,0.65980645505705693,1.7838214049714778,1.0426145458517411,&
        0.22262810801031518,-7.3993624347435723E-003,-0.69507383063618289,0.75968371135635349,&
        -0.56199195587302664,1.3703790888818737,0.36935942549120704,-1.4268326411786112,&
        1.2717527204489847,0.69472746386502715,1.0028143429265106,-0.63676466926588515,&
        1.1074809985874554,-1.6086112789463451,0.12110824363344315,-1.3498690320751543,&
        -0.95891376137853568,-0.18688051699727620,-6.5745297882768602E-002,-0.82894541094329688,&
        0.94439378740977542,-1.2815592506833415,5.7039271960390006E-002,0.98040829313091571,&
        1.0573530615628273,-0.62502396026967866,1.7283864862455707,1.4590000607826603,&
        0.76883488211632400,0.67295705989488741,0.23846759844400109,-0.36181253895574383,&
        -1.1695483983270671,1.1668828771143609,0.98387980525581742,-1.1154892459816741,&
        0.13636608204621053,1.1600377133622324,-1.0430957029243113,1.2462807437892784,&
        -0.94742381429453892,1.0703838370082395,-0.89740888156930099,1.1539330724682482,&
        0.60209390561414367,-0.77053214444849616,0.67381934753993922,1.2434204999101170,&
        0.74093629738678823,-1.1714634674652675,0.63138781622033668,-0.78720218441932721,&
        -1.2493872439687863,-0.93632690103348581,-0.38718403457864442,-1.0604862045438039,&
        5.7888663928812988E-003,0.70273712071150662,-0.61836903420714862,-0.39126086819802153,&
        0.89495489776591286,-0.88271664186739041,-0.69257458023665974,-1.1817707395632402,&
        -0.50410028989931543,0.56846076574885795,-1.8045982440435159E-002,4.2739765754919772E-002,&
        1.6934889159600106,1.3547571117754469,-1.2187504806937033,-0.21685178759613785,&
        1.8735109969869979,-1.6871526754424208E-002,4.4066265002549954E-002,-0.29742182518216376,&
        0.47551046386295071,-1.2077131134348389,0.40143932038115698,0.29730577396417235,&
        1.4807418478497865,1.0878245302733074,0.75309886726886965,-1.2379502702734493,&
        -0.56034432511293575,0.61393194727438671,-0.86089603064631592,0.87856539555708590,&
        -0.49780166882462340,-1.0452651395406973,1.7060084420198354,2.7630332917039477,&
        1.8490988485155659,-1.0584118452286462,-1.6292526374412399,-2.3789720225314830,&
        -1.0691263679788394,-3.2210907855698551E-002,-1.0194410128489606,0.36871315080679307,&
        -2.1034028646600937,-0.41560186255666215,-1.1862205968059611,0.62203411417061338,&
        -0.96623148755153676,0.65984517826581268,-0.36436460081581323,-0.83798859973977102,&
        -0.49822533189478424,-8.8833342220231981E-002,-0.52200617206097866,-0.40553791671378453,&
        -0.16901801334607772,1.0058382684350202,-0.94272833568958314,-1.4884804181691789,&
        0.53605900370314630,-0.97794808360337837,-0.80717057683117421,0.31655116424307383,&
        -3.6677296618079031E-002,0.25318224627399616,-0.28170983918928688,0.12759228589233104,&
        -0.45376785921547175,0.57085466603274504,2.2534287164402960,-0.26116794380700104,&
        -0.56007219448320034,-0.52210969064772594,0.14083290164901563,-0.53132209082868431,&
        0.37948982351746474,-0.62198087338758712,0.46587510925673764,4.8263670013448202E-002,&
        -0.34332158640190841,-0.33468805496772791,-1.9098913343227393E-002,-1.6805000850031553,&
        1.3113270668069621,0.41503030683447661,0.23071804112028677,1.3956920061069467,&
        -0.46120816117358959,0.26528448488169337,0.12511957303755697,0.39786264550892669,&
        -2.2529761566775184,0.54265835142480423,-0.54633325575021319,-1.3782709500606243,&
        0.48090834605410182,-0.41295927824957473,0.74162725967496024,0.95408845856795643,&
        -6.3473433677317254E-002,0.90306517604561198,-0.24604987752399385,1.3945709769535304,&
        1.0551085583911533,0.40429679769251342,1.1201993539337605,0.56374471715246743,&
        -4.1558969546972489E-002,0.27279806929879130,-1.0819165391904333,0.17866366294272240,&
        -1.2724888235799314,0.36813028541672366,0.49573655740886219,0.39256210363593080,&
        0.87774753948262008,-0.41431253868342871,-0.10190095036328084,0.38707887136538877,&
        -1.5011903204442629,-8.2639891301311788E-002,0.35290712128221646,-0.79205291234773356,&
        -0.55669941836577608,1.5571995596690333,-1.6291652934563119,-1.1126187958942104,&
        0.42921821317774306,0.68496330977075559,0.72477547330830239,-2.2003155133023973,&
        -1.1544717575771544,0.20839951043971047,-1.0672930802237307E-002,-2.1071238204184350,&
        -0.65179543326867173,2.0519602257828327,0.94614011083444283,0.30971909825971061,&
        -0.47439359536586223,0.16779885514321533,-0.50566598384796457,-0.26009917590349735,&
        0.18770659315735735,-2.1040785925539027,-0.71672348492644522,-0.52271652551408132,&
        0.60339190042406010,0.72764802448972454,-1.9462556664127257,-0.78726698591547628,&
        -0.79050439020459728,-1.3223419537366516,1.0865195484835266,-1.7868356017906526,&
        -0.59432117809305607,0.39168017672614996,0.37355871082773706,-0.92872467747057208,&
        -1.0233517531301990,-0.47146708603936194,-1.2028923879750884,1.2548033849871059,&
        -1.4432098229314234,1.0877173108920604,9.9373445545960337E-002,0.46439076927290346,&
        -0.62197648470703837,-2.6858486297834386E-002,0.42965595354648028,0.68145719476465383,&
        5.8508758532712833E-002,-2.2417681092985133,-1.1511369894220214E-002,-0.28202597623914605,&
        0.10053963867816580,-0.69045115977986005,0.18849670697526114,1.3242790288853206,&
        0.49787972198085551,-9.4770649915045468E-002,-9.1316731933502315E-002,1.8347331470608106,&
        -1.7947784586684199,0.22625931885290992,1.1709355323041346,-1.5660472619446570,&
        -0.26832180080167400,-0.13339391172950688,-1.3265732129386332,-0.69664907154249267,&
        -0.84291181950636396,-0.56890013633937542,4.9241319097118236E-002,0.51539888964888791,&
        -0.32767445055232242,1.0992690565234946,-0.27784544618712104,-1.4878915449713148,&
        0.77902023368195705,0.30453969300712708,2.5009039415598431,-0.11161694058106179,&
        -1.0853234339637692,2.2639625042753148E-002,-1.5488565387566187E-002,0.72241097043867586,&
        -0.33742945387015383,1.3890824620940017,-0.22137579171703931,0.51685935923803905,&
        1.0935321298507354,-1.4571937114527265,-1.4863170702193900,0.34432206967212331,&
        -0.21235788651963078,-0.70264450821155966,1.5399059010907321,-0.21541111899803508,&
        -0.94714616957665887,-0.82865092883235891,1.6664074228809636,-5.2209425674210171E-002,&
        0.95032112862192963,0.25418644758517184,-0.63616449895105787,-0.10410522259810337,&
        -0.33906300434607173,-1.1521726662581868,-1.8071838577797164,-1.1914578734098218,&
        0.29021018682986588,0.69731509901289468,0.57835333681789558,-0.58113037645630161,&
        -1.4762042269339113,-1.5875155373890629E-002,2.6651540672762755,0.16017285435032433,&
        -0.59154035653371884,1.2297243371431690,-0.80019643580530075,-0.72047889923060493,&
        -0.67332623796072244,0.53536692901539695,0.13974335794929632,-0.39239432850646250,&
        0.67291410268231155,-0.65341940090156903,-0.14748620557082248,-1.1618634732721824,&
        -0.23522418338900616,2.5495819360431007,1.6319633266243090,-2.0402575725674548,&
        0.59222201198451618,-0.26874579144404515,-0.44040206283744704,0.88060891152631859,&
        0.35158517394340155,-1.0979066576774599,-0.90143539553567720,-0.13102122348300749,&
        0.67951630077444147,-0.15294778849540311,-1.2566450862669400,-0.19376647129142777,&
        0.82788272066876634,-0.20071433587772344,-0.91910083736229675,1.0278611748863369,&
        0.13746300125131800,0.38479414680082069,-1.1403273370640870,-0.67472286482133892,&
        -1.2029514690189280,-0.80217046024684768,9.6233240872943705E-003,-1.2874151515089469,&
        0.10028430929748346,-0.20986305941883263,0.49500503510711324,0.28666398763812750,&
        0.32314769255290871,-1.7460569542579869,-0.17069502357882901,2.7429468039729845,&
        -1.0512299941362375,0.49636295079215609,1.1502284785433616,0.10439045675962530,&
        -1.0524514916359411,-0.66393863727519353,-0.38328669082435091,-0.41262963901030503,&
        -1.4493268477785739,0.33267902939819066,-0.24688993599651093,0.67364192708776227,&
        1.1194760637061694,-0.21616165158283951,1.0151788059700873,-0.25659654837658169,&
        0.51762915903053497,-0.82479013595635287,-2.1638303773334342,1.3662068586590859,&
        -0.36829471436816102,-2.0274354920528405E-002,0.45964368340215594,-1.5486194269495630,&
        1.3959218518129253,0.15487777624327706,2.1429271323331531,1.4755865547231919,&
        -1.5194911732917058,-2.2660317991258658,-1.1014941235451343,-1.1306545923712512,&
        -1.6937357152101893,-0.37229783559231566,0.18339852870098594,-0.64276008788883110,&
        0.62948520962043775,1.5861951280237041E-002,-0.91229465817165500,-1.5902589131095206,&
        -0.60091743200033643,-0.60264191451515214,0.58009587938808660,-1.8247895519687689,&
        -1.6828258935588720,-1.3388040766685698,1.6448125813364887,0.18561249711107655,&
        0.57489196450420654,3.9150777125422261E-002,-0.30354384954636160,-0.94243160864353448,&
        -0.25268567890768168,-0.20222739300991152,1.6141347259781320,8.4859408064501596E-002,&
        0.45156810410643083,-0.31443187347415119,-1.0079578700570571,0.86207173367465539,&
        -0.17055054901543107,-1.2166028758467742,2.0717081481482005,8.7715195983933070E-002,&
        -1.8177841534405919,0.39850283668213687,-1.7438812294477959,0.51821033838816877,&
        -0.23511327761635450,-0.16136145754670883,-0.64702591193926229,-1.2540560391756899,&
        1.1239391708817945,0.58192047074293873,0.16037092298271105,0.17005838450139407,&
        -0.67662407648586831,1.0994634357675124,0.20165678626470585,0.26870914847495625,&
        1.0526359439081208,-0.17883169269076818,0.95714022324615644,0.56862852071698633,&
        -0.18568259652706826,0.10783589241460122,0.31837864747507383,1.7515783313625319,&
        0.96224556367168590,0.26981638551772924,-1.3496585602399749,-2.4065362718594302E-002,&
        -0.95626034806744720,-0.64500088134583544,-0.40378890945122231,-0.69571885189258598,&
        -1.0016948056341364,0.91770096094474518,-0.30435919572305098,0.94645462882929510,&
        1.7106044749277443,-1.4755092940803070,-0.29609854671087271,0.19433973793039516,&
        0.48579081587014622,0.17514277719336582,0.82732029056271006,-1.2899203628962055,&
        -0.96145091176716224,0.86185530336997063,-0.47590195154409654,-0.13735037072167278,&
        -0.21427933476128888,-0.50519849111772852,0.26372209233609162,0.56776266043429036,&
        0.53344112931538112,-1.5532265941687060,-0.23974419326454832,-1.1727982308888043,&
        1.5591082765807864,-0.76197951493197524,-0.75873516390247175,-0.53879640434465614,&
        -0.20414480283913936,-0.81000210482121382,1.2670601347287103,-1.6355641356073092,&
        -0.32805871027869349,1.1965564846902526,4.3049447566258179,-0.58066718574745257,&
        -0.41427045030887338,1.7298162462438726,-2.1436954376072036E-002,-0.98836999885769194,&
        0.58576317578350579,-1.1218452003060495,0.20212965532280089,0.29135909935725018,&
        5.7668203331367240E-002,-0.23716531190654230,-4.9857887297727409E-002,0.90299563303464825,&
        -0.47960224499588827,0.70344004182693776,-1.5973953508603067,2.0321238985989125,&
        -0.39348771307113944,-1.8290043262303708,-0.18730280861409418,0.28400757481415018,&
        -1.6691048740873367,-1.7484527836391104,0.61182294991427122,1.8898396311010035,&
        -0.18262857813075328,-1.2587634952564786,0.52744362306845627,-1.1863735188831905,&
        2.1415120087481361,0.67675493412667298,0.10799383205363429,1.5024433777328035,&
        -1.8346098908588302,1.3263239062480308,0.15690031288731887,-1.6609990906667631,&
        0.26409810432728542,-0.53176527014947861,-1.1943763968459049,1.7776540146816633,&
        1.2802717316200090,-0.60233422674334203,0.68167361017829842,1.8895778230964255,&
        -2.9157702125690934E-002,-0.96618882833250219,1.4954330063044452,-1.3458507743306715E-002,&
        -2.0397429417905770,-1.6108003190950066,-0.97989938182191061,0.93641436004053025,&
        -1.0433553877609680,1.1904681641747772,-0.37694497123255238,-1.0546779959819483,&
        -0.18200901192297889,-0.28641871353709786,1.3293741130489702,-0.30393777212309886,&
        0.28567480193688094,-0.20122008426799745,0.84929723937170676,0.26813909163597927,&
        0.11052108365688837,0.85329264068481014,-0.80735133417203808,-0.13842219468699835,&
        3.0988338680746219,-1.0834348696677256,-0.98899790561673895,0.15793826612259779,&
        0.50563958333662373,0.72543907541785024,-0.51794088122691551,0.72482988768746459,&
        0.84712327071074445,6.6174198801819129E-003,-0.50302916913297602,-0.39900910627124897,&
        -8.7187957190929463E-003,-2.0843528932528832,0.68129668836048685,0.33675912507441996,&
        -7.6054246955887500E-002,1.6985233845654435,0.24745979868773899,0.22414912435603465,&
        0.14507476071706046,-1.9401584720151284,1.8307330858039419,1.7340696769185084,&
        -0.19238750054210887,0.94699699979581042,0.78073853567615314,1.1772855502027280,&
        -4.6870413200325374E-002,-0.76684413008480123,-1.3509668770934062,-0.59256849714718374,&
        -0.75503229196015231,-0.16794137425812744,-0.23805908967693945,-0.32547286437867357,&
        0.58165151326289199,0.76536209611352546,-0.42649039576796466,-0.14155004994929540,&
        0.29235280851861711,0.40245028886182793,0.60586782260898131,-1.2398181777490831,&
        1.2673671672721807,-0.46469341881763426,-1.2822835025690404,0.28403522406318005,&
        0.48046621594925920,1.0532574885289048,-0.17409976268594266,-1.7666015980561598,&
        1.1015184002500016,1.4441372185825847,1.1318077611611594,-0.63647031231106133,&
        -0.45907017486212548,-1.0745631713719688,-0.46544180652906653,1.4093622191288202,&
        1.8618337356820984,-0.17872652111107432,0.93830021673902653,-0.13334817237144431,&
        -0.92477926851700953,0.94175625015306896,0.26650129772085263,1.0302031611197124,&
        -0.87512398798431490,0.50461667096426055,-1.0500545356924091,-0.56847646951120812,&
        1.2308258907666294,-0.33465596111833767,4.6928058587069844E-003,-0.34432475722933398,&
        -0.51848335457109118,0.23591505032911728,-1.0165992598984783,0.30383009186829374,&
        0.19625697345290447,0.68294874276288309,0.69965529336514098,0.73439513820595648,&
        -0.30957792337982792,-1.6110798041078194,0.21695530272960289,0.27157431140965627,&
        6.7951087042718711E-002,-0.43953373071473040,-0.75441754725413235,0.33953042838780145,&
        1.7560463143496587,-1.0294441463236368,-0.50087026784995170,0.54294315022142470,&
        0.20900649831790588,0.14481309876687340,1.1627660761703009,-0.88590516807042285,&
        0.12627298402958434,4.4459525669977996E-002,1.2033941047345913,-1.8825645501929720,&
        -0.65144741001978723,0.53072131289980706,0.40854449082284644,0.52131304621048991,&
        -0.97156146815684663,1.4134919460941064,1.9500842933600968,2.0232853974323359,&
        -0.20983967976078502,-0.49231324681134714,1.6518902151328985,1.8305938664706480,&
        -0.31218552888771722,0.63891888928920326,-0.49588165658941208,0.85596355609247887,&
        -0.28888643344875115,-1.0012484634337879,2.4407181751628110E-002,0.75496079347879230,&
        0.32400674584725575,-0.26519359381176139,-1.0633348824404210,2.1699527043413718,&
        -1.2063754453427298,-0.16885248803157679,-2.0938230967774949,1.1961843861227801,&
        -1.4480959199600358,0.58728773145347235,0.22528092934685756,0.23309069914047062,&
        -0.89944924888214406,0.24690276148101853,-0.27087123666218205,0.13690266587821207,&
        -0.68363879531833360,1.4017801614972405,1.8839718638710825,-0.24296654246928512,&
        0.63286910723400869,0.72365823655744377,-0.21632126463051460,0.14839722738483027,&
        -0.97575930228759622,-5.0314629605868542E-002,-0.64653545351963804,0.69388114447438243,&
        0.42108351088454582,-0.28677253218682108,-0.52036902655769568,-0.78471782405749702,&
        0.39506911766640956,-5.5505644510927654E-002,1.9793699144964652,-1.8584627291414462,&
        0.75622646296096641,1.3698797534451086,7.7942271197041724E-002,-1.0276940033646418,&
        0.88685672045231656,-0.22563503823236539,-0.23707688550865555,0.58164495842152597,&
        -1.7482723141601890,-0.41699350138477198,7.9784841859156783E-002,-0.62709435387750845,&
        3.2712954374569967,-0.75581418629519281,-0.87905261678641766,0.64568624881824599,&
        1.5340737705741998,0.66270449977594881,-1.0700703506341898,0.24960773582372398,&
        2.4748726448039444,-0.11036612429852437,0.13582314642291116,2.0931531502851111,&
        1.3359006482339728,-0.40330875823098156,0.95001049110181957,-1.3479060465838912,&
        0.56967160685043250,0.58935338454729114,-0.76286227228492665,-0.38480255467614616,&
        -1.6077596627746613,0.44113104798339020,-0.26026491771927363,0.34474629820656527,&
        0.81362005960861483,-0.76889742139989825,0.40910881219892026,-0.56409256989603096,&
        -2.2087877975964330,0.30155752015101628,0.32941678254202417,-0.35775067123519122,&
        -0.16267411911324745,-0.14372508999274203,1.2427149531213069,-1.1155840337676184,&
        0.22294685071929887,0.74893193602750352,-1.3983446301148843,0.88432609253773131,&
        2.1061093902317327,-0.53765623665917439,-1.4571698411225211,0.49411748483968426,&
        -1.5592556379498693E-002,2.4234793024664492,0.85817489224206633,-0.10910021934108216,&
        -0.37389979818126606,0.38001489871943284,0.44118148538462271,-0.98696343298142986,&
        -0.28882854173849526,-0.16943302515975717,1.1541748099468394,-0.13790869271659256,&
        -0.68003729018190651,-2.0013530079310891,-1.8193393260714081,-0.47725300069108917,&
        -2.5872229046802184,-0.31097300097815167,-1.4832602100964820,-1.8249880684630941,&
        -6.1525073788978167E-002,1.1140126984535863,-1.5134110095194500,-0.22735790579454671,&
        0.36882210218480321,-1.3347517345220024,-0.99972415257170255,-1.1127163499009072,&
        -0.20072704757328305,0.54627875630591216,-0.44117964834403767,-1.1551716479132224,&
        0.22202088006675585,0.38229085050059758,-0.19612732028212423,0.38822163287522460,&
        0.72210036945234179,-1.7954565641388958,-2.6721565373009099E-002,0.21627993875922635,&
        1.4910703374047420,1.6408129836131389,0.50052776454022940,1.8372836861792687,&
        -0.12593590025407109,-1.0748399081698690,1.6149219841233968,-8.5923318441331040E-002,&
        1.7392554898731716,-0.97674242150090940,0.67268758236204751,-0.14077164617450841/

        DATA MC19/-0.62633622162014380,-0.36302621309066513,0.17515019589892022,-0.72649209750736743,&
        0.27675153688422788,-1.7852225788518572,-0.71832486820043073,0.65970470346415866,&
        0.96546803896458400,0.41222198112256891,-0.69890919898808157,0.54510459110854448,&
        0.23045190865189902,0.91756839128353640,-0.69468716495550364,-0.80495898340576033,&
        -0.25613338479553899,-0.85703179203987900,-2.5615380698493437,2.0452484455667892E-002,&
        -1.0621986202382314,8.0292004058634778E-002,0.80395129403425647,0.51922903988043878,&
        0.68511605140359289,0.87671156699729258,-7.4255236949785974E-002,0.10922643905999380,&
        1.5478347671511599,0.79547112773376627,1.0827339893861088,-7.5476264205625795E-002,&
        0.33161333068276833,0.77190427144373253,-1.9550146293035675,-1.1850613303714741,&
        6.5458054112754391E-002,-0.28778200400539417,0.38498706547052858,-0.23422387259543870,&
        -0.56946303871696802,-2.0799704204431153,-1.9177507316278231,-1.1682770407722218,&
        1.1844882122241167,0.77311450574643736,-1.1468867087532528,1.6018456550288969,&
        -0.40523214678473035,0.66995299353980686,1.2181515938823655,0.20321764427318570,&
        -6.5406085287958424E-002,-1.1081952470481586,-0.44282259312227734,-1.7303568669925009,&
        1.0491144612365795,-0.82052699247860450,-8.4049510957157639E-002,-0.15694464364404859,&
        0.12334481049723256,1.9722078248898940,-0.33086851058551014,1.3374656635920781,&
        -1.5916091180723395,0.78793996012144896,2.8547083874650636,1.0355552660147833,&
        -0.90641662171830129,1.2159020613475087,8.2191246202255375E-002,0.82259541026160266,&
        -6.7194423897668595E-002,1.9864954339581375,-1.1980262321988464,1.4978948629661470,&
        0.40072568031656974,-8.7774779090108918E-002,0.42036506260042289,0.75290049411836413,&
        -0.48153233032077047,-0.44176959124690729,-0.67423145764272918,-0.11994294606072985,&
        0.12300937892810133,-1.6392237571132129,0.99550933897494887,0.69514730938608216,&
        0.59345402946079606,-0.37525260800577748,-1.3182883792052369,-0.22516429635445304,&
        -2.2619442969173047,-0.42363436522983577,0.42264604638221254,-0.44681356969645392,&
        -0.67441804803143945,-0.13556093680802472,-0.43327288466008562,3.9625517259569011E-002,&
        -1.8029707354600202,1.1483367968899003,0.25407876295993315,1.0789302552218254,&
        0.28463817049681350,1.0110495235146730,-0.32723088947561463,0.72343842118247403,&
        1.2066081774008881,-0.91661160875544301,-0.63643232450827691,0.30334077298391066,&
        -0.58244724568881612,-0.42882524448289011,1.4577103337496891,-0.99948661411369655,&
        0.45116956811061182,-0.75182643413925598,-6.2500903680918124E-002,-1.4892213444381253,&
        0.69163646496437714,0.40570165834811400,-0.51623628087948692,-1.7894945272154414,&
        1.7811168480086734,-0.24054126131605383,-1.3520195392499177,-0.35552679948081389,&
        0.67774615665278026,0.13249266996213899,-1.3469096621105447,1.5526728368595388,&
        0.88775738130575010,8.8944327968970768E-002,-1.5601983494920322,-1.3255982584637580,&
        -1.2599833461612435,1.1931342965679312,0.19672234097294211,-2.0829597237691604,&
        -1.3151368358685886,1.4322382926588708,1.1783866649891090,-3.6932310525508709E-002,&
        -8.6282138364444955E-002,-1.0816292692647849,-0.74074798734262615,-0.65130150422280797,&
        -0.86785077410200495,1.4537511341131040E-002,-1.3415180043173858,0.52415919257420418,&
        1.6888373008374908,-0.30264724629104151,7.1979890941209740E-002,0.57182318116094255,&
        1.8008194196364511,0.16488561860484766,0.34458667529525916,1.3478923438151387,&
        -0.33485001265849090,0.60521219285588435,-2.3687901245643022,-0.66962674695312896,&
        -1.1340172450263111,0.61168355926693030,-1.1393708883042977,0.17741964861367815,&
        0.29158488803120330,0.58456249761018053,-0.64416053998304701,0.99257784130554216,&
        -0.45244934282210442,-1.6157514894801992,-0.74378250755613229,0.23932536007285274,&
        0.30197994540799045,0.46259143621238025,-6.9449387475609498E-002,-0.83296526305717433,&
        -0.12410765806956982,1.0067516744515568,0.94306264766391179,6.9867695603460775E-002,&
        0.24945407081079599,0.91011606656886013,-0.78051595419048747,-0.25007459178795355,&
        0.74010575243651300,-0.72484574349179787,1.7499266629441981,-0.59730230552301833,&
        0.68031309563338149,-1.9454762367627281,0.49140130363581341,0.94761854189356942,&
        0.70332328389739984,0.49933458934256991,1.3218902910264640,-1.0807755487023261,&
        -0.58061516610942199,0.14631529105285837,0.57296016145923623,-0.54821587449332609,&
        -0.48163445332029897,-0.28885677730465475,-0.54179625706869161,2.0812696891338693,&
        -1.3139683985232844,3.9577411192801545E-002,1.0014008260898688,0.85225667232445390,&
        -2.3365414324503346,-1.9905573438027431,0.88710705245769517,2.0177593363397035E-002,&
        0.19830658253698843,1.0876515716137163,0.38858437184903744,-0.82229675188972984,&
        2.2643859379869054,-0.11350177459874088,0.30167201500833957,0.93662690105327340,&
        -1.5507255674967013,-1.0199849480699528,-0.50080346788810282,-1.9633233724367183,&
        -0.92821439083638857,1.1849968442187195,-0.49394074974560981,-0.51293864147826984,&
        0.54421528089200544,-0.97752700237169254,-0.15274787205447735,-1.4240707928778296,&
        -1.3737490380157247,1.1415743228890010,-0.38862279595289118,-0.70987385559139349,&
        0.37086490954938495,-1.4260328590335110,0.78830635619772460,-1.0637297750460182,&
        1.3521771655918884,0.91498917721384088,-1.4349309408940394,-0.15873830963274907,&
        0.11826674405716162,-0.88933725271289021,-0.56167305798383149,0.23391367347073524,&
        0.83500774798058708,0.93860457262966190,-0.55260668518790867,-2.2569587299056648,&
        -1.0087388284693346,-0.91904852141810889,-0.45285788799945803,0.84412368327712595,&
        -1.4130405167639195,1.2342369228380448,1.2437187932995351,-1.0612830309479337,&
        -0.39401676713594602,1.2937366966084762,-0.35194710405706653,0.18834373199157642,&
        -0.24131801644556009,0.18009699789985739,-0.69612947200478348,-2.0999047652886196,&
        0.48743235060629253,0.76805286813513429,-0.72139488878113112,0.93630526641018397,&
        -1.2060597627275365,-0.36693491652844912,-0.71259829777510630,1.2774891390640415,&
        -0.41996702852699819,1.2349682933560731,1.2897241907768737,-0.52150699879616080,&
        -4.1513316615357933E-002,-0.22246181269409840,-0.31020991819409471,-0.46946480054042961,&
        0.80685234625303526,0.94575448853664801,-1.6381539523218445,2.8630352144584563,&
        0.40749568010298015,0.76590391405029434,-0.13573982169233392,-1.5569417799462559,&
        -0.73102510263841369,0.83040806237468423,0.57158357854063602,1.3322150832746236,&
        -1.6038815346068485,0.46114842966641495,0.68873940083179319,-1.7536565036750333,&
        -0.34989105889470401,0.22603271061783642,-0.21187137953662172,0.28227690028126523,&
        -0.12379279891538329,-0.80814670803653033,-0.59711398484697920,0.78083872431463963,&
        -1.3296569047499405,-0.64687831383721206,0.79993474313110968,-0.96555976904585317,&
        0.80006609945143914,0.70212787133699406,-0.17598079182386736,0.52426782629009527,&
        -0.11933369905585950,-0.15443905457633844,1.4018044172687294,0.59099438199902221,&
        -1.0851465145057739,-0.85758628206379017,-0.35375050507779165,1.1943928699240385,&
        -0.86896811119999051,-0.79744814764838345,-0.33582803525996052,0.79661950980816587,&
        -0.28715854161977095,-0.70489261838937145,-0.71645109417852659,1.3287085025947054,&
        0.11475057483098039,-1.1984361500661582,-0.78600828489232621,-0.16933748767553061,&
        1.7329358321764150,0.51318855481535042,2.0650774457063674,-1.2519298606762668,&
        -0.26096107989472200,0.71810258779765324,-0.28984123385852684,-0.96621678630105556,&
        0.19119003058678610,-1.9145176899445659,-0.87503479462610922,0.35749042956108962,&
        -0.59187365206336229,0.23557229999884627,0.46111860226882256,-0.63048196388128275,&
        -0.89965820500890037,1.1135069003052289,1.3827922652611522,0.14907957239950817,&
        0.18270089932780265,-0.52481232042536852,-0.76289368700867310,-1.1286329722533213,&
        -2.2322720738440083,2.0121685811227699,-0.67806772344958888,0.44284501371765650,&
        -0.18082325048642162,-0.78239332557608388,1.9817169634968173,2.3326991542330138,&
        0.51065452783858400,0.69388527185230464,-2.3086819596007926,-0.86790903304816758,&
        0.99330323769182627,0.74026187260747911,-1.4532273688992630,1.1320557932183752,&
        -1.2088512680687773,-0.35746203267041216,2.2512552798714851,0.25072724802117236,&
        -1.4683302459173329,-0.52293251890873116,0.55370916954495808,-0.88922168517784539,&
        0.17525687089019359,0.67881562133084250,0.99540087454074766,0.71669295219098017,&
        0.43001125354863412,1.8670737621791806,-0.57701709647654476,0.10198149259276224,&
        -1.9371206802069616,0.80240864960887692,0.43359233025722776,0.91612382969215644,&
        -0.13443254193229623,0.10054494615697354,-1.4136070637825318,1.2800066172653437,&
        0.37964957059588361,-0.79374098320988518,-1.8324662818785715,0.54236907468817253,&
        -0.34009685356800262,0.93009643539024145,8.3059887440099234E-002,-0.68303905768838447,&
        0.60254566367036577,0.17019180477711879,-0.45408120950304620,-0.56571348500256224,&
        1.0068587506389677,-2.6656444284491754E-002,-0.73529563370669571,0.61525208680806354,&
        -1.5009952441835626,1.3175389603433618,4.0467088883536770E-002,0.23215862698023140,&
        -1.6306125969929812,-1.9070910570457567,-0.21787111400727560,0.58520073766748060,&
        -0.70003588724600729,0.59152836165046996,-0.42427664075391330,-2.1372930570194368,&
        1.2823049193614755,-0.36542275496881443,-0.87842811881819949,1.4229449629901190,&
        -1.2043176197811492,-0.53980048994628294,-0.71235321861964584,-1.3913410828995461,&
        2.6455100872546291,-1.2737885042380144,0.33811722564292879,0.48131558207906655,&
        -1.4216864175370849,-0.82391657983419753,-0.65342404235633056,-0.67473169319845094,&
        0.16052383413004498,-2.6872691945265086E-002,-1.8666293759691774,-0.27181597869736729,&
        1.9405064513535717,-8.6446282098180130E-002,-1.0256791090384225,-0.23345250852253299,&
        -1.1239803519183451,0.14177171979749842,2.8312671501702193,-1.0005000982445409,&
        -1.0214422476490981,-0.47604283197532077,-0.97009749214015950,1.5975548715690484,&
        -0.75724460659372761,-1.2198914085002552,-1.4172999754777189,-0.45189125273376524,&
        -2.1485387048320423,-5.5345691824324007E-002,1.6020061183585683,-0.37762973294076763,&
        -2.2087360194061918,0.84621089840663499,0.32817777712389179,-1.6388977806836205E-002,&
        1.5545898885542297,-1.0725617325517030,-1.5191663955306980,-0.46021678328959958,&
        0.26278601324314915,0.50091941202393719,-0.27285550947186860,0.22835986890005830,&
        1.5246960572537034,-0.70112327960891463,-0.84328049012341200,-1.1498746115474703,&
        -1.5580697356065338,-0.84632144870519255,-1.2234578943439565,1.7375486635769306,&
        0.56311823889855528,1.5533836608047842,0.89434092260888753,0.30288748693499745,&
        1.0062165165006700,0.50154918216830391,-0.75487424063957065,-0.40000279076978118,&
        -1.1205949097802754,1.7648592870970998,0.67964978409169063,0.99027143675688634,&
        -0.51089450966069738,-0.73782206908875403,-0.12910636739348488,0.19864016429074716,&
        -0.81767268119590597,-0.77458109907783201,0.77941346389120680,-1.6250697293876761,&
        -0.52327419255598628,-0.27607521396188417,-0.56887009478871819,-1.0539010541599481,&
        -0.61480261785895496,0.39007838736689926,0.62582482370219905,2.3836948980416647E-002,&
        -0.83678245161749554,1.1130468331400305,-1.7575713349304092E-002,0.59061588675109444,&
        -4.2616037993019815E-002,-1.0375846496999144,-1.0027734383807263,-8.7594386552543604E-002,&
        -1.2984866797904282,0.18485246873170932,2.3323566778214865E-002,1.1967535135737322,&
        0.52508898202033605,0.37315107329316627,0.81599506645968489,2.2866961308371332,&
        0.25071176478941659,0.19340166817462232,0.72020117177576459,0.99791370456542472,&
        0.32156898632063230,-8.6612448204792705E-002,-0.35637358744577025,-1.2932596373726604,&
        1.0125589467394625,0.79169016323681929,-0.18629192917574228,2.0589580741093204E-002,&
        0.49840119861570847,0.17929214599142584,-0.53480667794937076,1.5522641494574776,&
        -0.28081527819097496,0.67233238250855598,0.47802101812575415,-0.87432400956816414,&
        1.7710632963021880,-1.0102711963633018,-1.0221592931354697,0.14198054306789723,&
        1.6714126762124464,-1.0245812736990958,-0.30482109986234451,0.97456457310271294,&
        0.45907775820053442,-0.44778499394062737,-0.55738611743134858,-2.0269007220677013E-002,&
        6.0306698827570608E-002,0.54360798301048729,1.0349051103222604,-0.94349378792439376,&
        1.2692336839416998,-0.20701296253345358,0.62075276315005767,0.45262660332564064,&
        -1.0097737871369523,-2.3867563271705130,-0.86134673345401269,-1.4133840343605775,&
        1.7015469112334103,0.24282571707262998,-0.36622726156307572,0.52249599409103664,&
        0.41354751824284225,-0.85725901146428674,-0.92178152889028331,-0.20448873512594976,&
        -1.3311275350584559,-0.23352681425190752,-1.3156869248882175,-0.62831826506029020,&
        0.10923845645016120,-1.5617500482670768,-1.4180662823743160,2.2942507984561176,&
        -4.1381956050297139E-002,0.55780852050794683,0.41678963503598826,0.55241361870308747,&
        0.86755316043591835,-1.7334221340041252E-002,-0.35855341144592201,-0.80844673409122525,&
        1.4455291852539645,-1.6554441457894848,-0.22654535847585888,-0.99974626150529045,&
        1.8479305291402084,-0.57191284492206973,-1.4375184939779675,0.81697367983295965,&
        0.61206464574236852,-0.94890484717223123,-0.14841373558690021,-2.0206426769883157,&
        -8.8066333962593973E-002,-0.53405811418923377,-0.93079234766296182,-9.6822553831046709E-002,&
        2.2245546689123783,1.0340160859684588,-1.4210587006430970,1.4619819689244160,&
        0.33347881573473837,-0.87901976777334578,-1.0151627628881859,0.49808630521933350,&
        -9.8557517720665372E-002,0.58876161547040129,1.0565646281914938,0.70536496394515213,&
        -0.63864201633311102,1.4956000442609450E-002,-0.53314297769284358,-0.58704629492126292,&
        -0.68222190858660381,1.1588137399492391,0.19308310295290826,0.73772502241887894,&
        -1.0169292572549353,0.60982034508897132,-0.24226253427536493,-8.3991653637545169E-002,&
        7.0812617784488385E-002,0.34786508160148805,-2.2979168068263967,-8.5579794259348391E-002,&
        1.1897687302950311,-4.2916346364039584E-002,0.13432429684951055,-1.8945911812039109,&
        2.5176890681468485,0.30750611866265026,0.74960068369692967,0.26388308295651863,&
        0.31881399022288909,8.3892129643933250E-002,-4.9926799371014914E-002,0.40101268727684103,&
        -0.91931980810590663,-1.0893189958564582,2.4552305635462492E-002,-1.0425205467194680,&
        -0.54122721528124040,-2.6470753610508241E-002,-0.92148740929421169,-0.14570482964856107,&
        -0.26300132311957158,0.73838919620561405,-1.1533368664868697,-1.9555907145610933,&
        -1.6284267267858470E-002,-0.66862556406500384,-0.70430745386987348,-0.39396866529008351,&
        -1.1996675509595383,-2.7707917762278711E-002,0.41241097297083967,1.3794427135338154,&
        -0.80310990436198137,0.22701945470894672,-1.2336107388969102E-003,-0.18167373923967448,&
        1.0493514177557866,0.43389674205474082,-1.2808429069880118,-0.94625039579709413,&
        0.61906761257214005,6.3380344659458993E-002,-1.3521505035723327,-0.26507864749959648,&
        -1.0335198968999675,0.45803029219765212,1.4696117301638967,0.79210949208755832,&
        -0.21166776154781761,1.1267853792365166,-1.0132949120425252,0.43166172911807948,&
        0.43519759085416759,-0.16800965397803647,-1.8069993154071173,-0.20988952507442776,&
        0.25836133557286955,-2.2343453087607754E-002,-8.2075442435472087E-002,-0.35506802421718214,&
        -2.7966435413042481,-8.8722880639544477E-002,-0.57402117982859369,0.31790780790355588,&
        0.19263997607866909,-0.63254269651900596,-1.2153567498394513,-0.63508222914677859,&
        0.72818030366025654,0.91405878805604635,0.43287741266896756,1.5873397439214822,&
        -0.61924273216016557,-0.87837983909376716,1.2969560218243796,-0.26063235179564115,&
        -0.15818024448452817,0.63136169048831325,3.3955231404261692,-0.42168626410719873,&
        0.36179783312645358,2.2273707409259554E-002,-4.4579534933059321E-002,-0.41472494523121806,&
        1.9494148653842684E-002,-0.27632995197622756,-0.93947079861358107,7.7169247802332877E-002,&
        -0.36145307059448900,1.4498952393576121,-0.27661990231265310,-0.90004469758421601,&
        0.36310516900267897,-1.2043129044118122,-1.1880680345829491,-5.3999589359093082E-003,&
        0.14283579303474003,-0.59540739901439932,0.11047583075730870,-1.7643128424227541,&
        2.0390882459712540,-3.3619691291491269E-002,0.29453075202462986,-1.7018932348325573,&
        -1.5871846314032785,1.3533569505025780,0.61176694322533165,-0.30864547047545748,&
        -1.4801795440318792,-1.5884622257070180,5.2228424432956999E-002,-0.25073421276159180,&
        0.74044845983913077,-1.7501698829839689,-0.61984714192820034,3.1944251029969841E-003,&
        1.1128604915340270,-2.2558184034191977,-0.25705680082547128,-0.64978083174631041,&
        -0.72102039924438310,-1.1680953414238411,-0.59264528122352789,1.1778418079265516,&
        1.7732768206202030,-1.8167046435387628,-1.3939403204266680,-1.5665030436131284,&
        -0.21809199214633124,0.23203925410397747,-1.1987544524198270,0.91525756450939166,&
        7.6261366188494217E-002,0.15886111476407680,-0.61067945554299197,-0.46730213755219296,&
        -0.20709709044917984,-0.84346364926892525,1.2677638857181415,1.0609039967369795,&
        -1.7479218691445293,-0.11638817554375418,1.3098946855709253,-2.7618906259970086,&
        -0.53218773206527981,-1.8067078084667632,0.44958235284555681,-0.75171440815942214,&
        1.5214941630710586,-0.43307589938413416,2.3449398693738837,-1.4201799274366571,&
        0.80248603818886644,0.97702320678925758,1.0043756474523804,0.32994011224662428,&
        -0.12992838017865818,-9.6265617234861187E-003,-0.54194031850143243,-0.42541957068172842,&
        0.39461030597181324,-0.71763028966986475,-0.61009436934295069,-1.6803963211796198,&
        -1.1635759955911491,-0.15609260630141247,-2.8399918139339659,0.64560759032876192,&
        0.29136152733427995,-1.6583459263207601,-1.1221524990740395,0.71987992765640174,&
        -1.2461262950700116,0.38602725423600182,0.97696203062956621,1.1750585152901400,&
        1.0839785318771926,1.2341686148844195,0.98724171181400899,-0.54554508300550431,&
        1.2577068748194200,0.42358650829908923,0.19911137389882103,-1.4036476865181093,&
        1.4557773394949416,1.6030087168362395,-0.27433502764698636,1.1770671934168908,&
        2.0508250204450884,0.59450693662474385,-0.49534254338375400,2.4796309433286663E-002,&
        0.98115156186468377,1.3218994530233412,9.9105163468680257E-002,7.3389827067131949E-003,&
        -0.75342255932330326,-0.12287341705939586,8.4278618804072641E-002,0.24601535570364869,&
        -0.32056380114232902,-0.20292202465748435,-0.69598366536089062,1.0172901008543838,&
        0.40201932485598574,0.62525765893363461,-1.1917952005395076,-1.3927807608724738,&
        0.72847707358567249,-1.0891260995370811,0.25685245815096103,1.3048855544353710,&
        1.0517684675034027,0.96587180357117441,3.2668278451455125E-002,0.31332866093914813,&
        -1.8959430840583684,0.51569414015566994,2.2341355462420838,-1.4610506669148764,&
        1.3550966793115762,-0.31996044606617285,0.48672058137544938,0.19924397107988012,&
        0.10765669201345253,-0.23368019785718322,-0.59781958364066168,-8.7190149866779310E-002,&
        -0.42959657542240992,-1.2491683453041913,-0.44520263599080084,-2.7611976743124136,&
        -1.3280843621296854,-0.34052534482644725,-3.0218418835838111E-002,-3.8573343822708973E-002,&
        0.97129408919645377,0.92898318675443170,3.0255571029004374E-002,-0.16868375332314431,&
        1.5978719974593674,0.14750454466660717,-1.0025535950965723,0.28845519820159354,&
        1.2661078839383366,0.44752866094259441,-2.1304440673437863,-2.0070553163315896,&
        -0.48671420665638798,0.89753895026614394,0.70701367193089171,-0.59680122635616961,&
        -0.50710659828883564,1.0517928598191464,-1.5381617436025550,0.38838275837875913,&
        4.9475136173602156E-002,0.30169987204614968,0.72724931345569221,1.0420121706360508,&
        -0.85801616672536440,-1.1763463388107467,-0.46585706349515638,-0.72260381977454591,&
        -1.1750200059398579,0.46530403126055409,0.44985020400985753,0.21847719356518899,&
        0.56099064558611922,1.6712485612327361,-7.9482869939352524E-002,1.2464915243879091,&
        0.79785883994913420,0.32605444963391506,1.0147451875291982,4.0081095430701701E-002,&
        -0.24146302691057847,0.84199148548193459,0.89741407964333497,-0.85415738114856787,&
        0.72088089056079030,1.1491496794003135,0.35941781598781303,0.74445294962643038,&
        1.9548627319014573,-0.27108274870465254,-0.68313869526937321,-0.93035666237112724,&
        -1.5573727135351056,0.18016720924364804,1.7239667630124267,-0.80016744673125983,&
        -0.30432616654855754,-0.26327053544204632,1.9577617796457665,0.75940853521269269,&
        -0.67997909607235762,0.82082898180505748,-0.96792021160763075,-0.10748623621984633,&
        -0.78022370138289410,0.81578837875272081,-0.34061509337072221,-1.5479060957833000,&
        -0.91813463898634040,0.55686832267976405,0.46225850772135030,-0.73895436401058845,&
        0.14189120260609511,-7.5822812486520258E-002,1.6420572227711006,-0.86770974501027753,&
        0.77610938048187561,0.84295518867832886,0.13014963718819877,-1.3983184145769840,&
        -0.46844588931353254,-1.1245641935640900,-0.44334826224119117,1.1298934100102009,&
        -1.2756654116496555,-0.41493875183297252,8.5148122388965061E-002,5.8897970300169210E-002,&
        -0.50251590129227752,-1.5058347846236171,-1.7262627789252010,-0.90649027014846284,&
        -8.4983574810571089E-002,-1.1679013048725002,0.65239893295437468,2.1294658541469382,&
        -2.1026105814861173,1.2891967732398231,-1.1306249799706520,-1.5791148718569594,&
        -1.1585480729252602,-2.2762468910166316,-2.7551912373927769E-002,0.73039720613933767,&
        -2.1407103578099687,-4.5188975203671926E-002,-2.3136062110798195,-0.75312932164772972,&
        -0.14009514102326603,0.71630800687148721,-2.0048698893501027,0.15693904212359777,&
        0.19916363545383822,0.18591174305338601,1.1187794755491680,-8.3825151994840807E-002/

        DATA MC20/0.84407243687814326,-0.97210568542602771,1.6702172553891701,-0.47169030230333969,&
        -1.1517021629242552,0.94509211679934246,0.36520652470717851,-0.32158488681534764,&
        -0.55300545277763380,-0.20672476649332472,6.5394160028533821E-002,-0.77209354782181094,&
        -8.0088022053001431E-002,0.33791002633914707,-1.4725161624319996,-0.65883097250486244,&
        0.82395975930762455,-0.68582558613960354,-0.54788935058413257,-0.98442769459421697,&
        0.43588272577055498,1.1272454821651001,-1.9774872368640963,0.83255601203026186,&
        0.10947626458273244,0.13577848679238166,2.0374901826225251,-1.1585814685599896,&
        -1.6033021755200527,-0.73935091271679787,-1.1310824312309340,0.26634625812975399,&
        0.55932602082217797,0.59685781376951419,-0.97924841172011001,0.23089650173379953,&
        1.1664019177984111,0.98252629014997306,-0.49011573898357785,0.15778932200275364,&
        -0.70397249170103793,1.1329068577898389,-1.0153373911401147,-3.4743710922601583E-003,&
        0.74537827747095731,2.3975407515015901,1.0835766002856262,-0.47050168554600030,&
        0.15441328790704817,-0.40386753178993301,0.34149312291945755,-1.9791311638242943,&
        0.66652779645349791,-1.0154699394761959,0.67246417178367102,-0.26393209792155115,&
        0.19627358673960885,-6.4834368152017208E-002,1.2653860595512476,-1.0060817244642397,&
        0.21842915070184352,-0.26088619749596748,0.43155210811529365,0.22884690183915310,&
        0.61930375968399309,-0.14142252407509176,2.0778176773433930,-1.3699549352464599,&
        1.0177406832781288,-1.3162467183049773,-0.73484745863406753,0.96958636466324133,&
        0.20565372071485458,-0.45207381255381723,2.4500359381093877,2.0795025791536577,&
        -1.8047830946417596,-4.5726680702014730E-002,0.61985253542593777,-0.88104602792942854,&
        -0.96343967601708846,0.79482070032343199,0.77599347427118626,0.21938189255709276,&
        -1.3661615755247425,0.85996543645052925,1.3958887768205634,-0.20935821188989964,&
        -0.23820218548565822,-0.50739110298172541,0.34845919377191376,0.65463347606735700,&
        -0.27134272920760716,1.8913048174758735,-0.24024718662348438,0.62175098481611324,&
        -0.82789315881313619,-1.3912204053775121,1.5399108122182421,0.51927656509593711,&
        0.20106622474169666,0.79261524315178322,-0.28878893149524421,0.59695587230801328,&
        -0.63848307811593807,1.0050513155581933,-0.63326402315919306,2.2775956169054505,&
        1.4929737013012425,0.25357261917125412,-0.13430773117846115,-0.76520594808499365,&
        0.92904139352492821,5.8603603692972531E-002,1.1305533612395899,-0.50573967170283241,&
        0.39001304532431502,0.65113390629444057,-0.36312469009468895,2.1124816581089636,&
        -0.97608980564725045,0.40961351405116181,-1.2613165483921431,0.79362596908306404,&
        0.37325143777977765,-0.40008389217309615,1.2432148546959461,9.5178523201789392E-002,&
        1.2876640530553354,-0.91428927794172576,-1.4355843177434375,-0.69885284428118255,&
        0.34202217492991938,-0.60719380963610037,0.91234000115966929,1.0789741810623492,&
        -1.5350403378760364,0.80601801264832917,1.2073213386803039,0.15506251981583433,&
        -1.5983904604641950,0.69199258049584722,0.17494645994003441,1.7855124611113848,&
        0.31921175134470003,-0.81691476972544408,0.45472030199071761,1.2845628710942514,&
        -1.1907009996352249,-1.2187109606866300,-0.64475969384036091,0.12000983143138448,&
        0.97312003411887216,-9.5087713949103050E-002,0.31813525810632853,0.26763482485110690,&
        -0.50299424603861709,-0.10899857583852635,1.1068034483123279,1.1340937019360824,&
        0.43528962872651616,-0.84105785004728539,1.4114450536724779,-1.9087304847656317,&
        1.2828053745909482,1.2324603687766222,-0.13354242092692820,-0.65490996101489496,&
        1.5554321212056959,-0.93724649057869724,2.2788180272993976,-0.34056973372074456,&
        -0.73203536116486900,-0.49750722035664341,-0.37756571009148149,-0.36737873067590326,&
        0.96642816564326284,-0.19681735335530312,1.2378764273159508,-0.11859421430485152,&
        -0.60608109451974812,-0.18359636528033066,-0.56279084485901809,1.2972754567819820,&
        1.2094508063358220,2.0884653383965102,2.7012867185303753,0.19554622802087748,&
        -1.3291596039520492,0.51334968736465914,0.71315583595777887,1.3073471878652039,&
        -0.23608087697933822,-0.60792400911513789,0.56633290053948337,0.97151168652486053,&
        -0.37173881195832731,-0.47380425384657465,-0.24705438633814775,-0.30932216705490939,&
        -1.0407142474506739,-0.91018972291966238,-1.2773469604265701,1.1103982117373381,&
        -0.48685685654188277,1.1758994022210931,1.2602959916369501,0.35938969471527293,&
        -1.8175797367348092,-1.4166880198374077,-1.3878355454921707,0.35637431180321411,&
        -9.7954579953618393E-002,0.21347089898564889,0.36935799087063487,1.5012384472511835,&
        2.0733749968078974,-0.33189396684307132,0.23509387355912667,-0.24499614027217623,&
        -0.89758573776305250,-2.4609806011266451,-1.6117600166424386,0.28208749345967521,&
        -0.55768315756470299,-0.24583215975346825,0.39857531884380232,0.96635880278245700,&
        -0.67504785517894172,0.10209585482070721,-1.2124969648279704,-0.42674066189073795,&
        0.41876799960415850,0.53464988357704313,1.5358115308883677,-1.7676726111410566,&
        3.1555074243315093E-002,-6.6123434652894933E-003,-0.13965819902647994,-0.42968857835531138,&
        -0.90164877858558312,0.47387909496645242,0.96787679116719672,0.67028187386816918,&
        0.91860480650166587,0.39646920373789529,0.46634342765808146,5.9022230902277033E-002,&
        -0.79662121481601300,0.88364997000005452,0.25661491833131012,-1.1902509043690193,&
        -0.24426315736950874,-0.87680951715790501,1.6750818445144959,-1.4849576191651761,&
        1.8991692121681758,1.5397959926909528,-1.0881620591947341,-0.41153885704462290,&
        -0.41919456214551004,-2.3712547966328084E-002,1.2751996568739654,-0.38478466567980601,&
        0.24674528008940783,0.34432430840064199,-0.16064397177561396,-1.0002445560032833,&
        0.52476030702645071,0.58040712210669343,-0.25360081010561253,-0.37587680811144608,&
        -1.0175103838200701,-0.32946798418000650,2.7219550652115871,0.79473434531892828,&
        1.1876529552161696,-0.51909412782227182,3.0123322398267454,-0.39823803009926223,&
        0.30626815407716523,0.62896179006662145,-1.0214040002545750,-1.6998630200633531,&
        0.69360319736152642,0.90710495707601957,-1.0930774618114105,-0.18447888009873384,&
        -0.81635029541879822,-0.40092846954606931,0.62159879160020159,0.66476255944625884,&
        -0.22744697589608859,-0.93327631861596994,-1.4700684396686992,0.71298960486074514,&
        -1.0951506132980569,-2.4130014318528916,-1.5168536638695918,-0.68497612752978365,&
        -0.54314598880341070,1.4624514895480212,-0.77911259394185328,0.91930598230054417,&
        0.50046638091675466,-0.34719144315077860,0.55585587919524182,0.71127989577643658,&
        0.70715347695461350,-1.8718669562223997,-0.38061881715793894,0.82434950174600463,&
        -0.31968272946586590,0.74462648817014576,1.2439064284754640,0.60733216454548145,&
        -0.16054870433238747,-7.0193390980374387E-002,-0.58553764287861754,-1.0694354388860821,&
        -0.94161847316377323,-0.49759204803245222,-0.38882004547043919,-0.22308678120807243,&
        -1.5309217666593857,-2.0611847321453647,-0.51659565953193320,-0.96372946247616698,&
        0.54535730744698319,0.53128329140491803,0.68149868946998715,-2.1059111047963168,&
        -5.3562727586220993E-002,0.58637803479983996,0.68651503577054851,-8.6954377111834250E-003,&
        -0.19020323071295339,1.2900992336918573,0.78807682291887216,-0.12204793314910739,&
        -1.1843645910901865,-0.51014110396869272,-0.38745150069832884,-0.17799523849593626,&
        -1.2970792946343865,1.7457194566755583,-0.28840940771211659,-1.0630348036867336,&
        0.16933912534708273,0.87396934364229084,0.40770256266467569,-1.3999302476810165,&
        -0.39055095356272701,0.17369739547628163,-1.1852060426116469,0.70488623381524451,&
        -1.9660189954034089,0.91604273418283200,0.68080541854926235,8.7885692229311783E-003,&
        0.79888282638355512,1.4490672227108634,0.13294165580671582,-0.83940478199328206,&
        -0.23558774422499928,-0.81521685095675533,-1.6152741274650757,1.7304545457421303,&
        0.98254522766489483,0.42552241615215342,-1.9352323863394780,0.20515939735548025,&
        -0.30995679800072073,0.88493718904334207,-2.2218059862226895,-0.50106890711484009,&
        -0.84619972102733843,0.32097035954160091,0.27277059640098444,-0.70315204476553361,&
        0.96058433322566406,-1.4894490540910676,9.1722562311470440E-002,-0.89808224881835252,&
        -0.31611304383337047,-0.14543464730174038,-1.9514797489925688,-0.23000178558218601,&
        -0.35519472709501337,-1.1484009788390925,1.2735875654768272,-0.28428275963061522,&
        0.16390680719334477,0.72967214841151151,-0.26144934114010970,0.55490382930279525,&
        -0.30619155202822568,-0.58400881549326311,-1.3155453767486200,0.58913782830820083,&
        -1.2425126240512143,0.80627803367286399,0.51009044296371608,-1.2693669277615212,&
        -0.91190857566226180,-0.85665105135543862,0.44091058971213043,0.43659843771891277,&
        2.6720648316650421E-002,-0.27941327407197392,2.1511261746326267,-1.4229054205075258,&
        0.30737031077504673,-0.26582864332967626,-0.99875911581932653,-1.1096770644573863,&
        -0.93550242153299279,-0.42329944193046037,-0.56790841506828849,-0.52493182836230246,&
        1.7874515251313545,-1.3156110269633885,-1.6045329136350104,-0.25374288725631100,&
        1.7770567051440467,-1.3340437339913747,-1.0056558021134387,-2.9388276479370421,&
        -0.75403975159084913,0.76229930141850000,-0.11158374616851813,5.4029108838150826E-002,&
        1.6160946782177832,-0.21567484119381136,1.5579008768473117,0.35109829468590864,&
        0.41171906508442108,-1.4819719342984536,-0.59035733765591281,-0.93764600347806681,&
        3.2037779825893974E-002,-1.7496932955448226,-0.10526224567467647,-0.40795101129379419,&
        0.84031170151654744,0.69725104747860989,0.42168577608766966,0.25910772290716683,&
        0.58125876482603001,0.59131789007957025,1.1851982493339512,-1.0982294607311274,&
        0.55325836821828522,-0.89765353831090244,-1.2538034966946290,-0.70782366985783396,&
        0.30433877873498161,-0.89003264073972965,0.27390796562507008,0.12541092621596311,&
        1.1111751307210924,0.11902993085508111,0.64902404166605465,-0.14379326938988010,&
        1.0583548580438205,1.6607733123887347,0.27018404456249723,1.5036230978403771,&
        -0.22365416008202391,-1.7561522144554615,-2.4243428363102493E-002,0.96941372195722897,&
        -3.4738427523448474E-002,0.43828045955565048,0.67864551911214654,-1.7070308527804192,&
        1.0454444015984294,-0.63271298464874204,-1.0165317146104191,-0.69020384913718913,&
        1.3014610013652657,-0.91208042097828412,-1.2262917602938685,0.59960978758642236,&
        -0.15881045151623863,-1.3959588187116136,-0.76503326300530206,-0.48773154629007892,&
        1.9910429080363683,-5.6843624171405364E-002,-0.13639264026859169,-0.42675299539373174,&
        -0.24384313558581600,1.0532025144482946,0.33613974123338847,1.0986305028948795,&
        1.6007701849245486,-1.6355628536184290,0.20206957925252322,-0.33534049330678745,&
        -1.5515989621195034,0.27324010820138017,-0.58362936888798556,-1.6960634666230328,&
        -0.15425571154556747,-1.6195755087335824,0.22533145253532483,-0.24548574637454726,&
        -1.6327723843080593,1.2407019233401930,-2.7980274479700329,0.73609103327180048,&
        -0.42894360224683120,1.2152601461770456,8.8192815099120969E-003,0.17969429459607683,&
        0.39614083744855488,-1.8595222727417333,0.21097691798954279,1.1641223677652888,&
        0.82895547819895032,1.2231950358091781,0.29376737812401083,0.14205196181604995,&
        0.39874050821490054,0.68673413814201456,2.2602965686156908,-1.2782244164731906,&
        0.48433347984388320,-1.1838597945264417,-2.2574684143859067,-0.55513370709735155,&
        2.0990381931818600E-002,0.57254221066188371,-1.2030823398908681,1.0474565222942296,&
        -8.7087093814824712E-002,-0.74997881766779229,0.40669260019825831,-2.7669936987339065,&
        -0.52524415429943072,-0.68721710762802635,0.87907778380357793,0.48226094497564204,&
        -0.14034421933128441,-0.21549339775621049,1.6026216263719659,-2.0889391514838634E-003,&
        -1.5677274527836036,2.2546618951337281,-1.0114677935121119,-0.75730019562590190,&
        0.25706376119430635,-1.1715563693417685,-0.35906934523831457,0.68327913260022244,&
        2.0289935388682734,-1.2183747882877847,0.13723087666951778,1.2512870234024358,&
        8.2546793242253544E-002,-0.93723716210881081,1.0346333971350385,1.3818853320478885,&
        0.29498529846772192,-1.0924151648011915,-0.85217006397800132,0.33143095158661912,&
        1.2826040146685087,-1.5105862268144918,-2.4527680626125234,-0.56836565631297131,&
        0.18072875766384419,0.28322645549713227,-1.3799972699830634,-1.6737655920065948,&
        1.1152988916598818,0.97828520646723038,0.43984158845465021,-0.27700747375187357,&
        0.75732464014933087,0.38524574860670191,-0.58616498936003791,-1.0137060236041617,&
        -0.31296275749469443,-1.9014591310080076,0.74637601766370265,0.90296471356060726,&
        0.67922082359547875,1.1555813537614368,-1.5186731674463079,1.1637449177271590,&
        0.13256842863141577,-1.4217173925599964,-0.31264326630155503,0.23750553477174877,&
        0.46665328413275592,-0.14499742705917817,-0.20769131100898755,0.18117441955925773,&
        0.96217099421391317,0.92232405089961556,1.1535299487039692,-1.1125810073872571,&
        0.94644195179465718,1.5060611545310025,1.2279161953164965,0.32881561821214678,&
        -1.4727664112678964,-0.95627153558674882,0.81701604621544299,0.94274728177819822,&
        0.13385765055347626,0.52801791959721678,0.12272542418783047,1.0048426971610098,&
        1.2824803381442216,0.40039407267262195,-0.97147961139915329,-2.3872696122957091,&
        -0.99573243439326664,-2.2935167099856977,0.51216233534413103,0.18457609137032860,&
        0.75110769126811128,-8.7290761777838316E-003,1.8394312375654640,2.8524636891214181E-002,&
        1.7256730024810008,0.69011075673620303,1.4413858037997596,-1.2543760757311053,&
        -1.7310581091021624,-0.44510468929526259,0.88884558467865116,1.7357046822676629,&
        -1.5160364542821461,1.8076936447736562,0.83552195999291390,0.29764188071043984,&
        -0.60992078541400685,0.54874006039423884,0.38685717744244452,1.0361175721241558,&
        -1.4080121606827465,-0.26650571189761590,1.5879581302362435,-1.1424649859575428E-002,&
        -8.1018053587888356E-002,-0.67836935475530125,-1.0568435060245356,-0.17578058067383942,&
        -0.66355666258509227,0.74374624833383451,-1.4371137560619671,0.23326420683480500,&
        0.35783758760334833,0.82784659238285707,1.2160055515041681,0.76288537099984510,&
        -1.3111211218245051,0.55432114502539342,1.3274843088621926,-0.42067392978795543,&
        2.0711693982097859,-0.31075706078661419,0.53397360499880020,-0.95710502981180545,&
        -0.50386104697826861,1.8501491161802275,0.53405784784380861,-1.5872359017070787,&
        -2.1908660749789033E-002,-0.25530469822125434,0.35400552845687938,1.2503654886837086,&
        -1.2059931682841347,1.1624925930564112,-0.63498915596775873,-0.13192010795001718,&
        -0.74990653916909367,6.7362209165247100E-002,-0.57256691278318594,1.6089360478976593,&
        -0.70930473078460810,0.36098079508395092,0.41660952752580971,0.74602618246889940,&
        0.82870084272863687,0.20185346974540708,-0.97701835961983530,0.83578074712963113,&
        -0.71251683926813303,0.60714844645044597,-0.20516552842985208,0.26640385322055216,&
        0.41064805877540300,0.56588802329452870,0.62405346154331720,-0.53642268240937263,&
        -0.90258310273874931,-0.59346144026874981,-0.61218097219451928,1.0354184760904779,&
        -1.0243981465989422,0.75532038497991516,1.1410466416975029,1.3290625728561690E-002,&
        -2.0509807283552541E-002,1.1959460174045780,1.3276831009029633,1.2344662475842560,&
        1.3852058003377332,1.1802728362121389,0.60790366390384032,1.2352888068086587,&
        -2.3896976976689746,-0.63115975785294887,-1.7468620137253275E-002,-1.5517304643460519,&
        0.67796333667996977,0.43169733582950276,-1.7171667266443662,0.49050080571387933,&
        3.7246752034773185E-002,-0.49051874005970147,0.98237169292748971,-0.20584661039977944,&
        -0.92780959457964829,0.69605573988048963,-0.37133526247961696,0.94646853466688563,&
        2.0003572912856176,8.5229541301862097E-002,0.34516627224955299,-2.1016655434585294E-002,&
        1.5773981951364962,-0.84471761443150384,-0.47535150507090801,2.2918700333511399,&
        0.14147046598543755,-1.2877037181775584,-1.2974426497071250,0.99697790978115874,&
        0.38566520585880992,0.80767998039865485,1.2172373182557827,-0.31392566573674713,&
        0.21858413699658541,-0.64323733072315836,-1.4754348304687455,0.56728943377984720,&
        0.85452573422001754,-0.64127799716278566,0.43692528308795808,2.1090451070739151,&
        -0.92320852595699399,1.0148893085686115,0.89226079534410696,0.10036685357732626,&
        -5.2632110053951173E-002,0.36048852269134563,-0.19059403291302182,-0.31295076669127547,&
        0.39265839388362361,1.0344198301310334,0.65299258833447016,1.4825224399877082,&
        -8.0033594383829967E-002,9.4737411941929316E-003,1.3677769012259795,-0.24810135121065452,&
        7.6367325070213232E-004,0.14017850697889506,-0.41926425142613732,-1.2162558903228124,&
        -0.75913037392005112,-0.21570427971333109,1.1590925527964580,-1.2934526170566882E-002,&
        0.36757134785722523,0.50772183400860005,0.96482976101480034,2.0011976119477710,&
        0.72557644194558424,0.45312145454385711,0.47174909548268645,0.15849454375241562,&
        -2.3772513994423570E-002,0.44406171815489254,-1.4497942341736036,1.2790539064198259,&
        -0.47905994241475119,0.12694318022936499,0.53144407963639029,-0.13881431211838696,&
        -1.0918689738800780E-002,-1.3753535749671781,0.11039530284124915,-1.8762531652647167,&
        -3.8156265169845632E-002,0.86156736719191440,0.87886320189680778,0.19156179425490005,&
        0.46743285969543508,0.13684404743633555,0.45208559005557414,-9.3719166745043648E-004,&
        0.37084870857658758,-0.60080921098002171,0.34766384778919501,-0.85846824250207976,&
        -0.40163153399239288,-0.69349791734980193,1.3544378305643150,-1.0398354459797328,&
        -1.0614354887632391,1.5529868989996010,-0.87476996033464549,-5.8241698876920052E-002,&
        -1.4454693820304316,-0.98248828969282520,1.3468551578533718,-1.7854319265952503,&
        0.14048207583170230,-0.41001140008376247,-0.14953156994234620,-0.12444921845018385,&
        2.2215054314774405,-0.66685575201650027,-1.3636758347208993,-0.94558309952915598,&
        -0.87642224547161585,-1.0210145123109895,1.2551782903464359,0.96500733177282327,&
        1.5006325273316308,1.1124087887031722,0.46021220059549289,-0.83482856726098476,&
        -1.7942041477820001,1.0867871301328611,-0.43184117040827841,-0.66622942779714989,&
        1.1068417119578227,-0.76142869403345670,-0.39108810207521894,0.68564129285314468,&
        -0.59904731425934798,-0.87508682153954165,-0.33932065891607338,2.0764052532568584,&
        -0.29777911422051273,-0.79483000514993496,0.61679802903789593,0.36736223620520819,&
        -0.46846509265182906,-0.26555811965184217,2.2307082844280807E-002,-2.0777720621456566,&
        0.59876560679874324,-0.23324490228916878,0.11842110018583453,0.25887101507800270,&
        -1.5760605381904802,-1.1505778740378338,-1.0236723254012883,0.86780386375739649,&
        0.23667623957240413,-0.73077329052032902,-1.2351658972159074,-4.0688820222795061E-002,&
        -1.3860467115441155,-0.44520887897404976,-0.93369926109855994,-0.87224966537838555,&
        -1.2044815536096070,0.49317098462270853,-1.1397415244340892,-0.17075784286608961,&
        0.17317453234392322,-1.1311479829541882,0.39142608101911114,0.74457279823280031,&
        0.27660729941063428,2.0869838298470724,-1.2176553344169512,0.14995659537965045,&
        -1.2923531554028012,-0.24578868280908064,-2.5211278590240318,-0.27367166247200309,&
        -0.19523215005518349,1.0423196461127535,-0.27170059179129213,2.7022876583494903E-002,&
        0.31972732754449512,-0.61436765864329801,0.55471263601858622,-2.1281605553123746,&
        -0.52083955061880416,0.15729660372427196,-0.16332514963490136,-0.57804475191699256,&
        0.54750620727982979,1.5210908896678859,-2.3907482828963320,-0.31384209094806059,&
        -0.18520286791061505,0.16314448635023476,0.98580544910384071,-0.48070024358704760,&
        -0.76363372570170140,0.82360509655208303,0.95979844999672226,0.85684643144177153,&
        -1.2189809589938572,-1.2036569119016876,0.40550357193143893,-0.45754762298473306,&
        1.2837638182500017,-0.19313375207791567,0.26513538401979003,1.0733969656192227E-002,&
        -0.42366659706748611,0.61204003829828102,1.2829577462623209E-002,0.56091272882892118,&
        -0.80084982995979048,-1.9455728764266416,-0.71950770237966466,-0.94285241450205970,&
        1.4553797452256245,-0.15539941535235827,3.1535690249421187,0.40983492453014125,&
        0.43880907787920892,-0.19179261126405536,6.3913417864527755E-002,-1.1157968371410578,&
        0.37734451573784844,0.77962960949404947,-2.2809006396294462,1.5483374406553832E-002,&
        0.46822158791230434,-0.88342511540019253,2.1179483093301723,-2.1894246396781494,&
        -1.1369846707047806,-0.90675222357312746,0.15839796554827099,-0.38229744496100387,&
        0.67330605269571653,0.46524188616564649,-2.2632900782391641,0.97326815852593607,&
        1.2762050308108706,0.56492875191294756,0.41354635937420914,0.68117754471033853,&
        -0.70156139295057385,-0.97518673395848832,-0.92598333444530601,-1.0837772438746893,&
        -0.20516299486615527,0.61817797514317785,0.53750736002149091,1.5418515669901840,&
        9.3320047405260634E-002,-1.4655378976681339,-0.56670651509469316,0.91691235180728503,&
        -1.8927206550084534,-0.20389807550908451,-0.96007120356265852,-0.24768222078788221,&
        0.64875931350830440,-6.1446827148686496E-002,-1.3269152139826570,0.14626579054152553,&
        -1.7363029523809005E-002,-0.82834183339136280,-0.21736654547505152,-0.77653773535122761,&
        0.12174206542798442,2.2085232499769845,-1.3577897811906459,-1.4122095392047882,&
        -1.1347340534744066,-1.7245040524385735,0.94650752411646000,-1.3395284198566459,&
        0.22643988921322408,1.0167602827939559,1.9464823178486030,0.79939978185190907,&
        -1.1742002122539161,1.3892860034811663,1.7943698594749344,-0.41214211919203947/

        DATA MC21/0.25678607295206207,0.23436795631575846,-1.3611944684587070,1.9416585793003633,&
        1.0900930006867946,-0.33980611766868946,-0.73838636496524968,-1.7451631968504844,&
        -1.0484569613929036,-1.0867085016348752,-1.3118724360300664,-0.38535072707249557,&
        -2.1136421260946627,0.54519910190809739,0.26638942440803537,-0.97627476759471488,&
        -0.50025021449757168,0.95161134822507443,1.2333544483265053,0.56158420167696221,&
        1.0105124255835298,-0.87180494370062422,0.20230199789285488,1.1046797708818430,&
        -0.61555867244392348,5.7951335255819851E-002,0.80657779225511705,4.3718554464809385E-002,&
        0.28664308471136118,-0.30977665631362483,0.18647051454431809,6.7907592564845215E-002,&
        -0.59175650102579891,-0.84701372234726979,0.33403971320963399,-1.0649393575332549,&
        -0.56591773969143289,-0.56934188543855013,-0.86914373414044943,-1.5839500108787414,&
        -1.5207790034704025,-0.40660829202520299,-1.9850895498190038,-0.83805066273639506,&
        0.84809981876926532,1.6991244879318177,3.9060702275764733E-002,-1.4026044885424074,&
        1.9013669867204581,-0.24993034672402467,-0.75791859858797928,0.33588608798296887,&
        -0.52524269457050776,0.67135508236948760,-0.28935401752073631,-1.2961369154248703,&
        1.6987308467608729E-002,-0.33580205768118482,-0.23572287132056829,1.3918175302612483,&
        -0.79216447530133149,-1.9730662945826682,0.42484161254467584,0.57398786166692028,&
        -0.29283157985282826,-1.3178817282009425,6.0110193542964041E-002,1.0641505343670428,&
        1.1522226498746497,0.14591526118724155,0.75334152077460037,0.39064540784582952,&
        0.40738598222973277,1.7616834846808487,0.77499405331661231,0.19741802265660643,&
        0.90850912140803808,-0.22304449696162779,1.5095247493161297,-0.96332873292732024,&
        0.70499537333398032,0.38434223488348318,-0.85388426076642632,-0.22438152547209975,&
        -0.61465659517364646,-0.38046727358628651,0.73152066505693392,-1.6009115382473906,&
        -0.56347964991742916,-1.5704973734348966,-0.55359586802981453,1.8628066527463802,&
        1.0109938873855166E-002,0.93311850500435756,0.68333820644921517,-0.93233192812740151,&
        0.20661852417147542,-2.8449509215567569E-002,2.0941172235877787,0.32045022773554843,&
        0.53274906180186954,-0.30088853941918470,-1.1660780109799189,0.22700763557996484,&
        0.97747740852981801,0.43124677281285589,0.39203404108354689,-0.61285131624693057,&
        -9.5053988845030302E-002,0.49836469331121891,-0.64818517846145896,-1.0907705957690579,&
        -0.37740853674597208,0.53786524019592641,0.44642903540850515,-0.78502721584453627,&
        -0.75156576063265756,-0.25777927545025736,2.4336950002780742,0.32754843228113129,&
        0.49416207611213814,-0.61625825665443767,-0.63315874550083262,-1.2656367787278335,&
        1.7062944051437043,-1.0940552748323054,0.38111853196809858,1.9936585756718450,&
        -0.59347182582508129,0.80792323163069601,0.70109963597346514,-4.0221692030726723E-002,&
        0.15273899228115770,1.3932896304032028,1.0384019648358624,-1.6278998726456368,&
        -0.11439879300732669,-0.40468148736090148,-1.2567624973157294,1.3051327453270731,&
        -1.0061332445469400,0.60648536999537372,-3.7054112312094351E-002,-3.4814523350261035E-002,&
        -0.26889568136612896,1.1338711163262012,0.33391969109564734,0.71698367524628148,&
        1.0669378534947760,0.32803347035150704,0.15777762112458057,0.46512743785336996,&
        -0.36760249680990786,-9.6231168727978475E-002,-0.67131150409142260,-1.0056456245397234,&
        0.40527040425287936,-0.11578576499089009,-0.23077697240523631,0.54913637925926584,&
        -1.2349374947287610,-2.5201040122196843,-1.5518952623238846,0.46366450505770501,&
        -0.86358164828514683,-0.19201079032466817,0.26253210739462901,-0.88594940341882455,&
        0.26363900571685833,0.76750178416717740,-0.33236044813524435,-2.0008267681331402,&
        -0.31927420681188234,0.72042294890263459,-8.5694964975936858E-002,-0.56328698173531189,&
        0.22055953611563681,0.22377369298388827,0.58016820817790571,-0.27573403640306865,&
        -0.45773935816505062,0.25195627525231939,-0.78293907947859132,-0.70577608185955187,&
        0.68894391395895327,-5.6713797315861214E-003,-2.3335854849650155,1.7206920275626061,&
        0.80010781175152468,0.96677823841252630,1.1641708991938631,0.69362762840440206,&
        0.90784794334854890,-7.0782513867795549E-002,-0.61426222986424206,0.61156923656658935,&
        1.3744372858273142,0.55085528622500113,-1.2009363381794453,-0.35388939565385730,&
        9.2646489516744729E-002,0.80884133616555098,0.48852290375395718,-0.35416392870958929,&
        -0.11074774400199949,0.34763829076000341,-0.49046399992656242,2.1619627055827420,&
        -0.55783011217761724,0.24260459151281064,-0.53353628407962650,-0.88685737078319749,&
        0.22611219235632574,-0.29041311939117526,0.78066238309310509,1.4772116254853318,&
        -0.19614363183884662,-0.12680827854131352,0.26007180818087078,0.77929297771049200,&
        -1.2527639320472881,-1.2015864693775682,1.5298055427174531,-0.34623658569708710,&
        1.3460217138576132,0.94822311544451066,-2.0418130578210478,-0.45064341220448223,&
        0.65129044180497275,2.2880657602968255,0.38235959674913900,-0.51036234215680620,&
        -0.79129847993882452,0.63565716351505741,-1.2044328400657534,0.24102172860235976,&
        2.2346911930748141,-0.55872247662310837,0.41062847315482481,-2.2194929975276936,&
        1.2100586341089747,-2.0908950370829791,-1.3043205004069331,-0.70962868634010923,&
        0.18754524584686294,3.6508982119004864E-002,-0.49108477462752487,-0.58286115857381393,&
        -0.85927667069721725,-0.64534861454810322,3.8295231714988123E-002,-1.1165929868530129,&
        0.94758989084954059,-4.9146932173811435E-002,0.83813421490299134,0.18928848736024842,&
        1.2097350359477204,-0.19167317132171449,-0.35449742279067842,-1.6726820527909703,&
        2.1488670786721071,0.40791698962315337,-0.40689880364071046,-1.2551303746497544,&
        -0.65294152755450652,0.90089181312855271,9.7491025376766405E-002,-0.64248450462153706,&
        -1.5849369673045315,-1.1108293650951946,0.74352391724423583,-0.86551583073982308,&
        -0.88684224614633389,-1.0279683220455469,-1.1289293655705446,0.61294039644768450,&
        1.0507913628388208,1.1071450142624566,-1.5285992739310683,0.13440918673954719,&
        -0.57889819772546525,0.15551615540539607,4.8738522621780182E-002,2.2006894187024589E-002,&
        0.21973895669597898,-0.84126279156774397,1.0700917649917066,-0.97452693729273665,&
        1.6222998259095167,-0.60899244734523561,-1.0374756292623473,-0.66126464557382036,&
        -0.48527857528904406,-0.37634888238352410,-0.62717657347131706,-0.16906572899261899,&
        -6.6441257089826289E-002,1.1157032278308852,-1.3138411333412519,-0.74857789933374841,&
        1.8847812713052414,0.18500387473352778,0.19191185514554099,-0.72486614494787915,&
        2.6621280388545287E-002,-0.60134992226977335,-6.3649434809079225E-002,0.25999784327296738,&
        7.4641107677863278E-002,1.1248902386423194,-0.62139782332729931,-6.6828495340653493E-002,&
        1.4370719136455674,-0.83135921041989613,-0.96782636114929610,-1.4675738361445090E-002,&
        -0.28060974477305695,-0.82871895876725921,-0.61523192017577510,5.9639515365998499E-002,&
        -0.89427783503502145,-1.7231215598085114,1.2771920068432718,1.3164007784182139,&
        0.12552929307194999,0.78637538027876908,0.83507637469883333,-0.45489565074402627,&
        -0.98118464833870822,0.51755721377739450,-0.17134048407931726,0.26574458597265105,&
        0.48610508244759132,-1.0871443812040269,-0.84892224359620094,0.67992246188781535,&
        1.9023327139803439,-0.14155812490463748,-0.41416569122177854,1.4260462877646893,&
        2.2337357640561497,0.14633242237520552,1.7623303528535834,-0.89831521632261835,&
        1.5481590388007860,0.67776007821059436,-0.15296166267518227,0.22586829775072828,&
        1.1461607411685644,-0.20203913979733437,-0.63495543451276160,0.96732367339207881,&
        0.83570570579643655,0.23170487222330149,-0.11803878749620596,-0.80814671586889175,&
        -1.8465468246858499,-0.16311624923489448,-0.43141525529198155,-0.42005362943098257,&
        1.3150756633979783,2.4953840275336878,1.3765194783225372,-0.57809812640301728,&
        0.87285548963606707,0.22374540269854915,0.28086904707700971,-0.16647346845550640,&
        -1.7463215830217587,-1.9707073661190835,1.1627161336106926,-0.44024155360251593,&
        1.6283764396800882,-2.4808779107368409E-002,1.0975018586908867,0.41935945445875533,&
        -0.15359303350428996,2.1202961227365758,-1.0571029387642379,-0.39061493862188457,&
        -1.9092535425976918,8.2532387946953126E-002,-0.77024301333765000,-2.0000578190825293,&
        -8.8982719687610151E-002,-0.91651167202159711,-1.6568413119099878,1.4423105816928607,&
        -1.0763993897535933,0.12475916336772985,-1.2661024487896415,-0.59096769271370952,&
        -0.49819380621497850,1.8715712398716857,0.28247459227606775,0.30841366877843940,&
        -8.1212162085410766E-002,-0.45372657069362293,1.3397757881488024,-2.6307656868851876,&
        0.94335216914796738,-0.40787457144832517,-0.36015033230701526,-4.0004726431137290E-002,&
        1.1501266920132545,-0.15969327762768529,1.4420320518296124,-0.84095117652504636,&
        -0.11010442726952732,-1.1447489592468407,-1.5041893642026412,-0.43003164668504035,&
        -0.44208847509695093,0.71905283816787002,-0.38067033934105859,1.1635818591529512,&
        -0.41897511129103876,-6.3129295357002346E-002,0.58691718645912361,-0.27879560501869005,&
        -1.7875280694806237,-1.1692414088034906,-0.22139668773942045,-1.3111637554019977,&
        0.27232082805785862,0.22451233448970648,-0.38193381675643312,0.34234782074380027,&
        -1.0033547723476683,1.1298679670522862,1.1971830397676564,-0.48115255432880533,&
        -0.38796827807706591,2.2524066637296582E-002,0.59149642609213748,0.62501397892979838,&
        1.3801753435533062E-004,1.0950301759084118,0.14115982992722867,1.4184382304464331,&
        3.7500687199681394E-002,-1.2394624752596251,-0.23206454790458886,-0.97688090354797763,&
        1.7353787300447818,0.29870519378104748,0.55082169910264622,-0.68415931941417374,&
        -0.16638813012543816,-0.81923848835400770,-1.0643039804233809,0.10616045954434075,&
        1.1275929586224056,-1.4312611888636408,0.14798929744145109,0.48959016956395823,&
        -1.4749581705182493,-0.34755426790014932,2.3759923745534313E-004,-0.41842142280841144,&
        0.56347054028321042,1.2698432859987407,-0.97570136657035689,-0.71204791235696929,&
        -0.48866021500550622,0.62379270906743700,2.0342706043751095E-002,1.6079235429062806,&
        1.4296040934480376,-0.53330833672834177,-0.20368936426719911,1.1370353196955296,&
        -1.8220271396640439,-0.32895828183894654,0.70865729504954478,-1.0395922883804751,&
        -1.7529346095288645,-0.97877182941066232,9.5614669412336983E-002,0.52959926726615025,&
        0.58321629076039583,0.76976399103853055,-0.64472338005443697,1.2879493276323766,&
        -0.90522894723386660,-1.2390708575516922,0.45506930538488749,0.83017454294173054,&
        1.2865703723055602,0.53587387364693151,0.16288037064885977,0.69194807026866323,&
        -0.70587127545184691,0.27864377280763541,-1.2644144151294712,-0.50792801470559523,&
        -0.21454436540315264,0.52287833413973583,0.93299976261520357,0.15726786743797475,&
        0.75628132850103424,0.65279311327741174,1.3071722618848680,-0.22303002304985275,&
        -3.6100486280619376E-002,0.18785052243705944,0.31837968568529185,-0.66698998175028412,&
        0.30998984168587090,-1.1035597280207750,-0.16095578899002810,0.92726748772607093,&
        -0.82250961999910799,-0.72954038599340321,-0.57009323918290611,-0.23683476013223650,&
        0.57319816743534791,1.8145172425122598,0.28910605647693255,9.3985888412716531E-002,&
        -0.88531577832155950,-0.74378025707646322,-4.8016705329768317E-002,-1.1553674724139322,&
        -0.21420458113345253,2.0527985554855999,-0.11200641977897473,0.88156919471113604,&
        1.0210327449245371,-1.1256854288660532,0.53472572137597696,-1.6192476363938837,&
        0.24763196356636052,0.36061936682550022,1.5633442846449648,0.18473739954494570,&
        0.32933950188183092,1.9325490361792133,-0.43387787631362540,-1.4038560643259650,&
        0.30579865653267796,1.2599839825352064,1.3858652241072136,-0.89446935694050023,&
        -1.4874317512091757,0.26457434008596553,-0.73902304307245870,0.99314288138125073,&
        -1.7085927415952145,-0.92881470674637800,0.57635913431478747,1.2575129857199177,&
        -0.14427510082054454,0.54620249333522553,1.2984781137864256,0.84913696270662375,&
        0.87661685827078129,6.7228541649175695E-003,0.20633245979226045,0.83823925329485127,&
        0.80430242889100612,1.9451581066215402,-0.68564553389651695,1.7266761165993540,&
        -9.1132956181814467E-002,-0.86339682524103134,5.4154276818189684E-002,-1.0740796954303844,&
        -2.2650790338750255,-0.45999625925025456,0.60105252051914038,0.48895210505478398,&
        -0.55935986768929902,-1.1156384482757744,-0.85936249233823947,-8.0962168697238518E-002,&
        -0.36524551940673333,1.1331529296362333,-0.61692553527883254,-2.6226914176977645,&
        2.0740100408142892,-0.30015482779215524,6.7773771748535286E-002,-1.4050742273691226,&
        -0.91506878550982451,0.15705256076791874,0.72127419269499427,-0.16331284610506352,&
        -1.6628877980973666,1.6592548177245132,1.5310921206076831,0.75818379157734939,&
        1.1270226236707395,-0.61229934233064653,0.63377964267307951,-1.5542739458559645,&
        0.55583017699705806,0.40027871373840673,-1.2027629498766075,0.10769460976703281,&
        0.32644663296204657,1.8764885304807837,-1.2047184952546215,-0.24461459232788263,&
        0.42923461248517747,0.57883619743386361,0.78454395865558779,0.65113919771877415,&
        -0.31102612606389402,0.21682505684559236,0.59398989713312322,-1.2983427661453373,&
        -0.11174002593960931,0.92517232849876285,0.38218438830899037,1.4804630151492433,&
        -1.1659305923015926,0.61626014037400834,0.16967033559443187,0.23561199618235654,&
        -0.99960103933472322,0.28398252081641212,-1.0229908409485189,0.49410186326497629,&
        0.27108596254770034,2.6478734266633648,1.3344456651711361,-3.2133256457892840,&
        -0.48103863524062440,-0.96987537436212778,1.0172048848703434,2.0018146274595097E-002,&
        -0.28440574679203823,-0.87212553485942679,-0.21029914436284666,0.45660106112216953,&
        2.4284800502954652E-002,-1.3577981062836748,-8.8891310626983355E-002,-0.20186254099827453,&
        0.65699894395261094,-0.23877486867973791,0.63704799589519046,-0.13442382640858003,&
        1.2709805499669289,0.76967890934462424,-0.50125884233440421,-0.88284432800385815,&
        -0.18055473031228605,0.35484361188202057,-1.9455671390146441,1.0139323501424509,&
        0.99433039711267923,-0.57260547278262020,1.4419070391314268E-002,1.2610595784207792,&
        1.5689036104378269,0.51321585860291019,0.75847127250869129,0.16928600812249606,&
        -0.27918513019222940,1.2531381292936361,-4.1139899479770018E-003,-1.8691590972162468,&
        1.1057413991047744,-0.23821354984982951,1.9599369164228775,-0.84151791598094161,&
        -0.37090840384571644,2.9993804370852581,0.70303991793414056,-1.0343968496680154,&
        1.7755767754451339,-1.2843203145268554,1.4124277525377138,-0.19812402203518714,&
        -2.0054170189584366,-5.4518630353323924E-002,0.27940539567085576,0.72510440923457087,&
        -0.10088561240315419,0.29895097061971582,-1.2197955946954382,0.69052298555436076,&
        0.28011798788412628,-0.74889992379955017,0.12041685989171165,0.10337722965745419,&
        -1.1092056969288204,-0.19049920361388678,-1.5827185550456739,-0.39228658343626821,&
        -0.66940042937273525,1.3845835775767223,0.47881668670070587,2.6617210116118194E-002,&
        -1.2745440736422042,1.6550272787573790,0.62568059370507056,-1.0741042320094383,&
        1.2552655563751007,-0.91685074519020160,0.50419585883159168,-1.2698992076145665,&
        -0.50296767274098320,-0.63534956837986845,-9.6155187243137832E-002,1.3688835199117644,&
        -1.2054626632319816,-0.64452784857956624,-0.90587035615117462,-1.0741748197846546,&
        -0.34335853538873490,0.30647759897521770,0.55372457922172558,-1.2319678212879146,&
        -0.92870687513778949,-0.90140698328830859,0.24124484131804153,-5.1031694318521656E-002,&
        0.53276260963688071,0.42072435597575214,1.9150393035774675,0.15268989551954940,&
        1.2761004979663009,0.40377090757127598,-0.94697797712411325,-1.1788536348672407,&
        -1.1703949085837657,1.2308406158387311,-0.35123187000817629,-1.1525154317264543,&
        -0.17790383346526406,1.4246801550460171,0.21216690917677580,0.73631073682702863,&
        0.11296841351038545,-0.39132899940600019,0.95690761663098767,-0.25295437153863831,&
        -0.80392928866902524,0.51902621662070381,-0.40704311995132170,-5.6376115127644712E-002,&
        -1.0213653299326046,1.0496688028358139,-0.65639147202611703,0.86569072538919900,&
        -0.32005871786657486,0.84275063426960040,2.8113778955109612,-0.36319835491698937,&
        0.59236551834915163,1.0330325808052698,1.2605472922191767,-0.92250681256213884,&
        0.21382573158083706,1.1757936521237309,0.52767101128434324,-2.1480258196451651,&
        -0.81943148455567993,-0.88323916588097018,-0.12057495840614985,-0.41647885674489915,&
        0.53431229317235551,-0.37387130272668162,-0.17926583191349957,0.32661063405183027,&
        0.27578441866828057,0.63164358123866660,-1.0196929314163621,0.11054782639007195,&
        -0.42155220281893335,0.74491092033931450,1.4773401530372978,-0.57383301128289654,&
        -0.17660410378166447,0.28066444029520443,1.7644042980036867,-0.85858416259357107,&
        -1.9327510980387026,-0.60942302592391462,-0.82067001117036154,-1.4073809727850664,&
        0.66105376126647586,0.78132641087113996,1.3030831883780196,2.4799378567775272,&
        1.9102858719218034,9.9316040945606504E-002,-0.97572804263809476,-0.65618960393416514,&
        -3.4092448758768434E-002,0.62071787550592195,-0.21833652867227796,1.6122315502013651,&
        0.91806137848646518,-1.0072098310539661,-2.8859503025524969E-003,0.64434223373581323,&
        -0.23634212083616896,-0.53361679921517879,3.2121855920894719E-002,-0.38617441001549097,&
        1.0854558714050129,-0.48368568103982518,0.79863733396552472,0.99543696498772205,&
        0.38361532240113638,-0.50291591289630022,0.50860921914952151,-1.6992202742623814,&
        1.1976758099384495,-0.26121376103797694,-1.5827905696070876,-2.2922465801734115,&
        -1.5098920697206588,-1.1517657502830647,0.55987116595889841,-3.9305709264052274E-002,&
        -1.3274845642902866,-0.40007103826568180,-0.70477666438722053,-1.1435915308191498,&
        -0.26073046152491441,-0.42798624368408311,-0.17966153117441672,3.1456841607965344E-002,&
        6.8561483791453233E-004,3.8180439556754500E-002,-1.2172985617613583,0.11937063809058465,&
        0.28341702272839969,-1.8602231995531653,0.94064998113224618,-0.41970554015732786,&
        -1.2342661061721905,0.33108886267207488,-8.1731496696897124E-002,0.76375869982876987,&
        0.43898844854262664,-1.2705879637544528,-0.56990800028642785,0.37746015357741985,&
        0.87254972830023747,1.4932542652742229,-2.3767706925281997,-0.49134931314258595,&
        -1.7461404028322520,0.52638930473709222,-0.28988503321711734,1.2397886258475153,&
        -0.12391939045242201,0.50685902251991544,-2.4967049277499367,1.0041271384469108,&
        0.28707521938489328,1.0993948877092292,0.34711909421934412,2.2270345404566476,&
        -8.5506879623751184E-002,-1.0072091108448606,-0.33333657116249471,0.41161946648634429,&
        0.66056001664608799,-0.39328938632772376,-0.23681573378621201,0.78196711495611637,&
        -1.0110835309942232,-0.37064804389221101,-1.4108716854487005,-0.85654541408509699,&
        -0.37245567216735082,0.67655129143679404,2.7270428133905864,-0.88643683313466970,&
        0.86151321190996533,-0.12380964921418214,0.88736374758876357,0.43554397659502975,&
        -1.3191485818661450,1.2480915374154673,-0.32296494885388866,-1.8221211703458260,&
        0.87111999425737441,-0.37986088354463193,-0.19104907381120384,-0.29944009809990285,&
        1.0893255315794450,0.27495385054691157,0.65412262751483408,1.5036922684438654,&
        0.55747863048309443,-0.50870482961932617,0.97245289545897928,-0.74872281760004467,&
        -0.29702453064882806,0.18303527624451083,0.92776351055602491,-1.8886888931122747,&
        0.66665970224536930,-0.10731006837681295,0.68335953597260457,1.1363324637417622,&
        -1.5347494791446734,-1.1117952557423765,-1.3217776005834998,-0.48781782111910144,&
        0.40561617204930561,-0.61500342963972199,-0.87002657384464521,-0.43916595776436895,&
        1.4167160313455605,-3.9686254643507227E-003,0.67214930724794708,-0.32416557259756501,&
        -1.5659942502460398,-0.82475478036155736,0.22766146544134849,-2.6386329104201297E-002,&
        0.99872651533832468,-0.78077601838692745,-0.68756433970068087,-0.59349240928373415,&
        -0.98091295507414478,-1.5572446318347075,-0.15378306712406883,-1.1698605968809168,&
        -0.76819955357195135,-2.4351904379287262E-002,2.5837140151337019,-0.67652276250059018,&
        8.5404536779504492E-002,-0.15089597252059966,0.66767281945719603,9.1275604617710601E-002,&
        -1.4289306569834144,6.6938202303845507E-002,0.49943590871669702,1.1939114874038084,&
        0.43979644068933071,-0.54718579157709213,0.89199987705534745,-1.3959526674733822,&
        -0.66258693535714352,-0.46795780272162901,-0.70821141164266421,-0.47776802373061333,&
        -0.39536620097848302,-0.42075725321413809,-1.3801561174959021,-1.5511788209599779,&
        1.2511138733249694,-1.2471558511235417,-0.59413327078668887,1.7336480464388946,&
        2.3784090981404233,1.5184832439583349,1.0964325998142088,1.0162040688682694,&
        -1.4415349405590963,0.21750433351541346,1.8996108658141284,0.76523241207313464,&
        -0.31847668705184368,-0.16730242256668382,1.5970115830884315,0.15977961799983054,&
        -0.41060173244838061,-2.8944215407442626E-003,-0.90133194956196017,-0.74208047304019720,&
        0.29496421909092058,-1.3139303912745175,-0.83429065855952189,1.3761124942729372,&
        1.2202243394541150,0.32191212300026373,0.79842795182301529,-0.17913158962178957,&
        0.75862028157010575,0.20199418725315355,-3.0763907184795120E-002,0.20835795704172280,&
        0.76075022886657662,-1.1856292145878000,-0.15940558364030444,1.1433288181466170,&
        -0.82665275836352059,0.49018158714585597,2.5469701180380167,6.5850126657409108E-002,&
        0.27469983613154964,-1.3381921180349972,-0.12708779266441439,9.8210610558169958E-002,&
        -9.4880758534024431E-002,0.89425185815341091,1.3021317528393188,0.19937317170008736/

        DATA MC22/1.8682091032378143,-1.2786820174002365,-1.7571364617724088,-0.36162068127804270,&
        0.84905774883659790,-0.78188863006174536,-0.51564391312480284,0.68810707264032844,&
        1.2553346878334011,-5.4830702227901339E-002,-1.1102762118020180,-2.2904911422272654,&
        0.54842490477296835,-0.72353362750334005,0.60695509258183222,-0.55230533613485555,&
        -1.1146067361688068,1.4138572184878253,1.9407229172404903,0.35297303127120722,&
        1.1624638204153515,-0.61261843204725297,1.2396661760775027,0.98593675180718110,&
        -1.7504071038563740,7.4802243565680118E-002,-1.2388077261100920,-0.39911528772109733,&
        -1.1788360195408440,-0.94129163787035275,1.7913599209965780,-0.23854260898706950,&
        -1.2568754862084917,1.2614824771812461,0.33024999086215129,1.1664804934629309,&
        0.17862081420610973,-0.98283015134155083,-0.24834262181566541,0.50846938611176140,&
        0.94364262162404644,-0.43638523791300088,1.3065499850092559,1.2765996473380594,&
        0.28232357596163316,9.4319797438884492E-003,2.9636679060183333,4.6681623066893843E-002,&
        -0.31763050828991884,0.98657458777287388,0.26101960216565445,0.41065575296222984,&
        -0.30734675302325798,-8.1033936454186745E-002,0.32571850274373187,1.7352465137830498E-002,&
        0.29869432819372232,-1.0489626288044984,-0.58558524803569090,1.4347443462890650,&
        -1.0546498802057118,-1.6117073358641507,-1.8963670545463547,-2.1909065149807954,&
        -7.9469829364768027E-002,0.52058316542318284,1.2763655561284879,-0.50710012042236186,&
        -1.1096797486873669,-0.82910751094748458,0.44546299013273466,0.31946005115519266,&
        -0.88007623631067355,-0.58933186339992194,-1.1397767014974314,0.28916080949862000,&
        -0.20756294707355524,-0.48138585954352858,0.57764681951743913,0.28249380173336180,&
        -0.56370543174462195,-1.3863661190361405,-0.49749193090184463,-0.79782907827772043,&
        0.21660924065292667,1.1651540670973695,-0.38823266435571652,7.3835425933272650E-002,&
        0.49475272805636450,0.83551194390127059,-0.16186900729699313,6.2473300081648309E-002,&
        3.8223571458335555E-002,0.22676061976864534,-1.3479560797448491,0.60118791100261304,&
        -1.3969193745032993,0.32201036931329702,0.38011315638327103,0.46929801047757524,&
        0.49957314221931343,-0.46706249776057396,0.58524092800961969,0.38335765525041149,&
        2.1612508944618005,-1.0794360587419616,-1.2869989304662144,0.35367695738572397,&
        1.4385260848935411,-0.66348036025940826,1.8971307274730389,2.0854573015913527,&
        -0.60329848856613078,0.50501141685394102,-0.76428385691908585,0.56656676019535790,&
        0.37297974514131538,2.1881972225550417,-0.83411611112364770,-0.31023562832539209,&
        0.42090028403452284,1.3951347949049071,-0.92534395194940089,0.69716719160310181,&
        1.9324588134503151,-0.59469364828389681,-0.38148688954613680,-0.18542135130181767,&
        -1.7692235317157410,-0.66120743055079567,0.97468934401869334,0.49105788672344719,&
        -0.36482774562068176,-0.67883894475127471,1.1355429074858838,-1.8017684936643834,&
        -6.4141490833317841E-002,0.50431018200165567,-6.3152327548393811E-002,-1.3426224702038831,&
        -1.3095540035019626,-1.8629260713517706,-1.2567945573287592E-002,0.87784576965229999,&
        -0.28901888158878880,-0.57485132009210826,0.33425687930170750,-3.7055117021844004E-002,&
        -1.2351233521458937,5.8279312980201572E-002,1.1450617632413096,0.58208265126341130,&
        -1.1437106898763347,-0.90109824402409844,0.84947370131553634,1.3641103107420554,&
        1.8151135633301236,-1.0875976556266225,-2.6678348850841989,-0.76858877178711937,&
        0.75772910845223873,0.69937497475769872,0.77179442846679036,1.0580717506574964,&
        -0.70062023696670550,1.3550471832615776,0.80835262561329857,-0.98905300477746516,&
        0.31799698869936077,2.0678067801282034,-0.16875825820355786,-0.42167036955749987,&
        -2.1553135206363896,-0.54586201064771422,-0.43150708735001325,3.9637151616623713E-002,&
        -9.7049554699035534E-002,0.75764208119124254,0.18906805797529364,0.82709557531140410,&
        2.2224813042016396,0.39210994256153542,-1.6663737416527478,0.35327924808808975,&
        -0.22584478585671647,2.2551126814385438,-0.17525892045663730,-0.66703496643502003,&
        5.8469118500644408E-002,0.99628546927869577,1.1212161814749551,0.82576413727490250,&
        -0.33951194659853462,-0.63036762871285068,0.52573806560405378,0.48131508158333131,&
        -0.46750671843862318,0.13356955146662453,-0.17334306391914089,-0.46648347050314881,&
        -0.33024827620682229,-1.0374279428022222,0.94365757774105696,0.40275779178212712,&
        0.25653644273566673,-0.51066348400893924,-0.21743755055939903,0.98209119686013246,&
        -1.6218918771895683,-1.3457520639883886,0.49310727207716687,-0.63576336287266388,&
        -0.62463652034702766,6.9069435662649503E-002,-0.32867772978939858,-0.83157232370113121,&
        -0.62096490498783075,-0.87991081891154954,-1.7500852704160739,-1.8382943008507635,&
        -0.11321438225339933,-1.3123280423890153,0.13548325117926932,-0.11187382098353610,&
        0.86440102200907776,-0.40750853458686059,-0.28764386395533226,0.39755727129438129,&
        1.6693054586415637,-0.95223425354379143,-0.83310528540882689,-1.2485529180183341,&
        0.58109942566781358,0.39877325946652692,0.86200373546510367,-0.41419615075404514,&
        1.6449137855902876,-0.96394520939004191,0.93556719069035632,0.52979710145792025,&
        0.60275993844085896,-0.15598831609117603,1.9777965196872049,-0.22653706240810484,&
        1.1786167079971197,0.28429133038493526,1.0206922208613753,1.0978011435847506,&
        -1.3501633782673865,0.18337852315722550,-0.22735781735663291,-0.41864755346085408,&
        -0.37646212294707171,0.87810020885471762,-0.54370539005179364,-0.98329817931745822,&
        0.81222685276695883,-0.93469858370126546,-0.57906328081455938,-0.13837053109314756,&
        -0.94098539251468194,2.5114428135792313,0.99433989922659149,-0.45217896623456927,&
        8.1121787839089576E-002,1.4587982476758756,-0.19381747319209666,-1.3035240492303157,&
        -0.18748874875273902,-0.15106014501641890,-2.4920985613237789,-1.1980668270552397,&
        -1.1536377152307944,1.1024281739498223,0.79810787075058032,-0.96820676631063840,&
        -1.1430950191730927E-002,0.96634663523932640,-0.59614282585502432,-0.42574516981245197,&
        -0.13199976715529407,-0.93886386661039345,0.64167673358768440,-1.0563382316184311,&
        1.0556734078429790,1.5101336344130729,1.3998083188963792,-0.77150553083640239,&
        1.1579714718418712,-0.76207892325559656,2.2001936344745103E-003,0.77062704665943227,&
        1.8399729290279985,-0.87109594257354450,0.41168828610950414,0.29599161369245630,&
        1.4633282374131147,9.3750311787727511E-002,-2.1731842166025097,-0.76501570401038643,&
        0.32443780029283953,1.6490337928022156,-1.4250592269171800,1.1434879747840883,&
        0.68666218541824908,-1.1962146965846863,-8.7084413788553819E-002,-0.40987209416123249,&
        0.15468289553918635,1.5129790495041997,-0.79954713628901097,-9.8682485402095729E-003,&
        -0.15331330539421339,-0.25942647458087292,-0.54170397766451195,2.1023219654111092,&
        0.11085822012292208,-0.49747080834785351,5.8860924983878640E-002,0.33209089566076899,&
        -0.80160708675527059,2.2443496682464597,2.6698302930104165,0.40612324346797463,&
        0.23160498317150682,9.4890176529800419E-002,-1.1416981356106572,1.1941487813562361,&
        0.78326288174688485,0.95187046072809645,-9.0573223655936314E-002,0.38022521247687008,&
        -0.38996837181281746,1.7945190395653321,7.4541738831245222E-002,0.15043116671719123,&
        0.97573751743863468,0.11888497942826644,-0.64487028324393514,-4.0170957855509212E-002,&
        -0.84243821505235039,0.25351040524148682,9.5860987647472556E-002,0.32402882799703936,&
        -0.39120747679766588,0.28080522694410409,-1.5622735296919779,0.40148514051535911,&
        -0.70503634026143491,0.38450418399179448,-0.89869037455647238,-1.9034922302262542,&
        -1.5480955265198599,-0.14284671201776988,6.8865230059247426E-002,-0.85695469411269609,&
        2.3477184245092433,0.48305785083058472,6.4236585481594902E-002,0.75968311693974078,&
        0.13128852075042319,1.8473594328966363,-1.1282214226314202,0.72748851286282779,&
        -0.38439139279818452,-1.3016918946606659E-003,1.4695280641292292,-0.82280245507704763,&
        -0.67472522389360323,1.6802721264471809,-1.0806311129531989,0.34036948261533895,&
        0.30317912034687994,1.8929823251335065,-0.53457740438905821,-0.58760442736897611,&
        -0.17456108083955418,-0.89255188932371654,-9.4814223488448035E-002,0.34715542148697148,&
        -0.81191221286161652,0.56353422135463416,0.21074642923003573,-1.0672092912216511,&
        -0.22240524138488710,1.2045307269227217,0.32315994811779136,1.9202395915861086,&
        -0.32127507009502537,-2.7714106999464326E-002,1.1533948302445542,0.35439318228618655,&
        -1.9761049842010041,-1.4090206658183795,0.38277424872115762,-1.5513189657076358,&
        0.73981515286667787,-0.23677084567356055,-0.68671534495142050,0.41204463482986786,&
        -2.1845163084174875,-1.1996443833554766,2.0248267377450251,-0.43535713369776213,&
        1.8804210119485298,1.0605803625538970,1.2951428731597729,-0.30069194542231270,&
        -8.8045943083683964E-002,0.89051308491196135,-0.53130675820057560,0.18968779063778235,&
        0.11025485427445682,0.72327680948574724,-0.18806292989010748,-8.6126344229116428E-002,&
        -0.96889568298367690,2.2187886818098566,-0.48404159185804307,-0.28072998713087294,&
        0.18737194736421597,0.22728158008750426,-0.57840167233782513,-6.6594856446154843E-002,&
        -2.0242307272844648,-4.8300612090226562E-002,-0.13376377053241642,-0.29626965707429775,&
        0.97466605963992126,-0.39142650400923057,0.20520939215181028,-0.70556372434792791,&
        0.11316452278268387,-0.43304977786917997,7.9645066447145779E-002,-0.38010741271556514,&
        -1.5432444941734977,1.1642004772546997,0.36052221362125281,-0.30297689885388351,&
        -1.6680850116537729,-0.83549212658111094,0.23261330957858839,1.4907596256377833,&
        -0.62136942534019179,2.5235454423922437,0.51204569060537442,0.50117351096321128,&
        -0.88092109257283147,1.0699366210862808,-0.40372257025868480,-2.0577287214820372,&
        0.33858825313559060,1.0261881132472210,-0.15647081482716479,-1.2536411602115294,&
        0.40947689382038832,-1.0451363911072686,0.78918923734845159,-1.0143368133767081,&
        -0.40090387122970050,-0.47979722927431528,-2.0845838842535680,0.53622758396714598,&
        -0.43469570906411303,0.75442318923122986,0.17572292924440797,1.3927471112462206,&
        0.70540912309802306,-3.5661502279031469E-002,1.0635354415893288,-0.53846682859893469,&
        -1.3371102970034954,-9.1910479130026562E-002,-0.73680433301472648,0.85041358185205640,&
        -0.92205087851651579,-1.1604043114457592,-1.7614152653644355,0.75906130484175227,&
        1.1554301509119045,-1.5700029395676880,-0.15476915419458098,-1.4090217280023767,&
        1.8217098938988360E-002,-0.33136646253360236,0.39843162016101674,-1.1889969429860552,&
        2.2431019128516829,-1.0444745416342456,-1.2419178501551988,-0.21626993796903252,&
        1.2697176655132529,0.24521066879771189,-5.8570177681494466E-002,-0.26040553338680344,&
        -0.95933461337529657,-0.18737370089133279,1.5806930188088337,2.4241987323534886,&
        0.85378880886527386,-2.2964772258207566,-0.53865430895867150,0.34472490083434110,&
        1.6526038088044404,1.1804637283642769,1.0338518505368715,-1.0773133187841746,&
        -0.69629379781701972,-1.4414943778141791,2.5621245127049574,0.66639212612967458,&
        4.4227817684212849E-002,8.7787509500641833E-002,0.53514616750218003,0.14062096693667461,&
        -0.58970546125190160,0.66341312938863695,-0.39800699657726946,5.5954941270156315E-002,&
        0.87041331579008618,-9.0569288772157655E-002,-0.99919846044499305,-1.8236844274880561E-002,&
        0.39579564340766155,0.42648273360807393,-0.93155386143134300,-1.0846347233636733,&
        0.77391132956425102,0.87649627439900490,-6.9154716172521238E-002,0.36338584724230077,&
        0.69954860777846084,1.1243488766199838,0.11467419036932382,-1.0220212035591536,&
        -0.70735192831846194,-0.50749263185095483,0.60862436386730068,-1.2907631914999922,&
        -1.4449291352542823,0.86572499609710474,0.89382140797173604,-2.0741445892873331,&
        -0.11585730163216448,-9.7380944335471606E-002,0.74895574517116503,0.33429960202403941,&
        0.74422754412334702,-1.1172959318503981,-1.7466054382051905,-0.61582700697098680,&
        0.36160713052144000,-1.5084744202740417,-1.0350854817140882,-0.44358393892911380,&
        -0.33484181263178708,-3.4155651830917740E-002,-0.45078841100322020,-1.5480711463248247,&
        -1.0533328226425180,-0.35054756711688922,0.75988079503455175,1.5730653742313070,&
        2.0170982546465832,1.0228765774648272,0.55868321051959846,1.9202726098483056,&
        1.2093682207811287,1.4350943951249859,-0.30588420163738961,1.9355132923280902,&
        -0.23808862142154616,0.19103639243007220,-1.8661792879788091,0.23783915716068313,&
        -2.3995728555425356E-002,-0.38862853504604439,0.22385561506463744,-0.74788565999136636,&
        -1.0664342482663796,-5.6475173761779941E-002,-0.78918661387696165,-0.22042287486938947,&
        -0.26628888889459318,-0.69961194720415432,7.8807293638332485E-002,0.65052718588208236,&
        -0.15044287647972088,-1.3550401324270087,-0.36413234361699720,1.3638715449794423,&
        -0.68024366030988759,0.23028454294883968,0.57336452725194198,-2.0136304592948346,&
        1.5701890108069740,0.95397124667718569,0.19680503130663943,0.85115848362368673,&
        -0.30771266970890288,-2.0596300551871058,-0.88909818971898458,-0.10947727193323088,&
        0.66797597283254306,-0.51824199117336489,-1.4059771954631937,-1.3980205910906296,&
        -1.6377218207627817,1.4809343899268261,2.1223140893331305,1.4567227471749533,&
        -0.69164117377227707,0.32291755343464568,-1.2517836582995874,0.69972441824301812,&
        0.26136578939557281,0.71292000448958626,0.14627452213862999,-1.0583714287618886,&
        -1.1577486653606348,-0.30307325470630153,-0.61240437906549861,-0.29183778678448580,&
        0.62087845858541368,-0.12898901292502188,-0.66067282601179289,0.24167070699962512,&
        3.2825391867543754E-002,0.67889163678604425,-1.5009391766952802,-1.5729837247940857,&
        -0.30653906432626521,-0.96906809350240053,6.4011529875952128E-002,-0.11929196143882582,&
        0.80735125592845924,-1.4362681078956261,-1.1920177999954247,0.26397549094853218,&
        -0.68073279740256232,-5.6861418929608144E-002,1.0574842607279054,0.73055253162750011,&
        0.14882841464658378,-0.88117818585495900,-8.1325369269041117E-003,0.29426269504500990,&
        -0.76358184087896175,-0.65613273653720261,0.35680903978483286,-0.37094976832664378,&
        -0.53726992747297997,-0.69576046331303765,-0.41558954309747503,0.76342716517614440,&
        -0.66236321368393858,-0.76864617710599192,0.26555659361428957,-8.1182782431082651E-002,&
        1.2774004958904313,-1.3959619157835279,0.94419267499314974,-1.0393249148414765,&
        -0.25642392247717549,1.9940983035383155,-1.2708020574064269,-1.0822467936219549,&
        0.17075096613018356,-1.1403832855308427,0.70910401229672859,-0.98692502051300024,&
        -1.3614428941916119,-0.14725076686484945,-0.78382967619387467,0.30290823788336635,&
        0.48830665584626404,1.0361111836049370,1.5529988180952259,-1.5360346975126804,&
        -0.12893126048541800,0.95424600603899989,-0.39728099366847347,-0.32946967858502108,&
        -1.6348490158856299,0.84813008432415915,-0.41022438382782406,0.33336678948816556,&
        -0.75734381912787962,-1.4004667169322679E-002,0.73433959487488010,0.56205238051858564,&
        1.8532052450288832,-2.0838111150191647E-002,1.2317304821184576,-1.4858200444658491,&
        -0.49454110650064736,0.81595261118306184,-1.1132056682371938,-0.75259608466213701,&
        -0.62526098577078792,-0.33956825506696470,1.4158243864252198,-0.68119515472656866,&
        1.3729678883581837,1.4234731811497623,-2.1096273077008704E-002,-0.63731921445501749,&
        -0.50167464082818047,4.6260659806618684E-002,-1.3894589344532335,0.23261876634188097,&
        -0.63067445126252908,-2.5740689030914012,-2.3608144599125329,0.43591769747058023,&
        3.1075397687830828E-002,0.21366128534774731,1.5445837715144548,0.35768554329480118,&
        -0.19180818175505976,-2.2808477714948379,-0.46145528781662665,1.3462751547824345,&
        0.81309809606772465,4.6635878561308353E-002,0.12047567458988043,-0.59850101297151226,&
        0.11502440526001312,0.11640967835748407,1.4957841929110847E-002,-1.2882549616755605,&
        -1.0670714384292488,-1.3584562088203469,-1.2878282860730770,0.18153044829193221,&
        -0.48908602461251710,-1.1338484251248533,0.83115035114980396,0.11661918092581088,&
        -0.54785645080473888,0.28097670144041242,0.52928257350184371,-0.57884724396985665,&
        -0.14982369999493292,1.1370139951378593,0.72378429111219167,-1.0377385665968852,&
        -0.62398782527242702,0.75084578084714115,0.41566013713840849,-0.37169511484896461,&
        0.43006350862384635,-0.81871685453777066,-0.55270633212618414,-0.67906569376962111,&
        -0.82254587564688608,0.62536592581981798,2.2581163637143584,-1.0197058241087846,&
        2.8820996989263450E-002,0.37568595584921194,0.39444566024538175,0.51486642358168477,&
        -0.68718189863216061,0.80323817727857338,0.76593078530798409,-1.3718041233019174,&
        0.29193303291523409,-0.54095939147429584,-0.36456064123278814,0.25380943083088076,&
        0.84657367135986383,1.8154810061376239,0.74878883903280669,-1.9799049902666721,&
        1.1088100382254431,1.1602623405049552,-0.27234178173761786,-0.86119310693255136,&
        1.5284758717970839,-0.73821583518023937,0.26413013056209628,2.1982527231940057,&
        -0.69620317314091318,0.18575625785358577,0.96944401280959147,1.1862956154051958,&
        1.0468719012913317,-0.85602599446398486,-0.38940760810015751,0.69869270166930331,&
        -1.2549212597803643,-0.83342788519248678,-0.28082094801107116,-0.10673130937418436,&
        -0.82109587028927444,-0.45365134333284879,-0.64769209264665251,-1.5143618740227900,&
        0.30688835145263638,-0.49747120698291880,1.0448700629642198,0.84610830678255566,&
        -1.6485982853610950,-0.33421799106322131,-0.28448426618783351,6.2466908439693103E-002,&
        -0.57082491906435684,-1.3798778033391244,0.55599933565395343,-2.6404305427279475E-002,&
        -0.51478487173257204,0.20223642617533422,-0.74001882858806722,0.65150292550010858,&
        2.2679468930801034,-0.78424267326417285,-1.7092556427110597,-0.76554714345765995,&
        -0.11537316710561503,-1.2949610762144581,0.20700123927228192,-1.4416169618445744,&
        -1.5762541320456460,-0.63123112350579103,-1.0242150466426974,-5.4817577486776035E-002,&
        -0.19006634819439167,-0.52225790843096787,1.6332887254386608,1.1921572162226712,&
        1.0224408077752163,-2.1218925976517840,0.69391871451715703,0.80748431984451874,&
        5.1723262114293657E-002,6.9381077674222663E-002,0.20564030270392028,2.1600131172018129,&
        -0.28106138084925131,-0.43895766682779896,-0.91178897037388673,3.9865584459051064E-002,&
        -0.16176676495588985,-0.69563041422988658,-2.1133638786800248,0.23452389486170930,&
        -0.40957482371048476,0.69720872275501200,0.39853807727015672,1.8361009211885573,&
        2.0009874583127019,-1.2681202147877517,0.83302076343945441,-0.56857608135081128,&
        -0.39776279059213288,-0.53786806480287619,0.57196454891045223,-0.86598925801722615,&
        0.64870020007969553,0.69325803131505115,-1.5485603830955039,0.30076403613625047,&
        0.77274479910892546,-1.7520292032837079,-0.32072393673918936,-2.5006170523580376,&
        -0.19033680801399677,6.5943973767425737E-002,-1.5877327992249148,5.4340414335924195E-002,&
        1.0660358138130919,0.28247998855381073,0.57402745858779136,-0.95974258829292269,&
        -0.30545091275774477,1.2310711882843250,1.1320036385160115,0.95121368826744934,&
        1.9478867586508495,0.16869010762068098,2.0938278109384854,0.69022771354767887,&
        0.78135498088222843,0.35317896462819770,1.8253720591321170E-002,0.68088576753463126,&
        1.4775821537810387,-0.35034165526643674,-4.1186155949687907E-002,-0.27706436225070941,&
        -0.14255277793268192,0.73747425190456095,9.5144210015143837E-002,-0.31433863673829543,&
        0.62201888415960815,0.21340315019783027,5.9536868056435880E-003,-0.23224847865932519,&
        -1.0227298980463599,-0.58052656779350231,0.18871383302356512,0.68717997047543133,&
        1.0810742941641107,-0.44009259896285091,1.3455604515998210,-1.2128172341416987,&
        2.8937041047548545E-003,0.79553513745476734,-0.56512549504334031,1.1032027008410903,&
        0.81596703069629728,0.49839037166819161,-0.59497087686652483,-1.0560758336116740,&
        0.58750025775435910,0.81846513177119662,6.6805582048482456E-002,-0.37556016573448792,&
        -0.97127724516522707,-0.63102461295573842,1.6882716887480644,-0.91937073714668949,&
        -0.54125917711295912,0.31248718955872828,9.3334679722446093E-003,0.54402856676947420,&
        -0.79183312317818189,-0.15089251640799370,-0.65250802555865972,-0.90697139047189890,&
        -0.70622630941201137,-1.2118640703475243,1.0914330273088519,0.91929755842352390,&
        1.7498268528971703,1.1472957163351742,0.19077793880663471,0.73320123950961713,&
        0.10982708490649759,0.13151440689554225,0.59834706035729868,-1.7388845418281549,&
        0.76670428313333161,0.49447983654035804,-0.18845152196285087,-1.0234305565365316,&
        2.2650818756799310E-002,0.46483198697143707,-0.85152992860391330,0.34302278872351843,&
        0.10165570463634246,-1.0480335238279188,0.11407376019422003,0.60201377169066117,&
        -0.51571386328301361,-1.0312404990335735,0.27489338023969018,1.3294537951365768,&
        -0.38272845271921585,-2.2817430904666756,-1.9136154434572115,0.21355895032624506,&
        -0.70449801769800136,0.95997791927164056,-1.5899913807341453,-0.32284375887191380,&
        0.33564423631984780,-0.51631743522529838,-0.95915678104923641,0.40780098401487108,&
        1.1125346829429632,0.66981170560445213,1.3210892166894697,-2.1282376093192817E-002,&
        -0.55827072068894079,-0.67793925077779038,-0.40485422721851128,-2.3397451617780574,&
        0.68489806606534054,1.0489151080120749,-1.5668702960784258,-0.24042796951561551,&
        0.47098355633815020,-0.13090041179074599,0.75637299407344760,-0.85287761840959775,&
        -1.2479900658796961,0.93141330377992460,-1.7226949545515682,1.0300427829815226,&
        1.4951857111671623,-1.0220666927227902,-0.29960892979383658,-0.68198889973699928,&
        -1.7891257596708889,-2.1766270912177199,-1.9664724030996792,1.3263549517649185/

        DATA MC23/-1.5217360321681943,0.68018210174050608,-1.9446338264359975,0.84734622927241765,&
        -1.9326863000285308,1.5822583900365183E-002,-0.72894064051158214,0.41354827566644975,&
        -0.77105190458070716,-0.10819220211250176,1.4396046558823683,-1.3105034706868885,&
        0.46185173751518793,-1.9391516553700874,0.34012954204654106,-0.37133325387270322,&
        -0.14454599452016550,0.34238967814899096,0.38546810337695953,7.3206557057989438E-002,&
        0.10730637320410406,-0.33684594743583623,-0.97119472111671834,1.9976992511401412,&
        -0.69563657517855038,0.63118475392437723,4.4359874567644342E-002,2.1916673204674075,&
        -0.38483606995193281,-1.7265535126611291,1.7996079947026520,-0.43343638538763968,&
        -0.46403349796205784,-0.69177360331467763,-1.2390701830421083,-0.39666556510363438,&
        -0.20813543637375370,-0.53109188664468066,-3.4905775952101925E-002,0.12510344608456675,&
        -0.67077142896013231,-0.50048587600926242,1.2416584685630636,-1.0040165512887236,&
        -0.97415544344094029,0.89859629749696324,1.8543565236677293,1.2080570720129160,&
        0.62734829622643196,0.95250986414583561,-0.51607682292768464,-0.84789978993612269,&
        0.23209418185697767,-7.5332194742913430E-002,0.53253440682428621,-4.5034683696681940E-002,&
        8.9553853504725830E-003,1.1728024675641691,0.46052366917502879,-0.44206840574026540,&
        -0.39090799221098987,0.53790618182160777,-0.12361327939632966,-0.57406090375765606,&
        -0.38537100457941970,-0.73393981279025100,-0.18520386616933793,-1.2040180856999894,&
        -0.70506400886419029,1.6174966190307007,0.77025499549239107,0.15018636552286552,&
        -0.56743111453952422,-3.7228017945446945E-002,1.1707777560751220,0.81613861834143497,&
        -0.17177933026394770,0.16255370462668792,-0.53424400437995800,-8.6025315554783002E-002,&
        1.1549740285924199,-0.39168442609666038,-5.9046654191341454E-002,-1.1920847565579058,&
        -0.25013240591398156,0.45507914777941438,0.42167369683750466,1.0772686439535681,&
        1.1379469802545710,1.9466609646735649,1.1080217765350675,1.4249679054477693,&
        2.0947461545892221,1.0340939821314996,-0.21561059525685086,0.23786207411732219,&
        1.5097798526925312,1.8387211975517190,7.5847898999037225E-002,-0.46041107265135056,&
        2.2910710911948757,-1.1568140673957015,1.3350040161360928,-2.0442968416892966,&
        0.42927003716769202,6.4026067532809691E-002,-0.30324392243565401,0.43001329374613684,&
        3.9378974557325100E-002,-0.51394171686053269,0.35896627559692706,-1.6711324914067853,&
        -1.3377568862898199,0.30930652716973772,-0.60045099525090362,-1.9091593821752049E-002,&
        1.9023638339396796,-0.61900784722590041,4.8964709160085780E-002,1.2221035912164537,&
        -0.53309461074244380,-0.95469588126775295,-1.7392088952399738,-0.94244027251199092,&
        -8.5746421335732598E-002,0.89109358557413354,0.19068034030708805,0.79724912862406683,&
        1.8419525988772505,0.56370095628397832,-1.6943050260739427,0.51446605522712185,&
        -0.32331473944086825,0.26322915641470562,0.25941778255320913,-0.84926212629516529,&
        -0.23573618490365705,0.32334954949853556,-0.29608575326388664,1.0903400179765153,&
        -0.70373750434676974,-0.55296425651916314,1.4047265141927829,-8.7194748000223810E-002,&
        -0.40102463934456900,1.2843117756885594,-0.45865533546261728,1.7987738691138317,&
        -0.72362460487015345,1.5131547861121071,-1.8218820347353524,-7.9841447143686670E-003,&
        0.69871731222463562,0.12198734958895757,-8.7260382611195050E-002,2.2643467640693897,&
        -0.71990184319629247,0.37505161145054772,-0.66586475477136720,-0.35213231257352967,&
        -0.55458337297785043,0.45760405540551696,-1.1388143656987157,-2.3929561951540709E-002,&
        -1.0912145979242480,0.47988425472713936,2.8514690188624248,-2.4390704901286453,&
        -1.5907754194748196,1.5412519536222946,-0.78646412225913209,0.30348318237393868,&
        -6.4120439080131097E-002,-0.45162917723771873,-0.56224445302293768,-0.16465344139909724,&
        0.40529036332492391,1.2371375852828532,2.3322906806976396,0.18312191015222282,&
        -0.53594379374146961,2.0485807130008129,0.23060705201735265,0.94262611638200711,&
        -0.50851712968082818,1.2029484504798562,-0.26767439649070995,0.56692420371600860,&
        -0.85307154938475194,0.35289543305567395,-1.6929189247872820,-0.17234947722848606,&
        0.46362453156149680,-0.79519310584613001,-0.73817174387091156,0.45339543641246677,&
        0.29462721544776488,0.42032874734912745,0.83545131223620728,7.2544569744022375E-002,&
        -0.36614966715869340,0.72497229817002673,0.19737877912784743,9.6746459950074318E-002,&
        -0.60379532590282703,-0.47069801649760917,-1.4986100266167346,2.1041408356376006,&
        -0.60349878077950836,0.53898095090632203,-0.97519634519334453,0.61176005421323343,&
        0.60734041737115851,0.24261327519152556,-1.5589834231189770,0.23285828509990739,&
        1.4216339403899723,0.85096206831023835,0.20847644638553225,-0.17638111656251204,&
        1.1660471446033347,1.4102170490144716,0.97942142822314471,-1.1177569800711995,&
        0.42710591641293938,0.27391239914398563,1.4894721099560595,0.50040822323614920,&
        1.1031465865978092,1.2804147304421851,-0.58560921660147658,1.2048084336734453,&
        -2.5042876269734102,-0.81929757370202905,-1.3656170044215599,1.0124374648166936,&
        0.58554948853896371,-0.81586199562622386,0.33320746755327163,-2.6216997137602882,&
        -1.1558235902627894,0.25446961137281221,1.1243442487257895,-1.6548278006875790,&
        0.79994986632986842,-0.92303666045641697,-0.80241289221875767,0.71823554863630212,&
        -0.95008928512811353,4.5347147303099293E-002,-0.25654365856982825,-0.97793062659714514,&
        -1.8609761314849089,-0.47607759246197640,-0.61921553711441857,-0.39344516501371307,&
        7.0260075867925195E-002,-4.1827395815907713E-002,-0.10097795915373267,1.6748204235021162,&
        0.92912462285681841,-0.83326715916063188,-1.0644174727359006,2.4491370457679662,&
        0.99958286930662876,0.73886183121441473,0.66739797529959111,1.1349902701118357,&
        0.56295293440383254,1.3573778825248697,0.94034482414158571,0.77603796672769665,&
        0.78267037538910766,-0.72312514226015956,-1.0581964482031601,0.10583186011625069,&
        -1.3646686401946146,5.0433048754886571E-002,0.24747614942202678,0.83303697705316271,&
        -0.66008985318307323,-0.18086827609752032,-1.8439155874742641,-8.0326493542356159E-002,&
        -5.5463050687807110E-002,-0.58751214657929896,0.54961242206725447,-0.51263191647050177,&
        0.26497283954191198,-8.5056737968515830E-002,-0.28089730200107360,0.41447354388306268,&
        -0.68239216144077486,-1.6636298708505557,1.7784568617184768,0.17128912972974689,&
        -0.14522906715596698,-0.93547730922455352,-2.0046699110444521,-0.53141741939593079,&
        -0.14077395614614879,0.29369661198436198,-0.20091453698711711,1.1659768319016734,&
        0.55147735550486177,0.26854581370565522,-0.66253727475709234,0.14028465463602791,&
        -0.18275590730666913,0.12734759339017782,0.31215565453456190,-0.13384762667126252,&
        -1.0939061833280783,1.2831126583563870,-1.8960586893099498,0.19881302813711782,&
        -0.96984593212424064,-1.4156134400455183,0.80220639976008756,2.4848923845524307,&
        0.64533440605089709,-0.24802790308801659,-1.1010278227279287,0.14697388127964445,&
        1.0329625082439895,0.40387798360912869,-0.81230154646863173,1.1208572136576973,&
        2.2284266536992378E-002,-0.67150438449544259,-0.24498846475051650,1.7301741834049109,&
        -1.1849763330627290,0.75063287182814697,0.33747589099728897,-0.24258413497945017,&
        0.79753457709846720,-1.1516851045403478,-9.0760592989812552E-002,-9.7438889255374347E-002,&
        1.0167294356851420,0.11413032743428587,-0.68437085814804766,1.6030977866612217,&
        -1.0997416017465780E-002,1.1278080892404305,0.52236239554504271,-0.11560428624800420,&
        -0.58909698581106729,-0.73245974324988206,2.4557888497828508,-0.47849380144806691,&
        -0.19799828584971399,0.95967193943407691,-0.38114338126658842,0.43639914439855787,&
        1.4513144851684092,-1.2182344442548310,0.58017980371315703,1.7744485076777994,&
        0.26614826229231286,1.6267047630484472,-1.0577135746072264,-1.7003253354495813,&
        -0.67511579520011777,0.26264800897050805,1.0085686145106481,-0.39642037353339765,&
        -0.49190079792147873,-0.38022995667845899,0.39553684234930181,0.55298456463657453,&
        -0.28947554580268886,1.3027296778910680,1.7015221610465907,-1.2744666274972487,&
        0.89688482596253349,0.84598832433099147,1.0251863357013871,0.55117901829272908,&
        -0.22316996387704624,-0.95817117380143235,0.62199828650438327,-0.21734319345613665,&
        -1.5029583067203547,1.5434182394943508,-0.62391894761421041,-1.7410641441573018,&
        -1.3455833382340792,0.35720843570601135,-0.75114524885972733,0.20400934566613801,&
        -1.6622073757764133,1.3642387498045510,-0.17413772907893099,-0.70853806382871953,&
        0.33028437131088079,-0.18971151247525506,0.21025259913586175,-1.0182146021741534,&
        -0.44600300535536852,0.55751258341762666,0.33675501580116074,-0.14591854684377065,&
        0.70193006268241831,-0.31882432479775558,1.0476585660534716,0.27636512845753591,&
        -1.0002758675448340,-1.0947985239504756,0.22401656985136398,-0.56302297497620402,&
        -0.37719127601881569,-1.0803289594642498,-0.15028056253925706,1.7324853805799916,&
        0.56975117932528108,1.0057844005891527,-0.78828019429354668,1.2624888696308452,&
        -0.61163058407224147,0.27778069008155759,-0.22843076210697733,-0.64673751834975035,&
        2.9201522861340745,0.53358825074822325,0.31008018847889757,0.73073911147268067,&
        1.1157776809539621,0.28855743863163597,-0.51656288866337552,1.9165224305003605,&
        0.28410948690142535,0.68506647422384814,-0.68859384914341037,-0.78749583550709890,&
        -1.2719617111051462,0.26534595695971558,-0.46376859000342996,0.53772248196992156,&
        0.31388846294705530,2.2137006534662431,-0.67576247012444657,-0.22205749655994125,&
        6.4720840858245879E-002,-2.2807364231584186,0.26679782312219391,2.5114549989483983,&
        1.4114810026930698,-0.57874240294529911,1.9380334558246157,-1.4767275149261681,&
        -1.0852758624136263,-0.84197117318746717,-0.59561121257091310,1.0307641450799765,&
        0.19850879909039729,0.98269608137894948,1.9222034684357039,-0.99849177763199648,&
        -1.6119563912175587,0.64407617179750420,-1.4718260346923402,0.28101906065976839,&
        -0.89394455022351260,1.2089955418371836,-0.29911078594450374,-0.24579558404771848,&
        -0.57928614304750703,-1.0084990606001145,-2.0847854781250290,0.81869699925686301,&
        4.2453494166257995E-002,0.33780918712338054,1.3497936879612942,-0.15046159206696250,&
        0.22489294977933161,-1.6285005624278017,0.13180669576693932,-0.41062635973309558,&
        1.7317631856697002,-0.24235229173473649,-0.61386191224845921,0.75423917305718136,&
        0.11808552195285603,-1.5336455127764272,1.0028516939258854,0.54581760926915368,&
        0.52729109889102588,0.25822179510145549,-0.48177786059562555,0.35700502554021257,&
        0.22933194422053557,0.90553518963714108,1.1700961777413350,-1.6994839330107880,&
        -0.82203744428159964,-1.6740720571009107,0.36016398301849073,-0.94377210155255664,&
        -0.53602164790844931,0.40083739358088549,0.57595767142058918,-0.54671206565512043,&
        -1.1436204074569438,-0.90617095566533989,1.3159994660536634,-0.36929990049144573,&
        0.21111536539674336,-2.8743699582162487,-0.21329831573069438,-0.64542405962024396,&
        -2.2607869439209569,-0.45994629108684965,0.10121532271523410,-0.20831794776776133,&
        -0.76274006291617902,1.6833781456832553,-0.51998736759176933,-1.9714081531194818,&
        0.27792174866131092,-0.38396830673712173,-0.95072392142929063,1.9073779047740205,&
        -0.10746294517198647,-0.73621720889723108,1.3387620616876015,-0.94605666665522070,&
        0.27240965422577201,-1.3007857436285544,2.1144978846003255,0.20903629248424371,&
        -0.44496522596194177,-0.59062186830289509,2.2206611094034736,0.11705779036023573,&
        0.17848648802985420,-9.0228259310709699E-002,0.74992125733959869,2.2992955170059064,&
        1.2468258659091365,-0.17932815873571945,0.35578046074588238,-0.25293363643034505,&
        1.0717775544220225,0.51865797414981107,-1.6098696589414259,0.93336935663688048,&
        7.9679564186392104E-002,0.44353386015633017,-1.4708093089366021,-0.35141499780991498,&
        1.2984377421434807,-0.22296299076441267,0.44048555354537583,-0.90382033940817175,&
        -0.71019757824365759,0.49696099804282123,0.65136516481090578,0.44785726228187156,&
        1.7450710057122951,0.17733960381192299,0.29526051281820870,-7.7949104082607537E-002,&
        -0.33367934275362404,-2.3206599715863727,-0.80491961559165492,0.31544138737429267,&
        1.8831775688292187,2.2977411020900846,-0.92680402198298806,-0.33433085445567556,&
        2.7935613381263248E-002,-0.50566764993448565,-0.29741599527734958,-0.87571636056876145,&
        1.1032450255868806,-2.0021894329229495,1.4456142233580433,-1.6878243344783519,&
        -2.1950348956959201E-002,-0.76448267926560920,-0.14410621666758050,-0.48247165656770608,&
        0.60013892181639150,0.30447470685072686,-0.17302597386267515,-1.0512357456209311,&
        -2.0622486690233250,0.66358422942375317,0.55335014747224021,0.92388055506232436,&
        0.79944357515087017,0.36337613012767128,-0.59075076259147585,-0.64056882392269221,&
        -1.2949868721472690,0.21510143460827746,-0.36568138217127627,1.2036722928337531,&
        2.1849837783111052,-0.76785917575604912,-1.6679368363108842,-0.70175194390727003,&
        -0.36262577166981547,0.25338773935562597,0.84862775123689149,-0.54743629340743971,&
        -0.51202862698949236,-1.0996939747576751,-2.0659464001584382,1.3692935254192655,&
        1.0627243541163416,1.8218736494777444E-002,0.71343416925917913,-5.2178129799457879E-002,&
        -0.68444694418231189,-1.0367914311195674,0.20669698551091314,1.8747081091992202,&
        0.67430089812105398,0.56097751514603345,0.88252019220822464,0.70274529894441295,&
        0.55190460562710242,-1.0378758275599966,0.51432834124332139,-0.41230708337974697,&
        -0.42370764584426163,-0.21498435780138445,0.47558558858110200,-0.26894495960510773,&
        0.13117960176826310,0.54522847248377337,-1.7340560555724318,0.78679293674651574,&
        -0.13331069283701649,6.9106452714083361E-002,0.91167772674180270,0.33573745039710556,&
        0.36912844020931296,1.6823227234423872,0.13203804020342391,-1.1561007523778366,&
        0.69198483531028043,-0.71793047883278760,1.2287657492338331,1.3594341830901989E-002,&
        8.4057164457056577E-002,1.1413360103562797,0.93315734001307304,0.60156409389342724,&
        1.5481442419647626,1.0339592514826139,1.7661529099072368,-0.56231971566325711,&
        -0.77137857596447224,0.73143041447738999,0.35021165694932394,-0.57642890259448998,&
        0.19019827047878138,0.23221716037466492,1.7616009948598756,-0.20917127687744280,&
        0.60573503591205202,0.98283372630188659,-1.0223845954347444,-0.11740731836759009,&
        -0.23235701603791548,-1.1433456478325017,0.43752811035674510,-0.63671059863255697,&
        -0.35590167495346364,0.65617345871475397,1.0632853692674769,-0.47846893003486596,&
        -1.0918804892972562,-0.42668762272832084,-0.79646743401883602,-0.49903728318657531,&
        0.14803182437944609,1.4728176238026218,-0.87269151145903390,0.48992435195137218,&
        0.70450173890086243,-3.6070336647691015,-0.77492418243193029,0.28930867822832346,&
        0.19578033601206529,0.35866683649499265,-0.68069436221572810,0.63422591628856173,&
        0.20389792971329726,-0.79578285865928056,-1.4157678775615656,0.55882688394357094,&
        0.63661913998312147,-1.0815457513884728,-4.9622997887953636E-002,1.4615934583659911,&
        -1.0699475393128277,-1.1745977834361077,-0.77879917415725974,-0.11693966651049363,&
        0.59024328945253124,1.4654397288137955,0.50237407176213855,-0.41740375042167260,&
        -1.2296559687564261,-1.2459520627353771,3.1039912136673085,5.1405893641427815E-002,&
        -0.32458511263627415,1.6988439635085046,1.5369791465030422,0.17806551818904592,&
        1.0358167762505872,0.46948713616965609,0.36586745325458836,1.5929294477113884,&
        0.23676344857662371,1.5708461001967204,1.4058714681056983,-0.87558390249979989,&
        0.89304338606878308,0.32361804345223039,1.9930732740224453,0.66514266184022186,&
        -0.26001107191739686,1.4457228843139160,3.0988186615852229E-003,1.0136607854483497,&
        1.0291665610065721,-2.5712752956053917,0.25745641963380228,-0.39441328980031010,&
        1.4485444497042108,0.47229491647586913,0.72800539461519687,-0.60959803283207037,&
        2.3770680078679898,-0.49256773056750558,-0.26985439285043400,-0.98839135462576233,&
        -1.2984083207448032,0.59650445304536059,-1.4212205488460039,-0.12786872223413800,&
        -0.69965562935624925,-6.3507527060953750E-002,1.2572888375472526,-4.8075332474014285E-003,&
        -0.54571249833386148,0.63091281670598143,-0.24349789055332371,-5.3668615109775074E-002,&
        -0.15862008778945058,-0.32955670557986994,1.2179373793395276,-1.4953853228396223,&
        -0.33758462444179921,-0.78647045609496591,1.3798663989886988,3.2392287406619498,&
        -0.43261301688411385,-0.44648989668738565,0.36936303981417884,0.59006207933303034,&
        -0.74901933762557860,0.27005470004703430,-1.1103518468751763,0.37759373611425123,&
        1.1467190176797042,1.4396988217897064,1.5394584246132459,0.39634564576629422,&
        1.2325637019066666,-1.2092371345937516,0.79461524754568946,-0.17636182442952636,&
        -9.4315912127238333E-002,-1.1093588371348653,-0.22013364142605826,-0.26044314792748863,&
        0.39330701525687700,1.2101483981380687,0.18688700236662667,-0.78344723603499677,&
        -1.4568646150904929,-0.92303200631641957,0.65178624332447732,0.61875702684140477,&
        1.5068368071811753,0.38576309184564533,-0.47451896719725661,-0.69410685898337199,&
        2.1101807909287604,1.5106368604133593,-1.0033917487046899,-0.89477706033289583,&
        1.2767564608618587,0.66352476486238210,1.2293432455151190,0.10773709546851006,&
        0.12589519126817961,-1.3561389796747991,-0.59169881672108626,-1.2099285756536124,&
        -0.32259435281588045,0.97484538160475775,0.53166941863008610,-1.9224781888608879,&
        1.0692748584411675,-0.30180711980915687,0.69483249476364328,-5.7049360644503090E-002,&
        -1.1699684074264252,-1.4900337565102293,0.23077651370836461,-0.25654978248517574,&
        0.55256853411142348,-2.1515953386077906,-1.3336422761000042,-1.9518416107910932,&
        0.25354593484164828,0.40397144024794757,1.6438192955828084,0.35564785999880949,&
        0.72295063287207240,-1.1993440963719963,-0.21791489556560564,-0.23387934395282695,&
        0.28943080029315793,2.6132726612790199E-002,-1.7249093127702355,4.8741520286901034E-002,&
        0.76812185673268574,0.66823443338733546,0.54475900636422692,-0.25052707466789731,&
        -1.0026606415834487,-0.30378176465383261,-0.27840392403644054,0.61642251295416461,&
        -0.56528937265003398,0.44538541872190551,0.38084485564816262,0.33171215138432081,&
        0.33563907106442259,1.2819998613148245,1.4712045865170924,-0.98089523345854968,&
        -0.87964482111981568,0.68225866650995748,-0.64766820651659474,0.14940770570430148,&
        0.40557550363719241,-1.2537939055009932,-1.3067303367710468,-0.22928655450114013,&
        0.21256427940549610,-8.2974690940971693E-002,0.15714726066086884,-6.7619897956051181E-002,&
        -0.48419825770918312,0.88566878528466941,0.52565050796478874,2.4063434632538883,&
        -0.76423969204675279,-0.23585552031267645,0.44257797028531098,0.69098806343770691,&
        1.0295015485947070,0.65480970134753669,0.69480643968233002,2.3016064573354380,&
        5.8591000297388993E-002,3.4266485014700164E-002,0.60497272264792978,1.3809488804084054,&
        0.50698518529849990,0.16100599935225429,0.67374284477076174,-1.2288311099772058E-002,&
        0.43716891634332011,-1.0001198074182012,0.82177214735083559,-0.91932325271993720,&
        1.0304173707099202,1.6317647615690913,1.8966039879650265,-0.37338399292771562,&
        -9.5067217674145499E-002,0.21456320695729467,0.46254604370285451,-5.0487554495639929E-002,&
        -0.16332890003483533,0.48768520525859826,0.21638899829844019,0.33168576447546605,&
        1.1677264713972555,-0.59597483682365293,-0.27014348551204648,-0.91998255696082876,&
        -0.92451609760146192,-1.0737783005657202,-0.56000617858147883,3.1987961365596146E-002,&
        -0.51172076719744408,7.3043498946248592E-002,1.0799606798861721,-3.9138118305014936E-002,&
        0.12179024822803068,-0.28039346691551570,0.70068373633655567,-0.64808447951174908,&
        1.5279670308850393,-1.7785938975756908,-0.22233482091034132,1.1639795970815865,&
        0.13678440052143681,0.73822951813272075,3.2576183488730197,-0.94089609186644629,&
        -1.2807944022335087,-0.66819964247279273,-1.0286498644001227,0.14094998165393832,&
        0.95094260202220282,-0.42486857808627460,-0.52102666344377846,1.0573541650242246,&
        -1.3822144281063187,3.8295495454350854E-002,1.3197863763126898,1.6608866457936045,&
        4.3394697121518062E-002,1.0067974575827445,-1.2816652234422359,-0.24359548951328028,&
        -0.61223476443417602,-1.4134573612643431,0.21640906886619052,-0.98782815828588166,&
        0.84117259162805103,-0.73474741888458028,-0.20299046585967795,-2.6558148468489740,&
        -1.0411218136819662,3.1646678588960913,0.24801306674753365,1.0148019387492861,&
        0.71753666391077431,-0.15577145070939277,5.7643953350521852E-002,-1.1879272179513420,&
        -1.2227775971615658,-0.72676607077981237,2.5252640489887361,-1.0296079179226503,&
        1.0262029349403501,-1.2333204391415644,-1.0489716639613984,0.87399747897345270,&
        -4.4390221311631554E-002,0.39242346956248836,-0.48304028283394418,-0.40259015597238079,&
        0.90491448728411894,1.7032083981497763,0.28639692502117164,-0.86029566145975334,&
        1.5584668489430638,0.29891176577214212,-1.1230571559545479,1.2215296367565167,&
        -0.48652884656649320,0.55675824945790253,0.32134060794346270,0.94967892552013344,&
        0.54857346309674737,2.6489478431271734E-002,-0.68102981408125929,0.99562736550242348,&
        0.32787781777792646,-0.86234701491748977,-1.7445819441429629,-1.7546833170604850,&
        -0.87757401534885671,1.8261052453389404,0.69071684983399362,1.0347620064488963,&
        -1.0527630380258914,0.11234260855915060,0.67385010323370986,-1.8696187115272820,&
        1.5116489642464788,-1.2942313453881482,-0.30111318236094037,-0.58775402401663379/

        DATA MC24/-0.58327231692157189,-0.46827436104684983,1.2677484376314867,-0.42947240416621646,&
        -0.63526026288582371,1.8416941835130045,0.37128689674165372,1.9816861561606305,&
        -0.27625743237777850,-1.8276058515458822,0.83760439332221814,-1.7696406214884661,&
        0.11868568961905715,-0.39363144881898265,-0.81631429523989796,-3.1359536039926135,&
        0.10961558283537011,1.5160466829881463,1.6840394052152032,0.12748204502961852,&
        0.49547963147439572,-0.38153054524606617,-2.3814500724460070,-1.3520283173900134,&
        -1.5487009911193514,0.64752686554152672,-0.57518021690596777,-0.42027803155244853,&
        0.18154257980697397,0.17624992097851500,-1.0099951575616177,1.6810818448904949,&
        -0.85822240730499200,-1.3978414789589488,0.98812121974958766,0.69313443469160174,&
        1.0745690782648722,-0.58055945706442935,0.33658972504771367,-0.70773471428315315,&
        1.5904356499221484,1.3035212515778209,-1.0678939377780099,-0.51338548023084585,&
        0.97656573683086756,-0.27333820772694312,7.0022308605489469E-002,-0.16644836737529997,&
        0.92703230373569867,0.25586581899081229,-1.2510325626164582,-0.70067099412293232,&
        -0.30574174668594356,0.19891180538791289,5.6889140687209655E-002,1.4582752622786113,&
        -0.94847477117683154,1.1820706068484719,0.83930907354373818,0.51520460932595102,&
        5.5050245037295449E-002,2.1558305826565212,-1.2944104136420358,0.63964968950400602,&
        -0.76117693126169694,-1.1544730251998592,-1.6229772607731887,-0.32078350360680513,&
        0.10348443513996478,-0.33301880859010230,1.1374538399887599,-0.34834679209810598,&
        -1.2950188807030898,-0.78937786965796242,0.52482849474473570,0.96464306712970715,&
        0.99340682143442638,1.4821508676788642,0.36817435461092246,-1.3681877126017008,&
        0.26130425007210595,1.4075538064166191,0.43057112859087138,1.2988483404854798,&
        -0.42119614482354012,-0.50578834203275569,1.4706053776892734,1.0651250389584381,&
        1.0340857452435034E-002,1.1312626537691386,-0.55042154813522681,-0.78061213023613696,&
        -1.5717511468215681,-0.42732127770290568,-1.0826329707744882,-0.47633572114297557,&
        -1.4651772274592014,0.62759901528003248,0.18585843117789388,-0.51100848441401991,&
        0.53784284917572311,1.0331420825253341,-0.53444831396351555,0.39829527103561096,&
        0.35835951456181381,1.7651195017824408,-0.54815321898459213,1.4605799428897344,&
        7.0574856928883836E-002,-1.7561848439437100,1.5741984065980823,5.3981522174389750E-002,&
        -0.46706232547053006,-1.2305570604096681,-1.0540969718794955,-2.7962974024084305E-003,&
        2.0827300733580003,-1.8503945423203423,0.70071709901883672,-1.7260894313024542,&
        0.42883383311054607,1.5049144494451701,-8.1974148259662913E-002,-1.0807275855975580,&
        0.87128850808175839,0.14499684271446567,-1.2168352147974211,0.35076050831757749,&
        0.84391206669162366,-0.75738793788450498,0.67147230018535842,-0.54700456502088246,&
        -0.81009265056814439,1.9464978140484679,-1.0164326979119596,-2.5827117472859586,&
        -0.29591640632086880,-1.3492660021211611,1.1016184083120617,2.8000198414076123,&
        -6.7962103701188270E-002,-0.29487845704599785,0.20222829396632927,1.5040865631514040,&
        0.11522935619168152,-0.42583554494497505,-0.27565796611269017,1.3022584942002429,&
        0.96519656601279336,-4.0092635063948161E-002,-1.1221843216331804,-1.2387628408801081,&
        -0.60867964643279560,1.8541803033661297,-0.72870645477680107,1.1133298808001895,&
        2.5668169136478349,0.46055925191921987,-0.76059632059734505,0.61163039456687995,&
        -0.39609117432491853,-1.8503063869244099,0.32212020267358710,0.75882134763320175,&
        -0.62841672420843764,1.0180959368115785,0.32913977870749755,-0.73871324668899407,&
        9.5696323646527498E-002,1.7136059075745955,-1.6087970994222167,6.0307419028867645E-002,&
        -0.32469266945327274,0.14260417195666217,1.6371786331201181,0.25644084240531806,&
        -0.70145587011349109,-2.1826177245260272,0.48400453370271762,-0.86029394208775101,&
        -0.92601150148229050,0.53300085914102102,0.70660070152585763,-3.2288996745930817E-002,&
        -0.93467504272537782,-3.1269633676181421E-002,3.6086626090200413E-002,-1.6370845183660668E-002,&
        -0.71346469811317970,-0.34566596236811720,0.28783909385255446,0.79457935532912505,&
        0.26912938960956634,-0.39690446251477379,0.42890133978612621,-0.94750825571026798,&
        0.68615592103943990,-0.53921318840705523,-0.96501797530726796,-0.39447895499288665,&
        0.47049561325960221,2.5937049384598128,0.88667952889850876,-0.46740147876829397,&
        0.37068996631152179,-0.66308839281590559,0.76365044058143472,0.26976889584100056,&
        1.7600486843107430,-0.65999098731915629,0.75442379638211787,-0.24570325859393741,&
        0.21434394646539823,0.80132816848338395,-0.37087737146837246,-0.70846494747061539,&
        2.5988889212874984,0.58785406733537837,7.2078723754436524E-002,1.4321746565145717,&
        2.1383138560602548,-1.0470584572594628,-9.8567789858956825E-002,1.0771025272151555,&
        -1.2587945582001618,-1.7450447761287420,0.59830649975061223,6.7426395579301690E-002,&
        0.33528360250124623,0.50249949257385274,-0.82387086973710510,-0.16988569762751385,&
        6.3776238511396688E-002,0.88743234730488663,0.49566319682028714,0.96041371997499680,&
        -0.90632419795932850,-1.8149744745972594,-0.93386825061301959,0.69219618180975051,&
        1.0515622088464407,-0.94606157239700472,-0.68142949337902858,-1.2869583129670155,&
        -0.67069790069644530,0.62036171189844169,-0.39048441379091869,0.97261975522661936,&
        -8.8446099355834321E-002,2.3414373684660553E-002,-2.2598360221929354,0.73980155909727141,&
        1.6544339048763115,1.2936181989411011,-0.39997216718419404,1.8522680842080597,&
        -0.97521183155639868,0.87098365494383811,-1.0404525415772912,0.10626134250117358,&
        -0.14728466777406729,1.2603902327283643,0.57334283769462702,0.89498986325768781,&
        -0.16959645131217060,-0.74693936654924886,0.87304040298266816,0.85161911860331718,&
        1.0791522417028412,-6.9633900736869772E-002,0.57274258717061954,-0.56756469455308822,&
        1.7387331458676114,-4.2173559683012667E-002,1.1489078269040309,0.29398466653855654,&
        0.74016361851166323,-3.0033780541585742,-3.0886505236348435E-002,0.23933598717446564,&
        0.67066878943351860,3.9539284790913704E-002,-0.19339918251337898,0.10835455603139556,&
        -0.36589370919510161,-4.0693875787388346E-002,-1.5258112962777601,0.95595970300282840,&
        -0.64370493546906038,5.1518602291990685E-002,-0.21372951767970821,5.3133957069402195E-002,&
        1.3367908485474136,0.61486283142232723,-0.76300039712078283,-0.95607564338853757,&
        -0.25774553086137536,-0.17993728308425130,-0.29165770117623646,0.86052387316084344,&
        -0.82790970555504639,-0.95856122090640616,3.8480226326787027E-002,-0.49331920195432483,&
        -0.19348289742481861,0.37146987038715168,-0.98371200482017485,1.5669957023038121,&
        -0.37584929710652798,-1.2070579623029993,1.0251769688769545,2.8312372455105910E-002,&
        2.2211911830843905,0.73615259221780793,-1.2739976283622125,-1.9218917889956633,&
        -0.40823326332911658,0.79359882501932988,7.6319856770042216E-002,-1.1940851444271066,&
        1.8606638019921442,0.34686566812899128,0.32790022836978661,2.9880983126722187,&
        -1.3012314560138880,2.9877492796254693E-002,0.37799204555552957,0.67619283651300932,&
        0.57999950762591468,1.2078333992831289,0.67656965665774738,0.64380143341913720,&
        0.16057304049349039,-0.69757808257124188,7.7531649219245045E-003,-0.50100545424911025,&
        0.80859971297037425,0.28579838231998489,1.8184718750494513,-0.62827095998891092,&
        -1.2889529104561341,1.1688324640750649,0.32648337899453916,0.92806944849683293,&
        5.2909141113668255E-002,-0.96243924598162622,1.1349300746032416,-0.49858762336553503,&
        -0.69274839855765646,1.0770647235688504,9.7637978193988464E-002,-6.0857389694299914E-002,&
        0.19957744658293958,0.66932390891657989,1.5011169726344253,-1.2226405686050286,&
        0.43485865887648834,0.90896951916075674,-2.0234387749681515,0.96026940215281675,&
        -1.2948229507398412,-1.8545891491886999,0.32923160304086846,-0.45379166552954137,&
        2.1101685077011836,-0.61576927704658313,0.86519794687688112,1.0476617644176767,&
        1.0959327929980833,-1.1841802922738378,-0.52576342535855736,-0.63958453669798365,&
        -1.7717487171279327,0.51633007184846136,-2.2440704784235415,-2.7898040629120251E-002,&
        -0.45904631064669638,-0.47110638661203452,-1.8291308113909683,0.73217598238056503,&
        -0.36834546703037124,-0.46857272998270044,-1.1271239059285922,-0.19827213961661480,&
        1.3568344241123007,-0.35618577221884262,0.17946659731963058,-0.40568587736015460,&
        0.88397858101473692,-0.95037110566538441,-0.22131275933523895,-2.2300244827214617,&
        3.8773725604239209E-002,0.89511619295449252,-0.63953825135955833,1.6613739340655425,&
        0.75265094032446977,0.80331407379613839,-1.2827530841928392,-0.77281845375812097,&
        4.8550133023923227E-002,-0.37380923201756966,1.0601179266265268,-1.3283467846408727,&
        2.1518340952153148,-0.99885204025969032,-0.46291227241456717,-1.4609969817386366,&
        -1.7700350049034395,0.38335095739384512,-0.95481819184400274,-1.2038853429632341E-002,&
        -0.17560498174713568,1.3145821369042949,-0.93328617791138835,0.40951291213268942,&
        -0.25521007967733789,0.98485764058588132,-0.74130677488823937,-2.6735500093258024,&
        0.20283273634620577,1.1580910005054370,-0.95882098336062205,3.2258714856605301E-002,&
        -0.78949143325373861,-7.7290762589035444E-002,-0.58266411744794155,0.16566136300020068,&
        0.39389014205783218,-0.97919132475397264,-1.7973623169745967,-0.74971557237591113,&
        -7.0454045105460189E-002,-0.75359732889317932,-1.3577487454324051,0.16340505927054827,&
        -1.3674286478445863,0.41655067037771348,-1.0357655190954680,-0.16534323028425260,&
        3.7088489400893904E-002,-0.62057288670188471,-0.92866351635430411,-0.53897607695844818,&
        0.46730662252707567,0.12285533536477636,-1.0086901328375952,0.40792284896575387,&
        1.2863946943616098,-0.86442536366669287,-1.3727967814805950,-0.81343250053797866,&
        0.89673209716894353,-1.7521788800380333,0.47116032849135353,-1.9281173584132343,&
        -1.4446335972320297,-1.3214930563971434,-7.5118599302898227E-003,-0.11512169834292561,&
        -0.32005447215686672,0.13398784447582515,4.7290945031460023E-002,-1.1895824851123702,&
        -0.97978476393288882,-0.39541592530635078,0.95623110677118017,1.7764155817749860,&
        0.65276167707970112,0.89019534391149158,-4.3155392137300047E-002,0.53125295091570890,&
        -0.86453568901584343,0.55374481021110078,0.77525028858923961,-0.84937954592615050,&
        0.16063576294326898,0.88343792401240828,-0.84208668682428911,-2.4940148565223033,&
        0.55103306277810860,0.75831804076401976,0.30520118185391965,2.3007693713478790,&
        -0.51404741662006948,-1.9279468695024016,0.86958248362205703,0.69357768605424575,&
        -0.38243793111656937,-1.2706297400746163,-0.63462249383684399,-0.17103367393458657,&
        -4.2864496440576341E-002,0.65272499812766449,-0.44318208231860956,-0.16124076524762110,&
        -1.1202264258764905,0.47876417251878239,2.6341957631244344,-0.84794801732259661,&
        -1.4033336750295571,2.0101031950993362,2.0901616485043699,-0.87202814286843344,&
        -1.2824359819648585,0.81329078256830400,-1.5602375243121744,-0.18224777791357716,&
        -1.1948189428246045,-0.46606615271959240,0.65973142666283446,0.21286168076497158,&
        0.56446536823350257,1.9233327590394611,0.75848178419013523,-0.44717518457242694,&
        2.2933474880470532,1.4883927481206025,0.18698736215385897,8.6618922131577292E-002,&
        0.93691905158888000,-0.28315967130676312,-0.18718637397029297,9.7162468909371330E-002,&
        0.16739487517061291,-0.19270649391368017,0.93452443933818496,-0.76834746619233218,&
        0.77439725400532144,-1.3598301497105467,1.0937189979962902,-1.7966643553584216,&
        0.55856718265225036,-0.67045518074831045,-1.6382029310381532,0.91140868180945300,&
        -0.62343258936269219,0.66621493337615956,8.2865282469141224E-002,0.61932961364444761,&
        0.54305277098078553,-0.60679739155248102,0.74284700731372133,-0.22969806173976826,&
        8.5807335051410930E-002,-0.89208231475080979,0.68845445938285532,0.91670754388560594,&
        4.9683420136132717E-003,-0.68005563771991517,0.91988277034802357,0.69595335727909047,&
        -0.50797711497608056,0.98406134400751144,-0.73751348288603058,-1.6658385049575664,&
        -0.19645375137276641,0.38213094383515478,-2.2445177391174140,4.7000000983915637E-002,&
        1.6387489537360269,1.4958066068028140,-0.71938169217149828,-0.83198171667210752,&
        -1.2150147722077738,-0.69694862535338842,1.6449656732696910E-002,-0.21902647163238581,&
        -0.35245102529528960,-0.32819157012905092,1.8370354554188890,6.0588586124796409E-002,&
        4.7196003519801653E-002,0.29204397043076996,-0.24871842197105021,0.53215225554335699,&
        1.8955877358228383,1.3064770714673073,0.35577301321950361,1.3805886739023185,&
        0.51044122253444923,1.1498850042266127,0.33502616480089142,1.1646546093506605,&
        -2.1901749853761996,0.20773669916398485,-0.83880029627205122,-8.3414916052186996E-002,&
        0.20650291304044505,-0.67916842497010554,1.4322648990647877,-1.4862183745625150,&
        -0.15322685692546234,1.3938270098234364,-0.34893359505397226,-2.6233676058615889,&
        -3.5535271381656721,0.44203500137773677,0.43076211274366161,-0.44852116167222777,&
        0.85852753248785096,-0.30477648382447320,0.30834137853782545,8.5955552446374081E-002,&
        0.29278435605085218,-0.44007135753282473,-1.2554048222077787,2.1486219364833845,&
        0.82805971969747338,0.86024661705377803,2.0184399078158486,-0.68614883855185949,&
        -0.38523994005193546,-0.72823709114573010,-1.3268558445548631,0.17320850876198338,&
        -5.7574344712139326E-002,0.89345671422647088,0.14097233244829921,1.2021807300315266,&
        -0.76487455693696638,1.7749031244328966,1.1920244379394788E-002,1.4798232304002417,&
        -0.16431027725569991,-0.73825463090371735,0.12127477704624806,-2.0373059691945019,&
        -1.1616346790443228,0.70179490792817867,1.9919439825442380,-1.6223992906977815,&
        -0.14779797077324663,-0.41087227320944775,1.8533796393345110,-2.1468078857415751,&
        -1.0781558483843314,1.0467381344309101,1.3411882664425960,-1.9178712424491231,&
        -0.40098427503850564,2.7093343040882201,1.3289466687697311,0.69230970892583610,&
        1.2692404670221686,-0.18119204119467955,6.9328941787665910E-002,-0.36820633680002846,&
        -0.81597090538617656,-0.31363803887214875,0.31327965779653572,-0.22954189287587187,&
        0.12690951661094430,-0.77338827421271217,0.11911121060271722,-3.9830623584493248E-002,&
        -0.62505637984082674,-0.43028369086615131,-1.1095444641421239,-0.97255604603620693,&
        1.1158619683459692,0.68269680875056582,0.14815457190436279,0.51998074069383848,&
        0.54568684387734301,1.6994760037392758,-0.70927026285666439,-0.69003698318523321,&
        0.18761706911954631,-0.31170221301941792,-3.1330189641673059,-1.5970399525473995,&
        -0.40175799196686196,-1.8050183752945665,0.40802685218518386,-0.47355784976614179,&
        -1.1593420572250923,-0.59393063797911860,-0.77122993376231974,1.0892493881956364,&
        -8.2720396212380670E-002,0.88559715859767218,-3.2272386703184039E-002,0.51848376885167391,&
        0.74209402247361256,-2.0202651884812930,-0.68894562344932797,7.9525419025424121E-002,&
        -4.6330728081797362E-002,0.26968409685451272,-0.84685790941036343,0.10810292710433245,&
        0.24983678844221299,-0.41654891073929251,1.0169023883258859,2.8750725730562893E-002,&
        1.6082036668068347,0.85414231928394424,-0.37959819939371958,0.50571686150046280,&
        -0.98097786898502748,0.96040255584833123,-0.72100829507949615,0.81410252759275814,&
        0.52211007500788897,-0.49978976333216918,-0.45448690576152367,-1.3448188836646053,&
        -1.5610355308389037,-0.13754954578494127,0.37047088462792188,-0.25308568317256325,&
        2.0254026198552121E-002,-0.55426639535039135,0.29420937319215945,2.1263190228705910E-002,&
        0.15720576786652560,0.65999700141105577,-0.81307165548295857,-1.0450227810800430,&
        0.34667549164528377,-0.28121121189437898,-0.83552271276855561,-0.32986057729830265,&
        1.0272485550240733,1.5281659110258896,-4.6373267134517684E-002,-1.6972716891151043,&
        0.47868149193748577,-0.37937563296040389,-1.8609006571293538,1.0135642660686939,&
        1.6331247102478672,-1.3391756917555595,0.18445668799905521,-2.7109041216191074,&
        -1.7505242324373531,0.26089960442644416,0.59516612949093994,0.74704813822412175,&
        -0.97379016699315135,0.57989706572975208,-1.0469741543349689,1.5346324559834037,&
        0.42702816140911787,-0.18760273287764162,1.5276081971075419,-1.3541246697873421,&
        0.52199111558748124,-0.41050083085008365,0.11147216037871926,-1.2744141310979979,&
        -0.14120566775349494,-0.37116535676406226,2.1589689983807521,0.73621359989232593,&
        -0.50644831066242291,-0.58477968115526568,0.29053796902792628,-1.4905136547349283,&
        0.96409927987229616,-0.13103693998045057,-0.69862913064395216,3.4514304820250252E-002,&
        -1.8452747113741153,-0.49788612652043440,-1.0239288510241749,-0.40253913924277412,&
        0.32279355941756133,0.88205075295792768,-0.83954899805492467,3.5269488840046326E-002,&
        0.39416650680684340,-0.91785481019525816,-9.3412229247751676E-003,-1.0098828288738677,&
        1.0516620944972830,-0.18630183286307259,-0.43791044186907907,0.25935294001829184,&
        8.3406240430850390E-002,0.44505283405976470,0.31765552611637210,-0.77593558479591074,&
        1.4157610091723776,-0.33583278142631434,3.0227858228258787E-002,0.69514735856255905,&
        0.38651341563136982,1.2581297575345942,0.23435950168608063,0.62584557387784001,&
        -0.69598691090141107,1.1923558178436571,-1.3112150515520349,-1.8760447681958057,&
        0.44924583854698913,1.3438274757120732E-002,0.29093362740528333,0.53950418756170770,&
        0.96045351697515413,-0.12711113709155716,-1.3400900906922544,0.48476326490031063,&
        -1.1166499863914721,-0.17412588320332925,-1.5329762290290332,-1.4671477693163089,&
        -0.55149948234477164,1.9545103616146060,0.87698910740061009,-1.0510003295842322E-002,&
        1.2467483583205883,0.13408548645950322,1.8284242868262945,1.7529907465439276,&
        -0.85374451310456057,-1.4576193493400282,1.0099512506957458,-0.31927274739169803,&
        0.75539465281359264,0.39227520781805580,1.1006675291106274,1.3881939817401865,&
        0.65713080467164642,1.0610023922081515,-0.45397883355868240,-0.27299767388156865,&
        -0.21411743046994644,-0.13911344781644436,-0.69135892579690217,-1.1476248615420208,&
        1.1115725015758717,-1.7103748955782858,-0.52366154272989063,0.40572918844664801,&
        -1.5151310132981064,1.0962444944810903,-0.79264591261211748,0.80184808232444549,&
        -1.6300796986297916,-0.27157197228886454,0.31960252904695707,0.24874486311135546,&
        0.78708975589565555,0.43812543758007910,0.76964613127406256,-0.50040729237671611,&
        0.69498450603541417,-2.2653331493902416,0.60987434813840247,0.43817691092079225,&
        -0.35804701196497246,0.24657689293323992,-0.34336905864444373,0.47283727039805923,&
        -0.56638268189849594,-0.93731390294621308,-0.77577777512941237,0.61115036794800282,&
        2.8052591542485801,0.14877530360645719,1.4299510648124152,-0.10275016375784388,&
        -0.33726951966689439,-0.18569607018543252,-1.6359656163483185,0.20121220109440846,&
        0.81385206926923948,0.39445836779097171,-2.1781140615139511E-003,-0.45471528702525343,&
        1.0145039153522815,-0.19486135494707058,-0.76238818936091779,-0.86285648315960395,&
        -0.91344601506758372,-0.17627620678489131,-0.80133696405261923,1.1327911558094406,&
        0.74040958892616371,-1.1662766366379056,-3.8687906300560918E-002,0.33435702795344990,&
        -0.73217086803988463,-0.46094021165954069,-7.5367247230275339E-002,-1.8482999687526556,&
        1.1670659587023959,-0.24178262835009198,0.68938564312510453,-0.35669356230645377,&
        0.77222938292262444,1.0933750297548051,-7.2695442564938165E-002,0.16227308352474148,&
        1.0689692117596654,1.4679232162168052,0.12180606785233591,1.8424986251381454,&
        0.80993751747116671,0.79909638991876086,-0.92106530154090804,-5.5641223853541331E-002,&
        0.42531435134960216,0.64526939179472742,1.9959884403520824,0.52579732011391123,&
        0.33270692525756290,0.47224105321557919,0.80598299049000877,1.5605462667280308E-002,&
        -6.3095023763751021E-002,-1.0810081405941820,1.1501920284425811,1.6464292859739538,&
        -0.11933036199926614,-1.2197855723075872,0.29996561735441518,-1.4856165309642637,&
        0.94200095241654180,-1.9177827194544244,-8.6900089259479174E-002,0.15251643863211400,&
        1.5535227306461377,-0.90348031299980358,-0.87285778138404313,-1.4313761606211071,&
        0.35038220789222435,0.21172592052439335,-1.6043472789083131,-0.35819952204628996,&
        1.8947472612384224,1.3090273936082251,1.2644586245888552,0.53563973991717773,&
        -1.3988659476791532,0.19339481505962447,1.7696175248136732,-0.24635498135473571,&
        -1.6224611244389595,0.77937596685104793,2.9678756817741925,-1.0780191210524797,&
        0.33576318722123516,0.75775142447929800,0.46364397389190071,2.8600356848017801,&
        -1.8357098028055299,0.94681634291676919,-1.0730576920382473,-1.0306806109490652,&
        0.16213040937015744,0.61440313636968802,0.53378935678929440,-0.54695107299233481,&
        -0.18407604743383646,0.59081506909130699,1.4494397913398698,-1.0530962078017652,&
        -0.40462252875780769,4.0383427217921611E-002,0.56854461149401092,1.2525816222612443,&
        -1.2256916934677013,-0.20747197514447535,-0.16305045820853456,2.0365880038854374,&
        8.5656495877427338E-002,0.66791487264061700,-1.1469340458267225,-0.71196518876913695,&
        0.30715135032211138,-0.49022796461458484,-1.5025031974984681E-002,-0.86482923464165595,&
        -2.3739632359299625,2.2021916852114720,1.1966925924714757,-0.54733679536961821,&
        0.13589349120144581,-0.52188179512499788,-0.22996533807877714,-2.1224632500522369,&
        -0.15311773367612444,1.4501329516675492,-1.2503566008574003,-0.74093223529059382,&
        9.5382239713277001E-002,0.78722073191502617,0.14798905296698256,1.5485792626981612,&
        -0.15827643299544161,-0.44120106707627343,-0.54519048601333586,-1.5450841576263110E-002,&
        0.72947623355131019,-1.6147585969789728,-2.6905872309345735,0.66583842652795500/

        DATA MC25/-0.65012040667856164,-0.70456454877238628,0.68250886647012576,-1.1037086459592911,&
        1.1928099691436509,0.67189614665666297,-0.28744179903810668,0.25246122418377981,&
        -0.88870020053054177,0.39005207457867030,0.91725399294552612,-0.93752305015622139,&
        1.4879534687081026,-0.56115230568234686,-0.18509735872539626,0.36529495613019242,&
        -1.0204925907611926,1.8580739058788784,1.5884625612619450,-0.52516587666697478,&
        1.0591800438737213,1.0558368784092877,-0.43069096254146227,-0.23030930618936019,&
        0.62503056962780323,-0.84895101691306607,1.2165695114965693,-0.45958879382980189,&
        1.0621673513477841,-1.1700091813021982E-002,0.67548510843733178,0.42151214107860707,&
        -0.47745440676908574,0.29963322492293282,1.3929721067535117,-0.18880724094895743,&
        -1.3759793111582479,-0.72923607531351187,1.6751070244849631,-1.0382327671925953,&
        -3.1886414336118087E-002,-0.36634177685958264,-0.33581492074729935,-0.13850795227242074,&
        1.1469056030370470,-0.26029001080377828,0.59790656142809706,-0.95324106829373834,&
        -1.3847516805775171,-2.1706173626646339,1.7596631840968906,1.2830549126194382,&
        -0.20374913918879856,1.3802803257761760,-1.1875795970488017,0.24032406820494825,&
        -0.61172844780711999,-0.87148673151295708,1.1253581964590540,-1.1487168138781740,&
        2.1097745172650946,-0.90270879571838181,0.82488058079637783,6.8257577766022398E-002,&
        -1.1307367997168856,-3.3539204619676542E-002,1.1821988139553983,-3.1340148619305883E-002,&
        -0.41771728968458405,-1.4213306180475829,-0.66148742445919706,1.1022960194247202,&
        0.70328680572438851,9.4346604335878825E-002,0.23815064394607444,-1.8322640867912920E-002,&
        -0.56715315712019065,-0.95301388291384448,-1.7886475177548258,0.56370228421775415,&
        0.30462458534629239,0.18961042082890986,0.33825523465941038,-1.4820278591745075,&
        -2.1400967976104350E-002,-0.20457254730452201,-0.27283112090472328,1.1097273461777597,&
        -1.8473072727299098,-0.72738928609105380,-0.19963103900613371,-0.17508250663598357,&
        -0.19496423752994019,-0.18273797059781463,1.4862421063203040,-5.3242374716431881E-002,&
        0.82579224966340548,1.7048937413143739,-0.33817951624468096,-0.41103556669557745,&
        1.6488322198161776,0.57293346316805183,-0.29677969366196910,0.43693061808100736,&
        -0.36995797855205986,1.0137424505016748,0.88962466784159566,0.42039679373937444,&
        -1.6645483895963440,1.0020971749610095,1.0089278303006941,1.7560237144341928,&
        1.0836948188988453,-0.46550191464102092,0.51642247552737786,-1.0431353489560660,&
        -0.14780832591230636,0.31557156453043428,1.6134554613023933,-1.2784296436581550,&
        0.87687304260809351,0.61181681150890610,0.74191396673100751,1.3641594473417298,&
        1.3237570511055887,-1.1521117114601792E-002,-1.4655924148972745,-2.3693374630094338E-002,&
        -0.64035707513277407,1.3722361158187357,-0.16430635215060418,-0.82523042227405008,&
        -0.23872486369866325,-1.6326913799674470,-0.30589721834644540,0.38984503479370147,&
        0.19265730290099747,-0.30235025624657635,-1.3788748208462152,0.27088891402722343,&
        0.37258960838729405,3.3105063564423118,1.7392479721726355,1.2954176658222278,&
        -0.57613318667586388,-1.1089806974081475,-0.45810989530494384,1.1000621658337204,&
        1.3199278669430441,2.2499296074111874,-0.96846475450222080,1.4751800225281295,&
        0.74810901556976284,-2.1114874361227138,-0.29321599179720820,-0.65863621966732255,&
        1.0168595557802214,-1.1015334678224218,-0.75251326736423885,-1.5622469231730178,&
        -0.12827773890027905,1.6073354278358265,-0.80868736921191031,1.4893992259151845,&
        -0.15253223593218485,0.93039453429692631,0.63243322925005130,1.4494085537230261,&
        -0.92623203951383126,1.0498008754492252,-0.59779080894655445,-1.7094581425894775,&
        1.5385103834358562,-0.72628484857544739,-0.15648251603225805,0.25059533853167532,&
        0.79127937373445689,0.13527535166240454,-0.35248577465174175,-0.96427268098330066,&
        0.30593091680070006,0.65731947818702474,1.0466044417294755,2.4755445176310302,&
        0.65332902919307745,-3.1498339034929781E-002,-4.2829438201278859E-002,-1.6216465672086320,&
        1.0861106555700692,-1.4784997501280119,-1.6004378899127962,1.1352381879000091,&
        -0.29228063871504212,-1.4874031278487190,-1.0168276948207857,-1.1211094067222793,&
        -2.1467784124397000,-0.91024142426502075,1.0929471971166622,0.63250053400120432,&
        0.45283649370464724,-0.40293665944954471,-0.99504734796754857,-0.56748481742550128,&
        0.15671416083312409,0.76102563871748485,-0.38291919762547805,-0.40847543747794413,&
        0.12219371714453414,-1.2020014626737339,1.9654548975023427,1.3662562321513381,&
        0.79773699955497401,-0.67601941561707479,-0.50905499040809410,-2.1352658999573912,&
        1.5870705957233933,0.19341550296013113,-0.73535236153710903,1.3913061061018619,&
        -0.67210427830961084,1.0316215643948869,-0.61647179159502608,0.44235789394017327,&
        -0.21464504872216020,-1.5559788880150209,-0.23889405288461821,1.1211028585189777,&
        0.59751783795852020,1.1074567338437584,2.0912026261052588,1.0595742348480615,&
        1.1569337626020799,1.2765588706703090,-1.3973490181914492,-1.5115535212305511,&
        -6.9023729705498613E-003,0.90673295513203112,-0.58005323317352719,1.8059778127815851,&
        0.51097904981099107,0.89595933949549944,-1.5047995158818623,0.47048033631652364,&
        -0.34434122444895471,1.5928270367496391,0.62409771320653107,-0.78642213443569242,&
        -8.6490243046399240E-002,1.1176464152859560,-0.38731185903588400,-0.23211776586025534,&
        -2.1227986978730211,0.83658602144059124,0.43936960514093021,-0.63784404287902197,&
        -1.2701612782800638,-0.55461651423287250,-0.55814154932004201,1.9866030076991998,&
        -0.44876820417782387,-1.1390485556807666,0.52473286650297291,-0.21862645047747062,&
        0.83081234428808171,-1.3575124569421819,0.25249686484118111,0.10509154485977733,&
        -0.27544861304923957,0.51458783099028305,-0.74517121818366849,0.76029757586484181,&
        0.43453652278109023,-1.8082622068580869,-0.41749550662141460,-0.47867979765824764,&
        -0.40000111467963262,-0.47407095684492362,-0.50728458239540497,0.20319024442572831,&
        2.4702307662591334,-0.10049811136181029,1.3884040873396148,6.2492526428020785E-002,&
        1.3723898155851790,-1.2848768491431859,0.59984072762830909,-0.16232951456024775,&
        -2.9933464766589486,-0.25506362036532448,-0.73115612803978780,-0.74003466038520149,&
        -1.4177985726983986,-0.29583431324034698,-0.23624327159887051,2.0880616556923377E-002,&
        0.41695584579269451,-0.17487525476470703,-0.35601362242191004,0.39030302995805910,&
        -0.30855686034670921,1.8404824584659960,0.89742764480668125,-0.44910499785658364,&
        -0.92684657341839860,0.99187568487291145,-1.0604869652404880,0.39642200055628002,&
        -1.8328018494491825,-1.7301916913219588,-1.9951401617073630,-1.4375632416536881,&
        1.1165783570649639,-0.98391700939256799,1.1882025331221164,1.6263143655102217,&
        -0.35861240752332396,0.58803648728792768,1.6018341354809413,1.9981051352248256,&
        -0.71302625189288293,0.27184515425876382,-1.2688961498937357,-1.0240995912398949,&
        0.60093603991751277,-1.4866676941885058,-1.1530547241967315,0.29095322384379957,&
        -0.31823169843537480,1.1415350884181523,0.14093514673421520,-0.11105296313180486,&
        0.19366467106217833,0.38264082522714993,2.2731025400917373,0.83718355822890400,&
        -2.2340930934021159,-0.37850049046872136,0.27783371782108007,1.3409431505732328,&
        0.49301966814523895,-2.1947637510426006,0.59840772327328007,0.82764705933672045,&
        1.2017583635383482,2.0280475615976568,-0.78471658437895297,-0.60218361963815581,&
        0.34658866684881628,-1.0233141611983096,-0.46232348169382392,0.57392523016348973,&
        -0.16476726721292512,0.31867916210579877,-0.44267798206386416,1.1450537133926688,&
        1.9726051864079071,0.59105001500752075,0.78544367439777352,-0.57539505370488242,&
        -0.40471348907718641,1.2121034720250012,-1.4775038371116460,-0.10137938472396248,&
        2.0697772851218268,0.48958839770799667,-0.58670415731675141,-0.36517673677607582,&
        -0.65392844128951855,0.98727590176623126,-0.42464827724626319,0.52747633793128201,&
        -0.81166836744935345,-0.97145019388096754,0.33317914951349425,-0.98238237199995482,&
        -3.5359183277156252E-002,-0.57990104683506372,-0.77885515549663442,-0.97531308613924472,&
        -1.4501706505282872,-0.26551971489632437,6.0685769348173213E-002,1.1129452434446752,&
        -0.19845405447275360,-6.7204519399923460E-002,0.84712403624268173,-0.68846657430894975,&
        0.42811638153373072,-1.6270483764831873,-2.3398375601444172,-0.94874762132398571,&
        -0.49627891987460304,-3.7734108591401163E-003,0.80585333847233498,-2.2498480280663200,&
        1.1913432405345723,3.1713973975268962E-002,0.53858286415454915,0.80382900296279969,&
        -1.7627627359126550,-1.1015131810828724,2.8408975363283750E-002,0.27147293381873694,&
        -3.1008084215401195,1.3496022299603458,0.51928088912539905,-0.68087760441792711,&
        0.96737211531871026,8.5646532793964281E-002,1.6167134496302473,0.25662886867452694,&
        -2.6399963772957320,0.39889529758866998,-2.0739339606920343E-002,0.32339090907781576,&
        -0.40222081971338747,-0.87959114382606829,1.2989007573729214,-0.69473056920589971,&
        0.59834196367143655,-0.24299969843369376,0.67887377136512406,0.22361102745449282,&
        1.6039553407109053,-0.25827860322350071,-0.48477802270754183,-0.35407751495738615,&
        -0.59961437943817597,-0.11117005171490522,5.9742931296188968E-002,0.27507156192025040,&
        0.85085154006798247,1.2159646646076405,1.7540216253681071,1.3689524814761009,&
        -0.45094429039333589,1.6604187726681074,0.21890207149751620,-0.96110548403651541,&
        0.66675099781296210,0.24549630917009629,1.6941782960803098,1.6169592966736499,&
        -2.7400857007761341,-1.4538036802461860,0.21022723513310754,-1.0212221985036412E-002,&
        -0.13188458057612970,0.41907072883287649,4.1334379745924833E-003,-0.26040734534278182,&
        0.56904158987754416,-1.5007082344024860,-0.78031886810950790,0.44233422754171720,&
        6.8028604535091228E-002,-0.14303110710159622,0.66681862131121827,-0.65310409948060855,&
        6.8669137828095680E-002,-0.65456841316100145,-1.6160025219107903,0.94641261267940879,&
        0.62585564533371207,-0.50801725453608493,-0.63193022175530622,-0.62503275224787591,&
        1.2628133094670451,-0.28376374652786718,-0.94560470836902166,-0.39563621873147609,&
        -1.2341011305564127,0.31768430518343177,-0.18491978021230726,-1.0801615726775606,&
        -1.4546192769841173,1.2047299894527863,0.24352603602776107,-1.5663525526385857,&
        -0.96928008674264132,-0.18619117526320614,2.7673398319345974,-1.0277115470220277,&
        0.13212367946238623,-2.1131992230146937,0.19643681715554995,0.65139060703145779,&
        0.96983339434576588,0.65842244866811950,-0.99409574251155730,-1.5567621837180654,&
        -0.14680578426151467,1.0044557223695880,-0.21361248523052684,0.13864874287236151,&
        -1.2681663795892515,-0.55809996880120549,-1.0062744732967501,0.14888131719777997,&
        -1.3478209004835531,1.4663273527383025,-1.0060714199281111,-1.6421159062358728,&
        1.5096196639018531,-0.43491398945544740,6.9127547617477150E-002,-0.56554295857023251,&
        -0.94308373692264791,-0.31871487256418646,1.2652129893812121,-1.3636116226604922,&
        2.2352196837191931,-1.5056544494154338,0.12447027107426872,-2.0209554549235480,&
        2.5667166812755573,0.62744254643767905,-0.89202183467941998,0.11810545106689310,&
        0.95742846445453700,-0.22423909768640066,0.10881154695187839,-0.10894223081995186,&
        6.2593089708841657E-002,-0.25955631465718537,-0.84766676294721566,-3.2178122811261790E-002,&
        -0.44802879165599407,0.59712894343710132,-0.21432453706136886,0.70276086956471007,&
        1.2750494089909223,7.8370682539916654E-003,-0.53936998068452269,0.45064710123185292,&
        -1.3328851560510691,1.3498768861608932,7.0111915667465621E-002,1.4754538197485600,&
        0.28882028223494211,1.9276484733976529,-1.0574031809305868,-0.76297929136328546,&
        -0.38006552006615563,0.99026305814544247,0.29171167582157603,1.0752600950818378,&
        -1.0540962586952696,0.45209878414237586,-1.3937906241092510,-0.30410402012282289,&
        1.1505538005851830,-0.32526946900512627,-1.2266968745959341,-1.7066452095924443,&
        0.81518713392492759,1.1814805791289298,-1.2706744889859620,1.2987900336387845,&
        8.9731817461475294E-002,0.90093862567396021,0.66538111005501288,2.3290162165296584,&
        0.83014376913738663,0.55140950557290891,-0.45370219284771351,-0.80380860135386667,&
        -0.12975715367515592,1.4134352409725062,-0.18070371023414175,0.64226359945413003,&
        0.73732435285995146,5.0569998592679286E-002,-0.22570326780077152,-0.52447213943232485,&
        -0.32711812746486368,-1.6624274724964796,-1.2341801786521254,8.5824750763424357E-002,&
        -1.7443796186679086,1.7148684923488213,-0.89229480257223881,1.0617813622002856,&
        0.68353582200393548,1.0178509599513375,0.52891549314356145,-0.47926375209834610,&
        -2.5046346016962997,-0.26905342812375083,-0.47627770328730584,-1.2805348517565942,&
        -0.99188829516602994,2.3039895709306736E-002,1.6934029095484431,0.84397472653834560,&
        -0.30528086988496050,0.45902698877430370,-3.5662282300667661E-002,0.30163330708812047,&
        1.3735328392278363,0.52830799308437626,0.70472652614359677,0.39548920418786276,&
        -0.95985633108875701,-0.45493599045562283,1.2695231564297389,-1.8635585864361577,&
        -0.32394950507688614,0.56680063178034645,0.48603343333536864,0.78208904040971572,&
        1.4545516819285065,1.4704511462362821,-0.88726084705553521,-0.25852599768612938,&
        0.13834793161088965,-0.23228463787567374,-0.50712194613043449,-0.23508668331258339,&
        -0.19924832135016760,-0.18172061524719504,0.97164408750929632,1.7556716793143581,&
        0.66947095273275292,0.32359226704718136,-1.4335319806273323,0.51945383938725498,&
        -1.0438819320706814,0.40614492840714433,1.1740498472000793,1.2205046959102122,&
        -0.68806997968009642,0.64157192717206357,-1.6862124988873237,0.60953143446841407,&
        1.1671558563081108,-1.7214283087672004,-0.78377474307106554,1.0138966441253789,&
        0.36194597182157567,0.89072227312687369,-0.42247700536917393,-0.38738453705128140,&
        -1.9678596473011551,0.32084627207322514,-1.4500825466820777,8.5257998914740271E-002,&
        -0.48288897655867380,-0.51376449540460745,-1.9147885371984539,-2.1314978534617857,&
        1.0035235782082919,-1.1345547388209507,-2.5626245125477922,0.70600520818016477,&
        -2.3461050798841447,6.9691247066962850E-002,-7.9602181956797691E-003,1.5607701627980690,&
        0.37265490436076548,0.18761918593821114,0.72968575723726625,1.4214991117939131,&
        -0.10738884190572494,8.8354483203042580E-002,-0.67790613642816411,-1.4276960407821200,&
        -0.90224109258464913,0.44241378435441109,1.5573145853947432,0.39054898483934075,&
        1.1431141554938535,-0.43020702006883593,-0.58158564573429972,0.25436600559178801,&
        -2.3516859775051726,0.73284721097031014,-0.57583633869147266,-0.17704190571617595,&
        1.8217386464125243,0.29246868894370659,0.24184240346410416,0.55117683172302279,&
        1.2277161395868963,0.51165013191341124,-0.73845169757085005,-0.11959750867193264,&
        0.54445976521846595,5.4797035952664400E-002,0.68569544979403874,0.48672565010552643,&
        -1.1106464027082092,0.61299149266325681,-0.28251252070543748,-2.1571062058611608,&
        -0.21201493157222967,-2.3202031462570196,0.53607104227702140,0.84647563471046239,&
        1.0288744272901329,-0.72266863860243513,-0.27401506643335533,-0.98511334298675168,&
        -1.3867436551263110,-8.8713315674486273E-002,-0.33467910414659130,-0.87445541098942381,&
        -0.97166513015246780,2.2187515422962742,-0.66449975351757784,-1.6129385565979932,&
        0.93991828396462407,-1.1973740193418319,9.0041297720155733E-002,1.9595904065670384,&
        0.53019366359356779,-1.4859170681194245,0.86906044151997475,0.94526563472587755,&
        2.0207341490818984,0.17983727832049740,1.0803118076174325,-0.85536662413137166,&
        1.7370392067085803,0.12025341391865001,-1.0844911925936345,-0.38870724699931281,&
        -0.55322264023771384,-0.44974901716377241,-0.14167005042574052,-1.1459690308986985,&
        -0.39092539430244022,0.69137557552059781,-1.6503714444388791,-1.0792664250610116,&
        1.5829848151095753,0.32404231872160705,0.99813940781436206,1.4277018654308797,&
        1.5659251392060611,-0.91761058078812241,1.3449475102025203,0.14445559681122194,&
        -0.15852549903065344,-2.3299521826290137,0.59100075436598798,-0.29079470349999575,&
        -0.71570310474034793,0.42086627198707116,-0.99388152906356586,1.2856441045107814,&
        0.67821081967935959,-1.3032156002562860,-0.21102982288185132,-3.1414314924412191E-002,&
        0.42810052463663389,0.16888132451543361,0.49685501094520895,0.88627390246106541,&
        -0.13174237383371601,0.42214087181003118,1.8471105997372988E-002,0.61927047899228094,&
        0.88807645780465738,-0.49714370773395361,-1.2370798658705482,0.75576446364583771,&
        1.4632012273744475,-1.1055096609310666,0.97708453931611972,4.8833646496093966E-002,&
        -0.44178985606013005,-0.79640573493191147,0.91883823203420345,0.34291640273627927,&
        -0.88794694140348973,-0.30005972043050816,0.15950609055737841,-1.5852169718691997,&
        -4.4151783097771062E-002,-0.92667417082040493,-1.4487551632619615,0.23015359627289197,&
        -0.50390215769711533,1.6527423534501215,0.19925771320561622,1.6290414307618224,&
        -7.3702200240223031E-002,0.66087268029454205,-0.33214785761259641,-7.1200994562241243E-002,&
        -0.15483765423466928,1.7285573712199431,0.76571534068232439,-0.73035453265629302,&
        -0.10709465964852705,-0.60673509690224214,0.27471059926605562,-0.59203315255144662,&
        0.10110428425236045,-0.22541124855496894,-0.60407141218049798,0.71297201292769430,&
        0.50212053027697634,1.9264787040988334,-1.2334609319644114,0.16349194462045677,&
        0.23321556586153805,1.0123641933916319,-0.61112266809948201,0.21313425242879125,&
        -3.2920831520607687E-002,-0.70220309974624961,-0.89184787355309425,0.46856171247413564,&
        -0.33532363383085473,0.40796237501913951,-1.0483667463135373,0.13607631516262950,&
        2.1255562046324668E-002,0.37864667239424321,-0.27674908071733090,-1.2842044822298229,&
        1.4494072012839914,0.32771147387234545,0.49543864905535906,-0.58676565916444956,&
        -1.1304081345794723,-0.89990851787577653,-0.76262740717944055,0.19790075463267995,&
        1.1878334683489324,-6.8930422622000317E-002,-1.1815381352461221,-0.22722591674474601,&
        0.64446079768806575,1.0059929543527255,-1.0316705610945933,-0.21334787440818156,&
        0.74623937950440133,-0.37583966364679239,-0.39070785402370706,-0.98780008490264914,&
        -1.3502771401811737,0.95458098339184039,-0.73174023594467230,-1.1473730679307381,&
        -0.66042995763365475,-9.7200866622251095E-002,0.35785290004579356,-1.9172317997284352,&
        0.80346020785728300,-4.7944937789570714E-002,0.65222315540988662,0.76321333355418064,&
        -0.31223054640879117,1.9631702855692088,1.9466221737584805E-002,0.49637819095313301,&
        0.74500113196396245,-0.28226760423738517,-0.12467868920973663,-1.0706321470060927,&
        0.86148310496326508,0.59431991060604417,1.1144627066267194,0.13077934024643936,&
        -2.8531218667800213,0.68773143195984288,-2.4853147917494991,-0.94598614094325073,&
        1.4822879168008292,0.10884542186461318,1.6042750665301300,1.6055744984373648,&
        1.5508533296200238,0.46761687626897264,2.3427994409182906,-0.17292166269940681,&
        -2.0414216051938485,0.77600127591322599,1.0615774379675107,0.22212332281775471,&
        -1.9973059003807234,-0.45862583659672962,-9.1425159212312784E-002,0.77286068749616577,&
        -0.17535635499183477,1.2425730771134575,8.3033327959473102E-002,-1.0951191194862611,&
        1.3053863457130088,-0.16274619695871256,-0.23902692053097552,1.4001787058797948,&
        -0.83566945432301820,-0.70870511963870420,-1.9076019859922735,-1.5829614371930378,&
        -0.20383282029513450,0.43794725349838515,1.0563570622435736,1.2802740597141120,&
        -6.8731955497874739E-002,0.62206356635752513,-2.3267515519176367,1.1798963509632654,&
        -7.4888794112543802E-002,0.23871038399966507,-0.89101179382388529,-1.1085310101500936,&
        -0.32906791976555877,-0.78912126438849661,1.2106915340751281,-0.40361953139113821,&
        -0.46983503421624673,-1.8187283501157194,0.84927516909203793,2.0154593663175517,&
        -0.93367302208721159,-1.7775844559532474,1.7189369294364538,0.64533740996404965,&
        1.4464311679850075,0.45924343796859873,-0.55276613725300960,-0.27860672029344286,&
        1.2139328743589004,0.50455259863346102,0.54201887573118135,0.91148870086889011,&
        -0.78551360606590837,1.4164573478813489,-0.92149605601144569,0.80161907395371657,&
        0.85243276756879727,-0.75727120389438618,-0.63389573943462363,-1.4944355397812021,&
        0.28466541871400275,7.3049379565859107E-002,0.79315982793238360,0.24645243697904931,&
        0.20204625268375354,0.28695452877598515,1.2035665534934865,-1.8562118874452012,&
        -0.46180922578853417,0.12016331978272338,-0.68178722009799375,-2.0658690626792859,&
        -9.9693611445766089E-003,0.56994819224746440,0.68128070694650311,0.76369162384345768,&
        0.47840296422583212,-0.72021364959002487,1.6822462229321016,-0.25303815892734954,&
        -0.95169442972082330,0.94055860543243475,-0.82478459986530150,0.65216766954507832,&
        0.62515768227613333,2.0807030765297108,1.1844750875609489,0.49747518124640205,&
        -1.6571353906058395,0.65818601084961725,-2.0599317714721774,0.49899753586130985,&
        -1.3451575936690952,0.64733118788080912,-1.7654687046680064,0.24682085130633727,&
        -0.16462453476258201,0.55671944240028604,-0.30904022308451629,-0.21411865439489267,&
        -1.0744356702462872,0.17329180438064382,-1.2948917966405218,-0.89374658781284078,&
        0.16754592736686186,0.64122032846670873,0.60085280279548525,-4.1199202415667192E-002,&
        0.66936025433801494,0.91038632408524200,-0.63096026279433948,1.8743106198104293,&
        0.73789243262574900,1.6843526198421535,0.97681009428564891,1.5525232277792718,&
        0.65796177084115570,0.43660088430348565,-1.0924576319880754,-0.51742248795827417/


        data QMC500_1 /0.0d0, 0.674489750196082d0, -0.674489750196082d0, -0.318639363964375d0,&
        1.15034938037601d0, 0.318639363964375d0, -1.15034938037601d0, -0.887146559018876d0,&
        0.488776411114669d0, 1.53412054435255d0, -0.157310684610171d0, -0.488776411114669d0,&
        0.887146559018876d0, 0.157310684610171d0, -1.53412054435255d0, -1.31801089730354d0,&
        0.237202109328788d0, 1.00999016924958d0, -0.402250065321725d0, -0.0784124127331122d0,&
        1.86273186742165d0, 0.579132162255556d0, -0.776421761147928d0, -1.00999016924958d0,&
        0.402250065321725d0, 1.31801089730354d0, -0.237202109328788d0, -0.579132162255556d0,&
        0.776421761147928d0, 0.0784124127331122d0, -1.86273186742165d0, -1.67593972277344d0,&
        0.117769874579095d0, 0.830510878205399d0, -0.53340970624128d0, -0.197099084294312d0,&
        1.41779713799627d0, 0.445096524985516d0, -0.946781756301046d0, -0.724514383492365d0,&
        0.626099012346421d0, 2.15387469406146d0, -0.0391760855030976d0, -0.360129891789569d0,&
        1.07751556704028d0, 0.277690439821577d0, -1.22985875921659d0, -1.41779713799627d0,&
        0.197099084294312d0, 0.946781756301046d0, -0.445096524985516d0, -0.117769874579095d0,&
        1.67593972277344d0, 0.53340970624128d0, -0.830510878205399d0, -1.07751556704028d0,&
        0.360129891789569d0, 1.22985875921659d0, -0.277690439821577d0, -0.626099012346421d0,&
        0.724514383492365d0, 0.0391760855030976d0, -2.15387469406146d0, -1.9874278859299d0,&
        0.0587829360689431d0, 0.75021537546794d0, -0.602449453164424d0, -0.257393526100938d0,&
        1.27269864119054d0, 0.381105454763556d0, -1.04315826331845d0, -0.803172565597918d0,&
        0.556125593618691d0, 1.76167041036307d0, -0.0980721524886611d0, -0.4235760842012d0,&
        0.977897543940542d0, 0.21710694721013d0, -1.3662038163721d0, -1.18916435019934d0,&
        0.298102412930487d0, 1.11319427716093d0, -0.339311606538817d0, -0.0195842852301269d0,&
        2.4175590162365d0, 0.650104070647995d0, -0.69928330238322d0, -0.916556667533112d0,&
        0.46682512285259d0, 1.4734675779471d0, -0.17716982099174d0, -0.510965806738247d0,&
        0.858484474141832d0, 0.137513402144336d0, -1.60100866488608d0, -1.76167041036307d0,&
        0.0980721524886611d0, 0.803172565597918d0, -0.556125593618691d0, -0.21710694721013d0,&
        1.3662038163721d0, 0.4235760842012d0, -0.977897543940542d0, -0.75021537546794d0,&
        0.602449453164424d0, 1.9874278859299d0, -0.0587829360689431d0, -0.381105454763556d0,&
        1.04315826331845d0, 0.257393526100938d0, -1.27269864119054d0, -1.4734675779471d0,&
        0.17716982099174d0, 0.916556667533112d0, -0.46682512285259d0, -0.137513402144336d0,&
        1.60100866488608d0, 0.510965806738247d0, -0.858484474141832d0, -1.11319427716093d0,&
        0.339311606538817d0, 1.18916435019934d0, -0.298102412930487d0, -0.650104070647995d0,&
        0.69928330238322d0, 0.0195842852301269d0, -2.4175590162365d0, -2.26622680920965d0,&
        0.029378775744157d0, 0.711842195939419d0, -0.638055580922517d0, -0.287881432831012d0,&
        1.20926123170915d0, 0.349701803553895d0, -1.09518065276139d0, -0.844415077375257d0,&
        0.522154877598001d0, 1.63732538276806d0, -0.12763541906627d0, -0.455933915613139d0,&
        0.931562830007115d0, 0.187125162225721d0, -1.44507257981807d0, -1.25099171546255d0,&
        0.267528206101097d0, 1.06018047943536d0, -0.370597291109629d0, -0.0489771572021319d0,&
        2.06352789831624d0, 0.614231289060245d0, -0.737304000438654d0, -0.962223195295421d0,&
        0.43431116117521d0, 1.3915374879959d0, -0.20709265272436d0, -0.544732512988176d0,&
        0.816765415315091d0, 0.107915779489187d0, -1.71722811750574d0, -1.56668858606841d0,&
        0.147404821612355d0, 0.87272589462704d0, -0.499840344883735d0, -0.16723200837085d0,&
        1.50310294312927d0, 0.477771988903886d0, -0.9017541138301d0, -0.686833748574731d0,&
        0.662247682488414d0, 2.66006746861746d0, -0.00979167316134535d0, -0.328957912640491d0,&
        1.13157655838619d0, 0.308354631344837d0, -1.16953661020714d0, -1.34171784108025d0,&
        0.227143062502715d0, 0.993815907860883d0, -0.412889601443654d0, -0.0882380194499245d0,&
        1.80989223848061d0, 0.567591323544569d0, -0.789726519943266d0, -1.02643306313791d0,&
        0.391655871092591d0, 1.29502240670581d0, -0.247285215340805d0, -0.590750658062819d0,&
        0.76325304373257d0, 0.0685943705051181d0, -1.9213507742937d0, -2.06352789831624d0,&
        0.0489771572021319d0, 0.737304000438654d0, -0.614231289060245d0, -0.267528206101097d0,&
        1.25099171546255d0, 0.370597291109629d0, -1.06018047943536d0, -0.816765415315091d0,&
        0.544732512988176d0, 1.71722811750574d0, -0.107915779489187d0, -0.43431116117521d0,&
        0.962223195295421d0, 0.20709265272436d0, -1.3915374879959d0, -1.20926123170915d0,&
        0.287881432831012d0, 1.09518065276139d0, -0.349701803553895d0, -0.029378775744157d0,&
        2.26622680920965d0, 0.638055580922517d0, -0.711842195939419d0, -0.931562830007115d0,&
        0.455933915613139d0, 1.44507257981807d0, -0.187125162225721d0, -0.522154877598001d0,&
        0.844415077375257d0, 0.12763541906627d0, -1.63732538276806d0, -1.80989223848061d0,&
        0.0882380194499245d0, 0.789726519943266d0, -0.567591323544569d0, -0.227143062502715d0,&
        1.34171784108025d0, 0.412889601443654d0, -0.993815907860883d0, -0.76325304373257d0,&
        0.590750658062819d0, 1.9213507742937d0, -0.0685943705051181d0, -0.391655871092591d0,&
        1.02643306313791d0, 0.247285215340805d0, -1.29502240670581d0, -1.50310294312927d0,&
        0.16723200837085d0, 0.9017541138301d0, -0.477771988903886d0, -0.147404821612355d0,&
        1.56668858606841d0, 0.499840344883735d0, -0.87272589462704d0, -1.13157655838619d0,&
        0.328957912640491d0, 1.16953661020714d0, -0.308354631344837d0, -0.662247682488414d0,&
        0.686833748574731d0, 0.00979167316134535d0, -2.66006746861746d0, -2.52050221719036d0,&
        0.0146878031333598d0, 0.693045098387663d0, -0.656163781150379d0, -0.303224538198166d0,&
        1.17929369001065d0, 0.33413028225882d0, -1.12233801170217d0, -0.865583239756308d0,&
        0.505395256291619d0, 1.58361547580179d0, -0.142457369611016d0, -0.472291481268261d0,&
        0.909130489944847d0, 0.172198788871808d0, -1.48812189602338d0, -1.28378055260817d0,&
        0.25233614780249d0, 1.03475948108824d0, -0.3863752869032d0, -0.0636878869241329d0,&
        1.95332370774539d0, 0.596589849251445d0, -0.756718131051078d0, -0.985825500405061d0,&
        0.418226872548409d0, 1.35385936407511d0, -0.222122208220557d0, -0.561849225726257d0,&
        0.796431543684233d0, 0.0931539598455833d0, -1.78526249043532d0, -1.61890014353736d0,&
        0.132572793629228d0, 0.851428708305571d0, -0.516552258376321d0, -0.182145235070168d0,&
        1.45912302502159d0, 0.461372678278513d0, -0.924033738805388d0, -0.705548838662176d0,&
        0.644068138600693d0, 2.33523304006881d0, -0.0244812369184941d0, -0.34450205612612d0,&
        1.10414267929223d0, 0.292988096856233d0, -1.19915225099327d0, -1.37876004322192d0,&
        0.212097141151849d0, 0.970030579177241d0, -0.428937443704609d0, -0.102992718520838d0,&
        1.7390199717299d0, 0.550420122521827d0, -0.809950283969892d0, -1.05163128165734d0,&
        0.375846185216561d0, 1.26177086163599d0, -0.262457496397155d0, -0.608329815634632d0,&
        0.743744189746654d0, 0.0538793990464063d0, -2.02401362371916d0, -1.89122923782011d0,&
        0.0735025059641587d0, 0.769820715012041d0, -0.584931540146927d0, -0.242240583770448d0,&
        1.30643035112756d0, 0.396947399151455d0, -1.01817720560067d0, -0.783056813674774d0,&
        0.573352197171953d0, 1.83567153691254d0, -0.0833242105440363d0, -0.40756406632868d0,&
        1.00187027637698d0, 0.232169649403845d0, -1.32977095018121d0, -1.15988961852528d0,&
        0.313492852637276d0, 1.14091270934231d0, -0.323794328878954d0, -0.00489577790634245d0,&
        2.88563491242676d0, 0.668356195590579d0, -0.680648785127646d0, -0.894426479612224d0,&
        0.483266884672673d0, 1.51842914115259d0, -0.16226934990287d0, -0.494300814491471d0,&
        0.879913353819681d0, 0.152355884338473d0, -1.55019904079176d0, -1.69622250500661d0,&
        0.112841457367714d0, 0.823618695051533d0, -0.539062470681719d0, -0.202093345575596d0,&
        1.40454624815887d0, 0.43969744961512d0, -0.954474027767443d0, -0.730894247427629d0,&
        0.620154232595207d0, 2.10655408816281d0, -0.0440760921002205d0, -0.365358587538023d0,&
        1.0688078752592d0, 0.2726058039057d0, -1.24035599423067d0, -1.43130175910248d0,&
        0.19210973438208d0, 0.939145102896062d0, -0.450508606282178d0, -0.122701154016606d0,&
        1.65632386534081d0, 0.52777393514818d0, -0.837442740149245d0, -1.0863057362981d0,&
        0.354911023290717d0, 1.21949532284622d0, -0.282782265212403d0, -0.632066001577947d0,&
        0.718163873887231d0, 0.0342770193514366d0, -2.20657521653713d0, -2.33523304006881d0,&
        0.0244812369184941d0, 0.705548838662176d0, -0.644068138600693d0, -0.292988096856233d0,&
        1.19915225099327d0, 0.34450205612612d0, -1.10414267929223d0, -0.851428708305571d0,&
        0.516552258376321d0, 1.61890014353736d0, -0.132572793629228d0, -0.461372678278513d0,&
        0.924033738805388d0, 0.182145235070168d0, -1.45912302502159d0, -1.26177086163599d0,&
        0.262457496397155d0, 1.05163128165734d0, -0.375846185216561d0, -0.0538793990464063d0,&
        2.02401362371916d0, 0.608329815634632d0, -0.743744189746654d0, -0.970030579177241d0,&
        0.428937443704609d0, 1.37876004322192d0, -0.212097141151849d0, -0.550420122521827d0,&
        0.809950283969892d0, 0.102992718520838d0, -1.7390199717299d0, -1.58361547580179d0,&
        0.142457369611016d0, 0.865583239756308d0, -0.505395256291619d0, -0.172198788871808d0,&
        1.48812189602338d0, 0.472291481268261d0, -0.909130489944847d0, -0.693045098387663d0,&
        0.656163781150379d0, 2.52050221719036d0, -0.0146878031333598d0, -0.33413028225882d0,&
        1.12233801170217d0, 0.303224538198166d0, -1.17929369001065d0, -1.35385936407511d0,&
        0.222122208220557d0, 0.985825500405061d0, -0.418226872548409d0, -0.0931539598455833d0,&
        1.78526249043532d0, 0.561849225726257d0, -0.796431543684233d0, -1.03475948108824d0,&
        0.3863752869032d0, 1.28378055260817d0, -0.25233614780249d0, -0.596589849251445d0,&
        0.756718131051078d0, 0.0636878869241329d0, -1.95332370774539d0, -2.10655408816281d0,&
        0.0440760921002205d0, 0.730894247427629d0, -0.620154232595207d0, -0.2726058039057d0,&
        1.24035599423067d0, 0.365358587538023d0, -1.0688078752592d0, -0.823618695051533d0,&
        0.539062470681719d0, 1.69622250500661d0, -0.112841457367714d0, -0.43969744961512d0,&
        0.954474027767443d0, 0.202093345575596d0, -1.40454624815887d0, -1.21949532284622d0,&
        0.282782265212403d0, 1.0863057362981d0, -0.354911023290717d0, -0.0342770193514366d0,&
        2.20657521653713d0, 0.632066001577947d0, -0.718163873887231d0, -0.939145102896062d0,&
        0.450508606282178d0, 1.43130175910248d0, -0.19210973438208d0, -0.52777393514818d0,&
        0.837442740149245d0, 0.122701154016606d0, -1.65632386534081d0, -1.83567153691254d0,&
        0.0833242105440363d0, 0.783056813674774d0, -0.573352197171953d0, -0.232169649403845d0,&
        1.32977095018121d0, 0.40756406632868d0, -1.00187027637698d0, -0.769820715012041d0,&
        0.584931540146927d0, 1.89122923782011d0, -0.0735025059641587d0, -0.396947399151455d0,&
        1.01817720560067d0, 0.242240583770448d0, -1.30643035112756d0, -1.51842914115259d0,&
        0.16226934990287d0, 0.894426479612224d0, -0.483266884672673d0, -0.152355884338473d0/


        data QMC500_2 /0.0d0, -0.674489750196082d0, 0.674489750196082d0, -0.318639363964375d0,&
        1.15034938037601d0, -1.15034938037601d0, 0.318639363964375d0, -0.488776411114669d0,&
        0.887146559018876d0, -1.53412054435255d0, 0.157310684610171d0, -0.887146559018876d0,&
        0.488776411114669d0, -0.157310684610171d0, 1.53412054435255d0, -0.0784124127331122d0,&
        1.86273186742165d0, -0.776421761147928d0, 0.579132162255556d0, -1.31801089730354d0,&
        0.237202109328788d0, -0.402250065321725d0, 1.00999016924958d0, -1.00999016924958d0,&
        0.402250065321725d0, -0.237202109328788d0, 1.31801089730354d0, -0.579132162255556d0,&
        0.776421761147928d0, -1.86273186742165d0, 0.0784124127331122d0, -0.626099012346421d0,&
        0.724514383492365d0, -2.15387469406146d0, 0.0391760855030976d0, -1.07751556704028d0,&
        0.360129891789569d0, -0.277690439821577d0, 1.22985875921659d0, -1.41779713799627d0,&
        0.197099084294312d0, -0.445096524985516d0, 0.946781756301046d0, -0.117769874579095d0,&
        1.67593972277344d0, -0.830510878205399d0, 0.53340970624128d0, -0.724514383492365d0,&
        0.626099012346421d0, -0.0391760855030976d0, 2.15387469406146d0, -0.360129891789569d0,&
        1.07751556704028d0, -1.22985875921659d0, 0.277690439821577d0, -0.197099084294312d0,&
        1.41779713799627d0, -0.946781756301046d0, 0.445096524985516d0, -1.67593972277344d0,&
        0.117769874579095d0, -0.53340970624128d0, 0.830510878205399d0, -0.257393526100938d0,&
        1.27269864119054d0, -1.04315826331845d0, 0.381105454763556d0, -1.9874278859299d0,&
        0.0587829360689431d0, -0.602449453164424d0, 0.75021537546794d0, -0.803172565597918d0,&
        0.556125593618691d0, -0.0980721524886611d0, 1.76167041036307d0, -0.4235760842012d0,&
        0.977897543940542d0, -1.3662038163721d0, 0.21710694721013d0, -1.18916435019934d0,&
        0.298102412930487d0, -0.339311606538817d0, 1.11319427716093d0, -0.0195842852301269d0,&
        2.4175590162365d0, -0.69928330238322d0, 0.650104070647995d0, -0.510965806738247d0,&
        0.858484474141832d0, -1.60100866488608d0, 0.137513402144336d0, -0.916556667533112d0,&
        0.46682512285259d0, -0.17716982099174d0, 1.4734675779471d0, -1.11319427716093d0,&
        0.339311606538817d0, -0.298102412930487d0, 1.18916435019934d0, -0.650104070647995d0,&
        0.69928330238322d0, -2.4175590162365d0, 0.0195842852301269d0, -0.137513402144336d0,&
        1.60100866488608d0, -0.858484474141832d0, 0.510965806738247d0, -1.4734675779471d0,&
        0.17716982099174d0, -0.46682512285259d0, 0.916556667533112d0, -0.381105454763556d0,&
        1.04315826331845d0, -1.27269864119054d0, 0.257393526100938d0, -0.75021537546794d0,&
        0.602449453164424d0, -0.0587829360689431d0, 1.9874278859299d0, -1.76167041036307d0,&
        0.0980721524886611d0, -0.556125593618691d0, 0.803172565597918d0, -0.21710694721013d0,&
        1.3662038163721d0, -0.977897543940542d0, 0.4235760842012d0, -0.43431116117521d0,&
        0.962223195295421d0, -1.3915374879959d0, 0.20709265272436d0, -0.816765415315091d0,&
        0.544732512988176d0, -0.107915779489187d0, 1.71722811750574d0, -2.06352789831624d0,&
        0.0489771572021319d0, -0.614231289060245d0, 0.737304000438654d0, -0.267528206101097d0,&
        1.25099171546255d0, -1.06018047943536d0, 0.370597291109629d0, -0.931562830007115d0,&
        0.455933915613139d0, -0.187125162225721d0, 1.44507257981807d0, -0.522154877598001d0,&
        0.844415077375257d0, -1.63732538276806d0, 0.12763541906627d0, -0.029378775744157d0,&
        2.26622680920965d0, -0.711842195939419d0, 0.638055580922517d0, -1.20926123170915d0,&
        0.287881432831012d0, -0.349701803553895d0, 1.09518065276139d0, -1.50310294312927d0,&
        0.16723200837085d0, -0.477771988903886d0, 0.9017541138301d0, -0.147404821612355d0,&
        1.56668858606841d0, -0.87272589462704d0, 0.499840344883735d0, -0.662247682488414d0,&
        0.686833748574731d0, -2.66006746861746d0, 0.00979167316134535d0, -1.13157655838619d0,&
        0.328957912640491d0, -0.308354631344837d0, 1.16953661020714d0, -0.227143062502715d0,&
        1.34171784108025d0, -0.993815907860883d0, 0.412889601443654d0, -1.80989223848061d0,&
        0.0882380194499245d0, -0.567591323544569d0, 0.789726519943266d0, -0.76325304373257d0,&
        0.590750658062819d0, -0.0685943705051181d0, 1.9213507742937d0, -0.391655871092591d0,&
        1.02643306313791d0, -1.29502240670581d0, 0.247285215340805d0, -0.844415077375257d0,&
        0.522154877598001d0, -0.12763541906627d0, 1.63732538276806d0, -0.455933915613139d0,&
        0.931562830007115d0, -1.44507257981807d0, 0.187125162225721d0, -0.287881432831012d0,&
        1.20926123170915d0, -1.09518065276139d0, 0.349701803553895d0, -2.26622680920965d0,&
        0.029378775744157d0, -0.638055580922517d0, 0.711842195939419d0, -0.544732512988176d0,&
        0.816765415315091d0, -1.71722811750574d0, 0.107915779489187d0, -0.962223195295421d0,&
        0.43431116117521d0, -0.20709265272436d0, 1.3915374879959d0, -1.25099171546255d0,&
        0.267528206101097d0, -0.370597291109629d0, 1.06018047943536d0, -0.0489771572021319d0,&
        2.06352789831624d0, -0.737304000438654d0, 0.614231289060245d0, -0.0882380194499245d0,&
        1.80989223848061d0, -0.789726519943266d0, 0.567591323544569d0, -1.34171784108025d0,&
        0.227143062502715d0, -0.412889601443654d0, 0.993815907860883d0, -1.02643306313791d0,&
        0.391655871092591d0, -0.247285215340805d0, 1.29502240670581d0, -0.590750658062819d0,&
        0.76325304373257d0, -1.9213507742937d0, 0.0685943705051181d0, -1.56668858606841d0,&
        0.147404821612355d0, -0.499840344883735d0, 0.87272589462704d0, -0.16723200837085d0,&
        1.50310294312927d0, -0.9017541138301d0, 0.477771988903886d0, -0.328957912640491d0,&
        1.13157655838619d0, -1.16953661020714d0, 0.308354631344837d0, -0.686833748574731d0,&
        0.662247682488414d0, -0.00979167316134535d0, 2.66006746861746d0, -0.00489577790634245d0,&
        2.88563491242676d0, -0.680648785127646d0, 0.668356195590579d0, -1.15988961852528d0,&
        0.313492852637276d0, -0.323794328878954d0, 1.14091270934231d0, -0.894426479612224d0,&
        0.483266884672673d0, -0.16226934990287d0, 1.51842914115259d0, -0.494300814491471d0,&
        0.879913353819681d0, -1.55019904079176d0, 0.152355884338473d0, -1.89122923782011d0,&
        0.0735025059641587d0, -0.584931540146927d0, 0.769820715012041d0, -0.242240583770448d0,&
        1.30643035112756d0, -1.01817720560067d0, 0.396947399151455d0, -0.40756406632868d0,&
        1.00187027637698d0, -1.32977095018121d0, 0.232169649403845d0, -0.783056813674774d0,&
        0.573352197171953d0, -0.0833242105440363d0, 1.83567153691254d0, -0.730894247427629d0,&
        0.620154232595207d0, -0.0440760921002205d0, 2.10655408816281d0, -0.365358587538023d0,&
        1.0688078752592d0, -1.24035599423067d0, 0.2726058039057d0, -0.202093345575596d0,&
        1.40454624815887d0, -0.954474027767443d0, 0.43969744961512d0, -1.69622250500661d0,&
        0.112841457367714d0, -0.539062470681719d0, 0.823618695051533d0, -0.632066001577947d0,&
        0.718163873887231d0, -2.20657521653713d0, 0.0342770193514366d0, -1.0863057362981d0,&
        0.354911023290717d0, -0.282782265212403d0, 1.21949532284622d0, -1.43130175910248d0,&
        0.19210973438208d0, -0.450508606282178d0, 0.939145102896062d0, -0.122701154016606d0,&
        1.65632386534081d0, -0.837442740149245d0, 0.52777393514818d0, -1.28378055260817d0,&
        0.25233614780249d0, -0.3863752869032d0, 1.03475948108824d0, -0.0636878869241329d0,&
        1.95332370774539d0, -0.756718131051078d0, 0.596589849251445d0, -0.561849225726257d0,&
        0.796431543684233d0, -1.78526249043532d0, 0.0931539598455833d0, -0.985825500405061d0,&
        0.418226872548409d0, -0.222122208220557d0, 1.35385936407511d0, -0.303224538198166d0,&
        1.17929369001065d0, -1.12233801170217d0, 0.33413028225882d0, -2.52050221719036d0,&
        0.0146878031333598d0, -0.656163781150379d0, 0.693045098387663d0, -0.865583239756308d0,&
        0.505395256291619d0, -0.142457369611016d0, 1.58361547580179d0, -0.472291481268261d0,&
        0.909130489944847d0, -1.48812189602338d0, 0.172198788871808d0, -0.34450205612612d0,&
        1.10414267929223d0, -1.19915225099327d0, 0.292988096856233d0, -0.705548838662176d0,&
        0.644068138600693d0, -0.0244812369184941d0, 2.33523304006881d0, -1.61890014353736d0,&
        0.132572793629228d0, -0.516552258376321d0, 0.851428708305571d0, -0.182145235070168d0,&
        1.45912302502159d0, -0.924033738805388d0, 0.461372678278513d0, -1.05163128165734d0,&
        0.375846185216561d0, -0.262457496397155d0, 1.26177086163599d0, -0.608329815634632d0,&
        0.743744189746654d0, -2.02401362371916d0, 0.0538793990464063d0, -0.102992718520838d0,&
        1.7390199717299d0, -0.809950283969892d0, 0.550420122521827d0, -1.37876004322192d0,&
        0.212097141151849d0, -0.428937443704609d0, 0.970030579177241d0, -0.970030579177241d0,&
        0.428937443704609d0, -0.212097141151849d0, 1.37876004322192d0, -0.550420122521827d0,&
        0.809950283969892d0, -1.7390199717299d0, 0.102992718520838d0, -0.0538793990464063d0,&
        2.02401362371916d0, -0.743744189746654d0, 0.608329815634632d0, -1.26177086163599d0,&
        0.262457496397155d0, -0.375846185216561d0, 1.05163128165734d0, -0.461372678278513d0,&
        0.924033738805388d0, -1.45912302502159d0, 0.182145235070168d0, -0.851428708305571d0,&
        0.516552258376321d0, -0.132572793629228d0, 1.61890014353736d0, -2.33523304006881d0,&
        0.0244812369184941d0, -0.644068138600693d0, 0.705548838662176d0, -0.292988096856233d0,&
        1.19915225099327d0, -1.10414267929223d0, 0.34450205612612d0, -0.172198788871808d0,&
        1.48812189602338d0, -0.909130489944847d0, 0.472291481268261d0, -1.58361547580179d0,&
        0.142457369611016d0, -0.505395256291619d0, 0.865583239756308d0, -0.693045098387663d0,&
        0.656163781150379d0, -0.0146878031333598d0, 2.52050221719036d0, -0.33413028225882d0,&
        1.12233801170217d0, -1.17929369001065d0, 0.303224538198166d0, -1.35385936407511d0,&
        0.222122208220557d0, -0.418226872548409d0, 0.985825500405061d0, -0.0931539598455833d0,&
        1.78526249043532d0, -0.796431543684233d0, 0.561849225726257d0, -0.596589849251445d0,&
        0.756718131051078d0, -1.95332370774539d0, 0.0636878869241329d0, -1.03475948108824d0,&
        0.3863752869032d0, -0.25233614780249d0, 1.28378055260817d0, -0.52777393514818d0,&
        0.837442740149245d0, -1.65632386534081d0, 0.122701154016606d0, -0.939145102896062d0,&
        0.450508606282178d0, -0.19210973438208d0, 1.43130175910248d0, -1.21949532284622d0,&
        0.282782265212403d0, -0.354911023290717d0, 1.0863057362981d0, -0.0342770193514366d0,&
        2.20657521653713d0, -0.718163873887231d0, 0.632066001577947d0, -0.823618695051533d0,&
        0.539062470681719d0, -0.112841457367714d0, 1.69622250500661d0, -0.43969744961512d0,&
        0.954474027767443d0, -1.40454624815887d0, 0.202093345575596d0, -0.2726058039057d0,&
        1.24035599423067d0, -1.0688078752592d0, 0.365358587538023d0, -2.10655408816281d0,&
        0.0440760921002205d0, -0.620154232595207d0, 0.730894247427629d0, -1.83567153691254d0,&
        0.0833242105440363d0, -0.573352197171953d0, 0.783056813674774d0, -0.232169649403845d0,&
        1.32977095018121d0, -1.00187027637698d0, 0.40756406632868d0, -0.396947399151455d0,&
        1.01817720560067d0, -1.30643035112756d0, 0.242240583770448d0, -0.769820715012041d0,&
        0.584931540146927d0, -0.0735025059641587d0, 1.89122923782011d0, -0.152355884338473d0,&
        1.55019904079176d0, -0.879913353819681d0, 0.494300814491471d0, -1.51842914115259d0/
        

        data QMC1000_1 /0.0d0, 0.674489750196082d0, -0.674489750196082d0, -0.318639363964375d0,&
        1.15034938037601d0, 0.318639363964375d0, -1.15034938037601d0, -0.887146559018876d0,&
        0.488776411114669d0, 1.53412054435255d0, -0.157310684610171d0, -0.488776411114669d0,&
        0.887146559018876d0, 0.157310684610171d0, -1.53412054435255d0, -1.31801089730354d0,&
        0.237202109328788d0, 1.00999016924958d0, -0.402250065321725d0, -0.0784124127331122d0,&
        1.86273186742165d0, 0.579132162255556d0, -0.776421761147928d0, -1.00999016924958d0,&
        0.402250065321725d0, 1.31801089730354d0, -0.237202109328788d0, -0.579132162255556d0,&
        0.776421761147928d0, 0.0784124127331122d0, -1.86273186742165d0, -1.67593972277344d0,&
        0.117769874579095d0, 0.830510878205399d0, -0.53340970624128d0, -0.197099084294312d0,&
        1.41779713799627d0, 0.445096524985516d0, -0.946781756301046d0, -0.724514383492365d0,&
        0.626099012346421d0, 2.15387469406146d0, -0.0391760855030976d0, -0.360129891789569d0,&
        1.07751556704028d0, 0.277690439821577d0, -1.22985875921659d0, -1.41779713799627d0,&
        0.197099084294312d0, 0.946781756301046d0, -0.445096524985516d0, -0.117769874579095d0,&
        1.67593972277344d0, 0.53340970624128d0, -0.830510878205399d0, -1.07751556704028d0,&
        0.360129891789569d0, 1.22985875921659d0, -0.277690439821577d0, -0.626099012346421d0,&
        0.724514383492365d0, 0.0391760855030976d0, -2.15387469406146d0, -1.9874278859299d0,&
        0.0587829360689431d0, 0.75021537546794d0, -0.602449453164424d0, -0.257393526100938d0,&
        1.27269864119054d0, 0.381105454763556d0, -1.04315826331845d0, -0.803172565597918d0,&
        0.556125593618691d0, 1.76167041036307d0, -0.0980721524886611d0, -0.4235760842012d0,&
        0.977897543940542d0, 0.21710694721013d0, -1.3662038163721d0, -1.18916435019934d0,&
        0.298102412930487d0, 1.11319427716093d0, -0.339311606538817d0, -0.0195842852301269d0,&
        2.4175590162365d0, 0.650104070647995d0, -0.69928330238322d0, -0.916556667533112d0,&
        0.46682512285259d0, 1.4734675779471d0, -0.17716982099174d0, -0.510965806738247d0,&
        0.858484474141832d0, 0.137513402144336d0, -1.60100866488608d0, -1.76167041036307d0,&
        0.0980721524886611d0, 0.803172565597918d0, -0.556125593618691d0, -0.21710694721013d0,&
        1.3662038163721d0, 0.4235760842012d0, -0.977897543940542d0, -0.75021537546794d0,&
        0.602449453164424d0, 1.9874278859299d0, -0.0587829360689431d0, -0.381105454763556d0,&
        1.04315826331845d0, 0.257393526100938d0, -1.27269864119054d0, -1.4734675779471d0,&
        0.17716982099174d0, 0.916556667533112d0, -0.46682512285259d0, -0.137513402144336d0,&
        1.60100866488608d0, 0.510965806738247d0, -0.858484474141832d0, -1.11319427716093d0,&
        0.339311606538817d0, 1.18916435019934d0, -0.298102412930487d0, -0.650104070647995d0,&
        0.69928330238322d0, 0.0195842852301269d0, -2.4175590162365d0, -2.26622680920965d0,&
        0.029378775744157d0, 0.711842195939419d0, -0.638055580922517d0, -0.287881432831012d0,&
        1.20926123170915d0, 0.349701803553895d0, -1.09518065276139d0, -0.844415077375257d0,&
        0.522154877598001d0, 1.63732538276806d0, -0.12763541906627d0, -0.455933915613139d0,&
        0.931562830007115d0, 0.187125162225721d0, -1.44507257981807d0, -1.25099171546255d0,&
        0.267528206101097d0, 1.06018047943536d0, -0.370597291109629d0, -0.0489771572021319d0,&
        2.06352789831624d0, 0.614231289060245d0, -0.737304000438654d0, -0.962223195295421d0,&
        0.43431116117521d0, 1.3915374879959d0, -0.20709265272436d0, -0.544732512988176d0,&
        0.816765415315091d0, 0.107915779489187d0, -1.71722811750574d0, -1.56668858606841d0,&
        0.147404821612355d0, 0.87272589462704d0, -0.499840344883735d0, -0.16723200837085d0,&
        1.50310294312927d0, 0.477771988903886d0, -0.9017541138301d0, -0.686833748574731d0,&
        0.662247682488414d0, 2.66006746861746d0, -0.00979167316134535d0, -0.328957912640491d0,&
        1.13157655838619d0, 0.308354631344837d0, -1.16953661020714d0, -1.34171784108025d0,&
        0.227143062502715d0, 0.993815907860883d0, -0.412889601443654d0, -0.0882380194499245d0,&
        1.80989223848061d0, 0.567591323544569d0, -0.789726519943266d0, -1.02643306313791d0,&
        0.391655871092591d0, 1.29502240670581d0, -0.247285215340805d0, -0.590750658062819d0,&
        0.76325304373257d0, 0.0685943705051181d0, -1.9213507742937d0, -2.06352789831624d0,&
        0.0489771572021319d0, 0.737304000438654d0, -0.614231289060245d0, -0.267528206101097d0,&
        1.25099171546255d0, 0.370597291109629d0, -1.06018047943536d0, -0.816765415315091d0,&
        0.544732512988176d0, 1.71722811750574d0, -0.107915779489187d0, -0.43431116117521d0,&
        0.962223195295421d0, 0.20709265272436d0, -1.3915374879959d0, -1.20926123170915d0,&
        0.287881432831012d0, 1.09518065276139d0, -0.349701803553895d0, -0.029378775744157d0,&
        2.26622680920965d0, 0.638055580922517d0, -0.711842195939419d0, -0.931562830007115d0,&
        0.455933915613139d0, 1.44507257981807d0, -0.187125162225721d0, -0.522154877598001d0,&
        0.844415077375257d0, 0.12763541906627d0, -1.63732538276806d0, -1.80989223848061d0,&
        0.0882380194499245d0, 0.789726519943266d0, -0.567591323544569d0, -0.227143062502715d0,&
        1.34171784108025d0, 0.412889601443654d0, -0.993815907860883d0, -0.76325304373257d0,&
        0.590750658062819d0, 1.9213507742937d0, -0.0685943705051181d0, -0.391655871092591d0,&
        1.02643306313791d0, 0.247285215340805d0, -1.29502240670581d0, -1.50310294312927d0,&
        0.16723200837085d0, 0.9017541138301d0, -0.477771988903886d0, -0.147404821612355d0,&
        1.56668858606841d0, 0.499840344883735d0, -0.87272589462704d0, -1.13157655838619d0,&
        0.328957912640491d0, 1.16953661020714d0, -0.308354631344837d0, -0.662247682488414d0,&
        0.686833748574731d0, 0.00979167316134535d0, -2.66006746861746d0, -2.52050221719036d0,&
        0.0146878031333598d0, 0.693045098387663d0, -0.656163781150379d0, -0.303224538198166d0,&
        1.17929369001065d0, 0.33413028225882d0, -1.12233801170217d0, -0.865583239756308d0,&
        0.505395256291619d0, 1.58361547580179d0, -0.142457369611016d0, -0.472291481268261d0,&
        0.909130489944847d0, 0.172198788871808d0, -1.48812189602338d0, -1.28378055260817d0,&
        0.25233614780249d0, 1.03475948108824d0, -0.3863752869032d0, -0.0636878869241329d0,&
        1.95332370774539d0, 0.596589849251445d0, -0.756718131051078d0, -0.985825500405061d0,&
        0.418226872548409d0, 1.35385936407511d0, -0.222122208220557d0, -0.561849225726257d0,&
        0.796431543684233d0, 0.0931539598455833d0, -1.78526249043532d0, -1.61890014353736d0,&
        0.132572793629228d0, 0.851428708305571d0, -0.516552258376321d0, -0.182145235070168d0,&
        1.45912302502159d0, 0.461372678278513d0, -0.924033738805388d0, -0.705548838662176d0,&
        0.644068138600693d0, 2.33523304006881d0, -0.0244812369184941d0, -0.34450205612612d0,&
        1.10414267929223d0, 0.292988096856233d0, -1.19915225099327d0, -1.37876004322192d0,&
        0.212097141151849d0, 0.970030579177241d0, -0.428937443704609d0, -0.102992718520838d0,&
        1.7390199717299d0, 0.550420122521827d0, -0.809950283969892d0, -1.05163128165734d0,&
        0.375846185216561d0, 1.26177086163599d0, -0.262457496397155d0, -0.608329815634632d0,&
        0.743744189746654d0, 0.0538793990464063d0, -2.02401362371916d0, -1.89122923782011d0,&
        0.0735025059641587d0, 0.769820715012041d0, -0.584931540146927d0, -0.242240583770448d0,&
        1.30643035112756d0, 0.396947399151455d0, -1.01817720560067d0, -0.783056813674774d0,&
        0.573352197171953d0, 1.83567153691254d0, -0.0833242105440363d0, -0.40756406632868d0,&
        1.00187027637698d0, 0.232169649403845d0, -1.32977095018121d0, -1.15988961852528d0,&
        0.313492852637276d0, 1.14091270934231d0, -0.323794328878954d0, -0.00489577790634245d0,&
        2.88563491242676d0, 0.668356195590579d0, -0.680648785127646d0, -0.894426479612224d0,&
        0.483266884672673d0, 1.51842914115259d0, -0.16226934990287d0, -0.494300814491471d0,&
        0.879913353819681d0, 0.152355884338473d0, -1.55019904079176d0, -1.69622250500661d0,&
        0.112841457367714d0, 0.823618695051533d0, -0.539062470681719d0, -0.202093345575596d0,&
        1.40454624815887d0, 0.43969744961512d0, -0.954474027767443d0, -0.730894247427629d0,&
        0.620154232595207d0, 2.10655408816281d0, -0.0440760921002205d0, -0.365358587538023d0,&
        1.0688078752592d0, 0.2726058039057d0, -1.24035599423067d0, -1.43130175910248d0,&
        0.19210973438208d0, 0.939145102896062d0, -0.450508606282178d0, -0.122701154016606d0,&
        1.65632386534081d0, 0.52777393514818d0, -0.837442740149245d0, -1.0863057362981d0,&
        0.354911023290717d0, 1.21949532284622d0, -0.282782265212403d0, -0.632066001577947d0,&
        0.718163873887231d0, 0.0342770193514366d0, -2.20657521653713d0, -2.33523304006881d0,&
        0.0244812369184941d0, 0.705548838662176d0, -0.644068138600693d0, -0.292988096856233d0,&
        1.19915225099327d0, 0.34450205612612d0, -1.10414267929223d0, -0.851428708305571d0,&
        0.516552258376321d0, 1.61890014353736d0, -0.132572793629228d0, -0.461372678278513d0,&
        0.924033738805388d0, 0.182145235070168d0, -1.45912302502159d0, -1.26177086163599d0,&
        0.262457496397155d0, 1.05163128165734d0, -0.375846185216561d0, -0.0538793990464063d0,&
        2.02401362371916d0, 0.608329815634632d0, -0.743744189746654d0, -0.970030579177241d0,&
        0.428937443704609d0, 1.37876004322192d0, -0.212097141151849d0, -0.550420122521827d0,&
        0.809950283969892d0, 0.102992718520838d0, -1.7390199717299d0, -1.58361547580179d0,&
        0.142457369611016d0, 0.865583239756308d0, -0.505395256291619d0, -0.172198788871808d0,&
        1.48812189602338d0, 0.472291481268261d0, -0.909130489944847d0, -0.693045098387663d0,&
        0.656163781150379d0, 2.52050221719036d0, -0.0146878031333598d0, -0.33413028225882d0,&
        1.12233801170217d0, 0.303224538198166d0, -1.17929369001065d0, -1.35385936407511d0,&
        0.222122208220557d0, 0.985825500405061d0, -0.418226872548409d0, -0.0931539598455833d0,&
        1.78526249043532d0, 0.561849225726257d0, -0.796431543684233d0, -1.03475948108824d0,&
        0.3863752869032d0, 1.28378055260817d0, -0.25233614780249d0, -0.596589849251445d0,&
        0.756718131051078d0, 0.0636878869241329d0, -1.95332370774539d0, -2.10655408816281d0,&
        0.0440760921002205d0, 0.730894247427629d0, -0.620154232595207d0, -0.2726058039057d0,&
        1.24035599423067d0, 0.365358587538023d0, -1.0688078752592d0, -0.823618695051533d0,&
        0.539062470681719d0, 1.69622250500661d0, -0.112841457367714d0, -0.43969744961512d0,&
        0.954474027767443d0, 0.202093345575596d0, -1.40454624815887d0, -1.21949532284622d0,&
        0.282782265212403d0, 1.0863057362981d0, -0.354911023290717d0, -0.0342770193514366d0,&
        2.20657521653713d0, 0.632066001577947d0, -0.718163873887231d0, -0.939145102896062d0,&
        0.450508606282178d0, 1.43130175910248d0, -0.19210973438208d0, -0.52777393514818d0,&
        0.837442740149245d0, 0.122701154016606d0, -1.65632386534081d0, -1.83567153691254d0,&
        0.0833242105440363d0, 0.783056813674774d0, -0.573352197171953d0, -0.232169649403845d0,&
        1.32977095018121d0, 0.40756406632868d0, -1.00187027637698d0, -0.769820715012041d0,&
        0.584931540146927d0, 1.89122923782011d0, -0.0735025059641587d0, -0.396947399151455d0,&
        1.01817720560067d0, 0.242240583770448d0, -1.30643035112756d0, -1.51842914115259d0,&
        0.16226934990287d0, 0.894426479612224d0, -0.483266884672673d0, -0.152355884338473d0,&
        1.55019904079176d0, 0.494300814491471d0, -0.879913353819681d0, -1.14091270934231d0,&
        0.323794328878954d0, 1.15988961852528d0, -0.313492852637276d0, -0.668356195590579d0,&
        0.680648785127646d0, 0.00489577790634245d0, -2.88563491242676d0, -2.75554887345342d0,&
        0.00734370353043169d0, 0.683737997401054d0, -0.665298835919928d0, -0.310922715893284d0,&
        1.16469956534333d0, 0.326375033007281d0, -1.13623225407686d0, -0.876313965464153d0,&
        0.497068673028721d0, 1.55839084718429d0, -0.149879893723577d0, -0.480517623198981d0,&
        0.898084268969658d0, 0.16475017195312d0, -1.5107216853605d0, -1.3007052195221d0,&
        0.244762120956717d0, 1.02229642449682d0, -0.394300255055697d0, -0.0710482242921843d0,&
        1.90607384923176d0, 0.587838610917144d0, -0.76653274638327d0, -0.997835000557589d0,&
        0.410225379567002d0, 1.33572056504665d0, -0.229655630625748d0, -0.570469393786029d0,&
        0.786387293998826d0, 0.0857808560936914d0, -1.82263048663553d0, -1.64675032766897d0,&
        0.125167905608435d0, 0.840923798724339d0, -0.524962334487275d0, -0.189616859401405d0,&
        1.43815307900302d0, 0.453219593437879d0, -0.935347244701583d0, -0.714999463162297d0,&
        0.635057943402778d0, 2.23540724355632d0, -0.0318278020929306d0, -0.352305218402456d0,&
        1.09073245569302d0, 0.285330921640916d0, -1.21436237874935d0, -1.39801229534686d0,&
        0.204592359975061d0, 0.958341418018926d0, -0.437002720596656d0, -0.110378283674032d0,&
        1.70663118536312d0, 0.541895314131648d0, -0.820187239913321d0, -1.06448427337982d0,&
        0.367976676977171d0, 1.24565624149491d0, -0.270066134646447d0, -0.617190054347694d0,&
        0.734095353894574d0, 0.0465264849526418d0, -2.08455871840791d0, -1.9370897365465d0,&
        0.0661409296831973d0, 0.759981530500801d0, -0.593667723429761d0, -0.249809884929244d0,&
        1.2893811107918d0, 0.389014223059009d0, -1.03058734087267d0, -0.793074574990729d0,&
        0.564717947168687d0, 1.79744107394942d0, -0.0906957156729311d0, -0.415556757275935d0,&
        0.989812804597863d0, 0.224631927517902d0, -1.3477637672852d0, -1.17440117463922d0,&
        0.305788578807489d0, 1.12694526183216d0, -0.331542988709853d0, -0.0122397014708965d0,&
        2.58401958059948d0, 0.659202681860284d0, -0.689936096184168d0, -0.905436143675761d0,&
        0.475029951585417d0, 1.49557046317418d0, -0.169714875285445d0, -0.502615861929802d0,&
        0.869149024454586d0, 0.144930652172474d0, -1.57509561962568d0, -1.72802147121901d0,&
        0.105453929524875d0, 0.813353127508359d0, -0.547574103573779d0, -0.209594240778642d0,&
        1.38512049830698d0, 0.431622744449859d0, -0.966119525969419d0, -0.740520255855527d0,&
        0.611277891191507d0, 2.04337202094265d0, -0.0514281236341141d0, -0.373220452841663d0,&
        1.05589623376374d0, 0.264991999560325d0, -1.2563630414547d0, -1.45206197024557d0,&
        0.184634626287249d0, 0.927791710155385d0, -0.458651601070847d0, -0.130103709894028d0,&
        1.62804367632253d0, 0.519351530221023d0, -0.847916679096402d0, -1.09965062580976d0,&
        0.347100756751592d0, 1.20419135908412d0, -0.290433818099894d0, -0.641058962903565d0,&
        0.708692008707423d0, 0.0269299255889371d0, -2.29936229740323d0, -2.17946859778912d0,&
        0.0367264422438769d0, 0.72133549234393d0, -0.629079707162832d0, -0.280235444318555d0,&
        1.22466059983832d0, 0.357519240337698d0, -1.08190020225002d0, -0.833971800052114d0,&
        0.530589714123105d0, 1.66605166238845d0, -0.120235148819768d0, -0.44780092608518d0,&
        0.942956555614785d0, 0.194603803788316d0, -1.42451697418177d0, -1.23509036459975d0,&
        0.275147232671631d0, 1.07315154982209d0, -0.36274300002125d0, -0.0416259638712113d0,&
        2.12961846911981d0, 0.623123869784967d0, -0.727700613034726d0, -0.950620860870747d0,&
        0.442395375318794d0, 1.41114072110521d0, -0.19959559262874d0, -0.536233946622638d0,&
        0.827059875726257d0, 0.115305315887256d0, -1.68599441546561d0, -1.5421099601365d0,&
        0.154832809329535d0, 0.883524178244099d0, -0.49153673764685d0, -0.15978952613545d0,&
        1.52622786964839d0, 0.486019803756523d0, -0.890780618191639d0, -0.677566054832191d0,&
        0.671419815495155d0, 3.09726907819878d0, -0.00244788161911068d0, -0.321215779435019d0,&
        1.14561829257781d0, 0.316065061863936d0, -1.15510635777657d0, -1.32386803759834d0,&
        0.234685136420896d0, 1.00592193241354d0, -0.404905636576578d0, -0.0808680677627817d0,&
        1.84903246516889d0, 0.57623977333281d0, -0.779734996530243d0, -1.01407519104019d0,&
        0.399597327736265d0, 1.31219862702896d0, -0.239720585848375d0, -0.58202940428861d0,&
        0.773117027116272d0, 0.075957230458921d0, -1.8767900479811d0, -2.0053852719249d0,&
        0.0563309982498503d0, 0.746975872532823d0, -0.605387017711062d0, -0.259924678065871d0,&
        1.26721583563447d0, 0.378474511416355d0, -1.04738537323502d0, -0.806556793379432d0,&
        0.553270606780821d0, 1.75023295183998d0, -0.100532131244173d0, -0.426255232406073d0,&
        0.973956526882356d0, 0.21460137091761d0, -1.37245488241084d0, -1.19414340989772d0,&
        0.295544288601364d0, 1.10865712398397d0, -0.341905679930527d0, -0.0220326950308341d0,&
        2.37438680605393d0, 0.647083157764331d0, -0.702412623695317d0, -0.920288771883032d0,&
        0.464097175910881d0, 1.46625758841323d0, -0.17965697210979d0, -0.513757028359516d0,&
        0.854951270871459d0, 0.135042685843707d0, -1.60988998841876d0, -1.77334307781058d0,&
        0.09561276707409d0, 0.7997975116462d0, -0.558985120627175d0, -0.21961388722509d0,&
        1.36000568463741d0, 0.420899972915016d0, -0.981853808166937d0, -0.753462770653122d0,&
        0.599517078154522d0, 1.97008940475787d0, -0.0612352273424688d0, -0.383739038722914d0,&
        1.0389497113123d0, 0.254864022115934d0, -1.27821997483642d0, -1.4807549883929d0,&
        0.174683765351141d0, 0.912837286072549d0, -0.469556548200866d0, -0.139984958173739d0,&
        1.59225185952329d0, 0.508178560348605d0, -0.862028426972385d0, -1.11775446278603d0,&
        0.336719814444443d0, 1.18421459785573d0, -0.300662489533887d0, -0.653130928015844d0,&
        0.696160813976152d0, 0.0171359928260878d0, -2.4657708956965d0, -2.58401958059948d0,&
        0.0122397014708965d0, 0.689936096184168d0, -0.659202681860284d0, -0.305788578807489d0,&
        1.17440117463922d0, 0.331542988709853d0, -1.12694526183216d0, -0.869149024454586d0,&
        0.502615861929802d0, 1.57509561962568d0, -0.144930652172474d0, -0.475029951585417d0,&
        0.905436143675761d0, 0.169714875285445d0, -1.49557046317418d0, -1.2893811107918d0,&
        0.249809884929244d0, 1.03058734087267d0, -0.389014223059009d0, -0.0661409296831973d0,&
        1.9370897365465d0, 0.593667723429761d0, -0.759981530500801d0, -0.989812804597863d0,&
        0.415556757275935d0, 1.3477637672852d0, -0.224631927517902d0, -0.564717947168687d0,&
        0.793074574990729d0, 0.0906957156729311d0, -1.79744107394942d0, -1.62804367632253d0,&
        0.130103709894028d0, 0.847916679096402d0, -0.519351530221023d0, -0.184634626287249d0,&
        1.45206197024557d0, 0.458651601070847d0, -0.927791710155385d0, -0.708692008707423d0,&
        0.641058962903565d0, 2.29936229740323d0, -0.0269299255889371d0, -0.347100756751592d0,&
        1.09965062580976d0, 0.290433818099894d0, -1.20419135908412d0, -1.38512049830698d0,&
        0.209594240778642d0, 0.966119525969419d0, -0.431622744449859d0, -0.105453929524875d0,&
        1.72802147121901d0, 0.547574103573779d0, -0.813353127508359d0, -1.05589623376374d0,&
        0.373220452841663d0, 1.2563630414547d0, -0.264991999560325d0, -0.611277891191507d0,&
        0.740520255855527d0, 0.0514281236341141d0, -2.04337202094265d0, -1.90607384923176d0,&
        0.0710482242921843d0, 0.76653274638327d0, -0.587838610917144d0, -0.244762120956717d0,&
        1.3007052195221d0, 0.394300255055697d0, -1.02229642449682d0, -0.786387293998826d0,&
        0.570469393786029d0, 1.82263048663553d0, -0.0857808560936914d0, -0.410225379567002d0,&
        0.997835000557589d0, 0.229655630625748d0, -1.33572056504665d0, -1.16469956534333d0,&
        0.310922715893284d0, 1.13623225407686d0, -0.326375033007281d0, -0.00734370353043169d0,&
        2.75554887345342d0, 0.665298835919928d0, -0.683737997401054d0, -0.898084268969658d0,&
        0.480517623198981d0, 1.5107216853605d0, -0.16475017195312d0, -0.497068673028721d0,&
        0.876313965464153d0, 0.149879893723577d0, -1.55839084718429d0, -1.70663118536312d0,&
        0.110378283674032d0, 0.820187239913321d0, -0.541895314131648d0, -0.204592359975061d0,&
        1.39801229534686d0, 0.437002720596656d0, -0.958341418018926d0, -0.734095353894574d0,&
        0.617190054347694d0, 2.08455871840791d0, -0.0465264849526418d0, -0.367976676977171d0,&
        1.06448427337982d0, 0.270066134646447d0, -1.24565624149491d0, -1.43815307900302d0,&
        0.189616859401405d0, 0.935347244701583d0, -0.453219593437879d0, -0.125167905608435d0,&
        1.64675032766897d0, 0.524962334487275d0, -0.840923798724339d0, -1.09073245569302d0,&
        0.352305218402456d0, 1.21436237874935d0, -0.285330921640916d0, -0.635057943402778d0,&
        0.714999463162297d0, 0.0318278020929306d0, -2.23540724355632d0, -2.37438680605393d0,&
        0.0220326950308341d0, 0.702412623695317d0, -0.647083157764331d0, -0.295544288601364d0,&
        1.19414340989772d0, 0.341905679930527d0, -1.10865712398397d0, -0.854951270871459d0,&
        0.513757028359516d0, 1.60988998841876d0, -0.135042685843707d0, -0.464097175910881d0,&
        0.920288771883032d0, 0.17965697210979d0, -1.46625758841323d0, -1.26721583563447d0,&
        0.259924678065871d0, 1.04738537323502d0, -0.378474511416355d0, -0.0563309982498503d0,&
        2.0053852719249d0, 0.605387017711062d0, -0.746975872532823d0, -0.973956526882356d0,&
        0.426255232406073d0, 1.37245488241084d0, -0.21460137091761d0, -0.553270606780821d0,&
        0.806556793379432d0, 0.100532131244173d0, -1.75023295183998d0, -1.59225185952329d0,&
        0.139984958173739d0, 0.862028426972385d0, -0.508178560348605d0, -0.174683765351141d0,&
        1.4807549883929d0, 0.469556548200866d0, -0.912837286072549d0, -0.696160813976152d0,&
        0.653130928015844d0, 2.4657708956965d0, -0.0171359928260878d0, -0.336719814444443d0,&
        1.11775446278603d0, 0.300662489533887d0, -1.18421459785573d0, -1.36000568463741d0,&
        0.21961388722509d0, 0.981853808166937d0, -0.420899972915016d0, -0.09561276707409d0,&
        1.77334307781058d0, 0.558985120627175d0, -0.7997975116462d0, -1.0389497113123d0,&
        0.383739038722914d0, 1.27821997483642d0, -0.254864022115934d0, -0.599517078154522d0,&
        0.753462770653122d0, 0.0612352273424688d0, -1.97008940475787d0, -2.12961846911981d0,&
        0.0416259638712113d0, 0.727700613034726d0, -0.623123869784967d0, -0.275147232671631d0,&
        1.23509036459975d0, 0.36274300002125d0, -1.07315154982209d0, -0.827059875726257d0,&
        0.536233946622638d0, 1.68599441546561d0, -0.115305315887256d0, -0.442395375318794d0,&
        0.950620860870747d0, 0.19959559262874d0, -1.41114072110521d0, -1.22466059983832d0,&
        0.280235444318555d0, 1.08190020225002d0, -0.357519240337698d0, -0.0367264422438769d0,&
        2.17946859778912d0, 0.629079707162832d0, -0.72133549234393d0, -0.942956555614785d0,&
        0.44780092608518d0, 1.42451697418177d0, -0.194603803788316d0, -0.530589714123105d0,&
        0.833971800052114d0, 0.120235148819768d0, -1.66605166238845d0, -1.84903246516889d0,&
        0.0808680677627817d0, 0.779734996530243d0, -0.57623977333281d0, -0.234685136420896d0,&
        1.32386803759834d0, 0.404905636576578d0, -1.00592193241354d0, -0.773117027116272d0/

        data QMC1000_2 /0.0d0, -0.674489750196082d0, 0.674489750196082d0, -0.318639363964375d0,&
        1.15034938037601d0, -1.15034938037601d0, 0.318639363964375d0, -0.488776411114669d0,&
        0.887146559018876d0, -1.53412054435255d0, 0.157310684610171d0, -0.887146559018876d0,&
        0.488776411114669d0, -0.157310684610171d0, 1.53412054435255d0, -0.0784124127331122d0,&
        1.86273186742165d0, -0.776421761147928d0, 0.579132162255556d0, -1.31801089730354d0,&
        0.237202109328788d0, -0.402250065321725d0, 1.00999016924958d0, -1.00999016924958d0,&
        0.402250065321725d0, -0.237202109328788d0, 1.31801089730354d0, -0.579132162255556d0,&
        0.776421761147928d0, -1.86273186742165d0, 0.0784124127331122d0, -0.626099012346421d0,&
        0.724514383492365d0, -2.15387469406146d0, 0.0391760855030976d0, -1.07751556704028d0,&
        0.360129891789569d0, -0.277690439821577d0, 1.22985875921659d0, -1.41779713799627d0,&
        0.197099084294312d0, -0.445096524985516d0, 0.946781756301046d0, -0.117769874579095d0,&
        1.67593972277344d0, -0.830510878205399d0, 0.53340970624128d0, -0.724514383492365d0,&
        0.626099012346421d0, -0.0391760855030976d0, 2.15387469406146d0, -0.360129891789569d0,&
        1.07751556704028d0, -1.22985875921659d0, 0.277690439821577d0, -0.197099084294312d0,&
        1.41779713799627d0, -0.946781756301046d0, 0.445096524985516d0, -1.67593972277344d0,&
        0.117769874579095d0, -0.53340970624128d0, 0.830510878205399d0, -0.257393526100938d0,&
        1.27269864119054d0, -1.04315826331845d0, 0.381105454763556d0, -1.9874278859299d0,&
        0.0587829360689431d0, -0.602449453164424d0, 0.75021537546794d0, -0.803172565597918d0,&
        0.556125593618691d0, -0.0980721524886611d0, 1.76167041036307d0, -0.4235760842012d0,&
        0.977897543940542d0, -1.3662038163721d0, 0.21710694721013d0, -1.18916435019934d0,&
        0.298102412930487d0, -0.339311606538817d0, 1.11319427716093d0, -0.0195842852301269d0,&
        2.4175590162365d0, -0.69928330238322d0, 0.650104070647995d0, -0.510965806738247d0,&
        0.858484474141832d0, -1.60100866488608d0, 0.137513402144336d0, -0.916556667533112d0,&
        0.46682512285259d0, -0.17716982099174d0, 1.4734675779471d0, -1.11319427716093d0,&
        0.339311606538817d0, -0.298102412930487d0, 1.18916435019934d0, -0.650104070647995d0,&
        0.69928330238322d0, -2.4175590162365d0, 0.0195842852301269d0, -0.137513402144336d0,&
        1.60100866488608d0, -0.858484474141832d0, 0.510965806738247d0, -1.4734675779471d0,&
        0.17716982099174d0, -0.46682512285259d0, 0.916556667533112d0, -0.381105454763556d0,&
        1.04315826331845d0, -1.27269864119054d0, 0.257393526100938d0, -0.75021537546794d0,&
        0.602449453164424d0, -0.0587829360689431d0, 1.9874278859299d0, -1.76167041036307d0,&
        0.0980721524886611d0, -0.556125593618691d0, 0.803172565597918d0, -0.21710694721013d0,&
        1.3662038163721d0, -0.977897543940542d0, 0.4235760842012d0, -0.43431116117521d0,&
        0.962223195295421d0, -1.3915374879959d0, 0.20709265272436d0, -0.816765415315091d0,&
        0.544732512988176d0, -0.107915779489187d0, 1.71722811750574d0, -2.06352789831624d0,&
        0.0489771572021319d0, -0.614231289060245d0, 0.737304000438654d0, -0.267528206101097d0,&
        1.25099171546255d0, -1.06018047943536d0, 0.370597291109629d0, -0.931562830007115d0,&
        0.455933915613139d0, -0.187125162225721d0, 1.44507257981807d0, -0.522154877598001d0,&
        0.844415077375257d0, -1.63732538276806d0, 0.12763541906627d0, -0.029378775744157d0,&
        2.26622680920965d0, -0.711842195939419d0, 0.638055580922517d0, -1.20926123170915d0,&
        0.287881432831012d0, -0.349701803553895d0, 1.09518065276139d0, -1.50310294312927d0,&
        0.16723200837085d0, -0.477771988903886d0, 0.9017541138301d0, -0.147404821612355d0,&
        1.56668858606841d0, -0.87272589462704d0, 0.499840344883735d0, -0.662247682488414d0,&
        0.686833748574731d0, -2.66006746861746d0, 0.00979167316134535d0, -1.13157655838619d0,&
        0.328957912640491d0, -0.308354631344837d0, 1.16953661020714d0, -0.227143062502715d0,&
        1.34171784108025d0, -0.993815907860883d0, 0.412889601443654d0, -1.80989223848061d0,&
        0.0882380194499245d0, -0.567591323544569d0, 0.789726519943266d0, -0.76325304373257d0,&
        0.590750658062819d0, -0.0685943705051181d0, 1.9213507742937d0, -0.391655871092591d0,&
        1.02643306313791d0, -1.29502240670581d0, 0.247285215340805d0, -0.844415077375257d0,&
        0.522154877598001d0, -0.12763541906627d0, 1.63732538276806d0, -0.455933915613139d0,&
        0.931562830007115d0, -1.44507257981807d0, 0.187125162225721d0, -0.287881432831012d0,&
        1.20926123170915d0, -1.09518065276139d0, 0.349701803553895d0, -2.26622680920965d0,&
        0.029378775744157d0, -0.638055580922517d0, 0.711842195939419d0, -0.544732512988176d0,&
        0.816765415315091d0, -1.71722811750574d0, 0.107915779489187d0, -0.962223195295421d0,&
        0.43431116117521d0, -0.20709265272436d0, 1.3915374879959d0, -1.25099171546255d0,&
        0.267528206101097d0, -0.370597291109629d0, 1.06018047943536d0, -0.0489771572021319d0,&
        2.06352789831624d0, -0.737304000438654d0, 0.614231289060245d0, -0.0882380194499245d0,&
        1.80989223848061d0, -0.789726519943266d0, 0.567591323544569d0, -1.34171784108025d0,&
        0.227143062502715d0, -0.412889601443654d0, 0.993815907860883d0, -1.02643306313791d0,&
        0.391655871092591d0, -0.247285215340805d0, 1.29502240670581d0, -0.590750658062819d0,&
        0.76325304373257d0, -1.9213507742937d0, 0.0685943705051181d0, -1.56668858606841d0,&
        0.147404821612355d0, -0.499840344883735d0, 0.87272589462704d0, -0.16723200837085d0,&
        1.50310294312927d0, -0.9017541138301d0, 0.477771988903886d0, -0.328957912640491d0,&
        1.13157655838619d0, -1.16953661020714d0, 0.308354631344837d0, -0.686833748574731d0,&
        0.662247682488414d0, -0.00979167316134535d0, 2.66006746861746d0, -0.00489577790634245d0,&
        2.88563491242676d0, -0.680648785127646d0, 0.668356195590579d0, -1.15988961852528d0,&
        0.313492852637276d0, -0.323794328878954d0, 1.14091270934231d0, -0.894426479612224d0,&
        0.483266884672673d0, -0.16226934990287d0, 1.51842914115259d0, -0.494300814491471d0,&
        0.879913353819681d0, -1.55019904079176d0, 0.152355884338473d0, -1.89122923782011d0,&
        0.0735025059641587d0, -0.584931540146927d0, 0.769820715012041d0, -0.242240583770448d0,&
        1.30643035112756d0, -1.01817720560067d0, 0.396947399151455d0, -0.40756406632868d0,&
        1.00187027637698d0, -1.32977095018121d0, 0.232169649403845d0, -0.783056813674774d0,&
        0.573352197171953d0, -0.0833242105440363d0, 1.83567153691254d0, -0.730894247427629d0,&
        0.620154232595207d0, -0.0440760921002205d0, 2.10655408816281d0, -0.365358587538023d0,&
        1.0688078752592d0, -1.24035599423067d0, 0.2726058039057d0, -0.202093345575596d0,&
        1.40454624815887d0, -0.954474027767443d0, 0.43969744961512d0, -1.69622250500661d0,&
        0.112841457367714d0, -0.539062470681719d0, 0.823618695051533d0, -0.632066001577947d0,&
        0.718163873887231d0, -2.20657521653713d0, 0.0342770193514366d0, -1.0863057362981d0,&
        0.354911023290717d0, -0.282782265212403d0, 1.21949532284622d0, -1.43130175910248d0,&
        0.19210973438208d0, -0.450508606282178d0, 0.939145102896062d0, -0.122701154016606d0,&
        1.65632386534081d0, -0.837442740149245d0, 0.52777393514818d0, -1.28378055260817d0,&
        0.25233614780249d0, -0.3863752869032d0, 1.03475948108824d0, -0.0636878869241329d0,&
        1.95332370774539d0, -0.756718131051078d0, 0.596589849251445d0, -0.561849225726257d0,&
        0.796431543684233d0, -1.78526249043532d0, 0.0931539598455833d0, -0.985825500405061d0,&
        0.418226872548409d0, -0.222122208220557d0, 1.35385936407511d0, -0.303224538198166d0,&
        1.17929369001065d0, -1.12233801170217d0, 0.33413028225882d0, -2.52050221719036d0,&
        0.0146878031333598d0, -0.656163781150379d0, 0.693045098387663d0, -0.865583239756308d0,&
        0.505395256291619d0, -0.142457369611016d0, 1.58361547580179d0, -0.472291481268261d0,&
        0.909130489944847d0, -1.48812189602338d0, 0.172198788871808d0, -0.34450205612612d0,&
        1.10414267929223d0, -1.19915225099327d0, 0.292988096856233d0, -0.705548838662176d0,&
        0.644068138600693d0, -0.0244812369184941d0, 2.33523304006881d0, -1.61890014353736d0,&
        0.132572793629228d0, -0.516552258376321d0, 0.851428708305571d0, -0.182145235070168d0,&
        1.45912302502159d0, -0.924033738805388d0, 0.461372678278513d0, -1.05163128165734d0,&
        0.375846185216561d0, -0.262457496397155d0, 1.26177086163599d0, -0.608329815634632d0,&
        0.743744189746654d0, -2.02401362371916d0, 0.0538793990464063d0, -0.102992718520838d0,&
        1.7390199717299d0, -0.809950283969892d0, 0.550420122521827d0, -1.37876004322192d0,&
        0.212097141151849d0, -0.428937443704609d0, 0.970030579177241d0, -0.970030579177241d0,&
        0.428937443704609d0, -0.212097141151849d0, 1.37876004322192d0, -0.550420122521827d0,&
        0.809950283969892d0, -1.7390199717299d0, 0.102992718520838d0, -0.0538793990464063d0,&
        2.02401362371916d0, -0.743744189746654d0, 0.608329815634632d0, -1.26177086163599d0,&
        0.262457496397155d0, -0.375846185216561d0, 1.05163128165734d0, -0.461372678278513d0,&
        0.924033738805388d0, -1.45912302502159d0, 0.182145235070168d0, -0.851428708305571d0,&
        0.516552258376321d0, -0.132572793629228d0, 1.61890014353736d0, -2.33523304006881d0,&
        0.0244812369184941d0, -0.644068138600693d0, 0.705548838662176d0, -0.292988096856233d0,&
        1.19915225099327d0, -1.10414267929223d0, 0.34450205612612d0, -0.172198788871808d0,&
        1.48812189602338d0, -0.909130489944847d0, 0.472291481268261d0, -1.58361547580179d0,&
        0.142457369611016d0, -0.505395256291619d0, 0.865583239756308d0, -0.693045098387663d0,&
        0.656163781150379d0, -0.0146878031333598d0, 2.52050221719036d0, -0.33413028225882d0,&
        1.12233801170217d0, -1.17929369001065d0, 0.303224538198166d0, -1.35385936407511d0,&
        0.222122208220557d0, -0.418226872548409d0, 0.985825500405061d0, -0.0931539598455833d0,&
        1.78526249043532d0, -0.796431543684233d0, 0.561849225726257d0, -0.596589849251445d0,&
        0.756718131051078d0, -1.95332370774539d0, 0.0636878869241329d0, -1.03475948108824d0,&
        0.3863752869032d0, -0.25233614780249d0, 1.28378055260817d0, -0.52777393514818d0,&
        0.837442740149245d0, -1.65632386534081d0, 0.122701154016606d0, -0.939145102896062d0,&
        0.450508606282178d0, -0.19210973438208d0, 1.43130175910248d0, -1.21949532284622d0,&
        0.282782265212403d0, -0.354911023290717d0, 1.0863057362981d0, -0.0342770193514366d0,&
        2.20657521653713d0, -0.718163873887231d0, 0.632066001577947d0, -0.823618695051533d0,&
        0.539062470681719d0, -0.112841457367714d0, 1.69622250500661d0, -0.43969744961512d0,&
        0.954474027767443d0, -1.40454624815887d0, 0.202093345575596d0, -0.2726058039057d0,&
        1.24035599423067d0, -1.0688078752592d0, 0.365358587538023d0, -2.10655408816281d0,&
        0.0440760921002205d0, -0.620154232595207d0, 0.730894247427629d0, -1.83567153691254d0,&
        0.0833242105440363d0, -0.573352197171953d0, 0.783056813674774d0, -0.232169649403845d0,&
        1.32977095018121d0, -1.00187027637698d0, 0.40756406632868d0, -0.396947399151455d0,&
        1.01817720560067d0, -1.30643035112756d0, 0.242240583770448d0, -0.769820715012041d0,&
        0.584931540146927d0, -0.0735025059641587d0, 1.89122923782011d0, -0.152355884338473d0,&
        1.55019904079176d0, -0.879913353819681d0, 0.494300814491471d0, -1.51842914115259d0,&
        0.16226934990287d0, -0.483266884672673d0, 0.894426479612224d0, -1.14091270934231d0,&
        0.323794328878954d0, -0.313492852637276d0, 1.15988961852528d0, -0.668356195590579d0,&
        0.680648785127646d0, -2.88563491242676d0, 0.00489577790634245d0, -0.671419815495155d0,&
        0.677566054832191d0, -3.09726907819878d0, 0.00244788161911068d0, -1.14561829257781d0,&
        0.321215779435019d0, -0.316065061863936d0, 1.15510635777657d0, -1.52622786964839d0,&
        0.15978952613545d0, -0.486019803756523d0, 0.890780618191639d0, -0.154832809329535d0,&
        1.5421099601365d0, -0.883524178244099d0, 0.49153673764685d0, -0.773117027116272d0,&
        0.58202940428861d0, -0.075957230458921d0, 1.8767900479811d0, -0.399597327736265d0,&
        1.01407519104019d0, -1.31219862702896d0, 0.239720585848375d0, -0.234685136420896d0,&
        1.32386803759834d0, -1.00592193241354d0, 0.404905636576578d0, -1.84903246516889d0,&
        0.0808680677627817d0, -0.57623977333281d0, 0.779734996530243d0, -2.12961846911981d0,&
        0.0416259638712113d0, -0.623123869784967d0, 0.727700613034726d0, -0.275147232671631d0,&
        1.23509036459975d0, -1.07315154982209d0, 0.36274300002125d0, -0.442395375318794d0,&
        0.950620860870747d0, -1.41114072110521d0, 0.19959559262874d0, -0.827059875726257d0,&
        0.536233946622638d0, -0.115305315887256d0, 1.68599441546561d0, -0.0367264422438769d0,&
        2.17946859778912d0, -0.72133549234393d0, 0.629079707162832d0, -1.22466059983832d0,&
        0.280235444318555d0, -0.357519240337698d0, 1.08190020225002d0, -0.942956555614785d0,&
        0.44780092608518d0, -0.194603803788316d0, 1.42451697418177d0, -0.530589714123105d0,&
        0.833971800052114d0, -1.66605166238845d0, 0.120235148819768d0, -1.0389497113123d0,&
        0.383739038722914d0, -0.254864022115934d0, 1.27821997483642d0, -0.599517078154522d0,&
        0.753462770653122d0, -1.97008940475787d0, 0.0612352273424688d0, -0.09561276707409d0,&
        1.77334307781058d0, -0.7997975116462d0, 0.558985120627175d0, -1.36000568463741d0,&
        0.21961388722509d0, -0.420899972915016d0, 0.981853808166937d0, -0.336719814444443d0,&
        1.11775446278603d0, -1.18421459785573d0, 0.300662489533887d0, -0.696160813976152d0,&
        0.653130928015844d0, -0.0171359928260878d0, 2.4657708956965d0, -1.59225185952329d0,&
        0.139984958173739d0, -0.508178560348605d0, 0.862028426972385d0, -0.174683765351141d0,&
        1.4807549883929d0, -0.912837286072549d0, 0.469556548200866d0, -0.295544288601364d0,&
        1.19414340989772d0, -1.10865712398397d0, 0.341905679930527d0, -2.37438680605393d0,&
        0.0220326950308341d0, -0.647083157764331d0, 0.702412623695317d0, -0.854951270871459d0,&
        0.513757028359516d0, -0.135042685843707d0, 1.60988998841876d0, -0.464097175910881d0,&
        0.920288771883032d0, -1.46625758841323d0, 0.17965697210979d0, -1.26721583563447d0,&
        0.259924678065871d0, -0.378474511416355d0, 1.04738537323502d0, -0.0563309982498503d0,&
        2.0053852719249d0, -0.746975872532823d0, 0.605387017711062d0, -0.553270606780821d0,&
        0.806556793379432d0, -1.75023295183998d0, 0.100532131244173d0, -0.973956526882356d0,&
        0.426255232406073d0, -0.21460137091761d0, 1.37245488241084d0, -1.38512049830698d0,&
        0.209594240778642d0, -0.431622744449859d0, 0.966119525969419d0, -0.105453929524875d0,&
        1.72802147121901d0, -0.813353127508359d0, 0.547574103573779d0, -0.611277891191507d0,&
        0.740520255855527d0, -2.04337202094265d0, 0.0514281236341141d0, -1.05589623376374d0,&
        0.373220452841663d0, -0.264991999560325d0, 1.2563630414547d0, -0.184634626287249d0,&
        1.45206197024557d0, -0.927791710155385d0, 0.458651601070847d0, -1.62804367632253d0,&
        0.130103709894028d0, -0.519351530221023d0, 0.847916679096402d0, -0.708692008707423d0,&
        0.641058962903565d0, -0.0269299255889371d0, 2.29936229740323d0, -0.347100756751592d0,&
        1.09965062580976d0, -1.20419135908412d0, 0.290433818099894d0, -0.475029951585417d0,&
        0.905436143675761d0, -1.49557046317418d0, 0.169714875285445d0, -0.869149024454586d0,&
        0.502615861929802d0, -0.144930652172474d0, 1.57509561962568d0, -2.58401958059948d0,&
        0.0122397014708965d0, -0.659202681860284d0, 0.689936096184168d0, -0.305788578807489d0,&
        1.17440117463922d0, -1.12694526183216d0, 0.331542988709853d0, -0.989812804597863d0,&
        0.415556757275935d0, -0.224631927517902d0, 1.3477637672852d0, -0.564717947168687d0,&
        0.793074574990729d0, -1.79744107394942d0, 0.0906957156729311d0, -0.0661409296831973d0,&
        1.9370897365465d0, -0.759981530500801d0, 0.593667723429761d0, -1.2893811107918d0,&
        0.249809884929244d0, -0.389014223059009d0, 1.03058734087267d0, -0.125167905608435d0,&
        1.64675032766897d0, -0.840923798724339d0, 0.524962334487275d0, -1.43815307900302d0,&
        0.189616859401405d0, -0.453219593437879d0, 0.935347244701583d0, -1.09073245569302d0,&
        0.352305218402456d0, -0.285330921640916d0, 1.21436237874935d0, -0.635057943402778d0,&
        0.714999463162297d0, -2.23540724355632d0, 0.0318278020929306d0, -1.70663118536312d0,&
        0.110378283674032d0, -0.541895314131648d0, 0.820187239913321d0, -0.204592359975061d0,&
        1.39801229534686d0, -0.958341418018926d0, 0.437002720596656d0, -0.367976676977171d0,&
        1.06448427337982d0, -1.24565624149491d0, 0.270066134646447d0, -0.734095353894574d0,&
        0.617190054347694d0, -0.0465264849526418d0, 2.08455871840791d0, -0.786387293998826d0,&
        0.570469393786029d0, -0.0857808560936914d0, 1.82263048663553d0, -0.410225379567002d0,&
        0.997835000557589d0, -1.33572056504665d0, 0.229655630625748d0, -0.244762120956717d0,&
        1.3007052195221d0, -1.02229642449682d0, 0.394300255055697d0, -1.90607384923176d0,&
        0.0710482242921843d0, -0.587838610917144d0, 0.76653274638327d0, -0.497068673028721d0,&
        0.876313965464153d0, -1.55839084718429d0, 0.149879893723577d0, -0.898084268969658d0,&
        0.480517623198981d0, -0.16475017195312d0, 1.5107216853605d0, -1.16469956534333d0,&
        0.310922715893284d0, -0.326375033007281d0, 1.13623225407686d0, -0.00734370353043169d0,&
        2.75554887345342d0, -0.683737997401054d0, 0.665298835919928d0, -0.677566054832191d0,&
        0.671419815495155d0, -0.00244788161911068d0, 3.09726907819878d0, -0.321215779435019d0,&
        1.14561829257781d0, -1.15510635777657d0, 0.316065061863936d0, -0.15978952613545d0,&
        1.52622786964839d0, -0.890780618191639d0, 0.486019803756523d0, -1.5421099601365d0,&
        0.154832809329535d0, -0.49153673764685d0, 0.883524178244099d0, -0.58202940428861d0,&
        0.773117027116272d0, -1.8767900479811d0, 0.075957230458921d0, -1.01407519104019d0,&
        0.399597327736265d0, -0.239720585848375d0, 1.31219862702896d0, -1.32386803759834d0,&
        0.234685136420896d0, -0.404905636576578d0, 1.00592193241354d0, -0.0808680677627817d0,&
        1.84903246516889d0, -0.779734996530243d0, 0.57623977333281d0, -0.0416259638712113d0,&
        2.12961846911981d0, -0.727700613034726d0, 0.623123869784967d0, -1.23509036459975d0,&
        0.275147232671631d0, -0.36274300002125d0, 1.07315154982209d0, -0.950620860870747d0,&
        0.442395375318794d0, -0.19959559262874d0, 1.41114072110521d0, -0.536233946622638d0,&
        0.827059875726257d0, -1.68599441546561d0, 0.115305315887256d0, -2.17946859778912d0,&
        0.0367264422438769d0, -0.629079707162832d0, 0.72133549234393d0, -0.280235444318555d0,&
        1.22466059983832d0, -1.08190020225002d0, 0.357519240337698d0, -0.44780092608518d0,&
        0.942956555614785d0, -1.42451697418177d0, 0.194603803788316d0, -0.833971800052114d0,&
        0.530589714123105d0, -0.120235148819768d0, 1.66605166238845d0, -0.383739038722914d0,&
        1.0389497113123d0, -1.27821997483642d0, 0.254864022115934d0, -0.753462770653122d0,&
        0.599517078154522d0, -0.0612352273424688d0, 1.97008940475787d0, -1.77334307781058d0,&
        0.09561276707409d0, -0.558985120627175d0, 0.7997975116462d0, -0.21961388722509d0,&
        1.36000568463741d0, -0.981853808166937d0, 0.420899972915016d0, -1.11775446278603d0,&
        0.336719814444443d0, -0.300662489533887d0, 1.18421459785573d0, -0.653130928015844d0,&
        0.696160813976152d0, -2.4657708956965d0, 0.0171359928260878d0, -0.139984958173739d0,&
        1.59225185952329d0, -0.862028426972385d0, 0.508178560348605d0, -1.4807549883929d0,&
        0.174683765351141d0, -0.469556548200866d0, 0.912837286072549d0, -1.19414340989772d0,&
        0.295544288601364d0, -0.341905679930527d0, 1.10865712398397d0, -0.0220326950308341d0,&
        2.37438680605393d0, -0.702412623695317d0, 0.647083157764331d0, -0.513757028359516d0,&
        0.854951270871459d0, -1.60988998841876d0, 0.135042685843707d0, -0.920288771883032d0,&
        0.464097175910881d0, -0.17965697210979d0, 1.46625758841323d0, -0.259924678065871d0,&
        1.26721583563447d0, -1.04738537323502d0, 0.378474511416355d0, -2.0053852719249d0,&
        0.0563309982498503d0, -0.605387017711062d0, 0.746975872532823d0, -0.806556793379432d0,&
        0.553270606780821d0, -0.100532131244173d0, 1.75023295183998d0, -0.426255232406073d0,&
        0.973956526882356d0, -1.37245488241084d0, 0.21460137091761d0, -0.209594240778642d0,&
        1.38512049830698d0, -0.966119525969419d0, 0.431622744449859d0, -1.72802147121901d0,&
        0.105453929524875d0, -0.547574103573779d0, 0.813353127508359d0, -0.740520255855527d0,&
        0.611277891191507d0, -0.0514281236341141d0, 2.04337202094265d0, -0.373220452841663d0,&
        1.05589623376374d0, -1.2563630414547d0, 0.264991999560325d0, -1.45206197024557d0,&
        0.184634626287249d0, -0.458651601070847d0, 0.927791710155385d0, -0.130103709894028d0,&
        1.62804367632253d0, -0.847916679096402d0, 0.519351530221023d0, -0.641058962903565d0,&
        0.708692008707423d0, -2.29936229740323d0, 0.0269299255889371d0, -1.09965062580976d0,&
        0.347100756751592d0, -0.290433818099894d0, 1.20419135908412d0, -0.905436143675761d0,&
        0.475029951585417d0, -0.169714875285445d0, 1.49557046317418d0, -0.502615861929802d0,&
        0.869149024454586d0, -1.57509561962568d0, 0.144930652172474d0, -0.0122397014708965d0,&
        2.58401958059948d0, -0.689936096184168d0, 0.659202681860284d0, -1.17440117463922d0,&
        0.305788578807489d0, -0.331542988709853d0, 1.12694526183216d0, -0.415556757275935d0,&
        0.989812804597863d0, -1.3477637672852d0, 0.224631927517902d0, -0.793074574990729d0,&
        0.564717947168687d0, -0.0906957156729311d0, 1.79744107394942d0, -1.9370897365465d0,&
        0.0661409296831973d0, -0.593667723429761d0, 0.759981530500801d0, -0.249809884929244d0,&
        1.2893811107918d0, -1.03058734087267d0, 0.389014223059009d0, -1.64675032766897d0,&
        0.125167905608435d0, -0.524962334487275d0, 0.840923798724339d0, -0.189616859401405d0,&
        1.43815307900302d0, -0.935347244701583d0, 0.453219593437879d0, -0.352305218402456d0,&
        1.09073245569302d0, -1.21436237874935d0, 0.285330921640916d0, -0.714999463162297d0,&
        0.635057943402778d0, -0.0318278020929306d0, 2.23540724355632d0, -0.110378283674032d0,&
        1.70663118536312d0, -0.820187239913321d0, 0.541895314131648d0, -1.39801229534686d0,&
        0.204592359975061d0, -0.437002720596656d0, 0.958341418018926d0, -1.06448427337982d0,&
        0.367976676977171d0, -0.270066134646447d0, 1.24565624149491d0, -0.617190054347694d0,&
        0.734095353894574d0, -2.08455871840791d0, 0.0465264849526418d0, -0.570469393786029d0,&
        0.786387293998826d0, -1.82263048663553d0, 0.0857808560936914d0, -0.997835000557589d0,&
        0.410225379567002d0, -0.229655630625748d0, 1.33572056504665d0, -1.3007052195221d0/
        
        
        data QMC100_1 /0.0d0, 0.674489750196082d0, -0.674489750196082d0, -0.318639363964375d0,&
        1.15034938037601d0, 0.318639363964375d0, -1.15034938037601d0, -0.887146559018876d0,&
        0.488776411114669d0, 1.53412054435255d0, -0.157310684610171d0, -0.488776411114669d0,&
        0.887146559018876d0, 0.157310684610171d0, -1.53412054435255d0, -1.31801089730354d0,&
        0.237202109328788d0, 1.00999016924958d0, -0.402250065321725d0, -0.0784124127331122d0,&
        1.86273186742165d0, 0.579132162255556d0, -0.776421761147928d0, -1.00999016924958d0,&
        0.402250065321725d0, 1.31801089730354d0, -0.237202109328788d0, -0.579132162255556d0,&
        0.776421761147928d0, 0.0784124127331122d0, -1.86273186742165d0, -1.67593972277344d0,&
        0.117769874579095d0, 0.830510878205399d0, -0.53340970624128d0, -0.197099084294312d0,&
        1.41779713799627d0, 0.445096524985516d0, -0.946781756301046d0, -0.724514383492365d0,&
        0.626099012346421d0, 2.15387469406146d0, -0.0391760855030976d0, -0.360129891789569d0,&
        1.07751556704028d0, 0.277690439821577d0, -1.22985875921659d0, -1.41779713799627d0,&
        0.197099084294312d0, 0.946781756301046d0, -0.445096524985516d0, -0.117769874579095d0,&
        1.67593972277344d0, 0.53340970624128d0, -0.830510878205399d0, -1.07751556704028d0,&
        0.360129891789569d0, 1.22985875921659d0, -0.277690439821577d0, -0.626099012346421d0,&
        0.724514383492365d0, 0.0391760855030976d0, -2.15387469406146d0, -1.9874278859299d0,&
        0.0587829360689431d0, 0.75021537546794d0, -0.602449453164424d0, -0.257393526100938d0,&
        1.27269864119054d0, 0.381105454763556d0, -1.04315826331845d0, -0.803172565597918d0,&
        0.556125593618691d0, 1.76167041036307d0, -0.0980721524886611d0, -0.4235760842012d0,&
        0.977897543940542d0, 0.21710694721013d0, -1.3662038163721d0, -1.18916435019934d0,&
        0.298102412930487d0, 1.11319427716093d0, -0.339311606538817d0, -0.0195842852301269d0,&
        2.4175590162365d0, 0.650104070647995d0, -0.69928330238322d0, -0.916556667533112d0,&
        0.46682512285259d0, 1.4734675779471d0, -0.17716982099174d0, -0.510965806738247d0,&
        0.858484474141832d0, 0.137513402144336d0, -1.60100866488608d0, -1.76167041036307d0,&
        0.0980721524886611d0, 0.803172565597918d0, -0.556125593618691d0, -0.21710694721013d0/


        data QMC100_2 /0.0d0, -0.674489750196082d0, 0.674489750196082d0, -0.318639363964375d0,&
        1.15034938037601d0, -1.15034938037601d0, 0.318639363964375d0, -0.488776411114669d0,&
        0.887146559018876d0, -1.53412054435255d0, 0.157310684610171d0, -0.887146559018876d0,&
        0.488776411114669d0, -0.157310684610171d0, 1.53412054435255d0, -0.0784124127331122d0,&
        1.86273186742165d0, -0.776421761147928d0, 0.579132162255556d0, -1.31801089730354d0,&
        0.237202109328788d0, -0.402250065321725d0, 1.00999016924958d0, -1.00999016924958d0,&
        0.402250065321725d0, -0.237202109328788d0, 1.31801089730354d0, -0.579132162255556d0,&
        0.776421761147928d0, -1.86273186742165d0, 0.0784124127331122d0, -0.626099012346421d0,&
        0.724514383492365d0, -2.15387469406146d0, 0.0391760855030976d0, -1.07751556704028d0,&
        0.360129891789569d0, -0.277690439821577d0, 1.22985875921659d0, -1.41779713799627d0,&
        0.197099084294312d0, -0.445096524985516d0, 0.946781756301046d0, -0.117769874579095d0,&
        1.67593972277344d0, -0.830510878205399d0, 0.53340970624128d0, -0.724514383492365d0,&
        0.626099012346421d0, -0.0391760855030976d0, 2.15387469406146d0, -0.360129891789569d0,&
        1.07751556704028d0, -1.22985875921659d0, 0.277690439821577d0, -0.197099084294312d0,&
        1.41779713799627d0, -0.946781756301046d0, 0.445096524985516d0, -1.67593972277344d0,&
        0.117769874579095d0, -0.53340970624128d0, 0.830510878205399d0, -0.257393526100938d0,&
        1.27269864119054d0, -1.04315826331845d0, 0.381105454763556d0, -1.9874278859299d0,&
        0.0587829360689431d0, -0.602449453164424d0, 0.75021537546794d0, -0.803172565597918d0,&
        0.556125593618691d0, -0.0980721524886611d0, 1.76167041036307d0, -0.4235760842012d0,&
        0.977897543940542d0, -1.3662038163721d0, 0.21710694721013d0, -1.18916435019934d0,&
        0.298102412930487d0, -0.339311606538817d0, 1.11319427716093d0, -0.0195842852301269d0,&
        2.4175590162365d0, -0.69928330238322d0, 0.650104070647995d0, -0.510965806738247d0,&
        0.858484474141832d0, -1.60100866488608d0, 0.137513402144336d0, -0.916556667533112d0,&
        0.46682512285259d0, -0.17716982099174d0, 1.4734675779471d0, -1.11319427716093d0,&
        0.339311606538817d0, -0.298102412930487d0, 1.18916435019934d0, -0.650104070647995d0/
        

    end module donnees
!=======================================================================================
!=======================================================================================
!                                FIN marq98 version optim
!=======================================================================================
!=======================================================================================

