% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{kidney}
\alias{kidney}
\title{Kidney Marker Data}
\format{
{This is a data frame with 76 observations and the following 4 variables.
   \describe{
   \item{id  }{patient code}

   \item{time }{time to recurrence of infection}

   \item{status }{censoring indicator; 0=censored, 1=recurrence}

   \item{marker }{risk score derived from observed data using frailty model}
   }
  }
}
\usage{
data(kidney)
}
\description{
This dataset contains four columns: \code{id}, patient code; \code{marker}, the risk score; \code{time}, the observed follow-up time; and \code{status}, the event indicator for subjects in the kidney marker dataset.
}
\details{
{
   \describe{
This dataset pertains to the recurrence of infection in patients with kidney disease who use portable dialysis equipment.
Recurrent infection is the primary complication in these patients, typically occurring at the catheter insertion site.
When an infection occurs, the catheter is removed and reinserted after successful treatment. In some cases, the catheter
is removed for reasons unrelated to infection; these observations are treated as censored. A total of 38 patients were
followed to assess the time to recurrence of infection. Each patient contributes exactly two observations.

The dataset includes the following covariates: \code{sex} (1 = Male, 2 = Female), \code{age}, and \code{disease}
(Disease type; a factor with four levels: \code{"GN"}, \code{"AN"}, \code{"PKD"}, and \code{"Other"}). The marker is derived using a gamma frailty model as follows:
\deqn{
  \hat{\nu} \exp(\hat{\beta}_1 \, \mathrm{sex} + \hat{\beta}_2 \, \mathrm{age} + \hat{\beta}_3 \, \mathrm{GN} + \hat{\beta}_4 \, \mathrm{AN} + \hat{\beta}_5 \, \mathrm{PKD})
}
 where \eqn{\hat{\nu}} is the estimated frailty term, and \eqn{\hat{\beta}_i}(for \code{i=}1,2,3) are
 the estimated regression coefficients from the frailty model.}
}
}
\references{
Beyene, K. M., and Chen, D. G. (2024). Time-dependent receiver operating characteristic curve estimator for correlated right-censored time-to-event data. \emph{Statistical Methods in Medical Research}, 33(1), 162-181.
}
\keyword{datasets}
