% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tree.R
\name{plot_tree}
\alias{plot_tree}
\title{Visualize a fractal tree}
\usage{
plot_tree(
  tree_df,
  d_col = NULL,
  branch_color = "black",
  leaf_color = "black",
  simplify = FALSE,
  dTolerance = 0.15
)
}
\arguments{
\item{tree_df}{A data frame resulting from the \code{build_tree} function, containing the tree's geometry and attributes.}

\item{d_col}{Name of the column that contains the diameters along the branches. Usually 'diameter'. Default is NULL (diameters are not used).}

\item{branch_color}{A character string specifying the color of the tree branches. Default is 'black'.}

\item{leaf_color}{A character string specifying the color of the tree leaves. Default is 'black'.}

\item{simplify}{A logical value. If \code{TRUE}, simplifies the geometries of the tree branches using a given tolerance. Default is \code{FALSE}.}

\item{dTolerance}{A numeric value specifying the tolerance parameter used when simplifying geometries, applicable if \code{simplify = TRUE}. Default is \code{0.15}.}
}
\value{
A ggplot object representing the tree profile.
}
\description{
This function generates a visualization of a fractal tree based on the geometry and attributes from the \code{build_tree} function.
The tree is plotted with branches and leaves. The user can customize the appearance using various parameters.
}
