% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fr-package.R
\docType{package}
\name{fr-package}
\alias{fr}
\alias{fr-package}
\title{About the fr package}
\description{
\code{fr} provides functions and objects to reproducibly create and track changes to metadata alongside code that creates
the data. This prevents a disconnect between data and metadata, but also allows for computing on the metadata
to create richer documentation.
The \code{fr} package provides \code{fr_tdr}, \code{fr_schema}, and \code{fr_field} objects to provide a representation of the
\href{https://frictionlessdata.io/}{Frictionless}
\href{https://specs.frictionlessdata.io/tabular-data-resource/}{Tabular Data Resource} standards in R.

A \code{fr_tdr}, or frictionless tabular data resource, object encapsulates data and metadata by building on top
of the data.frame and has a list of data resource-specific metadata properties (e.g., \code{name}, \code{description}).
one of which is a \code{fr_schema} (Frictionless Schema) object. One of these is a \code{fr_schema} object, which is a list of table-specific metadata properties. One of these is a list of \code{fr_field} objects, which is a list #' field- (or column-) specific metadata properties (e.g., \code{name}, \code{type}, \code{constraints})

Normal usage will only require using \code{as_fr_tdr()} to create a \code{fr_tdr} object based on a data.frame or tibble.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/cole-brokamp/fr}
  \item \url{https://cole-brokamp.github.io/fr/}
  \item Report bugs at \url{https://github.com/cole-brokamp/fr/issues}
}

}
\author{
\strong{Maintainer}: Cole Brokamp \email{cole@colebrokamp.com} (\href{https://orcid.org/0000-0002-0289-3151}{ORCID}) [copyright holder]

Other contributors:
\itemize{
  \item Tomasz Kalinowski [contributor]
}

}
\keyword{internal}
