% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transect_subplot_inventories.R
\name{transect_subplot_inventories}
\alias{transect_subplot_inventories}
\title{Extract quadrat/subplot-level inventories from a transect assessment}
\usage{
transect_subplot_inventories(transect)
}
\arguments{
\item{transect}{A data set downloaded from
\href{https://universalfqa.org/}{universalfqa.org} either manually or using
\code{\link[=download_transect]{download_transect()}}.}
}
\value{
A list of data frames, each with 9 columns:
\itemize{
   \item scientific_name (character)
   \item family (character)
   \item acronym (character)
   \item nativity (character)
   \item c (numeric)
   \item w (numeric)
   \item physiognomy (character)
   \item duration (character)
   \item common_name (character)
   }
}
\description{
\code{transect_subplot_inventories()} accepts a floristic quality transect
assessment data set obtained from
\href{https://universalfqa.org/}{universalfqa.org} and returns a list of
species inventories, one per quadrat/subplot.
}
\examples{
\donttest{
cbg_fen <- download_transect(5932)
cbg_inventories <- transect_subplot_inventories(cbg_fen)
}

}
