% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{plot.esttable}
\alias{plot.esttable}
\title{Plotting Estimation Results}
\usage{
\method{plot}{esttable}(x, yvar = "error", ncol = 5, yscale.free = TRUE, ...)
}
\arguments{
\item{x}{object of class \code{"list" "esttable"} created by the \code{\link{estTable}} function.}

\item{yvar}{if set to \code{"error"} (default), the estimation error is plotted on the y-axis. If set to \code{"estimate"},
point estimates with their confidence intervals are plotted.}

\item{ncol}{number of columns to plot small area estimations.}

\item{yscale.free}{\code{logical}: should y-axis scales be free (default) or fixed.}

\item{...}{ignored.}
}
\description{
Function plots the estimation results of an object created by the \code{\link{estTable}} function.
Provides the possibility to visualize and compare the point estimates and their estimation errors
differentiated by the applied estimation method and estimator.
}
\examples{

## run onephase estimation:
op.a <- onephase(formula = tvol~1,
                 data = grisons,
                 phase_id = list(phase.col = "phase_id_2p", terrgrid.id = 2),
                 area = list(sa.col = "smallarea", areas = c("A", "B", "C", "D")))

## run small area twophase estimation:
sae.2p.est <- twophase(formula = tvol ~ mean + stddev + max + q75,
                       data = grisons,
                       phase_id = list(phase.col = "phase_id_2p", terrgrid.id = 2),
                       small_area = list(sa.col = "smallarea", areas = c("A", "B","C", "D"),
                                         unbiased = TRUE))

## run small area threephase estimation:
sae.3p.est <- threephase(formula.s0 =  tvol ~ mean,
                         formula.s1 = tvol ~ mean + stddev + max + q75,
                         data = grisons,
                         phase_id = list(phase.col = "phase_id_3p", s1.id = 1, terrgrid.id = 2),
                         small_area=list(sa.col = "smallarea", areas = c("A", "B", "C", "D"),
                                         unbiased = TRUE))

## create estimation table:
sae.table<- estTable(est.list = list(op.a, sae.2p.est, sae.3p.est), add.ci=TRUE,
                     sae = TRUE, vartypes = c("variance", "g_variance",  "ext_variance"))

## plot estimation errors:
plot(sae.table)

## plot point estimates and confidence intervals:
#  Hint: --> use ggplot2 functions to modify graphic:
library(ggplot2)
plot(sae.table, yvar = "estimate") +
   ylab("Timber Volume [m3/ha]")
}
