% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading.R
\name{load_single}
\alias{load_single}
\title{Load single measurement}
\usage{
load_single(filename, columns = c(1:2))
}
\arguments{
\item{filename}{Character string containing the path to measurement file.}

\item{columns}{A vector of column numbers. The first entry will be used as the x-axis values, the second entry as y-axis values.
All other columns will be ignored. Default: \code{c(1,2)}.}
}
\value{
A tibble with two columns named "t" and "y".
}
\description{
Loads a single measurement.
}
\details{
#' The input files need to be in the following format (even though column names do not matter):\tabular{ccc}{
   \strong{\code{t}} \tab  \tab \strong{\code{y}} \cr
   \code{t.1} \tab  \tab \code{y.1} \cr
   \code{...} \tab  \tab \code{...} \cr
   \code{t.n} \tab  \tab \code{y.n} \cr
}


All columns except the first two are removed.
}
\examples{
# Store filename
filename <- forceR_example(type="raw")

df.1 <- load_single(filename,
                    columns = c(1:2))

}
