% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peak_finding.R
\name{find_strongest_peaks}
\alias{find_strongest_peaks}
\title{Find Peaks}
\usage{
find_strongest_peaks(
  df,
  no.of.peaks = 5,
  initial.threshold = 0.05,
  slope.length.start = 5,
  slope.length.end = 5,
  slope.thresh.start = 0.02,
  slope.thresh.end = 0.02,
  path.data = NULL,
  path.plots = NULL,
  show.progress = FALSE
)
}
\arguments{
\item{df}{A data frame or tibble in the below format. The columns \code{t} (= time), \code{force} and \code{measurement}
(= measurement ID) must be present.}

\item{no.of.peaks}{A numeric value defining how many peaks per \code{species} (not per \code{measurement}") should be identified. The function will always return
the strongest peaks. Default: \code{5}}

\item{initial.threshold}{A numeric value defining the threshold (in \% of the maximum force of the measurement)
that is used during the first iteration. Default: \code{0.05}}

\item{slope.length.start}{A numeric value defining the window size (in time steps) of
slope calculation for peak starts during the second iteration. Default: \code{5}}

\item{slope.length.end}{A numeric value defining the window size (in time steps) of
slope calculation for peak ends during the second iteration. Default: \code{5}}

\item{slope.thresh.start}{A numeric value defining the threshold at which to stop the sliding window and save the
current time point as the actual start of the current peak. Default: \code{0.04}}

\item{slope.thresh.end}{A numeric value defining the threshold at which to stop the sliding window and save the
current time point as the actual end of the current peak. Default: \code{0.04}}

\item{path.data}{A string character defining where to save the results. If \code{NULL} (default),
data is not stored in a file. Default: \code{NULL}.}

\item{path.plots}{A string character defining where to save the plots. Default: \code{NULL}.}

\item{show.progress}{A logical value indicating if progress should be
printed to the console. Default: \code{FALSE}.}
}
\value{
Creates a tibble in the following format and saves it as a CSV-file:
The column \strong{\code{species}} contains one species per row\cr (\verb{species.1 ... species.n}).

The column \strong{\code{measurements}} contains as many measurements as \code{no.of.peaks}, separated by '\verb{;}':\cr (\verb{measurement.1; ...; measurements.no.of.peaks}).

The column \strong{\code{starts}} contains as many peak starts as \code{no.of.peaks}, separated by '\verb{;}':\cr (\verb{start.1; ...; start.no.of.peaks}).

The column \strong{\code{ends}} contains as many peak ends as \code{no.of.peaks}, separated by '\verb{;}':\cr (\verb{end.1; ...; end.no.of.peaks}).
}
\description{
Identifies peaks in a first iteration and optimizes the starts and ends of the strongest peaks per species in a second iteration.
}
\details{
The input data frame \code{df} needs to contain the following columns:\tabular{ccc}{
   \strong{\code{t}} \tab \strong{\code{force}} \tab \strong{\code{measurement}} \cr
   \code{t.1} \tab \code{force.1} \tab \code{measurement.1} \cr
   \code{...} \tab \code{...} \tab \code{...} \cr
   \code{t.n} \tab \code{force.n} \tab \code{measurement.m} \cr
}
}
\examples{
require(dplyr)
# Using the forceR::df.all.200.tax dataset:

# reduce dataset (only rows 40 to 95 of species A (containing data of
  # measurement 1 and 2 (m_01 and m_02)))
df.all.200.tax_filtered <- forceR::df.all.200.tax[40:95, ] \%>\%
  filter(species == "species_A")

# find the 4 strongest peaks
peaks.df <- find_strongest_peaks(df = df.all.200.tax_filtered,
                                 no.of.peaks = 4)

# plot results (three peaks in measurement 1, 1 peak in measurement 2):
# plot_peaks(df.peaks = peaks.df,
#            df.data = df.all.200.tax_filtered,
#            additional.msecs = 20)

}
