% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pricing.R
\name{fmpc_price_intraday}
\alias{fmpc_price_intraday}
\title{Historical End of Day pricing data for one or more symbols}
\usage{
fmpc_price_intraday(
  symbols = "AAPL",
  startDate = Sys.Date() - 30,
  endDate = Sys.Date(),
  freq = c("1min", "5min", "15min", "30min", "1hour")
)
}
\arguments{
\item{symbols}{one or more symbols from the FMP available list that can be
found using \code{\link{fmpc_symbols_by_market}}. A valid API token must be
set in order to enable functionality. See documentation for setting a token
under \code{\link{fmpc_set_token}}.}

\item{startDate}{filter start date in yyyy-mm-dd format.}

\item{endDate}{filter end date in yyyy-mm-dd format.}

\item{freq}{the frequency of which to pull intraday prices. Options can be
'1min','5min','15min','30min','1hour'}
}
\value{
a data frame of intraday prices
}
\description{
Intraday includes open, high, low, close, for each time segment. The amount
of history available is based on the freq set. Smaller time intervals
frequency will pull back less history. Symbol can include equity, mutual
fund, index, currency, crypto, or any other symbol that can be found in
\code{\link{fmpc_symbols_by_market}}. Available history is limited by the
increment size.
}
\section{Warning}{
 Each symbol is a separate API call. If the API token has
monthly limits, this should be considered before making a bulk request
}

\examples{


\dontrun{

# Setting API key to 'demo' allows for AAPL only
fmpc_set_token()
# Freq of1hour will return about 2 months of data
fmpc_price_intraday('AAPL', freq = '5min')

# For multiple symbols, set a valid API Token
fmpc_set_token('FMPAPIKEY')
fmpc_price_intraday(symbols = c('AAPL','MSFT','SPY','^SP500TR','JPYUSD','BTCUSD'),
                   startDate = '2020-01-01', freq = '1hour')

}
}
