% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdop.R
\name{rdop}
\alias{rdop}
\title{Relative Density-based Outlier Probabilities Function}
\usage{
rdop(data, k = 0, lambda = 3, extended = FALSE, alpha = 0.2, beta = 0.25)
}
\arguments{
\item{data}{a (rectangular, multivariate, n by m) data matrix or a (n by n ) distance matrix,
in either case, the function continues with a full distance matrix}

\item{k}{number of neighbors (default: sqrt( 2n ))}

\item{lambda}{multiple of standard distance deviations to get probabilistic distances}

\item{extended}{extended relative density-based probabilities}

\item{alpha}{steepness parameter turning scores into weights}

\item{beta}{halfway parameter turning scores into weights}
}
\value{
if ( extended == FALSE ): outlier scores; else: weights matrix
}
\description{
\code{rdop} returns the relative density-based outlier probabilities according to Barroso and Busing (2025).
}
\references{
Barroso and Busing (2025).
}
\author{
Frank M.T.A. Busing
}
