% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{weight_vector}
\alias{weight_vector}
\title{Generate Weight Vector from Flows}
\usage{
weight_vector(dist_mat, x, weight_col = "count")
}
\arguments{
\item{dist_mat}{distance matrix}

\item{x}{flows tibble with flow_ID and weight_col}

\item{weight_col}{column to use as weights (default = "count")}
}
\value{
numeric weight vector. Each element corresponds to a flow in the distance matrix,
and is used as a weight in the DBSCAN clustering algorithm.
}
\description{
Generate Weight Vector from Flows
}
\examples{
flows <- sf::st_transform(flows_leeds, 3857)
flows <- head(flows, 100) # for testing
# Add flow lengths and coordinates
flows <- add_flow_length(flows)
flows <- add_xyuv(flows)
# Calculate distances
distances <- flow_distance(flows, alpha = 1.5, beta = 0.5)
dmat <- distance_matrix(distances)
wvec <- weight_vector(dmat, flows, weight_col = "count")
}
